/*
 *  Vocab.H - vocabulary #defines for Collosal Cave Adventure
 *  (C) 1988 Ravi Bhavnani
 *  All rights reserved
 *
 *	Objects (defined in Objects.h)
 *	  all         0
 *	  treasures   1 - 26
 *	  mortals     50 - 66
 *	  sundries    80 - 132
 *
 *	Verbs
 *	  actions         150 - 185
 *	  directionals    200 - 236
 *	  psuedo-places   250 - 271
 *	  utility         280 - 295
 *	  magic           300 - 320
 */

#ifndef _Vocab_h_
#define _Vocab_h_

#define errword         (-2)
#define null            (-1)

// Action verbs

#define MINVERB		150
#define MINACTION	150

#define jump		150
#define climb		151
#define look		152
#define obtain		153
#define drop		154
#define unlock		155
#define lock		156
#define on		157
#define off		158
#define wave		159
#define placate		160
#define silly		161
#define kill		162
#define pour		163
#define eat		164
#define drink		165
#define rub		166
#define throw_it		167
#define feed		168
#define fill		169
#define peruse		170
#define breakit		171
#define ride		172
#define dig		173
#define lost		174
#define scream		175
#define mist		176
#define swim		177
#define lpsd		178
#define fix		179
#define wizard		180
#define blast		181
#define move		182
#define fuck		183
#define obscenity	184
#define push		185

#define MAXACTION	185

/* DIRECTIONAL VERBS */

#define MINDIR		200

#define upstream	200
#define downstream	201
#define front		202
#define back		203
#define out		204
#define entrance	205
#define gully		206
#define stream		207
#define rock		208
#define bed		209
#define crawl		210
#define inside		211
#define _building	212
#define surface		213
#define passage		214
#define view		215
#define hole		216
#define stairs		217
#define up		218
#define down		219
#define outdoors	220
#define crack		221
#define dome		222
#define left		223
#define right		224
#define hall		225
#define cross		226
#define east		227
#define west		228
#define north		229
#define south		230
#define ne		231
#define se		232
#define sw		233
#define nw		234
#define cave		235
#define secret		236

#define MAXDIR		236

// Psuedo places

#define MINPLACE	250

#define _road		250
#define _depression	251
#define _valley		252
#define _forest		253
#define _slit		254
#define _cobbles	255
#define _pit		256
#define _debris		257
#define _y2		258
#define _reservoir	259
#define _plover		260
#define _balcony	261
#define _fork		262
#define _view		263
#define _barren		264
#define _lair		265
#define _oriental	266
#define _slab		267
#define _shell		268
#define _bedquilt	269
#define _low		270
#define _ledge		271

#define MAXPLACE	271

// Utility verbs

#define MINUTIL		280

#define say		280
#define save		281
#define restore		282
#define qquit		283
#define find		284
#define inventory	285
#define score		286
#define brief		287
#define hours		288
#define timenow		289
#define help		290
#define info		291
#define fast		292
#define full		293
#define news		294
#define hint		295

#define MAXUTIL		295

// Magic verbs

#define MINMAGIC	300

#define fum		300
#define sesame		301
#define zorton		302
#define xyzzy		303
#define thurb		304
#define snoeze		305
#define samoht		306
#define plugh		307
#define phuggg		308
#define noside		309
#define melenkurion	310
#define knerl		311
#define klaetu		312
#define foo		313
#define foe		314
#define fie		315
#define fee		316
#define blerbi		317
#define oldmagic        318
#define vamotu		319
#define utomav		320

#define MAXMAGIC	320

#define MAXVERB		320

#define MAXVOCAB    400   // size of vocabulary

#endif
