class almTopic: thing
	verIoConsultOn(actor) = {}
	verDoResearchIn(actor) = {
		self.verIoConsultOn(actor);
	}
	ioConsultOn(actor, dobj) = {
		"You find an entry labeled \"<<self.title>>\":\n";
		self.entry;
		dobj.lasttopic = self;
	}
	sdesc = self.title
	title = "Notes"
	entry = "There do seem to be some notes on that topic, but various
		unidentifiable food stains have rendered them illegible."
;

almanac: readable, almTopic
	sdesc = {
		if (isseen) {
			"Zefron's almanac";
		} else {
			"dusty old tome";
		}
	}
	adesc = {if (!isseen) "a "; sdesc;}
	thedesc = {if (!isseen) "the "; sdesc;}
	ldesc = {
		"This large dusty book is master Zefron's almanac.  It has no index
		or table of contents, but if you
		\(CONSULT THE ALMANAC\) on a topic, it magically opens to an
		appropriate page (if one exists).  You can also \(BROWSE THE ALMANAC\)
		in hopes of randomly discovering something useful.  Or you
		can simply \(READ THE CURRENT PAGE\), entitled \"<< lasttopic.title >>.\"";
		if (!isseen) {isseen = true;}
	}
	noun = 'almanac' 'book' 'tome' 'page'
	adjective = 'ancient' 'immense' 'Zefron\'s' 'dusty' 'current'
	location = workbench
	weight = 3
	bulk = 3

	verDoConsultOn(actor, iobj) = {}
	verIoResearchIn(actor, dobj) = {self.verDoConsultOn(actor, dobj);}
	ioResearchIn(actor, dobj) = {dobj.ioConsultOn(actor, self);}
	verDoAskAbout(actor, iobj) = {
		"Try \(CONSULT ALMANAC ON <topic>\) instead.";
	}

	lasttopic = cluple
	readdesc = {
		"The almanac is open to an entry marked \"<< lasttopic.title >>\":\n";
		self.lasttopic.entry;
	}
	verDoBrowse(actor) = {}
	doBrowse(actor) = {
		local t;

		t = global.almTopicList[rand(length(global.almTopicList))];
		"Randomly shuffling through pages, you come across an entry titled
		\"<< t.title >>\":\n";
		t.entry;
		self.lasttopic = t;
	}

	title = "My Almanac"
	entry = {
		"\"This is the Almanac of Zefron.  It preserves my knowledge for the
		future.  If found, please return to Zefron, Royal Wizard of Duke Oswale of
		Fimpoz, castle of Fimpoz, Royal Duchy of Fimpoz, XJ945378-3.\"";
		if (almanac.isVisible(fly)) {
			"\bThe fly crawls across the word \"Zefron\" in the almanac.";
		}
	}
;

bedbug: almTopic
	noun = 'bedbug' 'parasite'
	plural = 'parasites' 'bedbugs'
	title = "Parasites"
	entry = "\"A good way to keep parasites, such as bedbugs, out of your sleeping
		mat is to hang it in the garderobe.  The ammonia smell drives the parasites
		away.  Of course, it also keeps just about anyone else out of your sleeping
		mat as well.\""
;
		
cluple: almTopic
	noun = 'cluple'
	title = "Cluple"
	entry = {
		"\"The cluple spell changes the form of the wizard into that of
		another nearby creature.  For example, to turn into a
		bedbug, the wizard should stand in close proximity to a bedbug
		and say \(CLUPLE BEDBUG\).\n
		Safety tips: \n\t1) Be careful what you are wearing or carrying when
		casting this spell.  Avoid heavy articles when turning into a
		small creature, or constricting articles when turning into a
		large one.  \n\t2) Repeated or prolonged use of this spell may result
		in mental abberrations as a result of exposure to unusual sensory
		input.  \n\t3) Instinctual behavior of the shaped creature may affect
		the wizard's judgment.\n
		Obviously this spell should be used with the utmost caution.\"";
		if (almanac.isVisible(fly)) {
			"\bThe fly crawls across the word \"cluple\" in the almanac.";
		}
	}
;

divine: almTopic
	noun = 'divine' 'creation'
	title = "The Divine and the Creation"
	entry = {
		"\"All of Creation is the result of the Creation spell, which is in
		the process of being cast by the Divine Being.  There is much speculation
		about how far along the casting is (and the quality of the casting itself,
		and what exactly the final outcome will be)
		but in general it is agreed that the spell is only seven words long, each
		word taking so long to utter that an age passes with each.  The fragments
		and echoes of these words can be used by a wizard to make his own spells,
		if he can but discover echoes that are clear enough to be used as
		instruments of his will.  One of the first such words discovered was
		\(XYZZY\), a simple translocation spell.\"";
		if (almanac.isVisible(fly)) {
			"\bThe fly crawls across the word \"wizard\" in the almanac.";
		}
	}
;

elpulc: almTopic
	noun = 'elpulc'
	title = "Elpulc"
	entry = {
		"\"This spell negates the effects of the cluple spell.  For example, to
		change yourself back from being a bedbug, simply say \(ELPULC ME\).  You
		must say the original form of the creature in order for the spell
		to work.\"";
		if (almanac.isVisible(fly)) {
			"\bThe fly hops around excitedly on the word \"elpulc\" in
			the almanac.";
		}
	}
;

fimpoz: almTopic
	noun = 'fimpoz' 'dukedom' 'duchy'
	adjective = 'royal'
	title = "Fimpoz"
	entry = {
		"\"The Royal Duchy of Fimpoz is not quite the middle of nowhere, it's
		a bit just off center and thus even less significant.  Why a wizard of
		my caliber remains in a country whose primary exports are vicious
		marsupials is beyond my grasp.  Someday soon I will have finished my
		experiments and have no need of the hospitality of overbearing yet
		ineffectual royalty, and I will retire to a tropical island to establish
		my own little kingdom of palm trees and seafood.\"";
		if (almanac.isVisible(fly)) {
			"\bThe fly crawls across the words \"I\" and \"wizard\" in the
			almanac.";
		}
	}
;

ilwig: almTopic
	noun = 'Ilwig'
	plural = 'Ilwigs'
	title = "Ilwigs"
	entry = "\"The Ilwigs were a tiny, peaceful people, standing about two feet
		tall.  They had an advanced culture with many accomplishments in
		medicine, philosophy, and the arts, but virtually none in warfare.
		It became necessary for Duke Oswale to utterly obliterate them.\""
;

/*
jamrecipe: almTopic
	noun = 'recipe'
	adjective = 'grape' 'jam'
	title = "Grape Jam"
	entry = "\"Remove grape skins.  Simmer pulp until soft. Remove
		seeds.  Combine skins and pulp.  Add 2/3 cup as much sugar as combined
		skins and pulp.  Simmer slowly, stirring frequently, until juice
		sheets from spoon.\""
	verDoFollow(actor) = {jam.verDoMake(actor);}
	doFollow(actor) = {jam.doMake(actor);}
;
*/

language: almTopic
	noun = 'language' 'speech'
	plural = 'languages'
	title = "Language"
	entry = "\"Language is perhaps the greatest impediment to communication between
		sentient creatures, and yet, it's the best tool we have for doing so.
		All language is inherently flawed, consisting of fragments of distorted
		echoes of the words of the original creation spell.  Fortunately,
		communication between creatures of the same species is fairly
		straightforward, because they will use the same communications media.
		Interspecies communication is notoriously more difficult, since one
		species may communicate primarily via sound and vision, whereas the other
		may communicate via chemical excretions and rhythmic dance.  This is a
		serious problem, and one that I hope my spell research will ultimately
		help to solve.\""
;

magic: almTopic
	noun = 'magic'
	title = "Magic"
	entry = {
		"\"Magic is the alteration of natural laws through the imposition
		of the wizard's will.  The wizard's will is expressed in magic
		words, which the forces of nature understand and respond to.  The
		greater the will, the more powerful the effect.  For
		examples, '\(CONSULT ALMANAC ON XYZZY\)' and '\(CONSULT ALMANAC ON
		CLUPLE\).'\"";
		if (almanac.isVisible(fly)) {
			"\bThe fly crawls across the word \"cluple\" in the almanac.";
		}
	}
;

microemacs: almTopic
	noun = 'emacs' 'microemacs'
	adjective = 'micro'
	title = "MicroEMACS"
	entry = "\"This story was written with MicroEMACS 4.00 for Windows, which was
		in turn written by Daniel M.\ Lawrence (based on code by Dave Conroy)
		and ported to Windows by Pierre Perret.\""
;

paradox: almTopic
	noun = 'paradox' 'error'
	title = "Paradox"
	entry = "\"This statement is in error.\""
;

planet: almTopic, monTopic
	noun = 'XJ945378-3' 'planet' 'codex'
	adjective = 'new' 'universal'
	title = "XJ945378-3"
	entry = "\"XJ945378-3 is this planet's ID number in the New Universal Codex.\""
	monKnows = "\"This is planet XJ945378-3, right?  I'm stranded, not lost.\""
;

recursion: almTopic
	noun = 'recursion'
	title = "Recursion"
	entry = "\"'\(CONSULT ALMANAC ON RECURSION\).'\""
;

socks: almTopic, monTopic
	noun = 'socks' 'sock'
	adjective = 'unmatched'
	title = "Socks"
	entry = "\"No one really knows what happens to socks that disappear in the laundry,
		leaving a lonely widow behind, as it were.  This problem has plagued
		humanity since footwear was invented.  Do they get sucked into some
		strange parallel dimension from which they never return?  Do they dissolve
		into lint?  Are they kidnapped by crazed Tunisians?  We may never know.
		Someday I'll make a spell that will retrieve all the lost socks, for the
		betterment of mankind.\""
	monKnows = "\"Socks?  Oh yeah, boy, we've got socks.  The blasted things keep
		appearing spontaneously, all over the homeworld.  It can be quite
		embarrassing.  And you know what?  No two of them are ever the same.
		It's really quite weird.  And the saddest part?  Look at this.\"  He
		points down.  \"Look.  No feet.\""
;

spag: almTopic
	noun = 'spag' 'whizzard' 'gerry' 'kevin' 'wilson' 'magnus' 'olsson'
	title = "SPAG"
	entry = {
		"\"SPAG\ is the Society for the Promotion of Adventure Games,
		and is embodied in a newsletter semi-occasionally produced by Magnus
		Olsson.  SPAG was founded by
		G.\ Kevin Wilson (also known as Whizzard), who also administrates the Third
		Annual Text Adventure Authorship Competition, for which this message is a
		blatant attempt to garner more points.\"";
		if (almanac.isVisible(fly)) {
			"\bThe fly crawls across the word \"Whizzard\" in the almanac.";
		}
	}
;

spell: almTopic
	noun = 'spell' 'word'
	plural = 'spells' 'words'
	title = "Spells"
	entry = {
		"\"Spells are merely certain words that alter natural laws when
		spoken by a wizard.  The words themselves are echoes, fragments, and distortions
		of the primordial words used by the Divine to cast the spell of Creation.
		By speaking these words the wizard creates localized
		interference with the Creation spell, thus establishing his will
		upon Creation.  However, since the will of the Divine is immeasurably
		greater than that of the wizard, the effects are invariably transitory,
		though a great will can create effects of greater duration than a small
		will.  For more information, '\(CONSULT ALMANAC ON MAGIC\).'\"";
		if (almanac.isVisible(fly)) {
			"\bThe fly crawls across the word \"wizard\" in the almanac.";
		}
	}
;

tads: almTopic
	noun = 'tads' 'mike' 'michael' 'roberts'
	title = "TADS"
	entry = "\"TADS is the Text Adventure Development System, developed by
		Michael J.\ Roberts.  It made this virtual adventure possible, or at least
		a hell of a lot easier.  For information on creating your own interactive
		fiction with TADS, see:\b
		\t\(http://www.tela.bc.ca/tela/tads/\)\""
;

bncgroup: almTopic
	noun = 'toast' 'bread' 'cereal'
	title = "Bread and Cereal Group"
	entry = "\Breads and cereals provide fuel for the body and should comprise the
		bulk of a healthy person's daily food intake.  For example, a slice of
		toast is a good part of any complete breakfast.\""
;

wombat: almTopic
	noun = 'wombat' 'marsupial'
	plural = 'marsupials'
	title = "The Wombat"
	entry = "\b\t\"The wombat lives across the seas,\n
		\tAmong the far Antipodes.\n
		\tHe may exist on nuts and berries,\n
		\tOr then again, on missionaries;\n
		\tHis distant habitat precludes\n
		\tConclusive knowledge of his moods,\n
		\tBut I would not engage the wombat\n
		\tIn any form of mortal combat.\n
		\t\t- Ogden Nash\""
;

xyzzy: almTopic
	noun = 'xyzzy' 'adventure'
	title = "Xyzzy"
	entry = {
		"\"Xyzzy is the original magic word, of which all others are but
		distorted echoes.  The xyzzy spell transports the wizard to a faraway
		land of adventure.  To cast the spell, simply say \(XYZZY\).\"";
		if (almanac.isVisible(fly)) {
			"\bThe fly crawls across the word \"wizard\" in the almanac.";
		}
	}
;

/*
** Online help system.
*/
helpVerb: sysverb
	verb = 'help'
	action (actor) = {
	    if (Me == actor) {
		"\(Poor Zefron's Almanac\) is an interactive story with a mildly sophisticated command parser,
		comparable to the best of those used by the Infocom interactive fiction of
		the late 80s.  It understands abbreviated one-letter commands, such as those
		mostly used for movement (\(E\) to go east, \(N\) to go north,
		etc.)\ as well as fairly complicated commands using verbs, nouns, adjectives,
		prepositions, pronouns, multiple direct objects, and redirection of
		commands to other characters (\(SYLVIA, PICK UP TWO SILVER COINS AND ALL
		THE GROATS WITH THE ORNATE SALAD TONGS\)).\b
		Though examples of commands are provided in upper case, the case is
		actually ignored.  Words in angle brackets ('<' and '>') within example
		commands should be replaced with a word from the story; don't actually
		enter the angle brackets.\b
		Because much of the difficulty in participating in interactive fiction
		revolves around proper verb usage, this help system is mostly a
		means of providing you with information on nearly all of the verbs
		you need to achieve an ideal conclusion to the story.  And because this
		story largely revolves around Zefron's almanac, the help entries are
		provided as pages in that book.  Enter the following
		commands for more specific help on the listed topics:\b
		\(CONSULT ALMANAC ON STORY\): provide general information about the story\n
		\(CONSULT ALMANAC ON SPELLS\): using commands to cast magic spells\n
		\(CONSULT ALMANAC ON SYSTEM\): communicating with the command system\n
		\(CONSULT ALMANAC ON METACOMMANDS\): manipulating the previous command\n
		\(CONSULT ALMANAC ON MOVEMENT\): moving about the environment\n
		\(CONSULT ALMANAC ON SENSES\): look, smell, listen, touch, etc.\n
		\(CONSULT ALMANAC ON COMMUNICATION\): interacting with other characters\n
		\(CONSULT ALMANAC ON INVENTORY\): carrying things around\n
		\(CONSULT ALMANAC ON MANIPULATION\): interacting with the environment\n
		\(CONSULT ALMANAC ON ABBREVIATIONS\): shortened forms of common words\n
		\(CONSULT ALMANAC ON HINTS\): what to do when you don't know what to do";
		abort;
	    } else if (zefron == actor) {
		"\"Giving up, child?  Are you quite sure?  (Y or N): ";
		if (1 == yorn()) {
			"\bZefron sighs.  \"Very well.  I will deal with the
			situation.  Continue with your chores.\"";
			rescue();
		} else {
			"\b\"Ah, good.  Get back to it then.\"";
		}
	    }
	}
;

class helpTopic: almTopic
	entry = {
		self.hentry;
		abort;
	}
	thedesc = self.title
	adesc = self.title
;

systemcommands: helpTopic
	noun = 'commands'
	adjective = 'system' 'command'
	title = "Help: System Commands"
	hentry = "\"System commands are those that manipulate the interactive environment
		rather than the story setting.  The available system commands are:\b
		\(HELP\): Describes the on-line help system.\n
		\(SAVE\): 'Bookmark' a story session to come back to later.\n
		\(RESTORE\): Start a story session at a 'bookmarked' location.\n
		\(RESTART\): Start the story over again from the beginning.\n
		\(QUIT\): Leave the story.\n
		\(VERBOSE\): Give a full description of each area every time it's entered.\n
		\(TERSE\): Give a full description of each area only when first entered.\n
		\(STATUS\): Display your current role in the story environment.\n
		\(SCRIPT\): Begin logging the session to a text file.\n
		\(UNSCRIPT\): End logging the session to a text file: turn \(SCRIPT\) off.\n
		\(VERSION\): Display information about the interactive story executable.\""
;

metacommands: helpTopic
	noun = 'commands' 'metacommands'
	adjective = 'meta'
	title = "Help: Metacommands"
	hentry = "\"Metacommands tell the command interpreter to do something based
		upon the previously entered command.\b
		\(UNDO\): Eliminate the last command, as if it had not been entered.\n
		\(AGAIN\): Perform the last command again.\n
		\(OOPS\): Replace an unknown word in the last command with another.\b
		Note that \(OOPS\) is not recognized as a word unless the previous command
		resulted in a 'I don't know the word \"<xxx>\".' message.\b
		One other command is \(WAIT\), which simply allows time to pass without
		your character doing anything.\""
;

moveverbs: helpTopic
	noun = 'verbs'
	adjective = 'movement'
	title = "Help: Movement"
	hentry = "\"Movement is achieved by telling the command interpreter the direction
		in which you wish your character to go.  In addition to moving from one
		area to another, the character may enter and exit 'nested rooms', locations
		within other locations (chairs, beds, etc.).  Many of the movement verbs
		may be abbreviated by entering only their first letter: \(CONSULT
		ALMANAC ON ABBREVIATIONS\) for details.  Not all or even most directions
		will be available from most locations.  The most typical movement
		verbs are:\b
		\(NORTH\): Move your character to an area north of the current location.\n
		\(SOUTH\): Move your character to an area south of the current location.\n
		\(EAST\): Move your character to an area east of the current location.\n
		\(WEST\): Move your character to an area west of the current location.\n
		\(UP\): Move your character to an area above the current location.\n
		\(DOWN\): Move your character to an area below the current location.\n
		\(ENTER\): Move your character inward from the current location.\n
		\(EXIT\): Move your character outward from the current location.\n
		\(SIT\): Move your character into a chair.\n
		\(STAND\): Move your character out of a chair.\""
;

sensoryverbs: helpTopic
	noun = 'verbs' 'senses'
	adjective = 'sensory'
	title = "Help: Sensory Verbs"
	hentry = "\"The command interpreter provides many verbs for investigating your
		environment.  Most of these concentrate on the use of vision, but
		you can use your senses of hearing, smell, and touch as well:\b
		\(LOOK\): Look around the area.\n
		\(EXAMINE\): Provide detailed information about an object.\n
		\(READ\): Read written text.\n
		\(BROWSE\): Flip through a book at random and read what you find.\n
		\(CONSULT\): Look in a book for information on a specific topic.\n
		\(SEARCH\): Look carefully for something hidden.\n
		\(SMELL\): Sense with your nose.\n
		\(LISTEN\): Sense with your ears.\n
		\(TOUCH\): Physically contact an object and sense with your fingers.\b
		\(LOOK\) can also be combined with prepositions to obtain specific
		kinds of information.  Some examples are \(LOOK IN\), \(LOOK ON\),
		\(LOOK THROUGH\), \(LOOK AT\), \(LOOK AROUND\), \(LOOK UNDER\), and
		\(LOOK OUT\).\""
;

commverbs: helpTopic
	noun = 'verbs' 'interaction'
	adjective = 'communication'
	title = "Help: Communication"
	hentry = "\"Communication with other characters is typically done through speech.
		You can simply \(SAY\) whatever you want to no one in particular, as long
		as it's enclosed in
		quotes: e.g. \(SAY \"TIME FLIES LIKE AN ARROW, BUT FRUIT FLIES LIKE A
		BANANA\"\).  You can also simply \(YELL\).\b
		To give a command to another character, enter its name, a comma, and
		the command: e.g. \(ROSCOE, EAT THE DUMPLINGS\).  You can greet a
		character by entering \(GREET <character>\).\b
		To ask another
		character a question, enter \(ASK <character> ABOUT <topic>\).  To tell
		another character something, enter \(TELL <character> ABOUT <topic>\).  For
		example, you might \(ASK ALFONSE ABOUT THE WEATHER\).
		You can also \(SHOW <item> TO <character>\) to see how he responds, or
		\(OFFER <item> TO <character>\) to see if he will accept it.\""
;		

inventoryverbs: helpTopic
	noun = 'verbs'
	adjective = 'inventory'
	title = "Help: Inventory"
	hentry = "\"Your inventory consists of the things you are carrying around with
		you, as well as their contents if applicable.  You can use the following
		verbs to affect your inventory:\b
		\(INVENTORY\): Display what you are carrying.\n
		\(GET\): Move some item into your inventory.\n
		\(DROP\): Move an item out of your inventory into your location.\n
		\(WEAR\): Put on an article of clothing that you are carrying.\n
		\(TAKE OFF\): Remove an article of clothing into your inventory.\n
		\(PUT\): Place an item \(ON\) a surface or \(IN\) a container.\""
;

manverbs: helpTopic
	noun = 'verbs'
	adjective = 'other' 'manipulation' 'general'
	title = "Help: Manipulation Verbs"
	hentry = "\"The command interpreter understands many general verbs, most of which
		are for various manipulations of your environment.  The following list
		consists of a few of the most commonly used manipulation verbs:\b
		\t\(OPEN\), \(CLOSE\), \(LOCK\), \(UNLOCK\), \(BAR\), \(UNBAR\),\n
		\t\(PUSH\), \(TURN\), \(ATTACK\), \(MOVE\), \(CUT\),\n
		\t\(MAKE\), \(EAT\), \(KNOCK\)\""
;

abbrevwords: helpTopic
	noun = 'words' 'abbreviations'
	adjective = 'abbreviated'
	title = "Help: Abbreviations"
	hentry = "\"Several of the most commonly used words have one-letter abbreviations,
		as a tribute to repetitive-strain injury sufferers everywhere:\(\b
		\tN	\tNORTH\n
		\tS	\tSOUTH\n
		\tE	\tEAST\n
		\tW	\tWEST\n
		\tU	\tUP\n
		\tD	\tDOWN\n
		\tL	\tLOOK\n
		\tX	\tEXAMINE\n
		\tC	\tCONSULT\n
		\tI	\tINVENTORY\n
		\tO	\tOOPS\n
		\tG	\tAGAIN\n
		\tZ	\tWAIT\)\""
;

hinthelp: helpTopic
	noun = 'hints' 'hint'
	title = "Help: Getting Hints"
	hentry = "\"Here are a few general hints (for free, so to speak).\b
		1. Explore everywhere.  You'll often find in one place something you
		need elsewhere.\n
		2. Examine everything.  Details about an object can provide hints.  Don't
		forget that you have senses other than vision.\n
		3. \(CONSULT\) or \(BROWSE\) the almanac.  It's chock full of hints and
		information you need.\n
		4. \(ASK THE MONSTROSITY\) about things, if you know how.  He has lots
		of knowledge you'll need once you go to where he came from.\b
		If you still don't know what to do (or if you're just impatient),
		you can use the \(HINT\) command to find out what to do next.  \(HINT\)
		by itself tries to determine where you are in the story and provide a clue
		accordingly.  Alternatively, you can enter \(HINT <object>\) to get hints
		specific to certain objects.\n
		Each hint topic has three hints associated with it.  The first hint
		is vague and general, the second is more specific, and the third
		gives explicit instructions on what to do next.  If \(HINT\) gives you
		a hint that you don't need, because you've already solved the associated
		problem, keep entering \(HINT\) until you get a hint that you can use.\b
		For explicit commands on going through the whole story, \(CONSULT THE
		ALMANAC ON WALKTHROUGH\).  For a list of all possible statuses that you
		can achieve throughout the story, \(CONSULT ALMANAC ON STATUSES\).\""
;

carl: almTopic, monTopic
	noun = 'carl' 'klutzke' 'author'
	adjective = 'carl'
	title = "About the Author"
	entry = "\"Carl Klutzke lives in Lafayette, Indiana with his loving and patient
		wife Karen, their adorable and exuberant son Brandon, their affection-starved
		dog Pippin, and two cats which share but a single neuron between them (we
		have photographic evidence).
		\(Poor Zefron's Almanac\) is his third virtual adventure, and his first using TADS.  His next
		project is a World Wide Web site for transmitting subliminal messages to
		induce people to beg him to accept money to make more virtual adventures.
		Please feel free to examine the prototype at:\b
		\t\(http://www.iquest.net/~kklutzke/\)
		\bCarl would love to hear what you thought of this adventure!  Whether it's
		praise, condemnation, or (gasp) bug reports, please, please, please send
		him email.  As of this writing, he can be contacted
		at \(cklutzke@iquest.net\).\""
	monKnows = "\"Yeah, I know him!  He sent me email asking me about techniques to
		implant subliminal messages into World Wide Web pages.  I told him I
		didn't know anything about that, I'm just a pilot.\""
;

credits: almTopic
	noun = 'credits'
	title = "Credits"
	entry = "\"The following people were instrumental in the creation of this work,
		whether they know about it (or deny it) or not.\b
		Scotto Starkey: Introduced me to TADS, and has in general been a great
		friend for a very long time, and still will be even if \(Zombie!\)\ wins
		the contest instead.\b
		Brandon Klutzke: First playtester, responsible for the \(FART\) command.\b
		Karen Klutzke: Friendship, support, encouragement, playtesting, and
		unmatched socks.\b
		Daniel Lawrence: MicroEMACS, playtesting, and lots of thoughts over
		the years on game and software creation.\b
		Dana (Muck) Hoggatt: Playtesting, and suggesting things that even I
		thought too obscure and silly.\b
		Larry Klutzke: Playtesting, brothering, and general silliness.\b
		Michael J.\ Roberts: TADS, of course.\b
		N.\ K.\ Guy: The invaluable HTML TADS manual conversion and tip sheet.\b
		Rick LaBach: VERIVERB.EXE and TEXTOUT.EXE.\b
		Mark J Musante: Help with the \(CONSULT\) command.\b
		Stephen Granade (and Neil deMause): Lots of code bits.\b
		The Crew of SS Voyager SF Conclave: Inventors of the original
		Persian carpet & orange marmalade warp drive.\b
		rec.arts.int-fiction: Revivers of my boyhood dream of working for
		Infocom.\b
		Thank you all very much.  I promise the next one will be better.\""
;	

/* Dump the verbs.
verbVerb: sysverb
	verb = 'verbs'
	action(actor) = {
		local o = firstobj(deepverb);
		local l, len, i;

		while( o != nil ) {
			l = getwords(o, &verb);
			len = length(l);
			for (i=1; i<=len; i++) {
				say(l[i]);
				"\t";
			}
	        	o = nextobj( o, deepverb );
		}
	}
;
*/

