#include "almanac.t"

class carpetItem: cushionItem
	hangable = true

/*
	verDoTake(actor) = {
		if (Me == location) {
			"You already have << thedesc >>!";
		} else if (engine == location) {
			if (11 == throttle.setting) {
				"The piston is jammed up against it.  It
				won't budge.";
			} else if (!engine.ison) {
				"The hard clear sheet is in the way.  You can't get to
				it.";
			}
		} else {
			inherited.verDoTake(actor);
		}
	}
	doTake(actor) = {
		if (self == engine.mycarpet) {
			engine.mycarpet = nil;
		}
		inherited.doTake(actor);
	}
*/

	verDoMove(actor) = {
		if (engine == location) {
			if (11 == throttle.setting) {
				"The piston is jammed up against it.  It
				won't budge.";
			} else if (!engine.ison) {
				"The hard clear sheet is in the way.  You can't get to
				it.";
			}
		}
	}
;

bar: keyItem
	weight = 10
	bulk = 10
	sdesc = "wooden bar"
	ldesc = "It's a heavy wooden bar."
	noun = 'bar'
	adjective = 'heavy' 'wooden'
	location = maindoorsout
	verIoBarWith(actor) = {}
	ioBarWith(actor, dobj) = {
		dobj.doBarWith(actor, self);
	}
	doTake(actor) = {
		inherited.doTake(actor);
		if (maindoorsout != self.location) {
	    		maindoorsout.islocked = nil;
	    		maindoorsin.islocked = nil;
	    	}
	}
	verDoPutIn(actor, iobj) = {
		if (maindoorsout == self.location) {
			"You'll have to remove it from the doors first.";
		}
	}
	verDoPutOn(actor, iobj) = {self.verDoPutIn(actor, iobj);}
	doHint -> maindoorsout	
;

box: clothingItem, monTopic
	isfixed = nil
	sdesc = "little box"
	ldesc = "It's a little metal box attached to a collar."
	noun = 'box' 'translator' 'collar'
	adjective = 'little' 'metal' 'universal'
	location = monstrosity
	monKnows = 	"\"My universal translator is on the blink, I'm afraid.  It must
			have been damaged in the crash.\"  It fades purple.  \"Come to
			think of it, I'm not sure it ever worked right.  I've had some
			creatures look at me quite strangely when I've used it in the
			past, and they almost always end up talking about unmatched
			socks.\""
;

bunny: item
	sdesc = "stuffed bunny"
	ldesc = "It looks like it was once white, but years of adoration have turned it
		a pale gray.  Its glass eyes are scratched and some of the fuzz has
		been worn away."
	noun = 'bunny'
	adjective = 'stuffed'
	location = oswale
	verDoTake(actor) = {}
	doTake(actor) = {
		"The duke startles awake as you try to steal his beloved bunny.  He
		screams \"Guards!  Guards!  Thief!\"  Before you can escape, the
		castle guards break into the room and carry you off to the dungeons.";
		global.status = 'prisoner';
		rescue();
	}
;

carpet: carpetItem, monTopic
	sdesc = "priceless carpet"
	ldesc = "This priceless carpet was brought from exotic lands by Duke Oswale's
		grandfather.  It's decorated with graceful arabesques, highlighted
		with gold and silver threads, and a pearl adorns each tassel.  You find
		that if you stare at it with your eyes crossed, sometimes a bit of
		the pattern will leap out at you as if it were solid.  Zefron told you once
		that it's a test of wizardly potential.  He claims of course that he
		always sees the hidden solid pattern, but refuses to tell you what it is."
	location = dukesroom
	noun = 'rug' 'carpet'
	adjective = 'priceless' 'new' 'duke\'s'
	monKnows = {
		if (!monstrosity.seencarpet) {
			"\"I need one that's very nice and expensive.  The best I found so
			far was a muddy doormat.  That just won't work.\"";
		} else {
			"\"It's perfect!  It's even better than the one I jammed!
			The acceleration is going to be incredible!\"";
		}
	}
	up = "Nope, sorry.  It's not that kind of carpet."

	hintlevel = 1
	hint1 = "Where in the castle would you find things that are really expensive?"
	hint2 = "You don't need a key to get the carpet, but you need a key to take the
		carpet."
	hint3 = "\(UNLOCK THE DUKE'S DOOR WITH THE KEY\).  Go through the door (which
		isn't as easy as you might think).  Once in the duke's room, \(GET THE
		CARPET\), \(MOVE THE FURNITURE\), and \(OPEN THE DOOR\).  Once you have
		the carpet, go \(SHOW THE CARPET TO THE MONSTROSITY\)."
;

clothes: clothingItem
	sdesc = "your clothing"
	ldesc = "These are just nondescript clothes, affordable to an apprentice
		wizard such as yourself."
	adesc = self.sdesc
	thedesc = self.sdesc
	noun = 'clothes' 'clothing'
	adjective = 'my'
	location = Me
	isworn = true
	hangable = true
	verDoWear(actor) = {
		if (uniform.isworn) {
			"You can't wear it over the uniform.";
		} else {
			inherited.verDoWear(actor);
		}
	}
;

diploma: readable
	noun = 'diploma' 'parchment' 'sheet'
	sdesc = "diploma"
	readdesc = "\"The bearer of this document is a certified
		journeyman wizard, and is entitled to the rights
		and privileges thereof.\"  It's signed \"Zefron,
		Royal Wizard of Fimpoz, XJ945378-3.\""
;

grapes: fooditem
	noun = 'grape' 'bunch' 'grapes'
	sdesc = "bunch of grapes"
	ldesc = "They're large and firm, at the peak of ripeness."
	doEat(actor) = {
		if (fly != Me.form) {
			"You pop a couple into your mouth.  They're taut with perfect
			ripeness, and when you bite down, sweet, delicious juices
			explode into your mouth.";
		} else {
			inherited.doEat(actor);
		}
	}
	bulk = 2
	hangable = true

	hintlevel = 1
	hint1 = "Have you been in the garden yet?"
	hint2 = "You can't pick or carry the grapes as a fly."
	hint3 = "In your normal form, \(PICK GRAPES\).  Then \(CLUPLE THE RAVEN\),
		\(GET THE GRAPES\), and fly \(UP\) or \(WEST\) to get them out of
		the garden."
;

grapeskins: fixedItem, floatingItem
	noun = 'skins'
	adjective = 'grape'
	sdesc = grapes.sdesc
	ldesc = grapes.ldesc
	location = grapes.location
	verDoTake(actor) = {
		if (kitchen != actor.location) {
			"You probably ought to do that in the kitchen.";
		} else if (Me != almanac.location && kitchen != almanac.location) {
			"You can't remember what to do next.  Better have the
			recipe in front of you while you work.";
		}
	}
	doTake(actor) = {jam.doMake(actor);}
;

hat: container, clothingItem
	isworn = nil
	contentsVisible = {return !self.isworn;}
	contentsReachable = {return !self.isworn;}
	
	noun = 'hat' 'cap' 'cone'
	adjective = 'Zefron\'s' 'black' 'tall' 'silk' 'conical' 'unadorned'
	sdesc = "Zefron's hat"
	thedesc = self.sdesc
	adesc = self.sdesc
	hangable = true
	ldesc = {
		"It's in the traditional tall conical shape, but made of
		unadorned black silk.  Zefron only wears it when he travels.
		Strange that he should leave without it.  ";
		if (self.isworn) {
			"The hat is on your head.";
		} else if (!self.israbbitin) {
			self.contentsdesc;
		}
	}
	contentsdesc = {
		inherited.ldesc;
		/*
        	if ( self.contentsVisible and itemcnt( hatspace.contents ) <> 0 ) {
	        	"In "; self.thedesc; " %you% see%s% ";
			listcont( hatspace ); ". ";
       		} else {
      			"There's nothing in "; self.thedesc; ". ";
       		}
       		*/
       	}
	location = workbench
	israbbitin = true
	doWear( actor ) = {
		if (self.israbbitin) {
			notify(self, &hatDaemon, 0);
		}
		inherited.doWear(actor);
	}
	doLookin(actor) = {
		self.checkDrop;
		if (self.israbbitin) {
			"You look into the bright eyes and twitching nose
			of a white rabbit.  The rabbit hops out of the hat and
			scurries away before you can stop him.\b";
			israbbitin = nil;
		}
		self.contentsdesc;
	}
	hatDaemon = {
		if (!self.isworn || !self.israbbitin) {
			unnotify(self, &hatDaemon);
		} else if (1 == rand(3)) {
			"\bYou have the rather odd feeling that Zefron's hat is
			wriggling a bit on top of your head.";
		}
	}
	ioPutIn(actor, dobj) = {
		if (find(hintVerb.hintlist, self)) {
			hintVerb.hintlist -= self;
		}
		
		self.checkDrop;
		if (self.israbbitin) {
			"As you widen the mouth of the hat to put << dobj.thedesc >> in,
			a white rabbit pops out of the hat and scurries quickly out of
			sight.\n";
			israbbitin = nil;
		}
		if (maxbulk < dobj.bulk) {
			"\^<< dobj.thedesc >> won't fit through the opening.";
		} else {
			dobj.doPutIn(actor, self);
		}
	}

	Shove(obj) = {
		obj.oldweight = obj.weight;
		obj.weight = 0;
		obj.oldbulk = obj.bulk;
		obj.bulk = 0;
	}
	Grab(obj) = {
		obj.weight = obj.oldweight;
		obj.bulk = obj.oldbulk;
	}

	hintlevel = 1
	hint1 = "Having trouble carrying everything?"
	hint2 = "A magician's hat does more than just keep rain off his head."
	hint3 = "The hat is a convenience feature.  You can put just about anything
		and everything in there to carry around."
;

jam: fooditem, monTopic, almTopic
	noun = 'jam' 'pot' 'recipe'
	adjective = 'grape' 'dark' 'thick' 'sticky' 'sweet' 'fruity' 'small' 'grape'
	doSynonym( 'PutOn' ) = 'SpreadOn'
	location = nil
	sdesc = "jam"
	adesc = "a pot of jam"
	ldesc = "It's a pot full of grape jam."
	smelldesc = "It smells sweet and fruity."

	title = "Grape Jam"
	entry = "\"Remove grape skins.  Simmer pulp until soft. Remove
		seeds.  Combine skins and pulp.  Add 2/3 cup as much sugar as combined
		skins and pulp.  Simmer slowly, stirring frequently, until juice
		sheets from spoon.\""

	verDoFollow(actor) = {jam.verDoMake(actor);}
	doFollow(actor) = {jam.doMake(actor);}
	verDoMake(actor) = {
		if (kitchen != actor.location) {
			"You can't possibly do that here!";
		} else if (Me != almanac.location && kitchen != almanac.location) {
			"You don't know where to begin without a proper recipe.";
		} else if (Me != grapes.location && kitchen != grapes.location) {
			"You have everything you need except for the fruit.";
		}
	}
	doMake(actor) = {
		"Carefully following the recipe in the almanac, you find and mix the
		proper ingredients.  After a few minutes, you have a small pot of
		dark, thick, sticky, sweet grape jam.";
		self.moveInto(Me);
		grapes.moveInto(nil);
		if (find(hintVerb.hintlist, grapes)) {
			hintVerb.hintlist -= grapes;
		}
	}
	monKnows = {
		if (monstrosity.seenjam) {
			"\"That stuff looks perfect!  It's so dark, it must have a
			tremendous staining capacity.\"";
		} else {
			"\"Yeah, that's right, it's a condiment.  Made from fruit.  I
			need some to put on the toast.\"";
		}
	}

	hintlevel = 1
	hint1 = "If there's something you can't find, you may have to make it yourself."
	hint2 = "Have you found the grapes yet?"
	hint3 = "Take the grapes and the almanac to the kitchen and \(MAKE JAM\).  Once
		you have the jam, go \(SHOW THE JAM TO THE MONSTROSITY\)."
;

dukeskey: keyItem
	sdesc = "large brass key"
	ldesc = {
		"This is a large and rather ornate brass key, with a head in the
		shape of a rampant wombat.";
	}
	noun = 'key'
	adjective = 'large' 'ornate' 'brass'
	location = nil
	isseen = nil
	hangable = true

	hintlevel = 1
	hint1 = "Where is that key?  It must have fallen out of my pocket."
	hint2 = "Things sometimes fall out of my pockets while I'm sitting."
	hint3 = "\(LOOK UNDER THE CUSHION\) in the Great Hall."

	moveInto(location) = {
		if (find(hintVerb.hintlist, self)) {
			hintVerb.hintlist -= self;
		}
		inherited.moveInto(location);
	}
;

loaf: fooditem, monTopic
	noun = 'bread' 'loaf'
	adjective = 'small' 'golden' 'brown'
	adesc = "a loaf of bread"
	monKnows = "\"It's the primary ingredient in toast.  Then you add heat.\""
	location = oven
	sdesc = "loaf of bread"
	plural = 'bread'

	ldesc = {
		"It's a small loaf of golden brown bread, still warm from the
		oven.";
		if (0 < self.slices) {
			"  It look as if there are
			 about << say(8 - self.slices) >>  slices left.";
		}
	}
	smelldesc = "Your mouth waters."
	verDoCutWith(actor, iobj) = {}
	slices = 0
	slicelist = []
	doCutWith(actor, iobj) = {
		if (5 < slices++) {
			"You cut the last bit of the loaf into
			a slice and a heel.";
			slicelist = slicelist + new slice;
			slicelist = slicelist + new slice;
			slicelist[8].isheel = true;
			addword(slicelist[8], &noun, 'heel');
			delword(slicelist[8], &noun, 'slice');
			self.moveInto(nil);
		} else {
			slicelist = slicelist + new slice;
			if (1 == slices) {
				"You cut a heel off the loaf of bread.";
				slicelist[1].isheel = true;
				addword(slicelist[1], &noun, 'heel');
				delword(slicelist[1], &noun, 'slice');
			} else {
				"You cut a slice off the loaf of bread.";
			}
				
		}
	}
	verDoToast(actor) = {
		"You can't toast the whole loaf!";
	}
;

lunch: fooditem
	weight = 1
	firstlook = true
	sdesc = "lunch"
	ldesc = {
		"You see half a shepherd's pie, which Zefron left on
		his workbench yesterday.  It's
		quite cold now, and grease has congealed on top. ";
		if (firstlook) {
			"One of the more suspicious-looking black specks on the
			pie launches into the air and begins buzzing around.";
			fly.moveInto(Me.location);
			notify(fly, &actorDaemon, 0);
			firstlook = nil;
		}
		if (fly == Me.form || raven == Me.form) {
			"It looks delicious!";
		}
	}
	noun = 'lunch' 'pie' 'bit' 'leftovers' 'food'
	adesc = "a bit of lunch"
	adjective = 'shepherd\'s' 'half' 'Zefron\'s'
	location = workbench
	verDoEat(actor) = {
		if (fly != Me.form && raven != Me.form) {
			"Ugh, I don't think so.  Have you looked at it?  Yuck.";
		}
	}
	doEat(actor) = {
		"You land on the pie and start nibbling.";
	}
	smelldesc = "It's starting to get a bit ripe."
;

// The mat is the startroom.
startroom: cushionItem
	sdesc = "your sleeping mat"
	ldesc = "It's a mat of pressed straw that your master, Zefron, generously gave
		you to sleep upon.  Most apprentices sleep on pressed floor.  And it
		actually doesn't have any bedbugs.  The toxic chemicals in Zefron's
		workshop drive them away."
	smelldesc = "It smells like the noxious chemicals in the workshop."
	noun = 'mat'
	adjective = 'sleeping' 'my'
	thedesc = self.sdesc
	adesc = self.sdesc
	location = workshop
	hangable = true

	hintlevel = 1
	hint1 = "You start out lying on your sleeping mat."
	hint2 = "You can't do much from here."
	hint3 = "\(STAND UP\)."
;

notebook: readable
	noun = 'notebook' 'book'
	adjective = 'note'
	sdesc = "notebook"
	ldesc = "It looks as if Zefron is starting a new almanac."
	location = zefron
;

oldcarpet: carpetItem, monTopic
	sdesc = "ruined carpet"
	ldesc = "It's a fine carpet with a lovely pattern of blue cubes and a jaunty
		fringe around the edge, but it's
		ruined by a big orange blotch with bits of orange rind,
		right in the center.  That stain will never come out."
	noun = 'rug' 'carpet'
	adjective = 'old' 'ruined' 'stained'
	location = carpetsurface
	monKnows = "\"It was a good carpet.  I bought it in a bazaar from an old man
		with some terrible family problems.  I got a good price though.  Such
		a pity.\""
;

oldtoast: slice, monTopic
	noun = 'toast'
	plural = 'slices' 'bread'
	adjective = 'smashed' 'perfectly' 'toasted' 'old'
	toastlevel = 2
	issmashed = true
	location = piston

	crumbleFuse = {
		unnotify(self, &crumbleFuse);
		self.moveInto(nil);
		"Removed from the piston, the smashed toast crumbles apart.";
	}
	moveInto(loc) = {
		if (nil != loc) {
			notify(self, &crumbleFuse, 0);
		}
		inherited.moveInto(loc);
	}

	monKnows = "\"I need a new slice of toast.  The one I have now is hopelessly
		malformed.  The toast has to be uniform or
		harmonic disturbances can occur.\""

	hintlevel = 1
	hint1 = "Did you search the kitchen thoroughly?"
	hint2 = "Toast is made by applying heat to thin slices of bread."
	hint3 = "In the kitchen, \(OPEN THE OVEN\n
		SHARPEN SWORD WITH WHETSTONE\n
		SLICE BREAD WITH SWORD\n
		SLICE BREAD WITH SWORD\n
		PUT SLICE IN OVEN\)\n
		Watch the slice until it's perfectly toasted, then \(GET TOAST\).
		Once you have the toast, \(SHOW THE TOAST TO THE MONSTROSITY\)."
;

package: openable, monTopic
	weight = 2
	bulk = 7
	sdesc = "package"
	ldesc = {
		"It's about the same size as a breadbox, and wrapped in plain brown
		paper.  A label reads: ";
		if (!monstrosity.isbabbling) {
			"\"FOR THE KING.\"";
		} else {
			"\"TONUKI EL VISO.\"";
		}
	}
	smelldesc = "It bears a tantalizingly familiar aroma, but you can't quite
		place it."
	noun = 'package' 'box' 'cargo'
	adjective = 'wrapped' 'brown'
	location = belly
	isopen = nil
	doOpen(actor) = {
		if (monstrosity.location == Me.location) {
			"As you begin to tug on the wrappings, the monstrosity
			rips the package from your hands.  His entire body is
			flushed with scarlet.  ";
			if (monstrosity.isbabbling) {
				"\"Zor blopel!  Mork tonuki el viso!\"";
			} else {
				"\"How DARE you!  That's for the King!\"";
			}
			"  He sets the package down reverently.";
			self.moveInto(monstrosity.location);
		} else {
			"You start to open the package, but change your mind.
			Satisfying your curiosity just doesn't seem worth the
			risk of interplanetary war.";
		}
	}
	monKnows = "\"That's my cargo.  It's an urgent package for the King.\""
	verDoMove(actor) = {}
	doMove(actor) = {
		"Something moves around inside when you shake it.";
	}
;

paper: readable, monTopic
	sdesc = "piece of paper"
	noun = 'piece' 'paper' 'diagram' 'schematic'
	adjective = 'large'
	ldesc = "It looks like the schematic for some sort of engine.  It mostly
		involves a very expensive carpet and a slice of jam-covered toast.
		Apparently the fundamental attraction of the jam-covered side of the
		toast to the expensive carpet can propel a
		vehicle at incredible speeds.  As the jam comes closer to the carpet
		the attraction increases, becoming so great that it can distort the
		very laws of time and space, allowing the ship to exceed the speed of light. 
		The efficiency of the drive seems proportional to the value of the
		carpet and the staining capacity of the jam."
	location = nil
	monKnows = "The monstrosity turns purple.  \"It looks to me like I need a new
		slice of toast, some jam, and a new carpet, but I can't make much sense
		out of this thing.  I'm just a pilot.\""
;

quill: item
	noun = 'quill' 'feather'
	adjective = 'hawk\'s'
	sdesc = "quill"
	ldesc = "It's a hawk feather, cut at the tip and dipped in ink."
	location = zefron
;

class slice: fooditem
	construct = {
		self.moveInto(loaf.location);
	}
	destruct = {
		self.moveInto(nil);
		unnotify(self, &toastingDaemon);
	}
	noun = 'slice' 'bread'
	plural = 'slices' 'bread'
	adjective = 'untoasted' 'plain'
	
	isEquivalent = true
	toastlevel = 0
	toasttimer = 0
	isjammed = nil
	isheel = nil
	issmashed = nil
	remdesc = {
		" of ";
		switch (self.toastlevel) {
		case 0: "bread";
			break;
		case 1: "lightly toasted bread";
			break;
		case 2: "perfectly toasted bread";
			break;
		default: "burnt toast";
		}
		if (isjammed) " with jam";
	}
	sdesc = {
		if (issmashed) "smashed ";
		isheel ? "heel" : "slice";
		remdesc;
	}
	pluraldesc = {
		isheel ? "heels" : "slices";
		remdesc;
	}
	
	ldesc = {
		"It's a ";
		issmashed ? "smashed " : "nice thick ";
		isheel ? "heel" : "slice";
		" of bread";
		switch (self.toastlevel) {
		case 0: break;
		case 1: ", lightly toasted";
			break;
		case 2: ", toasted to perfection";
			break;
		default: ", burnt to a crisp";
		}
		if (self.isjammed) {
			", slathered with grape jam";
		}
		".";
	}
	smelldesc = "It smells delicious."

	toastingDaemon = {
		if (oven != self.location) {
			unnotify(self, &toastingDaemon);
			return;
		}

		if (self.isjammed) {
			if (kitchen == Me.location) {
				"The jam bursts into flames in the hot oven.
				<< self.thedesc >> quickly burns up and
				disintegrates into the ashy floor of the oven.";
			}
			delete self;
		} 
		if (2 == self.toasttimer++) {
			toasttimer = 0;
			toastlevel++;
			if (1 == self.toastlevel) {
				addword(self, &adjective, 'lightly');
				addword(self, &adjective, 'toasted');
				delword(self, &adjective, 'untoasted');
			}
			if (2 == self.toastlevel) {
				addword(self, &adjective, 'perfectly');
				addword(self, &adjective, 'perfect');
				addword(self, &noun, 'toast');
				delword(self, &adjective, 'lightly');
				delword(self, &noun, 'bread');
			}
			if (3 == self.toastlevel) {
				addword(self, &adjective, 'burnt');
				addword(self, &noun, 'crisp');
				delword(self, &adjective, 'perfectly');
				if (kitchen == Me.location && !oven.burning) {
					"You smell something burning.  Hardly surprising,
					considering the state of the town outside, but it
					reminds you of something else....";
					oven.burning = true;
				}
			}
			if (4 == self.toastlevel) {
				if (kitchen == Me.location) {
					"\^<< self.thedesc >> bursts into flames
					and quickly disintegrates into the
					ashy floor of the oven.";
				}
				delete self;
			}
		}
	}
	moveInto(loc) = {
		if (self == engine.mytoast && piston != loc) {
			engine.mytoast = nil;
		}

		if (oven == self.location && oven != loc) {
			unnotify(self, &toastingDaemon);
		}
		inherited.moveInto(loc);
		if (oven == self.location) {
			notify(self, &toastingDaemon, 0);
		}
	}
	verDoToast(actor) = {
		if (kitchen != Me.location) {
			"How?";
		}
	}
	doToast(actor) = {
		"Okay, you put the slice in the oven.";
		self.moveInto(oven);
	}

	verIoPutOn(actor) = {}
	ioPutOn(actor, dobj) = {
		if (jam == dobj) {
			"You smear a thick layer of jam over << self.thedesc >>.";
			self.isjammed = true;
			addword(self, &adjective, 'jam');
			addword(self, &adjective, 'jammed');
			delword(self, &adjective, 'plain');
			if (self == engine.mytoast && engine.ison &&
				engine.iscarpetfixed) {
				"  Unfortunately, you quickly (and briefly) discover that
				being caught in the attraction field of the newly-spread
				jam and the priceless carpet exposes you to forces that
				mere flesh cannot withstand.  Maybe you should have turned
				the engine off first.";
				global.status = 'non-sentient plasmoid';
				die(engine);
			}
			notify(self, &jamDaemon, 0);
		} else {
			"That won't fit on << self.thedesc >>.";
		}
	}
	ioSynonym( 'PutOn' ) = 'SpreadOn'
	jamDaemon = {
		if (self.isVisible(carpet)) {
			if (!(self == engine.mytoast ||
				(carpet == engine.mycarpet && !engine.ison))) {
			"\b\^<< thedesc >>, drawn irresistibly, flies through the air
			and strikes the carpet.  Inevitably, it strikes jam side first,
			ruining the carpet and your hopes.";
			rescue();
			}
		}
	}

	verDoMove(actor) = {
		if (self == engine.mytoast && 11 == throttle.setting) {
			"The piston is jammed up against it.  It
			won't budge.";
		}
	}
;

sword: item
	weight = 1
	bulk = 2
	issharp = nil
	noun = 'sword'
	sdesc = "sword"
	ldesc = {
		if (issharp) {
			"It's a bit rusty still, but quite sharp.";
		} else {
			 "It's not in particularly good shape.  It could use a good polish,
			and is overdue for a sharpening.  Still, it appears lethal enough
			for most purposes.";
		}
	}
	location = guard
	verIoAttackWith(actor) = {}
	ioAttackWith(actor, dobj) = { dobj.doAttackWith(actor, self); }
	verIoCutWith(actor) = {
		if (!issharp) {
			"This sword is too dull to cut much of anything.";
		}
	}
	ioCutWith(actor, dobj) = { dobj.doCutWith(actor, self); }
	verDoSharpenWith(actor, iobj) = {}		
;

uniform: clothingItem
	location = pegs
	sdesc = "guard uniform"
	ldesc = {
		"This is the uniform of one of the castle guards.  It looks about your
		size (conveniently enough).";
	}
	noun = 'uniform'
	adjective = 'guard'
	smelldesc = "What do you expect?  It's been hanging in the garderobe!"
	hangable = true
	verDoWear(actor) = {
		if (clothes.isworn) {
			"You can't wear it over your clothes.";
		} else {
			inherited.verDoWear(actor);
		}
	}
;

whetstone: item
	location = kitchen
	sdesc = "whetstone"
	ldesc = "The cooks use it to sharpen their knives."
	noun = 'stone' 'whetstone'
	adjective = 'sharpening'
	verIoSharpenWith(actor) = {}
	ioSharpenWith(actor, dobj) = {
		"Using long, even strokes, you carefully put a keen edge on << dobj.thedesc >>.";
		dobj.issharp = true;
	}
;

