#charset "us-ascii"

/*
 *   Copyright (c) 2002 by Joao Mendes.
 *   JmmmConv.t: Conversation Library - Basic Definitions.
 */

#include <adv3.h>
#include <en_us.h>

#include <JmmmConv.h>

ModuleID
    name = 'TADS 3 Topic-Based Conversation Library'
    byline = 'by Joao Mendes, Portugal'
    htmlByline = 'by <a href="joao.mendes@netcabo.pt">Joao Mendes, Portugal</a>'
    version = '1.0'

    listingOrder = 51
;

/******************************************************************************
 *
 *   Helper Functions
 */

getPropName(hook)
{
    switch(hook)
    {
    case Ask:
        return &AskProp;
    case Tell:
        return &TellProp;
    case Show:
        return &ShowProp;
    case Give:
        return &GiveProp;
    case AskFor:
        return &AskForProp;
    case Greet:
        return &GreetProp;
    case Recall:
        return &RecallProp;
    case Before:
        return &BeforeProp;
    case After:
        return &AfterProp;
    case Init:
        return &InitProp;
    }
    return nil;
}

/******************************************************************************
 *
 *   JmmmPlayer - Player Character Combination Class for Talking Tracking
 */

class JmmmPlayer: object
    afterAction()
    {
        if ( self.ofKind(Person) )
            delegated Person.afterAction();

        forEachInstance(JmmmPerson, new function(cur)
        {
            if ( cur.getOutermostRoom() != gPlayerChar.getOutermostRoom() )
                cur.isTalking = nil;
        });
    }

    dobjFor(TellAbout)
    {
        verify()
        {
            if (gActor == self)
                illogical(&cannotAskSelf);
        }
    }
;
