REM -- Misadventure of the Holy Grail
REM -- from the Apple II Eamon game by Evan Hodson
REM -- translated to AGT by Michael Detlefsen, 1989

REM -- ******flags ***************
REM -- flag 1 - if on, player is male, off if female
REM -- flag 2 - is turned on when first question is asked
REM -- flag 3 - is off if never been to Castle Asthma before
REM -- flag 4 - is off if haven't met Sir Robin yet
REM -- flag 5 - is off until after player died first time
REM -- flag 6 - is off until at Scottish castle first time
REM -- flag 7 - is off until dennis attacked
REM -- flag 8 - is off until player gone into room with KA and SB
REM -- flag 9 - off until seen monks
REM -- flag 10 - flag for room 16 (scene 24)
REM -- flag 11 - flag for if pot bought
REM -- flag 12 - flag for Knights of Boo room
REM -- flag 13 - flag for HHG instructions
REM -- flag 14 - flag for note arriving
REM -- flag 15 - herb and dad argue flag
REM -- flag 16 - walked into castle first time
REM -- flag 17 - speech after guards left, Sherbet left, dad remains
REM -- flag 19 - chicken arrives flag
REM -- flag 20 - first time in Tim's room
REM -- flag 21 - counted to 3?
REM -- flag 22 - inquisition showing up flag
REM -- flag 23 - gumbies showing up flag
REM -- flag 24 - black beast flag
REM -- flag 25 - said real secret word?
REM -- flag 26 - seen parrot first time yet?
REM -- flag 27 - said blancmange?
REM -- flag 28 - said lupin?
REM -- flag 29 - said larch?
REM -- flag 30 - if on, then parrot is waiting for you to get food, won't move
REM -- flag 31 - been told about skaters
REM -- flag 32 - stop parrot from telling about rug all the time
REM -- flag 33 - tells if you've answered the questions at b.o.d.b.o.
REM -- flag 34 - on when first question is answered
REM -- flag 35 - on when second question is answered
REM -- flag 36 - on when third question is answered
REM -- flag 37 - boat stuff
REM -- flag 38 - boat stuff
REM -- flag 39 - first time in arrrgh
REM -- flag 40 - gold dust twins show up
REM -- flag 41 - on when stand is opened
REM -- flag 42 - off when in room 76 for first time

REM -- variables *************
REM -- var 1 keeps track of how many limbs BK has lost
REM -- var 2  keeps track of how many moves in BK room
REM -- var 3  keeps track of how long at Scottish castle
REM -- var 4 keeps track of how long watching skaters
REM -- var 5 keeps track of watching letters


REM -- **********************************************************************

COMMAND any
flagoff 42
clearscreen
printmessage 133
waitforreturn
clearscreen
printmessage 134
waitforreturn
clearscreen
printmessage 135
waitforreturn
clearscreen
printmessage 136
waitforreturn
END_COMMAND

COMMAND any
flagoff 42
clearscreen
printmessage 137
waitforreturn
clearscreen
printmessage 138
waitforreturn
clearscreen
printmessage 139
waitforreturn
clearscreen
printmessage 140
waitforreturn
clearscreen
turnflagon 42
gotoroom 76
donewithturn
END_COMMAND


COMMAND any
chance 75
minusscore 3
END_COMMAND

COMMAND any
chance 20
plusscore 7
END_COMMAND

COMMAND any
chance 5
minusscore 23
END_COMMAND

COMMAND any
chance 68
plusscore 2
END_COMMAND

REM -- *****************************************************

COMMAND any
present 301
not isgroupmember 301
addtogroup 301
END_COMMAND

COMMAND any
present 302
not isgroupmember 302
addtogroup 302
END_COMMAND

COMMAND any
present 303
not isgroupmember 303
addtogroup 303
END_COMMAND

COMMAND any
present 304
not isgroupmember 304
addtogroup 304
END_COMMAND

COMMAND any
present 305
not isgroupmember 305
addtogroup 305
END_COMMAND

COMMAND any
present 319
not isgroupmember 319
addtogroup 319
END_COMMAND

COMMAND any
flagoff 40
atlocationgt 56
atlocationlt 60
printmessage 126
turnflagon 40
END_COMMAND

COMMAND any
flagoff 38
flagon 37
atlocation 72
printmessage 113
turnflagon 38
putincurrentroom 246
donewithturn
END_COMMAND

COMMAND any
flagoff 37
atlocation 72
printmessage 112 ; boat is coming
turnflagon 37
donewithturn
END_COMMAND

COMMAND any
flagoff 30
flagon 27 ; said blancmange
atlocationlt 47
chance 20 ; 20% chance parrot shows up to give next password
putincurrentroom 333 ; bring parrot
printmessage 100
turnflagon 30
donewithturn
END_COMMAND

COMMAND any
flagon 28 ; said lupin
flagoff 32
atlocationlt 47
chance 15 ; chance parrot gives clue for next password
printmessage 91
turnflagon 32
END_COMMAND

COMMAND any
flagoff 31 ; not done this yet
flagon 29 ; said larch
atlocationlt 47
chance 15
printmessage 93 ; tell about skaters
turnflagon 31
donewithturn
END_COMMAND

COMMAND any
atlocation 18 ; at castle
not verbisdirection
addtovariable 3 1
END_COMMAND

COMMAND any
atlocation 18
variableequals 3 3
not verbisdirection
printmessage 66
putincurrentroom 228
END_COMMAND

COMMAND any
atlocation 18
variableequals 3 5
not verbisdirection
printmessage 66
putincurrentroom 227
END_COMMAND

COMMAND any
atlocation 18
variableequals 3 8
not verbisdirection
printmessage 66
putincurrentroom 229
END_COMMAND

COMMAND any
atlocation 25 ; Boo room
present 312 ; Boo knight here
iscarrying 203 ; got pot
printmessage 46
destroy 203
donewithturn
END_COMMAND

COMMAND any
flagoff 19
verbisdirection
atlocation 42
printmessage 65
putincurrentroom 318
turnflagon 19
donewithturn
END_COMMAND


COMMAND any
flagoff 17
flagon 1 ; if male
atlocation 32
present 321 ; everyone gone but dad
not present 320
not present 324
not present 325
printmessage 62 ; incantation
turnflagon 17
donewithturn
END_COMMAND

COMMAND any
flagoff 17
flagoff 1 ; if female
atlocation 32
present 321 ; everyone gone but dad
not present 320
not present 324
not present 325
printmessage 63 ; tell secret
turnflagon 17
donewithturn
END_COMMAND


COMMAND any
flagoff 6
atlocation 18 ; Scottish castle
firstvisittoroom
printmessage 5 ; insults
turnflagon 6
donewithturn
END_COMMAND

COMMAND any
flagoff 3
atlocation 13 ; at castle Asthma
putincurrentroom 302 ; put galahad here
putincurrentroom 303 ; put launcelot here
printmessage 32
turnflagon 3
donewithturn
END_COMMAND

COMMAND any
flagoff 5 ; never been killed
variableequals 2 5
present 300
printmessage 34
delay 3
printmessage 23
delay 3
printmessage 24
delay 3
printmessage 25
delay 3
printmessage 26
turnflagon 5
donewithturn
END_COMMAND

COMMAND any
flagon 5 ; been killed first time
present 300
variableequals 2 5
printmessage 34
delay 3
printmessage 23
delay 3
printmessage 24
delay 3
printmessage 27
delay 3
printmessage 132
gotoroom 76
END_COMMAND

COMMAND any
flagoff 9
atlocation 10 ; fence lined road
printmessage 1 ; monks walking by
turnflagon 9
END_COMMAND

COMMAND any
flagoff 10
atlocation 16 ; scene 24
printmessage 3 ; old troll talks
turnflagon 10
END_COMMAND

COMMAND any
atlocation 6 ; Dark knight room
present 300
addtovariable 2 1
END_COMMAND

COMMAND any
atlocation 6 ; Dark knight room
present 300
verbisdirection
printmessage 31
donewithturn
END_COMMAND

COMMAND attack any
present 319 ; minstrel here
printmessage 115 ; he leaves
destroy 319
END_COMMAND

COMMAND attack any
atlocation 66
present 331
printmessage 116
swaplocations 331 247
swaplocations 330 248
donewithturn
END_COMMAND

COMMAND attack any
atlocation 66
present 329
not present 331
printmessage 117
swaplocations 329 249
swaplocations 328 250
donewithturn
END_COMMAND

COMMAND attack any
atlocation 66
present 327
not present 331
not present 328
printmessage 118
destroy 327
destroy 249
destroy 250
destroy 247
destroy 248
donewithturn
END_COMMAND

COMMAND attack any
atlocation 25
printmessage 37 ; Boo knights kill player
printmessage 132
waitforreturn
gotoroom 76
donewithturn
END_COMMAND

COMMAND attack Dark knight
atlocation 6
present 332
printmessage 33
donewithturn
END_COMMAND

COMMAND attack Dark knight
atlocation 6
present 300
addtovariable 1 1
END_COMMAND

COMMAND attack Dark knight
atlocation 6
present 300
variableequals 1 1 ; first hit
printmessage 18 ; first arm goes
donewithturn
END_COMMAND

COMMAND attack Dark knight
atlocation 6
present 300
variableequals 1 2 ; second hit
printmessage 19 ; second arm goes
donewithturn
END_COMMAND

COMMAND attack Dark knight
atlocation 6
present 300
variableequals 1 3 ; third hit
printmessage 20 ; first leg arm goes
donewithturn
END_COMMAND

COMMAND attack Dark knight
atlocation 6
present 300
variableequals 1 4 ; fourth hit
printmessage 21 ; second leg arm goes
swaplocations 300 332
donewithturn
END_COMMAND

COMMAND attack knight
atlocation 31
present 308
chance 25 ; 25% chance
printmessage 40
destroy 308 ; get rid of 3 head knight
putincurrentroom 223
donewithturn
END_COMMAND

COMMAND attack knight
atlocation 31
present 308
chance 15 ; 15% chance of killing the player
printmessage 41 ; get rid of player
waitforreturn
printmessage 132
gotoroom 76
donewithturn
END_COMMAND

COMMAND attack knight
atlocation 31 ; 3 headed knight
present 308
printmessage 42
donewithturn
END_COMMAND

COMMAND attack howie
atlocation 14
present 311
swaplocations 311 218 ; bring dead roger here
END_COMMAND

COMMAND attack chester
flagoff 7
present 326
printmessage 22 ; starts screaming
turnflagon 7
donewithturn
END_COMMAND

COMMAND attack chester
flagon 7
present 326
printmessage 36
destroy 326 ; get rid of dennis
putincurrentroom 221 ; put his body here
donewithturn
END_COMMAND

COMMAND attack guard1
atlocation 33
present 322 ; first guard here
chance 30
printmessage 50
destroy 322 ; kill him
donewithturn
END_COMMAND

COMMAND attack guard2
atlocation 33
present 323 ; second guard here
chance 35
printmessage 51
destroy 323 ; kill him
donewithturn
END_COMMAND

COMMAND attack guard3
atlocation 32
present 324 ; third guard here
chance 40
printmessage 52
destroy 324 ; kill him
donewithturn
END_COMMAND

COMMAND attack guard4
atlocation 32
present 325 ; fourth guard here
chance 35
printmessage 53
destroy 325 ; kill him
destroy 320 ; get rid of Sherbet
donewithturn
END_COMMAND

COMMAND attack guard1
atlocation 33
present 322
randommessage 54 60
donewithturn
END_COMMAND

COMMAND attack guard2
atlocation 33
present 323
randommessage 54 60
donewithturn
END_COMMAND

COMMAND attack guard3
atlocation 32
present 324
randommessage 54 60
donewithturn
END_COMMAND

COMMAND attack guard4
atlocation 32
present 325
randommessage 54 60
donewithturn
END_COMMAND

COMMAND attack bomber
gotoroom 24
donewithturn
END_COMMAND

COMMAND attack turkey
atlocation 42
present 318
printmessage 71
waitforreturn
printmessage 132
gotoroom 76
donewithturn
END_COMMAND

COMMAND attack armadillo
atlocation 46
present 309 ; bunny
printmessage 73 ; killed by vorpal bunny
waitforreturn
printmessage 132
gotoroom 76
donewithturn
END_COMMAND

COMMAND attack yellow beast
atlocation 53
present 310
printmessage 83
waitforreturn
printmessage 132
gotoroom 76
donewithturn
END_COMMAND

COMMAND attack any
printmessage 35 ; not friendly
donewithturn
END_COMMAND

COMMAND north
flagoff 2
atlocation 76
printmessage 128 ; find out if male or female
donewithturn
END_COMMAND

COMMAND north
flagoff 10
atlocation 9 ; going to room 16
printmessage 3 ; old troll talks
turnflagon 10
END_COMMAND

COMMAND north
flagoff 39
atlocation 65 ; before castle argh
printmessage 111 ; go in and describe the grail!
turnflagon 39
END_COMMAND

COMMAND north
flagon 38
atlocation 72
printmessage 114
destroy 301
destroy 302
destroy 303
destroy 304
destroy 305
destroy 319
gotoroom 73
donewithturn
END_COMMAND

COMMAND north
flagoff 4 ; never met Sir Wren
atlocation 21 ;
printmessage 6
turnflagon 4
END_COMMAND

COMMAND north
atlocation 25 ; Boo room
present 312
printmessage 48 ; can't
donewithturn
END_COMMAND

COMMAND north
flagoff 25
atlocation 53
present 310
printmessage 80
donewithturn
END_COMMAND

COMMAND north
flagoff 14
atlocation 20 ; before before Boo room
printmessage 49
putincurrentroom 225
putincurrentroom 209
turnflagon 14
donewithturn
END_COMMAND

COMMAND north
atlocation 64
present 306 ; if old troll is here, can't cross bridge
printmessage 105
donewithturn
END_COMMAND


COMMAND north
flagoff 12
atlocation 22 ; south of Boo place
gotoroom 25
printmessage 39 ; inform
gotoroom 22 ; exit to south
donewithturn
END_COMMAND

COMMAND east
flagoff 33
atlocation 63 ; fixing to go to b.o.d. room
printmessage 104
END_COMMAND


COMMAND east
atlocation 13 ; at castle Asthma
flagon 1 ; if male
printmessage 29
waitforreturn
printmessage 132
gotoroom 76
donewithturn
END_COMMAND

COMMAND east
atlocation 13
flagoff 1 ; player is female
printmessage 30
waitforreturn
printmessage 132
gotoroom 76
donewithturn
END_COMMAND

COMMAND east
atlocation 25 ; Boo room
present 312
printmessage 48 ; can't
donewithturn
END_COMMAND


COMMAND east
flagoff 22
atlocation 48
printmessage 4
turnflagon 22
END_COMMAND


COMMAND west
flagoff 10
atlocation 17 ; going to room 16
printmessage 3 ; old troll talks
turnflagon 10
END_COMMAND


COMMAND west
flagoff 20
atlocation 45
printmessage 8
destroy 307
turnflagon 20
END_COMMAND

COMMAND west
flagoff 24
atlocation 54
printmessage 81 ; black beast asks the question
turnflagon 24
END_COMMAND

COMMAND west
atlocation 25 ; can't go west from Boo room
present 312
printmessage 48 ; can't
donewithturn
END_COMMAND

COMMAND west
flagoff 15 ; first time in swamp castle
atlocation 33
not present 322
not present 323
printmessage 7 ; Sherbet and dad arguing
turnflagon 15
END_COMMAND

COMMAND west
flagoff 16 ; first time entering swamp castle
atlocation 34
printmessage 61 ; guests run away
turnflagon 16
END_COMMAND

COMMAND west
flagoff 8
atlocation 5 ; King Arthur shows up
printmessage 38
turnflagon 8
END_COMMAND

COMMAND west
flagoff 25
atlocation 53
present 310
printmessage 80
donewithturn
END_COMMAND

COMMAND south
flagoff 22
atlocation 55
printmessage 4
turnflagon 22
END_COMMAND


COMMAND south
flagoff 8
atlocation 9
printmessage 38 ; KA shows up
turnflagon 8
END_COMMAND

COMMAND south
atlocation 66
not iscarrying 202
printmessage 120
donewithturn
END_COMMAND

COMMAND south
atlocation 66
iscarrying 202
printmessage 119
wingame
gotoroom 70
donewithturn
END_COMMAND

COMMAND get chest
atlocation 31
present 308
printmessage 43
donewithturn
END_COMMAND

COMMAND get pot
atlocation 14
present 311
printmessage 13
donewithturn
END_COMMAND


COMMAND get mirror
flagon 41
atlocation 32
printmessage 70
donewithturn
END_COMMAND

COMMAND get parrot
flagoff 26 ; try to get parrot at castle
atlocation 18
present 229
printmessage 67
destroy 229
turnflagon 26
donewithturn
END_COMMAND

COMMAND get grail
atlocation 66
present 327
present 202
printmessage 121
donewithturn
END_COMMAND

COMMAND buy pot
atlocation 14
present 311
not iscarrying 207
printmessage 45
donewithturn
END_COMMAND

COMMAND buy pot
flagoff 11 ; buy pot first time
atlocation 14
present 311
iscarrying 207
printmessage 44
putincurrentroom 203
getit 203 ; pick up pot
destroy 207 ; chest
destroy 311 ; send roger away for a while
turnflagon 12
turnflagon 11
donewithturn
END_COMMAND

COMMAND give pot to knight
atlocation 25
present 312
iscarrying 203
printmessage 46
destroy 203
plusscore 43
donewithturn
END_COMMAND

COMMAND give crest to dad
redirectto show crest to dad
END_COMMAND



COMMAND say female
atlocation 76
flagoff 2
turnflagon 2
printmessage 130
donewithturn
END_COMMAND

COMMAND say male
atlocation 76
flagoff 2
turnflagon 2
turnflagon 1
printmessage 129
donewithturn
END_COMMAND


COMMAND say Boo
atlocation 25
present 312
printmessage 47
destroy 312
destroy 313
destroy 314
destroy 315
destroy 316
destroy 317
donewithturn
END_COMMAND

COMMAND say stealth bomber
flagoff 18
atlocation 68 ; in chapel
printmessage 64
printmessage 10
putincurrentroom 201 ; bring grenade
plusscore 82
turnflagon 18
donewithturn
END_COMMAND

COMMAND say BLANCMANGE
flagon 27
atlocation 53
present 310
printmessage 101
waitforreturn
printmessage 132
printmessage 145
gotoroom 76
donewithturn
END_COMMAND

COMMAND say BLANCMANGE
flagoff 27
atlocation 53
present 310
printmessage 82
turnflagon 27
waitforreturn
printmessage 132
randommessage 141 144
gotoroom 76
donewithturn
END_COMMAND

COMMAND say LUPIN
flagon 28
atlocation 53
present 310
printmessage 101
waitforreturn
printmessage 132
printmessage 145
gotoroom 76
donewithturn
END_COMMAND


COMMAND say LUPIN
flagoff 28
atlocation 53
present 310
printmessage 85
turnflagon 28
waitforreturn
printmessage 132
randommessage 141 144
gotoroom 76
donewithturn
END_COMMAND

COMMAND say LARCH
flagon 29
atlocation 53
present 310
printmessage 101
waitforreturn
printmessage 132
printmessage 145
gotoroom 76
donewithturn
END_COMMAND

COMMAND say LARCH
flagoff 29
atlocation 53
present 310
printmessage 86
turnflagon 29
waitforreturn
printmessage 132
randommessage 141 144
gotoroom 76
donewithturn
END_COMMAND

COMMAND say dostoevski
flagoff 25
atlocation 53
present 310
printmessage 102
turnflagon 25
destroy 310
donewithturn
END_COMMAND

COMMAND say yes
flagon 1
flagon 34
flagon 35
flagoff 36
atlocation 64
present 306
askquestion 5 ; ask third question
answeriscorrect
turnflagon 36
printmessage 109
destroy 306
donewithturn
END_COMMAND

COMMAND say yes
flagoff 1
flagon 34
flagon 35
flagoff 36
atlocation 64
present 306
askquestion 6 ; ask third question
answeriscorrect
turnflagon 36
printmessage 109
destroy 306
donewithturn
END_COMMAND


COMMAND say yes
flagon 34
flagoff 35
atlocation 64
present 306
askquestion 4 ; ask second question
answeriscorrect
turnflagon 35
printmessage 108
donewithturn
END_COMMAND


COMMAND say yes
flagon 1
flagoff 34
atlocation 64
present 306
askquestion 2 ; ask first question
answeriscorrect
printmessage 107
turnflagon 34
donewithturn
END_COMMAND

COMMAND say yes
flagoff 1
flagoff 34
atlocation 64
present 306
askquestion 3 ; ask first question
answeriscorrect
printmessage 107
turnflagon 34
donewithturn
END_COMMAND

COMMAND say any
atlocation 64
present 306
printmessage 106
waitforreturn
printmessage 132
gotoroom 76
donewithturn
END_COMMAND


COMMAND say any
printmessage 103
donewithturn
END_COMMAND


COMMAND look in mirror
flagon 1
flagon 41
atlocation 32
printmessage 68
donewithturn
END_COMMAND

COMMAND look in mirror
flagoff 1
flagon 41
atlocation 32
printmessage 69
donewithturn
END_COMMAND

COMMAND feed turkey
redirectto drop seed
END_COMMAND

COMMAND feed parrot
redirectto drop seed
END_COMMAND


COMMAND drop seed
flagon 26
present 333
iscarrying 227
printmessage 84
destroy 333
destroy 227
donewithturn
END_COMMAND


COMMAND drop seed
atlocation 42
present 318 ; chicken here
iscarrying 227 ; do you even have the feed?
printmessage 72 ; drops food, beast leaves
destroy 318
dropit 227
donewithturn
END_COMMAND

COMMAND throw dynamite
flagon 21
atlocation 46
present 309
iscarrying 201
printmessage 74
swaplocations 309 217
destroy 201
donewithturn
END_COMMAND


COMMAND throw dynamite
flagoff 21
atlocation 46
present 309
iscarrying 201
printmessage 76
dropit 201
donewithturn
END_COMMAND

COMMAND count to four
printmessage 75
turnflagon 21
donewithturn
END_COMMAND

COMMAND count to seven
printmessage 124
donewithturn
END_COMMAND

COMMAND read sign
atlocation 76
printmessage 125
donewithturn
END_COMMAND


COMMAND read inscription
atlocation 67
printmessage 77
donewithturn
END_COMMAND

COMMAND read inscription
atlocation 51
printmessage 78
donewithturn
END_COMMAND

COMMAND read inscription
atlocation 56
printmessage 79
donewithturn
END_COMMAND

COMMAND panic
printmessage 87
donewithturn
END_COMMAND

COMMAND examine self in mirror
atlocation 32
redirectto look in mirror
donewithturn
END_COMMAND



COMMAND examine skaters
flagon 31
atlocation 39
variableequals 4 0
printmessage 88
addtovariable 4 1
donewithturn
END_COMMAND

COMMAND examine skaters
flagon 31
atlocation 39
variableequals 4 1
printmessage 88
addtovariable 4 1
donewithturn
END_COMMAND

COMMAND examine skaters
flagon 31
atlocation 39
variablelt 5 4
printmessage 88
donewithturn
END_COMMAND


COMMAND examine skaters
atlocation 39
printmessage 99
donewithturn
END_COMMAND



COMMAND examine letters
flagon 31
variablegt 5 4
atlocation 39
printmessage 89
addtovariable 5 1
donewithturn
END_COMMAND

COMMAND examine letters
flagon 31
variableequals 5 4
atlocation 39
printmessage 98
addtovariable 5 1
donewithturn
END_COMMAND


COMMAND examine letters
flagon 31
variableequals 5 3
atlocation 39
printmessage 97
addtovariable 5 1
donewithturn
END_COMMAND


COMMAND examine letters
flagon 31
variableequals 5 2
atlocation 39
printmessage 96
addtovariable 5 1
donewithturn
END_COMMAND


COMMAND examine letters
flagon 31
variableequals 5 1
atlocation 39
printmessage 95
addtovariable 5 1
donewithturn
END_COMMAND

COMMAND examine letters
flagon 31
variableequals 5 0
atlocation 39
variablegt 4 0
printmessage 94
addtovariable 5 1
donewithturn
END_COMMAND

COMMAND examine tapestry in mirror
atlocation 32
flagon 41
present 204
printmessage 92
donewithturn
END_COMMAND

COMMAND examine boat
atlocation 73
printmessage 127
donewithturn
END_COMMAND

COMMAND show crest to dad
atlocation 32
iscarrying 252
not present 324
not present 325
printmessage 122
destroy 321
donewithturn
END_COMMAND

COMMAND show crest to dad
atlocation 32
iscarrying 252
present 324
present 325
printmessage 123
donewithturn
END_COMMAND

COMMAND enter boat
atlocation 72
present 246
printmessage 114
movethegroup 0
sendtoroom 246 74
gotoroom 73
donewithturn
END_COMMAND

COMMAND talk to chester
present 326
printmessage 9
donewithturn
END_COMMAND

COMMAND touch any
printmessage 131
END_COMMAND

COMMAND open stand
atlocation 32
flagoff 41
turnflagon 41
END_COMMAND

COMMAND close stand
atlocation 32
flagon 41
turnflagoff 41
END_COMMMAND

