/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      djp     In real life:   David J. Picton
 *
 * Modification History
 *
 *
 * 13-Jan-03    djp     Version 2.09 rev C: bugfixes and code tidy-up
 *                      Changes in this version:
 *                      * Moved the 'extra' rooms (middle crack, octagonal
 *                        room etc.) to this file.
 *
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode.
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *                      * Added all the new rooms and decorations for the
 *                        new mode.
 * 
 * 15-Jan-05    djp     Version 3.01: bugfix release.
 *                      * The pendant-charging machine in the Zarkalon Tower 
 *                        Basement should not have a label.
 *                      * Slight corrections to the text when the player meets
 *                        the elves in the Hall of the Mountain King
 *                      * US spelling is now used consistently for 'penciled'.
 *                      * Made LOOK IN SKELETON equivalent to SEARCH
 *                        SKELETON.  Check whether the skeleton has already
 *                        been searched.
 *                      * Added 'stone' to noun list for the rock in the
 *                        Control Room.
 *                      * Corrected the text for LOOK THROUGH WINDOWS.
 *                      * Minor changes to the Green-level top-of-tower room 
 *                        description.
 *                      * Changed GreenHOMBalcony to BlueHOMBalcony and
 *                        corrected the location to Blue_Hall_Of_Mists.
 *                      * Corrected the code for searching Eldrand (nothing
 *                        should be found after the first time)
 *                      * A second clue to the whereabouts of the Control 
 *                        Room Key has been added to the Green-level Bird
 *                        Chamber (also explaining why the scrawled note
 *                        points to this room)
 *                      * Corrected the exit properties for the Blue-level
 *                        East End of Long Hall.
 *                      * (Rev. A, 17 Jan 2005) Corrected the 'kata' 
 *                        properties for the Green-level tower base and 
 *                        basement rooms.
 *
 * 12-Apr-05    djp     Version 3.10: Bugfixes and enhancements
 *                      * Adjusted the ldesc for the machine chamber to be
 *                        correct after the green pendant has been found.
 *                      * Adjustments for variant gameplay when the
 *                        player has been through the Wumpi chase scene,
 *                        then restarts the game by sitting on the 
 *                        Mountain King's throne without a crown (a
 *                        'throne mishap'.   Under these circumstances
 *
 *                        1.  The door of the Green-level Large Circular
 *                            room stays open.
 *                        2.  If the Orange Level Office has been seen in 
 *                            the glass ball, the player can enter the
 *                            access shafts via Top of Blocks.  This 
 *                            route can now be used to escape during a
 *                            Wumpi chase sequence.
 *                        3.  Once the green pendant has been obtained, the
 *                            game disallows the transportation of Wumpi
 *                            (no longer necessary.)
 *                        4.  Changes to messages about the green pendant
 *                      * A row of buttons in the Control Room permits the
 *                        player to change the lighting level in any
 *                        Large Circular Room.  Pressing the green button
 *                        disturbs the Wumpi and makes them rearrange their
 *                        beds.  (This isn't necessary in regular play
 *                        but can be useful after a throne mishap, if the
 *                        Wumpi have not been transported.)
 *                        The lighting level in large circular rooms is
 *                        now described by a floatingdecoration object.
 *                      * On_Ladder is no longer NoNPC.  The new
 *                        throwHitDest property causes the axe to drop
 *                        down to the room below if it's thrown at
 *                        dwarves.
 * 7-May-05     djp     Version 3.10 Rev. A
 *                      * Incorrect uses of 'ismoved' property changed to
 *                        'moved' (ismoved should be used for Rockfalls only)
 *                      * In the Control Room, turning a switch on or off for
 *                        a second time now has no effect. 
 *                      * Corrections to the rockfalls descriptions.
 *                      * Fixed a nasty bug affecting the Octagonal room door.
 *                        An unsuccessful attempt to unlock the door
 *                        made the game unwinnable!   The extra treasures
 *                        were added to the list but the isunlocked property
 *                        was left unset, so the next attempt to unlock the 
 *                        door would add the treasures again.
 * 16-May-05    djp     Version 3.10 Rev. B
 *                      * Fixed a bug which prevented "kata" from being used
 *                        after the Wumpi had removed their rings.      
 *                      * Changed DisplayBoards to show the first paragraph
 *                        only when they are first read. 
 *                      * Added a mention of the display boards at the east end
 *                        of the Long Hall (Blue level)
 *                      * Changed the enterRoom check for the Green-level
 *                        maintenance room (see comments).
 *                      * Added an object for Blue-level lighting.
 *                      * The plaque at the top of the Blue-level tower now
 *                        refers to pendants as medallions.
 *
 * 28-Jun-05    djp     Version 3.11: Enhancements and bugfixes
 *                      * Corrected the vocabulary for the strange machine.
 *                      * A further (optional) treasure has been added.
 *                        The door to the Green-level small room (in the
 *                        Zarkalon tower) can now be unlocked using the
 *                        damaged key.  If cave closure is in process, it
 *                        is cancelled.  The room now contains a brass
 *                        sphere which can be transmuted into an
 *                        iridium sphere.
 *                      * Changes to the descriptions associated with moving
 *                        the Octagonal Room rocks.  Simpler messages are
 *                        issued after the Wumpus has put the rocks back.
 *                      * PUT OBLONG BOX IN MACHINE now works.
 *
 * 9-Aug-05     djp     Version 3.12: Enhancements and bugfixes
 *                      * Fixed a nasty bug which could prevent the discovery
 *                        of the iron key after a 'throne mishap'.
 *                      * Changes to the methods for opening the
 *                        access shaft grilles.  Initially we don't know
 *                        whether they are locked or unlocked, so attempting
 *                        to do so should get a 'keys don't fit' message.
 *                        Opening a grille is now disallowed when it is already
 *                        open.  Trying to open a locked grille now gets
 *                        a different response if it has been oiled.
 *
 * 16-Jul-06    djp     Version 3.20: Bugfixes and extensions
 *                      * Added room properties in connection with drinking
 *                        wine.  (In particular, drinking wine not allowed
 *                        as a way to escape from Wumpi, or in difficult
 *                        areas)
 *                      * New feature in the Lower Transindection room 
 *                        (multicolored rod appears if white button pressed)
 *                      * Addition of various new 'plaque rooms' where the
 *                        rods will transport the player instantly.  (3 plaque
 *                        rooms near the Debris Room, 3 near the Octagonal
 *                        Room, and one in the Blue-level sandstone chamber.
 *                      * Addition of various White-level rooms (mainly in 
 *                        Octagonal Room area).
 *                      * Addition of phleece property to various rooms
 *                        (Octagonal room and lower plaque room at each Level)
 *                      * Provision for unlocking of elevator door switches
 *                      * Various changes to reflect the fact that
 *                        Transindection areas are now accessible without a
 *                        pendant.  (At Green level the player is prevented
 *                        from meeting the elves.  At Blue level the player
 *                        can be captured by cave security).
 *                      * Correction to the 'north' exit property of 
 *                        Green_Upper_Trans_Room.
 * 12-Nov-06    djp     Version 3.20 Rev. A - minor corrections/enhancements
 *                      * Change to the upper plaque rooms.  The rocks no
 *                        longer reappear if the player exits without the
 *                        rod - in some circumstances this could unfairly
 *                        trap the player.
 *                      * Two plaques now appear in the Green-level
 *                        Lower Transindection Room after the white button
 *                        has been pressed.   (These are the plaques which
 *                        were removed from the two plaque rooms at White
 *                        level).  Rods will work if they are spun within two
 *                        turns, and the player is wearing the broken ceramic
 *                        pendant.
 *                      * Added Magenta_Machine_Chamber to loclist of
 *                        Strange_Machine (a machine should be present at all
 *                        Transindection levels)
 * 3-Mar-07      djp    Version 3.20 Rev. B
 *                      * Corrected the kata property of White_upper_trans_room
 *                        (it skipped one Level)
 *                      * Fixed a code bug which caused a TADS crash when
 *                        the player tried to break the display case.
 * 20-Oct-07     djp    Version 3.20 Rev. C
 *                      * Improvements to room descriptions - blocked-off
 *                        door correctly described in Orange Maintenance Room
 *                        and Office, 'stones' changed to 'blocks' in
 *                        description of Green-level Lower Transindection
 *                        Room. Orange Steps made 'upclimbable'.
 *                      * Improvements in the Orange Level Office.  The
 *                        Maintenance room can now be entered from the office,
 *                        and it is possible to stand or sit on the desk.
 *                      * Objects can now be put 'through' the hole to the
 *                        Blue-level Maintenance Room.  The code for
 *                        looking through the hole has also been reworked.
 *                      * Changes to the descriptions of the lower plaque 
 *                        rooms.
 *                        Like the Red-level room, the Green-level and
 *                        Blue-level rooms are simply blocked with debris.
 *                        The white-level room has been bricked up.
 *                      * It should be possible to poke any rod into the
 *                        crevice (in the Green-level Octagonal Room), not
 *                        just the black and gray rods.  (The spinnable_rod
 *                        class is used because all rods belong to it.)
 *                      * New code for putting a spinning rod on the
 *                        Green-level bridge. If the player is wearing the
 *                        gold ring, he is transported - otherwise only the
 *                        rod goes to its destination.
 *                      * Reworked code for the Zarkalon tunnel, including
 *                        new code for throwing objects (including a spinning
 *                        rod) at the tunnel. Objects can also be put into the
 *                        tunnel from outside, and the player will be
 *                        transported if a spinning rod are carried.
 *                      * Changed the test for Large_Gold_Nugget.isIn(actor) to
 *                        isInside(actor) in all cases.
 *
 * 2-Apr-09     djp     Version 3.20 Rev. D
 *                      * Corrected the kata destination for 
 *                        Green_West_Side_Of_Fissure 
 *                      * Changed the 'east' direction from Under_Desk.  It
 *                        gave too much away about the east wall ... 
 *                      * Changed the description of Blue_Balcony when the
 *                        elevator switch is unlocked.
 *                      * Defined the hasfloor property for various rooms.
 *                        Defined a floordesc for In_Elevator.
 *                      * Corrected the description of the Orange Level Office
 *                      * Defined more adjectives for GreenBirdChamberSign
 *                      * Corrected the directions in the Blue and Green level
 *                        Tower Base rooms - the locked door should be to the 
 *                        north.
 * 21-Nov-10    djp     Version 3.21
 *                      * Corrected minor typo in DisplayCase description
 *                      * Mention of the Wumpi's rings is now made in the
 *                      * banqueting hall scene (and it is confirmed that
 *                      * the rings can transport up to 20 people)
 *
 *                      * Changed the coding for the Dots description (in
 *                        Upper Transindection Rooms) to implement the
 *                        new has_ana_extradot and has_kata_extradot
 *                        properties.
 * 
 *                      * Added new code to object 'controls' (in the Control
 *                        Room).  If switches are operated in the correct
 *                        order, it is now possible to extend the operation
 *                        of the Upper Transindection Rooms to White Level
 *                        (provided that a 'cabinet explosion' has not been
 *                        caused).  The same action turns the Control Room
 *                        and Blue-level steel cage into Transindection rooms;
 *                        this works even after the cabinet has exploded, 
 *                        allowing the player to escape. 
 *                      * Changed the description of the controls object to
 *                        refer to cabinets; changed the vocab likewise.
 *                      * Changed the directions from the top of the desk:
 *                        ne and se are no longer allowed.
 *                      * Implemented the new 'posture' property for standing
 *                        or sitting on the desk
 *                      * A new message is visible if the player looks at the
 *                        plans while standing on the desk. 
 *
 * 22-Oct-13  djp         Version 3.21A
 *                      * Correction to description when Wumpi return to the
 *                        Green-level Large Circular Room - 'find out out'
 *                        corrected to 'find out'
 *                      * Dust and Pencil Sharpenings are now visible from the 
 *                        Orange Level Office after the desk has been searched.
 *                        The ldesc has also been revised.
 *                      * The ana method for Blue_Hall_Of_Mt_King now
 *                        recognizes that you can't ascend the stairs with
 *                        the gold nugget. 
 *                      * East from Blue_Hall_Of_Mt_King made more consistent
 *                        with the red-level room (this is a different route
 *                        from the staircase, and the nugget of gold can be
 *                        carried)
 *                      * Code added to prevent the insertion of a second
 *                        oblong box into the machine.
 *                      * The floor in Green_East_Passage now has a
 *                        description.
 *                      
 */

/* This file originally contained a few additional rooms (in the region of
   the Octagonal room) which were added to the TADS port of the 551-point
   game.  Many more rooms have been added in the 701+ point extension
   game (v11).
 */

Tight_Crack_2: darkroom, CCR_dead_end_room
    game551 = true
    sdesc = "In Very Tight Crack"
    ldesc = {I();
    "%You're% in a very tight n/s crack.  To the south, it appears to
    open out into a circular chamber. ";}

    north = At_East_End_Of_Long_Hall
    south = Spiral_Staircase
    ana2 = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        concrete.  Fortunately the spell reverses itself, and you find 
        yourself back in the room. ";
        return nil;
    }
;

Spiral_Staircase: darkroom // red level
    game551 = true
    sdesc = "On a Spiral Staircase"
    ldesc = {I();
    "You're on a long spiral staircase which goes both upwards and
    downwards, although the stairs leading down are in poor repair.  A very 
    narrow opening leads north. ";
    }
    hasfloor = true // room with a floor
    passage = Tight_Crack_2
    north = Tight_Crack_2
    up = Spiral_Staircase_Top
    down = Spiral_Staircase_Blocked
    verDoCount(actor) = {"You have better things to do than count steps
        and stairs. ";}
    ana = Blue_Spiral_Staircase
;

stairdebris: floatingdecoration
    game551 = true
    sdesc = "rubble"
    ldesc = "It blocks the stairs below you. "
    dobjGen(a, v, i, p) =
    {
        if (a.isIn(Spiral_Staircase_Blocked) and v = inspectVerb) {
            return;
        }
        else if (v <> gonearVerb)
        {
            caps(); self.thedesc; " is not important. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        if (v = askVerb or v = tellVerb or v = waveVerb)return;
        self.dobjGen(a, v, d, p);
    }
    noun = 'debris' 'rubble'
    loclist = [Spiral_Staircase Spiral_Staircase_Blocked]
;

spiralStairud: fixeditem
    game551 = true
    sdesc = "spiral staircase"
    ldesc = "It's an ordinary stone-built spiral staircase. You notice
        that the way up is clear, and the stairs are in fairly good
        repair.  However, the stairs below you are worn, cracked,
        and strewn with rubble. "
    noun = 'stair' 'stairs' 'staircase'
    adjective = 'spiral' 'stone-built'
    verDoClimb(actor) = {
        "You'll have to tell me which way you want to go.";
    }
    verDoClimbup(actor) = {}
    verDoClimbdown(actor) = {}
    doClimbup(actor) = {
        actor.travelTo(self.location,&up);
    }
    doClimbdown(actor) = {
        actor.travelTo(self.location,&down);
    }
    location = Spiral_Staircase
;

Spiral_Staircase_Blocked: darkroom
    game551 = true
    sdesc = "Blocked Spiral Staircase"
    ldesc = {I();
    "The staircase below you is filled with rubble and you cannot proceed
    any further down. ";}
    hasfloor = true // room with a floor
    up = Spiral_Staircase
    ana = Blue_Spiral_Staircase_Lower
;
spiralStairu: fixeditem, upclimbable
    sdesc = "spiral staircase"
    ldesc = "It's an ordinary stone-built spiral staircase, but the
        stairs here are badly damaged and strewn with debris.  Below
        you the staircase is now completely blocked with rubble, and
        you therefore cannot proceed any further. "
    noun = 'stair' 'stairs' 'staircase'
    adjective = 'spiral' 'stone-built'
    verDoClimb(actor) = {}
    doClimb(actor) = {
        actor.travelTo(self.location,&up);
    }
    location = Spiral_Staircase_Blocked
    verDoCount(actor) = {"You have better things to do than count steps
        and stairs. ";}
;
spiralStaird: floatingdecoration, downclimbable
    sdesc = "spiral staircase"
    ldesc = "It's an ordinary stone-built spiral staircase, leading
        down. "
    noun = 'stair' 'stairs' 'staircase'
    adjective = 'spiral' 'stone-built'
    verDoClimb(actor) = {}
    doClimb(actor) = {
        actor.travelTo(self.location,&down);
    }
    loclist = [Spiral_Staircase_Top, Blue_Spiral_Staircase_Top]
    verDoCount(actor) = {"You have better things to do than count steps
        and stairs. ";}
;
Spiral_Staircase_Top: darkroom
    game551 = true
    sdesc = "At Top of Spiral Staircase"
    ldesc = {I();
    "You're at the top of a long spiral staircase. A wide opening
    leads south. ";
    }
    hasfloor = true // room with a floor
    down = Spiral_Staircase
    south = Octagonal_Room
    passage = Octagonal_Room
    ana = Blue_Spiral_Staircase_Top
;

Octagonal_Room: darkroom
    game551 = true
    isOctagonalRoom = true
    sdesc = "Octagonal Room"
    ldesc = {I();
        "You're in an a low octagonal room with cracked marble walls.  There
        were once exits in every compass direction.  Unfortunately, most of
        them are now ";
        // change of wording to draw attention to the rocks.
        if(global.game701p)
            "obstructed by falls of large rocks, all of which appear to be
            far too heavy for you to move.  The rocks block all directions 
            except the ";
        else
            "blocked by rock falls, with the exception of the passages
            to the ";
        if (self.sw != Noexit)
            "southwest, ";
        if (Rockfalls.ismoved)
            "east, north and northwest. ";
        else
            "north and northwest. ";
    }

    hasfloor = true // room with a floor
    north = Spiral_Staircase_Top
    nw = Small_Chamber
    ana = Blue_Octagonal_Room
    myhints = [Octagonhint,SteelKeyhint]
    sw = Noexit // changed dynamically
    phleece = Plaque_Room // only if bracelet is worn and player has
                          // heard how to pronounce the word
;

Rockfalls: fixeditem
    game551 = true
    sdesc = "rock falls"
    ldesc = {
        if(global.game701p) {
            if(Wumpus.ischasing) {
                "You don't have the time to do that now. ";
                return;
            }
            "The rocks block most of the passages out of this room and appear 
            to be too large to move";
            if (self.ismoved) {
                ", except for the artificial rocks which you have now 
                cleared from the east passage.  ";
            }
            else if(self.movable) {
                if(self.wasmoved) {
                    ", except for the artificial rocks which someone has
                    put back, blocking the east passage once again. ";
                }
                else {
                    ".  There's something odd about the east passage rocks, 
                    though, and a more hands-on investigation would be a good
                    idea. ";
                }
            }
            else {
                ".  You experience a sudden flash of intuition, and a strange
                sense of foreboding.  You can't yet put your finger on it, 
                but there's something odd - something not quite right - about
                the rocks blocking the east passage. Maybe you'll discover 
                more if you investigate further. "; 
                self.movable := true;
            }
        }
        else {
            "They block most of the passages out of this room and are all
            too large to move. ";
        }
    }
    noun = 'rocks' 'rockfalls' 'rock-falls' 'falls'
    adjective = 'rock' 'passage'
                'e' 'east' 'eastern'
                'w' 'west' 'western'
                'n' 'north' 'northern'
                's' 'south' 'southern'
                
    verDoSearch(actor) = {
        if (Wumpus.ischasing) {
            "You don't have the time to do that now. ";
        }
        else if (self.ismoved)
            "You see nothing else of interest. ";
    }
    verDoMove(actor) = {
        if (global.game701p) {
            if (Wumpus.ischasing)
                "You don't have the time to do that now. ";
            else if (self.ismoved)
                "You are unable to move any more of the rocks. ";
        }
        else {
            "All the rocks are too large to move. ";
        }
    }
    verDoLookunder(actor) = {self.verDoSearch(actor);}
    doLookunder(actor) = {self.doSearch(actor);}
    verDoLookin(actor) = {self.verDoSearch(actor);}
    doLookin(actor) = {self.doSearch(actor);}

    // kludge for 'move east rocks'
    verDoMoveE(actor) = {self.verDoMove(actor);}
    doMoveE(actor) = {self.doMove(actor);}

    move(actor) = {
        if(self.wasmoved)
             "Once again, you remove the light rocks and reveal the locked
             steel door. ";
        else {
             "You start to move the rocks blocking the east passage - and
             realize that you've noticed two details which previous
             adventurers seem to have missed.  Firstly, the rocks look
             a little too neat and uniform, as if someone has deliberately
             piled them up to block the passage!  Secondly, they're all
             much lighter than they appear to be. ";
             P(); I();
             "It only takes a few minutes to move the rocks, behind which
             you find a steel door.  Unfortunately it's locked. ";
        }
        // move the door into view
        Trans_Room_Door.moveInto(Octagonal_Room);

        // dynamically change the travel tables
        self.location.east := Trans_Room_Door;
        self.location.NPCexits += &east;
        self.ismoved := true;
        self.wasmoved := true;
    }
    doMove(actor) = {
        if (global.game701p)
            if(self.movable) {
                self.move(actor);
            }
            else {
                "The rocks appear to be too heavy to move. ";
            }
        else
            "The rocks are all too heavy to move. ";
    }
    doSearch(actor) = {
        if (global.game701p) {
            if(self.movable) {
                self.move(actor);
            }
            else {
                "You experience a sudden flash of intuition, and a strange
                sense of foreboding. You can't yet put your finger on it, but 
                there's something odd - something not quite right - about the 
                rocks blocking the east entrance.  Maybe you'll discover more 
                if you investigate further. ";
                self.movable := true;
            }
        }
        else
            "The rocks are too heavy to move, and you see nothing of 
            interest.";
    }
    verDoTake(actor) = {
        if(self.ismoved)
            "You're here to find treasures, not to cart around useless 
            rocks, even if they're lighter than usual. ";
        else
            "The rocks are all too large to carry. ";
    }
    location = Octagonal_Room
;

Small_Chamber: darkroom
    game551 = true
    sdesc = "Top of Ladder"
    ldesc = {I();
    "You're in a small chamber with very smooth, dark walls.  A passage
    leaves to the southeast, and a ladder leads down a vertical shaft. ";
    }
    hasfloor = true // room with a floor
    down = On_Ladder
    se = Octagonal_Room
    jump = {"I respectfully suggest that you use the ladder instead of
    jumping. "; return nil;}
    ana2 = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        concrete.  Fortunately the spell reverses itself, and you find 
        yourself back in the room. ";
        return nil;
    }
;
shaft: floatingdecoration
    game551 = true
    sdesc = "shaft"
    ldesc = "It's a vertical shaft with smooth walls. "
    noun = 'shaft'
    adjective = 'vertical' 'smooth'
    loclist = [Small_Chamber On_Ladder]
    verDoUnboard(actor) = {}
    doUnboard(actor) = {
        actor.travelTo(actor.location,&out);
    }
;
Ladder_2: fixeditem, downclimbable
    game551 = true
    sdesc = "ladder"
    ldesc = "It leads down into the shaft.  It's a little rusty, but
    you should be able to climb down it safely. "
    noun = 'ladder'
    adjective = 'iron' 'rusty'
    location = Small_Chamber
    verDoClimb(actor) = {}
    doClimb(actor) = {
        actor.travelTo(self.location,&down);
    }
;

On_Ladder: darkroom
    game551 = true
    sdesc = "On a Rusty Ladder"
    ldesc = {I();
    "You're on a rusty ladder in a vertical shaft with smooth
    walls.
    Below you the shaft opens out into a chamber with several small,
    featureless pits.  The ladder once led down into the chamber, but
    the part below you has corroded away.  You could jump
    down from here, but you wouldn't then be able to climb back up. ";
    }
    hasfloor = true // room with a floor
    down = Cloak_Pits
    jump = Cloak_Pits
    up = Small_Chamber
    // Objects dropped here will fall down to Cloak Pits, and fragile
    // items will always be broken.
    roomdroploc = Cloak_Pits
    smashdrop = true
    // Room has no floor.
    nofloor = true
    roomDrop( obj ) = {
        global.dropsilent := true;
        inherited.roomDrop( obj );
        "Dropped to the room below. ";
    }
    // thrown objects will also fall down to Cloak Pits.
    throwHitDest = Cloak_Pits
    ana2 = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        concrete.  Fortunately the spell reverses itself, and you find 
        yourself back on the ladder. ";
        return nil;
    }
;
Ladder_3: fixeditem, upclimbable
    game551 = true
    sdesc = "ladder"
    ldesc = "It leads up the shaft, and used to lead down into the
    room below.  Unfortunately the ladder below you is now badly
    corroded and unusable. "
    noun = 'ladder'
    adjective = 'iron' 'rusty' 'rusted' 'corroded'
    location = On_Ladder
    verDoClimb(actor) = {}
    doClimb(actor) = {
        actor.travelTo(self.location,&up);
    }
    verDoClimbdown(actor) = {
        "The ladder below you is too badly rusted, but you could probably
        jump down safely. ";
    }
;

Concrete: floatingdecoration
    game701p = true
    sdesc = "concrete"
    adesc = "concrete"
    noun = 'concrete'
    adjective = 'reinforced'
    ldesc = "It appears to be reinforced concrete.  It occurs to you that
        whoever put it here wanted to make sure that no-one could get 
        through. "
    loclist = [Blue_Spiral_Staircase, 
    Large_Circular_Room, Blue_Large_Circular_Room, Blue_Octagonal_Room,
    Green_Octagonal_Room, Blue_Trans_Room]
;

Blue_Spiral_Staircase: darkroom, NoNPC
    game701p = true
    analevel = 1
    sdesc = "On a Spiral Staircase (Blue level)"
    ldesc = {I();
    "You're on a long spiral staircase which goes both upwards and
    downwards.  A narrow doorway once led north, but has now been filled
    with concrete. However, you notice that the stairs leading down are
    now in better repair. ";
    }
    hasfloor = true // room with a floor
    north = {"Maybe you could get through the concrete if you attacked it
        with a pickaxe for a few weeks.  Even then, significant progress would
        be unlikely. ";} 
    up = Blue_Spiral_Staircase_Top
    down = Blue_Spiral_Staircase_Lower
    verDoCount(actor) = {"You have better things to do than count steps
        and stairs. ";}
    kata = Spiral_Staircase
    ana2 = {
        "You see a brief flash of green light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        concrete.  Fortunately the spell reverses itself, and you find 
        yourself back in the room. ";
        return nil;
    }

;

Blue_spiralStairud: floatingdecoration
    game701p = true
    sdesc = "spiral staircase"
    ldesc = "It's a stone-built spiral staircase, leading both 
        up and down.  The stairs in both directions now appear to be in good 
        repair, and are now clear of rubble. "
    noun = 'stair' 'stairs' 'staircase'
    adjective = 'spiral' 'stone-built'
    verDoClimb(actor) = {
        "You'll have to tell me which way you want to go.";
    }
    verDoClimbup(actor) = {}
    verDoClimbdown(actor) = {}
    doClimbup(actor) = {
        actor.travelTo(self.location,&up);
    }
    doClimbdown(actor) = {
        actor.travelTo(self.location,&down);
    }
    loclist = [Blue_Spiral_Staircase, Blue_Spiral_Staircase_Lower]
;

Green_Spiral_Staircase: room, NoNPC
    game701p = true
    analevel = 2
    sdesc = "On a Spiral Staircase (Green level)"
    ldesc = {I();
    "You're at the top of a wide spiral staircase.  Light streams from a
    large doorway to the north. ";
    }
    north = Green_Living_Room
    down = {
        if((Wumpi.phase < 5) and (Wumpi.phase > 0)) {
            "Maybe you could go back there later, but I wouldn't advise you
            to risk disturbing the Wumpi right now.  In fact you've made 
            them really angry, so I suggest that you find an alternative
            way out. ";
            return nil;
        }
        else
            return Green_Large_Circular_Room;
    }
    verDoCount(actor) = {"You have better things to do than count steps
        and stairs. ";}
    kata = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        rock.  Fortunately the spell reverses itself, and you find 
        yourself back on the stairs. ";
        return nil;
    }
    katamovelevel = 1
;

Green_spiralStair_top: fixeditem, downclimbable
    game701p = true
    sdesc = "spiral staircase"
    ldesc = "It's a wide stone-built spiral staircase, leading downwards. "
    noun = 'stair' 'stairs' 'staircase'
    adjective = 'spiral' 'stone-built'
    verDoClimbup(actor) = {
        "The staircase leads down. ";
    }
    doClimbdown(actor) = {
        actor.travelTo(self.location,&down);
    }
    location = Green_Spiral_Staircase
;

Blue_Spiral_Staircase_Lower: darkroom, NoNPC
    game701p = true
    analevel = 1
    sdesc = "Lower Down on a Spiral Staircase (Blue level)"
    ldesc = {I();
        "You're on a long spiral staircase which goes both upwards and
        downwards. ";
    }
    hasfloor = true // room with a floor
    up = Blue_Spiral_Staircase
    down = Blue_Large_Circular_Room
    kata = Spiral_Staircase_Blocked
    ana2 = {
        "You see a brief flash of green light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of bricks
        and rubble.  Fortunately the spell reverses itself, and you find 
        yourself back in the room. ";
        return nil;
    }
;

CircularRoomLighting: floatingdecoration
    sdesc = "lighting"
    ldesc = {self.heredesc;}
    heredesc = {
        local room := self.location;
        if (room) {
            P(); I();
            "A diffuse glow from the ceiling lights the room ";            
            if(room.lightlevel = 2)
                "brightly";
            else
                "dimly";
            ". ";
        }
    }
    loclist= [Orange_Large_Circular_Room, Large_Circular_Room,
        Blue_Large_Circular_Room, Green_Large_Circular_Room]
;

Orange_Large_Circular_Room: room, NoNPC
    game701p = true
    analevel=-1
    sdesc = "In a large circular room (Orange level)"
    ldesc = {I();
        "You're in a large circular room with smooth marble walls.
        The only exit is a set of steps leading back up to the office.  A
        passage once led east and a staircase led up, but they have been
        securely blocked with rubble. ";
    }
    hasfloor = true // room with a floor
    up = Orange_Office
    steps = Orange_Office
    east = Orange_Office
    ana = Large_Circular_Room
    lightlevel = 1
;

Orange_Steps: fixeditem, upclimbable
    game701p = true
    location = Orange_Large_Circular_Room
    sdesc = "stone steps"
    adesc = "stone steps"
    isThem = true
    ldesc = "The steps are made from a similar type of stone as the spiral
            staircases.   They lead down from the Orange Office to the
            Large Circular Room. "
    noun = 'steps'
    adjective = 'stone'
    verDoClimb(actor) = {}
    doClimb(actor) = {
        actor.travelTo(self.location.up);
    }
;

Large_Circular_Room: room, NoNPC
    game701p = true
    isolated = true // no path to main Red-level area without Transindection
    sdesc = "In a large circular room"
    ldesc = {I();
        "You're in a large circular room with smooth marble walls. The only 
        exit is a doorway leading east.  A spiral staircase
        once led upwards, but has been blocked up with reinforced concrete. ";
    }
    hasfloor = true // room with a floor
    ana = Blue_Large_Circular_Room
    kata3 = Orange_Large_Circular_Room
    east = {
        if (Wumpi.phase = 2) {
            Wumpi.phase++;
        }
        return East_Passage;
    }
    out = {return self.east;}
    exithints = [East_Passage, &east]
    lightlevel = 2 // bright, important to plot.
;

Blue_Large_Circular_Room: room, NoNPC 
    game701p = true
    analevel = 1
    sdesc = "In a large circular room (Blue level)"
    ldesc = {I();
        "You're in a large circular room with smooth marble walls. The only 
        exit is a spiral staircase leading up.
        A passage once led east, but is now blocked with concrete. ";
    } 
    hasfloor = true // room with a floor
    up = Blue_Spiral_Staircase_Lower
    kata = Large_Circular_Room
    ana2 = Green_Large_Circular_Room
    lightlevel = 1
;

Green_Large_Circular_Room: room, NoNPC
    game701p = true
    analevel = 2 
    sober = true // never allowed to drink wine here!
    sdesc = "In a large circular room (Green Level)"
    ldesc = {
        I();
        "You're in a large circular room with smooth marble walls. The 
        original staircase has been bricked up and a new, wider
        stair - about 15 feet to the right of the original - leads up.
        Around the walls you can see various portraits, display cabinets and 
        pieces of furniture. ";
    }
    hasfloor = true // room with a floor
    up = {
        if(Wumpi.phase < 3 and (greenButton.lightpushes = 0)) {
            "It would be hard to reach the staircase without stepping over
            at least one of the Wumpi.  It isn't worth the risk. ";
            return nil;
        }
        else if (Wumpi.phase = 3) {
            Wumpi.phase++;
            "As you reach the top of the stairs, you hear the sound of twenty 
            angry Wumpi coming back into the Large Circular Room.  Something
            about the acoustics of this place allows you to hear more clearly
            than you might expect ... ";         
            P(); I();
            "You hear beds being dragged across the floor, and shouts,
            recriminations and denials in a strange language - no, it's an 
            unfamiliar dialect of English!   You manage to make out a few 
            phrases - \"Can we get any dormiture without some fool playing 
            games ... \", \"I'll be tried to return to the Old Ways if I 
            find out who ... \".  Then you hear one of the Wumpi say, in 
            a loud,
            authoritative voice: \"... Let the elves know nothing about this!
            Let them \(not\) know that Eldrand's mission failed.  And they
            would best know \(naught\) about the amulet.
            Ye all know the Charter - if any Transindection amulets are 
            stoneturned, they are to be re-given to the elves undelayedly.  
            Not employed in foolish manual jests!\""; P(); I();
            "You feel a strong desire to get out of here \"undelayedly\", 
            before the Wumpi discover that you were responsible for the
            \"foolish manual jest\". ";
            P();
        }
        return Green_Spiral_Staircase;
    }
    east = NoisyDoor
    kata = {
        // If the green pendant has been obtained, don't allow the Wumpi to be
        // transported.
        if (pendant2.obtained and (Wumpi.phase < 5)) {
            "You've gotten hold of the green pendant now, so there's no need
            to transport the Wumpi again.  I suggest that you leave them
            alone. ";
            return nil;
        }
        else return Blue_Large_Circular_Room;
    }
    lightlevel = 1 //dim
;

White_Large_Circular_Room: room, NoNPC 
// Dummy room (never seen or entered, but with a lightlevel which can be
// changed by pushing the white button in the Control Room.)
    game701p = true
    analevel = 3
    hasfloor = true // room with a floor
    sdesc = "In a large circular room (White level)"
    ldesc = {I();
        "You're in a large circular room with smooth marble walls. The only 
        exit is a spiral staircase leading up.
        A passage leads east, but the far end is blocked by a solid wall
        of concrete. ";
    } 
    lightlevel = 2
;

Furniture: fixeditem
    game701p = true
    sdesc = "furniture and portraits"
    ldesc = "You can't see them very clearly in the dim light, and you can't
        examine them more closely without the risk of disturbing the Wumpi. "
    hasfloor = true // room with a floor
    location = Green_Large_Circular_Room
    noun = 'furniture' 'cabinet' 'cabinets' 'portrait' 'portraits' 'picture'
           'pictures'
;

NoisyDoor: CCR_doorway
    game701p = true
    isopen = true
    sdesc = "door"
    noun = 'door' 'hinge' 'hinges'
    noAutoOpen = true
    otherside = EndDoor
    destination = {
        local actor := getActor(&travelActor);
        if (not self.isopen) {
            self.doornoise(actor);
            return nil;
        }
        else pass destination;
    }
    doOpen(actor) = {
        if (self.isopen) pass verDoOpen;
        self.doornoise(actor);
    }
    verDoYank(actor) = {}
    doYank(actor) = {
        if(self.isopen) 
            "I'm not sure why you want to do that.  The door is open
            and I respectfully suggest that you leave it that way. ";
        else self.doornoise(actor);
    }
    verDoClose(actor) = {
        if (not self.isopen) pass verDoClose;
        "If you close the door you'll disturb the Wumpi.  I suggest you leave
        it open. ";
    }
    opencount = 0
    doornoise(actor) = {
        opencount++;
        if(opencount <= 2) {
            if(self.isoiled) {
                "You start to open the door, in the hope that the oil has 
                freed it up.  Unfortunately this is not the case; the door 
                still makes a loud creaking noise.  Furthermore, it has moved 
                by only half an inch";
            }
            else {
                "You start to open the door.  Unfortunately it makes a
                tremendous noise but only moves by a quarter of an inch";
            }
            if(actor.maxweight > 20) {
                if(mushroom.is_eaten)
                    ", despite your bulging muscles. ";
                else
                    ", despite your increased strength. ";
            }
            else
                ". ";
            P(); I();
        }
        else {
            "You'd get the door open if you tried hard enough, but you'd wake 
            all the Wumpi if you did so!  I strongly advise you to find
            another way out of here. ";
        }
    }
    location = Green_Large_Circular_Room
    doordest = Green_East_Passage
;

StoneBlocks: fixeditem, upclimbable
    game701p = true
    sdesc = "stone blocks"
    ldesc = {
        "The blocks are massive - about 3 feet high, 3 feet deep and
        5 feet wide.  You could climb the blocks ";
        if(not Orange_Office.seenit) 
            "but I'm not quite sure what you would achieve by doing so. ";
        else
            "provided that you took care not to disturb the Wumpi. ";
    }    
    heredesc = {
        P(); I();
        "The massive stone blocks have been piled up neatly against a wall,
        close to the east passage. ";
    }
    noun = 'blocks' 'block'
    adjective = 'stone' 'massive'
    doCount = {"There are six stone blocks. ";}
    location = Green_Large_Circular_Room
    verDoClimb(actor) = {}
    doClimb(actor) = {
        "You climb to the top of the blocks, trying to make as little noise
        as possible... \b";
        actor.travelTo(Top_Of_Blocks);
    }
;

Top_Of_Blocks: room, NoNPC
game701p = true
analevel = 2
sober = true // drinking is banned in this room
    sdesc = "At Top of Blocks"
    ldesc = {I();
        "You're at the top of the pile of blocks, about 15 feet off
        the ground.  ";
        if(not Orange_Office.seenit)
            "Unfortunately there doesn't seem to be a great deal to do here,
            apart from going down again. ";
        else if (not self.seendoor) {
            P(); I(); 
            "You recall the plans which you saw when you viewed the Orange
            Level Office in the glass sphere.  The access shaft entrance 
            should be around here somewhere ... ";
            P(); I();
            "You examine the wall very carefully, and your patience is
            rewarded when a section of the wall moves slightly under your
            touch.  You have discovered a cleverly-camouflaged door, leading 
            east.  Furthermore, it appears to be unlocked! ";
            self.seendoor := true;
        }
        else
            "A small door leads east. ";
    }
    hasfloor = true // room with a floor
    kata = {
        "The floor disappears from beneath your feet!  Fortunately the
        pendant seems to detect the problem and quickly transports you back to
        safety. ";
        return nil; 
    }
    east = {
        if(not Orange_Office.seenit)
            pass east; 
        else return Access_Shaft_Door;
    }
    down = Green_Large_Circular_Room
    exithints = [Access_Shaft_Door, &east]
;

StoneBlocks_2: fixeditem, downclimbable
    game701p = true
    sdesc = "stone blocks"
    ldesc =
        "The blocks are massive - about 3 feet high, 3 feet deep and
        5 feet wide.  "
    noun = 'blocks' 'block'
    adjective = 'stone' 'massive'
    doCount = {"There are six stone blocks. ";}
    location = Top_Of_Blocks
    verDoClimb(actor) = {}
    doClimb(actor) = {
        actor.travelTo(Green_Large_Circular_Room);
    }
;

Access_Shaft_Door: CCR_doorway
    game701p = true
    isopen = nil
    sdesc = "small door"
    ldesc = "It's a small and very inconspicuous door in the north wall, 
            painted the same color as the wall.  The door shows signs of 
            having been forced open in the past, and its lock is broken. "
    noun = 'door'
    adjective = 'small'
    doordest = Green_Access_Shaft
    destination = {
        local actor := getActor(&travelActor);
        actor.travelTo(inherited.destination);
        if (Wumpi.phase = 3) {
            Wumpi.phase++;
            P(); I();
            "After a short while, you hear the sound of twenty 
            angry Wumpi coming back into the Large Circular Room. ";
            P(); I();
            "Once again you hear beds being dragged across the floor, and 
            heated arguments in an unfamiliar dialect of English.
            You hear the now-familiar phrases:
            \"Can we get any dormiture without some fool playing 
            games ... \", \"I'll be tried to return to the Old Ways if I 
            find out who ... \".  Then you hear one of the Wumpi say, in 
            a loud,
            authoritative voice: \"... Let the elves know nothing about this!
            Let them \(not\) know that Eldrand's mission failed.  And they
            would best know \(naught\) about the amulet.
            Ye all know the Charter - if any Transindection amulets are 
            stoneturned, they are to be re-given to the elves undelayedly.  
            Not employed in foolish manual jests!\""; P(); I();
            "You feel a strong desire to get out of here \"undelayedly\", 
            before the Wumpi discover that you were responsible for the
            \"foolish manual jest\". ";
            P();
        }
        return nil;
    }
    location = nil // initially, then Top_Of_Blocks when glass ball has been
                   // looked in.
    otherside = Green_Access_Shaft_Door
    verDoLock(actor) = {
        "It's unlikely that you'd be able to lock the door again, even if
        you found the right key. ";
    }
    verDoLockWith(actor) = {
        self.verDoLock(actor);
    }
;


East_Passage: room, NoNPC
    game701p = true
    isolated = true // no path to main Red-level area without Transindection
    sdesc = "In a long east-west passage"
    ldesc = {I();
        "You're in a long east-west passage. Light streams in from
        the west, and there is a red glow to the east. ";
    }
    hasfloor = true // room with a floor
    ana = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        concrete.  Fortunately the spell reverses itself, and you find 
        yourself back in the passage. ";
        return nil;
    }
    east = Red_Trans_Room
    west = Large_Circular_Room
;

/* Blue_East_Passage is blocked */

Green_East_Passage: room, NoNPC
    game701p = true
    analevel = 2
    sdesc = "In a long east-west passage (Green level)"
    ldesc = {I();
        "You're in a long east-west passage.  Light streams in from the
        west and there is a green glow
        to the east.  Deep scratch marks on the floor suggest that heavy
        objects have been dragged from one end of the passage to the
        other. The west end of the passage leads through ";
        if(EndDoor.isopen) "an open door ";
        else "a closed door ";
        "into another chamber. ";
    }
    hasfloor = true // room with a floor#
    hasfloordesc = true
    floordesc = "Deep scratch marks stretch from one end of the passage to the 
                other."
    west = EndDoor
    east = Green_Trans_Room
    kata = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        concrete.  Fortunately the spell reverses itself, and you find 
        yourself back in the passage. ";
        return nil;
    }
    katamovelevel = 2
;

EndDoor: CCR_doorway
    game701p = true
    isopen = true
    sdesc = "door"
    noun = 'door'
    heredesc = {
        if((self.passcount = 1) and self.isopen) {
            P(); I();
            if (NoisyDoor.seenopened)
                "The door has now been securely wedged in the open position. ";
            else
                "You notice - with great relief - that someone has opened the
                door again.  Maybe the Wumpi like to keep this door open for
                ventilation. ";
        }
    }
    passcount = 0
    destination = {
        local dest;
        dest := inherited.destination;
        passcount++;
        // have we been this way before (then sat on the throne without a
        // crown)?
        if(Green_Tight_Crack_2.isseen and (passcount = 1)) {
             passcount := 3;
             "This time you take care not to collide with the door when 
             passing through.  To your great relief, it remains open. ";
             P();
        }
        // the door stays open when we're passing through on a second
        // occasion
        if((passcount = 1) and (Wumpi.phase < 0)) {
                 "You knock against the door as you pass through, and it 
                 closes - making a horrendous creaking sound";
             if (self.isoiled)
                 " despite the fact that you've oiled the hinges.\b";
             else
                 ".\b"; 
             P();
             NoisyDoor.setIsopen(nil);
        }
        else if(passcount = 2) {
             "This time the door has been securely wedged, and you pass 
             through the opening without making a noise.\b";
        }
        return dest;
    }
    doordest = Green_Large_Circular_Room
    location = Green_East_Passage
    otherside = NoisyDoor
    verDoClose(actor) = {
        if(not self.isopen) pass verDoClose;
        "You start to pull the door closed, and it makes a terrible creaking
        sound";
        if (self.isoiled)
            " despite the fact that you've oiled the hinges. ";
        else
            ". "; 
        "You decide to leave it open. ";
    }
;
doorwedge: fixeditem
    sdesc = "wedge"
    ldesc = "It's a simple wooden wedge, holding the door open. "
    noun = 'wedge'
    adjective = 'wooden'
    verDoTake(actor) = {
        "After all the trouble this door has caused, I respectfully suggest
        that you leave the wedge where it is. ";
    }
    verDoPutIn(actor,io) = {
        self.verDoTake(actor);
    }
    verDoMove(actor) = {
        self.verDoTake(actor);
    }
;
yellowButton: transindection_Button
    sdesc = "yellow button"
    adjective = 'yellow'
    analevel = -3
;
purpleButton: transindection_Button
    sdesc = "purple button"
    adjective = 'purple'
    analevel = -2
;
orangeButton: transindection_Button
    sdesc = "orange button"
    adjective = 'orange'
    analevel = -1
;
redButton: transindection_Button
    sdesc = "red button"
    adjective = 'red'
    analevel = 0
;
blueButton: transindection_Button
    sdesc = "blue button"
    adjective = 'blue'
    analevel = 1
;
greenButton: transindection_Button
    sdesc = "green button"
    adjective = 'green'
    analevel = 2
;
whiteButton: transindection_Button
    sdesc = "white button"
    adjective = 'white'
    analevel = 3
;
magentaButton: transindection_Button
    sdesc = "magenta button"
    adjective = 'magenta'
    analevel = 4
;


Transindection_Light: floatingdecoration, readable
    game701p = true
    sdesc = "light"
    noun = 'light' 'label'
    loclist = [Red_Trans_Room, Blue_Trans_Room, Green_Trans_Room,
               East_Passage, Green_East_Passage]
    mytrans = {
        local loc := self.location;
        if (loc = East_Passage) return Red_Trans_Room;
        else if (loc = Green_East_Passage) return Green_Trans_Room;
        else return loc;
    }
    heredesc = {
        P(); I();
        if(self.location != self.mytrans)
            "Through the east exit you can see a light on the far wall of the
            room beyond.  It is ";
        else
            "A light on the east wall is ";
        if(self.mytrans.enabled)
            "glowing brightly. ";
        else
            "dark. ";
    }     
    ldesc = {
        "The light is ";
        if(self.mytrans.enabled)
             "on. ";
        else
             "off. ";
        if(self.location = self.mytrans) {
            "A small label below the light reads \"Control Panel Enabled.\" ";
            // If the player realizes the significance of the light, he's able
            // to work out that the green-level chamber was inactive at the
            // outset.
            transindection_Button.knowgreenfail := true;
        }
        else 
            "There is a small label below the light, but you can't read it
            from here. ";
    }
    // The object is a distantitem when seen from the passage.
    dobjGen(a, v, i, p) =
    {
        if(self.location = self.mytrans) return;
        if ((v <> inspectVerb) and (v <> gonearVerb) and (v <> countVerb))
        {
            "It's too far away.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        if(self.location = self.mytrans) return;
        if (v = waveVerb or v = askVerb or v = tellVerb) return;
        self.dobjGen(a, v, d, p);
    }
;

transindection_buttons: floatingdecoration
    game701p = true
    sdesc = "buttons"
    adesc = (self.sdesc)
    isThem = true
    ldesc = {
        "The buttons are arranged in a row.  From left to right, the order is
        yellow, purple, orange, red, blue, green, white and magenta. ";
    }
    noun = 'row' 'buttons'
    loclist = [Red_Trans_Room, Blue_Trans_Room, Green_Trans_Room,
    Control_Room]
    verDoPush(actor) = {
        "Pressing random buttons isn't likely to be productive. ";
    }
;
class transindection_Button: floatingdecoration
    game701p = true
    noun = 'button'
    loclist = [Red_Trans_Room, Blue_Trans_Room, Green_Trans_Room,
    Control_Room]
    verDoPush(actor) = {
        if ((location = Control_Room) or not self.location.enabled) return;
        if((Wumpi.phase = 3) and (self.analevel < self.location.analevel)) {
            "You'd probably appear among the Wumpi if you did that! ";
        }
    }
    doPush(actor) = {
        local dest, diff, toploc := toplocation(actor), buttondest;
        local travelsave := global.travelActor;
        local nochange := nil;

        // in the Control Room, the buttons change the lighting level in the
        // relevant Large Circular Room.
        if (self.location = Control_Room) {
            local roomlist := [Orange_Large_Circular_Room,Large_Circular_Room,
            Blue_Large_Circular_Room,Green_Large_Circular_Room,
            White_Large_Circular_Room];
            local room := nil;
            self.lightpushes++;
            if ((self.analevel >= -1) and (self.analevel <= 3))
                room := roomlist[self.analevel+2];
            if (room = nil) 
                nochange := true;
            else if (room.nolightchange) 
                nochange := true;
            if (nochange) {
                // Light change disabled.
                "You hear a low beep, and a recorded voice groans into action.
                Unfortunately, it's in Elvish, so you'll have to guess what it
                means. ";
                return;
            }
            if(room.lightlevel=1) {
                room.lightlevel := 2;
                "The button lights up brightly for a few seconds. ";
            }            
            else if(room.lightlevel = 2) {
                room.lightlevel := 1;
                "The button lights up dimly for a few seconds. ";
            }
            // Wumpi dim the lighting again
            if (room = Green_Large_Circular_Room and room.lightlevel = 2) {
                // Wumpi dim the lighting then disable the light change
                // control
                room.lightlevel := 1;
                "After a few more seconds the button lights up of its own 
                accord,  glowing dimly for a short while.  ";
                if (self.lightpushes >= 3) { 
                    "You then hear a low beep.  The green
                    button flashes briefly, then a recorded voice groans into 
                    action.  Unfortunately it's in Elvish, so you'll have to 
                    guess what it means. ";
                    room.nolightchange := true;
                }
            }
            return;
        }
        if (not toploc.enabled) {
            "Nothing happens.  Your attention is drawn to the light, which
            is off.  A small label below the light reads \"Control Panel
            Enabled\". ";
            // flag to indicate that the player knows that the green-level
            // chamber was de-activated at the outset.
            if ((toploc = Green_Trans_Room))
                transindection_Button.knowgreenfail := true;
            return;
        }
        dest := self.analevel;
        if (dest < -1) dest := -1;
        if (dest > 3) dest := 3;
        diff := toploc.analevel - dest;
        if (diff < 0)
             diff := -diff;
        else if (diff = 0) {
             "Nothing happens. ";
             return;
        }
        if (diff > 1) 
            "You see the light move through a sequence of colors, 
            until ...\n";
        if (self.analevel < 0) {
            "There is a brief flash of orange light, then you feel a sickening 
            \"crunch\".  You briefly see a room completely filled with rubble,
            through which a faint orange light filters from above.  Then the
            light changes to a more reassuring red color, and you're back in
            an empty room. "; P();
            dest := 0;
        }
        else if (self.analevel > 2) {
            if(not multicolored_rod.transported) {
                "You see a brief flash of white light, then feel a sickening 
                \"crunch\", as if you've hit a solid wall of concrete.  The
                color then changes back to a reassuring green, but your
                attention is soon drawn to something else.  Three ghost-like
                objects are hanging in mid-air!  One is a rod
                (with no star on an end) and gradually solidifies before
                falling to the floor.  The other two look like plaques of some
                kind, but you can't see them clearly and they slowly fade
                toward complete invisibility. ";
                P();

                Green_Trans_Room.plaqueturn := global.turnsofar;
                multicolored_rod.moveInto(Green_Trans_Room);
                multicolored_rod.transported := true;

            }
            else {
                "You see a brief flash of white light, then feel a sickening 
                \"crunch\", as if you've hit a solid wall of concrete.  The
                light then changes to a more reassuring green color, and 
                you're back in an empty room. Once again you see the 
                plaque-like objects, and once again they fade away 
                toward complete invisibility. "; P();
                Green_Trans_Room.plaqueturn := global.turnsofar;
            }
            dest := 2;

        }
        switch(dest) {
            case 0: buttondest := Red_Trans_Room; break;
            case 1: buttondest := Blue_Trans_Room; break;
            case 2: buttondest := Green_Trans_Room; break;
            default: buttondest := toploc; break;
        }
        if (buttondest != toploc) {
            actor.roomMoveTravel(&transmove,buttondest);
        }
    }
    // flag to indicate that the player realizes that the green-level
    // Lower Transindection Chamber was de-activated.  This will usually be the
    // case if he's examined the light in any lower-level chamber, pressed a 
    // button in the green-level chamber, or visited the green-level 
    // Maintenance Room.
    knowgreenfail = nil
    // number of times the light level has been changed
    lightpushes = 0
;

class Lower_Trans_Room: room
    ldesc = {I();
        "You're in a room with a low ceiling and irregular walls.  Along
        one wall there is a row of buttons, marked yellow, purple, 
        orange, red, blue, green, white and magenta.  The room is lit by a 
        bright <<self.color>> glow from the ceiling, and a passage leads 
        west. ";
    }
    hasfloor = true // room with a floor
    out = {return self.west;}
;

Red_Trans_Room: room, Lower_Trans_Room, NoNPC
    // N.B. The controls in the Lower Transindection Rooms are active only
    // if two conditions are met.  The Maintenance Room switch must be on, and
    // the control room enable signal light must be on. 
    enabled = (Red_Level_Switch.isActive and Red_Level_Light.isActive)
    game701p = true
    isolated = true // no path to main Red-level area without Transindection
    sdesc = "Lower Transindection Chamber "
    ana = Blue_Trans_Room
    kata3 = {
        "There is a brief flash of orange light, then you feel a sickening 
        \"crunch\".  You briefly see a room completely filled with rubble,
        through which a faint orange light filters from above.  Then the
        color changes back to red, and you're in an empty room again. ";
        return nil;
    }
    west = East_Passage
    out = East_Passage
    color = 'red'
;    

Blue_Trans_Room: room, Lower_Trans_Room, NoNPC
    enabled = (Blue_Level_Switch.isActive and Blue_Level_Light.isActive)
    game701p = true
    analevel = 1
    ldesc = {
        inherited.ldesc;
        P(); I();
        "Unfortunately the west passage has been blocked with concrete. ";
    }
    sdesc = "Lower Transindection Chamber (Blue level)"
    color = 'blue'
    ana2 = Green_Trans_Room
    kata = {
        if(Wumpi.phase = 3) {
            "You'd probably appear among the Wumpi if you did that!
            I strongly suggest that travel in the opposite direction would
            be a good idea on this occasion. ";
            return nil;
        }
        else return Red_Trans_Room;
    }
    out = {
       "You'll have to tell me how to get out of here - I can't see any
       obvious exits! ";
       return nil;
    }
;

Green_Trans_Room: room, Lower_Trans_Room, NoNPC
    enabled = (Green_Level_Switch.isActive and Green_Level_Light.isActive)
    game701p = true
    analevel = 2
    ldesc = {
        inherited.ldesc;
        P(); I();
        "A massive stone wall has been built across the west wall, but
        several blocks have been removed, revealing the entrance to the
        west passage. ";
    }
    sdesc = "Lower Transindection Chamber (Green level)"
    color = 'green'
    kata = {
        if(Wumpi.phase = 3) {
            "You might appear among the Wumpi if you did that! 
            I strongly suggest that you leave this room by more conventional
            means, and make your escape as best you can. ";
            return nil;
        }
        else return Blue_Trans_Room;
    }
    
    west = Green_East_Passage
    out = Green_East_Passage
    plaqueturn = -999
    isplaqueroom = {
        local actor := getActor(&verbActor);
        if((broken_pendant.location = actor) and broken_pendant.isworn) {
            if(self.plaqueturn >= global.turnsofar - 2) {
                return true;
            }
        }
        return nil;
    }
;

StoneWall: fixeditem
    game701p = true
    sdesc = "stone wall"
    ldesc = "The stone blocks are massive - about 3 feet high, 3 feet deep and
        5 feet wide.   The blocks near the opening have been displaced,
        as if someone with superhuman strength had pushed them from the
        other side.  Six blocks have been completely removed. "
    location = Green_Trans_Room
    noun = 'wall' 'blocks' 'block'
    adjective = 'stone' 'massive'
;
spiralStaircirc: fixeditem
    sdesc = "spiral staircase"
    ldesc = "The entrance to the staircase is completely blocked with
        concrete.  You also know that tons of rubble lie above the concrete.  
        You're sure of one thing - someone didn't want you to find this 
        room. "
    noun = 'stair' 'stairs' 'staircase'
    adjective = 'spiral' 'stone-built'
    location = Large_Circular_Room
    verDoCount(actor) = {"You have better things to do than count steps
        and stairs. ";}
;
Blue_spiralStaircirc: fixeditem, upclimbable
    sdesc = "spiral staircase"
    ldesc = "It's an ordinary stone-built spiral staircase, leading up. "
    noun = 'stair' 'stairs' 'staircase'
    adjective = 'spiral' 'stone-built'
    verDoClimb(actor) = {}
    doClimb(actor) = {
        actor.travelTo(self.location,&up);
    }
    location = Blue_Large_Circular_Room
    verDoCount(actor) = {"You have better things to do than count steps
        and stairs. ";}
;
Green_spiralStair_bot: fixeditem, upclimbable
    sdesc = "spiral staircase"
    ldesc = "It looks like the other spiral staircases you've seen, but is
        considerably wider. "
    noun = 'stair' 'stairs' 'staircase'
    adjective = 'spiral' 'stone-built'
    verDoClimbdown(actor) = {
        "The stairs lead up. ";
    }
    verDoClimb(actor) = {}
    doClimb(actor) = {
        actor.travelTo(self.location,&up);
    }
    location = Green_Large_Circular_Room
    verDoCount(actor) = {"You have better things to do than count steps
        and stairs. ";}
;

Blue_Spiral_Staircase_Top: darkroom, NoNPC
    analevel = 1
    game701p = true
    sdesc = "At Top of Spiral Staircase (Blue level)"
    ldesc = {I();
    "You're at the top of a long spiral staircase. A wide opening
    leads south. ";
    }
    down = Blue_Spiral_Staircase
    south = Blue_Octagonal_Room
    passage = Blue_Octagonal_Room
    kata = Spiral_Staircase_Top
    ana2 = {
        "You see a brief flash of green light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of bricks
        and rubble.  Fortunately the spell reverses itself, and you find 
        yourself back in the room. ";
        return nil;
    }
;

Blue_Octagonal_Room: darkroom, NoNPC
    analevel = 1
    game701p = true
    isOctagonalRoom = true
    sdesc = "Octagonal Room (Blue level)"
    ldesc = {I();
        "You're in an a low octagonal room with cracked marble walls.  There
        were once exits in every compass direction.  Unfortunately, most of
        them are now blocked by rock falls, with the exception of the passages
        to the north";
        if (self.sw != Noexit)
            ", southwest";
        if (Blue_Trans_Room_Door.isopen)
            ", east and northwest. ";
        else
            " and northwest. ";
        "However, the passage to the northwest has been blocked off with 
        reinforced concrete. ";
    }
    hasfloor = true // room with a floor
    north = Blue_Spiral_Staircase_Top
    east = Blue_Trans_Room_Door
    kata = Octagonal_Room
    ana2 = Green_Octagonal_Room
    sw = Noexit // changed dynamically
    phleece = Blue_Plaque_Room // only if bracelet is worn and player has
                               // heard how to pronounce the word
;

Green_Octagonal_Room: darkroom, NoNPC
    analevel = 2
    game701p = true
    isOctagonalRoom = true
    sdesc = "Octagonal Room (Green level)"
    ldesc = {I();
        "You're in an a low octagonal room with cracked marble walls.  There
        were once exits in every compass direction.  Unfortunately, some of
        them are now blocked by rock falls, with the exception of the passages
        to the north, west, east";
        if (self.sw != Noexit)  
            ", southwest";
        " and northwest.   The entrance to the west
        passage shows signs of recent repairs, but the north and northwest
        exits have both been filled with concrete. ";
    }
    hasfloor = true // room with a floor
    east = Green_Trans_Room_Door
    west = Green_Control_Door
    kata = Blue_Octagonal_Room
    sw = Noexit // changed dynamically
    phleece = Green_Plaque_Room // only if bracelet is worn and player has
                                // heard how to pronounce the word
;

White_Octagonal_Room: darkroom, NoNPC
    analevel = 3
    game701p = true
    isOctagonalRoom = true
    sdesc = "Octagonal Room (White level)"
    ldesc = {I();
        "You're in an a low octagonal room with cracked marble walls.  
        There were once exits in every compass direction, but they are 
        now blocked by rockfalls, with the exception of the ";
        if(self.sw != Noexit)
            "passages to the east and southwest.";
        else
            "passage to the east. ";
    }
    hasfloor = true // room with a floor
    kata = Green_Octagonal_Room
    east = White_Trans_Room_Door
    sw = Noexit // changed dynamically
    phleece = White_Plaque_Room // only if bracelet is worn and player has
                                // heard how to pronounce the word
;

Green_Banqueting_Room: room, NoNPC // seen only in the glass ball
    analevel = 2
    sdesc = "Banqueting Hall (Green level)"
    ldesc = {I();
        // Add a check if (after sitting on the throne) the player has managed
        // get out of the Wumpi room without transporting the Wumpi.
        if((global.seenelves or topaz.moved) and (Wumpi.phase > 0)) {
             "You are in a long southeast-northwest chamber with a 
             freshly-swept floor and a highly-polished table along most of its
             length.  Freshly-painted doors (now open) lead out of the 
             southeast end, and a doorway leads northwest to a blocked 
             passage.  You somehow know that it leads to the Octagonal 
             Room.  ";
 
             if (not self.seenelves and not global.closed) {
                 P(); I(); 
                 "Several elves are sitting at the table,
                 consulting old plans.  They show the area of the Octagonal
                 Room, including the rooms you have seen.  Despite the fact
                 that they are written in Elvish, you can understand the
                 words - there are familiar rooms like the Upper Transindection
                 Chamber as well as kitchens, living quarters, libraries etc.
                 You hear a lively discussion in the strange version of
                 English which you heard earlier - but this time
                 you can understand every word. ";
                 P(); I(); 
                 "You hear that King Ondral is to be asked to part with a
                 few more gold pieces, in return for which the Wumpi will
                 clear any obstacles between this room and the Upper 
                 Transindection Chamber.  Then the 
                 truth about Eldrand's mission will be revealed.  If the
                 Upper Chamber is still active, an invasion force is to be
                 mustered without delay.  The invasion can probably be speeded
                 up if the Wumpi's gold rings can be obtained; it is said that
                 they can transport up to 20 people at a time! ";
                 P(); I();
                 if (Green_Upper_Trans_Room.isdotroom) 
                     "You shudder at the realization that the elves will
                     almost certainly start with an invasion of Red level.
                     You will have to find a way to complete Eldrand's 
                     mission - at the very least, the Upper Transindection
                     Room must be disabled! ";
                 else
                     "You feel a sense of relief - having disabled the
                     Upper Transindection Rooms, you have probably saved
                     Red level! ";
                 self.seenelves := true;
             }
             else {
                 if(global.closed) {
                     "There are about ten Wumpi in the room, dragging large
                     rocks out of the blocked passage and carrying them through
                     the southeast passage.  This is not good news! ";
                 }
                 else {
                     "The elves have now left.  The chairs have been stacked 
                     against one wall, and the table moved to the other side of
                     the room, possibly in preparation for the clearance of the
                     passage.  ";
                 }
             }
        }
        else {
            "You are in a long southeast-northwest chamber with a banqueting
            table along most of its length.  Doors (closed) lead out of the
            southeast end, and an open doorway leads northwest.  Unfortunately
            the passage beyond the northwest end has been blocked by a 
            rock-fall, but somehow you know that it would lead to the Octagonal
            Room. ";
            P(); I(); 
            "The room looks just as it did before the elves abandoned it, many
            years ago.   The polished surface of the table, the freshly-swept 
            floor, the neatly-arranged chairs, and the freshly-painted doors
            at the southeast end.  And yet ... ";
            P(); I();
            "It's far \(too\) clean and tidy.  The floor \(has\) been 
            recently swept, right up to the rockfall. The paint on the  
            southeast doors \(is\) fresh. ";
        }
    }
    hasfloor = true // room with a floor
;

Trans_Room_Door: fixeditem, CCR_lockableDoorway
    game701p = true
    sdesc = "steel door"
    mykey = transindection_key
    externalDoor = nil
    ldesc = {
        "It's a heavily reinforced steel door.  ";
        if(not self.isunlocked) {
            "Your attention is drawn
            to the complex shape of the keyhole - if you found the key, 
            you'd probably recognize it. ";
        }
    }
    doordest = Upper_Trans_Room
    otherside = Trans_Room_Door_Inner
    location = nil
    heredesc = {P(); I();
        if(self.islocked) 
             "The east passage is barred by a locked steel door. ";
        else
             "The east passage leads through a steel door. ";
    }
    noun = 'door'
    adjective = 'steel'
    doUnlockWith(actor,io) = {
        inherited.doUnlockWith(actor,io);
        if (not self.isunlocked and not self.islocked) {
            // flag that the door has been unlocked.
            self.isunlocked := true;            
            // add the transindection-area treasures to the list of treasures
            // to be found, to prevent premature cave closure.
            global.treasures += length(global.bonustreasures);
            global.treasures_to_find += global.bonustreasures;
            // exclude two optional treasures
            global.treasures -= 2;
            global.treasures_to_find -= iridium_sphere;
            global.treasures_to_find -= platinum_bars;
            if (global.closure)
                cancel_cave_closure(nil);
        }
    }
;

Trans_Room_Door_Inner: fixeditem, CCR_lockableDoorway
    game701p = true
    sdesc = "steel door"
    mykey = transindection_key
    externalDoor = nil
    ldesc = "It's a heavily reinforced steel door. "
    doordest = Octagonal_Room
    otherside = Trans_Room_Door
    location = Upper_Trans_Room
    heredesc = {P(); I();
        if(self.islocked) 
             "The west passage is barred by a locked steel door. ";
        else
             "The west passage leads through a steel door. ";
    }
    noun = 'door'
    adjective = 'steel'
;

Blue_Trans_Room_Door: CCR_lockableDoorway
    sdesc = "steel door"
    mykey = transindection_key
    externalDoor = nil
    otherside = nil
    islocked = nil
    ldesc = {
        "It's a heavily reinforced steel door. ";
        if (self.isopen)
             "Unfortunately, it doesn't lead anywhere, due to the rockfall
             on the other side. ";
    }
    destination = {
        inherited.destination;
        if (self.isopen) {
            I();
            "The passage beyond the door is blocked by a rockfall. ";
        }
        return nil;
    }
    doordest = nil
    // The lock of this door is damaged, and only rocks lie between
    // lie Blue_Octagonal_Room and Blue_Upper_Trans_Room.  The
    // Wumpi would be able to move them without any difficulty.
    doLockWith(actor,io) = {
        if(io <> self.mykey) pass doLockWith;
        else
            "The key won't turn.  The lock mechanism shows signs of damage;
            it is hard to say whether this was caused by the rock-fall, or
            someone forcing open the door. ";
    }
    location = Blue_Octagonal_Room
    heredesc = {P(); I();
        if(self.islocked) 
             "The east passage is barred by a locked steel door. ";
        else if (self.isopen)
             "The passage to the east leads through a steel door, but has
             been blocked by a rockfall on the far side of the door. ";
        else
             "The east passage leads through a steel door. ";
    }
    noun = 'door'
    adjective = 'steel'
    doOpen(actor) = {
        inherited.doOpen(actor);
        "Unfortunately, the passage beyond the door has been blocked by a
        rock fall. ";
    }
;

Green_Trans_Room_Door: fixeditem, CCR_lockableDoorway
    game701p = true
    sdesc = "east door"
    mykey = transindection_key
    externalDoor = nil
    ldesc = "It's a heavily reinforced steel door. "
    doordest = Green_Upper_Trans_Room
    otherside = Green_Trans_Room_Door_Inner
    location = Green_Octagonal_Room
    heredesc = {P(); I();
        if(self.islocked) 
             "The east passage is barred by a locked steel door. ";
        else
             "The east passage leads through a steel door. ";
    }
    noun = 'door'
    adjective = 'steel' 'east'
;

Green_Trans_Room_Door_Inner: fixeditem, CCR_lockableDoorway
    game701p = true
    sdesc = "west door"
    mykey = transindection_key
    externalDoor = nil
    ldesc = {
        "It's a heavily reinforced steel door. ";
        if(not self.isunlocked) {
            "Your attention is drawn
            to the complex shape of the keyhole.  It looks as if your steel
            key may fit this door as well. ";
        }
    }
    doordest = Green_Octagonal_Room
    otherside = Green_Trans_Room_Door
    location = Green_Upper_Trans_Room
    heredesc = {P(); I();
        if(self.islocked) 
             "The west passage is barred by a locked steel door. ";
        else
             "The west passage leads through a steel door. ";
    }
    noun = 'door'
    adjective = 'steel' 'west'
;

Green_Control_Door: CCR_lockableDoorway, readable
    game701p = true
    sdesc = "control room door"
    mykey = iron_key // from Orange level office
    externalDoor = nil
    ldesc = {
        "It's a heavily reinforced steel door, marked \"Control Room 
        Access\". ";
    }
    doordest = Green_Steel_Cage
    otherside = Green_Control_Door_Inner
    heredesc = {P(); I();
        if(self.islocked) 
             "The west passage is barred by a locked steel door marked ";
        else
             "The west passage leads through a steel door marked ";
        "\"Control Room Access\". ";
    }
    noun = 'door'
    adjective = 'control' 'room' 'west' 'steel'
    location = Green_Octagonal_Room
;

Green_Control_Door_Inner: CCR_lockableDoorway
    game701p = true
    sdesc = "control room door"
    mykey = iron_key // from Orange level office
    externalDoor = nil
    ldesc = "It's a heavily reinforced steel door. "
    doordest = Green_Octagonal_Room
    otherside = Green_Control_Door
    heredesc = {P(); I();
        if(self.islocked) 
             "The east passage is barred by a locked steel door. ";
        else
             "The east passage leads through a steel door. ";
    }
    noun = 'door'
    adjective = 'control' 'room' 'east'
    location = Green_Steel_Cage
;

White_Trans_Room_Door: fixeditem, CCR_lockableDoorway
    game701p = true
    sdesc = "east door"
    mykey = transindection_key
    externalDoor = nil
    ldesc = "It's a heavily reinforced steel door. "
    doordest = White_Upper_Trans_Room
    otherside = White_Trans_Room_Door_Inner
    location = White_Octagonal_Room
    heredesc = {P(); I();
        if(self.islocked) 
             "The east passage is barred by a locked steel door. ";
        else
             "The east passage leads through a steel door. ";
    }
    noun = 'door'
    adjective = 'steel' 'east'
;

White_Trans_Room_Door_Inner: fixeditem, CCR_lockableDoorway
    game701p = true
    sdesc = "west door"
    mykey = transindection_key
    externalDoor = nil
    ldesc = {
        "It's a heavily reinforced steel door. ";
        if(not self.isunlocked) {
            "Your attention is drawn
            to the complex shape of the keyhole.  It looks as if your steel
            key may fit this door as well. ";
        }
    }
    doordest = White_Octagonal_Room
    otherside = White_Trans_Room_Door
    location = White_Upper_Trans_Room
    heredesc = {P(); I();
        if(self.islocked) 
             "The west passage is barred by a locked steel door. ";
        else
             "The west passage leads through a steel door. ";
    }
    noun = 'door'
    adjective = 'steel' 'west'
;

Translevel_Rockfalls: floatingdecoration
    game701p = true
    sdesc = "rock falls"
    ldesc = {
        if(self.location = Control_Room) {
            "They're on the floor, near the center of the room.  Most of them
            are too large to move. ";
            return;
        }
        "They block the passages to the northeast, ";
        if (self.location = Blue_Octagonal_Room) {
            if (Blue_Trans_Room_Door.isopen) {
                "east, ";
            }
            "west, ";
        }
        "southeast, south and southwest. ";
        if(Wumpi.phase = 1) {
            "However, you have no doubt that the Wumpi could unblock all
            these passages within a few minutes, gaining access to the
            Transindection Chamber and maybe other rooms as well.
            You'd be well advised to transport the Wumpi again, for all our
            sakes! ";
        }
    }
    noun = 'rocks' 'rockfalls' 'rock-falls' 'falls'
    adjective = 'rock'
    verDoMove(actor) = {
        if(self.location.analevel >= 2)
             return;
        "The rocks are all too large to move, and you find nothing of
        interest. ";
        if(Wumpi.phase = 1) {
            "However, you have no doubt that the Wumpi could remove them
            in no time at all.  You'd be well advised to transport the
            Wumpi out of Blue level as soon as possible. ";
        }
    }
    doMove(actor) = {
        if(self.location.analevel=3) {
            self.doMove3(actor);
            return;
        }
        if(self.searched)
            "The rocks are all too large to move.  You look again at the
            tiny scrap of paper, and confirm that it appears to bear the
            cryptic word \"OSAL\", but there is nothing else of interest. ";
        else {
            "The rocks are all too large to move, and you find nothing of 
            interest except for a tiny scrap of paper in a crevice between
            two rocks.  The paper is too far down for your fingers to 
            reach, but you can see that it bears a cryptic word: 
            \"OSAL\".  ";
            self.searched := true;
            tinypaper.moveInto(self.location);
            Crevice.moveInto(self.location);
        }
    }
    doMove3(actor) = {
        if(self.searched3)
            "A few of the smaller rocks can be moved, but you find nothing
            else of interest. ";
        else {
            "A few of the smaller rocks can be moved, and you find something - 
            a plain, and rather battered, copper bracelet.  Somehow you sense
            that it's not quite as uninteresting as it looks, and you slip
            it onto your wrist. ";
            self.searched := true;
            copper_bracelet.moveInto(actor);
            copper_bracelet.isworn := true;
        }
    }
    verDoLookunder(actor) = {self.verDoSearch(actor);}
    doLookunder(actor) = {self.doSearch(actor);}
    verDoLookin(actor) = {self.verDoSearch(actor);}
    doLookin(actor) = {self.doSearch(actor);}
    verDoTake(actor) = {
        "The rocks are all too large to carry. ";
    }
    verDoSearch(actor) = {self.verDoMove(actor);}
    doSearch(actor) = {self.doMove(actor);}
    loclist = [Blue_Octagonal_Room, Green_Octagonal_Room, White_Octagonal_Room,
    Control_Room]
;

class dotroom: object // allows transindection verbs without a pendant
    isdotroom = true
    hasfloor = true // room with a floor
;

tinypaper: fixeditem, readable
    sdesc = "tiny scrap of paper"
    ldesc = "It's no larger than a postage stamp.  Although it's too far down
        for your fingers to reach it, you can read the word which is written
        on it: \"OSAL\".  As for what it means, your guess is as good as
        mine ... "
    verDoTake(actor) = {"It's too far down for your fingers to reach. ";}
    noun = 'scrap' 'paper'
    adjective = 'tiny'    
    location = nil
    
;

Crevice: fixeditem
    sdesc = "crevice"
    ldesc = "It's a narrow gap between two rocks. Near the bottom of the
        crevice, out of reach, you see a tiny scrap of paper bearing the
        word \"OSAL\". "
    verDoLookin(actor) = {}
    doLookin(actor) = {ldesc;}
    verDoSearch(actor) = {}
    doSearch(actor) = {ldesc;}
    verIoPutIn(actor) = {}
    ioPutIn(actor,dobj) = {
         if(isclass(dobj,spinnable_rod) or (dobj = pole) 
         or (dobj = whiskbroom)) {
              "You attempt to remove the tiny piece of paper by poking
              <<dobj.thedesc>> into the crack, but you only succeed in pushing
              it further down.  However, you can still read the word which it
              bears: \"OSAL\". ";
         }
         else
              "I somehow don't think you'd achieve anything
              by trying to poke <<dobj.adesc>> into the crevice. ";
    }
    noun='crevice' 'crack' 'gap'
    location = nil
  
;
Dots: floatingdecoration
    game701p = true
    sdesc = "floor dots"
    adesc = {self.sdesc;}
    // the ldesc method for the dots is a simplified version of the
    // pendant ldesc method.  (Transindection is possible as if all 
    // pendants are worn.)
    heredesc = {
        if((self.location = Green_Upper_Trans_Room) and self.location.isdotroom
        and self.location.has_ana_extradot and (not 
        self.location.seenextradot)) {
            if (self.location.isseen) 
                "You notice something different about the floor.  Something
                you did in the control room has changed the dots - there's 
                now a white dot, to the right of the green dot! ";
            self.location.seenextradot := true;   
        }
        if((self.location = White_Upper_Trans_Room) and self.location.isdotroom
        and (not self.location.seenextradot)) {
            if (self.location.isseen) 
                "You notice that there are now two dots on the floor!  
                Something you did in the control room has activated this 
                room. ";
            self.location.seenextradot := true;   
        }
        if(self.location.isdotroom or (self.location = White_Upper_Trans_Room))
            return;
        P(); I();
        "You notice that the floor is now completely featureless.  The dots
        have disappeared! ";
    }
    anaproplist = [&ana, &ana2, &ana3]
    kataproplist = [&kata, &kata2, &kata3]
    ldesc = {
        local actor := getActor(&verbActor); 
        local toploc := toplocation(actor);
        local ndots := 1;
        local i, l, anaprop, kataprop, lowdot, highdot;
        local middledot := toploc.analevel;
        if(not self.location.isdotroom) {
            if(self.location = White_Upper_Trans_Room)
                "The floor is completely featureless. ";
            else
                "The floor is now completely featureless - the dots have 
                disappeared! ";
            return;
        }
        if (room.transclass = nil)
            room.transclass := defined(room, &kata, DEFINED_GET_CLASS); 
        l := length(anaproplist);
        for (i := 1; i <= l; i++) {
            anaprop := anaproplist[i];
            kataprop := kataproplist[i];
        
            if (defined(toploc,kataprop,DEFINED_GET_CLASS) <> 
            room.transclass) {
                lowdot := toploc.analevel - 1;
            }
            if (toploc.has_kata_extradot)
                lowdot := toploc.analevel - 1;
            if (defined(toploc,anaprop,DEFINED_GET_CLASS) <> 
            room.transclass) {
                highdot := toploc.analevel + 1;
            }                        
            if (toploc.has_ana_extradot)
                highdot := toploc.analevel + 1;
        }
        if (lowdot <> nil) ndots++;
        if (highdot <> nil) ndots++;
        switch(ndots) {
            case 1:
                "You see a single ";
                say (transindection_color(middledot));
                " dot with a circle around it. ";
                break;
            case 2:
                "You see two dots colored ";
                if (lowdot <> nil) {
                    say (transindection_color(lowdot));
                    " and ";
                    say (transindection_color(middledot));
                }
                else {
                    say (transindection_color(middledot));
                    " and ";
                    say (transindection_color(highdot));
                }
                ". There is a circle around the ";
                say (transindection_color(middledot)); 
                " dot. ";
                break;
            case 3:
                "You see three dots colored ";
                say (transindection_color(lowdot));
                ", ";
                say (transindection_color(middledot));
                " and ";
                say (transindection_color(highdot));
                ". There is a circle around the ";
                say (transindection_color(middledot));
                " dot. ";
                break;
        }
    }
    doCount(actor) = {self.ldesc;}
    noun = 'dots'
    adjective = 'floor'   
    loclist = [Upper_Trans_Room, Blue_Upper_Trans_Room, Green_Upper_Trans_Room,
              White_Upper_Trans_Room]
;
Upper_Trans_Room: darkroom, dotroom
    game701p = true
    isUpperTransRoom = true
    sdesc = {
        if(crumpled_sheet.isread or Blue_Upper_Trans_Room.isseen) 
            "Upper Transindection Chamber";
        else 
            "Empty Chamber";
    }
    ldesc = {I();
        if(self.isdotroom)
             "You're in a small, empty chamber, devoid of interest except for 
             two colored dots on the floor, one red and one blue.  The red dot
             is circled. ";
        else /* de-activated */
             "You're in a small, empty chamber, devoid of interest.  ";
        "A passage leads west. ";
    }
    hasfloor = true
    hasfloordesc = true
    floordesc = {Dots.ldesc;}
    west = Trans_Room_Door_Inner
    out = {return self.west;}
    ana = Blue_Upper_Trans_Room
    version_NoNPCs = (not Rockfalls.ismoved)
    NPCexit1 = Octagonal_Room // needed in case player locks door.
    north = Noexit // changed dynamically
;

Blue_Upper_Trans_Room: darkroom, dotroom, NoNPC
    analevel = 1
    game701p = true
    isUpperTransRoom = true
    sdesc = "Upper Transindection Chamber (Blue level)"
    ldesc = {I();
        if(self.isdotroom)
             "You're in a small chamber, devoid of interest except for three
             dots on the floor, colored red, blue and green.  The blue dot is
             circled.  ";
        else /* de-activated */
             "You're in a small, empty chamber, devoid of interest.  ";
        "A passage once led west, but has been blocked by a 
        rock-fall. ";
    }
    hasfloordesc = true
    floordesc = {Dots.ldesc;}
    kata = Upper_Trans_Room
    ana2 = Green_Upper_Trans_Room
    north = Noexit // changed dynamically
;

Blue_Upper_Trans_Room_Rockfalls: fixeditem, searchHider
    game701p = true
    sdesc = "rock falls"
    ldesc = "The rocks block the passage to the west.  Some of the them look
        small enough to move, although it won't be possible to unblock
        the passage this time. "
    noun = 'rocks' 'rockfalls' 'rock-falls' 'falls' 'passage'
    adjective = 'rock'
    verDoTake(actor) = {
        "You're here to find treasures, not to carry useless rocks and 
        rubble. ";
    }
    verDoMove(actor) = {self.verDoSearch(actor);}
    doMove(actor) = {self.doSearch(actor);}
    verDoLookunder(actor) = {self.verDoSearch(actor);}
    doLookunder(actor) = {self.doSearch(actor);}
    verDoLookin(actor) = {self.verDoSearch(actor);}
    doLookin(actor) = {self.doSearch(actor);}
    location = Blue_Upper_Trans_Room
;

Green_Upper_Trans_Room: darkroom, dotroom, NoNPC
    game701p = true
    analevel = 2
    isUpperTransRoom = true
    sdesc = "Upper Transindection Chamber (Green level)"
    ldesc = {I();
        if(self.isdotroom) {
            if(self.has_ana_extradot)    
                "You're in a small chamber, devoid of interest except for three
                colored dots on the floor, colored blue, green and white.
                The green dot is circled. ";
            else
                "You're in a small chamber, devoid of interest except for two
                colored dots on the floor, one blue and one green.  The green 
                dot is circled. ";
        }
        else /* de-activated */
            "You're in a small, empty chamber, devoid of interest.  ";
        "A passage leads west. ";
    }
    hasfloordesc = true
    floordesc = {Dots.ldesc;}
    kata = Blue_Upper_Trans_Room
    has_ana_extradot = nil
    ana_extradot = White_Upper_Trans_Room
    west = Green_Trans_Room_Door_Inner
    out = {return self.west;}
    north = Noexit // changed dynamically
    listendesc = {
        if((Wumpi.phase > 0) and global.closed) {
            "You hear noises from the southeast passage, as if large rocks
            are being moved out of the way. ";
            if(Green_Banqueting_Room.seenelves) 
                if (Green_Upper_Trans_Room.isdotroom)
                    "I have a very bad feeling about this.  The glass ball
                    showed you the Banqueting Hall to the southeast, and
                    you saw the elves' discussion.  They'll be here soon, 
                    and then we'll all be in *real* trouble!  ";
        }
        else pass listendesc;
    }
;

White_Upper_Trans_Room: darkroom, dotroom, NoNPC
    game701p = true
    analevel = 3
    isUpperTransRoom = true
    isdotroom = nil // de-activated
    sdesc = "Upper Transindection Chamber (White level)"
    ldesc = {I();
        if(self.isdotroom)
            "You're in a small chamber, devoid of interest except for two
            colored dots on the floor, one green and one white.  The white dot 
            is circled. ";
        else
            "You're in the Upper Transindection Chamber at White level.  
            Unfortunately it would appear to have been de-activated - there
            are no dots on the floor.  A passage leads west. ";
    }
    hasfloordesc = true
    floordesc = {Dots.ldesc;}
    kata = Green_Upper_Trans_Room
    west = White_Trans_Room_Door_Inner
    out = {return self.west;}
    north = White_Machine_Chamber
;

MachineChamberPassage: doorway, floatingdecoration
    sdesc = "north doorway"
    ldesc = {
        if (global.OpenedMachineChamber) {
            "A sliding doorway has opened in the north
            wall! ";
        }
        else {
            "The door has now shut, and the doorway is almost invisible. ";
        }
    }
    heredesc = {
        if (global.OpenedMachineChamber) {
            P(); I(); "A door has opened in the north wall, revealing a dark
            passage to another room. ";
        }
    }
    isopen = nil
    noAutoOpen = true
    noun = 'door' 'doorway'
    adjective = 'north' 'northern' 
    verDoClose(actor) = {"I can see no obvious way to do that. ";}
    verDoOpen(actor) = {"I can see no obvious way to do that. ";}
    loclist = [] // changed when third pendant keyword is first used
    doordest = {return self.location.north;}
    doordestOK = true
;

class Machine_Chamber_Class: darkroom
    game701p = true
    isMachineChamber = true
    ldesc = {I();
        "You're in a small chamber, devoid of interest except for
        a strange machine in one corner.  ";
        if(global.OpenedMachineChamber)
            "A passage leads south. ";
        else // in case we view the room remotely using the sapphire
            "There are no obvious exits. ";
    }
    hasfloor = true // room with a floor
    opencount = 0
    chamberopen(actor) = {
        opencount++;
        global.OpenedMachineChamber := true;
        MachineChamberPassage.moveLoclist([Upper_Trans_Room, 
        Blue_Upper_Trans_Room, Green_Upper_Trans_Room,
        White_Upper_Trans_Room]);
        Upper_Trans_Room.north := Machine_Chamber;
        Upper_Trans_Room.NPCexits += &north;
        Blue_Upper_Trans_Room.north := Blue_Machine_Chamber;
        Green_Upper_Trans_Room.north := Green_Machine_Chamber;
        White_Upper_Trans_Room.north := White_Machine_Chamber;
        MachineChamberPassage.isopen := true;
        if (toplocation(actor).isUpperTransRoom) {
            P(); I(); 
            if(opencount = 1)"A previously unseen ";
            else "The ";
            "door slides open in the north wall,
            revealing a passage to another room! ";
        }
        else if (toplocation(actor).isOctagonalRoom) {
            P(); I(); 
            "You hear a rumbling sound from somewhere to the east. ";
        }
    }
    chamberclose(actor) = {
        global.OpenedMachineChamber := nil;
        Upper_Trans_Room.north := Noexit;
        Upper_Trans_Room.NPCexits -= &north;
        Blue_Upper_Trans_Room.north := Noexit;
        Green_Upper_Trans_Room.north := Noexit;
        White_Upper_Trans_Room.north := Noexit;
        MachineChamberPassage.isopen := nil;
        if (toplocation(actor).isUpperTransRoom) {
            P(); I(); 
            "The door slides shut. ";
        }
        else if (toplocation(actor).isOctagonalRoom) {
            P(); I(); 
            "You hear a rumbling sound from somewhere to the east. ";
        }
    }
;

Machine_Chamber: darkroom, Machine_Chamber_Class
    sdesc = "Machine Chamber"
    out = Upper_Trans_Room
    south = Upper_Trans_Room
    version_NoNPCs = (not Rockfalls.ismoved and 
    not global.OpenedMachineChamber)
    ana = Blue_Machine_Chamber
    NPCexit1 = Upper_Trans_Room
    machinetrans = Blue_Machine_Chamber
;

Blue_Machine_Chamber: darkroom, Machine_Chamber_Class, NoNPC
    analevel = 1
    sdesc = "Machine Chamber (Blue level)"
    out = Blue_Upper_Trans_Room
    south = Blue_Upper_Trans_Room
    kata = Machine_Chamber
    ana2 = Green_Machine_Chamber
    machinetrans = Green_Machine_Chamber
;

Green_Machine_Chamber: darkroom, Machine_Chamber_Class, NoNPC
    analevel = 2
    sdesc = "Machine Chamber (Green level)"
    out = Green_Upper_Trans_Room
    south = Green_Upper_Trans_Room
    kata = Blue_Machine_Chamber
    machinetrans = White_Machine_Chamber
;

White_Machine_Chamber: darkroom, Machine_Chamber_Class, NoNPC
    // Now accessible to the player.  Contains another oblong box.
    analevel = 3
    out = White_Upper_Trans_Room
    south = White_Upper_Trans_Room
    sdesc = "Machine Chamber (White level)"
    kata = Green_Machine_Chamber
    machinetrans = Magenta_Machine_Chamber
;

Magenta_Machine_Chamber: darkroom, Machine_Chamber_Class, NoNPC
    // Not accessible to the player.  Seen if the discolored disk is
    // put in the slot at White level.
    analevel = 4
    // out = Magenta_Upper_Trans_Room
    sdesc = "Machine Chamber (Magenta level)"
    // kata = Green_Machine_Chamber
;

Green_Living_Room: room, NoNPC
    game701p = true
    analevel = 2
    sdesc = "In the Wumpus Living Room (Green level)"
    ldesc = {I();
        "You're in a large room which appears to be the living quarters of
        the Wumpi.  This room is lit, but there is no obvious source of light.
        An open doorway leads out to the south, and ";
        if(LivingRoomDoor.islocked)
            "a locked door bars the exit to the ";
        else
            "an unlocked door leads ";
        "north.  Armchairs and couches are grouped around low tables, but you 
        see something of far more interest to the west - a large
        free-standing bookcase, full of books in various languages.  You 
        notice that there is a gap behind the bookcase. ";
    }
    hasfloor = true // room with a floor
    south = {
        local actor := getActor(&travelActor);
        if(wumpi_book.isIn(actor)) 
        "There is a blinding flash of light as you pass through the door.
        When your eyes have recovered, you notice that your inventory is 
        a little lighter. ";
        P();
        wumpi_book.moveInto(Bookcase);
        return Green_Spiral_Staircase;
    }
    north = LivingRoomDoor
    kata = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        rock.  Fortunately the spell reverses itself, and you find 
        yourself back in the room. ";
        return nil;
    }
    exithints = [Green_Spiral_Staircase, &south]
    west = {
        "If you want to go behind the bookcase, please say so. "; 
        return nil;
    }
;

LivingRoomDoor: CCR_lockableDoorway
    externalDoor = nil // not a cave exit
    sdesc = "door"
    ldesc = {
        "It's a plain steel door.  Currently it's ";
        if (self.isopen) "open."; 
        else if (self.islocked)
            "closed and locked. ";
        else
            "closed but unlocked. ";
        "Strangely, there's no lock on the door.  Maybe the locking
        mechanism is somewhere else. ";
    }
    noun = 'door'
    doordest = Green_Tight_Crack_2 
    destination = {
        local actor := getActor(&travelActor);
        local whereto := inherited.destination;
        if(whereto) {
            if(Wumpi.phase < 5 and Wumpi.phase > 0) Wumpi.phase := 5;
            if(wumpi_book.isIn(actor)) 
            "There is a blinding flash of light as you pass through the door.
            When your eyes have recovered, you notice that your inventory is 
            a little lighter. ";
            P();
            wumpi_book.moveInto(Bookcase);
        }
        return whereto;
    }        
    mykey = livingRoomKey
    location = Green_Living_Room
    doorlist = [Keyswitch, LivingRoomDoor, GreenTightCrackDoor]
    verDoLock(actor) = {"There's no lock on this side of the door.  Maybe
        you'll find the locking mechanism if you look elsewhere. ";}
    verDoLockWith(actor,io) = {self.verDoLock(actor);}
    verDoUnlock(actor) = {self.verDoLock(actor);}
    verDoUnlockWith(actor,io) = {self.verDoLock(actor);}
;

GreenTightCrackDoor: CCR_lockableDoorway
    sdesc = "door"
    ldesc = {
        "It's a plain steel door.  Currently it's ";
        if (self.isopen) "open. "; 
        else if (self.islocked)
            "closed and locked. ";
        else
            "closed but unlocked. ";
        "The lock is another key-operated switch and is on the wall to
        the right of the door.  You ask yourself why the \(inside\) lock was
        hidden, but not the \(outside\) one. ";
    }
    noun = 'door' 'lock' 'switch'
    externalDoor = nil // not a cave exit
    doordest = Green_Living_Room
    mykey = livingRoomKey
    location = Green_Tight_Crack_2
    // Modified methods for locking/unlocking.     
    doLockWith(actor,io) = {
        if (io = mykey) {
            "As you turn the key, you hear a heavy mechanical \"clunk\".
            The door is now locked. ";
            self.setIslocked(true);
        }
        else pass doLockWith;
    }
    doUnlockWith(actor,io) = {
        if (io = mykey) {
            "As you turn the key, you hear a heavy mechanical \"clunk\".
            The door is now unlocked. ";
            self.setIslocked(nil);
        }
        else pass doUnlockWith;
    }
    doorlist = [Keyswitch, LivingRoomDoor, GreenTightCrackDoor]
;

Behind_Bookcase: room, NoNPC
    sdesc = "Behind the Bookcase"
    ldesc = {I();
        "You're hiding behind the bookcase in the Wumpi's living 
        quarters, in a small space bounded to the west by the wall of the
        room and to the east by the bookcase.  From this side it looks like
        a solid wooden board, marred only by a few small knot-holes. ";
    }
    hasfloor = true // room with a floor
    analevel = 2
    kata = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        rock.  Fortunately the spell reverses itself, and you find 
        yourself back in the room. ";
        return nil;
    }
    out = Green_Living_Room
    ne = Green_Living_Room
    se = Green_Living_Room
    north = Green_Living_Room
    south = Green_Living_Room
;

Keyswitch: CCR_lockableDoorway // not a door, but we reference all the
                               // relevant locking/unlocking code including
                               // the doorlist
    sdesc = "key-operated switch"
    ldesc = {
        "It has two positions, marked \"locked\" and \"unlocked\". 
        At present it is set to the ";
        if(self.islocked)"locked"; else "unlocked";
        " position. ";
    }
    heredesc = {
        P(); I();
        "The switch is in the ";
        if(self.islocked)"locked"; else "unlocked";
        " position. ";
    }
    noun = 'switch' 'lock'
    adjective = 'key-operated'
    islocked = true
    isopen = nil
    externalDoor = nil // not a cave exit
    mykey = livingRoomKey
    verDoTurnon(actor) = {
        "I'm not quite sure what you mean by \"on\" or \"off\".  The two switch
        positions are marked \"locked\" and \"unlocked\". ";
    }
    verDoTurnoff(actor) = {
        self.verDoTurnon(actor);
    }
    verDoOpen(actor) = {
        "I don't know what you mean by \"open\".  The two switch positions
        are marked \"locked\" and \"unlocked\". ";
    }
    verDoClose(actor) = {
        "I don't know what you mean by \"close\".  The two switch positions
        are marked \"locked\" and \"unlocked\". ";
    }
    // Intercept attempts to enter or go through the switch
    verDoEnter(actor) = {"You can't enter a switch! ";}
    // Modified method for trying to lock the door when it's open
    verDoLockWith(actor,io) =
    {
        if (self.isopen and (io = mykey))
            "The key won't turn in the lock.  You'll have to close the door
            before you can lock it again. ";
        else pass verDoLockWith;
    }
    // Modified methods for locking/unlocking.  (Note the reference to the
    // Mulldoon games ...)
    doLockWith(actor,io) = {
        if (io = mykey) {
            "You hear a heavy mechanical \"clunk\" from somewhere in the 
            room. ";
            self.setIslocked(true);
        }
        else pass doLockWith;
    }
    doUnlockWith(actor,io) = {
        if (io = mykey) {
            "You hear a heavy mechanical \"clunk\" from somewhere in the 
            room. ";
            self.setIslocked(nil);
        }
        else pass doUnlockWith;
    }
    doorlist = [Keyswitch, LivingRoomDoor, GreenTightCrackDoor]
;

Bookcase: fixeditem, qsurface
    sdesc = "bookcase"
    ldesc = {
        "It's a large wooden bookcase, crammed with books in many different 
        languages - Elvish, Dwarvish, and a strange version of English. 
        All of the books appear to be quite incomprehensible";
        if (wumpi_book.isIn(self))
            ", with the exception of one entitled \"History of the Wumpi in
            Bedquilt Cave.\" ";
        else
            ". ";
        "You notice that there is a space behind the bookcase.  It might be
        a useful hiding place if any of the Wumpi decide to come up here. ";
    }
    noun = 'bookcase' 'books' 'shelf' 'bookshelf' 'shelves' 'bookshelves'
    adjective = 'book'
    location = Green_Living_Room

    doSearch(actor) = {
        if(wumpi_book.isIn(self))
            "There are many books here, but the only one which looks remotely
            readable is entitled \"History of Bedquilt Cave\". ";
        else
            "You look through the books.  Some of them are written in a
            strange version of English, but you find them quite unreadable.
            Others are in Elvish and Dwarvish which you can't read anyway. ";
    }
    ioPutOn(actor,dobj) = {
        if(dobj != wumpi_book) 
            "You'd only attract attention to yourself by 
            putting <<dobj.thedesc>> on the bookshelves. ";
        else pass ioPutOn;
    }
    verioPutIn(actor,dobj) = {}
    ioPutIn(actor,dobj) = {
        if(dobj != wumpi_book) 
            "You'd only attract attention to yourself by 
            putting <<dobj.thedesc>> into the bookcase. ";
        else self.ioPutOn(actor,dobj);
    }
    verDoLookbehind(actor) = {}
    doLookbehind(actor) = {
        "(Going behind the bookcase to take a closer look...)";
        P();
        self.doHidebehind(actor);
        P();
        if(not Keyswitch.isIn(self.location))
            BookcaseBehind.lockfind;
    }
    verDoHidebehind(actor) = {}
    doHidebehind(actor) = {
        global.travelActor := actor;
        actor.travelTo(Behind_Bookcase);
    }
    doSynonym('Inspect') = 'Read'
;
BookcaseBehind: fixeditem
    sdesc = "bookcase"
    ldesc = {
        "The back face of the bookcase is a solid wooden board, almost
        featureless except for a few small knot-holes";
        if(Keyswitch.isIn(self.location)) {
            ", one of which contains a key-operated switch, currently
            in the ";
            if(Keyswitch.islocked) "locked "; else "unlocked ";
            "position. ";
        }
        else {
            ". ";
            self.lockfind;
        }
    }
    lockfind = {
        "You look carefully
        at the holes, and notice a small key-operated switch behind one of 
        them, about two inches above the floor!  It has two positions, marked 
        \"locked\" and \"unlocked\".  At present it is ";
        if(Keyswitch.islocked) "locked. "; else "unlocked. ";

        Keyswitch.moveInto(self.location);
    }
    noun = 'bookcase' 'hole' 'holes' 'knot-holes' 'board'
    adjective = 'knot' 'wooden'
    location = Behind_Bookcase
    verDoSearch(actor) = {}
    doSearch(actor) = {self.ldesc;}
    verDoLookbehind(actor) = {}
    doSynonym('Inspect') = 'Lookin'
    doSynonym('Inspect') = 'Lookthru'
;

Armchairs: chairitem
    isThem = true
    sdesc = "armchairs"
    adesc = "armchairs"
    ldesc = "They look like ordinary armchairs, only larger. "
    noun = 'chair' 'chairs' 'armchair' 'armchairs'
    adjective = 'large' 'arm'
    location = Green_Living_Room
;

Couches: chairitem
    isThem = true
    sdesc = "couches"
    adesc = "couches"
    ldesc = "They look like ordinary couches, only larger. "
    noun = 'couch' 'couches'
    adjective = 'large'
    location = Green_Living_Room
;

Tables: fixeditem, surface
    isThem = true
    sdesc = "tables"
    adesc = "tables"
    ldesc = "They look like large, nondescript coffee tables. "
    noun = 'table' 'tables'
    adjective = 'low' 'coffee' 'nondescript'
    location = Green_Living_Room
;

Blue_Dead_End_Crack: darkroom, CCR_dead_end_room, NoNPC
    game701p = true
    analevel = 1
    sdesc = "In Dead End Crack (Blue level)"
    ldesc = {I();
        "%You're% in a dead-end crack.";
    }
    north = Blue_East_End_Of_Long_Hall
    kata = Dead_End_Crack
    ana2 = Green_Dead_End_Crack
;

Green_Dead_End_Crack: darkroom, CCR_dead_end_room, NoNPC
    game701p = true
    analevel = 2
    sdesc = "In Dead End Crack (Green level)"
    ldesc = {I();
        "%You're% in a dead-end crack.";
    }
    north = Green_East_End_Of_Long_Hall
    kata = Blue_Dead_End_Crack
;

/* Blue_Tight_Crack_2 has been filled with concrete */

Green_Tight_Crack_2: darkroom, CCR_dead_end_room, NoNPC
    game701p = true
    analevel = 2
    sdesc = "In A Wide Crack (Green level)"
    ldesc = {I();
        "%You're% in a wide n/s crack. It appears to have been narrower
        at one time, but it has been enlarged. ";
        if(GreenTightCrackDoor.islocked)
            "The way south is barred by a locked steel door. ";
        else
            "The way south leads through an unlocked steel door. ";
        "For some reason the lock is on the wall to the right of the door, not
        the door itself. ";
    }
    north = Green_East_End_Of_Long_Hall
    south = GreenTightCrackDoor
    kata = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        concrete.  Fortunately the spell reverses itself, and you find 
        yourself back in the crack. ";
        return nil;
    }
;

/* Blue_Tight_Crack has also been filled with concrete */

Green_Tight_Crack: darkroom, NoNPC
    game701p = true
    analevel = 2
    sdesc = "In Tight N/S Crack"
    ldesc = {
        I(); "%You% %are% in a very tight N/S crack.   Unfortunately
        the passage south is blocked by an old cave-in. ";
    }
    north = Green_East_End_Of_Long_Hall
    passage = {return self.south;}
    south = {
        "The passage south is blocked by a cave-in. ";
        return nil;
    }
    kata = {
        "You see a brief flash of blue light, then feel a sickening 
        \"crunch\" as your entire body collides with a solid wall of 
        concrete.  Fortunately the spell reverses itself, and you find 
        yourself back in the passage. ";
        return nil;
    }
;

/* The following rooms are based on the Hall of Mists and Long Hall */
/* 15 */
Blue_Hall_Of_Mists: room, NoNPC
    game701p = true
    analevel=1
    sdesc = "In Hall of Mists (Blue level)"
    ldesc = {I(); 
        "%You% are at one end of a vast hall stretching
        forward out of sight to the west.  The floor has been concreted
        over and the room is now lit by overhead electric lights.  There are
        several display boards containing information about the cave and its
        history. To the northeast, a large elevator shaft leads up to a
        balcony at the top of a dome, but the doors of the elevator are
        firmly closed.  A wide staircase runs downward into the darkness, 
        large passages lead north and south, and a small crack leads east. ";
    }
    hasfloor = true // room with a floor
    south = Blue_Nugget_Of_Gold_Room
    forwards = Blue_East_Bank_Of_Fissure
    hall = Blue_East_Bank_Of_Fissure
    west = Blue_East_Bank_Of_Fissure
    ne = {
        local actor := getActor(&travelActor);
        if(Elevator.islocked) {
            "You press the call button, but the doors of the elevator remain
            firmly closed.  ";
            if(Elevator.examined) {
                "Unless you're lucky enough to find the right key for the 
                switch, you won't be able to enter the elevator by conventional
                means. ";
            }
            return nil;
        }
        else {
            Elevator.doEnter(actor);
            return nil;
        }   
    }
    east = Blue_Sandstone_Chamber
    crack = Blue_Sandstone_Chamber
    stairs = Blue_Hall_Of_Mt_King
    down = Blue_Hall_Of_Mt_King
    north = Blue_Hall_Of_Mt_King
    y2 = {  
        "You find the hidden passage on the north wall which would
        lead to Y2, but a steel grille bars the way. ";
        return nil;
    }
    up = {
        "The dome is unclimbable.  It appears that the elevator would be the
        only way up, if you could find a way to get into it. ";
    }
    passage = {
        "There's more than one opening - please tell me which
        direction you want to go. ";
        return nil;
    }

    climb = {return self.down;}
    kata = In_Hall_Of_Mists
    ana2 = Green_Hall_Of_Mists /* requires green pendant */
    // extra locations to allow the use of transindection to enter the lift.
    enterRoom(actor) = {
        Red_NE_Corner.moveInto(In_Hall_Of_Mists);
        Green_NE_Corner.moveInto(Green_Hall_Of_Mists);        
        pass enterRoom;
    }
    myhints = [Elevatorhint]
;

FixedGrille: fixeditem
    game701p = true
    sdesc = "steel grille"
    ldesc = "The grille is firmly fixed in place, and I can't see any way to
            remove it. "
    noun = 'grille'
    verDoUnlock(actor) = {self.ldesc;}
    verDoUnlockWith(actor,io) = {self.ldesc;}
    verDoOpen(actor) = {self.ldesc;}
    verDoClose(actor) = {"It's already firmly closed. ";}
    adjective = 'steel'
    location = Blue_Hall_Of_Mists
;    

Elevator: floatingdecoration
    game701p = true
    sdesc = "elevator"
    islocked = {
        if(self.location = Blue_Hall_Of_Mists) 
            return ElevatorSwitch1.islocked;
        else
            return ElevatorSwitch2.islocked;
    }
    ldesc = {
        self.examined := true;
        "It looks like other elevators you've seen, with sliding doors
        (closed at present) and a call button.  Oh, and a key-operated switch
        with two positions - \"on\" and \"off\".  At present it seems to be
        in the ";
        if(self.islocked)
            "\"off\" position. Unless you're lucky enough to find the right
            key, I don't think you'll be able to get into the elevator by
            conventional means. ";
        else
            "\"on\" position. ";
    }
    loclist = [Blue_Hall_Of_Mists, Blue_Balcony]
    noun = 'door' 'doors' 'button' 'elevator' 'lift'
    adjective = 'large' 'call' 'sliding'
    verDoPush(actor) = {
        if(self.islocked)
        "Nothing happens.  I suspect that the key-operated switch has 
        something to do with it. ";
    }
    verDoOpen(actor) = {
        if(self.islocked)
        "I think you'd need to turn on the key-operated switch to do that. ";
    }
    verDoClose(actor) = {
        "The elevator doors are already firmly closed. ";
    }
    verDoEnter(actor) = {
        "You press the call button, but nothing happens. ";
    }
    verDoBoard(actor) = {
        self.verDoEnter(actor);
    }

    doPush(actor) = {self.doEnter(actor);}
    doBoard(actor) = {self.doEnter(actor);}
    doEnter(actor) = {
        local toploc := toplocation(actor);
        "You push the call button. ";
        if (toploc != Blue_Hall_Of_Mists) "After a short wait the ";
        else "The ";
        "doors swish open and you step into the elevator. ";
        In_Elevator.outdest := toplocation(actor);
        P();
        actor.travelTo(In_Elevator);
    }
;
class ElevatorSwitch: fixeditem, keyedLockable
    game701p = true
    sdesc = "key-operated switch"
    ldesc = {
        "It's a key-operated switch.  At present it's in the ";
        if (self.islocked) "\"off\" ";
        else "\"on\" ";
        "position. ";
    }
    noun = 'switch' 'lock'
    adjective = 'key-operated'
    mykey = elevator_key 
    islocked = true
    isopen = nil
    doSynonym('UnlockWith') = 'TurnonWith'
    doSynonym('LockWith') = 'TurnoffWith'
    doSynonym('Unlock') = 'Turnon'
    doSynonym('Lock') = 'Turnoff'
    verDoOpen(actor) = {
        "I don't know what you mean by \"open\".  The two switch positions
        are marked \"off\" and \"on\". ";
    }
    verDoClose(actor) = {
        "I don't know what you mean by \"close\".  The two switch positions
        are marked \"off\" and \"on\". ";
    }
;
ElevatorSwitch1: ElevatorSwitch
    location = Blue_Hall_Of_Mists
;
ElevatorSwitch2: ElevatorSwitch
    location = Blue_Balcony
;

BlueHOMBalcony: distantItem
    sdesc = 'balcony'
    ldesc = "It's high above you, at the top of the elevator shaft. "
    location = Blue_Hall_Of_Mists
    noun = 'balcony'
    verDoEnter(actor) = {self.ldesc;}
    verDoBoard(actor) = {self.verDoEnter(actor);}
;

Green_Hall_Of_Mists: room, NoNPC
    game701p = true
    analevel = 2
    sdesc = "In Hall of Mists (Green level)"
    ldesc = {
        I(); "%You% are at one end of a vast hall stretching
        forward out of sight to the west, filled with wisps of
        white mist that sway to and fro almost as if alive.  There
        is a passage at the top of a dome above %youm%.  A wide
        staircase runs downward into the darkness;  a chill wind
        blows up from below.  There are small passages to the north and
        south, and a small crack leads east. ";
    }
    south = Green_Nugget_Of_Gold_Room
    forwards = Green_East_Bank_Of_Fissure
    hall = Green_East_Bank_Of_Fissure
    west = Green_East_Bank_Of_Fissure
    east = Green_Sandstone_Chamber
    crack = {
        return self.east;
    }
    stairs = {return self.north;}
    down = {return self.north;}
    north = {
        local actor := getActor(&travelActor);
        if (Green_Hall_Of_Mt_King.isseen) { 
            "You decide not to risk another encounter with the elves. ";
            return nil;
        }
        else if ((pendant.location != actor) or not pendant.isworn) {
            "Without your pendant you feel strangely insecure, and decide not 
            to risk an encounter with the elves right now. ";
            return nil;
        }
        else {
            local actor := getActor(&travelActor);
            actor.travelTo(Green_Hall_Of_Mt_King);
            P();I();
            "In place of a snake, you see several Elvish guards, all wearing
            a uniform made from a silvery fabric.  You also notice that every
            one of them is wielding a shiny sword!  One of them shouts \"Halt!
            This cavern sector is outbounded from humans!  Does thou have a 
            passdisk?\" ";  

            if ((cloak.location = actor) and cloak.isworn)
                "After a moment's hesitation, you try to explain that you
                found your way into the cave by accident, and would like to
                leave.  But the elf doesn't seem very interested.  \"Guards, 
                search this intruder!  I want to know how he inboarded the 
                cave!\" ";
            else
                "His eye then rests on your pendant. \"Ah - now I see what 
                style of passdisk thou used!  The lost amulet has been
                stoneturned at last!  Guards, seize the chattel!\" ";
            P();
            "For a moment you freeze - then the pendant seems to take control
            of you!  You hear yourself whisper the word \"kata\", and you
            are relieved to find yourself standing on a concrete floor in
            an empty room... ";
            P();
            global.seenelves := true;
            return Blue_Hall_Of_Mt_King;
        }
    }
    y2 = {  "You find the hidden passage on the north wall which would
            lead to Y2. On entering the passage, you experience a strange
            tingling sensation, then ...";
            P();
            return Green_Sandstone_Chamber;
    }
    up = {
        local actor := getActor(&travelActor);
        if(large_gold_nugget.isInside(actor)) {

            "The dome is unclimbable. ";
            return nil;
        }
        else {
            "You experience a strange tingling sensation as you climb the
            steps, then ...";
            P();
            return Green_East_End_Of_Long_Hall;
        }
    }
    passage = {
        "There's more than one opening - please tell me which
        direction you want to go. ";
        return nil;
    }

    climb = {return self.down;}
    kata = Blue_Hall_Of_Mists
    ne = {
        if (not Blue_Hall_Of_Mists.isseen) 
            pass ne;
        else
            "You stand in the northeast corner of the room, in the position
            of the elevator shaft at Blue level. ";
            P();
            return Green_NE_Corner;
    }
;

Foreboding: floatingdecoration // a sense of foreboding when the Green-level
                               // elves know that the Wumpi have been
                               // transported through Transindection.
    sdesc = "sense of foreboding"
    heredesc = {
        if(not Green_Upper_Trans_Room.isdotroom) return;
        if((global.seenelves or topaz.moved) and not 
        Green_Banqueting_Room.seenelves and (Wumpi.phase > 0)) {
            P(); I();
            if (find([In_Hall_Of_Mists, Blue_Hall_Of_Mists, 
            Green_Hall_Of_Mists],self.location)) {
                "You experience a strange sense of foreboding as you look at 
                the south passage.  ";
            }
            else {
                "The feeling of foreboding has intensified, and you now
                can't get it out of your mind. ";
            }
            "You somehow \(know\) that someone - something - wants 
            to warn you of an impending disaster. ";
        }    
    }
    loclist = [In_Hall_Of_Mists, Blue_Hall_Of_Mists, Green_Hall_Of_Mists,
              In_Nugget_Of_Gold_Room, Blue_Nugget_Of_Gold_Room,
              Green_Nugget_Of_Gold_Room]
;

ElfSign: fixeditem, readable
    sdesc = "signs"
    ldesc = "The signs read, \"Warning: passdisks must be shewn.\" "
    heredesc = {
        P(); I();
        "Signs above the staircase and the north passage read:
        \"Warning: passdisks must be shewn.\" ";
    }
    location = Green_Hall_Of_Mists
    noun = 'sign' 'signs'
;

IronBridge: floatingdecoration, surface
    game701p = true
    iswavetarget = true // we can attempt magic by waving the rod at it ...
    exists = nil
    sdesc = "iron bridge"
    ldesc = "It spans the fissure, thereby providing %youm% a way across."
    heredesc = {
        P(); I();
        "A sturdy iron bridge now spans the fissure.";
    }
    locationOK = true       // tell compiler OK for location to be method
    loclist = [ Green_West_Side_Of_Fissure, Green_East_Bank_Of_Fissure ]
    noun = 'bridge'
    adjective = 'iron' 'sturdy'

    verDoCross(actor) = {}
    doCross(actor) = {
        local oldana = toplocation(actor).analevel;
        local n := 0, o, i := 0, l := length(global.spinrodlist);
        for (i := 1; i <= l; i++) {
            o := global.spinrodlist[i];
            if (o.isspinning and o.isInside(actor)) n++;
        }
        if(n > 1) {
            "You try to cross the bridge, but the spinning rods refuse to
            go with you!  You conclude that it might be a better idea to spin 
            just one rod at a time. ";
            return;
        }
        else {
            for (i := 1; i <= l; i++) {
                o := global.spinrodlist[i];
                if (o.isspinning and o.isInside(actor)) {
                    local anlev;
                    "As you cross the bridge you feel a sudden gust of wind,
                    and it goes completely dark for a few seconds.  You then
                    find yourself in another place ... ";
                    P();
                    if ((pendant.location = actor) and pendant.isworn and
                    pendant.strictcontrol) {
                        actor.travelTo(o.myhome2[oldana+1]);
                    }
                    else if ((broken_pendant.location = actor) and 
                    broken_pendant.isworn and broken_pendant.strictcontrol) {
                        actor.travelTo(o.myhome2[oldana+1]);
                    }
                    else
                        actor.travelTo(o.myhome);
                    if (toplocation(actor).analevel != oldana) {
                        if(pendant.location = actor and pendant.isworn) {
                            "The gold pendant whispers to your mind: ";
                            if(pendant.strictcontrol)
                                 "\"Warning 09A2:  Transindection movement
                                 mediated by unregistered object, type
                                 Astral Staff.  Unable to block movement
                                 due to lack of proximity to Control Room.\" ";
                            else 
                                "\"Warning 09A1: Transindection movement 
                                mediated by unregistered object, type Astral 
                                Staff.\" ";
                        }
                    
                        if (not self.transchanged) {
                            P();
                            "You ponder the implications of your discovery.  
                            I'd bet that even Eldrand didn't know that the
                            rods could transport you through Transindection! ";
                            P();
                            self.transchanged := true;
                        }
                    }
                    // Suppress the 'wrong rod' message if the player has 
                    // landed in the Green-level Debris Room.  Until he goes
                    // west, it won't be obvious that he's arrived in the
                    // wrong place.
                    if(manual.isread and not Green_Bird_Chamber.isseen and
                    not actor.isIn(Green_Debris_Room)) {
                        // issue this message only once
                        if(not self.saidwrong) {
                            P();
                            "If you were trying to get into the \"Orange Stone
                            Chamber\" at Green level, I guess you've used the 
                            wrong rod.  I suspect that the \"staff\" to which 
                            the manual refers was a similar rod from Green 
                            level. ";
                            self.saidwrong := true;
                        }
                    }
                }
            }
        }
        if (actor.isIn(Green_East_Bank_Of_Fissure))
            actor.travelTo(Green_West_Side_Of_Fissure);
        else if (actor.isIn(Green_West_Side_Of_Fissure))
            actor.travelTo(Green_East_Bank_Of_Fissure);
    }
    verDoEnter(actor) = {}
    verDoBoard(actor) = {}
    verDoStandon(actor) = {}
    doEnter(actor) = {
        "You step onto the bridge, but you can't help looking down into the
        depths of the fissure.  This makes you feel very insecure, so you
        continue across ... ";
        P();
        self.doCross(actor);
    }
    doBoard(actor) = {self.doEnter(actor);}
    doStandon(actor) = {self.doEnter(actor);}
    verIoSpinOver(actor) = {}
    ioSpinOver(actor,dobj) = {
        BridgeFissure.ioSpinOver(actor,dobj);
    }
    ioPutOn(actor,dobj) = {
        if(not (isclass(dobj,spinnable_rod) and dobj.isspinning))
            pass ioPutOn;
        else {
            "You place <<dobj.thedesc>> on the bridge.  It hovers just over
            the surface and continues to spin, moving slowly toward the
            center of the bridge. ";

            dobj.moveInto(dobj.myhome);  

            // the gold ring transports the player, if worn.
            if((gold_ring.location = actor) and gold_ring.isworn) {
                local oldana := toplocation(actor).analevel;
                local newana;
                "Your gold ring quivers, and you feel a sudden gust of
                wind.  The room goes dark, and you then find yourself ...";
                P();
                if ((pendant.location = actor) and pendant.isworn and
                pendant.strictcontrol) {
                    actor.travelTo(dobj.myhome2[oldana+1]);
                }
                else if ((broken_pendant.location = actor) and 
                broken_pendant.isworn and broken_pendant.strictcontrol) {
                    actor.travelTo(dobj.myhome2[oldana+1]);
                }
                else
                    actor.travelTo(dobj.myhome);
                P();
                newana := toplocation(actor).analevel;
                if (newana != oldana) {
                    if((pendant.location = actor) and pendant.isworn) {
                        "The gold pendant whispers to your mind: ";
                        if (pendant.strictcontrol)
                            "\"Warning 09A2:  Transindection movement
                            mediated by unregistered object, type Dual Magic
                            Ring.  Unable to block movement
                            due to lack of proximity to Control Room.\" ";
                        else 
                            "\"Warning 09A1: Transindection movement 
                            mediated by unregistered object, type Dual Magic
                            Ring.\" ";
                    }
                    if (not IronBridge.transchanged) {
                        P();
                        "You ponder the implications of your discovery.  
                        I'd bet that even Eldrand didn't know that the
                        rods could transport themselves through 
                        Transindection! ";
                    }
                    IronBridge.transchanged := true;
                }
            }
            else {
                "Then there is a sudden gust of wind, and
                <<dobj.thedesc>> vanishes! I hope you'll be able to find it 
                again. ";
            }
        }
    }
;
Blue_Nugget_Of_Gold_Room: room, NoNPC
    game701p = true
    analevel = 1
    sdesc = "In Nugget of Gold Room (Blue level)"
    ldesc = {I(); 
        "This is a low room with a concrete floor.  It is lit by an 
        overhead electric light, but there is nothing else of
        interest except for a couple of display boards.  ";
        if (self.seengold) {
            "There was a nugget of gold here, but it was removed long ago.
            No doubt it's now on display in a dusty museum case. ";
        }
        else {
            "If there was a nugget of gold here, it was stolen long ago. ";
        }
    }
    hasfloor = true // room with a floor
    hall = Blue_Hall_Of_Mists
    out = Blue_Hall_Of_Mists
    north = Blue_Hall_Of_Mists
    kata = In_Nugget_Of_Gold_Room
    ana2 = Green_Nugget_Of_Gold_Room
;
Green_Nugget_Of_Gold_Room: darkroom, NoNPC
    game701p = true
    analevel = 2
    sdesc = "In Nugget of Gold Room (Green level)"
    ldesc = {
        local actor := getActor(&verbActor);
        I(); 
        "This is a low room to the south of the Hall of Mists.  There is
        no nugget of gold here, but there is something of much more 
        interest - a glass sphere, set into the wall. ";
        
        if ((pendant.location = actor) and pendant.isworn)
            "As you approach the sphere it begins to light up, and your gold 
            pendant also starts to glow; perhaps the sphere is activated by 
            the pendant. "; 
        P(); I();

        "Below the sphere there is a dial which can be set to a number 
        from <<Spheredial.minsetting>> to <<Spheredial.maxsetting>>. 
        The current setting is <<Spheredial.setting>>. ";
    }
    hall = Green_Hall_Of_Mists
    out = Green_Hall_Of_Mists
    north = Green_Hall_Of_Mists
    kata = Blue_Nugget_Of_Gold_Room
;

Glass_Ball: fixeditem //similar to crystal_ball
    game701p = true
    sdesc = "glass ball"
    ldesc = {
        "The glass sphere is firmly set into the wall, and cannot be
        removed. ";
        if (not self.imageformed) {
            "An image begins to form.  If you want to see more, I suggest
            that you look \(in\) the ball. "; P();
            self.imageformed := true;
        }
        "The dial below the ball is currently set to the 
        number <<Spheredial.setting>>. ";
    }
    noun = 'ball' 'sphere' 'palantir'
    adjective = 'glass'
    verDoLookin (actor) = {} 
    verDoSearch(actor) = {self.verDoLookin(actor);}
    doLookin(actor) = {self.doSearch(actor);}
    doSearch(actor) = {
        local myloc := actor.location;
        if ((pendant.location != actor) or not pendant.isworn) {
            "You can't see anything in the crystal ball.  I suspect this
            has something to do with the fact that you've managed to get
            here without wearing the gold pendant. ";
            return;
        }
        if (Spheredial.setting = 4) {
            "You feel rather disembodied, as if you were suddenly in a 
            different room - but in this case, not very far away ... "; P();
        }
        else {
            "You feel rather disembodied, as if you were suddenly somewhere
            else entirely. "; P();
        }
        switch (Spheredial.setting) {
            case 1:
                actor.location := Lost_Canyon_End;
                break;
            case 2:
                actor.location := Orange_Office;
                Access_Shaft_Door.moveInto(Top_Of_Blocks);
                // Important: force the ldesc to be printed when the
                // room is visited
                Top_Of_Blocks.isseen := nil;
                break;
            case 3:
                actor.location := Control_Room;
                break;
            case 4:
                actor.location := Green_Sandstone_Chamber;
                break;
            case 5:
                actor.location := Green_Banqueting_Room;
                break;
            case 6:
                actor.location := Green_Zarkalon_Tower_Top;
                break;
        }
        global.onlyviewing := true;
        global.view_artifact := self;
        "\("; actor.location.sdesc; "\)";
        actor.location.nrmLkAround(true);
        global.onlyviewing := nil;
        global.view_artifact := nil;
        actor.location.seenit := true;
        actor.location := myloc;
        P();
        "Your gaze withdraws from the glass ball, and you are
        now back in your normal senses. ";    
    }
    location = Green_Nugget_Of_Gold_Room
;

Spheredial: fixeditem, dialItem
    game701p = true
    sdesc = "dial"
    noun = 'dial'
    minsetting = 1
    maxsetting = 6
    location = Green_Nugget_Of_Gold_Room
;

Blue_Hall_Of_Mt_King: room, NoNPC
    game701p = true
    analevel = 1
    sdesc = "In Hall of Mt King (Blue level)"
    ldesc = {I();
        "%You% %are% in the hall of the mountain king, with
        passages off in all directions. The floor has been concreted, the 
        room is lit, and there are a few display boards,
        but otherwise it looks like the room with which you are
        familiar.";
    }
    hasfloor = true // room with a floor
    stairs = {
        local actor := getActor(&travelActor);
        if (large_gold_nugget.isInside(actor) and global.newgame) {
            "The staircase is now unclimable.";
            return nil;
        }
        else {
            return Blue_Hall_Of_Mists;
        }
    }
    up = {return self.stairs;}
    east = Blue_Hall_Of_Mists

    left = { return self.north; }
    north = {
        "Unfortunately the passage is blocked after a short distance by a
        steel door, 
        and you are forced to return to the Hall of the Mountain King. ";
        return nil;
    }

    right = { return self.north; }
    south = { return self.north; }
    forwards = { return self.north; }
    secret = { return self.north; }
    ne = { return self.north; }
    nw = { return self.north; }
    se = { return self.north; }
    sw = { return self.north; }
    west = { return self.north; }
    down = { return self.north; }
    kata = In_Hall_Of_Mt_King
    ana2 = {
        if (Green_Hall_Of_Mt_King.isseen) { 
            "You decide not to risk another encounter with the elves. ";
            return nil;
        }
        else {
            local actor := getActor(&travelActor);
            actor.vehicleTravel(&transmove,Green_Hall_Of_Mt_King);
            if (not actor.isIn(Green_Hall_Of_Mt_King))
                return nil;
            P(); I();
            "In place of a snake, you see several Elvish guards, all
            wearing a dark green military uniform and wielding a shiny
            sword! ";
            while (actor.location <> Green_Hall_Of_Mt_King) {
                local actorloc;
                "You quickly get 
                <<actor.location.outOfPrep>> <<actor.location.thedesc>>";
                actorloc := actor.location;
                if(not actorloc.isfixed) {
                    " and pick <<actorloc.itobjdesc>> up. ";
                    actor.moveInto(actorloc.location);
                    actorloc.moveInto(actor);
                } 
                else {
                    ". ";
                    actor.moveInto(Green_Hall_Of_Mt_King);
                }
            }
            "For a moment, they seem to freeze, startled by the manner
            of your appearance.  ";
            if ((cloak.location = actor) and cloak.isworn)
                "Then one of them seems to come to his senses. \"He must have
                 an amulet!\" ";
            else
                "Then one of them sees your pendant.  \"The long-sought
                amulet! ";
            "After him!\" ";
            if (large_gold_nugget.isInside(actor)) {
                "You try to flee up the stairs, but you stumble on the first
                step - the stairs are unclimbable with
                what you're carrying!   Fortunately you say \"Kata\" before
                the elves can grab you, and you're relieved to find 
                yourself ... ";
                P();
                global.seenelves := true;
                actor.travelTo(Blue_Hall_Of_Mt_King);
                return nil;
            }
            else {
                "You flee up the stairs with
                the elves in hot pursuit, and shout \"Kata\".  You stumble as 
                the stairs seem to melt and shift under your feet, but
                you regain your footing and continue upwards.  Then you glance 
                back - and are relieved to find yourself alone, standing on a 
                smooth concrete floor.  ";
                P();
                global.seenelves := true;
                actor.travelTo(Blue_Hall_Of_Mists);
                return nil;
            }
        }
    }

;
Green_Hall_Of_Mt_King: room, NoNPC /* Player doesn't stay here so no exit
                                      properties are required. */
    game701p = true
    analevel = 2
    sdesc = "In Hall of Mt King (Green level)"
    ldesc = {I();
        "%You% %are% in the hall of the mountain king, with
        passages off in all directions. ";
    }
;
Blue_East_Bank_Of_Fissure: room, NoNPC
    game701p = true
    analevel = 1
    sdesc = "At site of East Bank of Fissure (Blue level)"
    ldesc = {I(); 
        "%You% %are% at the site of the fissure which slices clear
        across the hall at Red level.  However, there is no fissure now.
        The floor has been concreted over and the room is lit by
        electric lights. ";
    }
    hasfloor = true // room with a floor
    hall = Blue_Hall_Of_Mists
    east = Blue_Hall_Of_Mists
    west = Blue_West_Side_Of_Fissure
    kata = On_East_Bank_Of_Fissure
    ana2 = Green_East_Bank_Of_Fissure /* requires green pendant */
;

Green_East_Bank_Of_Fissure: darkroom, NoNPC
    game701p = true
    analevel = 2
    sdesc = "On East Bank of Fissure (Green level)"
    ldesc = {I(); 
        "%You% %are% on the east bank of a fissure slicing
        clear across the hall. The mist is quite thick here. ";
    }
    hall = Green_Hall_Of_Mists
    east = Green_Hall_Of_Mists

    forwards = { return self.across; }
    jump = {
            "I respectfully suggest %you% go%es% across the
            bridge instead of jumping.";

            return nil;
    }

    over = { return self.across; }
    west = { return self.across; }
    cross = { return self.across; }
    across = {
        local actor := getActor(&travelActor);
        IronBridge.doCross(actor);
        return nil;
    }

    listendesc = {
        if (global.oldgame) pass listendesc;
        global.listenadd := true;
        inherited.listendesc;
        P(); "You hear a distant roar, like the sound of a fast-flowing
             river, from the depths of the fissure. ";
        global.listenadd := nil;
    }
    kata = Blue_East_Bank_Of_Fissure
    myhints = [Spinhint]
;

Rodspinplaque: floatingdecoration, readable
    game701p = true
    sdesc = "plaque"
    ldesc = {
        "You can't read the script, but the picture is unmistakable - a
        wand like the black rod you found in the Debris Room. ";
    }
    heredesc = {
        P(); I();
        if (self.location = BridgeFissure.location)
            "A strange plaque is affixed to the north wall, above the middle
            of the fissure.  It is written in an indecipherable script, but
            includes a picture which is instantly recognizable - a rod with a
            star on an end. ";
        else if (self.location.isplaqueroom) 
            "A plaque is affixed to the ceiling of the room.
            It's identical to the one you saw at Green level - the same
            script, and the same picture of a rod with a star on an end. ";  
        else
            "To one side of the tunnel there is a strange plaque,
            identical to the one you saw at Green level.  The same 
            indecipherable script,  and the same picture of a rod with a
            star on an end. ";
    }
    noun = 'plaque'
    loclist = 
        [Green_West_Side_Of_Fissure, Green_East_Bank_Of_Fissure,
        Zarkalon_Cliff_Top, Blue_Zarkalon_Cliff_Top, Plaque_Room, 
        Blue_Plaque_Room, Green_Plaque_Room, Plaque_Room_2, 
        Blue_Plaque_Room_2, Green_Plaque_Room_2]
;
Blue_West_Side_Of_Fissure: room, NoNPC
    game701p = true
    analevel = 1
    sdesc = "At site of West Bank of Fissure (Blue level)"
    ldesc = {
        I(); "%You% %are% at the site of the west bank of the
        fissure which slices clear across the hall at Red level.  However,
        there is no fissure now. The floor has been concreted over and the 
        room is lit by electric lights. ";
    }
    hasfloor = true // room with a floor

    east = Blue_East_Bank_Of_Fissure
    west = Blue_West_End_Of_Hall_Of_Mists

    north = {
        local actor := getActor(&travelActor);
        "%You% %have% crawled through a very low wide passage
        parallel to and north of the hall of mists.\b";

        return Blue_West_End_Of_Hall_Of_Mists;
    }
    kata = West_Side_Of_Fissure
    ana2 = Green_West_Side_Of_Fissure
;

Green_West_Side_Of_Fissure: darkroom, NoNPC
    game701p = true
    analevel = 2
    sdesc = "West Side of Fissure (Green level)"
    ldesc = {
        I(); "You are on the west side of the fissure in the
        hall of mists. ";
    }

    forwards = { return self.cross; }
    jump = {
            "I respectfully suggest %you% go%es% across the
            bridge instead of jumping.";

            return nil;
    }
    west = Green_West_End_Of_Hall_Of_Mists
    over = { return self.across; }
    east = { return self.across; }
    cross = { return self.across; }
    across = {
        local actor := getActor(&travelActor);
        IronBridge.doCross(actor);
        return nil;
    }

    north = {
        local actor := getActor(&travelActor);
        "%You% %have% crawled through a very low wide passage
        parallel to and north of the hall of mists.\b";

        return Green_West_End_Of_Hall_Of_Mists;
    }
    listendesc = {
        if (global.oldgame) pass listendesc;
        global.listenadd := true;
        inherited.listendesc;
        P(); "You hear a distant roar, like the sound of a fast-flowing
             river, from the depths of the fissure. ";
        global.listenadd := nil;
    }
    kata = Blue_West_Side_Of_Fissure
    myhints = [Spinhint]
;

Blue_West_End_Of_Hall_Of_Mists: room, NoNPC
    game701p = true
    analevel=1
    sdesc = "At West End of Hall of Mists (Blue level)"
    ldesc = {I(); 
        "You are at the west end of the hall of mists.  The floor
        has been concreted over, the room is lit by electric lights, and
        a few display boards are arranged around the walls. 
        A large tunnel continues west and another goes north, but the
        passage to the south is barred by a steel door. ";
    }
    hasfloor = true // room with a floor
    east = Blue_West_Side_Of_Fissure
    west = Blue_East_End_Of_Long_Hall
    passage = Blue_East_End_Of_Long_Hall

    north = {
        "%You% %have% crawled through a very low wide passage
        parallel to and north of the hall of mists.\b";

        return Blue_West_Side_Of_Fissure;
    }
    kata = At_West_End_Of_Hall_Of_Mists
    ana2 = Green_West_End_Of_Hall_Of_Mists
;

Green_West_End_Of_Hall_Of_Mists: darkroom, NoNPC
    game701p = true
    analevel=2
    sdesc = "At West End of Hall of Mists (Green level)"
    ldesc = {I(); 
        "You are at the west end of the hall of mists.
        A low wide crawl continues west and another goes north, but the
        passage to the south is barred by a locked iron gate. A sign on the
        gate reads \"Elves' Quarters: No Unauthorized Access.\" ";
    }
    east = Green_West_Side_Of_Fissure
    west = Green_East_End_Of_Long_Hall
    crawl = Green_East_End_Of_Long_Hall

    north = {
        "%You% %have% crawled through a very low wide passage
        parallel to and north of the hall of mists.\b";

        return Green_West_Side_Of_Fissure;
    }
    kata = Blue_West_End_Of_Hall_Of_Mists
;

IronGate1: fixeditem, readable
    game701p = true
    sdesc = "gate"
    ldesc = "It's unlikely that you'll be able to open the gate.  A sign on
    the gate reads \"Elves Quarters: No Unauthorized Access.\" "
    noun = 'gate' 'sign'
    verDoUnlock(actor) = {self.ldesc;}
    verDoUnlockWith(actor,io) = {self.ldesc;}
    verDoOpen(actor) = {self.ldesc;}
    verDoClose(actor) = {"It's already firmly closed. ";}
    adjective = 'iron'
    location = Green_West_End_Of_Hall_Of_Mists
;

DisplayBoards: floatingdecoration, readable
    game701p = true
    isThem = true
    sdesc = "display boards"
    adesc = "display boards"
    ldesc = {
        if(not self.firstseen) {
            "The display boards are written in a version of English similar to
            your own.  Some spellings are different, and there are a few
            unfamiliar words, although you can usually guess their meaning. ";
            P();I();
            self.firstseen := true;
        }
        if (self.location = Blue_Hall_Of_Mists) {
            "The information here is mostly of little interest to 
            experienced spelunkers like you.  It tells you everything you 
            already know about stalactites, stalagmites, domes and crawls. 
            But one board is more interesting.  It describes an unsuccessful
            siege of the Castle of the Elves, which failed because the elves
            were able to bring in reinforcements and supplies by \"some
            unknown means.\"  Since then a peace treaty has been
            signed with the Castle Elves. ";
        }
        else if(self.location = Blue_West_End_Of_Hall_Of_Mists) {
            self.spanseen := true;
            "The display boards in this area describe how a new source of
            mithril silver was discovered.  At a later stage it was
            found that the metal could be drawn out into filaments, then
            spun into threads and woven into fabrics: \"When we span the
            threds from filaments less than 1/2000 in. across, it became 
            possible to weave a cloth with twice the strength of mithril 
            argent chainmail but only 1/20 of the weight. \"";
            if(manual.misunderstood) {
                P();
                "(For some reason the word \"span\" seems to stand out, as
                if the way it's used here has some special significance.) ";
            }
            P();
            "Other applications for the metal have
            been found in the chemical industry.  Mithril silver alloys are
            in general very resistant to corrosion and chemical attack, 
            particularly with the addition of a small percentage of gold.
            When this exceeds 2% the metal resists all acids including
            \"fluorohydrogen\". ";
        }
        else if(self.location = Blue_West_End_Of_Long_Hall) {
            "The display boards here are devoted to various aspects of elvish
            and dwarvish lore, none of which seem to be dismissed as old
            myths; for example, the existence of Transindection is said to
            be \"in accord with a current scientific hypothesis\".  You
            shudder at the implications, but then you read on 
            with interest: \"a discovery of a sealed vault containing
            Elvin treasures confirmed the existence of mithril argent
            and \"magic\" steels with remarkable properties. More details
            are in the Hall of the Mountain King.\" ";
        }
        else if (self.location = Blue_East_End_Of_Long_Hall) {
            "The boards in this area make depressing reading. 
            In order to convert it into a tourist attraction, the cave first
            had to be rid of all its vermin: the \"savage\" dwarves, 
            \"vicious\" elves, \"brutal\" gnomes and \"extortionist\" trolls.
            Then the floors were concreted over, the tunnels widened, and the 
            rooms lit by electric lights. ";
        }
        else if (self.location = Blue_Nugget_Of_Gold_Room) {
            "The boards here show pictures of many of the treasures found in 
            the cave, including the heavy nugget of gold found in this room. ";
            if(In_Nugget_Of_Gold_Room.isseen) "You stare at the picture - the
            nugget which was here looks exactly like the one you found at
            your own Transindection level. ";
            Blue_Nugget_Of_Gold_Room.seengold := true;
        }
        else if (self.location=Blue_Hall_Of_Mt_King) {
            "The boards here describe how the \"serpent\" was captured and 
            taken to the local \"menagerie\".  The Mountain King was defeated 
            and the elves were driven out of the cave.  Some time later, three
            sealed vaults were discovered during routine mining operations.  
            The finds included 53 gold and 61 mithril silver crowns, all inlaid
            with precious stones.  A nearby armory contained approximately 100 
            suits of mithril silver chain-mail and 80 steel swords.  The
            comment is made that the elves would have been almost invincible
            if they had been able to use these artefacts. ";
        }
    }        
    noun = 'board' 'boards'
    adjective = 'display'
    loclist = [Blue_Hall_Of_Mists, Blue_Nugget_Of_Gold_Room, 
        Blue_Hall_Of_Mt_King, Blue_West_End_Of_Hall_Of_Mists, 
        Blue_West_End_Of_Long_Hall, Blue_East_End_Of_Long_Hall]
;

Blue_East_End_Of_Long_Hall: room, NoNPC
    game701p = true
    analevel = 1
    sdesc = "At East End of Long Hall (Blue level)"
    ldesc = {I();
        "You are at the east end of a very long hall apparently without side
        chambers.  The floor has been concreted over and the room is lit by
        overhead electric lights.  There are a few display boards near the
        east wall.
        In the south wall are three wide cracks, but the middle and left
        cracks have been blocked up with concrete.  The familiar high hole is 
        also here, far above your head, but you notice that it is partly
        blocked by a large construction - a water tank, perhaps.
        To the east a wide tunnel slants up.  To the north a round eight foot
        hole slants down, but it is barred by a solid steel door." ;
    }
    hasfloor = true // room with a floor
    east = Blue_West_End_Of_Hall_Of_Mists
    up = Blue_West_End_Of_Hall_Of_Mists
    passage = Blue_West_End_Of_Hall_Of_Mists
    west = Blue_West_End_Of_Long_Hall
    climb = {"It is too far up for you to reach.";return nil;}
    right = Blue_Dead_End_Crack
    south = Blue_Dead_End_Crack
    middle = {
        "The middle crack has been blocked up with concrete. ";
        return nil;
    }
    left = {
        "The left crack has been blocked up with concrete. ";
        return nil;
    }
    kata = At_East_End_Of_Long_Hall
    ana2 = Green_East_End_Of_Long_Hall
;

Green_East_End_Of_Long_Hall: room, NoNPC
    game701p = true
    analevel = 2
    sdesc = "At East End of Long Hall (Green level)"
    ldesc = {I();
        "You are at the east end of a very long hall apparently without side
        chambers.
        In the south wall are several wide cracks and a high
        hole, but the hole is far above your head. To the east a wide crawl 
        slants up.  To the north a round two foot
        hole slants down. ";
    }
    east = Green_West_End_Of_Hall_Of_Mists
    up = Green_West_End_Of_Hall_Of_Mists
    crawl = Green_West_End_Of_Hall_Of_Mists
    west = Green_West_End_Of_Long_Hall
    north = {
        "You experience a strange tingling sensation as you enter the
        passage, then ...";
        P();
        return Green_Hall_Of_Mists;
    }
    down = {return self.north;}
    hole = {return self.north;}
    south = Green_Tight_Crack_2
    crack = {return self.south;}
    climb = {if(global.oldgame) pass climb;
            "It is too far up for you to reach.";return nil;}
    left = Green_Tight_Crack
    middle = Green_Tight_Crack_2
    right = Green_Dead_End_Crack
    kata = Blue_East_End_Of_Long_Hall
;

Blue_West_End_Of_Long_Hall: room, NoNPC
    game701p = true
    analevel = 1
    sdesc = "At West End of Long Hall (Blue level)"
    ldesc = {I(); 
         "You are at the west end of a very long hall, featureless
         except for a few display boards and overhead electric lights.  
         The hall joins up with a narrow
         north/south passage.";
    }
    hasfloor = true // room with a floor
    east = Blue_East_End_Of_Long_Hall
    north = {
        if (self.seennorth) {
            "You'd best not go that way again.  There's a security camera, and
            you don't want to be spotted. ";
        }
        else {
            "You proceed a short way down the north passage, but then you
            notice a security camera swinging to and fro on the wall ahead of
            you.  You quickly retreat back to the Long Hall. ";
            self.seennorth := true;
        }
        return nil;
    }
    south = {
        local actor := getActor(&travelActor);
        if (self.seensouth) {
            "You'd best not go that way again, after what nearly happened. ";
            return nil;
        }
        // If the pendant is in a container, try to remove it. 
        if ((pendant.location != actor) or not pendant.isworn) {
            // Try to unlock the chest if the keys are available (and not
            // locked in the chest)
            if (pendant.isInside(treasure_chest) and treasure_chest.isIn(actor)
            and treasure_chest.islocked) {
                if(set_of_keys.isInside(actor) and not 
                set_of_keys.isInside(treasure_chest))
                    if(set_of_keys.location != actor) 
                        set_of_keys.moveInto(actor);
                if(set_of_keys.isIn(actor)) {
                    treasure_chest.islocked := nil;
                    treasure_chest.isopen := true;
                }
            }
            // wear the pendant unless it's still locked in the chest
            if (pendant.isInside(actor) and not (treasure_chest.islocked and
            pendant.isInside(treasure_chest))) pendant.moveInto(actor);
            if (pendant.isIn(actor)) {
                pendant.moveInto(actor);
                pendant.isworn := true;
            }    
        }
        if (pendant.location != actor) {
            "You proceed a short way into the south passage, but a steel
            door slides shut behind you!  Before you have time to decide what
            to do, a second steel door closes in front of you, and an alarm
            sounds in the distance.  Unfortunately you ";
            if(pendant.isInside(actor))
                "can't get at the pendant, ";
            else
                "don't have the pendant, ";
            "so there's no option but to wait for your arrest. ";
            incscore(-50,'for getting yourself arrested at Blue level');
            scoreRank();
            exitprompt();
        }
        else {
            "You proceed a short way into the south passage, but a steel
            door slides shut behind you!  Before you have time to decide what 
            to do, a second steel door closes in front of you, and an alarm 
            sounds in the distance.  In a moment of panic, you think you
            are trapped - then remember the fifth dimension. A \"Kata\" takes 
            you back to safe territory ... ";
            P();
            self.seensouth := true;
            return Different_Maze_1;
        }
    }
    kata = At_West_End_Of_Long_Hall
    ana2 = Green_West_End_Of_Long_Hall   
;

Green_West_End_Of_Long_Hall: darkroom, NoNPC
    game701p = true
    analevel=2
    sdesc = "At West End of Long Hall (Green Level)"
    ldesc = {
         I(); "You are at the west end of a very long
         featureless hall.  The hall joins up with a narrow
         north/south passage.";
    }
    hasfloor = true // room with a floor
    east = Green_East_End_Of_Long_Hall
    south = {
        "You proceed into the
        maze of twisty little passages.  But there is something odd about it;
        you feel a strange tingling, and then ... ";
        P();
        return Green_Hall_Of_Mists;
    }
    north = {
        "You proceed a short way into the north passage, but then you feel
        a strange tingling sensation, and ... ";
        P();
        return Green_Nugget_Of_Gold_Room;
    }
    kata = Blue_West_End_Of_Long_Hall
;

Orange_Office: room, NoNPC
    game701p = true
    analevel = -1
    sdesc = "In Orange Level Office"
    ldesc = {I();
        "You're in an abandoned office.  The room is lit, but there is no
        obvious light source.  Most of the furniture and equipment have
        been removed, except for one large desk against the east wall and
        a series of plans on the north wall. ";
        if ((not self.isseen) and (global.view_artifact = Glass_Ball)) 
            "Somehow you know that this room is located near the Large
            Circular Room.  This is confirmed by the plans, which
            show that this room is located between the ";
        else
            "The plans show that this room is located between the ";
        "Large Circular Room and the Lower Transindection Chamber, but the
        floor level is much higher.  At other Transindection levels there is
        an access shaft with the same floor level.  The west end of each 
        shaft was originally entered from a ladder fixed to the east
        wall of the Large Circular Room, and the east end ";
        if (not Red_Access_East.isseen)        
            "opens into a Maintenance Room. ";
        else
            "once opened into a Maintenance room. ";
        P(); I();

        "A doorway leads out to the west";
        if (Orange_Maintenance_Room.isseen)
            ", and you can just make out the outline of a blocked-off doorway
            to the east, behind the desk. ";
        else
            ". ";
    }
    hasfloor = true // room with a floor
    down = Under_Desk
    in = Under_Desk
    east = {
       if(topaz.isInside(Orange_Maintenance_Room)) {
           "(climbing over the desk and passing through the east wall)\n";
           return Orange_Maintenance_Room;
       }
       else
           "You can't go any further east. ";
       return nil;
    }
    west = {
        "You walk down a flight of stone steps, and find yourself ...";
        P();
        return Orange_Large_Circular_Room;
    }
    backhints = [Orange_Large_Circular_Room, &west]
    ana = {
        "You carefully estimate the position of the access shaft, then
        lie on the floor before saying the word ...\b";
        return Red_Access_Shaft;
    }

;

Under_Desk: room, NoNPC
    game701p = true
    analevel = -1
    sdesc = "Under a Desk (Orange level)"
    ldesc = {I();
        "You are in a cramped space, bounded on three sides: the floor
        below you, a wall to the east, and the nearly featureless
        underside of the desk above you.  Other directions lead out to an 
        abandoned office. ";
    }
    hasfloor = true // room with a floor
    out = Orange_Office
    nw = Orange_Office
    sw = Orange_Office
    north = Orange_Office
    south = Orange_Office
    west = Orange_Office
    east = {
       if(topaz.isInside(Orange_Maintenance_Room))
           return Orange_Maintenance_Room;
       else if(Blue_Maintenance_Room.isseen)
           "The east wall is solid right now, and you can't pass through. "; 
       else
           "You can't go any further east. ";
       return nil;
    }
    ana = Red_Access_East
    exithints = [Orange_Maintenance_Room, &east]
;

UnderDesk: fixeditem, openable
    game701p = true
    sdesc = "desk"
    ldesc = {
        if (self.isopen)
            "The flap has been opened, revealing a secret compartment. ";
        else     
            "The underside of the desk looks completely smooth and
            featureless, but close examination reveals a hinge at the
            back. ";
    }      
    noun = 'desk' 'underside' 'flap'
    isopen = nil
    location = Under_Desk
    verDoLookunder(actor) = {}
    doLookunder(actor) = {self.doInspect(actor);}
    verDoLookin(actor) = {
        if (not self.isseen) 
            "You'll have to find a way to open the desk before you can do 
            that. ";
        else if (not self.isopen)
            "You'll need to open the compartment first. ";
    }
    doSearch(actor) = {
        if (itemcnt(self.contents))
             pass doSearch;
        else
             "The compartment now contains nothing but dust and pencil
             sharpenings. ";
    }
    verDoOpen(actor) = {
        if (not self.isseen) 
            "You'll have to tell me how to do that. ";
        else pass verDoOpen;
    }
    verDoPull(actor) = {
        "You can't get a grip on the underside of the desk to pull it down. ";
    }
    verDoPush(actor) = {}
    ioPutIn(actor,dobj) = {
        if(dobj.islarge or dobj.ishuge or dobj.islong) "It won't fit. ";
        else pass ioPutIn;
    }
    doOpen(actor) = {
        self.doPush(actor);
    }
    doClose(actor) = {
        self.doPush(actor);
    }
    doPush(actor) = {
        if(not self.isopen and not self.isseen_thistime) {
            if(self.isseen)
                "You push the underside of the desk to reveal the secret
                compartment.  You take the iron key from the compartment. ";
            else
                "You firmly push the underside of the desk.  It moves upwards 
                about half an inch, then a catch mechanism releases with a 
                definite \"click\".  The flap then drops down, revealing a 
                secret compartment!   You rummage around, finding nothing but 
                dust and pencil sharpenings at first - but then your 
                persistence is rewarded.  You find a large iron key, which 
                you take! ";
            iron_key.moveInto(actor);
            self.isseen := true;
            self.isseen_thistime := true;
            self.isopen := true;
            addword(self,&noun,'compartment');
            addword(self,&adjective,'secret');
            Compartment.moveInto(Orange_Office);
        }
        else if (not self.isopen) {
            "You push the flap again, and it drops down to reveal the secret
            compartment. ";    
            self.isopen := true;
        }
        else {
            "You push the flap back up.  The catch operates, and the flap
            falls down about half an inch to rest in its original position. ";
            self.isopen := nil;
        }
    }
    verDoUnboard(actor) = {}
    doUnboard(actor) = {
        actor.travelTo(Orange_Office);
    }
;

Sharpenings: floatingdecoration, decoration
    sdesc = "dust and pencil sharpenings"
    ldesc = "The dust and pencil sharpenings are useless detritus.  I suggest 
            you leave them where they are. "
    isThem = true
    noun = 'dust' 'sharpenings'
    adjective = 'pencil'
    loclist = [UnderDesk]
;

Hinge: fixeditem
    game701p = true
    sdesc = "hinge"
    ldesc = "The hinge is at the back of the desk.  I suspect that the
        underside will open, if you can work out how to do it. "
    noun = 'hinge'
    location = Under_Desk 
;

Orange_Plans: fixeditem, readable
    game701p = true
    sdesc = "plans"
    ldesc = {
        local actor := global.verbActor;
        "They show this room and the access shafts at other Transindection
        levels. ";

        P(); I();  "The east end of each access shaft leads to a 
        maintenance room, and the door at the west end could originally be
        reached from a fixed ladder in the Large Circular Room.  On close
        examination, you notice penciled alterations which show what you 
        already know: the ladders have been removed and the maintenance rooms
        have been sealed off. ";

        if(actor.isIn(Desk) and actor.posture = 'standing') {
            P(); I();  "From this position you can see a note on one of the
            plans, written in very small but very neat lettering.  It reads 
            \"Control Room emergency exit: deactivate the switches for the
            vasular and Eldrand-Playfair interlocks, then activate the chamber 
            extension switch.\" I'll leave you to figure out what it all 
            means. ";
        }
    }
    location = Orange_Office
    noun = 'plans'
;   

Desk: fixeditem, beditem
    game701p = true
    sdesc = "desk"
    ldesc = "All the drawers have been removed. "
    location = Orange_Office
    noun = 'desk' 'bottom'
    adjective = 'false'
    verDoOpen(actor) = {
        "You can't open the desk from here. ";
    }
    verDoPush(actor) = {
        "You won't achieve much by trying to push the desk from here. ";
    }
    verDoHideunder(actor) = {}
    doHideunder(actor) = {
        actor.travelTo(Under_Desk);
    }
    verDoLookin(actor) = {}
    verDoSearch(actor) = {self.verDoLookin(actor);}
    doSearch(actor) = {
        "At first sight the desk appears to be empty, apart from dust and
        pencil sharpenings - but then you notice something odd.  It would
        appear that this desk has a false bottom! ";
        Sharpenings.moveLoclist([UnderDesk Orange_Office]);
    }
    doLookin(actor) = {self.doSearch(actor);}
    verDoLookunder(actor) = {}
    doLookunder(actor) = {
        if(UnderDesk.isopen) {
            "You can see that the secret compartment has been opened, but
            you'll need to go back under the desk to examine it more 
            closely. ";
        }
        else {
            "All you can see is the smooth underside of the desk.  Maybe you'd
            see more if you went ";
            if (Under_Desk.isseen)"back under"; 
            else "under";
            " the desk. ";
        }
    }
    east={return Under_Desk.east;}
    north={return self.location;}
    south={return self.location;}
    west={return self.location;}
    nw={return self.location;}
    sw={return self.location;}
    down={return self.location;}
    say_posture = true // mention posture in room description
    default_posture = 'standing' // stand on desk by default
    verDoStandon( actor ) = {  // DJP - added
        if ( actor.location = self and (actor.posture = 'standing'))
        {
            "%You're% already "; self.statusPrep; " ";
            self.thedesc; "! ";
        }
    }
    doStandon(actor) = {
        "Okay, %you're% now standing "; 
        if (self.onroom) "on "; else "in "; 
        self.thedesc; ". ";
        actor.moveInto(self);
        actor.posture := 'standing';
    }
    reachable = ([] + self + Orange_Plans + Walls)
;

Compartment: fixeditem
    game701p = true
    sdesc = "secret compartment"
    ldesc = "You won't be able to see much of the compartment unless you go
        back under the desk. "
    noun = 'compartment'
    adjective = 'secret'
    dobjGen(a, v, i, p) =
    {
        if ((v <> inspectVerb) and (v <> gonearVerb) and (v <> countVerb))
        {
            "I suggest that you go back under the desk before trying to 
            do that. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        if (v = waveVerb or v = askVerb or v = tellVerb) return;
        self.dobjGen(a, v, d, p);
    }
;

Red_Access_Shaft: darkroom, NoNPC
    game701p = true
    isolated = true // no path to main Red-level area without Transindection
    // don't allow player to escape by drinking wine, unless he has the
    // means to leave
    sober = {
        if (pendant3.isIn(Me) and pendant3.isworn) return nil;
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        return true;
    }
    sdesc = "Access Shaft (Red level)"
    ldesc = {I();
        "You're in a cramped, almost featureless E/W access shaft cut into
        the solid rock.   There is ";
        if (Red_Access_Shaft_Grille.isopened) "an unlocked ";
        else if(Red_Access_Shaft_Grille.isfoundlocked) "a locked ";
        else "an apparently locked ";
        "iron grille to the east and a locked door at the west. ";
        if (not self.isseen and not pendant2.moved and not pendant3.moved)
        "You have an uncomfortable feeling that you are trapped here, unless
        you can find a way out. ";
    }
    hasfloor = true // room with a floor
    west = RB_Access_Shaft_Door
    east = Red_Access_Shaft_Grille
    ana = Blue_Access_Shaft
    kata3 = {
        if (Wumpi.phase < 5 and Wumpi.phase > 0) Wumpi.phase := 5;
        return Orange_Office;
    }
    westpassage = true
;

Blue_Access_Shaft: darkroom, NoNPC
    game701p = true
    analevel = 1
    sober = {
        if (pendant3.isIn(Me) and pendant3.isworn) return nil;
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        return true;
    }
    sdesc = "Access Shaft (Blue level)"
    ldesc = {I();
        "You're in a cramped, almost featureless E/W access shaft cut into
        the solid rock.   There is ";
        if(Blue_Access_Shaft_Grille.isfoundlocked) "a locked ";
        else "an apparently locked ";
        "iron grille to the east and a locked door at the west. ";
    }
    hasfloor = true // room with a floor
    west = RB_Access_Shaft_Door
    east = Blue_Access_Shaft_Grille
    ana2 = Green_Access_Shaft
    kata = Red_Access_Shaft
    westpassage = true
;

Green_Access_Shaft: darkroom, NoNPC
    game701p = true
    sdesc = "Access Shaft (Green level)"
    ldesc = {I();
        "You're in a cramped, almost featureless E/W access shaft cut into
        the solid rock.   There is ";
        if(Green_Access_Shaft_Grille.isfoundlocked) "a locked ";
        else "an apparently locked ";
        "iron grille to the east and an unlocked door at the west. ";
    }
    hasfloor = true // room with a floor
    analevel = 2
    west = Green_Access_Shaft_Door
    east = Green_Access_Shaft_Grille
    kata = Blue_Access_Shaft
    westpassage = true
;

Red_Access_East: darkroom, NoNPC
    game701p = true
    isolated = true // no path to main Red-level area without Transindection
    sober = {
        if (pendant3.isIn(Me) and pendant3.isworn) return nil;
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        return true;
    }
    sdesc = "East Access Shaft (Red level)"
    ldesc = {I();
        "You're in a cramped E/W access shaft with ";
        if (Red_Access_Shaft_Grille.isopened) "an unlocked ";
        else "an apparently locked ";
        "iron grille to the west.  The east end of the passage dead-ends in
        a solid, smooth wall of concrete. ";
        if (not self.isseen and not pendant2.moved and not pendant3.moved) {
            P(); I();
            "You feel even more despondent.  This room is supposed to be an
            'access shaft', and you seem to recall that the plans showed a
            small room at the end.  However, if there is a room, it's 
            firmly blocked now.  How will you get out of here? ";
        }
        
    }
    hasfloor = true // room with a floor
    west = Red_Access_Shaft_Grille
    ana = Blue_Access_East
    kata3 = {
        if (Wumpi.phase < 5 and Wumpi.phase > 0) Wumpi.phase := 5;
        return Under_Desk;
    }
    east = {
       if(topaz.isInside(Red_Maintenance_Room))
           return Red_Maintenance_Room;
       else
           "You can't go any further east. "; 
       return nil;
    }
    exithints = [Red_Maintenance_Room, &east]
;

Blue_Access_East: darkroom, NoNPC
    game701p = true
    analevel = 1
    sober = {
        if (pendant3.isIn(Me) and pendant3.isworn) return nil;
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        return true;
    }
    sdesc = "East Access Shaft (Blue level)"
    ldesc = {I();
        "You're in a cramped E/W access shaft with ";
        if(Blue_Access_Shaft_Grille.isfoundlocked) "a locked ";
        else "an apparently locked ";
        "iron grille to the west.  The east end of the 
        passage dead-ends in a damaged concrete wall. ";
    }
    hasfloor = true // room with a floor
    west = Blue_Access_Shaft_Grille
    ana2 = Green_Access_East
    kata = Red_Access_East
    east = {
       if(topaz.isInside(Blue_Maintenance_Room))
           return Blue_Maintenance_Room;
       else if(Hole_BAE.isIn(self)) 
           "The hole is far too small to enter. ";
       else
           "You can't go any further east. "; 
       return nil;
    }
    exithints = [Blue_Maintenance_Room, &east]
;
Concrete_RGAE: floatingdecoration
    game701p = true
    sdesc = "concrete wall"
    otherside = {
        if((self.location = Under_Desk) or (self.location = Orange_Office))
            return Orange_Maintenance_Room;
        else if(self.location = Red_Access_East)
            return Red_Maintenance_Room;
        else
            return Green_Maintenance_Room; 
    }
    ldesc = {
        if(not topaz.isInside(otherside))
            "The wall is absolutely solid.  There's no way you can get
            through it. ";
        else
            "Your hand passes through the wall as if it isn't there. ";
    }

    noun = 'wall'
    adjective = 'concrete' 'east' 'eastern'
    loclist = [Under_Desk, Red_Access_East, Green_Access_East, Orange_Office]
    verDoAttack(actor) = {
        if(not topaz.isInside(otherside))
             "The wall holds firm against your onslaught. ";
    }
    verDoAttackWith(actor,io) = {self.verDoAttack(actor);}
    verDoKick(actor) = {self.verDoAttack(actor);}
    doAttackWith(actor,io) = {
        caps(); io.thedesc; "passes straight through the wall as if there's
        nothing there!";
    }
    doAttack(actor) = {
        "Your hands pass straight through the wall as if there's
        nothing there!";
    }
    doKick(actor) = {
        "Your legs pass straight through the wall as if there's
        nothing there!";
    }
    doEnter(actor) = {actor.travelTo(self.location,&east);} 
    doBoard(actor) = {self.doEnter;}
    verDoTouch(actor) = {}
    doTouch(actor) = {
        if (topaz.isInside(otherside))
             "Your hand passes straight through the wall. ";
        else
             "You feel nothing unexpected. ";
    }
;    

Concrete_BAE: fixeditem
    game701p = true
    sdesc = "concrete wall"
    otherside = Blue_Maintenance_Room
    ldesc = {
        if(topaz.isInside(otherside))
            "The wall still looks the same, but your hand now passes
            straight through it, as if it isn't there!";
        else if(self.holed)
            "Further examination of the wall reveals no further areas of
            weakness, apart from the hole you have made. ";
        else {
            "Unlike other concrete walls you have seen, this one appears to 
            have been attacked with a sledgehammer.  There are numerous
            holes about half an inch deep and three inches in diameter, behind
            which there is a finely-woven mesh of mithril silver wires.  No
            sledgehammer could get through that!   The exception is a 
            discolored area near the north wall, which appears to have been
            attacked by some kind of chemical.  You prod the area with your 
            foot, and find that the silver wires have now lost all their 
            strength.  So has the concrete behind, which is now so soft 
            that ... ";
            P(); I();
            "Oh! You've made a small hole through to the next room! ";
            Hole_BAE.moveLoclist([Blue_Access_East, Blue_Maintenance_Room]);
            self.holed := true;
        }
    }    
    noun = 'wall'
    adjective = 'concrete' 'east' 'eastern' 'damaged'
    location = Blue_Access_East
    verDoAttack(actor) = {
        if (self.holed and not topaz.isInside(otherside))
             "You are unable to make the hole any larger. ";
    }
    // brute force doesn't work in this case...
    doAttack(actor) = {
        if(topaz.isInside(otherside))
            "Your hand now passes
            straight through the wall, as if it isn't there! ";
        else
            "You aim a firm blow at the center of the wall, but it holds firm
            against your onslaught.  ";
    }
    verDoAttackWith(actor,io) = {self.verDoAttack(actor);}
    doAttackWith(actor,io) = {
        if(topaz.isInside(otherside)) {
            caps; io.thedesc; "passes right through the wall as if it isn't
            there! ";
        }
        else
            self.doAttack(actor);
    }
    verDoKick(actor) = {
        if (self.holed and not topaz.isInside(otherside))
             "You are unable to make the hole any larger. ";
    }
    doKick(actor) = {
        if(topaz.isInside(otherside))
            "Your leg passes right through the wall as if it isn't
            there! ";
        else
            "You aim a mighty kick at the center of the wall, but it
            holds firm against your onslaught. ";
    }
    verDoEnter(actor) = {}
    verDoBoard(actor) = {}
    doEnter(actor) = {actor.travelTo(self.location,&east);} 
    doBoard(actor) = {self.doEnter;}
    verDoTouch(actor) = {}
    doTouch(actor) = {
        if (topaz.isInside(otherside))
             "Your hand passes straight through the wall. ";
        else
             "You feel nothing unexpected. ";
    }
;

Hole_BAE: floatingdecoration
    sdesc = "small hole"
    otherside = {
        if(self.location = Blue_Access_East)
            return Blue_Maintenance_Room;
        else
            return Blue_Access_East;
    }
    ldesc = {
        local actor := getActor(&verbActor);
        if (self.location = Blue_Maintenance_Room)
            "You see nothing unexpected. ";
        else if (self.searched or (pendant3.location != Blue_Level_Hooks)) {
            self.searched := true;
            Fakehooks.moveInto(self.location);
            if (pendant3.location = Blue_Level_Hooks) {
                "You retrieve the orange pendant from the hook. ";
                pendant3.moveInto(actor);
                pendant3.isworn := true;
                pendant3.wearproc(actor);
            }
            else if (itemcnt(Blue_Level_Hooks.contents)) {
                "You see at least one object hanging on the hooks, but it's out
                of reach from here. ";
            }
            else {
                "You see a row of empty hooks through the hole, but there is
                nothing else you could take.. ";
            }
        }
        else {
            "You peer through the hole, and see a row of hooks along the
            north wall.  Most of them are empty, but on one of them hangs an
            orange plastic pendant, identical in size to your gold pendant.
            And it's just within reach!  You carefully put your hand through 
            the hole, taking care not to touch the damaged concrete with your
            bare skin.  Then you take the pendant and slip it on. ";
            pendant3.moveInto(actor);
            pendant3.isworn := true;
            pendant3.wearproc(actor);
            self.searched := true;
            Fakehooks.moveInto(self.location);
        }
    }
    heredesc = {
        P(); I();
        "You have made a small hole in the concrete wall. ";
    }
    noun = 'hole'
    adjective = 'small'
    verDoLookin(actor) = {}
    verDoLookthru(actor) = {}
    verDoSearch(actor) = {}
    doLookin(actor) = {self.ldesc;}
    doLookthru(actor) = {self.ldesc;}
    doSearch(actor) = {self.ldesc;}
    verDoEnter(actor) = {"It's far too small to enter! ";} 
    verDoBoard(actor) = {"It's far too small to enter! ";} 
    verDoAttack(actor) = {
        if(not topaz.isInside(Blue_Maintenance_Room)) {
            "You attempt to enlarge the hole, but this has
            little effect.  It's still too small for you to pass through. ";
        }
    }
    verDoAttackWith(actor,io) = {self.verDoAttack(actor);}
    doAttack(actor) = {
        "Your hands pass straight through the wall. ";
    }
    verDoKick(actor) = {
        if(not topaz.isInside(Blue_Maintenance_Room)) {
            "You attempt to enlarge the hole, but this has
            little effect.  It's still too small for you to pass through. ";
        }
    }
    doKick(actor) = {
        "Your foot passes straight through the wall. ";
    }
    doAttackWith(actor,io) = {
        caps(); io.thedesc; "passes straight through the wall as if it
        isn't there. ";
    }
    verIoPutIn(actor) = {}
    verIoPutThrough(actor) = {}
    ioPutIn(actor,dobj) = {
        if(dobj = ming_vase) {
            "You'd might break <<dobj.thedesc>> if you put it through a
            hole. ";
            return;
        }
        if((not Blue_Maintenance_Room.isseen) and not ((dobj = topaz) and 
        manual.isread)) {
            "If you did that, you might never get <<dobj.thedesc>> back! ";
            return;
        }
        if(((dobj = topaz) or topaz.isInside(dobj)) and 
        (otherside != Blue_Maintenance_Room)) {
            "You start to put <<dobj.thedesc>> through the hole, and the
            wall solidifies.  You realize that you'd be trapped in here if
            you put the topaz outside, so you bring it back
            in. ";
            return;
        }
        if(dobj = topaz and (not Blue_Maintenance_Room.isseen)) {
            "Your mind goes back to the penciled note in the Control Room
            manual.  There was something to the effect that the 
            \"Permeation field\" 
            outside the Maintenance Room was too weak to activate the damaged 
            topaz. But if you put the topaz inside ... ";
            P(); I();
            "You reach through the hole, taking care not to let your bare
            skin touch the damaged concrete.  You gently set down the
            Topaz on the floor of the room beyond, and at first you think
            that nothing has happened.  Then you realize - with a start - that
            your arm has passed right through the wall! ";
        }
        else {
            "You carefully put <<dobj.thedesc>> through the hole. ";
        }
        dobj.moveInto(otherside);
        if((dobj = topaz) and (otherside = Blue_Maintenance_Room))
    }
    ioPutThrough(actor,dobj)={self.ioPutIn(actor,dobj);}
    loclist = []
    verDoTouch(actor) = {
        "That part of the wall appears to have been attacked with a corrosive
        chemical.  I wouldn't advise you to touch it with your hands. ";
    }
    verDoRub(actor) = {
        "That part of the wall appears to have been attacked with a corrosive
        chemical.  I wouldn't advise you to touch it with your hands. ";
    }
;
     
Fakehooks: fixeditem
    sdesc = "hooks"
    isThem = true
    ldesc = {Hole_BAE.ldesc;}
    verIoPutOn(actor) = {
        "There's no point in trying to put anything onto the hooks from
        here. ";
    }
    noun = 'hook' 'hooks'
    verDoLookon(actor) = {}
    DoLookon(actor) = {self.ldesc;}
;

Green_Access_East: darkroom, NoNPC
    game701p = true
    sober = {
        if (pendant3.isIn(Me) and pendant3.isworn) return nil;
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        return true;
    }
    sdesc = "East Access Shaft (Green level)"
    ldesc = {I();
        "You're in a cramped E/W access shaft with ";
        if(Blue_Access_Shaft_Grille.isfoundlocked) "a locked ";
        else "an apparently locked ";
        "iron grille to the west.  The east end of the 
        passage dead-ends in a solid, smooth wall of concrete. ";
    }
    hasfloor = true // room with a floor
    analevel = 2
    west = Green_Access_Shaft_Grille
    kata = Blue_Access_East
    east = {
       if(topaz.isInside(Green_Maintenance_Room))
           return Green_Maintenance_Room;
       else
           "You can't go any further east. "; 
       return nil;
    }
    exithints = [Green_Maintenance_Room, &east]
;

RB_Access_Shaft_Door: floatingdecoration, CCR_lockableDoorway
    game701p = true
    externalDoor = nil //not a cave exit
    isopen = nil
    islocked = true
    sdesc = "small door"
    ldesc = "It's a small door at the west end of the shaft.  Unfortunately
        it appears to be firmly locked from the other side. "
    noun = 'door'
    adjective = 'small'
    verDoOpen(actor) = {
        "The door appears to be locked from the other side.  There's no way
        to open it from here. ";
    }
    verDoUnlock(actor) = {
        "The door appears to be locked from the other side.  There's no way
        to unlock it from here. ";
    }
    verDoUnlockWith(actor, io) = {
        self.verDoUnlock(actor);
    }
    adjective = 'door'
    doordest = nil
    mykey = office_keys //unobtainable
    loclist = [Red_Access_Shaft, Blue_Access_Shaft]
;

Green_Access_Shaft_Door: CCR_doorway
    game701p = true
    externalDoor = nil //not a cave exit
    isopen = nil
    sdesc = "small door"
    ldesc = "It's a small door at the west end of the shaft. "
    noun = 'small'
    adjective = 'door'
    verDoLock(actor) = {
        "It's unlikely that you'd be able to lock the door again, even if
        you found the right key. ";
    }
    verDoLockWith(actor) = {
        self.verDoLock(actor);
    }
    adjective = 'door'
    doordest = Top_Of_Blocks
    destination = {
        if((Wumpi.phase < 5) and (Wumpi.phase > 0)) {
            "Maybe you could go back there later, but I wouldn't advise you
            to risk disturbing the Wumpi right now.  I strongly suggest that 
            you find another way out of here. ";
            return nil;
        }
        else pass destination;
    }
    mykey = office_keys //unobtainable
    location = Green_Access_Shaft
    otherside = Access_Shaft_Door
;

class Access_Shaft_Grille: floatingdecoration, CCR_lockableDoorway
    game701p = true
    // Don't open this door automatically unless the player knows it's
    // not really locked.
    noAutoOpen = {return (not self.isopened);}
    sdesc = "rusty iron grille"
    ldesc = {
        "It's like the steel grating at the entrance to the cave.  At
        present it ";
        if (self.isopened) {
            if (self.isopen)
                 "is open and unlocked. ";
            else
                 "is closed but unlocked. ";
        }
        else {
            "is closed and ";
            if (self.isfoundlocked)
                 "locked. ";
            else
                 "appears to be locked, although it's hard to be sure. ";
            "The lock looks badly rusted, so I doubt whether you'd get it 
            open even if you found the right key. ";
        }
    }
    externalDoor = nil // not a cave exit
    isopen = nil
    isopened = nil     // has not been opened
    setIsopen(setting) = {
        inherited.setIsopen(setting);
        if(setting = true) {
            /* flag all relevant doors as opened */
            local cur, i, tot;
            tot := length (self.doorlist);
            for (i := 1; i <= tot; i++) {
                cur := self.doorlist[i];
                cur.isopened := setting;
            }
        }
    }
    islocked = true
    mykey = office_keys //unobtainable
    noun = 'grill' 'grille' 'grating' 'grate'
    adjective = 'iron' 'rusty'
    doordest = nil
    verDoOpen(actor) =
    {
        if (self.isopen)
            "\^<<self.itisdesc>> already open. ";
    }
    doOpen(actor) =
    {
        if(self.islocked) {
            if(self.isfoundlocked) 
                 "It's locked. ";
            else if (self.isoiled) {
                 "You give firmly ";
                 if (actor.location.westpassage) "push"; else "pull";
                 " the grille and it begins to move
                 easily, thanks to the oil.  Unfortunately it only opens
                 about a quarter of an inch.  You rattle the grille and
                 conclude that it really is locked. ";
            }
            else {
                 "You ";
                 if (actor.location.westpassage) "push"; else "pull";
                 " the rusty grille with all your might.  It moves about a
                 quarter of an inch but then fails to open any further.
                 You rattle it and conclude that the lock is holding it shut, 
                 not the rusty hinges.  It really is locked. ";
            }
            self.isfoundlocked := true;
        }
        else if(self.isopened) {
             "Opened. ";
             self.setIsopen(true);
        }
        else {
             if (self.isoiled)
                 "You give the grille a firm push and it swings open easily, 
                 thanks to the oil.  It wasn't locked after all! ";
             else
                 "You push the rusty grille with all your might.  Suddenly it
                 gives way and swings open! ";
             self.setIsopen(true);
        }
    }
    verDoPush(actor) = {
        if(self.location.westpassage) self.verDoOpen(actor);
        else self.verDoClose(actor);
    }
    doPush(actor) = {
        if(self.location.westpassage) self.doOpen(actor);
        else self.doClose(actor);
    }
    verDoPull(actor) = {
        if(self.location.westpassage) self.verDoClose(actor);
        else self.verDoOpen(actor);
    }
    doPull(actor) = {
        if(self.location.westpassage) self.doClose(actor);
        else self.doOpen(actor);
    }
    // Before we know the grille is unlocked, we should be allowed to try
    // keys in the lock.
    verDoUnlock(actor) = {
        if(not self.isopened) return;
        else pass verDoUnlock;
    }
    // Before we know the grille is locked, we should be allowed to 
    // attempt to lock it.
    verDoLock(actor) = {
        if(not self.isfoundlocked) return;
        else pass verDoLock;
    }
;

Red_Access_Shaft_Grille: Access_Shaft_Grille
    game701p = true
    islocked = nil
    isopen = nil
    loclist = [Red_Access_Shaft, Red_Access_East]
    doordest = {
        if (self.location = Red_Access_Shaft) return Red_Access_East;
        else return Red_Access_Shaft;
    }
    doordestOK = true // OK to use doordest in BACK command etc.
;

Blue_Access_Shaft_Grille: Access_Shaft_Grille
    game701p = true
    loclist = [Blue_Access_Shaft, Blue_Access_East]
;

Green_Access_Shaft_Grille: Access_Shaft_Grille
    game701p = true
    loclist = [Green_Access_Shaft, Green_Access_East]
;


Green_Steel_Cage: darkroom, NoNPC
    game701p = true
    analevel = 2
    sdesc = "Steel Cage (Green level)"
    ldesc = {
        "You're in a featureless steel cage in the shape of a cube, about
         seven feet on a side. ";
        if(self.isdotroom)
                "The floor at this Level also looks subtly different. ";
    }
    hasfloor = true // room with a floor
    hasfloordesc = {return self.isdotroom;}
    /* This room can potentially be made into a dotroom (not done at present)
     */
    floordesc = {
        if (self.isdotroom)
            "The floor is now a subtle shade of blue.  You feel sure that the
            color was different when you first came here. ";
    }
    kata = Blue_Steel_Cage
    east = Green_Control_Door_Inner
    out = {return self.east;}
;

Blue_Steel_Cage: darkroom, NoNPC
    game701p = true
    analevel = 1
    // don't allow player to escape by drinking wine, unless he has the
    // means to leave
    sober = {
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        else return true;
    }
    sdesc = "Steel Cage (Blue level)"
    ldesc = {
        "You're in a featureless steel cage with no apparent exits. ";
        if(self.isdotroom)
                "The floor looks subtly different. ";
        else if(not self.isseen) {
            "Once again you have an uncomfortable feeling that you may be
            trapped here,";
            if (Control_Room.seenit) 
                " but then you remember that you've seen a green pendant in
                the Control Room, and you feel certain that it will get 
                you out of here. ";
            else
                " unless you're very lucky; maybe you'll find another
                pendant which will get you out of here. ";
        }
    }
    hasfloor = true // room with a floor
    hasfloordesc = {return self.isdotroom;}
    floordesc = {
        if (self.isdotroom)
            "The floor is now a subtle shade of green.  You feel sure that the
            color was different when you first came here. ";
    }
    kata = Control_Room
    ana2 = Green_Steel_Cage
;

Control_Room: room, NoNPC
    game701p = true
    isolated = true // no path to main Red-level area without Transindection
    sober = true // no drinking here!
    sdesc = "Transindection Control Room"
    ldesc = {
        local actor := getActor(&verbActor);
        I();
        "You're in the Transindection control room.  The room is lit, but with
        no obvious source of light.  Apart from a small area in the center, the
        room is filled with cabinets with many rows of color-coded levers,
        dials and switches.  All of this equipment looks very old and
        neglected, and you feel disinclined to tamper with it.  Against one
        wall you see a more familiar set of controls: a row of colored buttons
        like those in the Lower Transindection Rooms.  A small label below the
        buttons suggests that their function may be relatively unimportant.  It
        reads \"Lower Anteroom Lighting.\" ";
        P(); I();
        if (pendant2.moved) {
            "In the center of the room you see several rocks which have 
            apparently fallen from the ceiling.  Near one of them lies 
            the skeleton of Eldrand, who was sent here many years ago to 
            de-activate the Transindection Chambers. ";
        }
        else if (global.onlyviewing) {
            "In the center of the room you see several rocks which have 
            apparently fallen from the ceiling.  Under one of them there is a 
            skeleton - it's probably Eldrand, who was sent here
            many years ago to de-activate the Transindection Chambers.
            You try to move the rock, but you can't because you're not 
            really here.  However, you do notice that the skeleton is
            wearing a green pendant. ";
            return;
        }
        else if (not self.isseen) {
            "In the center of the room you see several rocks which have 
            apparently fallen from the ceiling.  Under one of them there is a
            skeleton,  apparently of an elf - it's probably Eldrand, who was 
            sent here many years ago to de-activate the Transindection 
            Chambers. ";
            if (self.seenit)
                "Once again, you see ";
            else {
                "You notice ";
                self.seenit := true;
            }
            "a green pendant around the neck of the skeleton. ";
            P(); I();
            "With great effort you move the rock away from the body, then
            remove the pendant. Almost without thinking, you slip it on. ";
            pendant2.moveInto(actor);
            pendant2.isworn := true;
            pendant2.wearproc(actor);
            pendant2.obtained := true; // obtained by the normal method
        }
        else {
            "In the center of the room you see a large rock which has apparently
            fallen from the ceiling.  Beside it there is a badly crushed
            skeleton, apparently of an elf.  This must be Eldrand; according
            to the history book he was sent here to de-activate all the
            Transindection facilities, but never returned.  ";
        }
    }
    hasfloor = true // room with a floor
    hasfloordesc = {return self.isdotroom;}
    floordesc = {
        if (self.isdotroom)
            "You didn't notice when it changed, but the floor is now a subtle 
            shade of blue.  You feel sure that the
            color was different when you first came here. ";
    }
    kata = Control_Room
    ana = Blue_Steel_Cage
    east = {
        "The passage which once led to the east is blocked by rock falls. ";
        return nil;
    }
;

LightingButtonLabel: fixeditem, readable
    game701p = true
    sdesc = "small label"
    noun = 'label'
    adjective = 'small'
    ldesc = "It is written in Elvish and English.  The English version
        reads \"Lower Anteroom Lighting.\" "
    location = Control_Room
;

Empty_Container: fixeditem, readable
    game701p = true
    isListed = true
    sdesc = "broken container"
    noun = 'container'
    adjective = 'broken' 'small'
    ldesc = "It's a small, broken container made of an unfamiliar brown
        material.  A discolored label on the side reads \"Danger - aqua 
        mithrilis (hydrofluoric acid/ fluorohydrogen).\" "
    verDoTake(actor) = {
        "The label indicates that this container held hydrofluoric acid.
        Alarm bells ring in your mind when you recall your school chemistry 
        lessons.  You'd better leave well alone. ";
    }
    location = Control_Room
;


Elf_Skeleton: fixeditem
    game701p = true
    sdesc = "skeleton"
    ldesc = "The skeleton appears to have been here for a long time, and
        the skull and upper torso have been badly crushed, apparently by the
        nearby rock.  Remnants of clothing on the body look Elvish in 
        appearance. "
    noun = 'skeleton' 'clothing' 'body' 'bones' 'elf' 'eldrand' 'corpse'
    adjective = 'elfin' 'elvish'
    verDoSearch(actor) = {}
    doSearch(actor) = {
        if(self.searched)
            "You search the body again, but find nothing else. ";
        else {
            self.searched := true;
            "You search the body for
            other possessions.  You find a manual for the control room, which
            you take; maybe there will be useful information in there.  The 
            only other objects you find are broken,
            crushed by the stone: a shattered pendant and a damaged key. ";
            manual.moveInto(Me);
            // N.B. only the broken pendant is a red herring object.
            broken_key.moveInto(Control_Room); 
            broken_pendant.moveInto(Control_Room);
        }
    }
    verDoLookin(actor)={}
    doLookin(actor)={self.doSearch(actor);}
    location = Control_Room
;

Control_Room_Rock: fixeditem
    game701p = true
    sdesc = "large rock"
    ldesc = "It's almost to heavy to move. "
    noun = 'rock' 'stone'
    adjective = 'large'
    verDoMove(actor) = {
        if(actor.maxweight > 20) {
            if(mushroom.is_eaten)
                "Despite your bulging muscles, you'll";
            else
                "Despite your increased strength, you'll";
        }
        else "You'll";
        " probably do yourself an injury if you try to move the rock again. ";
    }
    verDoTake(actor) = {self.verDoMove(actor);} 
    location = Control_Room
;

Controls: fixeditem
    game701p = true
    sdesc = "controls and switches"
    ldesc = "The cabinets are made from a nondescript gray metal.  Each one
        has many rows of color-coded dials, levers and switches.  None of them
        are labelled, so you have no clue to their function.  It occurs to you
        that it would be dangerous to tamper with them; you'd either trap
        yourself here for ever, or trigger another rock-fall. "
    location = Control_Room
    noun = 'controls' 'switch' 'switches' 'dial' 'dials' 'lever' 'levers'
           'cabinet' 'cabinets'
    verDoTurn(actor) = {}
    verDoPull(actor) = {}
    verDoPush(actor) = {}
    verDoTurnon(actor) = {}
    verDoTurnoff(actor) = {}
    doTurn(actor) = {
        if(self.turned) { 
             "You decide not to interfere with the dials again, after what
             happened last time. ";
             return;
        }
        "You turn one of the dials.  The room brightens, but then you
        notice that something is wrong!  Choking fumes are emerging from
        a vent in the floor.  Hurriedly, you turn the dial back.  The room
        dims again and the fumes subside, but you'll need to get out of
        here for a while. ";
        self.turned := true;
        self.fumeturns := self.fumeduration;
        self.fumeturn := -1;
        notify(self,&fumedaemon,0);
    }
    fumeturns = 0
    fumeduration = 5 // number of turns before fumes subside
    doPull(actor) = {
        if(self.pulled) {
             "You decide against pulling a lever, after what happened last
             time. ";
             return;
        }
        "You pull one of the levers. Then you hear
        a low rumbling, as complex long-disused machinery whirrs into
        action below you.  Unfortunately the said machinery breaks down almost
        immediately, due to a lack of maintenance for over 100 years.
        You hear a grinding noise, followed by a loud 
        \"thump!\". "; P(); I(); 
        "Unfortunately, you have caused a rock-fall.  Fortunately, only one
        large rock falls from the ceiling.  Unfortunately, it strikes you 
        on the head, killing you instantly.  You share the same fate as
        Eldrand. ";
        self.pulled := true;
        die();
    }
    doPush(actor) = {
        if(self.pushed) {
            "You decide not to push a lever back, after what happened last
            time. ";
        }
        "You push one of the levers.  Then you hear a rumbling sound as
        a door starts to open in the north wall.  Unfortunately the vibrations
        are causing small rocks to fall from the ceiling!  In panic, you pull 
        the lever back, but it is too late.  A large rock falls on your head,
        killing you instantly.  You share the same fate as Eldrand. ";  
        self.pushed := true;
        die();
    }
    /* Deactivate all pendants and transindection rooms. 
       (This completes Eldrand's mission, but you're trapped and can then
       only leave by dying.)
     */

    doTurnon(actor) = {
        if((self.turnedoff = 1) and not self.tried_back_on) {
                "You try to turn on the switch again, but it seems to have
                jammed.  Try as you might, you can't flip the switch back
                to its original position. ";
                self.tried_back_on := true;
        }
        else if(self.turnedoff >= 2 and not self.made_dotrooms) {
            if(Orange_Right_Switch.forcedoff) {
                "You turn on a switch in the area from which you heard the
                \"click\", but nothing obvious happens. ";
                /* Make this room and the Blue-level cage into a dotroom */
                self.make_dotroom;
            }
            else {
                "You turn on a switch in the area from which you heard the 
                \"click\".  Out of the corner of your eye you think you see
                a white light come on briefly, but you're not sure. ";
                /* Activate white-level upper chamber */
                Green_Upper_Trans_Room.has_ana_extradot := true;
                White_Upper_Trans_Room.isActive := true;
                if(Orange_Right_Switch.isActive)
                    White_Upper_Trans_Room.isdotroom := true;
                /* Make this room and the Blue-level cage into a dotroom */
                self.make_dotroom;
            }
            self.made_dotrooms := true;             
        }
        else if(self.badswitch_turnedon) {
            "You turn on another switch, but nothing happens. ";
            return;
        }
        else {
            "You turn on one of the switches.  For a a few seconds your gold 
            pendant glows";
            if (cloak.isworn)
                "; you remove it from the cloak and notice that it now ";
            else
                " and ";
            "shows a row of eight dots, colored like the buttons here and in
            the Lower Transindection Rooms.  Then you observe that smoke is
            rising from one of the cabinets!  You turn off the switch
            again, but it is too late.  There is a deafening \"bang\" and a
            brilliant shower of sparks from the cabinet, and you notice
            that your pendant is no longer glowing.  In fact, the disk now
            looks like tarnished brass, and is completely featureless ... ";

            tarnished_pendant.moveInto(pendant.location);
            if (pendant.isworn) tarnished_pendant.isworn := true;
            pendant.moveInto(nil);

            // turn off both Transindection chambers.
            Orange_Middle_Switch.turnoff;
            Orange_Middle_Switch.forcedoff := true;
            Orange_Right_Switch.turnoff;
            Orange_Right_Switch.forcedoff := true;
            self.badswitch_turnedon := true;
        }
    }
    /* Code to turn this room and the blue-level cage into a dotroom */
    make_dotroom = {
        Control_Room.isdotroom := true;
        Blue_Steel_Cage.isdotroom := true;
        Blue_Steel_Cage.isseen := nil;
        Blue_Steel_Cage.isdotroom := true;
        Blue_Steel_Cage.isseen := nil;
    }
    /* Deactivate green pendant only */
    turnedoff = 0
    doTurnoff(actor) = {
        self.turnedoff +=1;
        if(self.turnedoff = 1) {
             "You turn off one of the switches.  Nothing obvious happens. ";
             dull_pendant.moveInto(pendant2.location);
             if (pendant2.isworn) dull_pendant.isworn := true;
             pendant2.moveInto(nil);
        }
        else if(self.turnedoff = 2){
            "You turn off another switch.  You hear a slight 'click' from
            another row of switches, but nothing else happens. ";
        }
        else 
            "Nothing happens. "; 
    }
    fumedaemon = {
        fumeturns--;
        if(parserGetMe().isIn(Control_Room)) {
            if(fumeturn = global.turnsofar - 1) {
                P(); I();
                "You are overcome by the fumes. ";
                die();
            }
            else if((self.fumeturns > 0) and (self.fumeturns < 
            fumeduration - 1)) {
                P(); I();
                "The room is still full of choking fumes.  I'd advise you to
                stay out for a little while longer. ";
            }
            else if(self.fumeturns < 0) {
                P(); I();
                "You notice that the fumes have now dispersed. ";
                if(fumeturns <= 0)unnotify(self,&fumedaemon);
            }
            self.fumeturn := global.turnsofar;
        }
    }
;

LockedSteelDoor: floatingdecoration
    game701p = true
    sdesc = "steel door"
    ldesc = "The steel door is locked, and I don't think there's any way 
            you'll get it open. "
    noun = 'door' 'doors'
    verDoUnlock(actor) = {self.ldesc;}
    verDoUnlockWith(actor,io) = {self.ldesc;}
    verDoOpen(actor) = {self.ldesc;}
    verDoClose(actor) = {"It's already firmly closed. ";}
    adjective = 'steel'
    loclist = [Blue_West_End_Of_Hall_Of_Mists, Blue_East_End_Of_Long_Hall,
        Blue_Hall_Of_Mt_King, Blue_Bird_Chamber, Blue_Fourier, 
        Blue_Zarkalon_Cliff_Top]   
;    

Blue_Sandstone_Chamber: room, NoNPC
    game701p = true
    analevel=1
    sdesc = "Sandstone Chamber (Blue level)"
    ldesc = { I(); "You are in a small chamber to the east of the Hall
        of Mists.  Like the other rooms at this level, it has a smooth 
        concrete floor and is lit by electric lights.  The walls are 
        composed of red sandstone and there is a large, cubical chunk of rock
        in the center of the room.  ";
    }
    hasfloor = true // room with a floor
    ana2=Green_Sandstone_Chamber
    kata=Sandstone_Chamber
    west = Blue_Hall_Of_Mists
    out = Blue_Hall_Of_Mists
    mists = Blue_Hall_Of_Mists
    isplaqueroom = true
;

Green_Sandstone_Chamber: darkroom, NoNPC
    game701p = true
    analevel=2
    sdesc = "Sandstone Chamber (Green level)"
    ldesc = { I(); "You are in a small chamber to the east of the Hall
        of Mists.  The walls are composed of rough red
        sandstone.  There is a large, cubical chunk of rock
        in the center of the room, bearing a plaque in Elvish";
        if((global.view_artifact = Glass_Ball) or Green_Stone.knowtrans) {
             ", and you somehow know that it reads
             \"Eldrand-Fitzgerald Topaz\". ";
             Green_Stone.knowtrans := true;
        }
        else
             ". ";
        if(Green_Stone.isglowing)
            "You also notice that the stone is glowing faintly. ";
    }
    enterRoom(actor) = {
        local prevana, prevroom := actor.prevloc;
        inherited.enterRoom(actor);
        if (prevroom)
            prevana := toplocation(prevroom).analevel;
        else
            prevana := self.analevel;
        if ((prevana = self.analevel) and not Green_Stone.isglowing) {
            P(); I();
            "You hear a definite \"click\", and you
            notice that the sandstone block has started to glow faintly. ";
            Green_Stone.isglowing := true;
        }
    }
    kata = Blue_Sandstone_Chamber
    west={
        local actor := getActor(&travelActor);
        if (Green_Stone.isglowing) {
            "You hear a definite \"click\" as you pass through the exit.  On
            looking back, you perceive that the sandstone block is no longer
            glowing. ";
            P();
            Green_Stone.isglowing := nil; 
        }
        else if(topaz.isInside(actor)) {
            "There is a blinding flash of light as you pass through the exit.
            When your eyes have recovered, you notice that your inventory is 
            a little lighter. ";
            P();
            topaz.moveInto(Green_Stone);
        }
        return Green_Hall_Of_Mists;
    }                
    out = {return self.west;}
    mists = {return self.west;}
    exithints = [Green_Hall_Of_Mists, &west]
;

Blue_Stone: Stoneclass
    game701p = true
    location = Blue_Sandstone_Chamber
    ldesc = { 
        inherited.ldesc;
        if (not self.examined) {
            "  You can see the mark where the sword used to be, but the
            sword is probably now in a dusty museum case.  The rest of the
            sandstone block is completely feature ...";
            P(); I();
            "Oh!  There's an old plaque set into the back face of the block. 
            Unfortunately you can't read it, because the surface is too
            badly damaged. ";
            Damagedplaque.moveInto(Blue_Sandstone_Chamber);
            self.examined := true;
        }    
        else
            "  You can see the mark where the sword used to be, and a 
            damaged plaque set into the back face of the block. ";
    }
    ana2 = Green_Stone
    kata = Stone
;

Damagedplaque: fixeditem, readable
    game701p = true
    sdesc = "damaged plaque"
    ldesc = {
        "The surface is badly eroded, and you can't make out anything 
        recognizable.  I guess this plaque was exposed to the weather for
        many years, before it was fixed in its present position. ";
    }
    heredesc = {
        P(); I();
        "A strange plaque is affixed to the back face of the sandstone
        block.  Unfortunately it's too badly damaged to read. ";
    }
    noun = 'plaque'
    adjective = 'damaged'
;


Green_Stone: Stoneclass, readable
    game701p = true
    location = Green_Sandstone_Chamber
    ldesc = { "It's a large, cubical chunk of rock sitting in the center
        of the room.  A plaque on the rock bears an inscription in Elvish";
        if (self.knowtrans)
            ", and you somehow know that the translation is 
            \"Eldrand-Fitzgerald Topaz\". ";        
        else
            ". ";
    }
    readdesc = {
        if (self.knowtrans)
            "Something happened when you viewed this room through the glass
            sphere, and you know the meaning of the words: \"Eldrand-Fitzgerald
            Topaz\". ";
        else
            "You are unable to read the Elvish inscription. ";
    }        
    verGrab(obj) = {
        if((obj = topaz) and self.isglowing) {
            "Your hands pass right through <<obj.thedesc>> as you try to take
            it. ";
        }
    }
    noun = 'plaque'
    kata = Blue_Stone
;

Orange_Maintenance_Room: room, NoNPC
    game701p = true
    analevel = -1
    // player can drink wine, but only if he has the means to escape.
    sober = {
        if (pendant3.isIn(Me) and pendant3.isworn) return nil;
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        return true;
    }
    isbonus = true
    isbonus_addmax = true
    sdesc = "Maintenance Room (Orange level)"
    ldesc = {
        I();
        "You're in a cramped room, slightly larger than its counterparts at 
        other Levels and lit by a dim glow from the ceiling.  There are no
        visible exits, except for a blocked-off doorway to the west.
        Marks and holes on the north wall suggest that it once bore
        equipment of some kind, but it has been removed. ";
        P(); I();
        "The south wall has three \"on-off\" switches.  The left switch is
        marked \"Orange Level Isolator Switch\", and a red light above it is
        labelled \"Control-room Enable Signal.\"  The middle and right
        switches are labelled \"Lower Chambers\" and \"Upper Chambers\",
        and a sign above both switches
        reads \"Emergency Chamber Shutdown (all levels)\". ";
    }
    hasfloor = true // room with a floor
    west = {
        if (topaz.isInside(self)) {
            "You pass your hand through the wall, and feel the desk on the
            other side.  Then you duck down and crawl through, aiming to
            emerge ... "; P();
            return Under_Desk;
        }
        else
            pass west;
    }
    ana = Red_Maintenance_Room
    exithints = [Under_Desk, &west]
;
Red_Maintenance_Room: darkroom, NoNPC
    game701p = true
    isolated = true // no path to main Red-level area without Transindection
    // player can drink wine, but only if he has the means to escape.
    sober = {
        if (not topaz.isIn(Me))return true;
        if (pendant3.isIn(Me) and pendant3.isworn) return nil;
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        return true;
    }
    sdesc = "Maintenance Room"
    ldesc = {
        I();
        "You're in a cramped, almost bare room with no visible exits.
        The north wall bears a row of hooks, and
        the south wall has the expected \"on-off\" switch marked \"Red Level
        Isolator Switch\". Above it there is a red light marked \"Control-room
        Enable Signal\". ";
    }
    hasfloor = true // room with a floor
    west = {
        if (topaz.isInside(self)) 
            return Red_Access_East;
        else
            pass west;
    }
    kata3={
        if (Wumpi.phase < 5 and Wumpi.phase > 0) Wumpi.phase := 5;
        return Orange_Maintenance_Room;
    }
    ana=Blue_Maintenance_Room
    exithints = [Red_Access_East, &west]
;
Blue_Maintenance_Room: darkroom, NoNPC
    game701p = true
    analevel = 1
    // player can drink wine, but only if he has the means to escape.
    sober = {
        if (not topaz.isIn(Me))return true;
        if (pendant3.isIn(Me) and pendant3.isworn) return nil;
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        return true;
    }
    sdesc = "Maintenance Room (Blue level)"
    ldesc = {
        I();
        "You're in a cramped, almost bare room with no visible exits.
        The north wall bears the row of hooks which you saw through the
        hole, and the south wall has a switch marked \"Blue Level
        Isolator Switch\". Above it there is a red light marked \"Control-room
        Enable Signal\". "; 
    }
    hasfloor = true // room with a floor
    west = {
        if (topaz.isInside(self)) 
            return Blue_Access_East;
        else
            pass west;
    }
    kata=Red_Maintenance_Room
    ana2=Green_Maintenance_Room
    exithints = [Blue_Access_East, &west]
;

Green_Maintenance_Room: darkroom, NoNPC
    game701p = true
    analevel = 2
    // player can drink wine, but only if he has the means to escape.
    sober = {
        if (not topaz.isIn(Me))return true;
        if (pendant3.isIn(Me) and pendant3.isworn) return nil;
        if (pendant2.isIn(Me) and pendant2.isworn) return nil;
        return true;
    }
    sdesc = "Maintenance Room (Green level)"
    ldesc = {
        I();
        "You're in a cramped, almost bare room with no visible exits.
        The north wall bears a row of hooks,  and the south wall has a switch 
        marked \"Green Level
        Isolator Switch\". Above it there is a red light marked \"Control-room
        Enable Signal\". ";
    }
    hasfloor = true // room with a floor
    // flag to indicate that the player knows that the green-level chamber
    // was de-activated at the outset.   Normally he'll realize this when
    // he sees that the light is off in this room - but he won't make the
    // deduction if the Lower Transindection Rooms have been disabled.
    enterRoom(actor) = {
        // Check that the player hasn't turned off the Orange-level middle
        // switch ...
        if(Orange_Middle_Switch.isActive
        // ... and that he hasn't turned on a switch in the Control Room
        and (not Orange_Middle_Switch.forcedoff))
            transindection_Button.knowgreenfail := true;
        pass enterRoom;
    }
    west = {
        if (topaz.isInside(self)) 
            return Green_Access_East;
        else
            pass west;
    }
    kata=Blue_Maintenance_Room
    exithints = [Green_Access_East, &west]
;
// The red lights in the Maintenance Rooms (indicating that the
// Lower Transindection Room has been enabled from the Control Room) 
class Enable_Light: fixeditem
    game701p=true
    sdesc = "red light"
    ldesc = {
        if(self.isActive)
            "The light is glowing red. ";
        else
            "The light is colored red, but is dark. ";
    }
    hasfloor = true // room with a floor
    heredesc = {
        P(); I();
        if(self.isActive)
            "The red light is glowing. ";
        else
            "The light is dark. ";
    }
    noun = 'light'
    adjective = 'red'
;    
Orange_Level_Light: Enable_Light
    location=Orange_Maintenance_Room
    isActive = true
;
Red_Level_Light: Enable_Light
    location = Red_Maintenance_Room
    isActive = true
;
Blue_Level_Light: Enable_Light
    location = Blue_Maintenance_Room
    isActive = true
;
Green_Level_Light: Enable_Light 
    location = Green_Maintenance_Room
    // (This was disabled from the Control Room - the only action which
    // Eldrand managed to carry out).
    isActive = nil
;
/* Class for the isolator switches at each level */
class Enable_Switch: switchItem
    sdesc = "isolator switch"
    heredesc = {
        P(); I();
        caps; self.thedesc; " is "; 
        if (self.isActive) "on. "; else "off. ";
    }
    ldesc = "It appears to be an isolator switch for the lower chamber at this 
            Transindection level."
    noun = 'switch'
    plural = 'switches'
    adjective = 'isolator'
;
/* Isolator for orange level lower transindection room only */
Orange_Left_Switch: Enable_Switch
    sdesc = "left switch"
    heredesc = {
        P(); I();
        "The left switch is ";
        if(self.isActive) "on. "; else "off. ";
        "The middle and right switches are ";
        if(Orange_Middle_Switch.isActive and Orange_Right_Switch.isActive)
             "both on. ";
        else if(not Orange_Middle_Switch.isActive and not
        Orange_Right_Switch.isActive)
             "both off. ";
        else {
            if(Orange_Middle_Switch.isActive)"on and "; else "off and "; 
            if(Orange_Right_Switch.isActive)"on, "; else "off, ";
            "respectively. ";
        }
    }
    location=Orange_Maintenance_Room
    isActive = nil
    adjective = 'left'
;     
/* Isolator for all lower chambers */
Orange_Middle_Switch: Enable_Switch
    sdesc = "middle switch"
    ldesc = "It appears to be an emergency shutdown switch for all the lower 
        chambers."
    heredesc = nil
    location=Orange_Maintenance_Room
    isActive = true
    adjective = 'middle'
    doTurnon(actor) = {
        inherited.doTurnon(actor);
        if(self.forcedoff)
            "The red light stays off. ";
        else {
            "The red light comes on. ";
            self.turnon;
        }
    }
    turnon = {
        Orange_Level_Light.isActive := true;
        Red_Level_Light.isActive := true;
        Blue_Level_Light.isActive := true;
        // The green-level light can't be turned on from here.  (Eldrand
        // disabled it from the control room - the only action he managed
        // to carry out.)
    }
    doTurnoff(actor) = {
        inherited.doTurnoff(actor);
        if (not self.forcedoff) "The red light goes off. ";
        else "The red light stays off";
        self.turnoff;
    }
    turnoff = {
        Orange_Level_Light.isActive := nil;
        Red_Level_Light.isActive := nil;
        Blue_Level_Light.isActive := nil;
    }
;
/* Isolator for all upper chambers */
Orange_Right_Switch: Enable_Switch
    sdesc = "right switch"
    ldesc = {
        "It appears to be an  emergency shutdown switch for all the
        upper chambers. ";
        if(Green_Banqueting_Room.seenelves)
            "It's also your opportunity to foil the invasion plans of the
            Green-level elves - for the time being, anyway. ";
    }        
    heredesc = nil
    location = Orange_Maintenance_Room
    isActive = true
    adjective = 'right'
    doTurnon(actor) = {
        inherited.doTurnon(actor);
        if(not self.forcedoff) {
            self.turnon;
            if (Green_Banqueting_Room.seenelves)
                "Your vision of the Banqueting Hall comes back into your
                mind.  The elves are hoping to invade other Levels via the
                Upper Transindection Room, and you've now enabled them to
                succeed!  Furthermore, they will almost certainly start with
                Red level. ";
            else
                "You are unable to say why, but you now have a strange feeling
                of insecurity.  You feel sure that you've upset the balance
                of things in the cave. ";
        }
    }
    turnon = {
        Upper_Trans_Room.isdotroom := true;
        Blue_Upper_Trans_Room.isdotroom := true;
        Green_Upper_Trans_Room.isdotroom := true;
        if(White_Upper_Trans_Room.isActive)
             White_Upper_Trans_Room.isdotroom := true;
    }
    doTurnoff(actor) = {
        inherited.doTurnoff(actor); 
        self.turnoff;
        // If we've managed to get here without transporting the Wumpi, the
        // position of this switch won't matter.
        if(Wumpi.phase <= 0) return;
        if(not self.forcedoff) {
            if (Green_Banqueting_Room.seenelves)
                "Your vision of the Green-level Banqueting Hall comes back
                into your mind.  The elves were hoping to use the Upper
                Transindection Room to invade other Levels - but you feel sure
                that you've now foiled their plans!  ";
            else
                "You are unable to say why, but you now have a strange feeling
                that you've somehow restored the balance of things in the
                cave. ";
        }
        /* A different message is issued if the player has managed to get
        out of the Control Room by fiddling with switches ... */
        else if (Control_Room.isdotroom) 
            "I suspect that this switch no longer matters.  You've already
            disabled the Transindection Rooms, but you now know that you
            could have done this without risking your life. ";
        else
            "I suspect that this switch no longer matters.  You've already
            disabled the Transindection Rooms, but you now know how you
            could have done this without sacrificing a life ... ";
    }
    turnoff = {
        Upper_Trans_Room.isdotroom := nil;
        Blue_Upper_Trans_Room.isdotroom := nil;
        Green_Upper_Trans_Room.isdotroom := nil;
        White_Upper_Trans_Room.isdotroom := nil;
    }
;
Red_Level_Switch: Enable_Switch
    location = Red_Maintenance_Room
    isActive = true
;
Blue_Level_Switch: Enable_Switch
    location = Blue_Maintenance_Room
    isActive = true
;
Green_Level_Switch: Enable_Switch
    location = Green_Maintenance_Room
    isActive = true
;
class Hooks: fixeditem, qsurface
    game701p = true
    sdesc = "hooks"
    ldesc = {"It's a very ordinary row of hooks";
        if(itemcnt(self.contents)) {
            " on which you can see "; listcont(self); ". ";
        }
        else
            ". There's nothing on the hooks. ";
    }
    heredesc = {
        if(itemcnt(self.contents)) {
            P(); I();
            "On the hooks you see "; listcont(self); ". ";
        }
    }
    noun = 'hooks' 'row'
    ioPutOn(actor,dobj) = {
        if(dobj.islarge or dobj.ishuge or dobj.islong)
            "You can't put bulky objects on the hooks. ";
        else 
            pass ioPutOn;
    }
;

Red_Level_Hooks: Hooks
    location = Red_Maintenance_Room
;
Blue_Level_Hooks: Hooks
    location = Blue_Maintenance_Room
;
Green_Level_Hooks: Hooks
    location = Green_Maintenance_Room
;
Concrete_Maint: floatingdecoration
    game701p = true
    sdesc = "concrete wall"
    ldesc = {
        if(not topaz.isInside(self.location))
            "The wall is absolutely solid.  There's no way you can get
            through it. ";
        else
            "Your hand passes through the wall as if it isn't there. ";
    }
    noun = 'wall'
    adjective = 'concrete' 'west' 'western'
    loclist = [Orange_Maintenance_Room, Red_Maintenance_Room,
        Blue_Maintenance_Room, Green_Maintenance_Room]
    verDoAttack(actor) = {
        if(not topaz.isInside(self.location))
             "The wall holds firm against your onslaught. ";
    }
    verDoAttackWith(actor,io) = {self.verDoAttack(actor);}
    verDoKick(actor) = {self.verDoAttack(actor);}
    doAttackWith(actor,io) = {
        caps(); io.thedesc; "passes straight through the wall as if there's
        nothing there!";
    }
    doAttack(actor) = {
        "Your hands pass straight through the wall as if there's
        nothing there!";
    }
    doKick(actor) = {
        "Your legs pass straight through the wall as if there's
        nothing there!";
    }
    doEnter(actor) = {actor.travelTo(self.location,&west);} 
    doBoard(actor) = {self.doEnter;}
    verDoTouch(actor) = {}
    doTouch(actor) = {
        if (topaz.isInside(self.location))
             "Your hand passes straight through the wall. ";
        else
             "You feel nothing unexpected. ";
    }
;    
In_Elevator: room, NoNPC
    analevel = 1
    sdesc = "In Elevator"
    ldesc = {
        "You are inside a large elevator with brushed stainless steel walls
        and a dark gray floor.  Two buttons on the east wall are marked
        \"Upper Level\" and \"Lower Level\". ";
        if(self.outdest)
            "Doors lead out to the south. ";
        else
            "Closed doors bar the exit to the south. ";
    }        
    hasfloor = true //floor described as 'floor', not 'ground'
    hasfloordesc = true
    floordesc = "The floor is dark gray and completely featureless. "
    // kata and ana will work only if the lift is at the lower level (N.B.
    // it is always at the lower level when the doors are closed).
    kata = {
        if((self.outdest = nil) or (self.outdest = Blue_Hall_Of_Mists)) {
            self.outdest := nil; // doors close when lift is empty
            return Red_NE_Corner;
        }
        else
           "The floor disappears from beneath your feet!  Fortunately the
           pendant seems to detect the problem and quickly transports you back
           to safety. ";
        return nil; 
    }
    ana2 = {
        if((self.outdest = nil) or (self.outdest = Blue_Hall_Of_Mists)) {
            self.outdest := nil; // doors close when lift is empty
            return Green_NE_Corner;
        }
        else
           "The floor disappears from beneath your feet!  Fortunately the
           pendant seems to detect the problem and quickly transports you back
           to safety. ";
        return nil; 
    }
    outdest = nil
    out = {
        local exitdest := outdest;
        if(self.outdest = nil) {
            "The elevator doors are closed. ";
            return nil;
        }
        else if(self.outdest != Blue_Hall_Of_Mists)
            "You step out of the elevator, the doors close behind you,
            and you hear it return to the lower level. ";
        else
            "You step out of the elevator and the doors close behind
            you. ";
        P();
        self.outdest := nil; // lift always returns to the lower level
        return exitdest;
    }
    south = {return self.out;}
;
ElevatorInternalDoors: fixeditem
    sdesc = "doors"
    adesc = "doors"
    isThem = true
    noun = 'doors'
    isopen = {return (self.location.outdest != nil);}
    ldesc = {
        if(self.isopen)
            "The doors are open. ";
        else
            "The doors are closed. ";
    }
    location = In_Elevator
    verDoOpen(actor) = {
        if(self.isopen) "They're already open! ";
        else 
            "There's no obvious way to do that.  I suspect they will open
            automatically. ";
    }
    verDoClose(actor) = {
        if(not self.isopen) "They're already closed! ";
        else 
            "There's no obvious way to do that. ";
    }
;

LevelButtonClass: fixeditem
    levels = [Blue_Hall_Of_Mists, Blue_Balcony]
    noun = 'button'
    adjective = 'black'
    verDoPush(actor) = {}
    doPush(actor) = {
        local oldlevel, newlevel;
        if(In_Elevator.outdest) {
             oldlevel := find(levels,In_Elevator.outdest);
        }
        else
             oldlevel := 1; // lift returns to lower level after use
        newlevel := find(levels,self.mydest);

        if(oldlevel = newlevel) {
             if(In_Elevator.outdest)
                  "Nothing happens. ";
             else
                  "The doors slide open. ";
        }
        else {
             if(In_Elevator.outdest)
                  "The doors slide shut. ";
        }

        if (newlevel > oldlevel)
            "The elevator ascends, then the doors open. ";
        else if (newlevel < oldlevel)
            "The elevator descends, then the doors open. ";
        In_Elevator.outdest := self.mydest;
    }
;

LowerLevelButton: LevelButtonClass
    sdesc = "lower-level button"
    ldesc = "It's a small blue button, marked \"Lower level\". "
    noun = 'button'
    adjective = 'lower' 'level' 'lower-level' 'blue'
    mydest = Blue_Hall_Of_Mists
    location = In_Elevator
;
UpperLevelButton: LevelButtonClass
    sdesc = "upper-level button"
    adesc = {"an ";self.sdesc;}
    ldesc = "It's a small green button, marked \"Upper level\". "
    noun = 'button'
    adjective = 'upper' 'level' 'upper-level' 'green'
    mydest = Blue_Balcony 
    location = In_Elevator
;

Blue_Balcony: room, NoNPC
    analevel = 1
    sdesc = "On a Balcony (Blue Level)"
    ldesc = {
        I(); "You're standing on a balcony above the east end of the Hall of
        Mists, whose concrete floor can be seen far below you.  An elevator 
        stands to the north";
        if (Elevator.islocked)
           ", but its doors are firmly closed and the key-operated switch 
           is in the \"off\" position.  ";
        else
           ".  Its doors are closed but the call button should now work.  ";
        "Another passage leads to the east.  ";
    }
    hasfloor = true // room with a floor
    east = Blue_Top_Of_Small_Pit
    north = {
        local actor := getActor(&travelActor);
        if(Elevator.islocked) {
            "The doors of the elevator are firmly closed, and the call button 
            has been disabled at this level.  I suggest that you find another 
            way out of here. ";
            return nil;
        }
        else {
            Elevator.doEnter(actor);
            return nil;
        }   
    }
    jump = {
        "I respectfully suggest that you find a safer way to go down. ";
        return nil;
    }
    kata = {
        "The floor disappears from beneath your feet!  Fortunately the
        pendant seems to detect the problem and quickly transports you back to
        safety. ";
        return nil; 
    }
;

Blue_Top_Of_Small_Pit: room, NoNPC
    analevel = 1
    sdesc = "At Top of Small Pit (Blue level)"
    ldesc = {
        I(); "This room is almost identical to its counterpart at Red level, 
        except for the concrete floor and the overhead electric lighting. 
        At %your% feet is a small pit, but the rough steps which used to
        lead downwards have been removed.  A passage from the east ends here 
        except for a small crack leading on, and a short northwest passage 
        leading to a balcony. ";
    }
    hasfloor = true // room with a floor
    kata = At_Top_Of_Small_Pit
    east = Blue_Bird_Chamber
    nw = Blue_Balcony
    down = {
        "There is no way down from here. ";
        return nil;
    }
    jump = {
        "I respectfully suggest that you have no need to do that. ";
        return nil;
    }
    west = {
        "Unlike some of the passages here, the crack has not been enlarged
        and is far too small for %you% to follow.";
        return nil;
    }
;

Green_Top_Of_Small_Pit: darkroom, NoNPC
    analevel = 2
    sdesc = "At Top of Small Pit (Green level)"
    ldesc = {
        I(); "This room is identical to its counterpart at Red level. 
        At %your% feet is a small pit, and the familiar rough steps lead
        downwards.  Thick dust on the steps suggests that no-one has been
        this way for many years.  A passage from the east ends here 
        except for a small crack leading on. ";
    }
    hasfloor = true // room with a floor
    kata = Blue_Top_Of_Small_Pit
    east = Green_Bird_Chamber
    down = {
        local actor := getActor(&travelActor);
        if (large_gold_nugget.isInside(actor)) {
            // drop possessions at bottom of pit to avoid loss of gray rod
            actor.moveInto(Green_Hall_Of_Mists);
            return broken_neck.death;
        }
        else
            return Green_Hall_Of_Mists;
    }
    west = {
        "The crack is far too small for %you% to follow.";
        return nil;
    }
;

Blue_Bird_Chamber: room, NoNPC
    analevel = 1
    isbonus = true
    isbonus_addmax = true
    sdesc = {
        if(Beach_Notice.isread)
             "In Travertine Room (Blue level)";
        else
    
             "In Bird Chamber (Blue level)";
    }
    ldesc = {
            I(); "%You% %are% in a splendid chamber thirty feet high.  Like
            the other rooms in this area it has a concrete floor and is lit
            by overhead electric lighting.  The walls are frozen rivers of 
            orange ";
            if(Beach_Notice.isread)
                "travertine, which explains the name of this room at
                Blue level. ";
            else
                "stone. ";
            "A wide tunnel and a good passage exit from east and west sides of
            the chamber.  Unfortunately the tunnel is barred by a solid steel
            door with no obvious lock or handle. ";
            P(); I();
            "There are several objects of interest here - two large display
            boards and a display case.  ";
    }

    hasfloor = true // room with a floor
    east = {"That way is barred by a massive steel door, and it's unlikely 
        that you'll ever get it open. "; return nil;}
    entrance = {return self.east;}
    debris = {return self.east;}
    depression = {return self.east;}
    passage = Blue_Top_Of_Small_Pit
    pit = Blue_Top_Of_Small_Pit
    west = Blue_Top_Of_Small_Pit
    kata = In_Bird_Chamber
;
BlueBoard1: fixeditem, readable
    game701p = true
    sdesc = "first display board"
    adesc = {self.thedesc;}
    ldesc = {
        self.isread := true;
        "The display is entitled \" Discovery of the Planet Zarkalon. \"
        It starts by recounting the curious tale told by the old pirate who
        used to live in the cave.  He claimed that he had been becalmed
        in a strange fog, after which he had found himself
        on another world - now known as Zarkalon. ";
        P(); I();
        "He had explored this world for several years, discovering 
        abandoned cities and many treasures.  Eventually he
        was caught in a storm and was shipwrecked, but he managed to put 
        ashore on a small dinghy.  The beach on which he landed is now
        known as the Pirate's Beach. ";
        P(); I();
        "Above the beach he found a passage, now known as the Convoluted
        Passage, leading back into our world!  For many years the route
        to the passage had been blocked by debris, but it had recently
        been cleared.  The remains of the pirate's dinghy were still on
        the beach, and contained a bag of antique silver coins which the
        pirate must have left behind! ";
        P(); // blank line for 'examine boards'
    }        
    noun = 'board'
    plural = 'boards'
    adjective = 'first' 'left-hand' 'left'
    location = Blue_Bird_Chamber
;
BlueBoard2: fixeditem, readable
    game701p = true
    sdesc = "second display board"
    adesc = {self.thedesc;}
    ldesc = {
        self.isread := true;
        "The second board is devoted to the archeological investigations
        of the abandoned city.  This project has been sub-contracted to the
        Mammoth Cave Mining Corporation, which has built a timber roadway
        to provide access to the tunnel leading up to the city. ";
        P(); I();
        "Many interesting artefacts have been found, some of which are
        displayed in this room.  Dating techniques have shown that the
        city was abandoned about 400 years ago, but many of the items
        are almost perfectly preserved.  For example, the power pack inside 
        the machine is still almost fully charged. ";
    }        
    noun = 'board'
    plural = 'boards'
    adjective = 'second' 'right-hand' 'right'
    location = Blue_Bird_Chamber
;

DisplayCase: fixeditem, keyedLockable,qcontainer 
    game701p = true
    contentsVisible = true
    sdesc = "display case"
    noun = 'case' 'glass'
    adjective = 'display' 'steel'
    ldesc = {
        self.examined := true;
        "The case is made of steel and is protected by a large security
        lock.  Furthermore, the glass is reinforced by a fine mesh of silver
        wires, and the following words are etched into one corner: 
        \"Mithrilgard reinforced glass\". ";
        P();
        "A caption in the display case states that it contains objects
        found on the planet Zarkalon.  Two of them attract your attention:
        a pair of metal pendants, both of which look very similar to the ";
        if(pendant3.moved) "pendants ";
        else "pendant ";
        "which you found earlier!  One pendant is gray in color whereas the
        other is shiny and bears a slanted checkerboard design. ";
    }
    doSynonym('Inspect') = 'Lookin'
    verDoSearch(actor) = {"You'd have to open the case first. ";}
    isopen = nil
    islocked = true
    mykey = office_keys //unobtainable
    verDoBreak(actor) = {}
    doBreak(actor) = {
        "You hit the case with all your might, ";
        if (self.examined)
            "but the reinforced glass withstands your onslaught.  I suspect
            that \"Mithrilgard\" means what we think it does - the 
            reinforcing wires are mithril silver.  ";
        else
            "but the glass withstands your onslaught. ";


        if(pendant.isIn(actor)) {
            "A klaxon sounds and you hear shouts and muffled footsteps from 
            the east!  The steel door starts to slide open";
            if ((not (pendant.location = actor)) or not pendant.isworn)
                ". You quickly slip the pendant around your neck and whisper
                \"Kata\" under your breath ... ";
            else
                ", and you hear yourself whisper \"Kata\" under your breath. ";
            P(); 
            pendant.moveInto(actor);
            pendant.isworn := true;
            actor.travelTo(self.location,&kata);
        }
        else {
            "A klaxon sounds and you hear shouts and muffled footsteps from
            the east!  ";
            if (pendant.isInside(actor))
                "The steel door slides open.  You try to remove the gold
                pendant from its closed container, but there isn't time.  Armed
                guards burst into the room and arrest you! ";
            else
                "The steel door slides open and you are promptly
                arrested!  ";
            
            incscore(-50,'for getting yourself arrested at Blue level');
            scoreRank();
            exitprompt();
        }
    }
    verDoAttack(actor) = {}
    verDoAttackWith(actor) = {}
    doAttack(actor) = {self.doBreak(actor);}
    doAttackWith(actor,io) = {self.doBreak(actor);}
    location = Blue_Bird_Chamber
;
Zarkalon_Objects: item // not actually obtainable
    game701p = true
    sdesc = "various objects"
    adesc = {self.sdesc;}
    isThem = true
    ldesc = {
        "The case contains a great variety of objects";
        if (treasure_chest.seentreasures)
            ", some of which look familiar - you realize that you have seen 
            similar items in the pirate's treasure chest!  It is however ";
        else
            "Many of them look quite unfamiliar and it is ";
        "often hard to guess their function.
        The same cannot be said for the two pendants, which look just like the
        Transindection ";
        if(pendant3.moved) "pendants ";
        else "pendant ";
        "which you found earlier. ";
    }
    noun = 'objects'
    adjective = 'various'
    location = DisplayCase
    isfixed = true
    verDoPurloin(actor) = {
        "You can't actually obtain these items. ";
    }
;    
Zarkalon_Shiny_Pendant: item // this is a pendant for travel on Zarkalon
                             // this item is not obtainable but is not needed;
                             // Transindection travel on Zarkalon will be 
                             // possible if the gold, green or orange pendant
                             // has been charged at Green level. 
    game701p = true
    sdesc = "shiny metal pendant"
    ldesc = {
        "It looks almost identical to ";
        if(pendant3.moved) "the Transindection pendants you found earlier. ";
        else "your gold pendant. ";
        "It is made of a shiny metal, and marked with a strange
        pattern like a slanted checkerboard.  A caption under the item simply 
        says \"Aluminum Medallion (charged) with slanted chessboard motif.  
        Function unknown\".  ";
    }
    noun = 'pendant' 'amulet' 'medallion'
    adjective = 'aluminum' 'aluminium' 'shiny' 'silvery' 'metal'
    location = DisplayCase
    isfixed = true
    verDoPutIn(actor,io) = {
        "You'd have to open the display case first. ";
    }             
    verDoPurloin(actor) = {
        "You can't actually obtain this item. ";
    }
;

Zarkalon_Pendant: item // not actually obtainable
    game701p = true
    sdesc = "gray metal pendant"
    ldesc = {
        "It looks almost identical to ";
        if(pendant3.moved) "the Transindection pendants you found earlier. ";
        else "your gold pendant. ";
        "It is made of a dull gray metal, with a plain disk.  A caption under 
        the item simply says \"Aluminum Medallion (uncharged).
        Function unknown\".  ";
    }
    noun = 'pendant' 'amulet' 'medallion'
    adjective = 'aluminum' 'aluminium' 'grey' 'gray' 'metal' 'dull'
    location = DisplayCase
    isfixed = true
    verDoPutIn(actor,io) = {
        "You'd have to open the display case first. ";
    }             
    verDoPurloin(actor) = {
        "You can't actually obtain this item. ";
    }
;

StrangeMachine: floatingdecoration
    game701p = true
    isListed = {
       if (self.location = GreenZarkalonCabinet) return true;
       else return nil;
    }
    sdesc = {
        if(self.location = GreenZarkalonCabinet) "pendant-charging machine";
        else "machine";
    }
    ldesc = {
        "The machine is made of a nondescript gray metal and is rectangular in
        shape,
        about two feet wide and three feet in height.  The front face is 
        inscribed with ";
        if (self.location.isMachineChamber)
            "an octagon, inside of which there is a representation of a
            castle.  The only other clues to its function are on the top face,
            which bears seven colored dots (yellow, purple, orange, red,
            blue, green, white and magenta) and a slot about two inches
            long. ";
        else
            "a design resembling a slanted checkerboard. Its top face
            bears two colored dots (red and blue) and a slot about two 
            inches long. ";
            if(self.location = Green_Bird_Chamber)
                "A label affixed to the machine confirms its function:
                \"Medallion-charging machine.  See display case.\" ";
    }
    heredesc = {    //Used in tower basement only
        if(self.location) {
            if(self.location.isbasement) {
                P(); I();
                "There is a pendant-charging machine here, exactly like the
                one you found in the Green-level Bird Chamber. ";
            }
        } 
    }
    noun = 'machine' 'slot' 'dots'
    adjective = 'strange' 'pendant-charging'
    verIoPutIn(actor) = {}
    ioPutIn(actor,dobj) = {
        if(dobj = discolored_disk) {
            discolored_disk.machinespecial;
            return;
        }
        else if(not isclass(dobj,pendantItem)) {
            "That won't fit into the slot of the machine. "; 
            return;
        }
        else
            "The pendant fits the slot perfectly. ";
        if(dobj = broken_pendant) {
            "The red and blue dots light up briefly, and the words
            \"ana\" and \"kata\" seem to pass through your mind.  But
            something is wrong.  The pendant starts to shimmer, then
            shatters into tiny fragments which disappear in a blinding 
            flash of light. ";
            dobj.moveInto(nil);
        }
        else {
            if(self.location.isMachineChamber) {
                if((dobj = tarnished_pendant) or (dobj = pendant)) {
                    "The red and blue dots light ";
                    pendant.firstworn := true; // in case pendant hasn't
                                               // been worn yet.
                }
                if((dobj = pendant2) or (dobj = dull_pendant))
                    "The green dot lights ";
                if(dobj = pendant3)
                    "The orange dot lights ";
                "up, and the words \"ana\" and \"kata\" seem to
                pass through your mind like water flowing in a stream. 
                You remove the pendant";
                if ((dobj = tarnished_pendant) or (dobj = dull_pendant))
                    ", and notice that it has now returned to its original
                    appearance! "; 
                else ". ";
            }
            else {
                "The red and blue dots light up, and an image comes
                into your mind: a ruined city on an alien planet, 
                illuminated by an aurora which fills the sky!  
                You remove the pendant, ";
                if (dobj.Zarkonalized)
                    "but notice no further change - it is still ";
                else 
                    "and notice that it has changed - it is now ";
                "marked with a slanted checkerboard pattern. ";
                if ((dobj = tarnished_pendant) or (dobj = dull_pendant))
                    "You also notice that the pendant has returned to its
                    original appearance! ";
            }
            // reactivate the gold pendant
            if(dobj = tarnished_pendant) {
                pendant.moveInto(tarnished_pendant.location);
                if(tarnished_pendant.isworn) pendant.isworn := true;
                tarnished_pendant.moveInto(nil);
                dobj := pendant;
            }
            // reactivate the dull pendant
            else if(dobj = dull_pendant) {
                pendant2.moveInto(dull_pendant.location);
                if(dull_pendant.isworn) pendant2.isworn := true;
                dull_pendant.moveInto(nil);
                dobj := pendant2;
            }
            if (not (self.location.isMachineChamber)) 
                dobj.Zarkalonized := true;
        }
    }
    loclist = [Green_Bird_Chamber, Machine_Chamber, Blue_Machine_Chamber, 
    Green_Machine_Chamber, White_Machine_Chamber, Magenta_Machine_Chamber, 
    Zarkalon_Tower_Basement]
    // special method to handle placement of the machine inside a container.
    location = {
        local actor := getActor(&currentActor);
        if(find(self.loclist,GreenZarkalonCabinet) and
        GreenZarkalonCabinet.isIn(actor.location))
            return GreenZarkalonCabinet;
        else pass location;
    }
;

Green_Bird_Chamber: darkroom, NoNPC
    game701p = true
    analevel = 2
    sdesc = {
        "In Bird Chamber (Green level)";
    }
    ldesc = {
        I(); "%You% %are% in a splendid chamber thirty feet high.
        The walls are frozen rivers of orange stone.  An
        awkward canyon and a good passage exit from east and
        west sides of the chamber.  A faded sign on the north wall reads:
        \"Transindection Room Keys are now stored in the Orange Level Office.\"
        A second sign over the east passage reads \"Elves only.\" ";
        P(); I();
        "There is a strange machine in one corner.  You immediately 
        recognize it as a pendant-charging machine, similar to the ones you
        found earlier. ";
    }

    west = Green_Top_Of_Small_Pit
    east = {
        local actor:= getActor(&travelActor);
        if(Green_End_Of_Road.isseen) {
            "You have no desire to risk being captured by the Elves, or to
            see the aftermath of the traffic accident at Blue level. ";
            return nil;
        }
        else if ((pendant.location != actor) or not pendant.isworn) {
            "Without your pendant you feel strangely insecure, and decide not 
            to risk an encounter with the elves right now. ";
            return nil;
        }
        "As you enter the passage, it seems to stretch out in front of
        you.  Everything goes very dark, then suddenly you find yourself ... ";
        P();
        actor.travelTo(Green_End_Of_Road);
        P();
        "Unfortunately, you are surrounded by heavily armed Elves, all
        wearing a uniform made from a silvery fabric!  They
        rush towards you, but fortunately you have the presence of mind to
        whisper \"Kata.\" ";
        global.seenelves := true;
        P();
        actor.travelTo(Blue_Highway);
        P();
        "The phrase \"out of the frying pan and into the fire\" comes to
        mind as you see a large truck heading straight for you!  At the
        top of your voice, you issue the word once again: \"Kata!\"  
        As your surroundings begin to shimmer and fade, you watch with horror 
        as the vehicle swerves and spins out of control.  Fortunately the 
        transition to Red level is almost complete when the truck reaches
        your position in space.  You are knocked to the ground, as if blown
        over by a strong gust of wind - shaken and bruised, but with no
        broken bones. ";
        P();
        actor.moveInto(At_End_Of_Road);
        theFloor.sitloc := actor.location;
        if (global.closure)
            cancel_cave_closure(nil,nil,true);
        return theFloor;
    }
    kata = Blue_Bird_Chamber
    machinetrans = White_Bird_Chamber
;
GreenBirdchamberSign: fixeditem, readable
    game701p = true
    sdesc = "sign"
    ldesc = {
        // The north sign serves two purposes: to give the player a clue if
        // the Orange Level Office has not yet been visited, and to explain
        // why the scrawled note (in the Control Room Manual) points to this
        // room.
        if(crumpled_sheet.isread or iron_key.moved)
            "The sign on the north wall gives you a sense of deja vu: ";
        else
            "The sign on the north wall reads ";
        "\"Transindection Room Keys are 
        now stored in the Orange Level Office.\"  You experience a feeling of 
        foreboding as you re-read the sign by the east passage: \"Elves 
        Only\".  If you go that way, you do so at your own risk. ";
    }
    noun = 'sign' 'signs'
    adjective = 'faded' 'east' 'north' 'second'
    location = Green_Bird_Chamber
;

White_Bird_Chamber: darkroom, NoNPC
    // dummy room, inaccessible to the player.  
    game701p = true
    analevel = 3
    sdesc = {
        "In Bird Chamber (White level)";
    }
    ldesc = {
        I(); "%You% %are% in a splendid chamber thirty feet high.
        The walls are frozen rivers of orange stone.  In fact, everything
        about this room looks as it does at Red level. ";
    }
    kata = Green_Bird_Chamber
;

Blue_Debris_Room: darkroom, NoNPC
    game701p = true
    analevel = 1
    sdesc = "In Debris Room (Blue level)"
    ldesc = {
        I(); "%You% %are% in a debris room filled with stuff
        washed in from the surface. A low wide passage with
        cobbles leads east and west.  An awkward canyon once led upward and 
        west, but is blocked by a recent rock-fall. ";
    }
    east = {
        "After a short distance your way is blocked by a steel door. You
        beat a retreat back to the Debris Room. ";
        return nil;
    }    
    west = Blue_Debris_West
    kata = In_Debris_Room
;

debrisrocks: fixeditem
    game551 = true
    sdesc = "rocks"
    adesc = "rocks"
    ldesc = "The rocks are too large to move or carry, and they are
    now blocking your passage along the awkward canyon. "
    noun = 'rocks'
    adjective = 'large' 'loose'

    location = Blue_Debris_Room

    verDoMove(actor) = {"The rocks are far too large to move.";}
    verDoTake(actor) = {"The rocks are too large to carry.";}
    verDoSearch(actor) = {}
    doSearch(actor) = {"You find nothing of interest. ";}
;

Debris_West: darkroom, NoNPC
    game701p = true
    isolated = true
    sdesc = "Debris Room West"
    sober = {return self.isolated;}  // no drinking while the passage is closed
    ldesc = {
        if(defined(self,&east,DEFINED_DIRECTLY)) {
            I(); "%You% %are% in a cobbled east-west passage.  It is strewn
            with debris, but you'll now be able to get past it to the east and
            the west. ";
        }
        else {
            I(); "%You% %are% in a small cobbled chamber west of the debris 
            room.  The way east is blocked, but you may be able to squeeze 
            past the debris to the west. ";
        }
    }
    west = Plaque_Room
;

class Lower_Plaque_Room_Class: darkroom
    game701p = true
    isplaqueroom = true
    sober = true
    ldesc = { 
        I(); "You are in a cramped room with a cobbled floor and a low
        ceiling.  A passage once led east, but is now blocked with debris. ";
    }
    hasfloor = true // room with a floor
;

Plaque_Room: Lower_Plaque_Room_Class, NoNPC
    isolated = true
    sober = {return self.isolated;}  // no drinking while the passage is closed
    sdesc = "Cobbled Plaque Room"
    ldesc = { 
        I(); "You are in a cramped room with a cobbled floor and a low
        ceiling.  A passage leads east. ";
    }
    east = Debris_West
    phleece = Octagonal_Room // if bracelet is worn and the player has
                             // heard how to pronounce the word
;

Blue_Plaque_Room: Lower_Plaque_Room_Class, NoNPC
    analevel = 1
    kata = Plaque_Room
    sdesc = "Cobbled Plaque Room (Blue level)"
    phleece = Blue_Octagonal_Room // if bracelet is worn and the player has
                                  // heard how to pronounce the word
;

Green_Plaque_Room: Lower_Plaque_Room_Class, NoNPC
    analevel = 2
    kata = Blue_Plaque_Room
    sdesc = "Cobbled Plaque Room (Green level)"
    phleece = Green_Octagonal_Room // if bracelet is worn and the player has
                                   // heard how to pronounce the word
;

White_Plaque_Room: Lower_Plaque_Room_Class, NoNPC
    isplaqueroom = nil
    analevel = 3
    kata = Green_Plaque_Room
    sdesc = "Cobbled Former Plaque Room (White level)"
    ldesc = { 
        I(); "You are in a cramped room with a cobbled floor and a low
        ceiling.  It would appear that the ceiling once bore a 
        plaque, but it has been removed. A passage once led east, but has
        now been bricked up. ";
    }
    phleece = White_Octagonal_Room // if bracelet is worn and the player has
                                   // heard how to pronounce the word
;


class Upper_Plaque_Room_Class: darkroom
    game701p = true
    isplaqueroom = true
    ldesc = { 
        I(); "You are in a small room with a marble floor and a high
        ceiling.  A passage leads northeast. ";
    }
    hasfloor = true // room with a floor
    ne = {
        local actor := getActor(&travelActor);
        if(multicolored_rod.isInside(actor)) {
            if (self.dest.sw = Noexit) {
                "Something strange happends as you pass down the passage. 
                Large rocks seem to melt away into nothingness, leaving the
                passage clear. ";
                P();
            }
            self.dest.sw := self;
            return self.dest;
        }    
        else {
            if (self.dest.sw = self) { 
                return self.dest;
            }
            else {
                "After the first few feet the passage is blocked by large
                rocks and you are unable to continue. ";
                return nil;
            }
        }
    }
;

Plaque_Room_2: Upper_Plaque_Room_Class, NoNPC
    sdesc = "Small Plaque Room"
    dest = Octagonal_Room
    ana = Blue_Plaque_Room_2
;

Blue_Plaque_Room_2: Upper_Plaque_Room_Class, NoNPC
    analevel = 1
    sdesc = "Small Plaque Room (Blue level)"
    dest = Blue_Octagonal_Room
    kata = Plaque_Room_2
    ana2 = Green_Plaque_Room_2
;

Green_Plaque_Room_2: Upper_Plaque_Room_Class, NoNPC
    analevel = 2
    sdesc = "Small Plaque Room (Green level)"
    dest = Green_Octagonal_Room
    kata = Blue_Plaque_Room_2
;

White_Plaque_Room_2: Upper_Plaque_Room_Class, NoNPC
    isplaqueroom = nil  // the plaque is set in concrete in the Lower
                        // Transindection Chamber
    analevel = 3
    ldesc = {
        inherited.ldesc;
        P();
        "Marks on the ceiling suggest that this room once had a plaque there.
        Unfortunately it has now been removed. ";
    }
    sdesc = "Former Plaque Room (White level)"
    dest = White_Octagonal_Room
    kata = Green_Plaque_Room_2
;

Blue_Debris_West: darkroom, NoNPC
    game701p = true
    analevel = 1
    sdesc = "Debris Room West (Blue level)"
    ldesc = {
        I(); "%You% %are% in a debris room filled with stuff
        washed in from the surface. A low wide passage with cobbles leads
        east, but the way west is now completely blocked with debris. ";
    }
    east = Blue_Debris_Room
    kata = Debris_West
;

Green_Debris_Room: darkroom, NoNPC
    game701p = true
    analevel = 2
    sdesc = "In Debris Room (Green level)"
    ldesc = {
        I(); "%You% %are% in a debris room almost completely filled with stuff
        washed in from the surface.   The only exit is the awkward canyon 
        leading upwards and west. ";
    }
    west = {
        "You feel a strange tingling sensation as you enter the passage, 
        then ... "; P();
        return Green_West_Side_Of_Fissure;
    }    
    up = { return self.west; }
    kata = Blue_Debris_Room
;

Green_End_Of_Road: room, NoNPC // no exit properties needed
    game701p = true
    sdesc = "At End Of Road (Green level)"
    analevel = 2
    ldesc = {
        I(); "%You% %are% standing at the end of a road before a
        small brick building. Around %you% is a forest.  A
        small stream flows out of the building and down a
        gully.";
    }
;

Blue_Highway: room, NoNPC // no exit properties needed
    sdesc = "On a Highway (Blue level)"
    analevel = 1
    ldesc = {
        I(); "You are standing on a six-lane highway which replaces
        the original road at this Transindection level. ";
    }
;

Blue_Fourier: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 1
    Zarkalonroom = true
    sdesc = {
        if(BlueBoard1.isread) "Convoluted ";
        else "Fourier ";
        "Passage (Blue level)";
    }
    ldesc = { I();
        if(BlueBoard1.isread)      
            "You are in the tunnel which the Blue-level people 
            refer to as the Convoluted Passage.  ";
        else
            "You're in the Fourier Passage. ";
        "Like other rooms
        in the Blue-level cave it is lit by overhead electric
        lights and concrete has been laid on the floor.  Narrow parts of the
        tunnel have been widened, and the southwest exit leads out to the
        platform above the beach.  Unfortunately the northwest
        exit is blocked by a locked steel door. ";
    }
    hasfloor = true // room with a floor
    sw = Blue_Beach_Shelf
    kata = Fourier
;

Blue_Beach_Shelf: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 1
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "Shelf of Rock Above Beach (Blue level)"
    ldesc = { 
        I();
        "You are standing on a large shelf of sedimentary rock
        overlooking a lava beach.  The shelf is an extension
        of an incredible cliff, but now there is a way up - a
        recently-built timber roadway zig-zags up the cliff, disappearing
        into a large tunnel about 200 feet above you.  A smaller tunnel
        leads into the cliff to the west. ";
    }
    west = Blue_Fourier
    down = Blue_Beach
    steps = Blue_Beach
    up = Blue_Zarkalon_Tunnel_Entrance
    kata = Beach_Shelf
;

Blue_Beach: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 1
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "Beach (Blue level)"
    ldesc = { 
        I();
        "You are standing on a short, barren beach composed of
        hardened lava.  Rugged and unclimbable volcanic hills
        block all view to the north and south, and a seemingly
        infinite cliff fills the entire western hemisphere.
        To the east, a narrow inlet of ocean water laps gently
        upon the beach. The scene is illuminated by the light
        of three small moons shining through the shimmering
        glow of an aurora that fills the entire sky with
        golden splendor.  Steps lead back up to the shelf of
        rock, from which a zig-zagging timber roadway continues up the face
        of the cliff.  A notice on the cliffside reads \"Pirate's 
        Beach\". ";
    }
    west = Blue_Beach_Shelf
    up = { return self.west; }
    steps = { return self.west; }
    ledge = { return self.west; }
    kata = Beach
;
Beach_Notice: fixeditem, readable
    game701p = true
    sdesc = "notice"
    ldesc = {
        "The notice reads \"MAMMOTH CAVE MINING CORPORATION\", with 
        \"Pirate's Beach\" below in large print.  There is smaller
        print underneath, so you move closer and read \"See the Exhibition in 
        the Travertine Room\".  Travertine ... Ah! I think that's the orange
        mineral in the Bird Chamber. The Travertine Room must be the 
        Blue-level name for the Bird Chamber. ";
        self.isread := true;
    }
    noun = 'notice'
    location = Blue_Beach
;

Roadway: floatingdecoration
    game701p = true
    sdesc = "timber roadway"
    ldesc = "The timber roadway is firmly fixed to the cliff face by
        scaffolding poles, and is about 10 feet wide.  It appears to follow
        the line of the original path which had been destroyed by rock
        falls. "
    noun = 'roadway' 'path' 
    adjective = 'timber'
    loclist = [Blue_Beach_Shelf, Blue_Beach, Blue_Zarkalon_Tunnel_Entrance]
;

Zarkalon_Tunnel_Entrance: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    isolated = true // no path to main Red-level area without Transindection
    sdesc = "At Tunnel Entrance"
    ldesc = "You're at the entrance to a dark E/W tunnel.  To the north, 
        a stone pathway once led down the cliff but has been destroyed by
        rock-falls.  To the west, the tunnel leads in to the cliff face. "
    west = Zarkalon_Tunnel
    passage = Zarkalon_Tunnel
    in = Zarkalon_Tunnel
    north = {
            "You'll need to change your Transindection level to go that
            way. ";
    }
    east = {self.north;}
    down = {self.north;}
    ana = Blue_Zarkalon_Tunnel_Entrance
;

Blue_Zarkalon_Tunnel_Entrance: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    analevel = 1
    sdesc = "At Tunnel Entrance (Blue level)"
    ldesc = { I();
        "You're at the entrance to an E/W tunnel, lit by overhead
        electric lights.  To the north, the timber roadway leads down the
        cliff.  To the west, the tunnel leads in to the cliff face. ";
    }
    west = Blue_Zarkalon_Tunnel
    passage = Blue_Zarkalon_Tunnel
    in = Blue_Zarkalon_Tunnel 
    north = Blue_Beach_Shelf
    east = Blue_Beach_Shelf
    down = Blue_Beach_Shelf
    kata = Zarkalon_Tunnel_Entrance
; 

class Zarkalon_Tunnel_Class: Internal_Room, floatingdecoration, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    isolated = true // no path to main Red-level area without Transindection
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    hasfloor = true // room with a floor
    location = {
        local actor := getActor(&currentActor);
        if ( actor.isIn(self) ) return nil;      // IMPORTANT: prevent
                                                 // infinite loop.
        else pass location;
    }
    isopen = true
    doEnter(actor) = {
        actor.travelTo(self.location,&passage);
    }
    doUnboard(actor) = {
        actor.travelTo(self,out);
    }
    out = {
        return self.back;
    }
 
    verDoOpen(actor) = {
        "The tunnel entrance is already open. ";
    }

    verDoClose(actor) = {
        "The tunnel entrance is open, and there's no way to close it. ";
    }

    doSearch(actor) = {
        if (not self.isseen and (itemcnt(self.contents) = 0))
            "You can't see very far into the tunnel, so I can't tell you 
            what's in there. ";
        else if (self.contentsVisible and itemcnt(self.contents) <> 0)
            "You can't see far into <<self.thedesc>>, but you know that you've
            left the following objects in there: <<listcont(self)>>. ";
        else
            "There's nothing in <<self.thedesc>>. ";
    }
    // Special reachability check.  From outside the tunnel, we can only 
    // reach objects which were put in there from the same side.
    special_cantreach(obj,actor,chain) = {
        local topcont, actor_side, obj_side;
        // check that the actor is outside the tunnel and that the object
        // to be tested isn't the room itself
        if (not actor.isIn(self) and obj <> self) {
            topcont := chain[2]; /* top-level container of obj */
            if(toplocation(actor) <> topcont.metoploc) return true;
        }
        return nil;
    }
    ioPutIn(actor,dobj) = {
        local toploc := toplocation(actor); 
        if((toploc = Zarkalon_Cliff_Top) or 
        (toploc = Blue_Zarkalon_Cliff_Top)) { 
            local n := 0, o, i := 0, l := length(global.spinrodlist);
            for (i := 1; i <= l; i++) {
                o := global.spinrodlist[i];
                if (o.isspinning and o.isInside(actor)) n++;
            }
            if (n > 0)
                actor.travelTo(toploc,&down);
            else
                pass ioPutIn;
        }
        else
            pass ioPutIn;
    }    
    ioThrowAt(actor,dobj) = {
        if(isclass(dobj,spinnable_rod) and dobj.isspinning) {
            dobj.moveInto(dobj.myhome);  

            // the gold ring transports the player, if worn.
            if((gold_ring.location = actor) and gold_ring.isworn) {
                local oldana := toplocation(actor).analevel;
                local newana;
                "Your gold ring quivers, and you feel a sudden gust of
                wind.  The room goes dark, and you then find yourself ...";
                P();
                if ((pendant.location = actor) and pendant.isworn and
                pendant.strictcontrol) {
                    actor.travelTo(dobj.myhome2[oldana+1]);
                }
                else if ((broken_pendant.location = actor) and 
                broken_pendant.isworn and broken_pendant.strictcontrol) {
                    actor.travelTo(dobj.myhome2[oldana+1]);
                }
                else
                    actor.travelTo(dobj.myhome);
                P();
                newana := toplocation(actor).analevel;
                if (newana != oldana) {
                    if((pendant.location = actor) and pendant.isworn) {
                        "The gold pendant whispers to your mind: ";
                        if (pendant.strictcontrol)
                            "\"Warning 09A2:  Transindection movement
                            mediated by unregistered object, type Dual Magic
                            Ring.  Unable to block movement
                            due to lack of proximity to Control Room.\" ";
                        else 
                            "\"Warning 09A1: Transindection movement 
                            mediated by unregistered object, type Dual Magic
                            Ring.\" ";
                    }
                    if (not IronBridge.transchanged) {
                        P();
                        "You ponder the implications of your discovery.  
                        I'd bet that even Eldrand didn't know that the
                        rods could transport themselves through 
                        Transindection! ";
                    }
                    IronBridge.transchanged := true;
                }
            }
            else {
                "There is a sudden gust of wind, and
                <<dobj.thedesc>> vanishes! I hope you'll be able to find it 
                again. ";
            }
        }
        else if(dobj = glass_vial) 
            dobj.doThrowAt(actor,self);          
        else if(dobj = ming_vase) {
            "You hurl <<dobj.thedesc>> into the tunnel.  It hits the ground
            with a delicate crash. ";
            dobj.moveInto(nil);
            shards.moveInto(self);
        }
        else {
            dobj.moveInto(self);
            "Thrown. ";
        }
    }
    ioThrowTo(actor,dobj) = {self.ioThrowAt(actor,dobj);}
;
  
Zarkalon_Tunnel: darkroom, Zarkalon_Tunnel_Class
    sdesc = "In a Winding Tunnel"
    multisdesc = "tunnel"
    inldesc = { I();
        "You're in a dark winding tunnel which spirals up towards the top of 
        the cliff.  You experience a strange sensation as you walk along, as if
        you are moving in slow motion. ";
    }
    outldesc = {
        if(self.location.analevel = 0)
            "The tunnel is completely dark.  You'll have to enter it to
            see anything. ";
    }
    loclist = [Zarkalon_Tunnel_Entrance, Zarkalon_Cliff_Top]
    up = {
        local actor := getActor(&travelActor);
        if (not self.climbed) {
            "As you continue upwards, you find it necessary to
            'pop' your ears every few yards, and notice that the air seems to 
            be getting thinner.  The tunnel emerges 
            into the light,and you find yourself ... ";
            P();
            self.climbed := true;
        }
        return Zarkalon_Cliff_Top;
    }
    down = Zarkalon_Tunnel_Entrance
    exithints = [Zarkalon_Cliff_Top, &up]
    ana = Blue_Zarkalon_Tunnel
    noun = 'tunnel'
;


Blue_Zarkalon_Tunnel: Zarkalon_Tunnel_Class
    sdesc = "In a Winding Tunnel (Blue level)"
    multisdesc = "tunnel"
    inldesc = { I();
        "You're in a winding tunnel, lit by overhead electric lights, 
        which spirals up towards the top of the
        cliff.  You experience a strange sensation as you walk along, as if
        you are moving in slow motion. ";
    }
    outldesc = {
        "The tunnel is lit by overhead electric lights.  It follows
        a spiral path, so you can't see very far into it. ";
    }
    loclist = [Blue_Zarkalon_Tunnel_Entrance, Blue_Zarkalon_Cliff_Top]
    up = {
        local actor := getActor(&travelActor);
        if (not self.climbed) {
            "As you continue upwards, you find it necessary to
            'pop' your ears every few yards, and notice that the air seems to 
            be getting thinner.  The tunnel emerges 
            into the light,and you find yourself ... ";
            P();
            self.climbed := true;
        }
        return Blue_Zarkalon_Cliff_Top;
    }
    down = Blue_Zarkalon_Tunnel_Entrance
    exithints = [Blue_Zarkalon_Cliff_Top, &up]
    kata = Zarkalon_Tunnel
    noun = 'tunnel'
;

Zarkalon_Cliff_Top: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    isolated = true // no path to main Red-level area without Transindection
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "At Top of Cliff"
    ldesc = { I();
        "You're at the top of the cliff, high above the beach.  There is 
        a low balustrade to the west, beyond which a magnificent sea-scape
        is spread out before you.  High walls block the way to the north, 
        south and west. The tunnel emerges from the north wall, and a large
        doorway - unfortunately blocked by rubble - is set into the west
        wall.  To the south, an open doorway leads into a stone tower, rising
        about 100 feet above you. ";
    }
    north = {return self.down;}
    passage = {return self.down;}
    down = {
        local actor := getActor(&travelActor);
        local oldana = toplocation(actor).analevel;
        local n := 0, o, i := 0, l := length(global.spinrodlist);
        for (i := 1; i <= l; i++) {
            o := global.spinrodlist[i];
            if (o.isspinning and o.isInside(actor)) n++;
        }
        if(n > 1) {
            "You try to approach the tunnel, but the spinning rods refuse to
            go with you!  You conclude that it might be a better idea to spin 
            just one rod at a time. ";
            return nil;
        }
        else {
            for (i := 1; i <= l; i++) {
                o := global.spinrodlist[i];
                if (o.isspinning and o.isInside(actor)) {
                    "As you approach the tunnel you feel a sudden gust of 
                    wind, then the room goes pitch black for a few 
                    seconds.  You then find yourself in another place ... ";
                    P();
                    if ((pendant.location = actor) and pendant.isworn and
                    pendant.strictcontrol) {
                        actor.travelTo(o.myhome2[oldana+1]);
                    }
                    else if ((broken_pendant.location = actor) and 
                    broken_pendant.isworn and broken_pendant.strictcontrol) {
                        actor.travelTo(o.myhome2[oldana+1]);
                    }
                    else
                        actor.travelTo(o.myhome);
                    Zarkalon_Cliff_Top.teleported := true;                    
                    if (toplocation(actor).analevel != oldana) {
                        if ((pendant.location = actor) and pendant.isworn) {
                            "The gold pendant whispers to your mind: ";
                            if(pendant.strictcontrol)
                                 "\"Warning 09A2:  Transindection movement
                                 mediated by unregistered object, type
                                 Astral Staff.  Unable to block movement
                                 due to lack of proximity to Control Room.\" ";
                            else 
                                 "\"Warning 09A1: Transindection movement 
                                 mediated by unregistered object, type Astral 
                                 Staff.\" ";
                        }
                        if (not IronBridge.transchanged) {
                            P();
                            "You ponder the implications of your discovery.  
                            I'd bet that even Eldrand didn't know that the
                            rods could transport you through Transindection! ";
                            P();
                            IronBridge.transchanged := true;
                        }
                    }
                }
            }
        }
        if (actor.isIn(Zarkalon_Cliff_Top))
            return Zarkalon_Tunnel;
        else if (actor.isIn(Blue_Zarkalon_Cliff_Top))
            return Blue_Zarkalon_Tunnel;
        else return nil;
    }
    south = Zarkalon_Tower_Base
    ana = Blue_Zarkalon_Cliff_Top
    exithints = [Zarkalon_Tunnel, &north]
    // 'in' property removed - ambiguous.
;

TowerBalustrade: decoration,floatingdecoration
    game701p = true
    sdesc = "balustrade"
    ldesc = {
        "A series of ornate stone columns topped
        with a ";
        if(self.location = Zarkalon_Cliff_Top)
            "dull ";
        else
            "shiny ";
        "metal rail. ";
    }
    noun = 'balustrade'
    loclist = [Zarkalon_Cliff_Top, Blue_Zarkalon_Cliff_Top]
;

ZarkalonTower: floatingdecoration
    game701p = true
    sdesc = "stone tower"
    ldesc = 
        "It's an impressive circular tower, about 100 feet high and 20 feet
        in diameter. "
    noun = 'tower'
    adjective = 'stone'
    verDoEnter(actor) = {}
    doEnter(actor) = {
        actor.travelTo(actor.location,&south);
    }
    verDoBoard(actor) = {}
    doBoard(actor) = {self.doEnter(actor);}
    loclist = [Zarkalon_Cliff_Top, Blue_Zarkalon_Cliff_Top]
;

Tower_door: floatingdecoration,CCR_lockableDoorway
    game701p = true
    externalDoor = nil
    sdesc = "tower door"
    noun = 'door'
    adjective = 'tower'
    mykey = office_keys //unobtainable
    doordest = nil // goes nowhere
    loclist = 
        [Blue_Zarkalon_Cliff_Top,
        Blue_Zarkalon_Tower_Base, Green_Zarkalon_Tower_Base]
;

Blue_Zarkalon_Cliff_Top: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    analevel = 1
    sdesc = "At Top of Cliff (Blue level)"
    ldesc = { I();
        "You're at the top of the cliff, high above the beach.  There is 
        a low balustrade to the east, beyond which a magnificent sea-scape
        spreads out before you.  High walls block the way to the north, 
        south and west. The tunnel emerges from the north wall, and a large
        steel door is set into the west wall.  To the south, a stone tower
        rises about 100 feet above you, but its door is firmly closed and
        locked. ";
    }
    passage = {return self.down;}
    north = {return self.down;}
    in = {return self.down;} // added
    down = {return inherited Zarkalon_Cliff_Top.down;}
    kata = Zarkalon_Cliff_Top
    exithints = [Blue_Zarkalon_Tunnel, &north]
;

Zarkalon_Tower_Basement: darkroom, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    isolated = true // no path to main Red-level area without Transindection
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    isbasement = true // flag for StrangeMachine.heredesc
    sdesc = "Tower Basement"
    ldesc = {
        I(); "You're in the basement of the tower - a small circular room
        with stone walls.  A spiral staircase leads up. ";
    }
    hasfloor = true // room with a floor
    up = {
        "The top of the staircase is blocked by a stone slab.  You climb
        down again. ";
    }
    machinetrans = Blue_Zarkalon_Tower_Basement
    ana = Blue_Zarkalon_Tower_Basement
;

Blue_Zarkalon_Tower_Basement: darkroom, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 1
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    isbasement = true // flag for StrangeMachine.heredesc
    sdesc = "Tower Basement (Blue level)"
    ldesc = {
        I(); "You're in the basement of the tower - a small circular room
        with smooth plastered walls.  A spiral staircase leads up. ";
    }
    hasfloor = true // room with a floor
    up = Blue_Zarkalon_Tower_Base
    machinetrans = GreenZarkalonCabinet
    kata = Zarkalon_Tower_Basement
;

Green_Zarkalon_Tower_Basement: darkroom, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 2
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    isbasement = true // flag for StrangeMachine.heredesc
    sdesc = "Tower Basement (Green level)"
    ldesc = {
        I(); "You're in the basement of the tower - a small circular room
        with whitewashed stone walls.  A spiral staircase leads up. ";
    }
    hasfloor = true // room with a floor
    up = Green_Zarkalon_Tower_Base
    kata = Blue_Zarkalon_Tower_Basement
;

// This is where the pendant-charging machine and discolored disk go to
// once the green rod puzzle has been completed.
GreenZarkalonCabinet: keyedLockable
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 2
    contentsVisible = true
    sdesc = "large glass-fronted cabinet"
    ldesc = "It's a large and very sturdy steel cabinet with a glass front.
        The glass has been reinforced with fine silver wires - probably
        mithril silver again.  There's no way you'll break it. "
    heredesc = {
        P(); I();
        "There is a sturdy steel cabinet here with a glass front. ";
    }
    noun = 'cabinet' 'glass'
    isopen = nil
    islocked = true
    verDoBreak(actor) = {}
    doBreak(actor) = {
        "The glass withstands your onslaught.  I doubt whether
        you'll even manage to scratch it. ";
    }
    verDoAttack(actor) = {}
    verDoAttackWith(actor) = {}
    doAttack(actor) = {self.doBreak(actor);}
    doAttackWith(actor,io) = {self.doBreak(actor);}
    mykey = office_keys //unobtainable
    location = Green_Zarkalon_Tower_Basement
    verDoLookin(actor) = {}
    verDoSearch(actor) = {}
;

Exhibits: decoration
    game701p = true
    isListed = true
    location = GreenZarkalonCabinet
    isThem = true
    sdesc = "various exhibits"
    adesc = {self.sdesc;}
    noun = 'exhibits'
    adjective = 'strange' 'various'
    ldesc = 
        "It's a collection of strange objects, all of them completely
        unfamiliar to you.  It's impossible to guess what any of the
        objects were used for.  The yellowing cards which describe the
        exhibits are all written in Elvish. "
;

Zarkalon_Tower_Base: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    isolated = true // no path to main Red-level area without Transindection
                    // (or by spinning the black rod, in this case)
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "Tower Base"
    ldesc = { I();
        "You're at the base of the tower.  A stone staircase leads up, but
        it appears to be in poor repair.  The only obvious exit is the
        doorway to the north, leading out. ";
    }
    hasfloor = true // room with a floor
    up = {
        "After a few feet, the stairs are blocked by fallen masonry.  You
        are forced to climb down again. ";
        return nil;
    }
    out = Zarkalon_Cliff_Top
    north = Zarkalon_Cliff_Top
    ana = Blue_Zarkalon_Tower_Base
;

RuinedStair1: fixeditem, upclimbable

    game701p = true
    sdesc = "ruined staircase"   
    ldesc = {
        "The staircase extends about 20 feet from the ground floor, 
        above which it is blocked by fallen masonry. ";
    }
    noun = 'staircase' 'stair' 'stairs'
    verDoClimb(actor) = {}
    doClimb(actor) = {
        return actor.location.up;
    }
    location = Zarkalon_Tower_Base
;

Masonry: fixeditem
    sdesc = "fallen masonry"
    ldesc = { I();
        "It consists mainly of stairs which have fallen from the shaft
        above you. ";
    }
    noun = 'rubble' 'masonry' 'stones'
    adjective = 'fallen'
    verDoSearch(actor) = {}
    doSearch(actor) = {
        "The rubble doesn't seem to be concealing
        anything of interest. ";
    }
    location = Zarkalon_Doorsite
;

Zarkalon_Doorsite: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    isolated = true // no path to main Red-level area without Transindection
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "Middle of Ruined Staircase"
    ldesc = { I();
        "You are standing on a short section of the ruined staircase which is
        still intact.  The staircase below you is blocked by fallen 
        masonry, and the stairs above you have collapsed.  To the east, a
        dark doorway leads into a small room! ";
        self.seendoorway := true;
    }
    hasfloor = true // room with a floor

    ana = Blue_Zarkalon_Doorsite
    east = Doorsite_SmallRoom
;

RuinedStair2: fixeditem
    game701p = true
    sdesc = "ruined staircase"   
    ldesc = {
        "The stairs below you are blocked, and the stairs above you have
        collapsed.  You won't be able to leave this area by conventional
        means. ";
    }
    noun = 'staircase' 'stair' 'stairs'
    verDoClimb(actor) = {"You can't climb these stairs. ";}
    location = Zarkalon_Doorsite
;

Doorsite_SmallRoom: room, NoNPC
    game701p = true
    isolated = true
    Zarkalonroom = true
    sdesc = "Small Room"
    ldesc = {I();
        "You're in a very small room to the east of the staircase. ";
    }
    hasfloor = true // room with a floor
    west = Zarkalon_Doorsite
    out = Zarkalon_Doorsite
    ana = Blue_Doorsite_SmallRoom
;

SmallroomMachine: floatingdecoration
    game701p = true
    isListed = true
    sdesc = "strange machine"
    ldesc = {
        "The device looks very similar to the pendant-recharging
        machines which you saw earlier.  The same gray metal, the same
        shape and size - rectangular, two feet wide by three feet high.
        The front face is inscribed with strange symbols.  In place of
        a slot, the top face bears a hemispherical recess, about three
        inches in diameter.  ";
        P(); I();
        if(self.location.analevel = 0)
            "Unfortunately this machine shows signs of damage.  The front
            face looks blackened and discolored, and there is a ragged hole in
            the left-hand side. ";
        else if (self.isused)
            "You see the obvious signs of the successful repair.  The
            square section of the front face which has been removed and 
            welded back.  The rectangular plate covering the hole on the
            side.  The bricked-up wall, to conceal the existence of this
            machine from the outside world.  No doubt the mining corporation
            had also bought the silence of the few people who knew about 
            it. ";
        else {
            "You note with interest that someone has put in some maintenance
            on this machine.  A section of the front face - about
            eighteen inches on a side - appears to have been cut out and
            welded back in place.  The hole in the side has been covered
            with a small rectangular plate";
            if (not self.charged)
                 ", but now there is an oblong hole below the plate, measuring
                 about 4 by 2 inches. ";
            else
                 ". ";
        }
    }
    noun = 'machine' 'recess'
    adjective = 'strange'
    verIoPutIn(actor) = {}
    verIoPutOn(actor) = {}
    ioPutIn(actor,dobj) = {
        if((self.location.analevel = 1) and (isclass(dobj,oblong_box_class))) {
            if (self.charged)
                "The hole has closed up, so you can't insert a second box. ";
            else
                MachineHole2.ioPutIn(actor,dobj);
        }
        else
            self.ioPutOn(actor,dobj);
    }
    ioPutOn(actor,dobj) = {
        if((self.location.analevel = 1) and (not self.charged)) {
            "Nothing exciting happens, so you remove <<dobj.thedesc>> from the
            recess. ";
        }
        else if((self.location.analevel != 1) && ((dobj = lead_sphere) ||
        (dobj = platinum_sphere) || (dobj = brass_sphere) ||
        (dobj = iridium_sphere))) 
            "There is a bright flash of light, and the sphere begins to
            glow.  But something is wrong with the machine.  Smoke pours
            out of the hole in the side, and the glow fades - leaving the
            sphere unchanged. You remove it from the recess. ";
        else if(dobj = lead_sphere) {
            "There is a bright flash of light, and the sphere glows
            intensely for a few seconds.  You remove it from the recess,
            noting that it has now changed.  In fact, it's now a platinum
            sphere! ";
            platinum_sphere.moveInto(lead_sphere.location);
            lead_sphere.moveInto(nil);
            self.isused := true;
        }
        else if (dobj = platinum_sphere) {
            "There is a bright flash of light, and the sphere glows
            intensely for a few seconds.  You remove it from the recess,
            noting that you have converted it back to lead. ";
            lead_sphere.moveInto(platinum_sphere.location);
            platinum_sphere.moveInto(nil);
        }
        else if(dobj = brass_sphere) {
            "There is a bright flash of light, and the sphere glows
            intensely for a few seconds.  You remove it from the recess,
            noting that it has now changed.  In fact, it's now an iridium
            sphere! ";
            iridium_sphere.moveInto(brass_sphere.location);
            brass_sphere.moveInto(nil);
            self.isused := true;
        }
        else if (dobj = iridium_sphere) {
            "There is a bright flash of light, and the sphere glows
            intensely for a few seconds.  You remove it from the recess,
            noting that you have converted it back to brass. ";
            brass_sphere.moveInto(iridium_sphere.location);
            iridium_sphere.moveInto(nil);
        }
        else
            "Nothing happens, so you remove <<dobj.thedesc>> from the 
            recess. ";
    }
    loclist = [Doorsite_SmallRoom, Blue_Doorsite_SmallRoom]
;

MachineHole: fixeditem
    sdesc = "hole"
    ldesc = "It's a rougly circular hole with a ragged outline, about 3
        inches in diameter. "
    noun = 'hole'
    adjective = 'ragged'
    verDoLookin(actor) = {}
    doLookin(actor) = {
        "You see blackened and melted electronic components.  It's obvious
        that this machine is broken. ";
    }
    verIoPutIn(actor) = {
        "Despite the damage, there may be live parts in there.  So I don't
        advise you to put anything inside! ";
    }
    location = Doorsite_SmallRoom
;

MachineHole2: fixeditem
    sdesc = "oblong hole"
    ldesc = "It's about four inches wide by two inches high. "
    noun = 'hole' 'slot'
    adjective = 'ragged' 'oblong'
    verDoLookin(actor) = {}
    doLookin(actor) = {
        "You see an empty rectangular slot, about 6 inches deep. ";
    }
    verIoPutIn(actor) = {}
    ioPutIn(actor,dobj) = {
        if(isclass(dobj,oblong_box_class)) {
            "You carefully insert the box into the hole, until its front
            surface makes a perfect fit with the surface of the machine.  
            There is a strange humming noise, and the outlines of the box 
            glow faintly for a few seconds before disappearing altogether! ";
            dobj.moveInto(nil);
            self.moveInto(nil);
            SmallroomMachine.charged := true;
        }
        else {
            "Nothing interesting happens, so you take <<dobj.thedesc>> out
            again. ";
        }
    }
    location = Blue_Doorsite_SmallRoom
;

Blue_Zarkalon_Tower_Base: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 1
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "Tower Base (Blue level)"
    ldesc = { I();
        "You're at the base of the tower.  The exit to the north is firmly 
        locked, but the staircase now leads both up and down.  Stone slabs
        (which presumably blocked the way down) are piled up to one side of
        the staircase.
        Its walls have been plastered and painted and are now completely
        smooth and featureless.  ";
    }
    hasfloor = true // room with a floor
    // Stop at the doorway site if it has been seen at Green level, 
    // otherwise go all the way up.
    up = {
        if(Green_Zarkalon_Doorsite.isseen)
             return Blue_Zarkalon_Doorsite;
        else
             return Blue_Zarkalon_Tower_Top;
    }
    down = Blue_Zarkalon_Tower_Basement
    kata = Zarkalon_Tower_Base
    out = {
        "The door is firmly locked. ";
    }
    north = {return self.out;}
    exithints = 
        [Blue_Zarkalon_Doorsite, &up, Blue_Zarkalon_Tower_Top, &up]
;
BlueTowerBaseSlabs: decoration
    sdesc = "stone slabs"
    ldesc = "They have been removed from the apparent base of the spiral
            stair, which now continues down to a basement room. "
    noun = 'slabs'
    adjective = 'stone'
    location = Blue_Zarkalon_Tower_Base
;

Green_Zarkalon_Tower_Base: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 2
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "Tower Base (Green level)"
    ldesc = { I();
        "You're at the base of the tower.  A repaired stone staircase
        leads both up and down, but the exit to the north is firmly locked. ";
    }
    hasfloor = true // room with a floor
    up = Green_Zarkalon_Doorsite
    kata = Blue_Zarkalon_Tower_Base
    out = {
       "The door is firmly locked. ";
    }
    north = {return self.out;}
    down = Green_Zarkalon_Tower_Basement
;

Blue_Zarkalon_Doorsite: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 1
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "About 20 feet up the stairs (Blue Level)"
    ldesc = {I();
            "You are on the Blue-level staircase, at the site of the doorway,
            but there's now no sign of a doorway at this Transindection level -
            only smooth plastered walls. ";
    }
    hasfloor = true // room with a floor
    kata = Zarkalon_Doorsite
    down = Blue_Zarkalon_Tower_Base
    up = Blue_Zarkalon_Tower_Top
;

Green_Zarkalon_Doorsite: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 2
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "About 20 feet up the stairs (Green Level)"
    ldesc = {I();
         "You are about 20 feet up the Green-level staircase.  A small
         door leads east";
         if (GreenSmallroom_door.islocked)
              ", but is firmly locked. ";
         else
              ". ";
    }
    hasfloor = true // room with a floor
    kata = Blue_Zarkalon_Doorsite
    down = Green_Zarkalon_Tower_Base
    up = Green_Zarkalon_Tower_Top
    east = GreenSmallroom_door
;

GreenSmallroom_door: CCR_lockableDoorway
    game701p = true
    externalDoor = nil
    sdesc = "small door"
    noun = 'door'
    adjective = 'small'
    mykey = broken_key // from searching Eldrand
    doUnlockWith(actor,io) = {
        inherited.doUnlockWith(actor,io);
        if (not self.islocked and not self.isunlocked) {
            self.isunlocked := true;
            "You stare in disbelief as the realization hits you.  This key
            no longer fits the lock for which it was intended, but here the
            converse is also true - it now fits a lock for which it wasn't
            intended! ";
            global.treasures++;
            global.treasures_to_find += iridium_sphere;
            if (global.closure)
                 cancel_cave_closure(true);
        }
    }
    doordest = Green_Doorsite_SmallRoom
    location = Green_Zarkalon_Doorsite
    otherside = GreenSmallroom_door2
;

Blue_Doorsite_SmallRoom: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 1
    Zarkalonroom = true
    sdesc = "Small Room (Blue level)"
    ldesc = {I();
        "You're in a very small room, identical to its counterpart at Red
        level except for the doorway to the west, which appears to have been
        bricked up from the other side. ";
    }
    hasfloor = true // room with a floor
    kata = Doorsite_SmallRoom
    myhints = [Machinehint]
;

Green_Doorsite_SmallRoom: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 2
    Zarkalonroom = true
    sdesc = "Small Room (Green level)"
    ldesc = {I();
        "You're in a very small, featureless room.  Marks on the floor 
        indicate that some sort of machine used to be here, but a 
        handwritten note
        attached to the wall reads
        \"Removed for recomprisation\".  The only exit is the
        door leading out to the west.  ";
    }
    hasfloor = true // room with a floor
    west = GreenSmallroom_door2
    kata = Blue_Doorsite_SmallRoom
    myhints = [Machinehint]
;

GreenSmallroom_note: readable, fixeditem
    sdesc = "handwritten note"
    ldesc = "It reads: \"Removed for recomprisation.\"  I'm not sure what that
    means - maybe it's been taken away for repairs.  Anyway, there's no
    machine here - at this Transindection level, anyway. "
    noun = 'note'
    adjective = 'handwritten'
    location = Green_Doorsite_SmallRoom
    verDoTake(actor) = {
        "The note is very firmly attached to the wall and you are unable to 
        remove it. ";
    }
;


GreenSmallroom_door2: CCR_lockableDoorway
    game701p = true
    externalDoor = nil
    sdesc = "small door"
    noun = 'door'
    adjective = 'small'
    mykey = broken_key // from searching Eldrand
    location = Green_Doorsite_SmallRoom
    doordest = Green_Zarkalon_Doorsite
    otherside = GreenSmallroom_door
;    

Zarkalon_Tower_Top: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    isolated = true
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "At Top of Tower"
    ldesc = { I();
        "You're in a circular room at the top of the tower.  A cool wind blows 
        through the broken windows, which have little glass left in them.
        To the east you see a magnificent view of the sea, illuminated by the
        light of three small moons.  A large abandoned city stretches to the
        west, its eerie, blackened buildings illuminated by the light of the 
        moons and the aurora which fills the sky.  Most of the buildings are 
        in ruins, but a few are still standing, often four or five stories 
        tall. ";
    }
    hasfloor = true // room with a floor
    down = {
        "The staircase has collapsed. There's no way down from here. ";
        return nil;
    }
    ana = Blue_Zarkalon_Tower_Top
;

RuinedStair3: fixeditem, downclimbable
    game701p = true
    sdesc = "ruined staircase"   
    ldesc = {
        "The staircase has collapsed.  You'd break your neck if you tried
        to climb down from here. ";
    }
    noun = 'staircase' 'stair' 'stairs'
    verDoClimb(actor) = {}
    doClimb(actor) = {
        return actor.location.down;
    }
    location = Zarkalon_Tower_Top
;

Blue_Zarkalon_Tower_Top: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 1
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "At Top of Tower (Blue level)"
    ldesc = { I();
        "You're in a circular room at the top of the tower.  Many
        signs of recent repairs are evident, including the windows which
        have been re-glazed.  To the east you see the seascape, and to the 
        west an abandoned city stretches out before you - or more
        accurately, a previously abandoned city.  Most of the buildings are 
        in ruins, but many of them are lit by electric lights and the more 
        intact ones - often four or five stories tall - are covered in
        scaffolding.  Large archeological digs are in progress at several 
        sites. ";
    }
    hasfloor = true // room with a floor
    // Stop at the doorway site if it has been seen at Green level, otherwise
    // go all the way down.
    down = {
        if(Green_Zarkalon_Doorsite.isseen)
             return Blue_Zarkalon_Doorsite;
        else
             return Blue_Zarkalon_Tower_Base;
    }
    kata = Zarkalon_Tower_Top
    listendesc = "You hear the sound of many generators, producing
        electricity to light the city. "
    exithints = [Blue_Zarkalon_Doorsite, &down, Blue_Zarkalon_Tower_Base,
        &down]
;

Zarkalon_Tower_Plaque: fixeditem, readable
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    sdesc = "brass plaque"
    heredesc = {
        P(); I();
        "A small brass plaque is attached to the wall.  It 
        bears the logo and name of the Mammoth Cave Mining Corporation,
        below which you can see more information in smaller print. ";
    }
    ldesc = {
        "The plaque bears a logo at the top, below which the following
        words are inscribed: ";
        P(); I(); 
        "\"MAMMOTH CAVE MINING CORPORATION ";
        P(); I();
        "Artefacts discovered in this tower";
        P();
        "Platinum sphere (during reconstruction of staircase).\n";
        "Blue wand (in basement room, now in Museum.)\n";
        "Medallion-charging machine (in Basement room, now in Travertine
        room exhibition.)\" ";
        self.isread := true;
    }
    noun = 'plaque'
    adjective = 'brass'
    location = Blue_Zarkalon_Tower_Top
;    


Green_Zarkalon_Tower_Top: room, NoNPC
    game701p = true
    wino_quicksand = true // must cross quicksand to leave (by conventional
                          // means)
    analevel = 2
    Zarkalonroom = true // Zarkalonized pendant required for transindection
    sdesc = "At Top of Tower (Green level)"
    ldesc = { I();
        if(global.onlyviewing) {
            "You're in a circular room at the top of a tower.  Somehow you
            know that you're on an alien planet, whose existence is known 
            to very few people at Red level.  However, the Green-level 
            elves discovered it at the end of the nineteenth century and 
            called it \"Ondralstir\", and the Blue-level humans found it 
            about five years ago and named it \"Zarkalon\". ";
            P(); I();
            "You peer through the windows.  The entire scene is lit by the
            glow of an aurora, far brighter than you'd ever see on Earth.
            To the east, the light of three small moons is reflected in an
            ocean.  To the west lies a bustling modern metropolis, rebuilt 
            by the Elves on the foundations of an abandoned city. "; 
            P(); I();
            global.knowsgreenname := true;
        }
        else {
            "You're in a circular room at the top of the tower.
            Many signs of old repairs are evident, including the windows which
            were re-glazed but now look somewhat neglected.  A seascape lies
            to the east,  and to the west you see a bustling modern city which
            appears to have been rebuilt on the foundations of the 
            original.  ";
        }
        "Domes, towers and spires 
        stretch to the horizon, and all the streets and buildings are brightly
        lit.  You notice that the bilingual road signs are in English and
        Elvish, but most of the shop signs are in English.  A few police
        officers are patrolling a nearby street.  Their uniforms are made from
        a silvery fabric - mithril silver, perhaps? ";
    }
    hasfloor = true // room with a floor
    // At green level, stop at the small room entrance.
    down = Green_Zarkalon_Doorsite
    kata = Blue_Zarkalon_Tower_Top
    listendesc = "You hear the sound of a bustling, vibrant city. "
    exithints = [Green_Zarkalon_Doorsite, &down]
;

Zarkalon_Tower_Window: floatingdecoration
    sdesc = "windows"
    ldesc = {
        switch (self.location.analevel) {
            case 0:
                "A cool wind blows through the broken panes.  Most of the
                glass is missing. ";
                break;
            case 1:
                "The windows have recently been reglazed. ";
                break;
            case 2:
                "The windows were reglazed at some point in the past, but
                now look somewhat shabby and neglected. ";
                break;
        }
    }
    noun = 'window' 'windows'
    verDoLookthru(actor) = {}
    doLookthru(actor) = {
        "All around you, the scene is illuminated by the glow of an aurora
        which fills the entire sky.  To the east you see an ocean, illuminated
        by the light of three small moons. ";
        switch (self.location.analevel) {
            case 0:
                "To the west, a large abandoned city stretches out before 
                you. "; 
                break;
            case 1:
                "To the west, a large city stretches out before 
                you.  It appears to have been abandonded until recently,
                but the signs of recolonization are everywhere. "; 
                break;
            case 2:
                "To the west, you see a bustling metropolis.  Brightly
                lit domes and spires stretch to the horizon. ";
                break;
        }

    }
    loclist = 
        [Zarkalon_Tower_Top, Blue_Zarkalon_Tower_Top,
        Green_Zarkalon_Tower_Top]
;
    BlueLevelLighting: floatingdecoration
    sdesc = "fluorescent lighting"
    ldesc = "It looks like ordinary fluorescent lighting.  The fittings are
        long and rectangular. "
    noun = 'light' 'lights' 'lighting'
    adjective = 'fluorescent'
    loclist = [ Blue_Hall_Of_Mists,  Blue_East_Bank_Of_Fissure,
    Blue_West_Side_Of_Fissure,  Blue_West_End_Of_Hall_Of_Mists,
    Blue_East_End_Of_Long_Hall,  Blue_West_End_Of_Long_Hall,
    Blue_Sandstone_Chamber,  Blue_Nugget_Of_Gold_Room,
    Blue_Hall_Of_Mt_King, In_Elevator, Blue_Top_Of_Small_Pit,
    Blue_Bird_Chamber,
    Blue_Zarkalon_Tunnel_Entrance, Blue_Zarkalon_Tunnel ]
;
