/*
 * Adventure 551
 *
 * A remake of David Long's 551-point version of the classic Adventure game
 * by Don Woods and Willie Crowther, based on the Fortran sources.  This TADS
 * version is adapted from David Baggett's port (Colossal Cave Revisited) of
 * the original 350-point game.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      dmb     In real life:   David M. Baggett
 *
 *      djp     In real life:   David J. Picton
 *
 * Modification History (this file)
 *
 * CCR
 * ===
 *
 *  1-Jan-93    dmb     rec.arts.int-fiction BETA release (source only)
 *                      For beta testing only -- not for general
 *                      distribution.
 * 20-Apr-93    dmb     Added the stream decoration to Inside_Building
 *                      you can get water there.
 *
 * AD551
 * =====
 *
 * 14-Apr-99    djp     Initial release of Adventure 551 (1.01)
 *
 * 15-Jul-99    djp     New release (2.00)
 *                      Changes in this release
 *                      Defined methods for 'search' to be synonymous with
 *                      'inspect' by default
 *
 * POLYADV
 * =======
 *
 * 24-Aug-99    bjs     Pre-release version 0.00
 *
 *          djp+bjs     Incorporated ad551 mods up to 2.20
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *                      * Enhanced checksmash to include the vial.
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *
 *
 * 31-May-03    djp     Version 2.10: minor bugfixes and enhancements
 *                      Changes in this version
 *                      * New defaults for OPEN x WITH y
 *
 * 12-Aug-03    bjs     Version 2.11: added LIFT x WITH y, for 580-point game
 *
 * 23-Aug-03    djp     Version 2:12: 
 *                      * Cured a bug which prevented the dragon from being
 *                        killed from the north part of the room (all fixed
 *                        items have the bothsides property set to true
 *                        by default)
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *                      * Added PULL X with Y, PUSH X with Y for 580-point
 *                        game.
 */

/*
 * This file is #included after adv.t and defines extensions to the thing
 * class, excluding extensions related to standard library verbs and
 * methods */


modify thing

// SECTION 1: SPECIAL PROPERTIES AND METHODS

// Property to hold list of created objects.
    list = []

// Property to indicate whether an object is accessible from both sides of
// the dragon.  By default, fixed items are accessible.

    bothsides = {return self.isfixed;}

// method to count identical objects at a location.  Note that the argument
// can be the class, or one of the objects; in the latter case the list
// property will be inherited.  The original statically-defined
// object is included.
    loccount(loc) = {
        local i,j,o,l,ll;
        if(self.objclass) ll := self.list + self.objclass;
        else ll := self.list + self;
        l := length(ll);
        j := 0;
        for (i := 1; i<= l; i++) {
            o := ll[i];
            if(o.location = loc)
                j += 1;
        }
        return j;
    }

// count the objects IN a location.  Note that the argument can be
// the class, or one of the objects; in the latter case the list
// property will be inherited.
    loccountin(loc) = {
        local i,j,o,l,ll;
        if(self.objclass) ll := self.list + self.objclass;
        else ll := self.list + self;
        l := length(ll);
        j := 0;
        for (i := 1; i<= l; i++) {
            o := ll[i];
            if(o.isIn(loc))
                j += 1;
        }
        return j;
    }

// Determine whether an object of a given class is in the location
    classfind(loc) = {
        local o;
        o := firstobj(self);
        while (o <> nil) {
            if(o.isIn(loc)) return true;
            o := nextobj(o, self);
        }
        return nil;
    }

// Determine the number of objects of a given class is in the location
    classcount(loc) = {
        local o, count := 0;
        o := firstobj(self);
        while (o <> nil) {
            if(o.isIn(loc)) count++;
            o := nextobj(o, self);
        }
        return count;
    }

/* DJP - added methods to return the floating items which are located in an
   object (floatingcontents), or all the contents of an object
   (allcontents).   It is essential that global.floatingList has been
   set up (normally in preinit) to contain all the floating objects in
   the game.
   Similarly we also define herecontents to be the list of floating items
   with defined heredesc properties which are located in an object.  The
   allherecontents method returns the contents property plus herecontents.
   These methods require that herefloatList be set up in preinit.

*/

    floatingcontents = {
    local i;
    local list := [];
    local o;
    local l := length(global.floatingList);
    for (i := 1; i <= l; i++) {
        o := global.floatingList[i];
        if (o.location = self) list := list + o;
    }
    return list;
    }
    allcontents = {return self.contents + self.floatingcontents;}
    herecontents = {
    local i;
    local list := [];
    local o;
    local l := length(global.herefloatList);
    for (i := 1; i <= l; i++) {
        o := global.herefloatList[i];
        if (o.location = self) list := list + o;
    }
    return list;
    }
    allherecontents = {return self.contents + self.herecontents;}

/* same as isIn but without regard to visibility. - DJP */
    isInside( obj ) =
    {
    local myloc;

    myloc := self.location;
    if ( myloc )
    {
        if ( myloc = obj ) return( true );
        return( myloc.isInside( obj ));
    }
    return( nil );
    }

// DJP: initial default for travel route
    nextRoute = 0

// DJP - routine to check whether an object should break when put on the
//       floor etc.  Called only by selected objects (e.g. rug)
//       returns nil if special actions were taken, true if not.  If it
//       returns nil, messages like 'dropped' should not be issued
//       afterwards.

    checksmash(actor,dobj,prep,where) = {
        if(where.softfloor) return true;
        else if(dobj = ming_vase) {
            "%You% attempt%s% to set down the vase gently
            <<prep.sdesc>> <<self.thedesc>>.  Unfortunately it slips out
            of %your% hands!"; P();
            if(velvet_pillow.location = where) {
                "Fortunately, the pillow was directly underneath.";P();
                velvet_pillow.ioPutOn(actor, dobj);
                return nil;
            }
            else {
                "The ming vase drops with a delicate crash.";
                dobj.moveInto(nil);
                shards.moveInto(where);
                return nil;
            }
        }
        else if(dobj = glass_vial) {
            if (rand(10) > 1) {
                    glass_vial.noshatter := true;
                    return true;
            }
            "%You% attempt%s% to set down the vial gently
            <<prep.sdesc>> <<self.thedesc>>.  Unfortunately it slips out
            of %your% hands!"; P();
            if(velvet_pillow.location = where) {
                "Fortunately, the pillow was directly underneath.";P();
                velvet_pillow.ioPutOn(actor, dobj);
                return nil;
            }
            else {
                    "The vial strikes <<self.thedesc>> and
                    explodes with a violent >foom<,
                    neatly severing your foot.  You
                    bleed to death quickly and messily.";
                    dobj.shatter;
                    return nil;
            }
        }
        else return true;
    }

/* Determines whether an object is in light, regardless of whether it
   is in a room or a container. */
    islighted = {
        local rem, cur, tot, i;
        // Method called for a room? Call the room's islit method.
        if (isclass(self,room)) return self.islit;
        // otherwise use a similar method to determine whether a lit
        // lamp is visible at this location
        else {
            if ( self.lightsOn ) return( true );
            rem := global.lamplist;
            tot := length( rem );
            i := 1;
            while ( i <= tot )
            {
                cur := rem[i];
                if ( cur.isIn( self ) and cur.islit ) return( true );
                i := i + 1;
            }
        }
        // if an object has a nil location and contains no lit lamps,
        // it's not lighted.
        if (self.location = nil) return nil;
        // object is a closed and opaque container?
        else if (not self.contentsVisible) return nil;
        // repeat method for the object's location.
        else return (self.location.islighted);
    }

// SECTION 2: VERB-RELATED MODIFICATIONS

// Modifications of standard library properties and methods are in 
// advmods.t

// New verbs defined in ccr-verb.t

    verDoPurloin(actor) = {
       if (self.deleted) "\^<<self.thedesc>> <<self.doesdesc>>n't
       exist in this game version. ";
       else if(self.isfixed) "\^<<self.thedesc>> <<self.isdesc>> a fixed
       item. ";
    }
    verDoPurloinNum(actor,io) = {self.verDoPurloin(actor);}
    doPurloin(actor) = {
        if (not self.isfixed) {
            self.moveInto(Me);
            "Purloined.";
        }
        else {caps(); self.thedesc; " is a fixed item.";}
    }

    verDoGonear(actor) = {if (self.deleted) "That object doesn't
    exist in this game version. ";}

    verDoGonearNum(actor,io) = {self.verDoGonear(actor);}
    doGonear(actor) = {
        local o, l, lloc, elem, done, top, ltop;
        "Going to the location of "; self.thedesc; ".\n";
        elem := locselVerb.value;
        locselVerb.value := 1;
        if(self.loclist <> nil) {
            lloc := length(self.loclist);
            if(lloc >= 1) {
                if (elem > lloc or elem < 1) {
                "\nElement out of range: minimum is 1, maximum
                is <<lloc>>. Using first element instead.\n";
                elem := 1;
                }
                l := self.loclist[elem];
            }
            else l := nil;
            }
            else {
            l := self.location;
            done := nil;
            while (not done) {
                if (l = nil) done := true;
                else if (isclass(l,room)) done := true;
                else l := l.location;
            }
        }
        if (l = nil) {
            "That object is not in a room.";
            return;
        }
        // An object in Elsewhere needs special handling.  We
        // should be sent to the Catacombs, with the room number
        // corresponding to the object.
        else if (l = Elsewhere) {
            l := Catacombs; o := self;
            // If the object is contained, find the outermost
            // container.
            while (o.location <> Elsewhere) {
                o := o.location;
                if (o = nil) {
                    "Internal error while trying to find the
                    outermost container of <<self.thedesc>>.";
                    return;
                }
            }
            "Setting room number to <<o.catac_room_num>> ";
            Catacombs.roomnumber := o.catac_room_num;
        }
        "(<<l.sdesc>>):\n";
        // If the actor is in a nested room, we move him/her into
        // the top-level room to make sure that all appropriate
        // leaveRoom methods will be used.

        top := toplocation(actor);
        while (actor.location <> top) {
            if (actor.location.location = nil) {
                "Internal error while trying to move
                <<actor.thedesc>> to the top-level room.";
                return;
            }
            actor.location.leaveRoom(actor);
            actor.moveInto(actor.location.location);
        }

        ltop := toplocation(l);

        // close the walk-in safe if appropriate
        if (In_Safe.isopen and (ltop <> In_Safe) and (ltop <> In_Safe.out)) {
            In_Safe.isopen := nil;
            In_Safe.out := nil;
        } 

            actor.travelTo(l,nil,nil,true);
    }

    verIoCutWith(actor) = {}
    verDoCutWith(actor,io) = {
        if(not isclass(io,weapon))
            "I doubt whether you'd be able to cut anything with
        <<io.thedesc>>.";
        else
            "Trying to cut <<self.thedesc>> wouldn't be very productive.";
    }
    verDoSwim(actor) = {
        "Don't be ridiculous! ";
    }

// DJP: defaults for yank verb (take or drop as appropriate, plus message)
// The yankobj property should be true when the object can be yanked but
// not taken.  (Rejection of the 'take' method should be done in verDoTake
// or verifyRemove; these methods will be bypassed when the object is
// yanked.)
    verDoYank( actor ) = {
        if (self.isIn(actor))self.verDoDrop(actor);
        else if (not self.yankobj)self.verDoTake(actor);
    }
    doYank( actor ) = {
        if (not self.yankobj) "Ok, ok.  No need to be grabby.\n";
        if (self.isIn(actor))self.doDrop(actor);
        else self.doTake(actor);
    }
    verIoYankOut(actor) = {
        self.verIoTakeOut(actor);
    }
    verDoYankOut(actor,io) = {
        if (not self.yankobj) self.verDoTakeOut(actor,io);
        else if (io <> nil and not self.isIn(io) and not 
        (self.fromloc = io)) {
            caps(); self.thedesc; " isn't in "; io.thedesc; ". ";
        }
    }
    ioYankOut(actor,dobj) = {
        if (not dobj.yankobj) "Ok, ok.  No need to be grabby.\n";
        self.ioTakeOut(actor,dobj);
    }

// DJP - common methods for take x with y, lift x with y
    verIoTakeWith(actor) = {}
    verDoTakeWith(actor, io) = {
        if ((io = cups) and not self.isfixed) 
            "It would be simpler to lift it with your hands. ";
        else if (io = cups) {
            caps(); "<<self.thedesc>> is fixed in place and cannot be 
            lifted. ";
        }
        else "How do you propose to lift anything with <<io.thedesc>>? ";
    }

// DJP - lift verb (defaults to take)
    verDoLift(actor) = {
        self.verDoTake(actor);
    }
    doLift(actor) = {
        self.doTake(actor);
    }

// Listen verb
    verDoListento (actor) = {}
    doListento(actor) = {
        self.listendesc;
    }
    listendesc = "You hear nothing unexpected. "

// Default actions for new verbs.
    verDoKick(actor) = { "Feeling violent?"; }
    verDoSmell(actor) = {}
    doSmell(actor) = {
        if (self.isThem)
            "\^<<self.itnomdesc>> smell like
            ordinary <<self.sdesc>>. ";
        else
            "\^<<self.itnomdesc>> smells like an
            ordinary <<self.sdesc>>. ";

    }
    // defaults for wave command reworked.    Weapons can now be waved
    // only if they are carried.
    verDoWave(actor) = {
        if (self.isfixed)
            "You can't wave <<self.thedesc>>! ";
        else if (isclass(self,weapon) and not self.isIn(actor))
            "You're not carrying <<self.thedesc>>! ";
        else self.verifyRemove(actor);
    }
    doWave(actor) = {
        local noask := global.noAskWave;
        global.noAskWave := nil;
        // if noask is set, it means that this method has been
        // called from doWaveAt.  Under these circumstances we
        // ignore the special code for weapons.     We also ignore
        // the code if we're waving a weapon near the shadowy figure
        // in the 350-point game.

        // When the weapons code is called, it issues a dismissive
        // message in the 350-point game; otherwise, it prompts
        // for the indirect object.

        if (isclass(self,weapon) and (not noask) and
        (not (global.vnumber = 0 and actor.isIn(Window.location)))) {
            if (global.vnumber = 0) {
                "Waving weapons around isn't particularly
                useful in the 350-point game mode. ";
            }
            else {
                askio(atPrep);
            }
        }
        else if (actor.isIn(Window.location)) {
            if (self = brass_lantern) {
                "The shadowy figure also waves his lamp
                around - he's definitely trying to attract
                your attention. ";
            }
            else if (self = sword) {
                "The shadowy figure waves back at you with a very
                rusty-looking sword. ";
            }
            else {
                "The shadowy figure waves back at you with a
                similar-looking object. ";
            }
        }
        else {
            "Waving "; self.thedesc; " doesn't seem to do much. ";
        }
    }
    // This method has a variable-length argument list to circumvent
    // a bug in askio, which misses off the dobj argument.    If necessary,
    // we fill it in using parserGetObj.  Note to authors: if you
    // override this method for an object, you'll need to use the
    // same technique.
        verIoWaveAt(actor,...) = {
        local dobj;
        // if a second argument was given, set dobj to it
        if (argcount > 1) dobj := getarg(2);
        // otherwise, find it out using parserGetObj
        else dobj := parserGetObj(PO_DOBJ);
        if (dobj = nil) return; // just in case - but it shouldn't be
        //
        if (isclass(dobj,weapon) and
        (isclass(self,Actor) or isclass(self,feedable)))
            self.verDoAttackWith(actor,dobj);
    }
    verDoWaveAt(actor) = {self.verDoWave(actor);}
    ioWaveAt(actor,dobj) = {dobj.doWaveAt(actor,self);}
    doWaveAt(actor,io) = {
        local selfloc;
        // Waving the rod at a suitable object, or near the Shadowy
        // Figure, gets the appropriate response for the location;
        // otherwise, there is no response.
        if(((self = black_rod) or (self = gray_rod)) and (io.iswavetarget or
        actor.isIn(Window.location))) {
            // let self.doWave know that it's being called
            // from doWaveAt
            global.noAskWave := true;
            self.doWave(actor);
        }
        else if (self = black_rod) "Nothing happens. ";
        // waving a weapon causes the appropriate method to be
        // used.
        else if (isclass(self,weapon)) {
            switch(io) {
                case Dwarves:
                    // in 350-point game, disallow hand-to-hand
                    // attacking of dwarves ...
                    if (global.vnumber = 0) {
                    "Waving the axe at dwarves doesn't work
                    in the 350-point game mode. ";
                    }
                    // but allow it in extended versions.
                    else io.doAttackWith(actor,self);
                    break;
                    // In some cases, attacking with hands
                    // gives an appropriate response ...
                case Snake:
                case little_bird:
                case Bear:
                case Troll:
                case Wumpus:
                case Dog:
                    io.doAttackWith(actor,Hands);
                    break;
                // special case ....
                case Bees:
                    io.verDoAttack(actor);
                    break;
                // in other cases, we attack with the
                // weapon.
                case Goblins:
                case Blob:
                case Basilisk:
                case Djinn:
                case Ogre:
                case Slime:
                    io.doAttackWith(actor,self);
                    break;
                case Dragon:
                    selfloc := self.location;
                    global.saidthrow := true;
                    io.doAttackWith(actor,self);
                    self.moveInto(selfloc);
                break;
                    // The default is simply to wave the object
                    // around.
                default:
                    // let self.doWave know that it's being called
                    // from doWaveAt
                    global.noAskWave := true;
                    self.doWave(actor);
                    break;
            }
        }
        else self.doWave(actor);
    }
    verDoRub(actor) = {}
    doRub(actor) = {"Ok, you just rubbed "; self.thedesc; "."; }
    // Fixed to work correctly for dwarves or multiple objects like the
    // rings.
    verDoCount(actor) = {}
    doCount(actor) = {
        local count := countVerb.value;
        if (count = 1) "You can see one (1) of that item. ";
        else "You can see <<count>> items here. ";
    }
    verDoUse(actor) = {
        "You'll have to be a bit more explicit than that.";
    }
    verDoLight(actor) = {
        "I don't know how to light "; self.thedesc; ".";
    }
    verDoPick(actor) = { "You're babbling, man!  Snap out of it!"; }
    verDoRide(actor) = { "I don't know how to ride such a thing."; }
    verDoWake(actor) = { caps(); self.thedesc; " is not asleep."; }
    verDoBlastWith(actor) = { "Been eating those funny brownies again?"; }
    verDoOil(actor) = { "Yuck."; }
    verDoWater(actor) = { "I don't see any point to that."; }
    verIoOpenWith(actor) = {
        if(self.isfixed) 
            "I don't see how you could open anything with that. ";
    }
    verDoOpenWith(actor, io) = {
        "I don't know how to open 
        <<self.thedesc>> with <<io.adesc>>. ";
    }
    verIoCloseWith(actor) = {
        if(self.isfixed) 
            "I don't see how you could close anything with that. ";
    }
    verDoCloseWith(actor, io) = {
        "I don't know how to close 
        <<self.thedesc>> with <<io.adesc>>. ";
    }
    verIoPullWith(actor) = {
        if(self.isfixed) 
            "I don't see how you could pull anything with that. ";
    }
    verDoPullWith(actor, io) = {
        "I don't know how to pull 
        <<self.thedesc>> with <<io.adesc>>. ";
    }
    verIoPushWith(actor) = {
        if(self.isfixed) 
            "I don't see how you could push anything with that. ";
    }
    verDoPushWith(actor, io) = {
        self.verDoPush(actor);
    }
    ioOpenWith(actor,dobj) = {
        if (defined(dobj,&doOpenWith))
             dobj.doOpenWith(actor,self);
        else
             "I don't know how to open 
             <<dobj.thedesc>> with <<self.adesc>>. ";
    }
    ioCloseWith(actor,dobj) = {
        if (defined(dobj,&doCloseWith))
             dobj.doCloseWith(actor,self);
        else
             "I don't know how to close
             <<dobj.thedesc>> with <<self.adesc>>. ";
    }
    ioPullWith(actor,dobj) = {
        if (defined(dobj,&doPullWith))
             dobj.doPullWith(actor,self);
        else
             "I don't know how to pull
             <<dobj.thedesc>> with <<self.adesc>>. ";
    }
    ioPushWith(actor,dobj) = {
        if (defined(dobj,&doPushWith))
             dobj.doPushWith(actor,self);
        else
             dobj.doPush(actor);
    }

    /*
     * Map douse x with y to pour y on x.  (There's no need in this
     * case to check that the verification method is defined, but in
     * general you need to do so - see the definitions for
     * verIoFeedTo etc. in ccr-npc.t).
     */

    verDoDouseWith(actor) = { self.verIoPourOn(actor); }
    verIoDouseWith(actor,dobj) = { self.verDoPourOn(actor,dobj); }
    ioDouseWith(actor, dobj) = { dobj.ioPourOn(actor, self); }

    verDoPourOn(actor, io) = {
        caps(); self.thedesc; " is going to have to undergo
        a major state change first.";
    }
    doPourOn(actor, io) = {
        "This shouldn't happen.";
    }
    verIoPourOn(actor) = {}
    ioPourOn(actor, dobj) = { dobj.doPourOn(actor, self); }

    verDoLeave(actor) = {
        if(actor.isIn(self) or self.isfixed) {
            if(defined(self,&verDoUnboard))self.verDoUnboard(actor);
            else "I don't know how to leave <<self.thedesc>>. ";      
        }
        else if(self.isIn(actor)) {
            if(defined(self,&verDoDrop))self.verDoDrop(actor);
            else "I don't know how to leave <<self.thedesc>>. ";      
        } 
        else if(self.ischasing) {
            "You'll have to tell me how to do that. ";
        }
        else "You'll need to be more specific about what you want me to do. ";
    }
    doLeave(actor) = {
        if(actor.isIn(self) or self.isfixed)
            self.doUnboard(actor);
        else self.doDrop(actor);
    }

    // DJP - span over
    verIoSpanOver(actor) = {"You can't span anything over that.";}
    verDoSpanOver(actor,io) = {
        if(self.isfixed) 
             "You can't do that, because 
             <<self.thedesc>> <<self.isdesc>> fixed in place! ";
    }
// SECTION 3: Modifications for item manipulation (from ccr-item.t)

    // special property used in place of isListed in nrmLkAround method.
    isListedinRoom = {return self.isListed;}

// SECTION 4: Feeding defaults

    verIoFeedWith(actor) = {}
    // map 'feed x to y' to 'feed y with x'
    verDoFeedTo(actor) = {
        if (not defined(self,&verIoFeedWith))
            "I don't know how to feed <<self.thedesc>> to
            anything. ";
        else self.verIoFeedWith(actor);
    }
    verIoFeedTo(actor,dobj) = {
        if (not defined(self,&verDoFeedWith))
            "I don't know how to feed anything
            to <<self.thedesc>>. ";
        else
            self.verDoFeedWith(actor,dobj);
    }
    ioFeedTo(actor, dobj) = { dobj.ioFeedWith(actor, self); }

// SECTION 5: Generic version-control rules

// All objects specific to the 350-point game are included in the 550-point
// version.  All objects in the 550-point and 551-point games are included 
// in the 701-point game.  If locations differ, the 701-point game uses the
// 551-point location.

   game550 = (self.game350)

   game701 = {
        return (self.game550 or self.game551);
   }
   location701 = {
        if (defined(self,&location551)) return self.location551;
        else if (defined(self,&location550)) return self.location550;
        else return self.location;
   }
   loclist701 = {
        if (self.loclist551 <> nil) return self.loclist551;
        else if (self.loclist550 <> nil) return self.loclist550;
        else return nil;
   }
/* BJS: Everything in the 550-point version is also in the 580-point
 * version. */
   game580 = {
        return (self.game550);
   }
   location580 = {
        if (defined(self,&location550)) return self.location550;
        else return self.location;
   }
   loclist580 = {
        if (self.loclist550 <> nil) return self.loclist550;
        else return nil;
   }

/* 
   We define default game701p and location701p methods for the extended
   version. 
 */

   game701p = {
        return self.game701;
   }
   location701p = {
        return self.location701;
   }
   loclist701p = {
        return self.loclist701;
   }

;

