#charset "us-ascii"
/*

   == Tads-3 Combat

   == Copyright (c) 2004, Steve Breslin
 
   ==>>  License:
     _______________________________________________________________
    /                                                               \
    |     You can use this program however you want, but if you     |
    |     decide to distribute anything that uses, #include's or    |
    |     otherwise borrows from this program, you have to send     |
    |     a copy of any improvements or modify-cations you made     |
    |     to this program to its author, Steve Breslin.             |
    |                                                               |
    |     That way, you will help keep the program up to date for   |
    |     everybody else, and everybody else will help keep it      |
    |     up to date for you.                                       |
    |                                                               |
    |     You may redistribute this verbatim or in modified form    |
    |     only if you keep the copyright and license intact.        |
    |                                                               |
    |     Also, feel encouraged to release your source code along   |
    |     with your game, though this isn't a requirement.          |
    |                                                               |
    |     The author can be reached at <versim@hotmail.com>.        |
    \______________________________________________________________*/

#include <adv3.h>
#include <en_us.h>

/* All combatants have their 'heal' method called
 * each turn.
 *
 * The actual healing is handled by the particular objects, so that
 * each can heal different amounts, and at different frequencies.
 */


Healer: InitObject
    execute() {
        new PromptDaemon(self, &healAll);
    }
    healAll() {
    foreach (local obj in libGlobal.combatantList)
        {
        if (!me.combating)
            {
        obj.heal();
            }
        }
        bottomBan.updateContents('<body bgcolor=#404040 background="art/elements/rock1.jpg"><font color=silver><b>Health: '+toString(gPlayerChar.endurance)); 
    }
;

modify libGlobal
    combatantList = []
;

/* We'll just modify actor. If you want non-combatant actors also,
 * just change this to a mix-in class.
 */

modify Actor
//move = [0, 0]
  picFile = nil
  caption = nil
    AC = 10

    endurance = 10
    maxEndurance = 10

    combating = nil
    wielding = nil

    mainExamine()
  {
    inherited();
    if(picFile)
      self.showPic();
if(picFile == nil)
      {
         mapWindow.updateContents('<body bgcolor=black><font color=silver>
         PIC NOT FOUND...');
      } 
  }
specialDesc { showPic(); stateDesc;} 
  
    showPic()
    {
        
         mapWindow.updateContents('<body bgcolor=black>
         <img src="art/actors/' + picFile + '.png" >');
    if(caption!=nil)
      {
       textWindow.updateContents('<body bgcolor=black><font color=silver>'+caption);  
      }
      
    }
 
 
/*  
   makeProper() 
  { 
    if(properName != nil) 
    { 
      name = properName; 
      initializeVocabWith(properName); 
      isProperName = true; 
    } 
    return name; 
  }
*/
  /*
    suggestTopics(explicit) 
    { 
        local str = mainOutputStream.captureOutput( 
                        {: inherited(explicit) }); 


       textWindow.updateContents(str); 
    }
    */
melee = nil

    initializeActor() {
        inherited();
        libGlobal.combatantList += self;
        melee = new Daemon(self, &autoCombat, 0);
    }

    autoCombat() {
        if (self == gPlayerChar)
            return;
        if (!combating)
        {
            foreach(local obj in enemyList) 
            {
            combating = obj;
             }
        }
        if (combating) 
                        {
                         nestedActorAction(self, Attack, combating);
                        "<SOUND SRC=\"sound/e3m1.mid\" layer=background>";
                        }

        }
    

endMelee
 { 
   if(melee != nil) 
     melee.removeEvent; 
     melee = nil; 
 } 

meleeReloaded
{
if(melee == nil)
melee = new Daemon(self, &autoCombat, 0);
} 


    construct() { initializeActor(); }



    /* This is what executes a heal for each combatant. This
     * method is called by a prompt daemon.
     */
    heal() {
        if (endurance != maxEndurance) {
            if (rand(100) < percentChanceToHeal) {
                endurance += (rand(maxHeal) +1);
                if (gPlayerChar == self)
                    "\nYou feel a bit better.\n";
                else if (gPlayerChar.canSee(self))
                    "\n<<theName>> recovers a bit.\n";
                if (endurance > maxEndurance)
                    endurance = maxEndurance;
            }
        }
    }

    maxHeal = 5 // you will heal at least 1. this is the bonus of that.
    percentChanceToHeal = 25

    /* This method controls the object's sustaining damage. First, the
     * endurance is updated.
     * Then, if endurance is below 1, the object "dies."
     */
    sustainDamage(amount) {
        endurance -= amount;
        if (endurance < 1)
            death(); //could add unconscious state below zero
    }

    /* The attack() method determines if the present object should
     * determine the damage dealt, or if the weapon should determines
     * the damage.
     *
     * Before damage is dealt, we call the beforedamage method, which
     * gets NPC's to auto-wield weapons. You may wish to override this
     * behavior.
     */
    attack(target) {
        combating = target;
        if (target.combating == nil) // if my opponent isn't already fighting
            target.combating = self; // then I become its target-combatant
            //showPic();
        beforedamage(target);
        if (wielding)
            wielding.damage(target);
        else
            damage(target);
    }


    /* Before NPC's attack, they auto-wield any available weapon.
     * You might like to add a message or emotive the monster sometimes
     * makes as it attacks, or change this auto-wield behavior.
     */
    beforedamage(target) {
        if (self != gPlayerChar && wielding == nil) { 
            for (local i = 1 ; i <= contents.length() ; i++) {
                if (contents[i].ofKind(Weapon)) {
                    nestedAction(Wield, contents[i]);
                }
            }
        }
    }

    /* This calculates and performs the damage, only when we have no
     * weapon wielded.
     */
    damage(target) {
        if (calcHit(target)) {
            hitMessage(target);
            target.sustainDamage(calcDamage);
        }
        else
            missMessage(target);
    }

    /* Here we calculate the chance to hit. This is based on the
     * attacker's level and hit bonus, and is counteracted by the
     * target's AC.
     *
     * As a sort of default, we have weighted things such that hitting
     * happens about 50% of the time.
     *
     * The author can easily adapt this by modifying either the base AC
     * and/or the hitbonus and/or this calcHit() method.
     *
     * If you want to modify how hits are calculated, you can modify
     * the following method, but you might rather modify the caller,
     * damage(target) in some way as well. For example, some find it
     * "more realistic" for armor to soak a certain amount of damage
     * inflicted by attacks rather than making the armored PC/NPC
     * harder to hit. Some such systems portray armour as ablative,
     * much like additional hit points would be, while others treat it
     * as a fixed reduction to the damage of all attacks.
     *
     * The hazard to such systems is that a heavily-armoured PC can wade
     * into the thick of a melee and know that he/she is essentially
     * invulnerable, which detracts from combat tension. There are
     * a couple ways to avoid that problem. For example, as a game
     * designer you can arrange things so that the PC never has
     * access to armor so powerful that it stops all damage. Also,
     * you can introduce the concept of a "critical hit", which would be
     * a low-probability (say, 5%) event that would bypass all armor.
     * Either approach makes armor a valuable commodity (as it was in
     * most low-tech armies), but prevents it from becoming an unrealistic
     * panacea.
     *
     * Keep foremost in mind, though, that realism or believability
     * isn't the final measure for a good game, if a measure it be at
     * all -- and efforts in that direction can all too easily detract
     * from the fun.
     */
    calcHit(target) {
        return (rand(20) > (20 - (level + hitBonus) + (10 - target.AC)));
    }

    level = 1 // by default

    hitBonus = 10 // by deafult

    /* This determines bare hand damage dealt. */
    calcDamage() {
        local total = 0;
        for (local i = 1 ; i <= dice ; i++) {
            total += rand(sides);
        }
        return total;
    }

    /* Default bare hand damage: */
    dice = 1
    sides = 4

    /* We note the endurance after the normal inspection material.
     */
    desc {
        "\^{Your dobj/her} endurance is
        currently <<endurance>> of <<self.maxEndurance>>.\n";

    }

    /* These messages are used when the player has no weapon.
     * If the player has a weapon, the weapon's hit and miss
     * messages are used instead.
     */
    hitMessage(target) {
        if (self==me)
        { textWindow.updateContents('<body bgcolor=black><font color=white>', nil);
           "<SOUND SRC=\"sound/hit.wav\" layer=foreground>";
    }
        if (self!=me)
        { textWindow.updateContents('<body bgcolor=black><font color=green>', nil);
    "<SOUND SRC=\"sound/jab2.wav\" layer=foreground>";}
       
        textWindow.updateContents('{You/he} punch{es} '+target.theName+'.\n', nil);
    
    }

    missMessage(target) {
  if (self==me)
        { textWindow.updateContents('<body bgcolor=black><font color=white>', nil);
    }
        if (self!=me)
        { textWindow.updateContents('<body bgcolor=black><font color=green>', nil);
    }
        //"<SOUND SRC=\"sound/swing.wav\" layer=foreground>";
        textWindow.updateContents('{You/he} swing{s} a fist at '+target.theName+', but miss{es}.\n', nil);
    }

    /* When the PC dies, we call playerDies(). Else we call NPCDies().
     */
    death() {
        if (gPlayerChar == self)
            playerDies();
        else
            NPCDies();
    }

    playerDies() {
        "<SOUND SRC=\"sound/pacdies.wav\" layer=foreground>";
        finishGameMsg(ftDeath, [finishOptionUndo, finishOptionCredits]);
    }

    NPCDies() {
        "\^<<theName>> dies.\n";
        npcTurn.endDmon();
        map1.npcs -= self.tile;
        mutantTile.Pos=[0,0];
        endMelee(); 
        removeCombatant();
        //cannibal.visible=nil;
        createCorpse();
        moveInto(nil);
        gPlayerChar.moveIntoForTravel(outside);
        map1.reload();
        //nestedAction(Look);
    }

    removeCombatant() {
        libGlobal.combatantList -= self;
    }

    /* The corpse will probably need to be monster-specific, so
     * we'll cheat around making a corpse in the general case.
     */
    createCorpse() {
        "A cloud of smoke envelopes <<self.theName>>, and slowly
        dissipates, leaving no trace of the body.\n<sound cancel>";
        // or create a generic corpse (container) based on vocabowrds and filled with items.
    //icon='transparent';
    }

    isFriendly(actor) {
        return (friendList.indexOf(actor));
    }

    /* All monsters fight back when attacked, but some monsters
     * are aggressive, and attack first. However, they don't
     * attack friends. E.g., two grues shouldn't attack each other.
     */
    aggressive = true
    friendList = []

    /* Even if I'm not naturally aggressive, I will react negatively
     * towards anyone who attacks me. I will become aggressive, unless
     * I am wimpy.
     */
    enemyList = []
    wimpy = nil

    /*
     *   "Attack" action.
     */
    dobjFor(Attack)
    {
        preCond = [objVisible] //need to put me.Pos vs. cannibal.Pos map comparison here...
        verify() { }
        action() { gActor.attack(self); }
    }

    /*
     *   "Attack with" action - attack with a weapon.
     */
    dobjFor(AttackWith)
    {
        preCond = [touchObj] // should be changed for ranged attacks.
        verify() { }
        action() { gActor.attack(self); }
    }
;

class Weapon: Thing

    /* The weapon calculates and performs the damage, if it is
     * equipped.
     */
    damage(target) {
        if (calcHit(target)) {
            hitMessage(target);
            target.sustainDamage(calcDamage);
        }
        else
            missMessage(target);
    }

    /* By default, weapons hit the target with the same success that
     * a barehand attack hits the target, as determined by the weapon's
     * wielder.
     */
    calcHit(target) {
        return (location.calcHit(target));
    }

    /* Two small methods for generating messages for hits and misses.
     * It would be nice for weapons to make specific messages for
     * the weapon type, and vary the messages so as not to get too
     * repetitive.
     */
    missMessage(target) {
        "{You/he} attack{s} <<target.theName>>, but miss{es}.\n";
    }

    hitMessage(target) {
        "{You/he} hit{s} <<gDobj.theName>> with <<theName>>.\n";
    }

    /* The weapon determines the damage dealt. */
    calcDamage() {
        local total = 0;
        for (local i = 1 ; i <= dice ; i++) {
            total += rand(sides);
        }
        return total;
    }

    /* The default damage dice for a weapon. */
    dice = 1
    sides = 6

    iobjFor(AttackWith)
    {
        preCond = [objHeld]
        verify() { }
        action() { 
            if (gActor.wielding != self)
                tryImplicitAction(Wield, self);
            replaceAction(Attack, gDobj);
        }
        
    }

    dobjFor(Wield) {
        preCond = [objHeld]
        verify() {
            /* make sure the actor isn't already wearing the item */
            if (gActor.wielding == self)
                illogicalNow('{You/he} {is} already wielding {the dobj/him}.');
        }
        action() {
            if (gActor.wielding)
                tryImplicitAction(Doff, gActor.wielding);
            defaultReport('{You/he} wield{s} {the dobj/him}.\n');
            gActor.wielding = self;
        }
    }
    dobjFor(Doff) {
        verify() {
            if (gActor.wielding != self)
                illogicalNow('{You/he} {is} not wielding that. ');
        }
        action() {
            defaultReport('{You/he} remove{s} {the dobj/him}. ');
            gActor.wielding = nil;
        }
    }
    /* get our current state */
    getState = (location.wielding == self ? wielded : notWielded)

    /* get our set of possible states */
    allStates = [notWielded, wielded]
;
wielded: ThingState 'wielded'
    stateTokens = ['wielded']
;
notWielded: ThingState
    stateTokens = ['not wielded']
;

class Armor: Wearable
    AC = 1 // by default, armor lowers the wearer's AC by 1

    makeWornBy(actor) {
        if (wornBy)
            wornBy.AC += AC;
        wornBy = actor;
        if (actor)
            actor.AC -= AC;
    }
;

/* A verb the player can use to find out his current and max endurance:
 */
DefineIAction(Health)
    execAction() {
        "You current endurance is <<toString(gPlayerChar.endurance)>> out
        of <<toString(gPlayerChar.maxEndurance)>>.\n";
if (gPlayerChar.endurance <= (gPlayerChar.maxEndurance/2))
"<sound src=sound/gauntlet_lifeforce.wav layer=foreground>";

    }
;

VerbRule(Health)
    'health' | 'status' | 'endurance'
    : HealthAction
    verbPhrase = 'check/checking health'
;

/* Two verbs for wielding and unwielding weapons:
 */
DefineTAction(Wield);

VerbRule(Wield)
    ('wield' | 'hold' | 'grab' | 'equip') singleDobj
    : WieldAction
    verbPhrase = 'wield/wielding (what)'
;

replace VerbRule(Doff)
    ('doff' | 'take' 'off' | 'unequip') dobjList
    | 'take' dobjList 'off'
    : DoffAction
    verbPhrase = 'remove/removing (what)'
;
replace grammar predicate(Remove):
    'remove' dobjList
    : DoffAction
    verbPhrase = 'take/taking off (what)'
;

/*
 * Monster Spawner (Dynamic Monster Creation)
 *
 */

spawner: object

    /*
     * The spawner is very simple. Just pass the type of actor you want
     * to spawn, plus the location you want it to begin life in.
     */
    spawn(actor, location) {
        local x = actor.createInstance();
        x.moveInto(location);
        x.contents = [];
        x.initializeActor();
        actorAppears(x, location);
    }

    /* actorAppears can be used to produce a message such as
     * "\^<<actor.theName>> appears in a puff of smoke.\n";
     * or something along those lines. Your particular game
     * or some particular situation in the game may want
     * to vary the message or have none at all. So by
     * default we leave this method empty.
     */
     actorAppears(actor, location) {}
;

/*
add a check so that two armor types cannot be worn simultaneously.
maybe make weapons (wielded) in inventory, not just carried.
add afterAction to combatant, for attacking if appropriate.
add verbs defend and charge (?)
add skeleton framework for advancing levels.
    (levelup could include switching to dynamic NPC object.)
disallow attacking self
Make monsters fight other monsters.
Write an example of a magic attack, usable from any room,
    and a ranged attack, usable from a room one link away from
    the target's room.
Make character classes with various special attacks, abilities, etc.
*/


