/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      bjs     In real life:   Bennett J. Standeven
 *
 *      djp     In real life:   David J. Picton
 *
 * Modification History
 *
 *
 * POLYADV
 * =======
 *
 * 24-Aug-99    bjs     Added 550-point extensions, split up items and npcs
 *                      into 3 files; 1 for each version.
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *              djp     Changed the code for BREAK VIAL to be more true
 *                      to the original (i.e. it affects any NPCs which
 *                      are present.)
 *
 * 4-Apr-00     djp     Version 1.01: bugfix release
 *                      Changes in this version
 *                      * Systematically added isThem properties to plural
 *                        objects (i.e. where sdesc is a plural phrase)
 *                      * Changed mushroom.regrow to print a message when
 *                        the mushroom regrows and the player is in the room.
 *                      * Implemented the pull verb for the sword.
 *                      * Defined the helmet as a protect_ring object (i.e.
 *                      * providing protection against the dwarves' knives).
 *                      * Defined a new class 'condlisted' for objects
 *                        like the sword and crown which require a heredesc
 *                        when dropped in the room, but which are listed
 *                        normally in other cases.  The rock sculpture is
 *                        now in this class.
 *
 * 4-May-00     djp     Version 1.02: bugfix release
 *
 * 15-May-00    djp     Version 1.03: bugfix release
 *                      * Fix to destroy vial when it is broken or thrown
 *                        at a wall etc.
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *                      Changes in this version:
 *                      * Changed code for singing sword - in the 701-point
 *                        version we can have it if 3 or more portions of
 *                        blueberries have been eaten.  (In practice, it's
 *                        much easier to eat the mushroom).
 *                      * Changed wine-in-the-flask to reflect its possible
 *                        appearance in the 701-point game.
 *                      * For 701-point game, the mushroom (like the
 *                        blueberries) increases the weight which can be
 *                        carried, not the bulk.
 *                      * For 701-point game we have 4 rings so the
 *                        helmet doesn't provide protection against
 *                        dwarves' knives.
 *                      * Enhanced vial code to recognize 551-point NPCs.
 *              
 * 25-Sep-00    djp     Version 2.01: bugfix release
 *
 * 20-Dec-00    djp     Version 2.02: bugfix release
 *
 * 8-Feb-01     djp     Version 2.03: bugfix release
 *
 * 15-May-01    djp     Version 2.04: bugfix release
 *                      Changes in this version:
 *                      * Changed glass_vial.verDoPutIn to verIoPutIn to 
 *                        avoid TADS error with (say) "put vial in sack".
 *                      * Changed glass_vial.doDrop to look for smashdrop
 *                        property (i.e. objects fall to the room below).
 *
 * 8-Jun-01     djp     Version 2.05: bugfix release
 *
 * 17-Aug-01    djp     Version 2.06: bugfix release with e-mail address update
 *                      * Added the nosack property for the singing sword
 *                      * Changed the class definitions of the flask to
 *                        get correct descriptions
 *
 * 22-Aug-01    djp     Version 2.07: bugfix release
 *
 * 22-Nov-01    djp     Version 2.08: bugfix release
 *                      Changes in this version:
 *                      * Added code to push the player out of the pentagram
 *                        after opening the flask.
 *
 * 13-Jan-03    djp     Version 2.09 rev C: bugfixes and code tidy-up
 *                      Changes in this version:
 *                      * Implemented the fromloc property for the condlisted
 *                        class.
 *                      * Made 'yank' equivalent to 'take' for the singing
 *                        sword.
 *                      * Correction to singing sword code for case when
 *                        blueberries have been eaten.
 *                      * Made the handling of SEARCH and LOOK IN more
 *                        consistent with current adv.t practice - see comments
 *                        in history.t.  Eliminated the use of unnecessary
 *                        doLookin/doSearch methods for containers.
 *                      * Moved the condlisted class definition to ccr-item.t
 *  
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode.
 *
 * 23-Aug-03    djp     Version 2:12 
 *                      * Changed the spyglass ldesc and verDoLookthru
 *                        methods.
 *
 * 23-Jan-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *
 * 16-Jul-06    djp     Version 3.20: Bugfixes and extensions
 *                      * Use the new Wumpi.nodeath() method to determine
 *                        whether the lamp life is to be frozen and deaths
 *                        (from the vial) are to be prevented.  
 *                      * Changed the vial code to check for the presence of
 *                        the pillow before the 'nodeath' test.
 */


 /* Oddly, the 550-point version doesn't allow you to fill the flask.
  *  But I'll allow it anyway. Also, I'll insist that PUT FLASK IN PENTAGRAM
  *  be typed, not just DROP FLASK while in the pentagram room. -BJS
  */

flask: liquidcont, openable
    issealable = true // don't try to fill when closed
    isopen = nil
    isopenable = true
    contname = "flask"
    game550 = true
    sdescbase = "small earthenware flask"
    emptydesc = "small, empty earthenware flask"
    sdesc = {
        if (not self.isopen) "small, sealed earthenware flask";
        else pass sdesc;
    }
    ldesc = {
        if (self.isopen) pass ldesc;
        else "It's a small earthenware flask. It is tightly-sealed and
            has the words, \"London Dry\" written on the side.";
    }
    location = Arabesque
    noun = 'flask' 'gin'
    adjective = 'small' 'earthenware' 'tighly-sealed' 'sealed' 'tightly'
                          'gin' 'london' 'dry'
    // Code for drinking wine from the container.  In the original
    // version, drinking wine from the bottle/flask had the same effect as
    // drinking from the cask/fountain, which doesn't make sense in
    // view of the smaller quantity.
    winocode = {
        local toploc := toplocation(Me);
        local newloc,inv,o,i,l,newturns;
        "The wine goes to your head, and you feel very sleepy ...
        You awaken with a mild headache, and try to focus your
        eyes.... "; P();
        Me.health := (Me.health*90)/100;
        if (brass_lantern.turnsleft > 25 and brass_lantern.ison) {
            newturns := brass_lantern.turnsleft -
            rand(brass_lantern.turnsleft)/ 10;
            if (newturns < 25) newturns := 25;
            brass_lantern.setlife(newturns);
        }
    }

    verIoPutIn(actor) = { if (not self.isopen) "That's a neat trick,
                                                putting things into
                                                a sealed flask!";
    }
    verDoFill(actor) = { if(not self.isopen) "That's a neat trick,
                                              filling the flask without
                                              opening it!"; }

    verDoEmpty(actor) = { if (not self.isopen) "I don't know how to
                                                empty a sealed flask.";
    }

    verDoPourOn(actor, io) = { if (not self.isopen) "That's a neat trick,
                                                     pouring out of a
                                                     sealed flask!";
    }

    verDoDrink(actor) = {
        if (not self.isopen)
            "That's a neat trick, drinking out of a sealed flask!";
        else pass verDoDrink;
    }
    doClose(actor) = {
        "I can't figure out how to reseal it.";
    }
    doOpen(actor) = {
        if(self.isIn(Floor_Pentagram)) { 
            "The wax seal breaks away
            easily.  ";
            if(actor.isIn(Floor_Pentagram)) {
                "A cloud of dark smoke starts to pour up from the
                mouth of the flask and begins to solidify, pushing %you% out 
                of the pentagram!   It condenses into the form of a 
                twelve-foot Djinn.  ";
                actor.moveInto(Floor_Pentagram.location);
            }
            else {
                "A cloud of dark smoke pours up from the
                mouth of the flask and condenses into the form of
                a twelve-foot Djinn standing in the pentagram.  ";
            }
            "He pushes experimentally at the magical wall of the
            pentagram (which holds), and nods politely to you.
            \"MY THANKS, OH MORTAL,\" he says in an incredibly
            deep bass voice.  \"IT HAS BEEN THREE THOUSAND YEARS
            SINCE SOLOMON SEALED ME INTO THAT BOTTLE, AND I AM
            GRATEFUL THAT YOU HAVE RELEASED ME.  IF YOU WILL
            OPEN THIS PENTAGRAM AND LET ME GO FREE, I WILL GIVE
            YOU SOME ADVICE THAT YOU MAY ONE DAY WISH TO
            POSSESS.\"";

            Djinn.moveInto(Floor_Pentagram);
        }
        else "The flask's wax seal crumbles at your touch.  A large
            cloud of black smoke pours out, solidifying into the
            form of a twelve-foot Djinn.  \"AT LAST!\" he says
            in an earth-shaking voice, \"I KNEW THAT SOMEDAY
            SOMEONE WOULD RELEASE ME!  I WOULD REWARD YOU FOR
            THIS, MORTAL, BUT IT HAS BEEN THREE THOUSAND YEARS
            SINCE I HAD A SOLID MEAL, AND I'M NOT GOING TO STAND
            HERE CHATTERING WHEN I COULD BE OUT EATING A SIX-INCH
            SIRLOIN STEAK.  FAREWELL.\"  With that, he somewhat
            rudely explodes back into smoke and drifts quickly
            out of sight.";
        self.isopen := true;
    }
;

metal_plate:  initmess
    game550 = true
    sdesc = "polished metal plate"
    ldesc = {
         "It's so highly polished that you can see your
         reflection in it";
         if (sword.location = Me) {
              ", but it doesn't seem to be a perfect mirror - for some
              reason the image of the gleaming sword looks very rusty. ";
         }
         else ". ";
    }
    // N.B. SEARCH and LOOK IN are not equivalent for mirrors but are for
    // many other objects e.g. containers, crystal ball.
    verDoLookin(actor) = {}
    doLookin(actor) = {self.ldesc;}     

    initdesc = "A highly polished metal plate is leaning against the wall. "
    location = Storage
    noun = 'plate' 'mirror'
    adjective = 'metal' 'polished'
;

DragonTeeth: item
    game550 = true
    sdesc = "dragon's teeth"
    adesc = "several dragon's teeth"
    ldesc = "They're just sharp, pointed teeth."
    location = nil
    noun = 'teeth'
    adjective = 'dragon\'s' 'sharp' 'pointed'
;   // Throwing them is handled in the code for the goblins.

singing_sword: weapon, condlisted // Not to be confused with sword, which is a
    game550 = true            // treasure in the 551-point version.
    sdesc = "singing sword"
    ldesc = "The sword is sharp and shiny.  It is singing
            quietly to itself. "
    initdesc = "There is a sword here, with its blade plunged deep into
               the block of stone.  The sword is singing quietly to
               itself. "
    has_heredesc = (not self.isListed)
    isListed = {
        if (self.location = nil)return true;
        if (not Me.isIn(self.location))return true;
        if (isclass(self.location,room) and not isclass(self.location,
        nestedroom))return nil;
        else return true;
    }
    heredesc = {
        if (self.isStuck) {P(); I(); self.initdesc; return;}
        P(); I(); switch(rand(11)) {
            case 1: "There is a magic sword here, chiming out the bell-like
                    tones of \"Kumbu Ice-fall\" by ringing its blade
                    against the ground."; break;
            case 2: "There is a sword here, singing \"A Day in the Life\"
                    in a quiet, introspective voice."; break;
            case 3: "There is a magic sword here, singing \"Cold Blue
                    Steel and Sweet Fire\" to itself in a plaintive,
                    hopeless voice."; break;
            case 4: "There is a sharp and obviously magical sword here.
                    It is quietly humming excerpts from Prokofiev's \"Romeo
                    and Juliet\" ballet to itself."; break;
            case 5: "There is a sword lying on the ground, jauntily
                    whistling the March from Tchaikovsky's \"Nutcracker
                    Suite\"."; break;
            case 6: "There is a sharp sword lying here. It is (somehow)
                    singing Tchaikovsky's \"1812 Overture\" in twelve
                    parts, by itself!"; break;
            case 7: "The stirring strains of Rossini's \"William Tell\"
                    overture fill the room, coming from a singing
                    sword lying on the ground."; break;
            case 8: "There is a singing sword lying on the ground . From
                    it resound the massed voices of a two-hundred-singer
                    choir, filling the air with the stirring sound
                    of the Hallelujah Chorus from Handel's
                    \"Messiah\"."; break;
            case 9: "There is a sharp and shiny sword here. It is
                    somehow managing to sing Harry Partch's \"Daphne
                    of the Dunes\" without destroying its singing
                    organs (whatever they happen to be...)."; break;
            case 10: "There is a sword here, singing \"Witchi-Tai-To\"
                    in two-part harmony with itself."; break;
            case 11: "There is a very strange singing sword here - it
                    is glowing and vibrating, and the eerie electronic
                    notes of Charles Wuorinen's \"Time's Encomium\"
                    issue from its blade and fill the air."; break;
        }
    }
    location = Sandstone_Chamber
    nosack = true  // tell sack_of_holding not to put it into containers
    fromloc = Stone
    noun = 'sword'
    isStuck = true
    adjective = 'singing' 'sharp' 'shiny' 'magic'

    // We can now remove the sword if the small mushroom or more than two
    // portions of blueberries have been eaten.

    strongenough = (mushroom.is_eaten or (Me.blueberries_eaten > 2))
    verifyRemove(actor) = {
        if(self.isStuck and not self.strongenough) {
            "The sword is firmly embedded in the stone, and you ";
            if (actor.blueberries_eaten > 0)
                "still aren't quite ";
            else        
                "aren't ";
            "strong enough to pull it out.";
        }
    }
    //implement 'pull sword'
    verDoPull(actor) = {
        if (self.isStuck) self.verDoTake(actor);
        else pass verDoPull;
    }
    doPull(actor) = {
        if (self.isStuck) self.doTake(actor);
    }

    doTake(actor) = {
        if(self.isStuck and self.strongenough) {
            "The singing sword slides easily out of the rock.  ";
            self.isStuck:=nil;
        }
        Dwarves.noattack := true;
        pass doTake;
    }

    verDoYank( actor ) = {self.verDoTake(actor);}
    doYank( actor ) = {self.doTake(actor);}
    verIoYankOut(actor) = {self.verIoTakeOut(actor);}
    verDoYankOut(actor,io) = {self.verDoTakeOut(actor,io);}
    ioYankOut(actor,dobj) = {self.ioTakeOut(actor,dobj);}

    doPurloin(actor) = {
        self.isStuck := nil;
        inherited weapon.doPurloin(actor);
    }
;

/* Liquids for this version follow here. */

water_in_the_flask: contliquid
    game550 = true
    mycont = flask
    myflag = &haswater

    sdesc = "water in the flask"
    adesc = "water"
    ldesc = "It looks like ordinary water to me."
    thedesc = "the in-flask water"
    adjective = 'in-flask' 'water'
    noun = 'water'
;

oil_in_the_flask: contliquid
    game550 = true
    mycont = flask
    myflag = &hasoil

    sdesc = "oil in the flask"
    adesc = "oil"
    ldesc = "It looks like ordinary oil to me."
    thedesc = "the in-flask oil"
    adjective = 'in-flask' 'oil'
    noun = 'oil'

;

wine_in_the_flask: contliquid
    game701 = true
    // This object should never show up in other versions.
    mycont = flask
    myflag = &haswine

    sdesc = "wine in the flask"
    adesc = "wine"
    ldesc = "It's a small quantity of sparkling vintage wine in a flask
            marked \"London Dry\".  In a larger container, it might be
            valuable.  "
    thedesc = "the in-flask wine"
    adjective = 'in-flask' 'wine'
    noun = 'wine'

;


glass_vial: item
    game550 = true
    sdesc = "vial of oily liquid"
    ldesc = {
            "It's a small glass vial filled with an oily liquid.  It
             looks somewhat fragile.";
    }
    location = Spherical_Room
    noun = 'vial' 'liquid' 'oil'
    adjective = 'glass' 'oily' 'small' 'liquid' 'fragile'

    /* DJP: Added messages for opening and closing */
    verDoOpen(actor) = {"The vial is very securely sealed, and I can't
            see any way to open it. ";}
    verDoClose(actor) = {"It's already closed. ";}
    verDoLookin(actor) = {}
    verDoSearch(actor) = {}
    doLookin(actor) = {self.doSearch(actor);}
    doSearch(actor) = {"The vial contains an oily liquid.";}

    /* BJS: Added ability to drop vial in Soft Room or on pillow. */

    doDrop(actor) = {
        local toproom := toplocation(actor), nosmash=self.noshatter;
        self.noshatter := nil;
        // check for Wumpi chase condition
        // check for a soft floor
        if (toproom.softfloor) pass doDrop;
        // check for a room in which objects fall to another room below
        // (vial explodes but player is not harmed)
        else if(toproom.smashdrop) {
            "(Dropping to the room below)\n";
            self.vapor_cloud(nil);
            self.moveInto(nil);
        }
        // check for presence of pillow
        else if (velvet_pillow.location = droploc(actor)) {
            "You have set the vial down carefully on the
            pillow.";

            self.moveInto(velvet_pillow);
        }
        // don't kill the player in Transindection areas until the Wumpi
        // chase cycle is complete or the green pendant has been found
        if (Wumpi.nodeath(actor))
            pass doDrop;
        // look for flag set by checksmash
        else if (nosmash) {
            pass doDrop;
        }
        else {
            if (rand(10) = 1) {
                "The vial strikes the ground
                and explodes with a violent >foom<,
                neatly severing your foot.  You
                bleed to death quickly and messily.";
                self.shatter;
            }
            else pass doDrop;
        }

    }

    verDoFill(actor) = { "The vial is sealed."; }
    verIoPutIn(actor) = { "The vial is sealed."; }
    verDoDrink(actor) = { "The vial is sealed."; }

    verDoBreak(actor) = {}
    // DJP - BREAK action changed to have the relevant effect on each
    // NPC in the room.
    alleffects(actor) = {
        local toploc := toplocation(actor);
        local effectlist := [Dwarves Troll Bear Snake little_bird
        Slime Dragon Wumpus Bees Dog Djinn Basilisk Goblins Ogre];
        local i,o,l;
        if (Blob.ischasing and (Blob.chase >= 13)) effectlist += Blob;
        l := length (effectlist);
        for (i := 1; i <= l; i++) {
            o := effectlist[i];
            if (o.isIn(toploc)) {
                P(); self.effects(o);
            }
        }
    }

    doBreak(actor) = {
        // DJP - I've taken the liberty to be more explicit about
        // what is supposed to be going on here.  Dropping the vial
        // can kill the player, so breaking it in one's hands would
        // also be unsafe.  So we break it by throwing it at the
        // floor, but away from the player.
        "You throw the vial towards the center of the room. "; P();
        self.moveInto(nil);
        self.vapor_cloud(nil);
        self.alleffects(actor);
    }
    // Throwing the vial at an NPC just affects the NPC.
    // Throwing it at the room or floor is the same as breaking it.
    doThrowAt(actor, iobj) = {
        if((iobj = theFloor) or isclass(iobj,theFloor)) {
            "You throw the vial at the center of the floor."; P();
            self.moveInto(nil);
            self.vapor_cloud(nil);
            self.alleffects(actor);
            return;
        }
        if(iobj = TheRoom) {
            "You throw the vial at the center of the room."; P();
            self.moveInto(nil);
            self.vapor_cloud(nil);
            self.alleffects(actor);
            return;
        }
        if(iobj = Walls) {
            "You throw the vial at the walls of the room.";P();
            self.moveInto(nil);
            self.vapor_cloud(nil);
            self.alleffects(actor);
            return;
        }
        self.moveInto(nil);
        self.shatter_near(iobj);
    }
    shatter = {
        self.moveInto(nil);
        die();
    }
    // DJP - removed some coding into separate methods to allow it to
    // be used in different places.
    vapor_cloud(o) = {
        "The vial ";
        if (o = parserGetMe()) {
            // don't kill player during Wumpi chase scene.
            if (Wumpi.nodeath(o))
                "bounces off your body, then ";
            else
                "strikes your body, then ";
        }
        else if (o) {
            "lands near to <<o.thedesc>>. It ";
        }
        "explodes into splinters and disintegrates,
        releasing an oily liquid which rapidly sublimes
        into a large mushroom-shaped cloud of ";
        switch(rand(7)) {
            case 1: "pale puce vapor smelling like sequoia sap
                     and ozone."; break;
            case 2: "bright green vapor smelling like pine
                     needles and sea water."; break;
            case 3: "thick yellow vapor smelling like cheddar
                     cheese and bananas."; break;
            case 4: "choking green vapor smelling like chlorine
                     and apples."; break;
            case 5: "misty white vapor with no scent."; break;

            case 6: "nearly-invisible vapor with a strong odor
                     of walnuts and onions."; break;
            case 7: "ominously glowing vapor smelling of hot
                     iron."; break;
        }
    }
    effects(iobj) = {
        switch(iobj) {

            case Dwarves:
                if (Dwarves.numberhere(parserGetMe()) = 1)
                    "The dwarf catches a lungful of the cloud,
                    gags audibly and stumbles out of the room
                    retching, sneezing, and cursing up a storm.";
                else "The dwarves blanche in horror and dash
                    away as fast as their brief and misshapen
                    legs can carry them.";
                Dwarves.scatter; // Scatter the dwarves.
                break;

            case Troll: "The troll calmly waves the vapor away.";
                break;

            case Bear: if(Bear.istame) "The bear inhales some
                of the vapor and moans appreciatively.";
                else "The bear inhales some of the vapor
                and snarls angrily.";
                break;

            case Snake: "The snake completely ignores the vapor.";
                break;

            case little_bird: "The bird breathes in a minuscule
                amount of the vapor and immediately
                sings a twenty-second segment of Morton
                Subotnik's \"Sidewinder\".";
                break;

            case Slime: "The slime filling the passageway to
                the south blackens and shrivels
                away into nothingness.";
                Slime.exists := nil;
                room_move(SlimeRoom,Slime.location);
                Slime.moveInto(nil);
                break;

            case Dragon: "The dragon sniffs the air, rumbles
                deep in his chest, and shoots out
                a small puff of flame that ignites
                and incinerates the vapor.";
                break;

            case Wumpus:
                if (Wumpus.isasleep)
                    "The vapor has no effect on the sleeping Wumpus. ";
                else if (Wumpus.isdead)
                    "Not surprisingly, the vapor has no effect on the dead
                    Wumpus. ";
                else
                    "The Wumpus sniffs the air, waves away the vapor,
                    and starts after you again! ";
                break;

            case Bees: "The vapor enrages the bees, which swarm all over you
                and sting you to death! ";
                die();
                break;

            case Dog:
                if (Dog.isasleep)
                    "The vapor has no effect on the sleeping dog. ";
                else
                    "The dog growls at you, but the vapor has no other
                    effect. ";
                break;

            case Djinn: "The djinn takes in a deep sniff of the
                vapor and comments, \"AH, A TRULY
                FINE ARABIAN PERFUME!  I HAVEN'T
                SMELLED ANYTHING LIKE THAT FOR
                YEARS!\"";
                break;

            case Basilisk: "The basilisk doesn't wake up.";
                break;

            case Goblins: "The gooseberry goblins sniff the
                vapor, screech in terror, and dash
                off into the distance.";
                Goblins.banish; // scare them off.
                break;

            case Ogre:  // The authors seem to have missed this case.
                        // I'll use the text from the 660 point version.
                "With a contemptuous growl the ogre waves the
                vapor aside.";
                break;

            case Me: 
                // Don't kill player during Wumpi chase scene
                if (not Wumpi.nodeath(Me)) {
                    "Unfortunately you are cut to ribbons by
                    glass shards from the explosion!";
                    die();
                }
                break;
            case nil: break; // This should be unreachable, but
                             // just in case...
            default: "The vapors have no effect on "; iobj.thedesc;
                ".\n";
                // includes the blob, beanstalk, and bivalve,
                // naturally.
        }
    }

    // except for Me, the vial doesn't land close enough to the target
    // for the explosion to do any harm, but the gas has effects on
    // various NPC's.
    shatter_near(iobj) = {
            self.vapor_cloud(iobj);
            P();
            self.effects(iobj);
    }
;

mushroom: fooditem, canpick, initmess
    game550 = true
    sdesc = "small mushroom"
    ldesc = "It's just a small mushroom. "
    location = In_Cubicle
    initdesc = "There is a small mushroom growing on the wall. "
    noun = 'mushroom' 'fungus'
    adjective = 'small'

    // For the 701-point game, the player has a sack of holding so the
    // effect of the mushroom is to allow more weight to be carried in the
    // sack, not to allow more items to be held.  The effect of the blueberries
    // is the same, but doesn't wear off.

    doEat(actor) = { "As you swallow the mushroom your mouth becomes
        numb, and everything seems to swirl around you.  The
        effect quickly passes, and you find that your muscles
        have bulged unbelievably.";
        if (global.game701) Me.maxweight += 20;
        else Me.maxbulk := 12;
        self.is_eaten := true;
        notify(self, &strengthWear, self.mushtime);
        self.moveInto(nil);
    }
    is_eaten = nil  // used for the sword's doTake method.
    // Strength is only temporary:
    strengthWear() = { P(); "A strange malaise suddenly afflicts you.
        You shiver with chill, and your muscles seem to
        turn to putty;  everything around you becomes grey
        and unreal.  The fit quickly passes, and you find
        that your body has degenerated back to what it was
        like before you ate the mushroom.";
        if (global.game701) Me.maxweight -= 20;
        else Me.maxbulk := 7;
        self.is_eaten := nil;
        notify(self, &regrow, self.growtime);
    }
    mushtime = 40 // strength wears off after this many turns.
    growtime = 8 // It regrows after this many turns:
    regrow = {
        self.moveInto(In_Cubicle);
        self.moved := nil; // obtain initmess description
        if (Me.isIn(self.location)) {
            P(); I(); self.initdesc;
        }
    }
;

/*
 * Treasures for 550-point version
 */

irid_crown: CCR_treasure_item, condlisted
        // Not to be confused with the elfin crown
    game550 = true
    sdesc = "massive iridium crown"
    ldesc = "It is quite massive, but nearly weightless."
    heredesc = { P(); I();
        "There is a massive crown made of solid iridium
         floating in midair! ";
    }
    location = In_Safe
    noun = 'crown'
    adjective = 'massive' 'iridium' 'floating' 'levitating' 'weightless'
    verDoWear(actor) = {
        "You set the crown on your head, but it floats off.";
    } // In this version , anyway...
      // N.B. In the 660-point game, the player can wear the crown and
      // hears all the safe passwords.
;

/* N.B. the TADS version allows these coins to be used in the vending machine.
   The original version didn't! */
bag: CCR_treasure_item, initmess, coinitem
    game550 = true
    sdesc = "bag filled with pieces of eight"
    ldesc = "The coins look quite valuable!"
    location = Beach
    initdesc = "There is a bag (obviously filled with pieces of eight) in
    the dinghy! "
    noun = 'bag'
    adjective = 'coins' 'pieces' 'eight'
    verDoLookin(actor) = {}
    verDoSearch(actor) = {}
    doLookin(actor) = {self.doSearch(actor);}
    doSearch(actor) = {
        "The bag is filled with pieces of eight.  They look valuable.";
    }
    verIoTakeOut(actor) = {}
    verDoTakeOut(actor,io) = {if (io = self) "%You%'d better leave the
    coins in the bag.  "; else pass verDoTakeOut;}
;

helmet: CCR_treasure_item, clothingItem, protect_ring
    /* This object has special properties only in the 550-point game. */
    /* N.B. this object isn't wearable in the 660-point version. */
    game550 = true
    sdesc = "gem-encrusted visorless helmet"
    ldesc = "It is encrusted with precious jewels!"
    location = Morion
    noun = 'helm' 'helmet'
    adjective = 'visorless' 'gem' 'encrusted' 'gem-encrusted'
    protection = {
        if(global.game701) return 0; else return 3;
    }
;

sceptre: CCR_treasure_item
    game550 = true
    sdesc = "sapphire sceptre"
    ldesc = "It's a long sceptre, ornately
             encrusted with sapphires!"
    location = Skeleton
    noun = 'sceptre' 'scepter'
    adjective = 'sapphire' 'long' 'ornate'
            'sapphire-encrusted' 'encrusted'
    passwordtold = nil  // Has the skeleton told the player the password?
    doTake(actor) = {   /* This should call the usual take
                        * method, then give the vault keyword.
                        * (if it hasn't already been given) */
        local i;
        inherited.doTake(actor);

        //
        // If we didn't get the sceptre (e.g., if the
        // actor's carrying too much), don't do anything
        // else.
        //
        if (not self.isIn(actor))
            return;
        else Skeleton.moveInto(nil);
        // This will happen every time the sceptre is
        // picked up, but this is harmless.

        if(not self.passwordtold and In_Safe.is_fused) {
            "As you pluck the sceptre from the
            skeleton's grasp, it raises its head
            and whispers, \"You blew it!\".  It
            then shivers and collapses into a pile
            of fine dust which quickly vanishes.";

            self.passwordtold:=true;
        }
        else if(not self.passwordtold) {
            // First determine the keyword.
            In_Safe.password := rand(5);

            "You pluck the sceptre from the skeleton's
            bony hand.  As you do, the skeleton raises
            its head and whispers \"Remember - ";

            // Now print the word, using its sdesc:
            for (i := firstobj(VaultKeyVerb); i;
                i := nextobj(i, VaultKeyVerb))
                if(i.wordnum = In_Safe.password) i.sdesc;

            // Done. Now print the rest of the text.
            "!\" in a forboding tone; it then sags to the
            ground and crumbles into dust which drifts
            away into the still air of the cave."; P();
            self.passwordtold:=true;
        }
    }
    doPurloin(actor) = {
            if (not self.passwordtold) self.doTake(actor);
            else pass doPurloin;
    }
;

yacht: CCR_treasure_item, initmess
    game550 = true
    sdesc = "ruby-covered toy yacht"
    ldesc = "It is a small toy yacht totally covered
             with rubies, and has the words \"Omar Khayyam\"
             engraved on the side!"
    location = Nondescript
    initdesc = "There is a small toy yacht sitting on the floor. It is
                totally covered with rubies, and has the words
                \"Omar Khayyam\" engraved on the side!! "
    noun = 'yacht' 'rubaiyat'
    adjective = 'ruby' 'toy' 'ruby-covered' 'covered'
                    'encrusted' 'ruby-encrusted' 'omar'
                    'khayyam' 'khayyam\'s'
    verDoRide(actor) = { "It's only a toy yacht, you fool! "; }
    verDoLaunch(actor) = { "I wouldn't advise it - the yacht is far too
        valuable. ";}
    verDoRow(actor) = {self.verDoRide(actor); }
    verDoEnter(actor) = {self.verDoRide(actor); }
    verDoBoard(actor) = {self.verDoRide(actor); }
;

beads: CCR_treasure_item, clothingItem, initmess
    game550 = true
    sdesc = "ancient Indian turquoise beads"
    adesc = { self.sdesc; }
    isThem = true
    initdesc = "There is a string of ancient Indian turquoise beads draped
                casually over the edge of the balcony! "
    ldesc = "The turquoise beads complement each other beautifully!"
    location = Balcony
    noun = 'beads' 'string' 'turquoise'
    adjective = 'string' 'bead' 'ancient' 'indian'
                    'turquoise'
;

mithril_ring: CCR_treasure_item, clothingItem, protect_ring
    game550 = true
    protection = 3
    sdesc = "mithril ring"
    ldesc = "It's a shiny ring crafted of the finest mithril."
    location = nil  // appears from sword
    noun = 'ring'
    adjective = 'shiny' 'mithril'
    plural = 'rings'
;

spyglass: CCR_treasure_item
    game550 = true
    sdesc = "scrimshaw spyglass"
    // Part of the ldesc has been borrowed from the 660-point game.
    ldesc = "It's small spyglass carved out of whale baleen.  It's a valuable 
        trifle, but it has no utilitarian value.  You certainly can't see
        much through it. "
    location = In_Jonah
    noun = 'spyglass' 'glass'
    adjective = 'scrimshaw' 'baleen' 'whale'
    // In case someone doesn't notice the sdesc.
    verDoLookthru(actor) = {
        "You see a very small, blurred image through the spyglass.  Unlike
        some treasures, it's valuable but not useful. ";
    }
;

sculpture: CCR_treasure_item, condlisted
    game550 = true
    sdesc = "rock-crystal sculpture"
    ldesc = { "It is a finely-carved sculpture of ";
        self.animdesc;  // print a random animal name.
        ", made of rock crystal!";
    }
    location = Sculpt_Niche
    noun = 'sculpture' 'pig' 'eel' 'emu' 'elf' 'mouse' 'rabbit'
            'ibex' 'frog' 'tiger' 'mule' 'moose'
    adjective = 'pig' 'eel' 'emu' 'elf' 'mouse' 'rabbit' 'ibex'
                    'frog' 'tiger' 'mule' 'moose' 'crystal' 'crystalline'
                    'rock' 'rock-crystal' 'carved' 'finely'
                    'finely-carved'
    animdesc = {
        switch(rand(11)) {
            case 1: "a pig"; break;
            case 2: "an eel"; break;
            case 3: "an emu"; break;
            case 4: "an elf"; break;
            case 5: "a mouse"; break;
            case 6: "a rabbit"; break;
            case 7: "an ibex"; break;
            case 8: "a frog"; break;
            case 9: "a tiger"; break;
            case 10: "a mule"; break;
            case 11: "a moose"; break;
        }
    }
    heredesc = {
        P(); I();
        "There is a finely carved sculpture of "; self.animdesc;
        " here! ";
    }
;

bracelet: CCR_treasure_item, clothingItem
    game550 = true
    sdesc = "jade bracelet"
    ldesc = "An ancient Chinese jade bracelet!"
    location = Translucent
    noun = 'bracelet' 'jade'
    adjective = 'jade' 'chinese' 'ancient'
;

casket: CCR_treasure_item
    game550 = true
    sdesc = "casket of opals"
    ldesc = "The casket is full of rare black opals!"
    location = Crack_4
    noun = 'opals' 'opal' 'casket'
    adjective = 'casket' 'opal' 'opals' 'black' 'rare'
;
