/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the creditsVerb in this
 * file for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 * Contributors
 *
 *      dmb     In real life:   David M. Baggett
 *              Internet:       <dmb@ai.mit.edu>
 *
 *      djp     In real life:   David J. Picton
 *              Internet:       djpicton@gmail.com
 *
 *      bjs     In real life:   Bennett J. Standeven
 *              Internet:       berry@pop.networkusa.net
 *                           or bjstande@artsci.wustl.edu
 *
 * Bug reports and other feedback
 *
 * Bug reports should be made to the current code maintainer, David Picton.
 *
 * Please note that (unlike *some* authors) we welcome ALL feedback on the 
 * game, including suggestions for improvements or extensions.
 *
 * The following people are also thanked for the provision of bug reports:
 *      C. Turnbull: bugs in CLOSE CAGE code and CREDITS command
 *      C. Rawson:   detailed bug reports (SCORE command output, bugs in
 *                   TAKE ALL, pirate continued to carry chest after he'd
 *                   hidden it, spelling issues, problem with crystal ball
 *                   implementation) plus many helpful comments.
 *      Bennett Standeven: bug in 701-point (telephone started ringing
 *                   in endgame)
 *                     
 *
 * Modification History
 *
 * CCR
 * ---
 *
 * 1-Jan-93     dmb     rec.arts.int-fiction BETA release (source only)
 *                      For beta testing only -- not for general
 *                      distribution.
 *
 * 20-Apr-93    dmb     Version 1.0 release.
 *
 *  9-Jul-93    dmb     Widespread version 1.0 release for all supported
 *                      machines.
 *
 * 29-Apr-96    djp     Supplied some suggested enhancements/bugfixes
 *                      to dmb.  These were incorporated in Version 2.0G,
 *                      (now available in compiled form only under
 *                      ftp://ftp.gmd.de/if-archive/games/adventions)
 *
 * AD551
 * -----
 *
 * 24-Mar-99    djp     Preview version (1.0)
 *                      * added 551-point mode.
 *
 * 14-Apr-99    djp     Initial release of Adventure 551 (1.01)
 *                      with minor fixes
 *
 * 23-Aug-99    djp     New release (1.10) of Adventure 551.
 *                      Main Changes:
 *                      * Minor fixes and enhancements
 *                      * Drinking of wine implemented
 *                      * Prompt issued at exit
 *
 * 30-Apr-99    djp     New release (1.11) of Adventure 551.
 *                      Main Changes:
 *                      * Various minor fixes e.g. to wave and throw verbs,
 *                        output from credits command, introductory text etc.
 *                      * Fixed bug in 'throw x at hive' where x <> flowers
 *                      * Fixed bug in 'close cage'.
 *                      * Cleaned up the coding for crossing the
 *                        rickety bridge.
 *
 * 17-May-99    djp     New release (1.20)
 *                      Main Changes:
 *                      * Minor fixes (e.g. to 'wear crown' giving messages
 *                        in the wrong order)
 *                      * The treasure scoring code is now more efficient.
 *                      * The handling of most 'floating' items has been
 *                        made more efficient by introducing them into
 *                        contents lists and handling them like normal
 *                        objects.
 *                      * Reduced the number of dwarves (by popular request.)
 *                        The dwarf code does need more work to make it more
 *                        like the original.
 *                      * Fixed SCORE to correctly indicate the number of
 *                        points to the next category.
 *                      * Fixed 'take all' not to take from the pantry when
 *                        the player is in the building.
 *                      * Fixed doDefault for takeVerb to prevent
 *                        'take all from container' when the container is
 *                        closed.
 *                      * Fixed the crystal ball code to work more like
 *                        the original version (it only worked in dark rooms,
 *                        which was unduly restrictive.  Now it works in all
 *                        indoor locations, including all rooms in the cave.)
 *                      * Fixed bugs involving the safe combination: READ
 *                        INSCRIPTION now gives the correct combination, and
 *                        the combination is restored correctly after you
 *                        sit on the throne.
 *                      * Changed the travel methods in several places so
 *                        that 'crawling around in little holes' is avoided
 *                        once the desired room has been found.  (This does
 *                        not yet work in Bedquilt.)
 *
 * 20-May-99    djp     New release (1.21)
 *                      Main changes:
 *                      * Some adjectives removed due to a change in the
 *                        TADS 2.4.0 parser, which fixes a bug preventing
 *                        the use of an adjective as a noun when another
 *                        object uses the same word as a noun.  This is
 *                        now permitted, making it necessary to exercise more
 *                        caution in the use of adjectives.  For example, the
 *                        crystal bridge defined 'rod' as an adjective; this
 *                        meant that 'wave rod' would refer to the crystal
 *                        bridge if the rod wasn't present.
 *
 * 15-Jul-99    djp     New release (2.00)
 *                      Main changes:
 *                      Minor bugfixes (e.g. allow bird to be put in pantry,
 *                      removed a few more adjectives which caused confusion
 *                      under TADS 2.4.0, corrected some wrongly capitalized
 *                      verDoEnter and doEnter methods)
 *                      Game design changes:
 *                      * Dwarves start later in the game.  (They can
 *                        start each time the player enters a 'far in' room,
 *                        except for the first 'global.NPCwaitmoves' times.
 *                        Thereafter, entering any 'far in' room starts the
 *                        dwarves and pirate with
 *                        a probability of global.NPCprob. )
 *                      * Protection from the dwarves knives has now been
 *                        reworked with the introduction of two new Rings of
 *                        Protection.  (2 base-metal rings or 1 gold ring will
 *                        provide protection if worn.  If all 3 rings are
 *                        worn, the dwarves are hoist with their own petard.)
 *                        A message is now always issued to indicate the
 *                        effect of the Rings.
 *                      * Reworked the cracks at the east end of the Long Hall.
 *                        There are now three, but the middle one must be
 *                        entered explicitly.
 *                      * The new middle crack now leads up a stairway to
 *                        a series of new rooms - which may be added to
 *                        in later versions.
 *                      * Similarly there are now three pits in the Room with
 *                        Small Pits.  Two of them contain a ring; the third
 *                        is empty but with suspicious-looking footprints.
 *                      * The limestone pinnacle puzzle has been changed so
 *                        that the player is allowed to go down only if no
 *                        bulky items are carried.
 *
 *                      Possible future extensions:
 *
 *                      * The octagonal room may have more exits in a later
 *                        version.
 *
 *                      * Spying on the Outer Courtyard now reveals that
 *                        the elves use a magic word in conjunction with a
 *                        bracelet.  There isn't one yet, but it may show up
 *                        in a future version ...
 *
 * 3-Aug-99     djp     Bugfix release - Version 2.01
 *                        Changes in this version
 *                      * Minor bugfixes (including a fix to the canister),
 *                        and addition to scenery objects.
 *
 *              djp     Bugfix release - Version 2.02 (not publicly released)
 *                      * Minor bugfixes.
 *
 * 9-Nov-99     djp     New release - Version 2.10
 *                        Main changes:
 *                      * Incorporated the generalized version handling code
 *                        from Bennett Standeven's pre-release Polyadv game.
 *                        Split up ccr-npc.t and ccr-item.t into separate
 *                        files for different game versions.
 *
 * 17-Feb-00    djp     New release - Version 2.20
 *                        Changes in this version
 *                        Source files 'untabified' to avoid problems with
 *                        incompatible tab settings on different platforms
 *                      * Filename numbering changed to correspond with
 *                        vnumber settings e.g. ccr-itm1.t for vnumber=1
 *                      * Further generalization of version handling
 *                      * Minor bugfixes
 * POLYADV
 * =======
 *
 * 24-Aug-99    bjs     Initial pre-release version of Polyadventure. 
 *              bjs     * Added 550-point mode
 *              bjs     * split up NPC and item files into three.
 *
 *          djp+bjs     Incorporated ad551 mods up to 2.20
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *              djp     * NPC code tidied up with methods now coded in
 *                        a consistent order.  Various fixes to NPC
 *                        interaction methods.
 *                      * Handling of floatingdecoration amended to remove
 *                        deleted objects.  Bugfixes to broken code for
 *                        version-dependent loclists.  Floatingdecoration
 *                        location method changed to return the first value
 *                        when the player isn't in any of the rooms.
 *                      * Various other bugfixes and enhancements as listed
 *                        in individual files, including an optional argument
 *                        to incscore allowing the reason to be given.
 *
 *  4-Apr-00    djp     Version 1.01: bugfix release
 *                      Changes in this version:
 *                      * The indentation of the source lines has been made
 *                        more consistent.
 *                      * Consistent implementation of isThem property for
 *                        plural objects.
 *                      * nestedroom class standardized to statusPrep and
 *                        outOfPrep instead of onword and offword.
 *                      * reorganized nestedroom classes (e.g. chairitem is
 *                        now a subclass of portable_chairitem)
 *                      * Added a the capability to wave things 'at' an
 *                        indirect object.  Used with rod (where the
 *                        indirect object must be relevant to the magic being
 *                        worked) or with weapons, indicating hand-to-hand
 *                        combat.  Except in the 350-point game, a command
 *                        like 'wave axe' now finds a default enemy, or
 *                        prompts for one if necessary.
 *                      * Changed most distantItem-like objects (i.e. ones
 *                        with dobjGen/iobjGen or dobjCheck/iobjCheck) to
 *                        allow them to be an indirect object for the ask, tell
 *                        and wave verbs.
 *                      * Made more verbs usable in the dark.
 *                      * Minor bugfixes as listed in individual files.
 *
 *  4-May-00    djp     Version 1.02: bugfix release
 *                      Changes in this version:
 *                      * Fixed the ldesc of the Hall of Mists to mention
 *                        the crack (in the 550-point game).   Added a crack
 *                        object.
 *                      * Missing sdesc added for bees
 *                      * Corrected the ldesc for the scrap of paper
 *                      * Made the mushrooms re-grow after the dog has
 *                        eaten them (551-point game)
 *
 * 15-May-00    djp     Version 1.03: bugfix release
 *                      * Fixed the vial code to destroy the vial in all
 *                        appropriate cases.
 *                      * Minor fixes to bird code and code to put birdcage
 *                        in containers (in case we are handling 'cloned'
 *                        cages)
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *                      Changes in this version:
 *                      * Addition of 701-point mode (combination of 
 *                        550- and 551-point modes)
 *                      * Various minor bugfixes and enhancements as 
 *                        described in individual files.
 *
 * 25-Sep-00    djp     Version 2.01: bugfix release
 *                      Changes in this version:
 *                      * Bugfixes to "go up" command (when used with an
 *                        object) and to hole objects in the two-pit room.
 *
 * 20-Dec-00    djp     Version 2.02: bugfix release
 *                      Changes in this version:
 *                      * Fixes to travel methods in north-of-reservoir
 *                        area.
 *                      * Enhancement to gong (can now be hit with an object)
 *                      * Added a 'dust' scenery object in the Dusty Rocks
 *                        room.
 *                      * Fixed a bug which caused the telephone to ring
 *                        in the 701-point endgame.
 *
 * 8-Feb-01     djp     Version 2.03: bugfix release
 *                      Changes in this version:
 *                      * Fixed various dust objects to give sensible responses
 *                        when swept.
 *
 * 15-May-01    djp     Version 2.04: bugfix release
 *                      Changes in this version:
 *                      * Fixed various bugs affecting the vial.
 *
 * 8-Jun-01     djp     Version 2.05: bugfix release
 *                      Changes in this version
 *                      * Various minor fixes as detailed in individual files.
 *                      * Fixed various problems with liquidcont items.
 *                      * Fixed a TADS crash when multiple rods were present
 *                        in the endgame (due to a faulty pluraldesc method)
 *
 * 17-Aug-01    djp     Version 2.06: bugfix release with e-mail address update
 *                      Changes in this version
 *                      * Updated e-mail addresses.
 *                      * Replaced listlist function to fix problems with
 *                        multiple indistinguishable items.
 *                      * Added missing sdesc to 'click' verb, implemented
 *                        CLICK SLIPPERS
 *                      * Fixed bug in 701-point endgame which left the
 *                        treasures in the safe.  Fixed bugs associated with
 *                        unlocking entrances with keys.  (In 701-point
 *                        endgame all the keys are now placed in the pantry,
 *                        permitting the player to try out all means of entry
 *                        to the cave.)    
 *                      * Other minor fixes detailed in individual files
 *
 * 22-Aug-01    djp     Version 2.07: bugfix release
 *                      Changes in this version
 *                      * In order to circumvent a TADS bug (affecting 
 *                        versions up to 2.5.5), certain objects in ccr-rm1.t
 *                        now define their own location instead of inheriting
 *                        it.  (See comments in ccr-rm1.t for more details.)
 *                        
 * 22-Nov-01    djp     Version 2.08: bugfix release
 *                      Changes in this version
 *                      * Implemented new 'leave' verb. 'Leave here' is
 *                        a synonym for 'drop', but 'leave' now means 'get
 *                        out of' or 'drop' as appropriate. (Special handling
 *                        is needed for the bear because it isn't carried).
 *                      * For consistency, the QUIT command now informs the
 *                        player about the deducted points.
 *                      * Improved the pentagram code (the player may stand
 *                        on the pentagram.  Objects can't be removed or
 *                        put into the pentagram while the barrier is up.)
 *                      * Other minor fixes detailed in individual files.
 *
 * 13-Jan-03    djp     Version 2.09 rev C: bugfixes and code tidy-up
 *                      Changes in this version
 *                      * Coding rationalization:
 *                        o Use of a standard library file (adv.t) from
 *                          the latest official TADS 2 distribution. 
 *
 *                        o Reorganization of code:  
 *
 *                         * A new file (advmods.t) contains most of the 
 *                           modifications to standard adv.t library objects, 
 *                           plus a few new objects (e.g. sweepVerb) which are 
 *                           closely associated with existing library objects. 
 *                           Modifications to class "thing" are included in
 *                           this file only when they replace existing adv.t
 *                           properties and methods, or provide code for verbs
 *                           defined in adv.t and advmods.t.
 * 
 *                         * The verb file (ccr-verb.t) defines all other new
 *                           verbs and their associated verification or 
 *                           action methods in specific objects and classes.
 * 
 *                         * The "thing" class extension file (ccr-thx.t) 
 *                           adds new methods to class "thing", including
 *                           default code for verbs defined in ccr-verb.t
 *
 *                         * The function file (ccr-fun.t) contains most
 *                           new functions.
 *
 *                        o Standardization of classes.  Lit rooms now have
 *                          class room and dark rooms have class darkroom.
 *                          Ordinary items have class item, and fixed items
 *                          have class fixeditem.  The classes CCR_item, 
 *                          CCR_room and lightroom have been eliminated.
 *
 *                        o In preparation for a new version with an
 *                          extended "701+" point mode, there are now files
 *                          for version 11 (ccr-it11.t, ccr-rm11.t, ccr-np11.t)
 *                          At present, these contain portable items and rooms
 *                          which have been added to the original 550- and/or
 *                          551 games (the scrap of paper, the base-metal 
 *                          rings, and the Octagonal Room area.)
 *
 *                      * Following a recent r.a.i.f post, fixed 'X ME' to
 *                        give the DIAGNOSE output when appropriate.
 *                      * Code cleanup to remove instances of object
 *                        properties being set in verification methods.
 *                      * Circumvention of a bug affecting dynamic object
 *                        creation (see ccr-endg.t).
 *                      * New optional argument added to Me.travelTo to allow
 *                        travel between inside and outside of cave after
 *                        closure.  Cylindrical Room and 'gonear' code changed
 *                        to take advantage of the new feature.
 *                      * New DEFVER define to allow test compilations with
 *                        a different default game version.
 *                      * New WIZARD define to allow non-debug compilations
 *                        with wizard-mode commands enabled.
 *                      * Changes to reachability code.  Additional checks
 *                        are made in certain rooms (e.g. that an object was
 *                        dropped on the correct side of the dragon).  Checks
 *                        for reachability of objects are now made in the
 *                        verbAction method.
 *                      * Added an InternalRoom class for objects like the
 *                        telephone booths and walk-in safe.
 *                      * Handling of 'search' and 'look in' has been changed
 *                        to work with the grain of current adv.t practice,
 *                        reducing the risk of an infinite loop with (say)
 *                        doSearch callinig doLookin and doLookin looping back
 *                        to doSearch. In particular:
 *                        o We make verDoSearch refer to verDoLookin
 *                        o When doSearch and doLookin are equivalent, we
 *                        define doSearch and make doLookin refer to doSearch.
 *                      * A separate 'look on' verb has been defined for
 *                        surfaces.
 *                      * Made provision for location methods to depend on 
 *                        an actor other than the player.
 *                      * Reworked the doorway code (grate, elfin door,
 *                        rusty door).
 *                      * Enhancements to the travelTo method with new
 *                        optional arguments.  The second argument is
 *                        a property pointer, e.g:
 *
 *                        actor.travelTo(actor.location,&out);
 * 
 *                        This has a major advantage - the travelTo method
 *                        can now set global variables before the 'out'
 *                        property is evaluated.  
 *
 *                      * Global variables are now set to facilitate retrieval
 *                        of information about the current actor, and a
 *                        convenient function (getActor) is provided for this
 *                        purpose. See comments in ccr-fun.t and advmods.t 
 *                        for more details.
 *
 *                      * Minor bugfixes as detailed in individual files.
 *
 *                      * Bugfix for rev A: going down from the Ledge Above
 *                        Pinnacles caused an infinite loop.
 *
 *                      * Bugfix for rev B: removed 'set' as an adjective for
 *                        the batteries to circumvent a parser problem with
 *                        'set of keys'
 *
 *                      * Bugfix for rev C: corrected Globlins.ActorAction to
 *                        actorAction.
 *
 * 31-May-03    djp     Version 2.10: minor bugfixes and enhancements
 *                      * Corrected some wrong messages 
 *                        when keys are added/removed from the keyring.
 *                        Corrected vocab for the elfin crown.
 *                        Corrected vscheme.txt (thanks to Mike Arnautov 
 *                        for pointing out the errors.)
 *                        Modified doorway, lockable and keyItem classes to 
 *                        allow OPEN <lockable item> WITH KEYS
 *
 * 12-Aug-03    bjs     Version 2.11: Added 580-point version, and introduced
 *                      security alert system, and flight code for rug.
 *
 * 23-Aug-03    djp     Version 2:12: Cleaned up bugs (dwarf attack code
 *                      error in 580-point mode, elevator did not lock,
 *                      other minor problems).  Added enhancements (e.g.
 *                      verbs to fly rug, like those for poling the boat).
 *                      Updated some code to facilitate integration into
 *                      version 3.  (New moveme method for moving a
 *                      vehicle, modified chairitem defaults to facilitate
 *                      use of the rug as a vehicle.)
 *
 * 26-Aug-03    djp     Version 2.12 rev A: removed an inappropriate statement
 *                      about searching the dead Wumpus.  (This will be
 *                      implemented in the forthcoming 701+ point mode).
 *
 * 8-Oct-03     djp     Version 2.12 rev B: Fixed a bug which prevented
 *                      interaction with the dragon and other fixed items
 *                      when entry was from the north.
 *
 * 6-May-04     djp     Version 2.12 rev C: Changed the location method for
 *                      theFloor (advmods.t) to avoid a stack overflow bug.
 *                      Now the floor location is determined by sitloc when
 *                      the player character is located there, regardless of
 *                      the current actor.  Also the Dwarves code has been
 *                      fixed to change global.currentActor after the 
 *                      evaluation of melocs, not before.
 *
 * 10-May-04    djp     Version 2.12 rev D (not released): Defined missing 
 *                      createloc property for endgame_liquidcont class 
 *                      (bottle pile wasn't stocked)
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *                      Numerous small changes have been made to existing
 *                      code, mainly to accommodate the new game mode. For
 *                      example, every room now has an analevel property
 *                      indicating its Transindection coordinate, and there
 *                      are new methods for transporting the player in a 
 *                      vehicle(vehicleTravel) or for moving the player and
 *                      room contents to another room (roomMoveTravel).
 *                      During the "on-rails" Wumpi chase scene the player 
 *                      actorAction method calls Wumpi.actorAction to vet 
 *                      player actions and move the player on. 
 *
 *                      Minor bugfixes and changes include:
 *                      * In 'oldgame' versions (350, 550, 580 points) the 
 *                      chest could be opened but had no room, even for tiny 
 *                      objects.  This is clearly unrealistic, so the mykey 
 *                      setting has been changed to prevent the chest from 
 *                      being unlocked.
 *                      * If the player gets killed due to attempting to go
 *                        down the pit with the gold, his possessions are 
 *                        dropped in Hall_Of_Mists.  (see ccr-room.t)
 *                      * Various improvements to the 580-point game 
 *                        (implementation of PULL X WITH Y for suction cups,
 *                        allow player to refer to "panels" in computer room.)
 *                      * Efficiency improvements in Catacombs enterroom and
 *                        leaveroom methods.
 *                      * New ways to use the rod (SPAN ROD OVER FISSURE for 
 *                        the wrong meaning of the scrawled note, and
 *                        SPIN ROD, SPIN ROD OVER FISSURE for the right one.)
 *                      * Changed the crystal ball code to show the top-level
 *                        location when appropriate.
 *                
 * 15-Jan-05    djp     Version 3.01: bugfix release.
 *                      * Minor corrections, mainly to text.  See comments in 
 *                        ccr-endg.t, ccr-room.t, ccr-rm11.t, ccr-it11.t
 * 17-Jan-05    djp     Version 3.01 Rev. A.
 *                      * Fixed kata properties for two Green-level rooms in
 *                        the Zarkalon tower.
 * 17-Jan-05    djp     Version 3.01 Rev. B.
 *                      * In ccr-np11.t, corrected the action check code to
 *                        disallow \"Kata\" from the East-level Large 
 *                        Circular Room when 10 Wumpi are left.
 *
 * 12-Apr-05    djp     Version 3.10: Bugfixes and enhancements
 *                      * Now linked with the latest version of adv.t
 *                        (TADS version 2.5.9)
 *                      * After sitting on the throne without a crown, allow
 *                        alternate game options (e.g. enter the door at the 
 *                        top of the blocks if the Orange Office has been 
 *                        viewed)
 *                      * Various bugfixes as detailed in individual files.
 * 7-May-05     djp     Version 3.10 Rev. A
 *                      * Fixed a nasty bug which made the game unwinnable
 *                        after an attempt to unlock the steel door with the
 *                        wrong key.
 *                      * Changed the battery insertion code to allow each set
 *                        batteries to be recharged once.
 *                      * Minor corrections, mainly cosmetic changes to
 *                        description messages. 
 * 16-May-05    djp     Version 3.10 Rev. B   
 *                      * Fixed a bug which prevented the use of "Kata"
 *                        when the Wumpi were no longer wearing rings 
 *                        (phase=5).
 *                      * Minor cosmetic changes.
 * 26-May-05    djp     Version 3.10 Rev. C
 *                      * Minor cosmetic fixes.
 *                      * Corrected the location property for the pits in the
 *                        featureless pits room.
 *                      * Fixed various problems with the blueberry code.
 *                      * Changed the specialrestart routine to use 
 *                        moveInto when restoring location properties.
 *
 * 28-Jun-05    djp     Version 3.11: Enhancements and bugfixes
 *                      * Addition of an (optional) extra treasure, available
 *                        if the Green-level door to the small room in the
 *                        Zarkalon Tower is opened.
 *                      * Minor fixes, mainly cosmetic.
 *
 * 9-Aug-05     djp     Version 3.12: Enhancements and bugfixes
 *                      * Fixed a nasty bug which prevented the iron key from 
 *                        appearing after a 'throne mishap' (sitting without
 *                        a crown).
 *                      * Cleaned up the history record in each file.  Versions
 *                        are normally listed only if changes were made to the 
 *                        file in question (or significant extensions added to
 *                        the game).
 *                      * Defined a new function Wumpi.nodeath() to determine
 *                        whether deaths are to be prevented and the lamp 
 *                        lifetime frozen.
 *                      * Minor cosmetic fixes.
 *
 * 15-Aug-05    djp     Version 3.12 Rev. A
 *                      * Corrected the code for 'detach key from keyring'.
 *
 * 16-Jul-06    djp     Version 3.20: Bugfixes and extensions
 *                      * Corrected the email addresses for D.J. Picton
 *                      * Various bugfixes as detailed in individual files.
 *                      * Modifications to the code for drinking wine.  This
 *                        is banned in certain areas, e.g. to prevent the 
 *                        player using it as a means to escape from the Wumpi,
 *                        or to bypass the troll. Room properties are now
 *                        defined (e.g. sober=true for a general prohibition
 *                        on drinking, wino_trollstop if the drunken player
 *                        would need to get past the troll.  For this purpose
 *                        it is assumed that the player will lose most
 *                        objects (except the lamp, axe, clover and any 
 *                        Transindection pendants which are being worn) and 
 *                        will not be capable of using the boat.)
 *                      * Extensions to the 701+ point game with a new area
 *                        at White level (around the Octagonal Room), a new
 *                        multicolored rod, and new 'plaque rooms' (where rods
 *                        can be spun to transport the player instantly). 
 *
 * 12-Nov-06    djp     Version 3.20 Rev. A - minor corrections/enhancements
 *                      * Pressing white button in lower transindection room 
 *                        now reveals two 'ghostly' plaques
 *                      * Corrections to exit methods from upper plaque rooms
 *                      * Once opened, passages to upper plaque rooms remain 
 *                        open (to avoid unfairly trapping the player) 
 *                      * Implementation of a missing feature: the Multicolored
 *                        Rod can be rubbed to change its Transindection level.
 *                        (This permits the player to enter Blue level without 
 *                        a gold pendant.  Note that a rubbed ceramic pendant
 *                        must be worn.)
 *
 * 3-Mar-07     djp     Version 3.20 Rev. B - minor bugfixes
 *                      * Corrected the Kata destination for
 *                        White_Upper_Trans_Room
 *                      * Fixed a TADS crash when the display case was
 *                        attacked.
 *                      * Other minor cosmetic fixes.
 *
 * 20-Oct-07    djp     Version 3.20 Rev. C
 *                      * Fixed a bug which prevented rods from being
 *                        explicitly taken from a container (e.g. take rod
 *                        from sack) 
 *                      * New code added for putting a spinning rod on the
 *                        Green-level bridge or throwing objects at the
 *                        Zarkalon tunnel.  The tunnel is now implemented
 *                        as an Internal_Room object (i.e. it looks like a
 *                        container from the outside).  If the gold ring is
 *                        worn, the player is transported along with the
 *                        rod. 
 *                      * Various minor bugfixes, documented in individual
 *                        source files.
 *
 * 17-Apr-09    djp     Version 3.20 Rev. D
 *                      * Various corrections to room descriptions and
 *                        directions and other minor bug fixes, as 
 *                        documented in individual files.  The principal
 *                        changes are listed below:
 *                      * ccr-endg.t: some rework to coding in functions
 *                        cancel_cave_closure and check_for_closure; points
 *                        for finding all the treasures are not rescinded when
 *                        the cave closure is postponed
 *                      * ccr-np11.t: if the player is at Top_of_Blocks and can
 *                        see the door, he will go through the door when 
 *                        the Wumpi approach.
 *                      * ccr-rm11.t: various corrections to room descriptions 
 *                        and directions
 *
 * 4-Nov-09     djp     Version 3.20 Rev. D
 *                      * Fix to bug in ccr-np11.t (due to missing code): the
 *                        player could get stuck in Green_Large_Circular_Room
 *                        when the Wumpi approached.
 * 
 *
 * 21-Nov-10    djp     Version 3.21 - enhancements and minor bugfixes
 *                      * Minor textual and vocab changes are documented in 
 *                      * individual files
 *                      *
 *                      * Bug fixes:
 *                      * In advmods.t prevent keys from being taken if they
 *                        are attached to the keyring
 *                      * In ccr-it11.t allow READ CHAPTERS
 *                      * In ccr-item.t allow PHLEECE while on the rug
 *                      * In ccr-npc.t stop the pirate from stealing the 
 *                        pendants or mithril ring if they may be needed to
 *                        reach the keys
 *                      * ccr-rm11.t changed the allowable directions from
 *                        the desk in the Orange Level Office
 *                      * ccr-rm2.t In_Safe sets the wino_wsbridge property
 *                        if entered from the far side of the stone bridge
 *                      * put the Wumpi back to bed if the player dies during
 *                        the chase (unless they are asleep at Blue level)
 *                      *
 *                      * Enhancements:
 *                      * New properties ana.extradot and kata.extradot allow
 *                        rooms with the 'dotroom' property to define extra
 *                        Transindection destinations which aren't available
 *                        with pendants.  
 *                      * New code added to take posture into account when
 *                        sitting, lying or standing on a rug or desk
 *                      * New code for object 'controls' in the control room.
 *                        If switches are operated in the right order, the
 *                        Upper Transindection Rooms are extended to White 
 *                        level and the Control Room and Blue-level steel cage
 *                        allow transindection without working pendants
 *                      * A clue to the operation of the switches is given if
 *                        the player stands on the desk and reads the plans
 *
 * 22-Oct-13         djp  Version 3.21a - bugfix release
 *                      * Various minor corrections, mainly to messages and
 *                        vocabulary
 *                      * Correction to Green_NE_Corner (nested room used in
 *                        701+ game) - exit properties lead out to Green level
 *                        instead of Red.
 */

