/* Hey emacs, this file is in -*- Fundamental -*- mode */

/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"

object *objects;

#define ROOM(this,n,s,w,e,u,d,nw,ne,sw,se,contents,luminous,long,short,cite) \
{0,0,contents,this + 1,this - 1,n,s,w,e,nw,ne,sw,se,u,d,long,short,cite,{1,0,0,luminous,1,1,0,1}},

#define OBJECT(this,above,below,inside,next,parent,opaque,luminous,container,examine,longname,shortname) \
{above,below,inside,next,parent,0,0,0,0,0,0,0,0,0,0,examine,longname,shortname,{0,0,0,luminous,opaque,0,0,container}},

#define VIRTUAL(this,above,below,inside,next,parent,container,examine,longname,shortname) \
{above,below,inside,next,parent,0,0,0,0,0,0,0,0,0,0,examine,longname,shortname,{0,0,0,0,0,1,0,container}},

#define PERSON(this,carrying,next,parent,examine,longname,shortname) \
{0,0,carrying,next,parent,0,0,0,0,0,0,0,0,0,0,examine,longname,shortname,{0,0,1,0,0,1,0,1}},

object intobjects [] = {

/* 0 */		{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,"Root object: if you can see this th"
"e game has gone wrong","(root object)","*ROOT",{1,0,0,0,0,0,0,1}},

ROOM(1, 0,2,0,0,0,0,0,0,0,0, 100, 1, "This is the office, at the centre of t"
"he Napoleons' web.  A smart ebony desk sits in one corner, with the sort of "
"office chair behind it that you can twirl round and round on if you get bore"
"d.  Boring carpet tiles adorn the floor, the walls are painted hospital whit"
"e, as is the ceiling which is also equipped with a large fluorescent tube.  "
"There is an exit to the south.","The central office","office")

ROOM(2, 1,6,0,0,0,0,3,4,0,0, 0, 1, "You are in a small, rickety wooden room;"
" the walls are made of rough timber, and every footstep makes the boards cre"
"ak.  To the northwest and northeast, winding corridors lead off, with only t"
"he wooden boards suspending you above... who knows what?  To the north you c"
"an walk into the office, while to the south a doorway leads into absolute bl"
"ackness.","Wooden room 1","*")

ROOM(3, 0,0,55,0,0,0,0,5,0,2, 0, 1, "You are at a bend in a rickety wooden c"
"orridor; it is possible to walk along it to the southeast and northeast.  In"
" addition there is a hole in the western wall, but through it there is only "
"pitch darkness.  Every step makes the old, rough boards under your feet crea"
"k with the strain.","Wooden room 2","*")

ROOM(4, 0,0,0,20,0,0,5,0,2,0, 0, 1, "You are at a bend in a rickety wooden c"
"orridor; it is possible to walk along it to the southwest and northwest.  In"
" addition there is a hole in the eastern wall, but through it there is only "
"pitch darkness.  Every step makes the old, rough boards under your feet crea"
"k with the strain.","Wooden room 3","*")

ROOM(5, 56,0,0,0,0,0,0,0,3,4, 0, 1, "You have come to a small wooden chamber"
" to the north of the Napoleons' office.  Corridors lead southwest and southe"
"ast; there is also a small hole leading north.  It is completely dark throug"
"h the hole and you can see nothing.  Here the flooring seems more broken dow"
"n than ever, giving a real fear that it might collapse.","Wooden room 4","*")

ROOM(6, 0,7,0,0,0,0,0,0,0,0, 106, 1, "You are standing in an ornate formal g"
"arden at the front of a large country house.  To your north is the exit from"
" the estate, but the gate is closed.  To your south is a large arched doorwa"
"y leading into the house proper.  A gravel path connects the two.  In the ce"
"ntre of the path is a marble fountain, and the path is edged with strictly t"
"rimmed privet hedging.","Front Garden","garden")

ROOM(7, 6,0,0,8,0,0,0,0,9,0, 0, 1, "You are in the entrance hall of the coun"
"try house.  To your north is an exit into the front garden; to the southwest"
" is an exit into the estate's country park.  To the east is a door labelled "
"'Music Room'.  There are several other locked doors.  This room is 'rather s"
"izeable'; about half way up the wall a balcony runs to which there appears t"
"o be access from the upstairs.  The floor is polished wood and your feet see"
"m to make an awful noise in the ancient quiet.","Entrance Hall","*")

ROOM(8, 0,0,7,0,0,0,0,0,0,0, 108, 1, "This is the music practice room, hopef"
"ully well soundproofed.  A grand piano sits in one corner, with two piano st"
"ools next to it.  In the north wall, sunlight streams in through an old lead"
"ed window, illuminating the scene of generations of children's music lessons"
".  Here the floor is carpeted, perhaps to absorb some of the more abominable"
" noise!  This room is also equipped with its very own piano teacher, current"
"ly sitting on one of the stools.","Music Room","*")

ROOM(9, 0,14,10,0,0,0,0,7,0,0, 119, 1, "You are standing at the back of the "
"country house, looking up at its tall brick walls mellowed by a climbing ros"
"e.  To your south and east lie more fine formal gardens, but the way east is"
" blocked by a hedge.  To the south a path leads to an ornamental pool (with,"
" of course, nothing as untidy as a frog in it).  To your west lie the tennis"
" courts - and they certainly look strange ones!","Back Garden","garden")

ROOM(10, 0,11,13,9,0,0,0,0,12,0, 110, 1, "You are at the northeast corner of"
" the tennis courts.  There appears to be just one court, but there are two n"
"ets crossing it - one going north to south (and positioned just to your west"
") and one going west to east (and positioned just to your south).  You can l"
"eave the court to the east, or you can jump over the net to the south, west,"
" or southwest.","Tennis Court 1","*")

ROOM(11, 10,0,12,0,0,0,13,0,0,0, 111, 1, "You are at the southeast corner of"
" the tennis courts.  There appears to be just one court, but there are two n"
"ets crossing it - one going north to south (and positioned just to your west"
") and one going west to east (and positioned just to your north).  You can j"
"ump over the net to the north, west, or northwest.","Tennis Court 2","*")

ROOM(12, 13,0,0,11,0,0,0,10,0,0, 112, 1, "You are at the southwest corner of"
" the tennis courts.  There appears to be just one court, but there are two n"
"ets crossing it - one going north to south (and positioned just to your east"
") and one going west to east (and positioned just to your north).  You can j"
"ump over the net to the north, east, or northeast.","Tennis Court 3","*")

ROOM(13, 0,12,0,10,0,0,0,0,0,11, 113, 1, "You are at the northwest corner of"
" the tennis courts.  There appears to be just one court, but there are two n"
"ets crossing it - one going north to south (and positioned just to your east"
") and one going west to east (and positioned just to your south).  You can j"
"ump over the net to the south, east, or southeast.","Tennis Court 4","*")

ROOM(14, 9,0,0,0,0,15,0,0,0,0, 0, 1, "You are crouched at the side of an orn"
"amental pool, and no, it doesn't have a frog in it.  The pool is completely "
"surrounded by hedges, apart from to the north, where a narrow path leaves.  "
"This area of the garden has a strange, malevolent air about it, as though ev"
"en the privet is waiting for something evil to happen.","Pool Edge","pool")

ROOM(15, 0,0,0,0,14,0,0,0,0,16, 0, 0, "This damp and foul-smelling room belo"
"nged to the water sprite.  Bits of pondweed and rotting vegetation lie aroun"
"d.  There is always the suspicion of more unpleasant things, and you don't l"
"ook too closely.  You can go up through the empty pool, or you can go southe"
"ast to some sort of cellar.","Water Sprite's Room","*")

ROOM(16, 0,0,0,0,18,0,15,0,0,0, 114, 0, "You are in what looks as though it "
"used to be the wine cellar.  Decayed wooden racks still line the walls, but "
"there are no longer any bottles in evidence.  It looks as though this cellar"
" might not have been used for some time, going by the cobwebs and dust which"
" line every surface.  There is a rickety wooden ladder up, while to the nort"
"hwest lies the water sprite's room.","Wine Cellar","wine_cellar")

ROOM(17, 18,0,0,0,0,0,0,0,0,0, 115, 1, "This is an old walk-in storage cupbo"
"ard; dusty shelves and cupboards still line the walls.  Light streams in thr"
"ough a rusty cast iron window, adorned with more cobwebs.  You can only leav"
"e north, to the Grandmaster's room.","Store Cupboard","cupboard")

ROOM(18, 0,17,0,19,0,16,0,0,0,0, 104, 1, "You are in the noughts and crosses"
" grandmaster's room.  The grandmaster himself is sitting behind an old and d"
"istinctive oak table; in front of him is a small slate, with a noughts and c"
"rosses board drawn on it; beside him is a book entitled 'Noughts and Crosses"
": How to play a Psychological Game'.  Light shines into the room through a s"
"mall window high on one wall.  There is a ladder down into the cellar, or yo"
"u can go south or east.","Grandmaster's Room","*")

ROOM(19, 0,0,18,0,0,0,0,0,0,0, 116, 1, "This was the alchemists' workshop, n"
"ow it looks as though it has become a reasonably modern laboratory.  Neat ye"
"llow-painted cupboards hang on the south wall, while along the west and east"
" wall benches have been placed.  On the west bench a piece of funny looking "
"equipment has been placed.  An exit leads to the noughts and crosses room to"
" the west.","Laboratory","*")

ROOM(20, 0,0,21,0,0,0,0,0,0,0, 0, 1, "You are standing in the reception area"
" of a group of offices.  To the east, a door opens onto the road, but it app"
"ears to be locked at the moment.  To the west you can walk down a corridor l"
"eading further into the building.  This reception area seems slightly shabby"
", as though the people inhabiting the offices are not too prosperous.","Offi"
"ce Entrance","office_entrance")

ROOM(21, 22,23,24,20,0,0,0,0,0,0, 0, 1, "You are part way along a corridor l"
"it starkly from above by fluorescent tubes.  To the north and south are entr"
"ances to individual offices - signs indicate that the north office belongs t"
"o Rusgreve and the south office to Prendergast.  Both appear to be at home. "
" To the west the corridor opens out onto a balcony.","Corridor","corridor")

ROOM(22, 0,21,0,0,0,0,0,0,0,0, 131, 1, "This is Rusgreve's office, and tidy "
"efficiency is the rule.  Rusgreve sits behind an immaculate desk, his head b"
"ent over a document that he is working on.  From behind him, light streams i"
"n through an open window, giving a light airy look to the office.  The scene"
" is completed by an artistic looking pot plant in one corner.  The only exit"
" is back the way you came in.","Rusgreve's Office","office")

ROOM(23, 21,0,0,0,0,0,0,0,0,0, 134, 1, "This is Prendergast's office, and th"
"ere are bits of paper and electronic junk spread out all over the place.  Pr"
"endergast is bending over a piece of equipment with a large glass bulb stick"
"ing out of the top.  Every so often, it makes a loud pop, the bulb flashes, "
"and Prendergast jumps.  The scene is completed by a large and overflowing ti"
"dy bin, with the remains of last night's take-away meal in it, along with se"
"veral Twinkie bar wrappers.  The only exit is back the way you came in.","Pr"
"endergast's Office","office")

ROOM(24, 0,25,0,21,0,0,0,0,0,0, 0, 1, "You are standing at a marble railing,"
" looking out over a vast hall to which there seems to be no access.  To the "
"south and east, the balcony disappears, and becomes a corridor; the view out"
" over the hall is only possible at this particular point.  It is an astoundi"
"ng contrast here, to the office environment to the east; the offices seemed "
"modern, whereas this area seems more like something from classical times.",""
"Balcony","balcony")

ROOM(25, 24,0,0,26,0,0,0,0,0,0, 0, 1, "The corridor bends here, going north "
"to the balcony or east to some sort of storeroom.  It is much the same here "
"as it was to the north and east - you seem to be back to modern times.","Rou"
"nd the Bend","*")

ROOM(26, 0,0,25,0,0,0,0,0,0,0, 137, 1, "The butler's room has plenty of stor"
"age space - shelves and cupboards line all the walls, with all the refreshme"
"nts he is expected to provide for the people in the offices.  The butler him"
"self is sitting in an easy chair in one corner, dozing slightly.  You can on"
"ly go west.","Butler's Store","store")

ROOM(27, 28,28,29,29,0,0,28,29,29,29, 0, 1, "You are in a small clearing in "
"the enchanted wood, from which exits lead in all directions.","Dense Woodlan"
"d","tree")

ROOM(28, 27,27,29,27,0,0,27,29,29,27, 0, 1, "You are in a small clearing in "
"the enchanted wood, from which exits lead in all directions.","Dense Woodlan"
"d","tree")

ROOM(29, 28,28,28,27,0,0,27,31,27,30, 0, 1, "You are in a small clearing in "
"the enchanted wood, from which exits lead in all directions.","Dense Woodlan"
"d","tree")

ROOM(30, 29,36,27,28,0,0,27,29,28,27, 0, 1, "You are in a small clearing in "
"the enchanted wood, from which exits lead in all directions.","Dense Woodlan"
"d","tree")

ROOM(31, 27,29,27,30,0,0,28,29,99,28, 0, 1, "You are in a small clearing in "
"the enchanted wood, from which exits lead in all directions.","Dense Woodlan"
"d","tree")

ROOM(32, 28,99,27,27,0,0,29,28,30,31, 0, 1, "You are in a small clearing in "
"the enchanted wood, from which exits lead in all directions.","Dense Woodlan"
"d","tree")

ROOM(33, 99,29,32,30,0,0,32,28,31,27, 0, 1, "You are in a small clearing in "
"the enchanted wood, from which exits lead in all directions.","Dense Woodlan"
"d","tree")

ROOM(34, 28,32,27,99,0,0,30,29,31,33, 0, 1, "You are in a small clearing in "
"the enchanted wood, from which exits lead in all directions.","Dense Woodlan"
"d","tree")

ROOM(35, 30,34,28,33,0,0,29,31,99,32, 0, 1, "You are in a small clearing in "
"the enchanted wood, from which exits lead in all directions.","Dense Woodlan"
"d","tree")

ROOM(36, 30,0,0,0,37,0,0,0,0,0, 158, 1, "You are in a big clearing in the en"
"chanted wood.  Undergrowth prevents you leaving in any direction except to t"
"he north.  However, here, unlike elsewhere, there is a big tree at the edge "
"of the clearing which looks as though it could be climbed.","Clearing","clea"
"ring")

ROOM(37, 0,0,0,0,0,36,0,0,0,0, 141, 1, "You are jammed in a fork between two"
" branches, half way up a large tree.  Near to you you can see a bird's nest,"
" and further away the birds are perched in the branches twittering.  It is m"
"ost uncomfortable here, so make up your mind quickly what you want to do!",""
"Up a Gum Tree","tree")

ROOM(38, 35,39,0,0,0,0,0,0,0,0, 0, 1, "You are just out of the enchanted for"
"est - to your north you can see its huge expanse.  To your south is the fair"
"y castle, now towering immense above you.  Right near the top, you can make "
"out another small tower coming off the main one and seemingly suspended in m"
"id air.","Castle Front","*")

ROOM(39, 38,0,0,0,40,0,0,0,0,0, 0, 1, "You are standing at the base of a lon"
"g spiral staircase, made out of a fine, dark wood.  To the north sunlight st"
"reams in from the castle front, while in all other directions you can only s"
"ee the marble walls of the castle, with occasional leaded windows in it at v"
"arious heights.","Fairy Castle's Bottom","*")

ROOM(40, 0,0,0,0,41,39,0,0,0,0, 0, 1, "You are part way up a spiral staircas"
"e made of a fine dark wood.  There are no exits from the staircase at this l"
"evel: you will have to go up or down.","Staircase","stairs")

ROOM(41, 0,0,0,0,42,40,0,0,0,0, 0, 1, "You are part way up a spiral staircas"
"e made of a fine dark wood.  There are no exits from the staircase at this l"
"evel: you will have to go up or down.","Staircase","stairs")

ROOM(42, 0,0,0,0,43,41,0,0,0,0, 0, 1, "You are part way up a spiral staircas"
"e made of a fine dark wood.  There are no exits from the staircase at this l"
"evel: you will have to go up or down.","Staircase","stairs")

ROOM(43, 0,0,0,0,44,42,0,0,0,0, 0, 1, "You are part way up a spiral staircas"
"e made of a fine dark wood.  There are no exits from the staircase at this l"
"evel: you will have to go up or down.","Staircase","stairs")

ROOM(44, 0,45,0,0,0,43,0,0,0,0, 148, 1, "You are at the top of the staircase"
" leading up the fairy castle.  You are standing on a dusty landing, illumina"
"ted gently from a tiny window.  Looking out, you see that you are now far ab"
"ove the enchanted forest, and can see all the country for miles around.  You"
" can either go south, or back down the stairs.","Staircase","stairs")

ROOM(45, 44,46,0,0,0,0,0,0,0,0, 149, 1, "You are in a tiny anteroom with a p"
"olished (and dusty) wooden floor, and exits leading north and south.  Like t"
"he landing, it is lit from a small window.","Anteroom","anteroom")

ROOM(46, 45,47,0,0,0,0,0,0,0,0, 150, 1, "You are in a tiny anteroom with a p"
"olished (and dusty) wooden floor, and exits leading north and south.  Like t"
"he landing, it is lit from a small window.","Anteroom","anteroom")

ROOM(47, 46,0,0,0,0,0,0,0,0,0, 156, 1, "This is the Princess's room/prison. "
" The only exit is to the north, the way that you have just unlocked.  On the"
" south wall is another of the small windows that this tower seems to have qu"
"ite a line in.  The floor is at least carpeted in here, and it looks clean. "
" Apart from that it is furnished like any room would be if it was the only o"
"ne someone had.","Princess's Room","*")

ROOM(48, 0,0,0,51,0,0,0,0,0,0, 0, 1, "You are crouched by the bank of a fast"
" flowing river, looking out over the water.  Every so often, a big log of wo"
"od - about the size of a small tree trunk - floats past.  If you want to lea"
"ve this tranquil country scene, you can go east.","River Bank","river_bank")

ROOM(49, 50,0,0,0,0,0,0,0,0,0, 161, 1, "You are at the far side of the bridg"
"e.  You can't get any further due to the fact that this area is completely b"
"ricked in by walls that extend right down to the waterline.  The only point "
"in having the bridge must, therefore, be to allow access to a vending machin"
"e which is fixed to one of the walls.  It sells dictating machines (!)","Far"
" Side","*")

ROOM(50, 51,49,0,0,0,0,0,0,0,0, 0, 1, "You are standing on the top of a rath"
"er rickety bridge.  As you walk along it it creaks rather ominously, and you"
" wish to be gone!  If you look over the side, you can see a fast flowing riv"
"er below.  The bridge itself is made of brittle old concrete blocks, and you"
" can walk along it to either the north or south.","Bridge","bridge")

ROOM(51, 52,50,48,0,0,0,0,0,0,0, 130, 1, "You are standing on the bank of a "
"fast flowing river, near a dangerous-looking concrete bridge to the south.  "
"You can also walk along the bank to the west, but a wall prevents similar pr"
"ogress to the east.  To the north you can re-enter the buildings, and reach "
"the elephant's room.","Near Bridge","*")

ROOM(52, 53,51,0,0,0,0,0,54,0,0, 160, 1, "This is the place you had to come "
"to sooner or later.  The place where the elephants squash you underfoot.  Th"
"is is a courtyard very like the one to the northeast, where the lions hold s"
"way, but here there are exits to the north, northeast and south.","Elephants"
"' Trampling Room","*")

ROOM(53, 0,52,0,54,0,0,0,0,0,0, 128, 1, "The guard house is conveniently sit"
"uated between the lions and the elephants, allowing the guards easy access t"
"o both.  You get to the former if you go east, and the latter if you go sout"
"h.  It is a rough, brick building with grimy windows, and odd bits of fighti"
"ng kit left lying around.  In the centre is a big deal table, covered in bee"
"r stains.","Guardhouse","guardhouse")

ROOM(54, 55,0,53,0,0,0,0,0,52,0, 0, 1, "You have come to a vast courtyard, w"
"ith pillared walls that tower high above you.  There is sand underfoot, thou"
"gh, perhaps in view of its function as a place where Christians were thrown "
"to the lions, rather than a pleasant place for an afternoon stroll among the"
" fountains.  In fact, so many were that perhaps by now the lions are more re"
"ady for tummy tickles than for eating someone else... or perhaps not.  The e"
"xits from this delightful place are north, west and southwest.","Lions' Cour"
"t","*")

ROOM(55, 0,54,0,0,0,0,0,0,0,0, 126, 1, "You are in a huge hall, with walls s"
"tretching up nearly as far as you can see.  About half way up one wall a bal"
"cony runs; the other walls have most of their bulk made up of stained glass "
"windows.  All in all it makes up quite an impressive sight, and an appropria"
"te last one for the Christians who were thrown to the lions through the sout"
"h door.  Indeed so many were that it might be suspected that the lions were "
"now only ready for after dinner tummy tickles.  And it looks as though that'"
"s the only way for you to go...","Martyrs' Way","*")

ROOM(56, 0,0,0,27,0,0,0,0,0,0, 151, 1, "You are standing at the top of a hil"
"l; lower down it is covered in gorse.  To the east, someone has cleared a pa"
"th through.  This path seems to lead down into an extensive wood; even from "
"the top of this hill it is hard to make out the far side.  However it is pic"
"ked out by a tall structure that looks like a castle out of a fairy tale!",""
"Hill Top","hill")

ROOM(57, 0,0,0,0,0,0,0,0,0,0, 0, 0, "Spare Oom","Spare Oom","*")

ROOM(58, 0,0,0,0,0,0,0,0,0,0, 0, 0, "Spare Oom","Spare Oom","*")

ROOM(59, 0,0,0,0,0,0,0,0,0,0, 124, 1, "Programmer's Storage Room","Storage","*")

{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},
{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},
{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},
{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},

/* 100 */		{0,0,0,101,1,0,0,0,0,0,0,0,0,0,0,"(the player)","(the player)","*"
"PLAYER",{0,1,1,0,1,1}},

VIRTUAL(101, 102,0,0,103,100,1, "The desk is elegantly crafted in highly pol"
"ished ebony.","a desk","desk")

OBJECT(102, 0,0,0,0,101, 0,0,0,"The scroll reads:\n\n    GNU GENERAL PUBLIC "
"LICENCE -- Version 1, February 1989\n\n Copyright (C) 1989 Free Software Fou"
"ndation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  Everyone is permitte"
"d to copy and distribute verbatim copies  of this licence document, but chan"
"ging it is not allowed.\n\n    Preamble\n\n  The licence agreements of most "
"software companies try to keep users at the mercy of those companies.  By co"
"ntrast, our General Public Licence is intended to guarantee your freedom to "
"share and change free software--to make sure the software is free for all it"
"s users.  The General Public Licence applies to the Free Software Foundation"
"'s software and to any other program whose authors commit to using it. You c"
"an use it for your programs, too.\n\n  When we speak of free software, we ar"
"e referring to freedom, not price.  Specifically, the General Public Licence"
" is designed to make sure that you have the freedom to give away or sell cop"
"ies of free software, that you receive source code or can get it if you want"
" it, that you can change the software or use pieces of it in new free progra"
"ms; and that you know you can do these things.\n\n  To protect your rights, "
"we need to make restrictions that forbid anyone to deny you these rights or "
"to ask you to surrender the rights. These restrictions translate to certain "
"responsibilities for you if you distribute copies of the software, or if you"
" modify it.\n\n  For example, if you distribute copies of"
" a such a program, whether gratis or for a fee, you must give the recipient"
"s all the rights that you have.  You must make sure that they, too, receive "
"or can get the source code.  And you must tell them their rights.\n\n  We pr"
"otect your rights with two steps: (1) copyright the software, and (2) offer "
"you this licence which gives you legal permission to copy, distribute and/or"
" modify the software.\n\n  Also, for each author's protection and ours, we w"
"ant to make certain that everyone understands that there is no warranty for "
"this free software.  If the software is modified by someone else and passed "
"on, we want its recipients to know that what they have is not the original, "
"so that any problems introduced by others will not reflect on the original a"
"uthors' reputations.\n\n  The precise terms and conditions for copying, dist"
"ribution and modification follow.\n\n     GNU GENERAL PUBLIC LICENCE -- TERM"
"S AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n\n  0. This Lic"
"ence Agreement applies to any program or other work which contains a notice "
"placed by the copyright holder saying it may be distributed under the terms "
"of this General Public Licence.  The \"Program\", below, refers to any such "
"program or work, and a \"work based on the Program\" means either the Progra"
"m or any work containing the Program or a portion of it, either verbatim or "
"with modifications.  Each licensee is addressed as \"you\".\n\n  1. You may "
"copy and distribute verbatim copies of the Program's source code as you rece"
"ive it, in any medium, provided that you conspicuously and appropriately pub"
"lish on each copy an appropriate copyright notice and disclaimer of warranty"
"; keep intact all the notices that refer to this General Public Licence and "
"to the absence of any warranty; and give any other recipients of the Program"
" a copy of this General Public Licence along with the Program. You may charg"
"e a fee for the physical act of transferring a copy.\n\n  2. You may modify "
"your copy or copies of the Program or any portion of it, and copy and distri"
"bute such modifications under the terms of Paragraph 1 above, provided that "
"you also do the following:\n\n    a) cause the modified files to carry promi"
"nent notices stating that you changed the files and the date of any change; "
"and\n\n    b) cause the whole of any work that you distribute or publish, th"
"at in whole or in part contains the Program or any part thereof, either with"
" or without modifications, to be licensed at no charge to all third parties "
"under the terms of this General Public Licence (except that you may choose t"
"o grant warranty protection to some or all third parties, at your option).\n"
"\n    c) If the modified program normally reads commands interactively when "
"run, you must cause it, when started running for such interactive use in the"
" simplest and most usual way, to print or display an announcement including "
"an appropriate copyright notice and a notice that there is no warranty (or e"
"lse, saying that you provide a warranty) and that users may redistribute the"
" program under these conditions, and telling the user how to view a copy of "
"this General Public Licence.\n\n    d) You m"
"ay charge a fee for the physical act of transferring a copy, and you may at"
" your option offer warranty protection in exchange for a fee.\n\nMere aggreg"
"ation of another independent work with the Program (or its derivative) on a "
"volume of a storage or distribution medium does not bring the other work und"
"er the scope of these terms.\n\n   3. You may copy and distribute the Progra"
"m (or a portion or derivative of it, under Paragraph 2) in object code or ex"
"ecutable form under the terms of Paragraphs 1 and 2 above provided that you "
"also do one of the following:\n\n    a) accompany it with the complete corre"
"sponding machine-readable source code, which must be distributed under the t"
"erms of Paragraphs 1 and 2 above; or,\n\n    b) accompany it with a written "
"offer, valid for at least three years, to give any third party free (except "
"for a nominal charge for the cost of distribution) a complete machine-readab"
"le copy of the corresponding source code, to be distributed under the terms "
"of Paragraphs 1 and 2 above; or,\n\n    c) accompany it with the information"
" you received as to where the corresponding source code may be obtained.  (T"
"his alternative is allowed only for noncommercial distribution and only if y"
"ou received the program in object code or executable form alone.)\n\nSource "
"code for a work means the preferred form of the work for making modification"
"s to it.  For an executable file, complete source code means all the source "
"code for all modules it contains; but, as a special exception, it need not i"
"nclude source code for modules which are standard libraries that accompany t"
"he operating system on which the executable file runs, or for standard heade"
"r files or definitions files that accompany that operating system.\n\n  4. Y"
"ou may not copy, modify, sublicense, distribute or transfer the Program exce"
"pt as expressly provided under this General Public Licence. Any attempt othe"
"rwise to copy, modify, sublicense, distribute or transfer the Program is voi"
"d, and will automatically terminate your rights to use the Program under thi"
"s Licence. However, parties who have received copies, or rights to use copie"
"s, from you under this General Public Licence will not have their licences t"
"erminated so long as such parties remain in full compliance.\n\n  5. By copy"
"ing, distributing or modifying the Program (or any work based on the Program"
") you indicate your acceptance of this licence to do so, and all its terms a"
"nd conditions.\n\n  6. Each time you redistribute the Program (or any work b"
"ased on the Program), the recipient automatically receives a licence from th"
"e original licensor to copy, distribute or modify the Program subject to the"
"se terms and conditions.  You may not impose any further restrictions on the"
" recipients' exercise of the rights granted herein.\n\n   7. The Free Softwa"
"re Foundation may publish revised and/or new versions of the General Public "
"Licence from time to time.  Such new versions will be similar in spirit to t"
"he present version, but may differ in detail to address new problems or conc"
"erns.\n\nEach version is given a distinguishing version number.  If the Prog"
"ram specifies a version number of the licenc"
"e which applies to it and \"any later version\", you have the option of fol"
"lowing the terms and conditions either of that version or of any later versi"
"on published by the Free Software Foundation.  If the Program does not speci"
"fy a version number of the licence, you may choose any version ever publishe"
"d by the Free Software Foundation.\n\n  8. If you wish to incorporate parts "
"of the Program into other free programs whose distribution conditions are di"
"fferent, write to the author to ask for permission.  For software which is c"
"opyrighted by the Free Software Foundation, write to the Free Software Found"
"ation; we sometimes make exceptions for this.  Our decision will be guided b"
"y the two goals of preserving the free status of all derivatives of our free"
" software and of promoting the sharing and reuse of software generally.\n\n "
"   NO WARRANTY\n\n  9. BECAUSE THE PROGRAM IS LICENCED FREE OF CHARGE, THERE"
" IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. "
" EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER "
"PARTIES PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER E"
"XPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES O"
"F MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS "
"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE PROGR"
"AM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR O"
"R CORRECTION.\n\n  10. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGRE"
"ED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIF"
"Y AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR D"
"AMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES "
"ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LI"
"MITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED "
"BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHE"
"R PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSS"
"IBILITY OF SUCH DAMAGES.\n\n     END OF TERMS AND CONDITIONS\n\n Appendix: H"
"ow to Apply These Terms to Your New Programs\n\n  If you develop a new progr"
"am, and you want it to be of the greatest possible use to humanity, the best"
" way to achieve this is to make it free software which everyone can redistri"
"bute and change under these terms.\n\n  To do so, attach the following notic"
"es to the program.  It is safest to attach them to the start of each source "
"file to most effectively convey the exclusion of warranty; and each file sho"
"uld have at least the \"copyright\" line and a pointer to where the full not"
"ice is found.\n\n    <one line to give the program's name and a brief idea o"
"f what it does.>\n     Copyright (C) 19yy<name of author>\n\n    This progra"
"m is free software; you can redistribute it and/or modify it under the terms"
" of the GNU General Public Licence as published by the Free Software Foundat"
"ion; either version 1, or (at your option) any later version.\n\n    This pr"
"ogram is distributed in the hope that it will be useful, but WITHOUT ANY WAR"
"RANTY; without even the implied warranty of "
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General P"
"ublic Licence for more details.\n\n    You should have received a copy of th"
"e GNU General Public Licence along with this program; if not, write to the F"
"ree Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n\nAl"
"so add information on how to contact you by electronic and paper mail.\n\nIf"
" the program is interactive, make it output a short notice like this when it"
" starts in an interactive mode:\n\n    Gnomovision version 69, Copyright (C)"
" 19xx name of author\n     Gnomovision comes with ABSOLUTELY NO WARRANTY; fo"
"r details type `show w'.     This is free software, and you are welcome to r"
"edistribute it under certain conditions; type `show c' for details.\n\nThe h"
"ypothetical commands `show w' and `show c' should show the appropriate parts"
" of the General Public Licence.  Of course, the commands you use may be call"
"ed something other than `show w' and `show c'; they could even be mouse-clic"
"ks or menu items--whatever suits your program.\n\nYou should also get your e"
"mployer (if you work as a programmer) or your school, if any, to sign a \"co"
"pyright disclaimer\" for the program, if necessary.  Here a sample; alter th"
"e names:\n\n  Yoyodyne, Inc., hereby disclaims all copyright interest in the"
" program `Gnomovision' (a program to direct compilers to make passes at asse"
"mblers) written by James Hacker.\n\n  <signature of Ty Coon>, 1 April 1989\n"
"Ty Coon, President of Vice\n\nThat's all there is to it!\n\n","a scroll","sc"
"roll")

VIRTUAL(103, 0,0,0,0,101,0, "The chair is the kind often found in offices - "
"that tempts you to twirl it round and round.","a chair","chair")

PERSON(104, 0,105,18,"The Noughts and Crosses Grandmaster is an old man, wit"
"h a glistening eye and a long white beard.  No, it isn't tucked into his bel"
"t.","the Grandmaster","grandmaster")

VIRTUAL(105, 0,0,0,0, 104,0,"The book is an ancient leather bound volume, en"
"titled 'Noughts and Crosses: How to play a Psychological Game'.","the book","book")

VIRTUAL(106, 0,0,0,107, 6,0,"The gate is nothing unusual in places such as t"
"his: it is about twice as tall as you, and made of wrought iron.","the gate","gate")

VIRTUAL(107, 0,0,0,121, 106,1,"The fountain is made of marble, although it h"
"as got a little bit dulled by time.  There is no water flowing and it looks "
"as though none has for quite some time.","the fountain","fountain")

VIRTUAL(108, 0,0,0,109, 8,1,"The piano is an ancient grand, and it looks as "
"though it has been well cared for.  Perhaps it would even play well...","the"
" piano","piano")

VIRTUAL(109, 0,0,0,125, 108,0,"The stools are of the kind generally found wi"
"th pianos.  They look quite well used, but are not yet getting into disrepai"
"r.","the stools","stools")

VIRTUAL(110, 0,0,0,0, 10,0,"The net is an unremarkable tennis net.  What is "
"remarkable is the way there are two of them, forming a cross.","the net","a_"
"net")

VIRTUAL(111, 0,0,0,0, 11,0,"The net is an unremarkable tennis net.  What is "
"remarkable is the way there are two of them, forming a cross.","the net","b_"
"net")

VIRTUAL(112, 0,0,0,123, 12,0,"The net is an unremarkable tennis net.  What i"
"s remarkable is the way there are two of them, forming a cross.","the net",""
"c_net")

VIRTUAL(113, 0,0,0,0, 13,0,"The net is an unremarkable tennis net.  What is "
"remarkable is the way there are two of them, forming a cross.","the net","d_"
"net")

VIRTUAL(114, 0,0,0,0, 16,0,"The racks are old and rotten.","the racks","racks")

VIRTUAL(115, 0,0,0,0, 17,0,"The shelves are old and dusty, although they sti"
"ll appear sound.","the shelves","shelves")

VIRTUAL(116, 0,0,0,117, 19,1,"The cupboards seem at home in a laboratory - t"
"hey are brightly painted and clean.","the cupboards","cupboards")

VIRTUAL(117, 0,0,0,118, 116,0,"The benches are the standard laboratory issue"
".  They are tall enough to work at while standing, and do not overhang at al"
"l so that you can't put your knees under them if you sit down.","the benches"
"","benches")

VIRTUAL(118, 0,0,0,120, 117,0,"The equipment is too complex for you to under"
"stand properly.  The most distinctive feature is the wires emerging and goin"
"g to a plate labelled 'DO NOT TOUCH'","the equipment","equipment")

VIRTUAL(119, 0,0,0,0, 9,0,"The rose is an old fashioned, scented variety.",""
"a rose","rose")

VIRTUAL(120, 0,0,0,0, 118,0,"The plate is labelled 'DO NOT TOUCH'.","the pla"
"te","plate")

OBJECT(121 ,0,0,122,0, 107,0,0,1,"The school bag is made of black plastic, w"
"ith a zip on the top, and the word 'SPORT' written on the side.","a school b"
"ag","school_bag")

OBJECT(122, 0,0,0,0, 121,1,1,0,"The battery torch is a long black cylinder w"
"ith buttons to switch it on and off.  The cylinder tapers towards one end; t"
"he torch is designed to be held at the narrow end, and the bulb is at the wi"
"de end.","a battery torch","battery_torch")

OBJECT(123, 0,0,0,0, 112,0,0,0,"The card is about a third of A4 size, rather"
" muddy and with odd round holes punched in it.","a card","punch_card")

OBJECT(124 ,0,0,0,145, 59,0,0,0,"The key is gleaming silver, obviously recen"
"tly polished.  It fits a cylinder lock, of the sort that you might have on y"
"our front door when you aren't dreaming.","a silver key","silver_key")

PERSON(125, 0,0,109,"The piano teacher is a fearsome woman, waiting to entra"
"p people who come into 'her' room in the house, and land them with sixteen h"
"ours of piano practice a day.","the piano teacher","piano_teacher")

VIRTUAL(126,0,0,0,127,55,0,"The balcony is made of thick, ornate marble.  Ei"
"ther it was made during classical times, or the people who had it built were"
" extremely rich!","a balcony","marble_balcony")

VIRTUAL(127,0,0,0,0,126,0,"The stained glass windows are made in abstract de"
"signs, not the designs you would see in a Church.","stained glass windows",""
"stained_glass_windows")

VIRTUAL(128,0,0,0,129,53,0,"The fighting kit is all useless - little scraps "
"of metal that were obviously once made into weapons, and old armour with the"
" leather straps long since rotted.","fighting kit","fighting_kit")

VIRTUAL(129,0,0,0,0,128,1,"The table is not really very exciting!  It looks "
"much like any grotty old table would!","a table","deal_table")

VIRTUAL(130,0,0,0,0,51,0,"The bridge is made of brick pillars supporting a p"
"athway made of paving stones.  It looks as though it needs preventive mainte"
"nance, in other words it may fall down at any moment!","a bridge","bridge")

VIRTUAL(131,144,0,0,132,22,1,"Rusgreve's desk is nothing special - just a st"
"andard desk of the sort you might find in any office.","a desk","desk")

VIRTUAL(132,0,0,0,133,131,0,"You can't see the document Rusgreve is working "
"on, because he won't let you.","a document","document")

VIRTUAL(133,0,0,0,142,132,0,"The pot plant is a standard issue office plant,"
" type 2 (a), with leaves that either look plastic but aren't, or are plastic"
" but look real.","a pot plant","pot_plant")

VIRTUAL(134,0,0,0,135,23,0,"There is paper here of all descriptions - from o"
"ld shopping lists to the designs for his... whatever it is he is working on."
"","paper","paper")

VIRTUAL(135,0,0,0,136,134,0,"The electronic junk is also used for Q's room i"
"n making the James Bond films.","junk","junk")

VIRTUAL(136,0,0,0,143,135,1,"Prendergast's tidy bin is overflowing with vast"
" quantities of material, but there is far more on the floor that could do to"
" be in it!","a tidy bin","tidy_bin")

VIRTUAL(137,0,0,0,138,26,0,"What can I tell you about shelves that you don't"
" already know?","shelves","shelves")

VIRTUAL(138,0,0,0,139,137,1,"The Butler's cupboards are pretty standard - pe"
"ople keep their things in them, and the Things keep their people outside the"
"m.","cupboards","cupboards")

VIRTUAL(139,0,0,0,140,138,0,"The easy chair is used by the Butler when he is"
" able to find an odd few minutes to relax during a busy day.","an easy chair"
"","easy_chair")

PERSON(140,159,0,139,"The butler is smartly dressed as befits his job, tall,"
" and you could imagine him carrying drinks on one of Gerald Ratner's trays.","the butler","butler")

VIRTUAL(141,0,0,146,0,37,1,"The magpie's nest is built out of twigs, and has"
" a section for the eggs to go in, and a section for all the collected trinke"
"ts to go in.","a magpie's nest","nest")

PERSON(142,0,0,133,"Rusgreve is smartly dressed, with a military bearing.  H"
"e would have had a small moustache if he had been around before Hitler gave "
"small moustaches a bad reputation.","Rusgreve","rusgreve")

PERSON(143,0,0,136,"Prendergast is wearing a white lab coat, stained with oi"
"l.  He has a vacant expression on his face, as though he is thinking of othe"
"r things.","Prendergast","prendergast")

OBJECT(144,0,0,0,0,131, 1,0,0,"The cup of coffee is hot and steaming.","a cu"
"p of coffee","cup_of_coffee")

OBJECT(145,0,0,0,147,124, 1,0,0,"The 10p coin has a picture of Her Majesty o"
"n one side, and the rampant lion from the Royal crest on the other.  Above t"
"he lion it says 'NEW PENCE', as a reminder of when Britain gave up a milleni"
"um of sovereignty or rationalised its currency, depending on how you look at"
" it.","a 10p coin","10p_coin")

OBJECT(146,0,0,0,0, 141,0,0,0,"The key is made of gold, rendered hard by som"
"e mysterious process.  It fits a cylinder lock, of the sort that you might h"
"ave on your front door when you aren't dreaming.","a gold key","gold_key")

OBJECT(147 ,0,0,0,157, 145,0,0,0,"The key is made of cast bronze, obviously "
"recently polished.  It fits a cylinder lock, of the sort that you might have"
" on your front door when you aren't dreaming.","a bronze key","bronze_key")

VIRTUAL(148, 0,0,0,0, 44,0,"The door is heavy, and made of a dark wood.  It "
"is locked with a cylinder lock, similar to that which you might have on your"
" front door if you weren't dreaming.  The lock is made of bronze.","a door","bronze_door")

VIRTUAL(149, 0,0,0,0, 45,0,"The door is heavy, and made of a dark wood.  It "
"is locked with a cylinder lock, similar to that which you might have on your"
" front door if you weren't dreaming.  The lock is made of silver.","a door","silver_door")

VIRTUAL(150, 0,0,0,0, 46,0,"The door is heavy, and made of a dark wood.  It "
"is locked with a cylinder lock, similar to that which you might have on your"
" front door if you weren't dreaming.  The lock is made of gold.","a door","g"
"old_door")

OBJECT(151, 152,153,154,0,56,0,0,1,"The chest looks like the dead man's one "
"in Treasure Island.","a large wooden chest","large_wooden_chest")

OBJECT(152, 0,0,0,0,151,0,0,0,"The paper star is about 10cm across, and is m"
"ade of green paper.","a big green paper star","big_paper_large_green_star")

OBJECT(153, 0,0,0,0,151,0,0,1,"The paper bag is the sort you might buy your "
"groceries in.","a brown paper bag","brown_paper_bag")

OBJECT(154, 0,0,155,0,151,0,0,1,"The small box is painted gloss black, and i"
"s about the size of a jewellry box.  It has a hinged lid, which is now bent "
"and will not close properly.","a small box","small_black_box")

OBJECT(155, 0,0,0,0,154,0,0,0,"The medallion is a small gold disc, with an a"
"bstract design on each face.  Attached to the top is a purple ribbon.","a me"
"dallion","gold_golden_medallion")

PERSON(156,0,0,47,"The princess doesn't like being examined.","a princess",""
"princess")

OBJECT(157,0,0,0,163,147,1,0,0,"The dictating machine is small enough to fit"
" in your pocket.  It is ready loaded with a miniature tape and batteries, re"
"ady for you to dictate something to your secretary...","a dictating machine "
"(!)","dictating_machine")

VIRTUAL(158,0,0,0,165,36,0,"The magpie is like all the magpies you have seen"
" before - a black and white bird.","a magpie","magpie")

OBJECT(159,0,0,0,0,140,0,0,0,"The potion bottle is made of brown glass, with"
" a ground glass stopper.  On the side it is labelled 'ARE YOU A MAN OR A MOU"
"SE?  DRINK THIS AND SEE.'","a bottle of potion","bottle_of_potion")

PERSON(160,0,0,52,"The elephant is very large, has a long trunk, big ears, g"
"rey skin...","an elephant","elephant")

VIRTUAL(161,0,0,0,162,49,1,"The vending machine is a large metal box on the "
"wall, with a slot and a window.  Through the window you can see a big pile o"
"f dictating machines waiting to be sold.","a vending machine","vending_machi"
"ne")

VIRTUAL(162,0,0,0,0,161,1,"The slot is about the right size for a 10p coin.","a slot","slot")

PERSON(163,0,164,157,"The water sprite is a huge, semi-human form, rearing o"
"ver you and trying to drag you under the water of the pool.","a water sprite"
"","water_sprite")

OBJECT(164,0,0,0,0,163,0,1,0,"The torch is really quite large; it looks rath"
"er like the Olympic torch, so despite being a funny thing to give as a sport"
"s prize it is sort of appropriate.  It is alight.","a burning torch","burnin"
"g_olympic_torch")

VIRTUAL(165,0,0,0,0,158,0,"The tree is quite large, and with numerous low br"
"anches that you could use if you wanted to climb up.","a tree","climbable_tr"
"ee")

/* Terminate */	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(char *) 1 /* Rogue value */,"","",{0,0,0,0,0,0,0,0}}

};
