/* $Header$ */
/* parse adv.t using normal TADS operators */
#pragma C-
/*
   advmods.t - modification and replacement of standard library objects
   for the Polyadv code.
*/

/*
 * Contributors (see history.t for current e-mail addresses)
 *
 *      dmb     In real life:   David M. Baggett
 *
 *      djp     In real life:   David J. Picton
 *
 *      bjs     In real life:   Bennett J. Standeven
 *
 * Modification history (Adventure 551/ Polyadv)
 *
 * AD551
 * =====
 *
 * 14-Apr-99    djp     Initial release of Adventure 551 (1.01)
 *
 * 23-Apr-99    djp     New release (1.10) of Adventure 551.
 *                      Changes since 1.01
 *                      * Changed 'get in' and 'get on' to be separate
 *                        verbs so that we obtain more sensible error
 *                        messages
 *                      * Changed the wear command to do an implied take.
 *
 * 30-Apr-99    djp     New release (1.11) of Adventure 551.
 *                      Changes since 1.10
 *                      * Added a doAction for 'throw'.   The default
 *                        doThrow method just does an askio, which makes
 *                        a difference in one case.  If you throw the axe,
 *                        its availability is checked BEFORE a prompt for
 *                        the indirect object.  Simplified iodefault coding
 *                        and added the bear (except when tame).
 *
 * 17-May-99    djp     New release (1.20)
 *                      Changes since 1.11
 *                      * Changed doDefault for takeVerb to:
 *                        (1) Close a loophope which allowed 'take all from
 *                        container' to remove the contents of a closed
 *                        container.
 *                        (2) Exclude fixedItem containers with a
 *                        notakeallfrom property set (so TAKE ALL in
 *                        the building will ignore the pantry.)
 *                      * doDefault for the Put command now excludes all
 *                        fixed items.
 *                      * A duplicated call to actor.location.reachable in
 *                        the default isReachable method has been removed.
 *                      * Changed initsearch to reflect the new handling of
 *                        floatingdecoration items.  These now go into room
 *                        contents lists provided that the global.floatcontents
 *                        variable is true, and the loclist for the object
 *                        is non-nil.
 *                      * Changed the default doDefault and ioDefault methods
 *                        not to add floatingdecoration items when
 *                        global.floatcontents is true.
 *                      * Implemented 'global.noall' as a list of objects
 *                        to be ignored by doDefault and ioDefault. (Mainly
 *                        omnipresent items like your hands or the air.)
 *                      * Changed the initSearch function to accommodate
 *                        the new scheme whereby some 'floating' objects are
 *                        placed in contents lists instead of
 *                        global.floatingList.
 *                      * Changed toplocation function to return nil for an
 *                        object not located in a true room.  (This is
 *                        done for the benefit of items which define
 *                        toplocation(Me) as their location and which have
 *                        the makecontents property set.  These items should
 *                        not be added to the contents lists of nestedrooms,
 *                        but the original toplocation function would allow
 *                        this to happen for nestedroom objects with an
 *                        initial location of nil.)
 *
 * 15-Jul-99    djp     New release (2.00)
 *                        Changes for this version
 *                      * Zapped 'center' (which is now a travel verb)
 *                      * Changed roomDrop method to recognize the new
 *                        roomdroploc property.  Likewise with droploc
 *                        function.
 *                      * Changed sayVerb to recognize 'saint-michel' and
 *                        to give a more authentic response in the general
 *                        case.
 *                      * Updated verDoUnwear method to check whether the
 *                        item is worn by the actor.
 *                      * Updated mainRestore to examine the return code
 *                        and report the reason for failure if TADS 2.5.0
 *                        is used (while retaining backward compatibility)
 *
 * 17-Feb-00    djp     New release - Version 2.20
 *                        Changes in this version
 *                      * Fixed bug in 'say' command
 *                      * Updated thing.cantReach, added thing.cantReachRoom,
 *                        room.cantReach and nestedroom.cantReachRoom.
 *                        Updated some default properties and methods for
 *                        'thing'.
 *                      * Updated methods for SEARCH verb.
 *                      * Changed dialItem to use the new asknum function
 *                        to prompt for numbers.
 *
 * POLYADV
 * =======
 *
 * 24-Aug-99    bjs     Pre-release version 0.00
 *
 *          djp+bjs     Incorporated ad551 mods up to 2.20
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *                      * Added an optional argument to incscore().
 *                      * Fixed noexit to give a suitable message for
 *                        invalid travel in the dark.
 *                      * Added code to deepverb to recognize negative numbers.
 *
 * 4-Apr-00     djp     Version 1.01: bugfix release
 *                      Changes in this version
 *                      * Changed onword and offword to statusPrep and
 *                        outOfPrep (for standardization).
 *                      * Moved portable_chairitem and portable_beditem
 *                        to this file.  The chairitem and beditem classes
 *                        are now subclasses of the portable versions.
 *                      * Added bees and basilisk to default list of targets
 *                        for throwing.
 *                      * Changed distantItem to allow things to be waved
 *                        at distant objects - also asking and telling about
 *                        these objects.
 *                      * Added the complete set of #defines from
 *                        TADS 2.5.1.
 *                      * Changed some verbs to be darkVerbs.
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *                      Changes in this version:
 *                      * Added provision for 701-point mode
 *                      * Corrected the default ldesc.
 *
 *              
 * 25-Sep-00    djp     Version 2.01: bugfix release
 *                      Changes in this version:
 *                      * Added sdesc method for travel verbs
 *                      * Corrected the doAction methods for the up and
 *                        down verbs.  
 *
 * 20-Dec-00    djp     Version 2.02: bugfix release
 *                      Changes in this version:
 *                      * Corrected thatdesc to display "those" not "them"
 *                        for plural items.
 *                      * Updated default actor travelTo method to use latest
 *                        v2.5.5 coding.  Eliminated use of %you% in check
 *                        for deleted room (which wouldn't produce correct
 *                        text in all cases).
 *                      * Corrected strObj so that say "noside samoht" is
 *                        equivalent to noside samoht.
 *
 * 8-Jun-01     djp     Version 2.05: bugfix release
 *                      Changes in this version:
 *                      * Corrected the code for lying on the floor.
 *
 * 17-Aug-01    djp     Version 2.06: bugfix release with e-mail address update
 *                      Changes in this version:
 *                      * Corrected showcontcont for the case when one
 *                        'plural' object is sitting on a surface.
 *
 * 22-Nov-01    djp     Version 2.08: bugfix release
 *                      Changes in this version:
 *                      * Implemented 'leave here' e.g. leave bear here 
 *                      * 'prise' accepted as synonym for 'pry'
 *                      * Explicitly tell the player about the loss of
 *                        points for quitting.
 *                      * Implemented 'out' for all nested rooms.
 *                        Changed default reachability to [] + self for
 *                        chairitems etc.
 *
 * 13-Jan-03    djp     Version 2.09 rev C: bugfixes and code tidy-up
 *                      Changes in this version:
 *                      * Standardization of library files.  A standard
 *                        adv.t file is now used, and this file (renamed
 *                        advmods.t) now just contains the modified
 *                        code for standard library objects.
 *                      * Defined isindoor and isoutside properties for
 *                        nested rooms.
 *                      * Enhancements to the construct method including
 *                        a createloc property (for endgame 'clones')
 *                      * Changed the moveInto method for items, to turn off
 *                        all the extra code during the init phase.  During
 *                        the game, we store information about the previous
 *                        location of the player when the item was dropped.
 *                      * Changed the isReachable property for items to call
 *                        the special_cantreach method.
 *                      * Changed listfixedcontcont to provide a fully
 *                        recursive list including the contents of nonfixed
 *                        items.
 *                      * Made provision for location methods to depend on 
 *                        an actor other than the player.
 *                      * Changed noexit not to cause the actor to fall into
 *                        a pit.  (This may not be appropriate in all
 *                        circumstances, e.g. when the bear is travelling.)
 *                      * Changed doPutIn and doPutOn to use execCommand for
 *                        the implied take (like doWear in the standard 
 *                        library)
 *                      * Moved Me customization (from ccr-std.t) into 
 *                        basicMe (this file)
 *                      * Enhanced travelTo method with a new argument
 *                        format, actor.travelTo(room, &prop).  This allows
 *                        the travel property to be evaluated within
 *                        the travelTo method after global variables have
 *                        been set.  Other optional arguments can be used to 
 *                        change the viewpoint from which location methods are 
 *                        evaluated, or to temporarily turn off travel
 *                        restrictions when the cave is closing.
 *
 *                      * In order to circumvent a bug in parserGetObj (see
 *                        preparse.t for more discussion of this) we now
 *                        set the following global properties in the
 *                        validDoList, validIoList and doDefault methods:
 *
 *                        global.verbActor:  The actor executing the current
 *                                           verb
 *                        global.travelActor: The actor who is travelling
 *                                            (initially set to the verb
 *                                            actor)
 *                        global.currentActor: The current actor for the
 *                                             purpose of evaluating location
 *                                             methods (initially set to the
 *                                             verb actor)
 *
 *                        Note that the last two properties are set to nil
 *                        at the start of daemon execution.
 *
 *                      * Added a generic verbAction method to reset some
 *                        variables and apply a special reachability check
 *                        (e.g. for objects on the wrong side of the dragon).
 *                        The global.xxxxActor properties (see above) are
 *                        set in this method.
 *
 * 31-May-03    djp     Version 2.10: minor bugfixes and enhancements
 *                      * Modified doorway, lockable and keyItem classes to 
 *                        allow OPEN <lockable item> WITH KEYS
 *
 *
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode.
 *
 * 6-May-04     djp     Version 2.12 Rev C 
 *                      * Installed the moveme method (general method for
 *                        moving a vehicle in which a player is riding)
 *                      * Changed properties for chairitems which now
 *                        use a standard enterRoom method, but now use
 *                        moveInto instead of travelTo for sitting/lying.   
 *                      * Changed the moveInto methods for actors.  The
 *                        following properties are now defined:
 *                        lastmoveloc: last room/nestedroom in which the 
 *                            actor was moved (using moveInto)
 *                        lasttoploc: last top-level room in which the
 *                            actor was moved (using moveInto)
 *                        prevloc: previous top-level room into which the
 *                            actor was moved (using moveInto)
 *
 *                      * Changed verdoUnboard, doUnboard and statusRoot
 *                        methods to cater for multiply-nested nestedrooms
 *
 *                      * Changed statusRoot for nested rooms 
 *
 *                      * Added turnoff functionality for lamps defined with
 *                        lightsource,switchItem
 *
 *                      * Fixed a bug which prevented the dragon being killed
 *                        from the north part of the room.  The
 *                        special_cantreach method is now invoked for all
 *                        objects of class 'thing' but fixed items are
 *                        now given the bothsides property by default.
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *                      * Added a new method, transmove to the room
 *                        classes.  This is intended to be returned by
 *                        travel methods for forms of travel (e.g. PHUCE, 
 *                        ANA, KATA) which may convey the player in a 
 *                        nestedroom.
 *
 *                      * Added new travel methods vehicleTravel and 
 *                        roomMoveTravel to the default actor class.  
 *                        The vehicleTravel method works like travelTo if the
 *                        player is in a top-level room, but may move the 
 *                        player's container if it is a nestedroom.  The
 *                        roomMoveTravel method also moves all the portable
 *                        objects from the existing room to the new one.
 * 
 *                      * Define special transmove/moveme methods for TheFloor.
 *
 *                      * Changed verdoUnboard, doUnboard and statusRoot
 *                        methods to cater for multiply-nested nestedrooms
 *
 *                      * Changed the lookAround method for nestedrooms to
 *                        avoid showing the room description when the player
 *                        is transported to a nestedroom in a dark room
 *                        (e.g. transindection movements when sitting on 
 *                        rock in Sandstone Chamber)
 *                      
 *                      * Various changes to the code for locking and 
 *                        unlocking doors etc.  LOCK DOOR or LOCK DOOR WITH
 *                        KEYS may now reference a special object which
 *                        searches for a key to fit the lock.
 *                      * BasicMe.moveInto now implements new 
 *                        floorvocab and floorvocaba properties to allow
 *                        theFloor to acquire extra nouns and adjectives in
 *                        particular rooms.
 *                      * Corrected a stack overflow problem when the
 *                        player lay on the floor while dwarves were in 
 *                        motion.                        
 *
 * 9-Aug-05     djp     Version 3.12: Enhancements and bugfixes
 *                      * Issue suitable messages when an individual key
 *                        must be detached from the keyring before being
 *                        dropped.  Make the keyring no longer worn or
 *                        wearable if no wearable keys are now attached.
 * 
 * 16-Jul-06    djp     Version 3.20: Bugfixes and extensions
 *                      * Modifications to general moveinto method to issue
 *                        cancel_cave_closure with appropriate arguments
 *                        including the optional second argument (see
 *                        ccr-endg.t)
 *                      * Implemented more magic words in the SAY command.
 *
 * 20-Oct-07    djp     Version 3.20 Rev. C
 *                      * Added properties for 'put through' (at present
 *                        this is implemented only for the hole in the
 *                        Blue-level maintenance room wall)
 *
 * 17-Apr-09    djp     Version 3.20 Rev. D
 *                      * Changed the reachability check in deepverb.verbAction
 *                        to apply to all objects except numObj and 
 *                        strObj.
 *                        Previously it applied to portable items only, but
 *                        this created a problem with the Zarkalon strange
 *                        machine which transports itself into a closed
 *                        container (the display cabinet).
 *
 *              djp     Version 3.21
 *                      * Implemented the new properties ana_extradot and
 *                        kata_extradot in nested rooms
 *                      * Changed the coding for taking keys; this is no longer
 *                        possible if they are attached to the keyring, unless
 *                        they are 'DETACH'ed first.
 *                      * Changed the verDoAttachTo method to check whether a
 *                        key is already attached to the keyring, and changed
 *                        verDoDetachFrom to check that a key is attached.
 *                      * Implemented changes to chairitem and beditem 
 *                        objects, to allow for alternative player postures -
 *                        sitting, lying and standing.  By default, chairitems
 *                        allow sitting, and beditems allow sitting or lying.
 *                        Standing is also permitted if appropriate methods are
 *                        defined.  The verification methods for sitting and
 *                        lying are now used by portable objects as well 
 *                        as nonportable ones.  (Portable objects need to
 *                        check that the object is not being carried, but no
 *                        harm is done if non-portable objects also do so)
 */
// Constants for parser status codes
// Definitions of compound prepositions
// Format Strings
// Special Word List
// Forward declaration of functions

// Functions
// =========
//
// inputline: function
// _rand: function(x)
replace initRestart: function(parm)
{
    global.restarting := true;
    global.vnumber := parm[1];    // BJS
    global.randomized := parm[2]; // DJP
    global.initsilent := parm[3]; // DJP
}

// inputline: function
// _rand: function(x)
// initRestart: function(parm)
// checkDoor: function(d, r)
// checkReach: function(loc, actor, v, obj)
// isIndistinguishable: function(obj1, obj2)
/*
 *  DJP - special customization for birdcages in endgame
 */
replace isIndistinguishable: function(obj1, obj2)
{
    return (firstsc(obj1) = firstsc(obj2)
            and obj1.isworn = obj2.isworn
            and obj1.hasbird = obj2.hasbird        // DJP, for endgame
            and ((obj1.islamp and obj1.islit)
                 = (obj2.islamp and obj2.islit)));
}
// itemcnt: function(list,always)
/* 
 *  DJP - added a new optional argument "always", containing a list of
 *  objects which are to be listed even when isListed = nil.
 */
replace itemcnt: function( list, ... )
{
    local cnt, tot, i, obj, j;
    local always := [];
    if (argcount > 1) always := getarg(2);
    tot := length(list);
    for (i := 1, cnt := 0 ; i <= tot ; ++i)
    {
        /* only consider this item if it's to be listed */
        obj := list[i];
        if ( obj.isListed or find(always, obj))
        {
            /*
             *   see if there are other equivalent items later in the
             *   list - if so, don't count it (this ensures that each such
             *   item is counted only once, since only the last such item
             *   in the list will be counted)
             */
            if (obj.isEquivalent)
            {
                local sc;

                sc := firstsc(obj);
                for (j := i + 1 ; j <= tot ; ++j)
                {
                    if (isIndistinguishable(obj, list[j]))
                        goto skip_this_item;
                }
            }

            /* count this item */
            ++cnt;

        skip_this_item: ;
        }
    }
    return cnt;
}

// sayPrefixCount: function(cnt)
// listcontgen: function(obj, flags, indent)
// listcont: function(obj)
//
/*
 *  listlist: function( list, always )  - DJP
 *
 *  This is a modified version of the listcont function.  The "list"
 *  argument specifies the items which are to be listed.  By default, items
 *  with the isListed property set to nil are not listed; however, the
 *  optional "always" argument may contain a list of items which are to
 *  be listed anyway.
 */

listlist: function( list, ... )
{
    local i, count, tot, cur, disptot, prefix_count;
    local always := [];
    if (argcount > 1) always := getarg(2);
    tot := length( list );
    count := 0;
    disptot := itemcnt( list, always );
    for (i := 1 ; i <= tot ; ++i)
    {
        cur := list[i];
        if ( cur.isListed or find(always, cur))
        {
            /* presume there is only one such object */
            prefix_count := 1;

            /*
             *   if this is one of more than one equivalent items, list
             *   it only if it's the first one, and show the number of
             *   such items along with the first one
             */
            if (cur.isEquivalent)
            {
                local before, after;
                local j;
                local sc;

                sc := firstsc(cur);
                for (before := after := 0, j := 1 ; j <= tot ; ++j)
                {
                    if (isIndistinguishable(cur, list[j]))
                    {
                        if (j < i)
                        {
                            /*
                             *   note that objects precede this one, and
                             *   then look no further, since we're just
                             *   going to skip this item anyway
                             */
                            ++before;
                            break;
                        }
                        else
                            ++after;
                    }
                }

                /*
                 *   if there are multiple such objects, and this is the
                 *   first such object, list it with the count prefixed;
                 *   if there are multiple and this isn't the first one,
                 *   skip it; otherwise, go on as normal
                 */
                if (before = 0)
                    prefix_count := after;
                else
                    continue;
            }

            if ( count > 0 )
            {
                if ( count+1 < disptot )
                    ", ";
                else if (count = 1)
                    " and ";
                else
                    ", and ";
            }

            /* list the object, along with the number of such items */
            if (prefix_count = 1)
                cur.adesc;
            else
            {
                sayPrefixCount(prefix_count); " ";
                cur.pluraldesc;
            }

            /* show any additional information about the item */
            if ( cur.isworn ) " (being worn)";
            if ( cur.islamp and cur.islit ) " (providing light)";
            count := count + 1;
        }
    }
}

// nestlistcont: function(obj, depth)
// showcontcont: function(obj)

// DJP - changed to use 'are' instead of 'is' when appropriate
// N.B. firstitem function is defined in ccr-fun.t

replace showcontcont: function(obj)
{
    local cnt := itemcnt(obj.contents);
    if (cnt)
    {
        if (obj.issurface)
        {
            if (not obj.isqsurface)
            {
                "Sitting on "; obj.thedesc;
                if (cnt > 1 or (firstitem(obj.contents)).isThem) 
                    " are ";
                else
                    " is ";
                listcont(obj);". ";
            }
        }
        else if (obj.contentsVisible and not obj.isqcontainer)
        {
            caps();
            obj.thedesc; " seem";
            if (!obj.isThem) "s";
            " to contain ";
            listcont(obj);
            ". ";
        }
    }
    if (obj.contentsVisible and not obj.isqcontainer)
        listfixedcontcont(obj);
}
// listfixedcontcont: function(obj)

// DJP - changed to show the contents of everything in obj, not just
// the fixeditems.

replace listfixedcontcont: function(obj)
{
    local list, i, tot, thisobj;

    list := obj.contents;
    tot := length(list);
    i := 1;
    while (i <= tot)
    {
        thisobj := list[i];
        if ((length(thisobj.contents) > 0) and thisobj.contentsVisible and
             not thisobj.isqcontainer and not thisobj.isqsurface)
            showcontcont(thisobj);
        i := i + 1;
    }
}
// listcontcont: function(obj)
// scoreStatus: function(points, turns)
// scoreFormat: function(points, turns)
// turncount: function(parm)
replace turncount: function(parm)
{
    global.currentActor := nil;  // unset during daemon execution
    global.travelActor := nil;
    incturn();
    global.turnsofar := global.turnsofar + 1;
    scoreStatus(global.score, global.turnsofar);
}
// addweight: function(l)
replace addweight: function( l )
{
    local tot, i, c, totweight;

    tot := length( l );
    i := 1;
    totweight := 0;
    while ( i <= tot )
    {
        c := l[i];
        totweight := totweight + c.weight;
        // DJP - changed to exclude items which are worn
        if (length( c.contents ) and not c.isworn)
            totweight := totweight + addweight( c.contents );
        i := i + 1;
    }
    return( totweight );
}

/* This is used by the decrepit bridge code to find the true weight of
   the adventurer's burden (since addweight has now been changed
   to exclude items which are worn.) */

addmass: function( l )
{
    local tot, i, c, cmass, totmass;

    tot := length( l );
    i := 1;
    totmass := 0;
    while ( i <= tot )
    {
        c := l[i];
        if(c.mass <> nil) cmass := c.mass;
        else if (c.weight <> nil) cmass := c.weight;
        else cmass := 0;
        totmass := totmass + cmass;
        if (length( c.contents ))
            totmass := totmass + addmass( c.contents );
        i := i + 1;
    }
    return( totmass );
}
// addbulk: function(list)
// incscore: function(amount)
replace incscore: function( amount, ... )  /* DJP - added optional argument */
{
        local extratext = '';
        if( amount = 0 ) return;  /* DJP - ignore calls with zero argument */
        silent_incscore(amount);
        if (argcount > 1) extratext := ' '+getarg(2);
        "\b";
        if (amount = -1)
                "* Your score just went down by a point<<extratext>>. *";
        else if (amount = 1)
                "* Your score just went up by a point<<extratext>>. *";
        else if (amount < -1) {
                "* Your score just went down by ";
                say(-1 * amount); " points<<extratext>>. *";
        }
        else if (amount > 1) {
                "* Your score just went up by "; say(amount); " points<<extratext>>. *";
        }
        "\b";
}
// DMB: added the following:
silent_incscore: function( amount )
{
        global.score := global.score + amount;
        scoreStatus( global.score, global.turnsofar );
}

// initSearch: function
replace initSearch: function
{
    local o;

    o := firstobj(hiddenItem);
    while (o <> nil)
    {
        if (o.searchLoc)
            o.searchLoc.searchCont := o.searchLoc.searchCont + o;
        else if (o.underLoc)
            o.underLoc.underCont := o.underLoc.underCont + o;
        else if (o.behindLoc)
            o.behindLoc.behindCont := o.behindLoc.behindCont + o;
        o := nextobj(o, hiddenItem);
    }

    //
    // Construct a list of 'floating' items (which is properly defined as the
    // set of objects which aren't included in contents lists).  In this game,
    // the special floatingdecoration and makecontents classes are excluded.
    // Other objects are included if they have the floatingItem class, or
    // a location which is defined as a method.
    //
    global.floatingList := [];  // all floating objects
    global.herefloatList := []; // floating objects with a defined heredesc or
                                // actorDesc property
    for (o := firstobj(thing); o; o := nextobj(o, thing) ) {
        // if the global.floatcontents flag is set, we omit floatingdecoration
        // objects with loclists, and other floating items in the
        // makecontents class.
        if ((global.floatcontents and isclass(o,floatingdecoration)
        and o.loclist <> nil) or isclass(o,makecontents))
            continue;
        if (proptype(o,&location) = 6 or isclass(o,floatingItem)) {
            global.floatingList += o;
            if (defined(o,&heredesc) or defined(o,&actorDesc))
                global.herefloatList += o;
        }
    }
}

// reachableList: function(obj)
// visibleList: function(obj, actor)
// numbered_cleanup: function(obj)
// mainRestore: function(fname)
replace mainRestore: function(fname) 
// DJP - adapted from the 2.5.0 adv.t version
{
    local restcode;
    /* try restoring the game */
    restcode := restore(fname);
    if(restcode)
    {
        switch(restcode) {
            case true:
            /* an error occurred (tadsr v2.3.0 or earlier) - tell the player */
            "Restore failed. ";
            return nil;

            case RESTORE_FILE_NOT_FOUND:
            "The saved position file could not be opened. ";
             return nil;

            case RESTORE_NOT_SAVE_FILE:
            "This file does not contain a saved game position. ";
            return nil;

            case RESTORE_BAD_FMT_VSN:
            "This file was saved by another version of TADS that is
            not compatible with the current version. ";
            return nil;

            case RESTORE_BAD_GAME_VSN:
            "This file was saved by a different game, or a different
            version of this game, and cannot be restored with this game. ";
            return nil;

            case RESTORE_READ_ERROR:
            "An error occurred reading the saved position file; the file
            might be corrupted.  The game might have been partially restored,
            which could make it impossible to continue playing; if the game
            does not seem to be working properly, you should quit the game
            and start over. ";
            return nil;

            case RESTORE_NO_PARAM_FILE:
            /*
             *   ignore the error, since the caller was only asking, and
             *   return nil
             */
            return nil;

            default:
            "Restore failed - unknown reason. ";
            return nil;

        }
    }
    else /* success.   The return code either 0 or nil, depending on the
          * TADS version. */
    {
        local oldrandomized := global.randomized; // DJP

        /* update the status line */
        scoreStatus(global.score, global.turnsofar);

        /* tell the user we succeeded, and show the location */
        "Restored.\b";

        // DJP - randomize if we need to (otherwise randomize() never gets
        // called if we restore in the first turn or using the -r command
        // line option)

        if(global.randomized and (not oldrandomized)) randomize();

        // DJP - tell us where we are

        P();
        parserGetMe().location.lookAround(true);   // show player where he is

        /* success */
        return true;
    }
}

// switchPlayer: function(newPlayer)
// class numberedObject: object
// class nestedroom: room
modify nestedroom
    noNPCs = true // we don't want NPC's to sit on chairs or stand on rugs.
    // DMB - define onroom property
    // DJP - standardized onword and offword to statusPrep and outOfPrep
    // but kept the dependence on the onroom property.
    statusPrep = { if (self.onroom) "on"; else "in"; }
    outOfPrep = { if (self.onroom) "off"; else "out of"; }
    statusRoot =
    {
        "<<self.location.statusRoot>>, <<self.statusPrep>> <<self.thedesc>>";
    }
    replace lookAround(verbosity) = {
        inherited darkroom.lookAround(verbosity);
    }
    replace nrmLkAround(verbosity) = {
        if (self.location) 
             self.location.nrmLkAround(verbosity);
        else
             pass nrmLkAround;
    }
    // Added - DJP
    isoutside = {
        if(self.location = nil) return nil;
        else return self.location.isoutside;
    }
    isindoor = {
        if(self.location = nil) return nil;
        else return self.location.isindoor;
    }
    out = {self.doUnboard(global.travelActor); return nil;}
    exithints = {return [] + self.location + &out;}
    // transindection movements use the transmove property

    ana = {return self.transmove(&ana);}
    ana2 = {return self.transmove(&ana2);}
    ana3 = {return self.transmove(&ana3);}
    has_ana_extradot = {return self.location.has_ana_extradot;}
    ana_extradot = {return self.transmove(&ana_extradot);}
    kata = {return self.transmove(&kata);}
    kata2 = {return self.transmove(&kata2);}
    kata3 = {return self.transmove(&kata3);}
    has_kata_extradot = {return self.location.has_kata_extradot;}
    kata_extradot = {return self.transmove(&kata_extradot);}

    transmove(prop) = {
    // N.B. the prop argument can be a destination location, or a property
    // pointer for a travel method (which by default is evaluated for the
    // top-level room.
        local actor := getActor(&travelActor);
        local l, toploc := toplocation(self);
        // if the actor's location is itself nested, refer to the outer
        // vehicle
        if(self.location != toploc) return self.location.transmove(prop);
        // If this vehicle is not to be moved, find out if there is an inner
        // vehicle.  If so, move it.  If not, move the player.
        if (self.isfixed and not self.istransportable) {
            l := actor;
            while (l and not (l.location = self)) {
                l := l.location;
            }
            if ((l = actor) or (l = nil)) {
                if(datatype(prop)= 13)
                    return toploc.(prop);
                else
                    return prop;
            }
            else return l.moveme(prop);
        }
        else
            return self.moveme(prop);
    }
    // General method for moving a vehicle in which the player
    // character is riding.
    moveme(prop) = {
        // Move the nested room 
        local actor := getActor(&travelActor);
        local dest, topdest;
        // Work out the vehicle destination (and maybe print out text)
        if (datatype(prop) = 13)
            dest := toplocation(self).(prop);
        else 
            dest := prop;
        if (dest) {
            self.moveInto(dest);
            topdest := toplocation(dest);
            if (topdest = nil) topdest := dest;
            // Adjust isseen properties for containing
            // room.
            self.isseen := topdest.isseen;
            if (not dest.isseen)topdest.firstseen;
            topdest.isseen := true;
            // The actor location does not change but must be returned to
            // enable the new room description to be printed.
            return actor.location;
        }
        else return nil;
    }
    analevel = {
        if(self.location)
             return self.location.analevel;
        else
             return 0;
    }
;

class owntrans: nestedroom
    // for nestedrooms which define their own transindection
    // properties, e.g. the rock in the sandstone chamber
    // transindection methods use normal defaults
    ana = {return inherited room.ana;}
    ana2 = {return inherited room.ana2;}
    ana3 = {return inherited room.ana3;}
    has_ana_extradot = nil
    kata = {return inherited room.kata;}
    kata2 = {return inherited room.kata2;}
    kata3 = {return inherited room.kata3;}
    has_kata_extradot = nil
    // The transmove method will be invoked if (say) the player is on the
    // rug and the rug is on the rock.  In the case of transindection 
    // movements we need to evaluate the property for the owntrans object,
    // (e.g. the rock at another Transindection level) not the top-level room
    // (which would send us to the Sandstone Chamber).
    transmove(prop) = {
        if(find([&ana,&ana2,&ana3,&ana_extradot,&kata,&kata2,&kata3,
        &kata_extradot],prop)) {
            local dest := self.(prop);
            if (dest) return inherited.transmove(dest);
            else return nil;
        }
        else pass transmove;
    }
;


// class chairitem: fixeditem, nestedroom, surface
modify chairitem
    // DMB - define onroom property
    // DJP - standardized onword and offword to statusPrep and outOfPrep
    // but kept the dependence on the onroom property.
    statusPrep = { 
        if ((parserGetMe.location = self) and parserGetMe().posture and 
        self.say_posture) {
            if(self.onroom) {
                say(parserGetMe().posture); " on";
            }
            else {
                say(parserGetMe().posture); " in";
            }
        }
        else if (self.onroom) "on"; 
        else "in"; 
    }
    onroom = true
    outOfPrep = { if (self.onroom) "off"; else "out of"; }
    /*
     *   See comments in ccr-adv.t.  The old default is nil, for historical
     *   reasons only.  It makes sense for objects to be reachable if their
     *   containers are reachable, so we change the default to true.
     */
    canReachContents = true
    // DJP - reinstate enterroom but use moveInto instead of travelTo for
    // sitting on the chair.
    replace enterRoom(actor) = {
        pass enterRoom;
    }
    // general methods for boarding
    // Note that if the default posture is 'standing' or 'lying', the 
    // methods for standing and lying must be correctly set up.  (For
    // chairitems, 'lie on' is just a synonym for 'sit on' and the default
    // posture should be 'sitting'.  For beditems, lying and sitting are 
    // distinct and the default posture can be 'sitting' or 'lying'.  A
    // default posture of 'standing' is only possible if the object 
    // defines the verDoStandon and doStandon methods.
    verDoEnter(actor) = { self.verDoBoard(actor); }
    doEnter(actor) = { self.doBoard(actor); }
    verDoBoard(actor) = { 
        if (self.default_posture = 'standing') self.verDoStandon(actor);
        else if(self.default_posture = 'lying') self.verDoLieon(actor);
        else self.verDoSiton(actor); 
    }
    doBoard(actor) = {
        if (self.default_posture = 'standing') self.doStandon(actor);
        else if(self.default_posture = 'lying') self.doLieon(actor);
        else self.doSiton(actor); 
    }
    // The verifification methods for sitting and lying are now the same
    // for the portable_chairitem and chairitem classes.  
    verDoSiton(actor) =
    {
        if ( actor.location = self and (actor.posture = 'sitting'))
        {
            "%You're% already "; self.statusPrep; " ";
            self.thedesc; "! ";
        }
        else if (actor.isCarrying(self))
        {
            "%You%'ll have to drop <<thedesc>> first!";
        }
        else if (not isclass(self.location,room) and 
        isclass(self.location,surface))
        {
            "%You% can't do that while <<self.thedesc>> is 
            on <<self.location.adesc>>!";
        }
        else if (not isclass(self.location,room))
        {
            "%You% can't do that while <<self.thedesc>> is 
            in <<self.location.adesc>>!";
        }
    }
    doSiton(actor) =
    {
        "Okay, %you're% now sitting "; 
        if (self.onroom) "on "; else "in "; 
        self.thedesc; ". ";
        actor.moveInto(self);
        actor.posture := 'sitting';
    }
    // lying is a synonym for sitting
    // see comments above before changing this setting
    default_posture = 'sitting'
;

// class beditem: chairitem
modify beditem
    outOfPrep = { if (self.onroom) "off"; else "out of"; }

    // statusPrep must be defined here because the standard
    // beditem class defines its own version

    statusPrep = { 
        if ((parserGetMe.location = self) and parserGetMe().posture and 
        self.say_posture) {
            if(self.onroom) {
                say(parserGetMe().posture); " on";
            }
            else {
                say(parserGetMe().posture); " in";
            }
        }
        else if (self.onroom) "on"; 
        else "in"; 
    }

    // beditems define a separate method for lying

    verDoLieon(actor) =
    {
        if ( actor.location = self and (actor.posture = 'lying'))
        {
            "%You're% already "; self.statusPrep; " ";
            self.thedesc; "! ";
        }
        else if (actor.isCarrying(self))
        {
            "%You%'ll have to drop <<thedesc>> first!";
        }
        else if (not isclass(self.location,room) and 
        isclass(self.location,surface))
        {
            "%You% can't do that while <<self.thedesc>> is 
            on <<self.location.adesc>>!";
        }
        else if (not isclass(self.location,room))
        {
            "%You% can't do that while <<self.thedesc>> is 
            in <<self.location.adesc>>!";
        }
    }
    doLieon(actor) =
    {
        "Okay, %you're% now lying ";
        if (self.onroom) "on "; else "in "; 
        self.thedesc; ". ";
        actor.moveInto(self);
        actor.posture := 'lying';
    }
;
// class floatingItem: object
// class thing: object
modify thing
    // weight
    // statusPrep
    // bulk
    bulk = 0 // (DJP: exclude the possibility of any non-item objects having 
             // bulk)
    // isListed
    // contents
    // verGrab(obj)
    // Grab(obj)
    // adesc
    // pluraldesc
    // thedesc
    // itnomdesc
    // itobjdesc
    // itisdesc
    // doesdesc
    // isdesc
    // isntdesc
    // itselfdesc
    // thatdesc
    // multisdesc
    // ldesc
    // readdesc
    // actorAction(v, d, p, i)
    // contentsVisible
    // contentsReachable
    // isIn(obj)
    // moveInto(obj)
    // verDoSave(actor)
    // verDoRestore(actor)
    // verDoScript(actor)
    // verDoSay(actor)
    //
    verIoDigWith(actor,dobj) = {self.action(actor);} 
    verDoDig(actor) = {self.action(actor);} 
    // verDoPush(actor)
    // verDoAttachTo(actor, iobj)
// If the indirect object is the set of keys, this method now checks that the
// object is not already attached
    verDoAttachTo(actor,io) = {
        if(io = set_of_keys) {
            if(self.isIn(io)) {
                caps(); self.thedesc; " is already on the ring. ";
            }
        }
    }
    // verIoAttachTo(actor)
    // verDoDetach(actor)
// If the indirect object is the set of keys, this method now checks that the
// object is attached
// Default for detach (verification is done by the indirect object only)
    // verDoDetachFrom(actor, iobj)
    verDoDetachFrom(actor,io) = {
        if(io = set_of_keys) {
            if (not self.isIn(io)) {
                caps(); self.thedesc; " is not attached to the keyring. ";
            }
        }
    }
    // verIoDetachFrom(actor)
    // verDoWear(actor)
    // verDoTake(actor)
    // verifyRemove(actor)
    // isVisible(vantage)
    // cantReach(actor)
    // cantReachRoom(otherRoom)
    isReachable (actor) = {
        if (self.special_cantreach(self,actor,[] + self)) return nil;
        pass isReachable;
    }
    special_cantreach(obj,actor,chain) = {
        if(self = actor) return nil;
        if(self.location = nil) return nil;
        else return 
        self.location.special_cantreach(obj,actor,[] + self.location + chain);
    }
    // doTake(actor)
    doTake( actor ) =
    {

        local totbulk, totweight;

        // DJP - special method for troll, bear etc.  If the realtake
        // property has been set, the normal take method is used.
        if(actor <> parserGetMe() and not actor.realtake) {
            actor.ioGiveTo(actor, self);
            return;
        }

        totbulk := addbulk( actor.contents ) + self.bulk;
        totweight := addweight( actor.contents );
        if ( not actor.isCarrying( self ))
            totweight := totweight + self.weight + addweight(self.contents);

        if ( totweight > actor.maxweight )
            "%Your% load is too heavy. ";
        else if ( totbulk > actor.maxbulk )
            // DJP - added 'sack of holding' code to move possessions into
            // containers automatically.
            if(sack_of_holding(actor,self,totbulk - actor.maxbulk)) {
                self.moveInto( actor );
                "Taken. ";
            }
            else
                "%You've% already got %your% hands full. ";
        else
        {
            self.moveInto( actor );
            "Taken. ";
        }
    }

    // verDoDrop(actor)
    // doDrop(actor)
    // verDoUnwear(actor)
    // verIoPutIn(actor)
    // circularMessage(io)
    // verDoPutIn(actor, io)
    verDoPutIn(actor,io) = {

        if (io = theFloor or isclass(io, theFloor)) {
            self.verDoDrop(actor);
        }
        else {
            pass verDoPutIn;
        }
    }
    // doPutIn(actor, io)
    doPutIn( actor, io ) =
    {
        // DJP - modified for implied Take
        if ( self.location <> actor and (not self.noImpliedTake)) {
            /* 
             *   if the actor is not directly carrying it (in other words,
             *   it's either not in the player's inventory at all, or it's
             *   within a container within the actor's inventory), take it --
             *   the actor must be directly holding the object for this to
             *   succeed 
             */
            if (self.location != actor)
            {
                /* try taking it */
                "(First taking <<self.thedesc>>)\n";
                if (execCommand(actor, takeVerb, self) != 0)
                    return;
    
                /* 
                 *   make certain it ended up where we want it - the command
                 *   might have failed without actually indicating failure 
                 */
                if (self.location != actor)
                    return;
            }
        }

        pass doPutIn;
    }

    // verIoPutOn(actor)
    // verDoPutOn(actor, io)
    verDoPutOn(actor,io) = {

        if (io = theFloor or isclass(io, theFloor)) {
            self.verDoDrop(actor);
        }
        else {
            pass verDoPutOn;
        }
    }
    // doPutOn(actor, io)
    doPutOn( actor, io ) =
    {
        // DJP - modified for implied Take
        if ( self.location <> actor and (not self.noImpliedTake)) {
            /* 
             *   if the actor is not directly carrying it (in other words,
             *   it's either not in the player's inventory at all, or it's
             *   within a container within the actor's inventory), take it --
             *   the actor must be directly holding the object for this to
             *   succeed 
             */
            if (self.location != actor)
            {
                /* try taking it */
                "(First taking <<self.thedesc>>)\n";
                if (execCommand(actor, takeVerb, self) != 0)
                    return;
    
                /* 
                 *   make certain it ended up where we want it - the command
                 *   might have failed without actually indicating failure 
                 */
                if (self.location != actor)
                    return;
            }
        }

        pass doPutOn;
    }
    verIoPutThrough(actor) = {
        "I don't know how to put anything through <self.thedesc>. ";
    }
    verDoPutThrough(actor,io) = {}
    // verIoTakeOut(actor)
    // ioTakeOut(actor, dobj)
    // verDoTakeOut(actor, io)
    // doTakeOut(actor, io)
    // verIoTakeOff(actor)
    // ioTakeOff(actor, dobj)
    // verDoTakeOff(actor, io)
    // doTakeOff(actor, io)
    // verIoPlugIn(actor)
    // verDoPlugIn(actor, io)
    // verIoUnplugFrom(actor)
    // verDoUnplugFrom(actor, io)
    // verDoLookin(actor)
    // thrudesc
    // verDoLookthru(actor)
    // verDoLookunder(actor)
    // verDoInspect(actor)
    // doInspect(actor)
    // verDoRead(actor)
    // verDoLookbehind(actor)
    // verDoTurn(actor)
    // verDoTurnWith(actor, io)
    // verDoTurnTo(actor, io)
    // verIoTurnTo(actor)
    // verDoTurnon(actor)
    // verDoTurnoff(actor)
    // verDoScrew(actor)
    // verDoScrewWith(actor, iobj)
    // verIoScrewWith(actor)
    // verDoUnscrew(actor)
    // verDoUnscrewWith(actor, iobj)
    // verIoUnscrewWith(actor)
    // verIoAskAbout(actor)
    // ioAskAbout(actor, dobj)
    // verDoAskAbout(actor, io)
    // verIoTellAbout(actor)
    // ioTellAbout(actor, dobj)
    // verDoTellAbout(actor, io)
    verDoUnboard(actor) = // DJP - modified to allow nesting of containers
    {
        if (not actor.isIn(self))
        {
            "%You're% not <<self.statusPrep>> <<self.thedesc>>! ";
        }
        else if (self.location = nil)
        {
            "%You% can't leave <<self.thedesc>>! ";
        }
    }
    doUnboard(actor) =
    {
        local actorloc := actor.location;
        while(actorloc and (actorloc != self.location) and actorloc.location) {
            if (actorloc.fastenitem)
            {
                "%You%'ll have to unfasten <<actor.location.fastenitem.thedesc
                >> first. ";
            }
            else
            {
                "Okay, %you're% no 
                longer <<actorloc.statusPrep>> <<actorloc.thedesc>>. ";
                actorloc.leaveRoom(actor);
                actor.moveInto(actorloc.location);
                actorloc := actor.location;
            }
        }
    }
/* DJP.     New defaults for verIoAttackWith, etc.  The
   verIoAttackWith method just checks that the weapon is carried in hand
   (unless it IS your hands).  All other checking is now done in
   verDoAttackWith and/or doAttackWith.
   Added missing ioAttackWith method (which has to call doAttackWith) and
   a default for an attack with no indirect object.
 */
    // verDoAttackWith(actor, io)
    verDoAttackWith( actor, io ) =
    {
        if(io) {
            "It's not very productive to attack ";self.thedesc;" with ";
            io.thedesc; ". ";
        }
        else {
            "It's not very productive to attack ";self.thedesc;" with
            your bare hands. ";
        }
    }
    // verIoAttackWith(actor)
    verIoAttackWith( actor ) = {
        if ( self.location <> actor and self <> Hands) {
            "You're not holding ";self.thedesc,".";
        }
    }
    //
    verDoAttack( actor ) =
    {
        "Attacking "; self.thedesc; " doesn't appear productive. ";
    }
    ioAttackWith( actor, dobj ) =
    {
        dobj.doAttackWith( actor, self );
    }
    // verDoEat(actor)
/* DJP - modified code for eating and drinking */
    verDoEat( actor ) =
    {
        if(actor = parserGetMe())                       // DJP
        "I think I just lost my appetite.";  // DMB
        else self.verifyRemove(actor);       // DJP
    }
    //
    doEat( actor )= {
        // DJP - special routine for troll, bear etc.
        if(actor <> parserGetMe()) {
            actor.doFeedWith(actor, self);
            return;
        }
    }
    // verDoDrink(actor)
    verDoDrink( actor ) =
    {
            "Don't be ridiculous!";          // DMB
    }
    // verDoGiveTo(actor, io)
    // doGiveTo(actor, io)
    // verDoPull(actor)
    // verDoThrowAt(actor, io)
    // doThrowAt(actor, io)
    doThrowAt( actor, io ) =
    {
        "Throwing ";self.thedesc;" at ";io.thedesc;" would be pointless. ";
    }
    // verIoThrowAt(actor)
    // ioThrowAt(actor, dobj)
    // verDoThrowTo(actor, io)
    // doThrowTo(actor, io)
    doThrowTo( actor, io ) =
    {
        "Throwing ";self.thedesc;" to ";io.thedesc;" would be pointless. ";
    }
    // verDoThrow(actor)
    // doThrow(actor)
/* DJP - modified to ask for an indirect object.  We do this so that 'throw'
   axe' will check for the presence of the axe straight away, rather than
   waiting until the indirect object has been determined. */
    doThrow( actor ) =
    {
        askio(atPrep);
    }
    // verDoShowTo(actor, io)
    // doShowTo(actor, io)
    // verIoShowTo(actor)
    // verDoClean(actor)
// DJP: Defaults for sweeping and cleaning, which generally have the same
// effect but may have different default messages.   An indirect object is
// now required for cleaning.

    verDoClean (actor)  = {}
    //
    verDoSweep (actor) = {}
    // verDoCleanWith(actor, io)
    verDoCleanWith( actor, io ) = {}
    //
    verDoSweepWith( actor, io ) = {}
    //
    verIoCleanWith( actor ) = {
        caps();"<<self.thedesc>> isn't much use for cleaning.";
    }
    //
    verIoSweepWith( actor ) = {
        caps();"<<self.thedesc>> will hardly serve as a broom.";
    }
    // doCleanWith(actor, io)
    doCleanWith( actor, io ) =
    {
        caps(); self.thedesc; " looks a bit cleaner now. ";
    }
    //
    doSweepWith( actor, io ) = {
        caps(); self.thedesc; " looks a little less dusty now. ";
    }
    //
    doClean( actor ) = {
        askio(withPrep);
    }
    //
    doSweep( actor ) = {
        askio(withPrep);
    }
    // verDoMove(actor)
    verDoMove( actor ) =
    {
        "Trying to move "; self.thedesc; " doesn't reveal anything. ";
    }
    // verDoMoveTo(actor, io)
    verDoMoveTo( actor, io ) =
    {
        "Trying to move "; self.thedesc; " doesn't reveal anything. ";
    }
    // verIoMoveTo(actor)
    // verDoMoveWith(actor, io)
    verDoMoveWith( actor, io ) =
    {
        "Trying to move "; self.thedesc; " doesn't reveal anything. ";
    }
    // verIoMoveWith(actor)
    // verDoTypeOn(actor, io)
    // verDoTouch(actor)
    // verDoPoke(actor)
    // verDoBreak(actor)
    // doBreak(actor)
    // genMoveDir
    // verDoMoveN(actor)
    // verDoMoveS(actor)
    // verDoMoveE(actor)
    // verDoMoveW(actor)
    // verDoMoveNE(actor)
    // verDoMoveNW(actor)
    // verDoMoveSE(actor)
    // verDoMoveSW(actor)
    // verDoSearch(actor)
    // construct
    // DJP - construct and destruct have been customized to
    // set up an objclass property and to adjust the list of scoreable
    // objects to include the created object.  For the full score, only
    // one object need be deposited in the right location (the original
    // object, or a dynamically created clone of the object).

    /* on dynamic construction, move into my contents list and various
     * other lists */
    construct =
    {
        self.objclass := firstsc(self);    // set up objclass
        if (defined(self,&createloc)) {
            self.location := createloc;    // bypass special moveInto code
            self.moveInto(self.createloc); // set up contents list
        }
        else
            self.moveInto(self.location);
        self.moved := nil;                 // not moved by player
        self.objclass.list += self;        // add to list property
        // adjust list of light sources
        if (isclass(self,lightsource)) global.lamplist += self;
        // adjust list of scoreable objects.
        if (find(global.allpointlist,self.objclass)) {
            global.allpointlist += self;
            global.allpoints += 1;
            if (isclass(self,CCR_treasure_item))
                global.treasurelist += self;
            else
                global.pointobjlist += self;
        }
        // set isEquivalent property in case it wasn't set.
        self.isEquivalent := true;
        // clear contents list
        self.contents := [];
        // ensure that a created container is empty (for bottle)
        if (isclass(self,liquidcont)) {
            self.haswater := nil;
            self.hasoil := nil;
            self.haswine := nil;
        }
    }


    // destruct
    /* on dynamic destruction, move out of various lists */
    destruct = {
        self.moveInto(nil);
        self.objclass.list -= self;
        // adjust list of light sources
        if (isclass(self,lightsource)) global.lamplist -= self;
        if (find(global.allpointlist,self.objclass)) {
            global.allpointlist -= self;
            global.allpoints -= 1;
            if (isclass(self,CCR_treasure_item))
                global.treasurelist -= self;
            else
                global.pointobjlist -= self;
        }
    }
    // validActor
    /*
     *   Arrange that a command to an actor can be issued only
     *   if an actor is visible in the normal manner.  (Test changed from
     *   reachable to visible - DJP.)  This method
     *   returns true when 'self' can be given a command by the player.
     */
    validActor = (self.isVisible(parserGetMe()))  // DJP
;

// class item: thing
modify item

    moveInto(loc) = {
        local actor;
        self.isworn := nil; // for clothing items, in case they don't
                            // inherit the clothingItem method for some reason
        // suppress all the extra stuff during the init phase.
        if(global.extend_moveInto) {
            // Store information about the actor's present and previous loc
            // (for rooms with special reachability checks e.g. where objects
            // must be on the correct side of the dragon).
    
            if (global.currentActor)actor := global.currentActor;
            
            // check for objects being dropped in the player's room by daemons.
            // (e.g. axe when dropped in Secret Canyon should land on the
            // same side of the dragon as the player!)
    
            else if(parserGetMe().isIn(loc))actor := parserGetMe();
            if (actor) {
                self.meprevloc := actor.prevloc;
                self.metoploc := toplocation(actor);
            }   
            self.moved := true; // used by items in initmess class
            // If this is a scoring object, add it to the checklist.
            // If it is a non-empty container, add it and all its
            // contents to the checklist.  If the object is a
            // container for liquids, add the wine to the list.
            if (self.depositpoints <> nil or
            length(self.contents) > 0) {
                global.checklist += nestcontents(self);
            }
            // Special case: check for wine in the cask (which is a floating
            // item)
            if ((self = cask or cask.isInside(self)) and cask.haswine)
                global.checklist += wine_in_the_cask;

            // If this is a 'bonus treasure', add it to the appropriate
            // scoring-object lists and increase the maximum score.

            if (self.bonustreasure and not self.bonusfound) {
                local addpoints, transcoord;
                self.bonusfound := true;

                if(self.takepoints <> nil)
                    addpoints := (self.takepoints + self.depositpoints);
                else
                    addpoints := 0;

                if(isclass(self,coinitem)) {
                    global.coinsets++;
                    fresh_batteries.available++;
                }

                // check for the discovery of a bonus treasure which has not
                // yet been added to the list.  (In most cases the bonus
                // treasures are added to the list when the relevant area is
                // opened). Note that the 'discovery' is detected when the
                // object is first moved. 

                if(isclass(self, CCR_treasure_item)) {
                    if (find(global.treasures_to_find,self) = nil) {
                        global.treasures_to_find += self;
                        global.treasures++;
                        // postpone cave closure if an extra treasure has
                        // been added to the list.
                        if(global.closure) {
                            if (toplocation(actor))
                                transcoord := toplocation(actor).analevel;
                            else
                                transcoord := 0;
                            if(transcoord != 0)
                                cancel_cave_closure(true,true);
                            else
                                cancel_cave_closure(nil,true);
                        }
                    }
                    global.origtreasures ++;
                    global.treasurelist += self;
                } 
                else if (addpoints){
                    global.pointobjlist += self;
                    global.pointobjs++;
                }

                if (addpoints) {
                    global.allpointlist += self; 
                    global.extras += addpoints;
                    global.maxscore += addpoints;
                    global.maxhiked := addpoints;
                }
            }
            // Special case: check for wine in the cask (which is a floating
            // item)
            if ((self = cask or cask.isInside(self)) and cask.haswine)
                global.checklist += wine_in_the_cask;

        }
        pass moveInto;
    }

    // The definition of the weight method now uses the mass property.
    // In a 350 or 550-point game, the weight is zero.  In a 551 or
    // 701-point game the weight is equal to the mass, or zero if the
    // item is worn.

    weight = {
        if(global.oldgame or self.isworn) return 0;
        else return self.mass;
    }
    mass = 1

// BJS: catac_room_num holds an object's location in the catacombs, so it
// won't show up in other rooms.
    catac_room_num = 0

/* methods to allow us to attempt to feed any item to a 'feedable' object. */
/* syntax is feed item to actor, feed actor with item */
/* These methods work in conjunction with those defined for the feedable
   class in ccr-room.t */

    verIoFeedWith (actor) = {}
    ioFeedWith (actor, dobj) = {dobj.doFeedWith (actor,self);}
;
;

// Implement missing 'turn off' method
modify lightsource
    doTurnoff(actor) =
    {
        local waslit := actor.location.islit;
        
        // turn off the light
        self.isActive := nil;
        self.islit := nil;
        "%You% switch%es% off <<self.thedesc>>. ";
        
        // if the room was previously lit, and it isn't now, issue a 
        // suitable message.
        if (waslit and not actor.location.islit) {
            P(); I(); "It is now pitch black.  If you proceed you
            will likely fall into a pit. ";
        }
    }
;
// class hiddenItem: object
// class hider: item
// class underHider: hider
// class behindHider: hider
// class searchHider: hider
// class fixeditem: thing      // An immovable object
modify fixeditem
/* Added as an additional check */
    verifyRemove( actor ) = {
        "%You% can't do that with "; self.thedesc; ". ";
    }
;

// class readable: item
// class fooditem: item
modify fooditem
    doEat( actor ) =
    {
        // DJP - special routine for troll, bear etc.
        if(actor <> parserGetMe()) {
            actor.doFeedWith(actor, self);
            return;
        }
        "That was delicious! ";
        // global.lastMealTime := global.lastMealTime - self.foodvalue;
        self.moveInto( nil );
    }
;
// class dialItem: fixeditem
modify dialItem
    doTurn( actor ) =
    {
        local stat,str,o,num,prompt,error;
        stat := outcapture(true);
        self.thedesc;
        str := outcapture(stat);
        prompt := 'To what number do you want to turn ' + str + '?\n>';
        error := 'That\'s not a valid number!';
        num := asknum(prompt,error);
        if(num = nil) return;
        else {
            numObj.value := num;
            self.doTurnTo(actor,numObj);
        }
    }
;

// class switchItem: fixeditem
// class room: thing
modify room
// Most customization now goes here, at the top-level room.
    // Method for dropping objects.  Customized with the new roomdroploc
    // property and global variable.
    roomDrop( obj ) =
    {
        if ( self.roomdroploc ) self.roomdroploc.roomDrop( obj ); // DJP
        else {
            if (not global.dropsilent) "Dropped. "; // DJP - added dropsilent
            obj.moveInto( self );
        }
    }

    //
    // Highlight the sdesc in room descriptions
    dispBeginSdesc = "\("
    dispEndSdesc = "\)"
 
    // dispBeginLdesc should be equivalent to P();
    dispBeginLdesc = {
        if(global.doublespace) "\b"; else "\n";
    }

    // dispParagraph made equivalent to P(); I();
    dispParagraph = {
        if(global.doublespace) "\b"; else "\n";
        if(global.indent) "\t";
    }

    //
    // By default, exits don't go anywhere.
    //
    // The directional ones call noexit, the standard TADS
    // "You can't go that way" method.
    //
    // The magic words print "Nothing happens."
    //
    // For the other words, the game tells the player it
    // doesn't know how to apply the word in the given
    // location.
    //
    jump = { "I don't see how that will help here."; return nil; }

    //
    // Directions
    //
    back = {
        /* This command is now implemented, and uses two methods to
        try to take you back to your previous location.

        Firstly, it looks for an exithints list of the form
        [ room1, &prop1, room2, &prop2, ... ]
        When attempting to go back to room1, the verb will use travel
        property &prop1 and so on.   The main use is to let the 'back'
        command know about travel properties which are methods.  The
        method may or may not succeed in taking you to the room, and
        there could be a special method to stop you from using 'back' in
        a particular room.

        Secondly, it looks through all the travel methods in exitlist.  If
        one of them is a simple object and evaluates to the desired room,
        the player is taken there.  (Note that destination properties
        of doors are NOT examined, because these might have side effects;
        all such destinations must therefore be included in the exithints
        list.)

        */
        local actor, room, newroom, exitlist;
        local p,r,i,j,l;
        actor := getActor(&travelActor);   // actor doing the travelling
        newroom := actor.prevloc;      // previous top-level room
        // directions to try for simple-object destinations.  Note that
        // magic words are not included.
        exitlist := [
            &north, &south, &east, &west,
            &ne, &nw, &se, &sw,
            &up, &down, &in, &out,
            &jump, &upstream, &downstream, &forwards, &outdoors,
            &left, &right, &middle, &cross, &over, &across, &road,
            &forest, &valley, &stairs, &building, &gully, &stream, &rock,
            &bed, &crawl, &cobble, &tosurface, &dark, &passage, &low,
            &canyon, &awkward, &giant, &view, &pit, &crack, &steps,
            &dome, &hall, &barren, &debris, &hole, &wall, &broken, &y2,
            &floor, &toroom, &slit, &slab, &depression, &entrance,
            &secret, &cave, &bedquilt, &oriental, &cavern, &shell,
            &reservoir, &fork, &chimney, &slide, &pool, &knoll,
            &ledge, &shelf, &thunder, &ice, &bridge, &altar,
            &grotto, &gate, &balcony, &gorge, &lair, &fourier, &jonah,
            &pentagram, &nondescript, &tube, &peelgrunt, &safe,
            &golden, &arabesque, &translucent
        ];
        // previous location not defined or same as current room
        if ((newroom = nil) or (room = newroom)) {
            "I'm sorry, but I can't quite remember %your% previous
            location.  You'll have to tell me which way to go. ";
            return nil;
        }
        room := actor.location;        // current room
        // look for exit hints list
        if (datatype(room.exithints) = 7) {
            l := length(room.exithints) / 2;
            for (i :=1; i <= l; i++) {
                j := i*2;
                r := room.exithints[j-1];  // destination room
                p := room.exithints[j];    // property
                if(r = nil) continue;      // ignore nil room
                if(datatype(p) <> 13) {    // check that p is a propptr
                    "Internal error in back command: invalid property
                    pointer in exithints list for room "; room.sdesc;". ";
                    return nil;
                }
                if(datatype(r) <> 2) {     // check that r is an object
                    "Internal error in back command: invalid room object
                    in exithints list for room "; room.sdesc;". ";
                    return nil;
                }
                if (r = newroom) {        // execute property p, which may
                    return room.(p);      // or may not evaluate to newroom
                }
            }
        }
        // Now go through all the exit properties and look for a
        // simple-object exit corresponding to the desired room.
        l := length(exitlist);
        for (i := 1;i <= l; i++) {
            p := exitlist[i];
            if (proptype(room,p) = 2) {
                r := room.(p);
                // handle doors
                if (r.isdoor) r := r.NPCdest;
                if (r = newroom) {
                    return newroom;
                }
            }
        }
        // if we've failed, print an appropriate message according to
        // the type of room.
        if (isclass(room,nestedroom) and not isclass(room,vehicle)) {
            "%You% can't return to <<newroom.sdesc>> until
            %you% get%s% "; self.outOfPrep;" "; self.thedesc; ". ";
            return nil;
        }
        else {
            "You'll need to tell me how to return
            to \"<<newroom.sdesc>>\" from here. ";
        }
    }

    in = {
        "I don't know what 'in' or 'enter' means here.  Use compass
        points or name something in the general direction you want to
        go. "; return nil;
    }
    out = {
        "I don't know what 'out' or 'exit' means here.  Use compass
        points or name something in the general direction you want to
        go. "; return nil;
    }
    upstream = { return self.doesnotapplyhere; }
    downstream = { return self.doesnotapplyhere; }
    forwards = { return self.doesnotapplyhere; }
    outdoors = { return self.doesnotapplyhere; }
    left = { return self.doesnotapplyhere; }
    right = { return self.doesnotapplyhere; }
    middle = { return self.doesnotapplyhere; }
    cross = { return self.doesnotapplyhere; }
    over = { return self.doesnotapplyhere; }
    across = { return self.doesnotapplyhere; }
    // DJP - changed
    climb = {"I'm not sure what you'd want to climb - please give me
            more specific instructions. "; return nil;}
    // Climb up and down default to up and down unless overridden
    climbup = {return self.up;}
    climbdown = {return self.down;}

    //
    // Default responses to magic words
    //
    xyzzy = { return self.nothinghappens; }
    plugh = { return self.nothinghappens; }
    plover = { return self.nothinghappens; }
    phuce = {
        "Nothing happens.  ";
        if (not global.phuced) {
            "I'm not surprised, because most elfin magic doesn't work for
            humans.  On the other hand, some spells may work if you
            cast them where elves have used the same magic before. ";
        }
        global.phuced := true;
    }
    pray = {"There is no obvious answer to %your% prayers.";
            return nil;}
    smichel = { return self.nothinghappens; }
    phleece = { return self.nothinghappens; }
    reflect = { return self.nothinghappens; }
/* this method is only accessed when the slippers are worn */
    click = {"%You% click%s% the heels of the slippers.  You feel a
             slight tingling sensation, but nothing else happens.";
             return nil;}
    thurb = { return self.nothinghappens; }
    //
    // Feature names
    //
    // These mostly allow limited travel to prominent locations.
    //
    //
    road = { return self.doesnotapplyhere; }
    forest = { return self.doesnotapplyhere; }
    valley = { return self.doesnotapplyhere; }
    stairs = { return self.doesnotapplyhere; }
    building = { return self.doesnotapplyhere; }
    gully = { return self.doesnotapplyhere; }
    stream = { return self.doesnotapplyhere; }
    rock = { return self.doesnotapplyhere; }
    bed = { return self.doesnotapplyhere; }
    crawl = { return self.doesnotapplyhere; }
    cobble = { return self.doesnotapplyhere; }
    tosurface = { return self.doesnotapplyhere; }
    dark = { return self.doesnotapplyhere; }
    passage = { return self.doesnotapplyhere; }
    low = { return self.doesnotapplyhere; }
    canyon = { return self.doesnotapplyhere; }
    awkward = { return self.doesnotapplyhere; }
    giant = { return self.doesnotapplyhere; }
    view = { return self.doesnotapplyhere; }
    pit = { return self.doesnotapplyhere; }
    crack = { return self.doesnotapplyhere; }
    steps = { return self.doesnotapplyhere; }
    dome = { return self.doesnotapplyhere; }
    hall = { return self.doesnotapplyhere; }
    barren = { return self.doesnotapplyhere; }
    debris = { return self.doesnotapplyhere; }
    hole = { return self.doesnotapplyhere; }
    wall = { return self.doesnotapplyhere; }
    broken = { return self.doesnotapplyhere; }
    y2 = { return self.doesnotapplyhere; }
    pantry = { return self.doesnotapplyhere; }
    floor = { return self.doesnotapplyhere; }
    toroom = { return self.doesnotapplyhere; }
    slit = { return self.doesnotapplyhere; }
    slab = { return self.doesnotapplyhere; }
    depression = { return self.doesnotapplyhere; }
    entrance = { return self.doesnotapplyhere; }
    secret = { return self.doesnotapplyhere; }
    cave = { return self.doesnotapplyhere; }
    bedquilt = { return self.doesnotapplyhere; }
    oriental = { return self.doesnotapplyhere; }
    cavern = { return self.doesnotapplyhere; }
    shell = { return self.doesnotapplyhere; }
    reservoir = { return self.doesnotapplyhere; }
    main = { return self.doesnotapplyhere; }
    office = { return self.doesnotapplyhere; }
    fork = { return self.doesnotapplyhere; }
    chimney = { return self.doesnotapplyhere; }
    slide = { return self.doesnotapplyhere; }
    pool = { return self.doesnotapplyhere; }
    knoll = { return self.doesnotapplyhere; }
    ledge = { return self.doesnotapplyhere; }
    thunder = { return self.doesnotapplyhere; }
    ice = { return self.doesnotapplyhere; }
    bridge = { return self.doesnotapplyhere; }
    altar = { return self.doesnotapplyhere; }
    grotto = { return self.doesnotapplyhere; }

    row = { if (Boat.isVisible(global.travelActor)) {
              "The boat's oars were stolen by the dwarves to play
              bing-bong.  (That's dwarvish ping-pong -- with rocks!). ";
              "%You%'d better find another way to propel the boat.";
              return nil;
              }
            else return self.doesnotapplyhere;
    }
    gate = { return self.doesnotapplyhere; }
    boat_north = { return nil; }
    boat_south = { return nil; }
    boat_east = { return nil; }
    boat_west = { return nil; }
    boat_ne = { return nil; }
    boat_se = { return nil; }
    boat_nw = { return nil; }
    boat_sw = { return nil; }
    balcony = { return self.doesnotapplyhere; }
    gorge = { return self.doesnotapplyhere; }
    lair = { return self.doesnotapplyhere; }
    fourier = { return self.doesnotapplyhere; }
    jonah = { return self.doesnotapplyhere; }
    pentagram = { return self.doesnotapplyhere; }
    nondescript = { return self.doesnotapplyhere; }
    tube = { return self.doesnotapplyhere; }
    peelgrunt = { return self.doesnotapplyhere; }
    safe = { return self.doesnotapplyhere; }
    golden = { return self.doesnotapplyhere; }
    arabesque = { return self.doesnotapplyhere; }
    translucent = { return self.doesnotapplyhere; }
    nopendant = {
        local actor := getActor(&travelActor);
        if (pendant.location = actor and pendant.isworn) {
            "The pendant seems to whisper to your mind: 
            \"Security error 1:  Intended destination is outside the permitted
            operating zone for this pendant. \"";
            return nil;
        }
        else return self.nothinghappens;
    }
    ana = {return self.nopendant; }
    kata = {return self.nopendant; }
    // versions of ana/kata to be used when the green pendant is worn:
    ana2 = {return ana;}
    kata2 = {return kata;}   
    
    // versions of ana/kata to be used when the orange pendant is worn:
    // by default, the methods return either ana/kata or ana2/kata2, depending
    // on whether the green pendant is worn.  If the room has the isdotroom
    // property set to true, the player can travel as if he is wearing all
    // the pendants.
    ana3 = {
        local actor := getActor(&travelActor), toploc := toplocation(actor);
        if (toploc.isdotroom or ((pendant2.location = actor) and 
        pendant2.isworn))
             return ana2;
        else
             return ana;
    }
    kata3 = {
        local actor := getActor(&travelActor), toploc := toplocation(actor);
        if (toploc.isdotroom or ((pendant2.location = actor) and 
        pendant2.isworn))
             return kata2;
        else
             return kata;
    }



    nothinghappens = {
        "Nothing happens.";
        return nil;
    }
    doesnotapplyhere = {
        "I don't know how to apply that word here.";
        return nil;
    }
    nofourd(v) = {
        "Nothing happens.  Old Elvish lore claimed 
        that the magic words  \"ana\" and \"kata\" could transport you
        between parallel worlds, linked by a fifth dimension called
        \"Transindection\".  It was rumored that the Wumpus entered the cave by
        this means. ";
        if (v.seenspecial) {
            "I used to dismiss all these tales as old myths, but now 
            I'm not sure.  When you transported the sapphire into the castle,
            you saw something you weren't meant to see.  Namely, the use of 
            \"kata\" for some kind of teleportation. ";
        }
        else {
            "However, the general view nowadays is that it's just an old myth.
            No-one has demonstrated the existence of the dimension, let alone
            found any way to travel through it! ";
        }
        return nil;
    }

    //
    // Exits for NPC's.  Since NPC's won't take regular exits
    // that are methods (instead of simple object names), we
    // have to add "hints" in some rooms to allow complete access
    // to all rooms.  By default, these are all nil.  (Note that
    // it is important for them to be nil objects, and not methods
    // that return nil.  If they are methods, NPC's will try them.)
    //
    NPCexit1 = nil
    NPCexit2 = nil
    NPCexit3 = nil
    NPCexit4 = nil
    NPCexit5 = nil
    NPCexit6 = nil
    NPCexit7 = nil
    NPCexit8 = nil
    NPCexit9 = nil
    NPCexit10 = nil
    NPCexit11 = nil
    NPCexit12 = nil

    //
    // Each room has a list of exit properties that can be considered by
    // NPC's.  The lists is determined at preinit time by looking at all the
    // exit properties and discarding those that are not simple object
    // definitions, e.g. "east = Giant_Room" or "north = Rusty_Door".
    // Exits which are defined as rooms (or doors) with the noNPCs property
    // set to true are also discarded.
    //

    // Note that the NPCexits are always considered, whether they are methods
    // or not, since they're guaranteed not to print anything or
    // change game state when they're run.
    //
    // Note that the list contains travel properties, not locations,
    // e.g. [ &west, &up ... ], not [ At_Y2, In_Hall_Of_Mists ..]
    //
    NPCexits = []


    /* DJP - set size of brass key as seen in this room */
    brasskey = small_key

    /* DJP - new method to check the validity of a room for NPC's */

    NPCvalid = (not (self.noNPCs or self.deleted or self.version_NoNPCs))

    // Rooms may also have a list of 'exit hints' like this:
    // exithints = [room1, &prop1, room2, &prop2 ... ]
    // It is currently used by the 'back' command to find a travel method
    // which can be used in an attempt to return to a particular room.

    // The default listendesc searches for objects which are likely
    // to make a noise.  Set global.listenadd if you want to incorporate
    // these extras in a customized listendesc method, and you don't want
    // the 'You hear nothing unexpected' message.
    listendesc = {
        local count := 0;
        if (little_bird.isIn(self) and little_bird.location <>
        wicker_cage) {
            count++;
            P(); little_bird.listendesc;
        }
        if (Stream.isIn(self)) {
            count++;
            P(); Stream.listendesc;
        }
        if (Phone1.isIn(self) and Phone1.isringing) {
            count++;
            P(); Phone1.listendesc;
        }
        if (Phone2.isIn(self) and Phone2.isringing) {
            count++;
            P(); Phone2.listendesc;
        }
        if (Blob.isIn(self) and ((Blob.chase <= 1) or (Blob.chase > 4) )) {
            count++;
            P(); Blob.listendesc;
        }
        if (count = 0 and not global.listenadd)
            "You hear nothing unexpected. ";
    }

/*
 * Replace the nrmLkAround method to list ordinary objects and treasures
 * separately, using a modified version of the listcont function.
 */
    nrmLkAround( verbosity ) =      // lookAround without location status
    {
        local l, ll, cur, i, tot, tott;
        local treaslist, ordlist;
        local outhideStatus;
        treaslist := [];
        ordlist := [];
        if ( verbosity )
        {
            self.dispBeginLdesc;
            self.ldesc;
            self.dispEndLdesc;
        }

        /* DJP: modified to use heredesc regardless of verbosity, and to
        include floating items with heredesc methods defined. */

        ll := self.allherecontents;  // DJP
        tott := length( ll );
        i := 1;
        while ( i <= tott )
            {
                cur := ll[i];
                // modified to support a special has_heredesc flag
                // note that the heredesc method must contain a paragraph
                // separator, if required.
                if ( cur.isfixed or cur.has_heredesc) cur.heredesc;
                i := i + 1;
            }

        l := self.contents;
        tot := length( l );
        i := 1;
        while ( i <= tot )
        {
            cur := l[i];
            if (cur.isListedinRoom){
                if (isclass(cur, CCR_treasure_item))treaslist += cur;
                else ordlist += cur;
            }
            i := i + 1;
        }
        if (length( ordlist) > 0)
        {
            self.dispParagraph;
            "You see "; listlist( ordlist, ordlist ); " here. ";
        }
        if (length( treaslist) > 0)
        {
            self.dispParagraph;
            "You see "; listlist( treaslist, treaslist ); " here! ";
        }

        // if listcontcont outputs text, precede it with the paragraph
        // separator.
        outhideStatus := outhide(true);
        listcontcont(self);
        if (outhide(outhideStatus)) {
                self.dispParagraph;
                listcontcont(self);
        }

        // DJP - eliminated duplicate assignments for l and tott
        i := 1;
        while ( i <= tott )
        {
            cur := ll[i];
            if ( cur.isactor )
            {
                if ( cur <> parserGetMe())
                {
                    // If the actordesc property outputs text, precede
                    // it with the paragraph separator
                    outhideStatus := outhide(true);
                    cur.actorDesc;
                    if (outhide(outhideStatus)) {
                        self.dispParagraph;
                        cur.actorDesc;
                    }
                }
            }
            i := i + 1;
        }
        "\n";
    }
    // DJP - method to determine whether there's a light source in this room
    lamplit = {return inherited darkroom.islit;}
    // DJP - coordinate for transindectional (four-dimensional) travel
    analevel = 0
    // default transindection method (see nestedroom)
    moveme(prop) = {
        if (datatype(prop) = 13)
            return self.(prop);
        else
            return prop;
    }
    transmove(prop) = {
        if (datatype(prop) = 13)
            return self.(prop);
        else
            return prop;
    }
;

// class darkroom: room        // An enterable area which might be dark
modify darkroom
    replace roomAction( actor, v, dobj, prep, io ) =
    {
        // DJP - vet the 'put', 'change' and 'replace' verbs to allow
        // batteries to be changed, but no other actions.
        if (v = putVerb and not self.islit) {
            if (isclass(dobj,fresh_batteries) and prep = inPrep and
            io = brass_lantern and brass_lantern.isReachable(parserGetMe()) and
            dobj.isReachable(parserGetMe())) {
                pass roomAction;
            }
            else {
                "It's pitch black.\n";
                exit;
            }
        }
        if ((v = lookInVerb) and not self.islit) {
            if ((dobj = crystal_ball) and dobj.isReachable(parserGetMe())) {
                pass roomAction;
            }
            else {
                "It's pitch black.\n";
                exit;
            }
        }
        if ((v = changeVerb or v=replaceVerb) and not self.islit) {
            if (isclass(dobj,fresh_batteries) and 
            brass_lantern.isReachable(parserGetMe())
            and dobj.isReachable(parserGetMe())) {
                pass roomAction;
            }
            else {
                "It's pitch black.\n";
                exit;
            }
        }
        // allow dropping in the dark but not 'drop on' or 'drop in'
        if ((v = dropVerb) and (not self.islit) and (io <> nil)) {
            "It's pitch black.\n";
            exit;
        }
        if ( not self.islit and not v.isDarkVerb)
        {
            "%You% can't see a thing. ";
            exit;
        }
        else pass roomAction;
    }
    replace noexit = // DJP - modified to give a different message when wrong 
                     // directions are used in the dark.
    {
        if ( self.islit ) pass noexit;
        else "You stumble around, but go nowhere. ";
    }
    lookAround( verbosity ) =
    {
            // DMB: Changed pitch dark message
            // DJP: Added check for blinding room.
        if ( self.islit and not self.blinding ) pass lookAround;
        if ( self.blinding) {
            "\(Blinding Room\)"; P(); "The glare from the walls is absolutely
            blinding.  If you tried to proceed you would almost certainly fall
            into a pit.";
        }
        else {
            "\(In the Dark\)"; P(); "It is now pitch dark.
            If you proceed you will likely fall into a pit.";
        }
    }
;
// theFloor: beditem, floatingItem
/* DJP - extensive customizations to the floor; for example, it uses the
makecontents class and has several changes, e.g. special code to handle 'put 
vase on floor'. */
replace theFloor: beditem, makecontents
    onroom = true       // DMB so it won't say "in the ground"
    noun = 'floor' 'ground'
    // DJP change description to 'floor' within building and any room
    // with the hasfloor property
    sdesc = {
        local toploc := toplocation(parserGetMe());
        if (toploc.hasfloor) "floor"; else "ground";
    }
    // DJP change long description.  If the hasfloordesc property is
    // described for the top-level room, the floor is described with
    // the floordesc property.
    ldesc = {
        local toploc := toplocation(parserGetMe());
        if (toploc.hasfloordesc) toploc.floordesc; else {
            "You see nothing unusual about ";self.thedesc;".  ";
        }
    }
    adesc = {"the ";self.sdesc;}
    // DJP - the location is normally the top-level room of the current
    // actor.  If the player is located in the floor, the location is 
    // obtained from the sitloc property.
    location =
    {
        local actor,toploc;
        if(global.currentActor) 
            actor := global.currentActor;
        else
            actor := parserGetMe();
        if ( parserGetMe().location = self )
            return self.sitloc;
        else {
            toploc := toplocation(actor);
            if (toploc = nil) return nil;
            if (not toploc.nofloor)
                return toploc;
            else
                return nil;
        }
    }
    reachable = {  // DJP - everything in the room will be reachable
        return self.location.allcontents;
    }

    canReachContents = true // DJP - give access to contents of containers

    locationOK = true        // suppress warning about location being a method
    //
    // Note that these methods will need to be changed if we ever allow actors
    // other than the player to sit on the floor!
    //
    doSiton( actor ) =
    {
        "Okay, %you're% now sitting on "; self.thedesc; ". ";
        self.sitloc := toplocation(actor); // DJP
        actor.moveInto( self );
        actor.posture := 'sitting';
    }
    doLieon( actor ) =
    {
        // DMB changed so it says "lying."
        "Okay, %you're% now lying on "; self.thedesc; ". ";
        self.sitloc := toplocation(actor); // DJP
        actor.moveInto( self );
        actor.posture := 'lying';  
    }
    // standing on the floor is the same as getting off the floor
    // disallow if the player is already standing in the room or is
    // located in a nestedroom other than the floor
    verDoStandon( actor ) = {  // DJP - added
        if (actor.location <> toplocation(actor)) {
            if (actor.location = self) return;
            "%You%'ll have to get "; 
            if (actor.location.onroom)
                "off "; 
            else 
                "out of "; 
            actor.location.thedesc; " first. ";
        }
        else "%You're% already standing on <<self.thedesc>>.";
    }
    doStandon ( actor ) = {
        self.doUnboard (actor);
    }
    
    // Changed so that we get an explanation for the vase breaking when
    // we attempt to put it on the floor.
    ioPutOn( actor, dobj ) =
    {
        if (self.checksmash(actor,dobj,onPrep,droploc(actor))) // DJP
            dobj.doDrop( actor );
    }
    ioPutIn( actor, dobj ) =
    {
        self.ioPutOn( actor );
    }

    // DJP add sweeping and cleaning methods
    doCleanWith( actor, io ) =
    {
        if(io = whiskbroom) {
            if(toplocation(actor) = Bat_Cave) {
                Guano.sweepmess;
            }
            else if(toplocation(actor) = In_Dusty_Rock_Room and not
            DustyRocks.areswept) DustyRocks.sweep;
            else "Enough dusting, already!  You're making me sneeze.";
        }
        else pass doCleanWith;
    }
    doSweepWith( actor, io ) =
    {
        if(io = whiskbroom) {
            if(toplocation(actor) = Bat_Cave) {
                Guano.sweepmess;
            }
            else if(toplocation(actor) = In_Dusty_Rock_Room and not
            DustyRocks.areswept) DustyRocks.sweep;
            else "Enough dusting, already!  You're making me sneeze.";
        }
        else pass doSweepWith;
    }
    meIsMovingInto(meActor) =  // for TADS v2.5.6 and later
    {
        /*
         *   When the player character object is explicitly moved into
         *   theFloor, we must set our sitloc property to the player
         *   character's old location.  Since we're floating, we don't
         *   have a location ourselves, so we use sitloc to keep track of
         *   the effective container that the player should see when
         *   moving back out of the floor. 
         */
        self.sitloc := toplocation(meActor); // DJP
    }
    // Handle transindection movements while lying on the floor
    transmove(prop) = {
        if(not (self = theFloor)) pass transmove; 
        return self.moveme(prop);
    }
    // Special method for moving the player from the floor of one room
    // to the floor of another.
    moveme(prop) = {
        local actor := getActor(&travelActor);
        local dest;
        // Work out the destination (and maybe print out text)
        if(datatype(prop) = 13)
            dest := self.location.(prop);
        else
            dest := prop;
        if (dest) {
            // If there's no floor in the new room, return the room instead.
            if(dest.nofloor) return dest;
            // Move the actor into the destination room, then 
            // return the floor as the new location.
            actor.moveInto(dest);
            self.meIsMovingInto(actor);
            // Adjust isseen properties for containing
            // room.
            self.isseen := dest.isseen;
            if (not dest.isseen)dest.firstseen;
            dest.isseen := true;
            return self;
        }
        else return nil;
    }

;
// class Actor: fixeditem, movableActor
// class movableActor: qcontainer // A character in the game
modify movableActor      // code to save prevloc for actors, e.g. Wumpus
    isHim = true         
    actorAction( v, d, p, i ) = {
// DJP - allow actor, eat xxx, and actor, take xxx; these are handled using
// appropriate methods.
        if(isclass(self,feedable) and v=eatVerb and p=nil and i=nil)
            return;
        if(v=takeVerb and p=nil and i=nil) return;

        caps(); self.thedesc; " doesn't appear interested. ";
        exit;
    }
    lastmoveloc = nil
    lasttoploc = nil
    moveInto( obj ) = {
        local oldloc, newloc := toplocation(obj);
        // reset posture variable if location is being changed
        if (obj != self.location) {
             if(obj) self.posture := obj.default_posture;
             else self.posture := nil;
        }
        if(lastmoveloc = nil) {
             lastmoveloc := self.location;
             lasttoploc := toplocation(lastmoveloc);
        }
        oldloc := lasttoploc;

        // DJP - save previous topmost location.
        if(oldloc <> newloc) {
            self.prevloc := oldloc;
        }
        // Moves into and out of nestedrooms are ignored, but a move from
        // a top-level room to the same room is acknowledged.
        if(lastmoveloc = obj and newloc = obj) {
            self.prevloc := oldloc;
        }
        lastmoveloc := obj;
        lasttoploc := toplocation(lastmoveloc);
        // Pass control to the original movableActor.moveInto
        // method in adv.t.
        pass moveInto;
    }
    disavow = "You can't expect <<self.thedesc>> to be able to answer
        questions." // DJP (most actors are non-human)

    // Enhanced travelTo method:
    // The argument list is:
    // room, propptr, refloc, nocheck   
    // All arguments after the first are optional and default to nil.
    // propptr  - pointer to a travel property e.g. &north.  If this is non-nil
    //            the destination will be room.(propptr) instead of 
    //            room. 
    // refloc   - if non-nil, put a dummy reference actor in this room for
    //            the purpose of evaluating location methods.
    // nocheck  - if true, allow the actor to go anywhere at closing time.
    //            This is forced to true unless the actor has the 
    //            closerestrict method set to true.
 
    // The advantage of the propptr argument is that it allows travelTo to
    // set global variables before the travel property is evaluated.  If the
    // property is a method, it may then use the global variables e.g. to
    // issue different messages, depending on which actor is being moved.

    // The following properties are set in the global object:

    // currentActor - the actor for the purpose of evaluating location methods.
    // travelActor - the actor doing the travelling.

    travelTo(obj,...) = {
        local room;
        local old_loc_visible;
        local new_loc_visible;

        local toproom, propptr := nil, refloc := nil, nocheck := nil;
        local travelsave, currentsave, dummylocsave;

        if (argcount > 1) propptr := getarg(2);
        if (argcount > 2) refloc := getarg(3);
        if (argcount > 3) nocheck := getarg(4);
        if (not self.closerestrict) nocheck := true;    
    
        travelsave := global.travelActor;
        currentsave := global.currentActor;
        dummylocsave := DummyActor.location;

        global.travelActor := self;

        if (refloc) {
             global.currentActor := DummyActor;
             DummyActor.location := refloc;
        }
        else 
             global.currentActor := self;

        if (propptr) {
            if(not datatype(propptr) = 13) {
                "Error: second argument to <<self.sdesc>>.travelTo is not a 
                property pointer. ";
                abort;
            }
            room := obj.(propptr);
        }
        else
            room := obj; 

        global.travelActor := travelsave;    
        global.currentActor := currentsave;   
        DummyActor.location := dummylocsave;  

        /* do nothing if going nowhere */
        if (room = nil)
            return;

        /* handle doors using the new-style argument list */
        if ( room.isobstacle )
        {
            self.travelTo( room,&destination,refloc,nocheck );
            return;
        }

        toproom := toplocation(room);

        /* check that the room is valid for this game version. */
        if (room.deleted) {
            "\n\t<<self.thedesc>> can't go that way in this version of 
            the game. ";
            return;
        }

        /* check for attempts to leave the cave when it's closing, or
           to re-enter after escaping from the Cylindrical room */
        if(not nocheck) {
            // Check if we're trying to escape from the cave when it's
            // closing.
            if (global.closed and room.isoutside and not room.isobstacle and
            not self.location.isoutside) {
                global.closingmess;
                return;
            }
    
            /* Check if we're trying to re-enter the cave after escaping from
             * the Cylindrical Room (550-point version)
             */
            if (global.closed and self.location.isoutside and
            not room.isoutside and not room.isobstacle) {
                global.closingmess;
                return;
            }
        } /* not nocheck */

        /* note whether the actor was previously visible */
        old_loc_visible := (self.location != nil
                            && parserGetMe().isVisible(self.location));

        /* note whether the actor will be visible in the new location */
        new_loc_visible := parserGetMe().isVisible(room);

        /* 
         *   if I'm leaving the player's location, and I was previously
         *   visible, and I'm not going to be visible after the move, and
         *   the player's location isn't dark, show the "leaving" message 
         */
        if (parserGetMe().location != nil
            && parserGetMe().location.islit
            && old_loc_visible
            && !new_loc_visible)
            self.sayLeaving;
        
        /* move to my new location */
        self.moveInto(room);

        /* 
         *   if I'm visible to the player at the new location, and I
         *   wasn't previously visible, and it's not dark, show the
         *   "arriving" message 
         */
        if (parserGetMe().location != nil
            && parserGetMe().location.islit
            && new_loc_visible
            && !old_loc_visible)
            self.sayArriving;
    }
    vehicleTravel(moveprop,dest,...) = {
        // Moves the player normally if he's in a top-level room, or (maybe)
        // conveys the player in a nestedroom within which he is located.
        //
        // The first argument should usually be one of
        // &moveme - by default, this will convey the nestedroom regardless
        //           of whether it is a fixed item.
        // &transmove - by default, convey the nestedroom only if it is a 
        //           transportable item (isfixed=nil or istransportable=true)
        //           otherwise the player is moved to the destination room and
        //           the nestedroom is left behind.
        // 
        // The second argument (dest) is the destination to which the player, 
        // or the player's container, is to be moved.
        //
        // The third argument is optional, and must be a property pointer if
        // given.  It specifies that the destination will be dest.(prop).
        //
        local prop, travelsave := global.travelActor;
        local currentsave := global.currentActor;
        if(argcount > 3) prop := getarg(3);
        global.travelActor := self;
        global.currentActor := self;
        if (prop != nil) dest := dest.(prop);
        self.travelTo(self.location.(moveprop)(dest));
        global.travelActor := travelsave;
        global.currentActor := currentsave;
    }
    roomMoveTravel(moveprop,dest,...) = {
        // Similar to vehicleTravel, but all portable objects are moved
        // to the new room.  (The contents of non-portable containers are
        // not moved.)
        local prop, travelsave := global.travelActor;
        local currentsave := global.currentActor;
        if(argcount > 3) prop := getarg(3);
        global.travelActor := self;
        global.currentActor := self;
        if (prop != nil) dest := dest.(prop);
        room_move(toplocation(self), toplocation(dest));
        self.travelTo(self.location.(moveprop)(dest));
        global.travelActor := travelsave;
        global.currentActor := currentsave;
    }
;

// class follower: Actor
// class basicMe: Actor, floatingItem
modify basicMe
    panicked = nil  // has the player panicked after closing time?

    // The original 350-point code only allowed the player to carry
    // seven objects at a time.  Weight wasn't taken into
    // consideration.   This has now been changed.  In the 551-point
    // version, weight as well as bulk are taken into consideration.
    // (In the Fortran version only weight was considered).  You can
    // still carry only 7 objects in your hands (unless you have very
    // bulky items like the clam) , but the sack allows
    // you to carry more, up to your weight limit.  Items which are
    // worn don't count towards the total weight.

    noun = 'self'

    maxbulk = 7
    maxweight = 20
    ldesc = {
        if(mushroom.is_eaten) {
            I(); "Your muscles are bulging unbelievably.";
        }
        if(global.newgame and self.health < 95) {
            healthVerb.action(self);
        }
        else if (not mushroom.is_eaten) {
            I(); "You look much the same as always.";
        }
    }
    // This counts how many portions of blueberries have been eaten
    blueberries_eaten = 0

    //
    // Give the player points for getting a fair ways into
    // the cave.
    //
    awardedpointsforgettingfarin = nil

    closerestrict = true // check travel destination at closing time.

    // Enhanced travelTo method:
    // The argument list is:
    // room, propptr, refloc, nocheck   
    // All arguments after the first are optional and default to nil.
    // propptr  - pointer to a travel property e.g. &north.  If this is non-nil
    //            the destination will be room.(propptr) instead of 
    //            room. 
    // refloc   - if non-nil, put a dummy reference actor in this room for
    //            the purpose of evaluating location methods.
    // nocheck  - if true, allow the actor to go anywhere at closing time.
    //            This is forced to true unless the actor has the 
    //            closerestrict method set to true.
 
    // The advantage of the propptr argument is that it allows travelTo to
    // set global variables before the travel property is evaluated.  If the
    // property is a method, it may then use the global variables e.g. to
    // issue different messages, depending on which actor is being moved.

    // The following properties are set in the global object:

    // currentActor - the actor for the purpose of evaluating location methods.
    // travelActor - the actor doing the travelling.

    replace travelTo(obj,...) = {
        local room;
        local toproom, propptr := nil, refloc := nil, nocheck := nil;
        local travelsave, currentsave, dummylocsave;

        // If this object is not the player character, use the non-player
        // travelTo method.
        if (self <> parserGetMe()) {
            pass travelTo;
        }

        if (argcount > 1) propptr := getarg(2);
        if (argcount > 2) refloc := getarg(3);
        if (argcount > 3) nocheck := getarg(4);
        if (not self.closerestrict) nocheck := true;    

        travelsave := global.travelActor;
        currentsave := global.currentActor;
        dummylocsave := DummyActor.location;

        global.travelActor := self;

        if (refloc) {
             global.currentActor := DummyActor;
             DummyActor.location := refloc;
        }
        else 
             global.currentActor := self;

        if (propptr) {
            if(not datatype(propptr) = 13) {
                "Error: second argument to travelTo is not a property 
                pointer. ";
                abort;
            }
            room := obj.(propptr);
        }
        else
            room := obj;

        global.travelActor := travelsave;    
        global.currentActor := currentsave;   
        DummyActor.location := dummylocsave;  

        /* do nothing if going nowhere */
        if (room = nil)
            return;

        /* if it's an obstacle (i.e. a door), travel to the obstacle's
           destination property instead */
        if ( room.isobstacle )
        {
            self.travelTo( room,&destination,refloc,nocheck );
            return;
        }

        toproom := toplocation(room);

        /* check that the room is valid for this game version. */
        if(room.deleted) {
            "%You% can't go that way in this version of the game. ";
            return;
        }

        /* check for attempts to leave the cave when it's closing, or
           to re-enter after escaping from the Cylindrical room */

        if(not nocheck) {
            // Check if we're trying to escape from the cave when it's
            // closing.
            if (global.closed and room.isoutside and not 
            self.location.isoutside) {
    
                global.closingmess;
    
                if (not self.panicked) {
                    self.panicked := true;
    
                    //
                    // We have reverted to the original behavior of the
                    // Fortran code which set the endgame timer to 15
                    // (rather than incrementing it by 15 which seems
                    // unkind to the player).  However a check has now
                    // been added to stop global.bonustime from being changed
                    // after full closure.
    
                    if (not global.fully_closed) { 
                        global.bonustime := global.panictime;  // DJP
                    }
                }
    
                return;     // no pass travelTo
            }
    
            /* Check if we're trying to re-enter the cave after escaping from
             * the Cylindrical Room (550-point version)
             */
            if (global.closed and self.location.isoutside and
            not room.isoutside and not room.isobstacle) {
                global.closingmess;
            
                /* "A mysterious recorded voice groans into life
                and announces, \"This entrance is closed.  Please
                report to the treasure room via the alternate
                entrance to claim your treasure.\""; */
    
                return;         // no pass travelTo
            }
        } /* not nocheck */

        /* Check the top-level room for bonus points */
        if (not toproom.notfarin) {
            if (not self.awardedpointsforgettingfarin) {
                incscore(global.farinpoints,
                'for getting well into the cave');
                self.awardedpointsforgettingfarin := true;
            }
            if (not global.NPCstarted and not global.nodwarves) {
                global.NPCwaitmoves -= 1;
                if (global.NPCwaitmoves <= 0) {
                    if (rand(100) <= global.NPCprob) dwarfstart(0);
                }
            }
        }

        if (toproom.isbonus and not toproom.bonusawarded) {
            incscore(global.extenpoints,
            'for entering a room with bonus points');
            toproom.bonusawarded := true;
            if (toproom.isbonus_addmax) {
                global.maxscore += global.extenpoints;
                global.extras += global.extenpoints;
            }
        } // give points for crossing volcano, etc.

        // DJP - modified dark travel procedure (dark travel
        // is permitted but we might fall into a pit.)
        global.fellpit := nil;
        if ( not ( self.location.islit or room.islit ))
            darkTravel();
        if ( not global.fellpit) {
            if ( self.location ) self.location.leaveRoom( self );
            self.moveInto(room); // DJP - use customized MoveInto
                                 // method for all travel
            room.enterRoom( self );
        }
        // DJP - Warn if the lamp is left on when wandering outside
        // in lit rooms, except in certain rooms near entrances, or
        // when the message has already been issued.
        if (not self.lamplitwarn and toproom.isoutside
        and not toproom.nolampwarn and not isclass(toproom,darkroom)) {
            if (brass_lantern.isIn(self) and brass_lantern.islit) {
                P(); I();
                "You know, you are wasting your batteries by
                wandering around out here with your light on.";
                self.lamplitwarn := true;
            }
        }
        // Allow the warning message to appear again once the
        // player enters a dark room.
        if (isclass(toproom,darkroom))
            self.lamplitwarn := nil;
    }
    moveInto(room) = {
        // In Polyadv, the player character's moveInto does a number of
        // things besides moving the character.  It swaps the brass keys
        // around (551-point game), keeps track of the player's previous
        // location and travel route code for the BACK command and NPC code.
        // If the floorvoc and/or floorvoca properties are set for the room,
        // they define extra nouns and adjectives which may be used to refer
        // to TheFloor.

        local i,l,word,oldkey, newkey, oldvoc, oldvoca, newvoc, newvoca;
        local oldloc, newloc := toplocation(room);
        // reset posture variable if location is being changed
        if (room != self.location) {
             if(room) self.posture := room.default_posture;
             else self.posture := nil;
        }
        if(lastmoveloc = nil) {
             lastmoveloc := self.location;
             lasttoploc := toplocation(lastmoveloc);
        }
        oldloc := lasttoploc;
        oldvoc := oldloc.floorvocab;
        newvoc := newloc.floorvocab;
        oldvoca := oldloc.floorvocaba;
        newvoca := newloc.floorvocaba;
        if (newvoc != oldvoc) {
            // remove old floor nouns
            if (oldvoc) {
                l := length(oldvoc);
                for (i := 1; i <=l; i++) {
                    word := oldvoc[i];
                    delword(theFloor,&noun,word);
                }
            }
            // add new floor nouns
            if (newvoc) {
                l := length(newvoc);
                for (i := 1; i <=l; i++) {
                    word := newvoc[i];
                    addword(theFloor,&noun,word);
                }
            }
        }
        if (newvoca != oldvoca) {
            // remove old floor adjectives
            if (oldvoca) {
                l := length(oldvoca);
                for (i := 1; i <=l; i++) {
                    word := oldvoca[i];
                    delword(theFloor,&adjective,word);
                }
            }
            // add new floor adjectives
            if (newvoca) {
                l := length(newvoca);
                for (i := 1; i <=l; i++) {
                    word := newvoca[i];
                    addword(theFloor,&adjective,word);
                }
            }
        }
        // Check that this object is the player character
        if (self = parserGetMe()) {
            // DJP - adjust size of brass key.  (We could use addword/delword
            // but instead we have 3 keys and switch them around.  This
            // will make it easier if we want to give them different
            // properties - for example, the large key could be heavier.)
            if(not (oldloc = nil) and not (newloc = nil) ) {
                oldkey := oldloc.brasskey;
                newkey := newloc.brasskey;
                if((oldkey <> nil) and (newkey <> nil) and oldkey <> newkey)
                    obj_switch(oldkey,newkey);
            }
        }

        // Save the travel route and previous travel route
        // (currently used only for the purpose of backtracking detection when
        // the Wumpus is chasing the player).
        if(oldloc <> newloc) {
            self.prevloc := oldloc;
            if(self.nextRoute <> nil) {
                self.previousRoute := self.travelRoute;
                self.travelRoute := self.nextRoute;
            }
        }

        // DJP - save previous topmost location.
        // Moves within the same topmost room (e.g. when sitting on the
        // Y2 rock) are ignored, but a move from a top-level room to the
        // same top-level room (through a looping passage) is acknowledged.
        if(lastmoveloc = room and newloc = room) {
            self.prevloc := oldloc;
            if(self.nextRoute = nil or self.nextRoute = 0) {
                self.previousRoute := self.travelRoute;
                self.travelRoute := 11;
            }
            else self.travelRoute := self.nextRoute;
            // for use by Wumpus-chasing code, to detect that reflexive
            // travel has just happened.  (The property is cleared by
            // the code).
            self.reflexmove := true;
        }
        if (self = parserGetMe()) 
            self.location := room;
        else inherited thing.moveInto(room);
        self.lastmoveloc := self.location;
        self.lasttoploc := toplocation(self.lastmoveloc);
    }
    verGrab(obj) = {}  // DJP - allow troll to take treasures

    // Code for 'bear, follow me'
    verDoFollow(actor) = {
        if(actor = Bear) Bear.verDoTake(self);
        else pass verDoFollow;
    }
    doFollow(actor) = {
        if(actor = Bear) Bear.doTake(self);
        else pass doFollow;
    }
    health = 100
    shielded = ((glowing_stone.location = canister) and not
        canister.isopen)
    healthmess = [
        'Is it hot in here?  You are flushed and sweating.'
        'You are feeling definitely peculiar, weak....'
        'You\'re dizzy, nauseous.  You can barely stand.'
        'You are really ill.  If you don\'t find an antidote soon, it\'s
        curtains.'
        'You are a walking wound.  You are very weak.  You\'d better find out
        what\'s wrong before it\'s too late.'
        'Sheeesh!  What a mess!  Your hair has fallen out and your skin is
        covered with blisters.  And not an aspirin in sight!'
        'Well, you tried, but your strength is gone.  The agony is finally
        over.'
    ]

    healthdaemon = {
        local i,toproom := toplocation(self),msg := nil;
        if (toproom.isoutside and not toproom.isindoor)
            self.health += 3;
        else self.health += 1;
        if(self.health > 100) self.health := 100;
        if (glowing_stone.isInside(self) and not self.shielded) {
            self.health -= 7; msg := true;
        }
        else if(glowing_stone.isInside(toproom) and not self.shielded) {
            self.health -= 5; msg := true;
        }
        if (msg) {
            if (self.health < 60) {
                i := 1 + (60 - self.health) / 10;
                P(); I(); say(healthmess[i]);
            }
        }
        if (self.health < 0) die();
    }
    actorAction( verb, dobj, prep, iobj ) =  {
#ifndef WIZARD
        if(verb = purloinVerb and dobj = axe and prep = nil and iobj = nil
            and global.nodwarves and not axe.moved) return;
        else if (isclass(verb,wizardVerb)) {
            "Only wizards can use that verb. ";
            exit;
        }
#endif
        if((Wumpi.phase > 0) and (Wumpi.phase < 5 or 
        Wumpi.location != Green_Large_Circular_Room))
            Wumpi.actioncheck(self,verb,dobj,prep,iobj);
    }
    ringlist = [] // filled in during preinit
    protection = {
        local i,o,p := 0,l := length(self.ringlist);
        for (i := 1; i <= l; i++) {
            o := self.ringlist[i];
            if(o.location = self and o.isworn) {
                p += o.protection;
            }
        }
        return p;
    }
    // added for 'feed slime with me' etc
    ioFeedWith (actor, dobj) = {dobj.doFeedWith (actor,self);}
    // added for 'feed me with item'
    // (note that verIoFeedWith is set to {} for everything in ccr-npc.t)
    verDoFeedWith (actor, io) = {
        if (not defined(io,&verDoEat))
            "I don't know how to feed you with <<io.thedesc>>. ";
        else
            io.verDoEat(self);
    }
    // ioFeedWith transfers control to doFeedWith for all portable
    // items
    doFeedWith (actor, io) = { io.doEat(self); }
;

modify decoration
    dobjGen(a, v, i, p) =
    {
        if ((v <> inspectVerb) && (v <> gonearVerb))
        {
            "\^<<self.thedesc>> <<self.isntdesc>> important.";
            exit;
        }
    }
;
// class distantItem: fixeditem

// Allow certain verbs to be used with distantItems
modify distantItem
    dobjGen(a, v, i, p) =
    {
        if ((v <> inspectVerb) and (v <> gonearVerb) and (v <> countVerb))
        // DJP - allow the rod to be waved at the volcano;
        // also allow asking and telling.
        {
            "It's too far away.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        if (v = waveVerb or v = askVerb or v = tellVerb) return;
        self.dobjGen(a, v, d, p);
    }
;
// class buttonitem: fixeditem
// class clothingItem: item
modify clothingItem
    doUnwear( actor ) =
    {
        local totbulk := addbulk(actor.contents) + self.bulk;

        // DJP - added a weight check (for the 551/701 point games), since 
        // worn items don't count as part of the player's weight. Check
        // weight and bulk only for objects which have nonzero weight or
        // bulk.

        if (self.mass and global.newgame) {
            if (addweight(actor.contents) + self.mass > actor.maxweight) {
                "%You% could drop <<self.thedesc>>, but %your% load would be 
                too heavy if %you% tried to carry <<self.itobjdesc>>. ";
                return;
            }
        }

        if (self.bulk and (totbulk > actor.maxbulk))
        {
            if(not sack_of_holding(actor,self,totbulk - actor.maxbulk)) {
                "%You% could drop <<self.thedesc>>, but %your% hands are
                too full to carry <<self.itobjdesc>>. ";
                return;
            }
        }

        // If this point is reached, the object is OK to be unworn.
        "Okay, %you're% no longer wearing "; self.thedesc; ". ";
        self.isworn := nil;
    }
;
// class obstacle: object
// class doorway: fixeditem, obstacle
//
// DJP - added an NPCdest door destination method for use in NPC and backVerb 
// code.  This will return doordest if:
// 
// (i)  the doordest property is set to a room object, or is a method and
//      the doordestOK property is set to true.  In the latter case the
//      method should return a room object (or nil), but must not print text.
//
// (ii) the door can be traversed without first issuing an explicit OPEN or 
//      UNLOCK command.
//
// In some cases, both sides of a door (e.g. the grate or rusty door) are
// represented as a single floatingdecoration object, and the doordest
// depends on the location of an actor.  The actor won't always be Me, and
// in Polyadv the convention is to check the location of a 'current
// actor' (global.currentActor), either directly or through the door's location
// method.
//
// An optional argument (loc) to the NPCdest method specifies the location
// of an actor who wishes to pass through the door.  If the doordest
// property is a method, NPCdest will place a dummy actor in this location
// and temporarily make it the current actor.

modify doorway
    NPCdest(...) = {
        local loc := nil, actorsave, dummysave, value;
        local ptype := proptype(self,&doordest);
        if (argcount > 0) loc := getarg(1);
        if ((self.isopen or 
        (not self.islocked and not self.noAutoOpen))
        and ((ptype = 2) or self.doordestOK)) {
            // If a location is given and the doordest property is a method,
            // we place a dummy actor object in the room and make it the
            // current actor.
            if(loc and (ptype = 6)) {
                actorsave := global.currentActor;
                dummysave := DummyActor.location;
                DummyActor.location := loc; 
                global.currentActor := DummyActor;
            }
            value := self.doordest;
            // reset the global actor and dummy actor location
            if(loc and (ptype = 6)) {
                global.currentActor := actorsave;
                DummyActor.location := dummysave;
            }    
        }
        else
            value := nil;
        return value;
    }
// Allow OPEN DOOR WITH KEYS
    doSynonym('UnlockWith') = 'OpenWith' 
// Allow use of boardVerb
    doSynonym('Enter') = 'Board'
;
// class lockableDoorway: doorway
// class vehicle: item, nestedroom
modify vehicle
    // The iobjgen and dobjgen are overkill, so we zap them.
    iobjGen(a, v, i, p) = {}
    dobjGen(a, v, i, p) = {}
    // Some vehicle objects are portable, so we need to prevent the actor
    // from taking the vehicle while inside it.  
    verifyRemove(actor) =
    {
        if (actor.isIn(self)) {
            "%You%'ll have to get ";self.outOfPrep;" ";self.thedesc;" first.";
        }
        else if (self.isfixed)
            inherited fixeditem.verifyRemove(actor);
        else
            pass verifyRemove;
    }
    out = {inherited nestedroom.out;} // DJP - use doUnboard
;
// class surface: item
// class qsurface: surface
// class container: item
// class openable: container
// class qcontainer: container
// class lockable: openable
modify lockable
// Allow OPEN CHEST WITH KEYS
    doSynonym('UnlockWith') = 'OpenWith' 
;
// class keyedLockable: lockable
modify keyedLockable
    // Message to be issued when a key doesn't work.  This code is used
    // by all lockable objects including doors (class CCR_doorway).
    misfit(io) = {
        // Determine whether we are actually trying more than one key.
        local multikey := nil;
        // Detect a special case when the key(s) found by disambigIobj 
        // are not reachable.
        if ((io = available_keys) and (length(io.list) = 0)) {
            "There are no keys available at your location. ";
            return;
        }
        if (io = set_of_keys) 
            multikey := true;
        else if ((io = available_keys) and ((length(io.list) > 1) or 
        find(io.list,set_of_keys)))
            multikey := true;
            
        // This condition will only occur when the object is an external
        // door which can't be unlocked at closing time, or during a
        // security alert.
        if (io = self.mykey) {
            "The lock seems to be stuck - the key refuses
            to turn!  ";
            self.closingmessage;
        }
        else switch (self.mykey) {
            case small_key:
                if (multikey)
                     "All the keys are too large for the lock. ";
                else
                     "It's too large for the lock. ";
                break;
            default:
                if (multikey)
                     "None of the keys fit the lock. ";
                else
                     "It doesn't fit the lock. ";
                break;
        }
    }
    doLock(actor) = {
    local i,l,outhideStatus,key;
        l := length(available_keys.list);
        if (l = 0)
            askio(withPrep);
        else {
            if (l = 1) {
                key := available_keys.list[1];
                "\n (using <<key.thedesc>>)\n";
                key.ioLockWith(actor,self);
            }     
            else if (l > 1) {
                "\n (trying all available keys)\n";
                available_keys.ioLockWith(actor,self);
            }
        }    
    }
    doUnlock(actor) =
    {
        local i,l,outhideStatus,key;
        l := length(available_keys.list);
        if (l = 0)
            askio(withPrep);
        else {
            if (l = 1) {
                key := available_keys.list[1];
                "\n (using <<key.thedesc>>)\n";
                key.ioUnlockWith(actor,self);
            }     
            else if (l > 1) {
                "\n (trying all available keys)\n";
                available_keys.ioUnlockWith(actor,self);
            }
        }    
    }
    doLockWith( actor, io ) =
    {
        if ( self.isopen )
        {
            "%You% can't lock << self.thedesc >> when it's open. ";
        }
        else if ( io = self.mykey )
        {
            "Locked. ";
            self.islocked := true;
        }
        else self.misfit(io);  // DJP
    }
    doUnlockWith( actor, io ) =
    {
        if ( io = self.mykey )
        {
            "Unlocked. ";
            self.islocked := nil;
        }
        else self.misfit(io);  // DJP
    }
;
// class keyItem: item
modify keyItem
    plural = 'keys'  
    // 'Keys' normally refers to all available keys, except those which have
    // been attached to the keyring (set_of_keys).  The other exception 
    // applies when noun phrase resolution is modified by a disambigIobj
    // method.  In particular, locking or unlocking with the 'keys', e.g. 
    // LOCK DOOR WITH KEYS, will refer to a special object representing all
    // available keys thus avoiding error messages about multiple direct 
    // objects.
    //
    verDoDetach(actor) = {
        // when detaching a key from the keyring, check that the keyring 
        // itself could be taken
        if(not (self.location = set_of_keys)) 
            pass verDoDetach;
        else
            self.location.verifyRemove(actor);
    }
    doDetach(actor) = {
        self.moveInto(self.location.location);
        "You detach <<self.thedesc>> from the keyring. ";
        if (clothingItem.classcount(set_of_keys) = 0) {
             set_of_keys.isworn := nil;
             set_of_keys.iswearable := nil;
        }
    }
    doDrop(actor) = {
        if(self.location = set_of_keys) {
            "(Detaching <<self.thedesc>> from the 
            keyring first)\n ";
            inherited.doDrop(actor);
            if (clothingItem.classcount(set_of_keys) = 0) {
                 set_of_keys.isworn := nil;
                 set_of_keys.iswearable := nil;
            }
        }
        else pass doDrop;
    }
    // Simply taking a key is prevented if it is attached to the keyring
    verDoTake(actor) = {
        if(self.location = set_of_keys) {
            "You'll need to detach <<self.thedesc>> from the keyring first. ";
        }
    else pass verDoTake;
    }
    doTake(actor) = {
        if(self.location = set_of_keys) {
            "(Detaching <<self.thedesc>> from the keyring first)\n ";
            inherited.doTake(actor);
            if (clothingItem.classcount(set_of_keys) = 0) {
                 set_of_keys.isworn := nil;
                 set_of_keys.iswearable := nil;
            }
        }
        else pass doTake;
    }
    // Allow TAKE KEY FROM KEYRING if the key is attached - the verDoDetach
    // method is used instead
    verDoTakeOut(actor, io) =
    {
        if (io <> nil and not self.isIn(io))
        {
            caps(); self.thedesc; " "; self.isntdesc;
            " in "; io.thedesc; ". ";
        }
        else if (self.location = set_of_keys)
            self.verDoDetach(actor);
        else
            self.verDoTake(actor);     /* ensure object can be taken at all */
    }
    // for key-operated switches
    ioSynonym('UnlockWith') = 'TurnonWith'
    ioSynonym('LockWith') = 'TurnoffWith'
    // Allow OPEN DOOR WITH KEYS
    verIoOpenWith(actor) = {self.verIoUnlockWith(actor);}
    ioOpenWith(actor, dobj) =
    {
        if (defined(dobj,&doOpenWith))
            dobj.doOpenWith(actor,self);   
        else if (defined (dobj,&doUnlockWith))
            dobj.doUnlockWith(actor, self);
        else
            "I don't know how to open <<dobj.thedesc>> with 
            <<self.thedesc>>. ";
    }
    // Remove 'keys' from the vocab when a key is attached to the keyring,
    // and reinstate the vocab when it is taken off again.
    moveInto(loc) = {
        local oldloc := self.location;
        if((loc != set_of_keys) and (oldloc = set_of_keys))
            addword(self,&plural,'keys');
        else if((loc = set_of_keys) and (oldloc != set_of_keys))
            delword(self,&plural,'keys');
        pass moveInto;
    }
;
// class seethruItem: item
// class transparentItem: item
// class basicNumObj: object   // when a number is used in a player command,
// class basicStrObj: object   // when a string is used in a player command,
modify basicStrObj
    doSay( actor ) =
    {
            // DMB added magic words
            // DJP added PHUCE and REFLECT but removed Y2 which isn't really
            // a magic word.
            // BJS added magic words from 550-point version.
            if (upper(strObj.value) = 'XYZZY') {
                    xyzzyVerb.action(actor);
            }
            else if (upper(strObj.value) = 'PLUGH') {
                    plughVerb.action(actor);
            }
            else if (upper(strObj.value) = 'PLOVER') {
                    ploverVerb.action(actor);
            }
            else if (upper(strObj.value) = 'THURB') {
                    thurbVerb.action(actor);
            }
            else if (upper(strObj.value) = 'NOSIDE') {
                    nosideVerb.action(actor);
            }
            else if (upper(strObj.value) = 'SAMOHT') {
                    samohtVerb.action(actor);
            }
            else if (upper(strObj.value) = 'ZORTON') {
                    zortonVerb.action(actor);
            }
            else if (upper(strObj.value) = 'BLERBI') {
                    blerbiVerb.action(actor);
            }
            else if (upper(strObj.value) = 'SNOEZE') {
                    snoezeVerb.action(actor);
            }
            else if (upper(strObj.value) = 'KLAETU') {
                klaetuVerb.action(actor);
            }
            else if (upper(strObj.value) = 'KNERL') {
                knerlVerb.action(actor);
            }
            else if (upper(strObj.value) = 'PHUGGG') {
                phugggVerb.action(actor);
            }
            else if (upper(strObj.value) = 'MELENKURION') {
                melenkurionVerb.action(actor);
            }
            else if (upper(strObj.value) = 'PHUCE') {
                    phuceVerb.action(actor);
            }
            else if (upper(strObj.value) = 'SAINT-MICHEL') {
                    smichelVerb.action(actor);
            }
            else if (upper(strObj.value) = 'REFLECT') {
                    reflectVerb.action(actor);
            }
            else if (upper(strObj.value) = 'FEE') {
                    feeVerb.action(actor);
            }
            else if (upper(strObj.value) = 'FIE') {
                    fieVerb.action(actor);
            }
            else if (upper(strObj.value) = 'FOE') {
                    foeVerb.action(actor);
            }
            else if (upper(strObj.value) = 'FOO') {
                    fooVerb.action(actor);
            }
            else if (upper(strObj.value) = 'FUM') {
                    fumVerb.action(actor);
            }
            else if (upper(strObj.value) = 'FEE FIE FOE FOO') {
                    "Try saying the words one at a time.";
            }
            else if (upper(strObj.value) = 'FEE FIE FOE FUM') {
                    "Try saying the words one at a time.";
            }
            else if (upper(strObj.value) = 'NOSIDE SAMOHT') {
                    nosidesamohtVerb.action(actor);
            }
            else if (upper(strObj.value) = 'THGIRW') {
                    thgirwVerb.action(actor);
            }
            else if (upper(strObj.value) = 'RUBLIW') {
                    rubliwVerb.action(actor);
            }
            else if (upper(strObj.value) = 'THGIRW RUBLIW') {
                    thgirwrubliwVerb.action(actor);
            }
            else if (upper(strObj.value) = 'ANA') {
                    anaVerb.action(actor);
            }
            else if (upper(strObj.value) = 'KATA') {
                    kataVerb.action(actor);
            }
            else if (upper(strObj.value) = 'OSAL') {
                    osalVerb.action(actor);
            }
            else if (upper(strObj.value) = 'PHROSAL') {
                    phrosalVerb.action(actor);
            }
            else if (upper(strObj.value) = 'PHLEECE') {
                    phleeceVerb.action(actor);
            }
            else {
                    "Okay, \"<<strObj.value>>\". ";
            }
    }
;





// Verbs
// =====
//
/* 
 * Modifications of adv.t verbs 
 */

// N.B. we turn some verbs into darkVerbs (the isDarkVerb property is looked at
// by roomCheck etc, not the class, so we can use modify rather than replace
// for this purpose.) 

// function to set up global actor defaults (mainly for pre-tads2.5.6 kludge)
actorsetup: function(actor) {
    global.verbActor := actor;     // actor actually executing this verb
    global.travelActor := actor;   // actor being moved with travelTo
    global.currentActor := actor;  // actor for location method evaluation
}


// class deepverb: object                // A deep-structure verb.
modify deepverb
/* Things to do at the start of execution for all verbs */
    verbAction(actor,dobj,prep,io) = {
        local validdoclass, validioclass;
        // Find the real class associated with the deepverb.validIo
        // and deepverb.validDo definitions; if further modify statements
        // are used, it won't be deepverb.
        if(deepverb.realclass = nil) 
            deepverb.realclass := defined(deepverb,&validDo,DEFINED_GET_CLASS);
        // reset some global variables used for temporary purposes within
        // verb execution, in case the code forgot to do it or the last
        // command bombed with a TADS error.
        global.dropsilent := nil;     // 'dropped' message was suppressed
        global.saidthrow := nil;      // a weapon was explicitly thrown
        global.listenadd := nil;      // used in customized listendesc methods
        global.onlyviewing := nil;    // set when looking into a ball
        global.view_artifact := nil;  // identifies which ball is being used
        global.trollcatch := nil;     // troll 'catches', not 'takes' an item
        clover.isfixed := nil;        // in case of TADS error in phuce code.
        crown.isfixed := nil;         // in case of TADS error in phuce code.
        thronesign.isfixed := nil;    // in case of TADS error in phuce code.
        // set global variables to the actor
        actorsetup(actor);

        // do we have a direct object?
        if (dobj and (dobj != numObj) and (dobj != strObj)) {
        // check how the verb defines its validDo method.  If it's
        // inherited from the deepverb class, we assume that the normal
        // reachability check is required and do it here.  The advantage
        // is that we have control over what happens when a list of 
        // objects has been given, some of which are reachable.  The
        // normal check aborts the command, but we do an exitobj, so that
        // the action will succeed on all the reachable objects in the list.
            validdoclass := defined(self,&validDo,DEFINED_GET_CLASS);
            if((validdoclass=deepverb.realclass) and not 
            dobj.isReachable(actor)) {
                dobj.cantReach(actor);
                exitobj;
            }
        }
        // apply similar checks for an indirect object.
        if (io and (io != numObj) and (io != strObj)) {
            validioclass := defined(self,&validIo,DEFINED_GET_CLASS);
            if((validioclass=deepverb.realclass) and not 
            io.isReachable(actor)) {
                io.cantReach(actor);
                exitobj;
            }
        }

    }
      
    // DJP - check for visibility only.  By default, reachability is now 
    // checked for in the verbAction method above.   (This only applies to
    // verbs which inherit their validDo methods directly from deepverb) 
    // 

    validDo( actor, obj, seqno ) =
    {
        return( obj.isVisible( actor ));
    }

    // DJP - store the actor in global variables so that they
    // will be available during the validation and verification stages.

    validDoList( actor, prep, iobj) = 
    {            
        if(global.tadsversion < '2.5.6') {
            actorsetup(actor);
        }
        pass validDoList;
    }
    validIo( actor, obj, seqno ) =
    {
        return( obj.isVisible( actor ));
    }
    validIoList( actor, prep, iobj) = 
    {            
        if(global.tadsversion < '2.5.6') {
            actorsetup(actor);
        }
        pass validIoList;
    }
    doDefault( actor, prep, io ) =
    {
        local roomlist;
        roomlist := actor.contents + actor.location.contents;
        if(global.tadsversion < '2.5.6') {
            actorsetup(actor);
        }
        if (find(Dwarves.loclist, toplocation(actor)) <> nil)
                roomlist += Dwarves;
        if (not global.floatcontents) {
            if (find(Stream.loclist, toplocation(actor)) <> nil)
                roomlist += Stream;
            if (toplocation(actor) = Outside_Grate or
            toplocation(actor) = Below_The_Grate)
                roomlist += Grate;
        }
        roomlist -= global.noall;
        return( roomlist );
    }
    ioDefault( actor, prep ) =
    {
        local roomlist;
        roomlist := actor.contents + actor.location.contents;
        if (find(Dwarves.loclist, toplocation(actor)) <> nil)
            roomlist += Dwarves;
        if (not global.floatcontents) {
            if (find(Stream.loclist, toplocation(actor))<> nil)
                roomlist += Stream;
            if (toplocation(actor) = Outside_Grate or
            toplocation(actor) = Below_The_Grate)
                roomlist += Grate;
        }
        roomlist -= global.noall;
        return( roomlist );
    }
    // DJP - recognize negative numbers (in plain commands; unfortunately
    // this won't work after disambiguation or askio prompts)
    parseUnknownIobj(actor, prep, dobj, wordlist) = {
        local i, l, word, firstchar, char, remainder;
        local nums := '0123456789';
        if (length(wordlist) <> 1) return nil;
        word := wordlist[1];
        l := length(word);
        if(length(word) <= 1) return nil;
        firstchar := substr(word,1,1);
        if (firstchar <> '-') return nil;
        remainder := substr(word,2,l-1);
        for (i := 2; i <= l; i++) {
            char := substr(word,i,1);
            if(find(nums,char) = nil) return nil;
        }
        numObj.value := -cvtnum(remainder);
        return numObj;
    }
    parseUnknownDobj(actor, prep, iobj, wordlist) = {
        return self.parseUnknownIobj(actor, prep, iobj, wordlist);
    }
;
// class darkVerb: deepverb
// inspectVerb: deepverb
// askVerb: deepverb
// tellVerb: deepverb
// followVerb: deepverb
// digVerb: deepverb
modify digVerb
    action(actor) = {
        "Digging without a shovel is quite impractical. Even
        with a shovel progress is unlikely.";
    }
    doAction = 'Dig'
;
// jumpVerb: deepverb

// jumpVerb is replaced in ccr-verb.t and is now a travel verb

modify pushVerb
    ioAction(withPrep) = 'PushWith' //DJP added (for suction cups)
;

// attachVerb: deepverb
// wearVerb: deepverb
// dropVerb: deepverb, darkVerb
modify dropVerb
    isDarkVerb = true // DJP - allow simple dropping in the dark
    verb = 'drop' 'put down' 'free' 'release'   // DMB: added last two
           'leave here'         // DJP: added, for bear at volcano bridge
    ioAction( inPrep ) = 'PutIn'
    doDefault(actor, prep, io) =
    {
        local invlist;
        if(global.tadsversion < '2.5.6') {
            actorsetup(actor);
        }
        invlist := inherited.doDefault(actor,prep,io);
        invlist -= global.noall;
        return invlist;
    }
;
// removeVerb: deepverb
// openVerb: deepverb
modify openVerb 
    isDarkVerb = true           // darkVerb so we can open the sack if
                                // it contains the lamp!
    verb = 'open' 'pry'         // DMB added pry for "pry clam with trident"
           'prise'              // DJP added British equivalent 
    ioAction(withPrep) = 'OpenWith' //DMB added (for clam)
    disambigIobj(actor, prep, dobj, verprop, wordlist, objlist, flaglist,
    numberWanted, isAmbiguous, silent) = {
    local key;
    if (wordlist = ['keys']) {
        // Return the object if there is only one option
        if (length(objlist) = 1) {
            key := objlist[1];
            // Let the user know which key is being used, except for
            // set_of_keys
            if ((not silent) and (key != set_of_keys))
                "\n (Trying <<key.thedesc>>)\n";
            return [DISAMBIG_DONE, key];
        }
        // Otherwise return the special object and let the player know
        else if (not silent)
            "\n (Trying all available keys) \n";
        return [DISAMBIG_DONE,available_keys];
    }
    else 
        return DISAMBIG_CONTINUE;
    }
;
modify closeVerb
    ioAction(withPrep) = 'CloseWith' //DJP added (for trying to close the safe
                                    //with the suction cups)
;
// putVerb: deepverb
modify putVerb  
    isDarkVerb = true // DJP - allow batteries to be put in lamp in dark
                      // rooms.   (But roomAction disallows anything else).
    verb = 'put' 'place' 'insert'             // DMB: added 'insert'
    sdesc = "put"
    doDefault( actor, prep, io ) =
    {
        // changed - DJP.  In the main part of the game, all non-fixed
        // objects at the location and all objects which are carried
        // are eligible for consideration.  However, in the endgame we
        // restrict the default to objects carried by the player, due
        // to the proliferation of identical objects in piles/bundles etc.
        local i,l,list := [],o,xlist;
        if(global.tadsversion < '2.5.6') {
            actorsetup(actor);
        }
        if(actor.location and not global.fully_closed) list +=
        actor.location.contents;
        list += actor.contents;
        l := length(list);
        xlist := list;
        for (i := 1; i <= l; i++) {
            o := xlist[i];
            if (o.isfixed) list -= o;
        }
        return list;
    }
    ioAction(thruPrep)='PutThrough'
    // N.B. default methods for 'put x through y' are defined in this file,
    // not ccr-thx.t
;
// takeVerb: deepverb
modify takeVerb
    verb = 'take' 'pick up' 'get' 'remove' 'catch' // DJP - added catch
    doDefault(actor, prep, io) = {
        local roomlist;
        if(global.tadsversion < '2.5.6') {
            actorsetup(actor);
        }
        roomlist := inherited.doDefault(actor,prep,io);
        roomlist -= global.noall;
        return roomlist;
    }
    ioAction(withPrep) = 'TakeWith'
;
// plugVerb: deepverb
// lookInVerb: deepverb
// 'look in' and 'look on' are now separated. 
replace lookInVerb: deepverb
    verb = 'look in' 'l in'
    sdesc = "look in"
    doAction = 'Lookin'
;
//
lookOnVerb: deepverb // Now separated from LOOK IN, defined for surfaces.
    verb = 'look on' 'l on'
    sdesc = "look on"
    doAction = 'Lookon'
;
modify surface
    verDoLookon(actor) = {}
    doLookon(actor) = {self.doSearch(actor);}
;
// screwVerb: deepverb
// unscrewVerb: deepverb
// turnVerb: deepverb
modify turnVerb
   verb = 'spin'
   ioAction(overPrep) = 'SpinOver'
   ioAction(acrossPrep) = 'SpinOver'
;   
//
// switchVerb: deepverb
// flipVerb: deepverb
// turnOnVerb: deepverb, darkVerb
modify turnOnVerb
    ioAction(withPrep) = 'TurnonWith'
;
// turnOffVerb: deepverb
// DJP: make 'turn off' a darkVerb as well so we can turn off the lamp in the
// Crystal Palace.
modify turnOffVerb
    isDarkVerb = true
    ioAction(withPrep) = 'TurnoffWith'
// DMB: added 'deactivate'
// DJP: added 'extinguish'.
    verb = 'turn off' 'deactivate' 'switch off' 'extinguish'
;
// lookVerb: deepverb
// sitVerb: deepverb
// lieVerb: deepverb
// getOutVerb: deepverb
// DJP: getOutVerb now split up ...
replace class getOutVerb: deepverb
    doAction = 'Unboard'
    doDefault( actor, prep, io ) =
    {
        if(global.tadsversion < '2.5.6') {
            actorsetup(actor);
        }
        if ( actor.location and actor.location.location )
            return( [] + actor.location );
        else return( [] );
    }
;
getOutVerb1: getOutVerb
    verb = 'get out' 'get outof'
    sdesc = "get out of"
;
getOffVerb: getOutVerb
    verb = 'get off' 'get offof'
    sdesc = "get off"
;
// boardVerb: deepverb
// DJP - boardVerb also split up
replace class boardVerb: deepverb
    doAction = 'Board'
;
boardVerb1: boardVerb
    verb = 'get in' 'get into' 'board'
    sdesc = "get in"
;
boardVerb2: boardVerb
    verb = 'get on' 'get on' 'get onto' //DJP added onto
    sdesc = "get on"
;

// againVerb: darkVerb
// waitVerb: darkVerb
// iVerb: deepverb
modify iVerb
    isDarkVerb = true  // Allow inventory-taking in the dark (useful in
;                      // Inform games)

// iwideVerb: deepverb
// itallVerb: deepverb
// lookThruVerb: deepverb
// breakVerb: deepverb
modify breakVerb
    verb = 'break' 'destroy' 'damage' 'bust' 'mangle' 'smash'
;

// attackVerb: deepverb
modify attackVerb
    doAction = 'Attack' // DMB
;
// climbVerb: deepverb
// eatVerb: deepverb
modify eatVerb
    verb = 'sample' // DJP - for blueberries in 551-point game.
;
// drinkVerb: deepverb
modify drinkVerb
    verb = 'drink from' // DMB - for bottle etc.
;
// giveVerb: deepverb
modify giveVerb
    doDefault(actor, prep, io) =
    {
        if(global.tadsversion < '2.5.6') {
            actorsetup(actor);
        }
        pass doDefault;
    }
;
modify pullVerb
    ioAction(withPrep) = 'PullWith' //DJP added (for suction cups)
;

// readVerb: deepverb
// throwVerb: deepverb
modify throwVerb
/* DJP: define a default action for throw */
    doAction = 'Throw'

    ioDefault( actor, prep ) =
/* DJP: if hostile creatures are present, we make them the
sole defaults for the indirect object.  */
    {
        local roomlist,i,o,l;
        local enemylist := [Dwarves, Snake, Dragon, Bear, Troll, Dog,
                            Bees, Wumpus, Blob, Goblins, Slime, Ogre,
                            Basilisk];
        roomlist := [];
        l := length(enemylist);
        for (i := 1; i <= l; i++) {
            o := enemylist[i];
            // omit the Blob if it's not yet in view
            if ((o = Blob) and o.ischasing and (o.chase < 13)) continue;
            if (o.isIn(toplocation(actor)) and not o.istame)
                roomlist += o;
        }
        return roomlist;
    }
;
// standOnVerb: deepverb
modify standOnVerb
    verb = 'stand in'
;
// standVerb: deepverb
// helloVerb: deepverb
// showVerb: deepverb
modify showVerb
    doDefault(actor, prep, io) =
    {
        if(global.tadsversion < '2.5.6') {
            actorsetup(actor);
        }
        pass doDefault;
    }
;
// cleanVerb: deepverb
// sayVerb: deepverb
// yellVerb: deepverb
// moveVerb: deepverb
// fastenVerb: deepverb
// unfastenVerb: deepverb
// unplugVerb: deepverb
// lookUnderVerb: deepverb
// lookBehindVerb: deepverb
// typeVerb: deepverb
// lockVerb: deepverb
modify lockVerb
    disambigIobj(actor, prep, dobj, verprop, wordlist, objlist, flaglist,
    numberWanted, isAmbiguous, silent) = {
        return inherited openVerb.disambigIobj(actor, prep, dobj, verprop,
        wordlist, objlist, flaglist,numberWanted, isAmbiguous, silent);
    }
;
// unlockVerb: deepverb
modify unlockVerb
    disambigIobj(actor, prep, dobj, verprop, wordlist, objlist, flaglist,
    numberWanted, isAmbiguous, silent) = {
        return inherited openVerb.disambigIobj(actor, prep, dobj, verprop,
        wordlist, objlist, flaglist,numberWanted, isAmbiguous, silent);
    }
;
// detachVerb: deepverb
// sleepVerb: darkVerb
modify sleepVerb
    verb = 'sleep' 'rest' 'loaf' 'nap' 'relax'
    replace action(actor) = {
        "This is no time for loafing!";
    }
;
// pokeVerb: deepverb
// touchVerb: deepverb
// moveNVerb: deepverb
// moveSVerb: deepverb
// moveEVerb: deepverb
// moveWVerb: deepverb
// moveNEVerb: deepverb
// moveNWVerb: deepverb
// moveSEVerb: deepverb
// moveSWVerb: deepverb
// centerVerb: deepverb
// searchVerb: deepverb
// knockVerb: deepverb
// class travelVerb: deepverb, darkVerb

// travelVerb and its subclasses are modified in ccr-verb.t

// eVerb: travelVerb
// sVerb: travelVerb
// nVerb: travelVerb
// wVerb: travelVerb
// neVerb: travelVerb
// nwVerb: travelVerb
// seVerb: travelVerb
// swVerb: travelVerb
// inVerb: travelVerb
// outVerb: travelVerb
// dVerb: travelVerb
// uVerb: travelVerb
// gothroughVerb: deepverb
// class sysverb: deepverb, darkVerb
// quitVerb: sysverb
modify quitVerb
    quitgame( actor ) =
    {
        local yesno;

        /* XXX */
        "\bDo you really want to quit? (YES or NO) > ";
        yesno := yorn();
        "\b";
        if ( yesno = 1 )
        {
            incscore(global.quitpoints,'for quitting'); 
            // points for quitting (neg.)
            scoreRank();        // DMB: moved here from XXX
            terminate();        // allow user good-bye message
            quit();
        }
        else
        {
            "Okay. ";
        }
        abort;
    }
;
// verboseVerb: sysverb
// terseVerb: sysverb
// scoreVerb: sysverb
// saveVerb: sysverb
// restoreVerb: sysverb
// scriptVerb: sysverb
// unscriptVerb: sysverb
// restartVerb: sysverb
modify restartVerb // DJP
    restartGame(actor) =
    {
        local yesno, silent := nil;
        if (global.turnsofar <= 5) silent := true;
        while ( true )
        {
            "Note: to restart in a different game mode, use the
            \"game350\", \"game550\", \"game551\", \"game580\", \"game701\", 
            or \"game701+\" command. \n
            By default, you will restart ";
            switch(global.vnumber) {
                case 0: "in the 350-point mode.\n "; break;
                case 1: "in the 551-point mode.\n "; break;
                case 2: "in the 550-point mode.\n "; break;
                case 7: "in the 580-point mode.\n "; break;
                case 11: "in the 701+ point mode. \n "; break;
                case 15: "in the 701-point mode.\n "; break;
            }
            "Do you really want to start over? \n(YES or NO) > ";
            yesno := yorn();
            if ( yesno = 1 )
            {
                "\n";
                scoreStatus(0, 0);
                // DJP - pass game version information.
                global.initRestartParam := [global.vnumber global.randomized
                    silent];
                restart(initRestart, global.initRestartParam);
                break;
            }
            else if ( yesno = 0 )
            {
                "\nOkay.\n";
                break;
            }
        }
    }
;
// versionVerb: sysverb
// debugVerb: sysverb
// undoVerb: sysverb

// Prepositions
// ============
// class Prep: object
// ofPrep: Prep
// aboutPrep: Prep
// withPrep: Prep
// toPrep: Prep
// onPrep: Prep
// inPrep: Prep
// offPrep: Prep
// outPrep: Prep
// fromPrep: Prep
// betweenPrep: Prep
// overPrep: Prep
// atPrep: Prep
// aroundPrep: Prep
// thruPrep: Prep
// dirPrep: Prep
// underPrep: Prep
// behindPrep: Prep
herePrep: Prep             // Added - DJP
    preposition = 'here'
    sdesc = "here"
;
acrossPrep: Prep           // Added - DJP
    preposition = 'across'
    sdesc = "across"
;
// articles: object
