"Art of Fugue" by "Victor Gijsbers, Jimmy Maher, Dorte Lassen and Johan"

[For those who would simply like to create their own puzzles: I suggest scrolling down to where the actual puzzles are, at the bottom of the source, and learn from them what to do.]


The story headline is "Interactive studies in counterpoint".
The story genre is "Puzzle".
The release number is 1.

Release along with cover art.

[The Music section can be commented out to create a version without music.]
Section - Music

To loopplay (SFX - sound name):
	(- PlaySoundLoop(ResourceIDsOfSounds-->{SFX}); -).

Include (-
[ PlaySoundLoop resource_ID;
   if (resource_ID == 0) return;
   ResourceUsageFlags->resource_ID = true;
   if (glk_gestalt(gestalt_Sound, 0)) {
      glk_schannel_play_ext(gg_foregroundchan, resource_ID, -1, 0);
   }
];
-).

To soundstop (SFX - sound name):
	(-StopSound(ResourceIDsOfSounds-->{SFX}); -).

Include (-
[ StopSound resource_ID;
   if (resource_ID == 0) return;
   ResourceUsageFlags->resource_ID = true;
   if (glk_gestalt(gestalt_Sound, 0)) {
      glk_schannel_stop(gg_foregroundchan);
   }
];
-).

Sound of Grosse Fuge is the file "GrosseFuge.ogg".

When play begins:
	loopplay the sound of Grosse Fuge.

Stopping music is an action out of world. Understand "stop music" and "end music" and "stop sound" and "end sound" as stopping music.

Carry out stopping music:
	say "Music is now turned off.";
	soundstop the sound of Grosse Fuge.
	
Starting music is an action out of world. Understand "start music" and "begin music" and "continue music" and "start sound" and "begin sound" and "continue sound" as starting music.

Carry out starting music:
	say "Music is now turned on.";
	loopplay the sound of Grosse Fuge.


Section - Includes

Include Custom Library Messages by David Fisher.
Include Editable Stored Actions by Ron Newcomb.
Include Menus by Emily Short.
Include Questions by Michael Callaghan.
[Include Title Page by Jon Ingold.]

Use MAX_STATIC_DATA of 3000000.



[I might change the layout so that each turn simply produces the name of the actor + a response that no longer mentions the actor by name. This is not very important right now.]

When play begins:
	change the library message person to third person;
	set the library message third person text to "[bold type][current-player][roman type]";
	choose row with a Word of "Himself" in the Table of 'himself' forms;
	now the Word entry is "[bold type][current-player][roman type]";
	choose row with a Word of "himself" in the Table of 'himself' forms;
	now the Word entry is "[bold type][current-player][roman type]".

To say current-player:
	if Een is the player, say "Een";
	if Twee is the player, say "Twee";
	if Drie is the player, say "Drie";
	if Vier is the player, say "Vier".

[Before an actor doing anything except looking: say "([count + 1]) [run paragraph on]".] [I'm not sure about the typography here. Try uncommenting this line and tell me what you think.]

When play begins:
	say "Welcome to [bold type]Art of Fugue[roman type], a collection of fiendish puzzles. Well--the first puzzles aren't too fiendish. You can change between puzzles by typing 'next puzzle' and 'previous puzzle', or restart the current puzzle by typing 'restart puzzle'. You can get to the main menu by typing 'menu'. Have fun!"




Chapter - Voices and the Fugue

First Puzzle is a room.

[We are going to create four actors. Een, Twee, Drie and Vier are the first four numbers in Dutch. Using the English names would be... problematic, to say the least.]

Een is a person. The printed name of Een is "[bold type]Een[roman type]".
Twee is a person. The printed name of Twee is "[bold type]Twee[roman type]".
Drie is a person. The printed name of Drie is "[bold type]Drie[roman type]".
Vier is a person. The printed name of Vier is "[bold type]Vier[roman type]".

Een, Twee, Drie and Vier are scenery.

The player is Een. [At the start of the game at least.]

Count is a number that varies. Count is 0. [Count goes from 0 to 1 to 2 to 3, and is equivalent to the person who has had his turn last. (Where 4 is 0.) So if count is 0, Een is going to take the next turn.]

tmpcmd is some indexed text that varies. [tmpcmd will be a very important variable, because we use it to manipulate and store the player's input. It is after all the INPUT, not the PARSED COMMAND that we want to store. "X me", for instance, is parsed to "examine Een"--and we don't want Twee, Drie and Vier to examine Een in response to "x me". We want them to examine themselves. In order to get that, we store the player's input, and reparse it when needed.]


[The Table of Melodies stores the commands. We make 15 rows, for possible later use, but use only 4 or 5 now.]

Table of Melodies
Twee Stored Action (indexed text)		Drie Stored Action (indexed text)		Vier Stored Action (indexed text)
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait"
"wait"			"wait"			"wait" [15 rows]



[This is the most important routine!]

First every turn when not looking (this is the play and write the fugue rule):
	if count is 0: [New commands are stored only on Een's turn.]
		now tmpcmd is the player's command;
[		if the again boolean is true, now tmpcmd is "again"; [See below, the section about again.]]
		choose row 3 in the Table of Melodies;
		now the Twee Stored Action entry is tmpcmd;
		choose row 4 in the Table of Melodies;
		now the Drie Stored Action entry is tmpcmd;
		choose row 5 in the Table of Melodies;
		now the Vier Stored Action entry is tmpcmd;
		repeat with N running from 1 to 14: [because 15 rows] [Here we push all the rows up.]
			choose row N in the Table of Melodies;
			let M be N + 1;
			let Q be the Twee Stored Action in row M of the Table of Melodies;
			now the Twee Stored Action entry is Q;
[			say Q;]
			let Q be the Drie Stored Action in row M of the Table of Melodies;
			now the Drie Stored Action entry is Q;
[			say Q;]
			let Q be the Vier Stored Action in row M of the Table of Melodies;
			now the Vier Stored Action entry is Q;
[			say Q;]
		increase move counter by 1;
		if move counter is less than 501: [For move counter, see the chapter on keeping track of the player's solution, at the end of this file]
			choose row move counter in the Table of Player Solution;
			now the move entry is tmpcmd;
	now count is 1 + count; [We increase the person whose turn it is.]
	if count is 4, now count is 0;
	if count is 0, change player to Een.

Rule for reading a command when count is not 0: [When count is not 0, this routine reads a command from the Table of Melodies and uses it as input.]
	choose row 1 in the Table of Melodies;
	if count is 1:
		change player to Twee; [We make the actor the protagonist. Otherwise, the standard library would give us insane amounts of headaches. Most actions are not reported for non-protagonists.]
		now tmpcmd is the Twee Stored Action entry;
	if count is 2:
		change player to Drie;
		now tmpcmd is the Drie Stored Action entry;
	if count is 3:
		change player to Vier;
		now tmpcmd is the Vier Stored Action entry;
	change the text of the player's command to tmpcmd. [And now Inform 7's standard parsing + running the action routines take over.]








Chapter - Commands

The again-text is some indexed text that varies.
	
After reading a command when count is 0 (this is the handle again rule):
	if the player's command matches the regular expression "^(again|g)\b":
		if the again-text is "": [if "again" is the very first command]
			say "You can hardly repeat that.";
			reject the player's command;
		change the text of the player's command to the again-text;
	otherwise:
		change the again-text to the player's command.

Section - Disable "all" and multiple objects

[Here we rewrite all the grammar lines that include "all".]

Understand the commands "take", "carry", "hold", "get", "pick",
"remove", "put", "insert", "drop", "throw" and "discard" as something
new.

Understand "take [something]" as taking.
Understand "take off [something]" as taking off.
Understand "take [something] from [something]" as removing it from.
Understand "take [something] off [something]" as removing it from.
Understand "take inventory" as taking inventory.
Understand the commands "carry" and "hold" as "take".

Understand "get out/off/up" as exiting.
Understand "get [something]" as taking.
Understand "get in/into/on/onto [something]" as entering.
Understand "get off [something]" as getting off.
Understand "get [something] from [something]" as removing it from.

Understand "pick up [something]" or "pick [something] up" as taking.

Understand "remove [something preferably held]" as taking off.
Understand "remove [something] from [something]" as removing it from.

Understand "put [something] in/inside/into [something]" as inserting it into.
Understand "put [something] on/onto [something]" as putting it on.
Understand "put on [something preferably held]" as wearing.
Understand "put down [something preferably held]" or "put [something
preferably held] down" as dropping.

Understand "insert [something] in/into [something]" as inserting it into.

Understand "drop [something preferably held]" as dropping.
Understand "drop [something] in/into/down [something]" as inserting it into.
Understand "drop [something] on/onto [something]" as putting it on.
Understand "drop [something preferably held] at/against/on/onto
[something]" as throwing it at.
Understand the commands "throw" and "discard" as "drop".

Rule for printing a parser error when the latest parser error is can't use multiple objects error:
	say "You can't use multiple objects in this game."


Section - Disable disambiguation questions

[Here we rewrite NounDomain to stop disambiguation questions.]


Include (-
[ NounDomain domain1 domain2 context
	first_word i j k l answer_words marker;
    #Ifdef DEBUG;
    if (parser_trace >= 4) {
        print "   [NounDomain called at word ", wn, "^";
        print "   ";
        if (indef_mode) {
            print "seeking indefinite object: ";
            if (indef_type & OTHER_BIT)  print "other ";
            if (indef_type & MY_BIT)     print "my ";
            if (indef_type & THAT_BIT)   print "that ";
            if (indef_type & PLURAL_BIT) print "plural ";
            if (indef_type & LIT_BIT)    print "lit ";
            if (indef_type & UNLIT_BIT)  print "unlit ";
            if (indef_owner ~= 0) print "owner:", (name) indef_owner;
            new_line;
            print "   number wanted: ";
            if (indef_wanted == INDEF_ALL_WANTED) print "all"; else
print indef_wanted;
            new_line;
            print "   most likely GNAs of names: ", indef_cases, "^";
        }
        else print "seeking definite object^";
    }
    #Endif; ! DEBUG

    match_length = 0; number_matched = 0; match_from = wn;

    SearchScope(domain1, domain2, context);

    #Ifdef DEBUG;
    if (parser_trace >= 4) print "   [ND made ", number_matched, " matches]^";
    #Endif; ! DEBUG

    wn = match_from+match_length;

    ! If nothing worked at all, leave with the word marker skipped past the
    ! first unmatched word...

    if (number_matched == 0) { wn++; rfalse; }

    ! Suppose that there really were some words being parsed (i.e., we did
    ! not just infer).  If so, and if there was only one match, it must be
    ! right and we return it...

    if (match_from <= num_words) {
        if (number_matched == 1) {
            i=match_list-->0;
            return i;
        }

        ! ...now suppose that there was more typing to come, i.e. suppose that
        ! the user entered something beyond this noun.  If nothing ought to follow,
        ! then there must be a mistake, (unless what does follow is just a full
        ! stop, and or comma)

        if (wn <= num_words) {
            i = NextWord(); wn--;
            if (i ~=  AND1__WD or AND2__WD or AND3__WD or comma_word
                   or THEN1__WD or THEN2__WD or THEN3__WD
                   or BUT1__WD or BUT2__WD or BUT3__WD) {
                if (lookahead == ENDIT_TOKEN) rfalse;
            }
        }
    }

    ! Now look for a good choice, if there's more than one choice...

    number_of_classes = 0;

    if (number_matched == 1) i = match_list-->0;
    if (number_matched > 1) {
        i = Adjudicate(context);
        if (i == -1) rfalse;
        if (i == 1) rtrue;       !  Adjudicate has made a multiple
                             !  object, and we pass it on
    }

    ! If i is non-zero here, one of two things is happening: either
    ! (a) an inference has been successfully made that object i is
    !     the intended one from the user's specification, or
    ! (b) the user finished typing some time ago, but we've decided
    !     on i because it's the only possible choice.
    ! In either case we have to keep the pattern up to date,
    ! note that an inference has been made and return.
    ! (Except, we don't note which of a pile of identical objects.)

    if (i ~= 0) {
        if (dont_infer) return i;
        if (inferfrom == 0) inferfrom=pcount;
        pattern-->pcount = i;
        return i;
    }

    ! If we get here, there was no obvious choice of object to make.

    if (match_from > num_words) etype = "You need to supply a noun as well.^";
	else etype = "You'll have to be more specific.^";
	rfalse;

]; ! end of NounDomain
-) instead of "Noun Domain" in "Parser.i6t".





Section - Disable "someone, do something" and "someone, hello"

Include (-
        ! Only check for a comma (a "someone, do something" command) if we are
        ! not already in the middle of one.  (This simplification stops us from
        ! worrying about "robot, wizard, you are an idiot", telling the robot to
        ! tell the wizard that she is an idiot.)

        if (actor == player) {
            for (j=2 : j<=num_words : j++) {
                i=NextWord();
                if (i == comma_word) jump Conversation;
            }
        }
        jump NotConversation;
!         jump GiveError;

        ! NextWord nudges the word number wn on by one each time, so we've now
        ! advanced past a comma.  (A comma is a word all on its own in the table.)

      .Conversation;

        j = wn - 1;
        if (j == 1) {
            L__M(##Miscellany, 22);
            jump ReType;
        }

        ! Use NounDomain (in the context of "animate creature") to see if the
        ! words make sense as the name of someone held or nearby

        wn = 1; lookahead = HELD_TOKEN;
        scope_reason = TALKING_REASON;
        l = NounDomain(player,actors_location,6);
        scope_reason = PARSING_REASON;
        if (l == REPARSE_CODE) jump ReParse;
        if (l == 0) {
            if (verb_word && ((verb_word->#dict_par1) & 1)) jump NotConversation;
            L__M(##Miscellany, 23);
            jump ReType;
        }

      .Conversation2;

        ! The object addressed must at least be "talkable" if not actually "animate"
        ! (the distinction allows, for instance, a microphone to be spoken to,
        ! without the parser thinking that the microphone is human).

        if (l hasnt animate && l hasnt talkable) {
            L__M(##Miscellany, 24, l);
            jump ReType;
        }

        ! Check that there aren't any mystery words between the end of the person's
        ! name and the comma (eg, throw out "dwarf sdfgsdgs, go north").

        if (wn ~= j) {
            L__M(##Miscellany, 25);
            jump ReType;
        }

        ! The player has now successfully named someone.

!		print "You don't need to talk to anyone in this game.^^";
		print "You don't have to name anyone -- just give the command and
",(name) l, " will try it soon enough.^";
		jump ReType;

      ! end of first-word-not-a-verb
-) instead of "Parser Letter C" in "Parser.i6t".




Section - Disable multiple commands

Include (-
        for (pcount=1 : : pcount++) {
            pattern-->pcount = PATTERN_NULL; scope_token = 0;

            token = line_token-->(pcount-1);
            lookahead = line_token-->pcount;

            #Ifdef DEBUG;
            if (parser_trace >= 2)
                print " [line ", line, " token ", pcount, " word ",
wn, " : ", (DebugToken) token,
                  "]^";
            #Endif; ! DEBUG

            if (token ~= ENDIT_TOKEN) {
                scope_reason = PARSING_REASON;
                AnalyseToken(token);

                l = ParseToken(found_ttype, found_tdata, pcount-1, token);
                while ((l >= GPR_NOUN) && (l < -1)) l =
ParseToken(ELEMENTARY_TT, l + 256);
                scope_reason = PARSING_REASON;

                if (l == GPR_PREPOSITION) {
                    if (found_ttype~=PREPOSITION_TT &&
(found_ttype~=ELEMENTARY_TT ||
                        found_tdata~=TOPIC_TOKEN)) params_wanted--;
                    l = true;
                }
                else
                    if (l < 0) l = false;
                    else
                        if (l ~= GPR_REPARSE) {
                            if (l == GPR_NUMBER) {
                                if (nsns == 0) special_number1 = parsed_number;
                                else special_number2 = parsed_number;
                                nsns++; l = 1;
                            }
                            if (l == GPR_MULTIPLE) l = 0;
                            parser_results-->(parameters+INP1_PRES) = l;
                            parameters++;
                            pattern-->pcount = l;
                            l = true;
                        }

                #Ifdef DEBUG;
                if (parser_trace >= 3) {
                    print "  [token resulted in ";
                    if (l == REPARSE_CODE) print "re-parse request]^";
                    if (l == 0) print "failure with error type ", etype, "]^";
                    if (l == 1) print "success]^";
                }
                #Endif; ! DEBUG

                if (l == REPARSE_CODE) jump ReParse;
                if (l == false) break;
            }
            else {

                ! If the player has entered enough already but there's still
                ! text to wade through: store the pattern away so as to be able to produce
                ! a decent error message if this turns out to be the best we ever manage,
                ! and in the mean time give up on this line

                ! However, if the superfluous text begins with a comma or "then" then
                ! take that to be the start of another instruction

                if (wn <= num_words) {
                    l = NextWord();
                    if (l == THEN1__WD or THEN2__WD or THEN3__WD or comma_word) {
					if (wn <= num_words) {
						print "(You can only give one command at a time. The part after ~";
						PrintCommand();
						print "~ will be ignored.)^";
						CommandClarificationBreak();
					}
                    }
                    else {
                        for (m=0 : m<32 : m++) pattern2-->m = pattern-->m;
                        pcount2 = pcount;
                        etype = UPTO_PE;
                        break;
                    }
                }

                ! Now, we may need to revise the multiple object because of the single one
                ! we now know (but didn't when the list was drawn up).
                if (parameters >= 1 && parser_results-->INP1_PRES == 0) {
                   l = ReviseMulti(parser_results-->INP2_PRES);
                   if (l ~= 0) { etype = l; parser_results-->ACTION_PRES = action_to_be; break; }
                }
                if (parameters >= 2 && parser_results-->INP2_PRES == 0) {
                   l = ReviseMulti(parser_results-->INP1_PRES);
                   if (l ~= 0) { etype = l; break; }
                }

                ! To trap the case of "take all" inferring only "yourself" when absolutely
                ! nothing else is in the vicinity...

                if (take_all_rule == 2 && parser_results-->INP1_PRES == actor) {
                   best_etype = NOTHING_PE;
                   jump GiveError;
                }

                #Ifdef DEBUG;
                if (parser_trace >= 1) print "[Line successfully parsed]^";
                #Endif; ! DEBUG

                ! The line has successfully matched the text.  Declare the input error-free...

                oops_from = 0;

                ! ...explain any inferences made (using the pattern)...

                if (inferfrom ~= 0) {
                	PrintInferredCommand(inferfrom);
                    ClearParagraphing();
                }

                ! ...copy the action number, and the number of parameters...

                parser_results-->ACTION_PRES = action_to_be;
                parser_results-->NO_INPS_PRES = parameters;

                ! ...reverse first and second parameters if need be...

                if (action_reversed && parameters == 2) {
                    i = parser_results-->INP1_PRES;
                    parser_results-->INP1_PRES = parser_results-->INP2_PRES;
                    parser_results-->INP2_PRES = i;
                    if (nsns == 2) {
                        i = special_number1; special_number1 = special_number2;
                        special_number2 = i;
                    }
                }

                ! ...and to reset "it"-style objects to the first of these parameters, if
                ! there is one (and it really is an object)...

                if (parameters > 0 && parser_results-->INP1_PRES >= 2)
                    PronounNotice(parser_results-->INP1_PRES);

                ! ...and return from the parser altogether, having successfully matched
                ! a line.

                if (held_back_mode == 1) {
                    wn=hb_wn;
                    jump LookForMore;
                }
                rtrue;

            } ! end of if(token ~= ENDIT_TOKEN) else
        } ! end of for(pcount++)

        .LineFailed;
        ! The line has failed to match.
        ! We continue the outer "for" loop, trying the next line in the grammar.

        if (etype > best_etype) best_etype = etype;
        if (etype ~= ASKSCOPE_PE && etype > nextbest_etype)
nextbest_etype = etype;

        ! ...unless the line was something like "take all" which failed because
        ! nothing matched the "all", in which case we stop and give an error now.

        if (take_all_rule == 2 && etype==NOTHING_PE) break;

    } ! end of for(line++)

    ! The grammar is exhausted: every line has failed to match.
-) instead of "Parser Letter G" in "Parser.i6t".




Chapter - Actions

[Lots of text replaced with text that mentions the actor. Much of this may be removed if I introduce the alternative layout mentioned at the beginning of the source. But I'm not sure if that's a good idea or not!]

Section - Singing

A person has a number called the singing number. The singing number of a person is usually 1.

Instead of an actor singing:
	if the singing number of the actor is:
		-- 1: say "[The actor] sings '[italic type]Frère Jacques, frère Jacques,[roman type]'.";
		-- 2: say "[The actor] sings '[italic type]Dormez-vous? Dormez-vous?[roman type]'.";
		-- 3: say "[The actor] sings '[italic type]Sonnez les matines! Sonnez les matines![roman type]'.";
		-- 4: say "[The actor] sings '[italic type]Din, dan, don. Din, dan, don.[roman type]'.";
	increase the singing number of the actor by 1;
	if the singing number of the actor is 5, now the singing number of the actor is 1.


Section - Jumping

Instead of an actor jumping:
	say "[The actor] jumps with a soft 'thump'.".


Section - Waiting

Instead of an actor waiting:
	say "[The actor] remains absolutely silent."


Section - Looking

Check an actor looking:
	if the actor is not Een, say "[The actor] looks at the surroundings." instead.


Section - Examining

Instead of an actor examining:
	say "[The actor] examines [the noun] with obvious interest.".


Section - Inventory

Instead of an actor taking inventory:
	say "[The actor] carries:[line break]";
	list the contents of the actor, with newlines, indented, giving inventory information, including contents, with extra indentation.

Section - Taking

The can't take people's possessions rule is not listed in any rulebook.

Check an actor taking (this is the new can’t take people’s possessions rule):
	let the local ceiling be the common ancestor of the actor with the noun;
	let H be the not-counting-parts holder of the noun;
	while H is not nothing and H is not the local ceiling:
		if H is a person:
			say "[The actor]: [=> noun][that|those] seem[-s] to belong to [H].";
			stop the action;
		let H be the not-counting-parts holder of H.

Section - Custom Library Messages

[There are undoubtedly things missing here! Search the right line in David Fisher's extension.]

Table of custom library messages (continued)
Message Id							Message Text
LibMsg <report player taking>			"[The actor]: Taken."
LibMsg <report player removing>			"[The actor]: Removed."
LibMsg <report player dropping>			"[The actor]: Dropped."
LibMsg <report player eating>			"[The actor] [eats*] [the % dobj]. Not bad."
LibMsg <cannot take hidden parts>		"[The actor]: [That|those] [isn't|aren't] available."
LibMsg <cannot open something already open>		"[The actor]: [That's|they're] already open."
LibMsg <block climbing>				"[The actor]: I don't think much [if lm_past]would have been[otherwise]is to be[end if] achieved by that."
LibMsg <cannot close something already closed>		"[The actor]: [That's|they're] already closed."
LibMsg <cannot reach within closed containers>	"[The actor]: [The %] [isn't|aren't] open."
LibMsg <cannot insert into closed containers>		"[The actor]: [The %] [is|are] closed."

Section - Exiting

The describe room emerged into rule is not listed in any rulebook.

Check an actor exiting:
	if the actor is not in the elevator, say "[The actor] tries to get out of the elevator".

This is the new can’t exit when not inside anything rule:
	let the local room be the location of the actor;
	if the container exited from is the local room:
		say "[The actor] tries to get out, but is not inside anything.";
		stop the action.

The new can't exit when not inside anything rule is listed instead of the can't exit when not inside anything rule in the check exiting rulebook.

This is the new can’t exit closed containers rule:
	if the actor is in a closed container (called the cage):
		say "[The actor] attempts to exit [the cage], but it is closed.";
		stop the action.

The new can't exit closed containers rule is listed instead of the can't exit closed containers rule in the check exiting rulebook.


Exiting from is an action applying to one thing. Understand "exit [something]" as exiting from. Understand "get out of [something]" as exiting from.

Check an actor exiting from:
	if the noun is not the holder of the actor, say "[The actor] attempts to exit [the noun], but isn't in it." instead;
	try the actor exiting instead.


Section - Touching

Instead of an actor touching:
	say "[The actor] touches [the noun].".


Section - Getting off

The describe room stood up into rule is not listed in any rulebook.






Chapter - New variables, kinds of value, etc

Section - Place

[Place is used in puzzle 1 and 2. Check it out.]

Place is a kind of value. The places are lower, upper and wherever.

A thing has a place. The place of a thing is usually wherever.

Before an actor doing anything:
	let S be the current action;
	if the noun part of S is not nothing and the noun part of S is a thing:
		if the place of the noun part of S is not wherever:
			if the place of the noun part of S is not the place of the actor part of S:
				if the action name part of S is not the examining action:
					say "[The actor] cannot reach [the noun].";
					stop the action;
	if the second noun part of S is not nothing and the second noun part of S is a thing:
		if the place of the second noun part of S is not wherever:
			if the place of the noun part of S is not the place of the actor part of S:
				if the action name part of S is not the showing it to action and the action name part of S is not the throwing it at action:
					say "[The actor] cannot reach [the noun].";
					stop the action;
	continue the action.

To say listing of lower people:
	let X be the number of lower persons;
	let Y be X;
	if X is 0, say "nobody is";
	repeat with Guy running through lower persons:
		say "[Guy]";
		decrease Y by 1;
		if Y is not 0 and Y is not 1, say ", ";
		if Y is 1 and X is not 1, say " and ";
		if Y is 0 and X is 1, say " is";
		if Y is 0 and X is not 1, say " are".

To say listing of upper people:
	let X be the number of upper persons;
	let Y be X;
	if X is 0, say "nobody is";
	repeat with Guy running through upper persons:
		say "[Guy]";
		decrease Y by 1;
		if Y is not 0 and Y is not 1, say ", ";
		if Y is 1 and X is not 1, say " and ";
		if Y is 0 and X is 1, say " is";
		if Y is 0 and X is not 1, say " are".

Section - Playing

[This verb is used in puzzles 1 and 2]

Playing is an action applying to one thing. Understand "play [something]" as playing.

Instead of playing: say "[The actor] attempts to play [the noun], but it is not an instrument.".

Section - the All token

[In fact, we have abolished all altogether, but I'm leaving it here for the moment.]

Rule for deciding whether all includes scenery: it does not.

Rule for deciding whether all includes persons: it does not.



Chapter - Changing between puzzles

[The puzzle number is a number that tells us what the current puzzle is.]

The puzzle number is a number that varies.

After printing the banner text:
	now the puzzle number is 1; [CHANGE THIS FOR TESTING! Should be "1" in the release.]
	consider the reset the puzzle rulebook.

The initial room description rule is not listed in the startup rules. [Because the reset the puzzle rules will do this for us.]

Reset the puzzle is a rulebook. [This rulebook contains a rule for each puzzle, which fires only if the puzzle number is right.]

Resetting the puzzle is an action out of world. Understand "reset puzzle" and "reset" and "restart puzzle" as resetting the puzzle.

Carry out resetting the puzzle:
	say "Resetting the puzzle...";
	consider the reset the puzzle rulebook.
	
Understand "restart" as a mistake ("You must either type 'restart puzzle' to restart this particular puzzle, or 'restart game' to restart the entire game. If you do the latter, all puzzles will be considered unsolved!").

Understand "restart game" as restarting the game.

Going to the next puzzle is an action out of world. Understand "next puzzle" as going to the next puzzle.

Carry out going to the next puzzle:
	if the puzzle number is 8, say "This is (currently) the final puzzle!" instead;
	choose row puzzle number + 1 in the Table of Solutions;
	if the Solved entry is not blocked:
		increase the puzzle number by 1;
		consider the reset the puzzle rulebook;
	otherwise:
		say "You must first unlock that puzzle." instead.

Going to the previous puzzle is an action out of world. Understand "previous puzzle" as going to the previous puzzle.

Carry out going to the previous puzzle:
	if the puzzle number is 1, say "This is the first puzzle!" instead;
	decrease the puzzle number by 1;
	consider the reset the puzzle rulebook.

Backstage is a room. "Please type 'menu'." [Here we drop everything we don't need.]

Check an actor looking:
	if the actor is enclosed by backstage, do nothing instead.

The banner boolean is a truth state that varies. The banner boolean is true. [We want to clear the screen when a new puzzle is started, but not when the game starts, because that would make the banner unreadable.]

First reset the puzzle rule (this is the clear the screen rule): [We clear the screen when a new puzzle starts, except the first time the game is started, when this would make the banner text unreadable.]
	if the banner boolean is true:
		now the banner boolean is false;
	otherwise:
		clear the screen.

First reset the puzzle rule (this is the empty everything rule): [We put everything into backstage. The individual puzzle puts back whatever is needed.]
	now the reset boolean is true;
	repeat with X running through things:
		if X is not part of something, move X to backstage;
	now the reset boolean is false.

Last reset the puzzle rule (this is the empty the Table of Melodies rule): [We remove all stored actions from the Table of Melodies]
	repeat with N running from 1 to 14: [because 15 rows]
		choose row N in the Table of Melodies;
		let Q be the Twee Stored Action in row 15 of the Table of Melodies;
		now the Twee Stored Action entry is Q;
		let Q be the Drie Stored Action in row 15 of the Table of Melodies;
		now the Drie Stored Action entry is Q;
		let Q be the Vier Stored Action in row 15 of the Table of Melodies;
		now the Vier Stored Action entry is Q.

Last reset the puzzle rule (this is the clear tmpcmd rule):
	now tmpcmd is "wait". [useful for again]

Last reset the puzzle rule (this is the look after resetting rule): [Otherwise we won't have a room description.]
	try looking.

The reset boolean is a truth state that varies.

Check an actor looking: [To stop four look commands in a row when the four actors are moved to the scene.]
	if the reset boolean is true, do nothing instead.






Part - Keeping Score and the Main Menu

Chapter - Main menu

Menuing is an action out of world. Understand "menu" and "about" and "info" and "help" as menuing.

Carry out menuing:
	change the current menu to the Table of Options;
	carry out the displaying activity;
	clear the screen;
	try looking.

Table of Options
title				subtable				description				toggle
"About this game"	Table of About	""					a rule
"Puzzle 1 - Rise and Fall ([sol 1])"		--		--					puzzle one jump rule
"Puzzle 2 - Instant Vertical Movement ([sol 2])"		--		--			puzzle two jump rule
"Puzzle 3 - Taking a Bite ([sol 3])"		--		--					puzzle three jump rule
"Puzzle 4 - Go Add and Multiply ([sol 4])"	--		--					puzzle four jump rule
"Puzzle 5 - Cardinal Directions ([sol 5])"	--		--					puzzle five jump rule
"Puzzle 6 - Running in Circles ([sol 6])"	--		--					puzzle six jump rule
"Puzzle 7 - Burgundy Banana ([sol 7])"	--		--					puzzle seven jump rule
"Puzzle 8 - Canon in Contrary Motion ([sol 8])"		--		--			puzzle eight jump rule

Table of About
title				subtable				description				toggle
"What kind of game is this?"		a table-name		"[italic type]The Art of Fugue[roman type] is a pure puzzle game. However, these puzzles are different in nature than those of typical interactive fiction works like [italic type]Zork[roman type], [italic type]Curses[roman type] and [italic type]Anchorhead[roman type]. In [italic type]The Art of Fugue[roman type], the rules of each puzzle will become clear very quickly; in order to reach the goal, one must logically apply the rules. Some of the puzzles require a bit more of a creative leap, but in general this game is more like a chess problem than it is like a standard IF/adventure puzzle."		a rule
"How does interactive fiction work?"		--			"In interactive fiction, you type commands that the protagonist will then act out. Some commands to get you started in the first puzzle are: 'enter elevator', 'exit elevator', 'push button', 'hit chau gong', 'wait'."		--
"How does this game work?"		--				"If you play it for a few turns, it should become obvious. Just type 'sing', 'jump', 'sing', 'sing', 'wait', or something like that, and see what happens.[paragraph break]But if you [italic type]really[roman type] want an explanation, it is this. There are four characters, Een, Twee, Drie and Vier. Whatever command you give is executed by Een. Then, next turn, it is executed by Twee; the turn after that by Drie; and finally, by Four. Of course, in the meantime Een has been able to do three other actions, which might well change the state of the world and influence what later actors can do.[paragraph break]It may be useful to know that it is commands rather than actions that are repeated. The difference is that commands are not yet parsed: it is the raw text you typed in. So if you typed 'take black' in the presence of a black hat, the hat will be taken. But if three turns later Vier tries the same thing in the presence of a black lotus, he will take the lotus."		--
"Who made this game?"			--				"This game was made by Victor Gijsbers, Jimmy Maher, Dorte Lassen and Johan. Specifically, Victor Gijsbers coded the main game engine and puzzles 1, 2, 3, 4, 6 and 7; Jimmy Maher coded puzzle 5; Dorte Lassen coded puzzle 5; Johan did some very useful parser hacking."		--
"Who wrote the music? How do I turn it off and on?"		--		"There are versions of [italic type]The Art of Fugue[roman type] with and without music. If you have the version with music, you will be hearing the [italic type]Große Fuge[roman type] of Ludwig van Beethoven (opus 133). It is performed on electric guitar by Daniel Bautista, and released under the Attribution-ShareAlike 3.0 Unported license. Check out his entire Beethoven album and other works on http://www.jamendo.com/en/album/27602.[paragraph break]You can turn the music on and off with the commands 'music on' and 'music off'. (If the game doesn't know these commands, you have the version without music. If it does but you don't hear anything, perhaps you interpreter does not support sound.)"		--
"Can I still contribute?"	--	"YES! I would very much like to have more puzzles, so if you'd like to code one, or already have coded one, let me know. You should be able to get the source code wherever you got the game. Ideally, the game should have about 20 puzzles. (Which is also why I have not yet used the best-known fugue composers in the victory messages -- Bach is reserved for puzzle 20.)"	--
"How do I get in contact with the authors?"	--		"You can send an email to Victor Gijsbers at victor@lilith.cc. Since email-addresses tend not to have eternal life, you may want to google me first if you are reading this many years after 2009. Since search engines may not have eternal life either, please substitute anything you like for 'google'."		--
"I need puzzle solutions!"			--			"There are no solutions given within the game. Your best bet is to go to the interactive fiction newsgroup, rec.games.int-fiction (use Google Groups if you do not know what a newsgroup is), or the interactive fiction forum, http://www.intfiction.org/forum/index.php."			--
"How is this game licensed?"			--			"This game is licensed under the GNU General Public License version 3, or any later version. Please read http://www.gnu.org/licenses/gpl-3.0.html for details. Distilled to its basics: you may freely distribute this game, learn from the source code, reuse the source code, change the game, and redistribute modified versions. But any derivative works must be licensed under the same license, and be accompanied by their source code."		--

To say sol (N - a number):
	choose row N in the Table of Solutions;
	say "[Solved entry]" in upper case;
	if the solved entry is solved:
		say " using [Player Score entry] of [Best Score entry] needed moves".

To change the puzzle from the menu:
	consider the reset the puzzle rulebook;
	change menu depth to menu depth - 1;
	rule succeeds.

To do the (N - a number) jump:
	choose row N in the Table of Solutions;
	if the Solved entry is not blocked:
		now the puzzle number is N;
		change the puzzle from the menu.

This is the puzzle one jump rule:
	do the 1 jump.

This is the puzzle two jump rule:
	do the 2 jump.

This is the puzzle three jump rule:
	do the 3 jump.

This is the puzzle four jump rule:
	do the 4 jump.

This is the puzzle five jump rule:
	do the 5 jump.

This is the puzzle six jump rule:
	do the 6 jump.

This is the puzzle seven jump rule:
	do the 7 jump.

This is the puzzle eight jump rule:
	do the 8 jump.

This is the puzzle nine jump rule:
	do the 9 jump.

This is the puzzle ten jump rule:
	do the 10 jump.



Section - Cheat code

Unblocking all puzzles is an action out of world. Understand "bwv1080" as unblocking all puzzles.

Carry out unblocking all puzzles:
	repeat with N running from 1 to 20:
		choose row N in the Table of Solutions;
		if the solved entry is blocked, now the solved entry is unsolved;
	say "All puzzles unblocked.".


Chapter - Keeping score

Solvedness is a kind of value. The solvednesses are Blocked, Unsolved and Solved.

Table of Solutions
Puzzle number		Solved			Player Score		Best Score
1					unsolved			500				7
2					unsolved			500				13
3					unsolved			500				13
4					blocked			500				33
5					blocked			500				12
6					blocked			500				27
7					blocked			500				34
8					blocked			500				24
9					blocked			500				500
10					blocked			500				500
11					blocked			500				500
12					blocked			500				500
13					blocked			500				500
14					blocked			500				500
15					blocked			500				500
16					blocked			500				500
17					blocked			500				500
18					blocked			500				500
19					blocked			500				500
20					blocked			500				500

Section - Keeping track of the player's solution

The move counter is a number that varies. The move counter is 0.

Table of Player Solution
Move
indexed text
with 500 blank rows

First reset the puzzle rule (this is the reset the move counter and table rule):
	now the move counter is 0;
	repeat with N running from 1 to 500:
		choose row N in Table of Player Solution;
		now the move entry is "".


Section - Upon solving a puzzle

To finish solving the puzzle:
	choose row puzzle number in the Table of Solutions;
	say "You needed [move counter] moves to solve this puzzle; ";
	if the solved entry is solved:
		say "your previous record was [player score entry]; ";
	say "the best known solution is [best score entry].[run paragraph on]";
	if the move counter is less than the player score entry, now the player score entry is the move counter;
	if the move counter is less than the best score entry:
		say " [bold type]This is a new record![roman type] Please email your solution to victor@lilith.cc, so we can put it in the next release of [italic type]The Art of Fugue[roman type].[run paragraph on]";
	if the solved entry is not solved:
		now the solved entry is solved;
		repeat with N running from 1 to 20:
			choose row N in the Table of Solutions;
			if the solved entry is blocked:
				now the solved entry is unsolved;
				say "[paragraph break]A new puzzle has been unlocked!";
				break;
	say "[paragraph break]Would you like to print your solution to the screen (so you can easily copy/paste it)?";
	now count is 0; [Without this, the game locks up if count is not 0 at this point!]
	ask a closed question, in yes/no mode.

A yes/no question rule:
	if the decision understood is Yes:
		repeat with N running from 1 to move counter:
			choose row N in Table of Player Solution;
			if N is not move counter, say "[Move entry] / ";
			if N is move counter, say "[Move entry].[paragraph break]";
		wait for any key;
	now count is 3;
	now the player is Een;
	try going to the next puzzle.
	















[This is where the puzzles start!]






Part - Puzzles



[I haven't commented the puzzles yet. Look at the third or the fourth puzzle for the simplest syntax, but none of them should be too hard to understand.]


Chapter - First Puzzle

Reset the puzzle rule (this is the set up the first puzzle rule):
	if the puzzle number is 1:
		now the reset boolean is true;
		move Een to First Puzzle;
		move Twee to First Puzzle;
		move Drie to First Puzzle;
		move Vier to First Puzzle;
		now the reset boolean is false;
		move elevator to First Puzzle;
		move white button to First Puzzle;
		move chau gong to First Puzzle;
		move nipple gong to First Puzzle;
		move agung double gong to First Puzzle;
		repeat with X running through things enclosed by First Puzzle:
			now the place of X is lower;
		now the place of chau gong is upper;
		now the place of nipple gong is upper;
		now the place of the white button is wherever;
		now gong counter is 0.



The description of First Puzzle is "This room consists of two levels, a lower level (where [listing of lower people]) and an upper level (where [listing of upper people]). The levels are connected by a small elevator, which is currently on the [bold type][place of the elevator][roman type] level. There is a white button next to the elevator on both levels. In addition, the upper level contains a chau gong and a nipple gong, and the lower level an agung double gong.[paragraph break][bold type]In order to win, you must hit all four gongs within a single turn.[roman type]".



The elevator is a thing. The elevator is scenery. The elevator is an enterable open transparent container. Understand "lift" as the elevator.

Instead of examining the elevator when the puzzle number is 1:
	say "[The actor]: a small lift. In order to use it, one must enter it, then press the white button.".

Check an actor entering the elevator when the puzzle number is 1:
	if the place of the actor is not the place of the elevator, say "[The actor] cannot enter the elevator, since it is on a different level." instead;
	if there is a person in the elevator, say "[The actor] cannot enter the elevator, since [a random person in the elevator] is already in it." instead.

Instead of going up when the puzzle number is 1:
	say "[The actor] looks around puzzled. (You'll have to use the elevators by entering them and pressing the button.)".

Instead of going down when the puzzle number is 1:
	say "[The actor] looks around puzzled. (You'll have to use the elevators by entering them and pressing the button.)".



The white button is a thing. It is scenery.

Instead of examining the white button when the puzzle number is 1:
	say "[The actor]: it is a simple white button, reachable from within the elevator."

Instead of an actor pushing the white button when the puzzle number is 1:
	say "[The actor] pushes the white button, and the elevator immediately [if the place of the elevator is lower]rises[otherwise]descends[end if].";
	let X be the place of the elevator;
	if X is lower, now the place of the elevator is upper;
	if X is upper, now the place of the elevator is lower;
	repeat with Y running through persons enclosed by the elevator:
		now the place of Y is the place of the elevator.


The gong counter is a number that varies.

Last every turn when the puzzle number is 1: if count is 0, now the gong counter is 0.


The chau gong is scenery.

Instead of examining the chau gong when the puzzle number is 1: say "[The actor]: the chau gong is made of copper-based alloy, bronze in this case. It is almost flat except for the rim, which is turned up to make a shallow cylinder. Traditionally, chau gongs were used to clear the way for important officials and processions."

Instead of an actor attacking the chau gong when the puzzle number is 1:
	say "[The actor] hits the chau gong. [italic type]Beng![roman type][paragraph break]";
	increase the gong counter by 25.

Instead of an actor playing the chau gong:
	try the actor attacking the chau gong instead.



The nipple gong is scenery.

Instead of examining the nipple gong when the puzzle number is 1: say "[The actor]: it's a huge, eight feet high nipple gong, so called for the raised boss or nipple in the centre.".

Instead of an actor attacking the nipple gong when the puzzle number is 1:
	say "[The actor] strikes the nipple gong, producing a clear resonant tone. [italic type]Bong![roman type][paragraph break]";
	increase the gong counter by 5.

Instead of an actor playing the nipple gong:
	try the actor attacking the nipple gong instead.



The agung double gong is scenery.

Instead of examining the agung double gong when the puzzle number is 1: say "[The actor]: the agung is a set of two wide-rimmed, vertically-suspended gongs used in the Philippines as a supportive instrument. One person can only hit one of these gongs in a single turn."

Instead of an actor attacking the agung double gong when the puzzle number is 1:
	let X be the remainder after dividing the gong counter by 25;
	let Y be the remainder after dividing X by 5;
	if Y is odd, say "[The actor] hits the second gong. [italic type]Bing![roman type][paragraph break]";
	if Y is even, say "[The actor] hits the first gong. [italic type]Bang![roman type][paragraph break]";
	increase the gong counter by 1.

Instead of an actor playing the agung double gong:
	try the actor attacking the agung double gong instead.



Every turn when the puzzle number is 1 (this is the winning the first puzzle rule):
	if the gong counter is 32:
		say "[bold type]You have SOLVED the first puzzle! Dieterich Buxtehude would be proud of you.[roman type][paragraph break][paragraph break]";
		finish solving the puzzle.



Chapter - Second Puzzle

Reset the puzzle rule (this is the set up the second puzzle rule):
	if the puzzle number is 2:
		now the reset boolean is true;
		move Een to Second Puzzle;
		move Twee to Second Puzzle;
		move Drie to Second Puzzle;
		move Vier to Second Puzzle;
		now the reset boolean is false;
		move chau gong to Second Puzzle;
		move nipple gong to Second Puzzle;
		move agung double gong to Second Puzzle;
		move blue button to Second Puzzle;
		move dummy_lift to Second Puzzle;
		repeat with X running through things enclosed by Second Puzzle:
			now the place of X is lower;
		now the place of chau gong is upper;
		now the place of nipple gong is upper;
		now the place of the blue button is wherever;
		now gong counter is 0;
		now the power boolean is false;
		now the superfast automatic lift state is 0;
		now the place of the superfast automatic lifts is wherever;
		now the place of dummy_lift is wherever;
		now the lift A place is lower;
		now the lift B place is lower.

Second Puzzle is a room. "This room again consists of two levels, a lower level (where [listing of lower people]) and an upper level (where [listing of upper people]). These levels are connected by two super-fast automatic lifts: just type 'up' or 'down', and there you go! Currently, lift A is turned [if the superfast automatic lift state is less than 2]on[otherwise]off[end if] and at the [lift A place] level;  lift B is turned [if the superfast automatic lift state is even]on[otherwise]off[end if] and at the [lift B place] level.[paragraph break]There is also a blue button on each level, and, again, a chau gong and a nipple gong on the upper, and an agung double gong on the lower level.[paragraph break][bold type]In order to win, you must hit all four gongs within a single turn.[roman type]"

The blue button is scenery.

Instead of examining the blue button:
	say "[The actor]: the lower blue button switches on and off the elevators. Pressing it will cycle through four options: both lifts turned on, only lift A turned on, only lift B turned on, and both lifts turned off. The upper blue button switches on and off the power needed to play the electric gongs.".

The power boolean is a truth state that varies. The power boolean is false.


Instead of an actor pushing the blue button when the puzzle number is 2:
	if the place of the actor is upper:
		if the power boolean is true:
			say "[The actor] presses the upper blue button, thus turning off the power.";
			now the power boolean is false;
		otherwise:
			say  "[The actor] presses the upper blue button, thus turning on the power.";
			now the power boolean is true;
	if the place of the actor is lower:
		increase the superfast automatic lift state by 1;
		if the superfast automatic lift state is 4, now the superfast automatic lift state is 0;
		say "[The actor] presses the lower blue button. Lift A is now turned [if the superfast automatic lift state is less than 2]on[otherwise]off[end if]; lift B is now turned [if the superfast automatic lift state is even]on[otherwise]off[end if].".

The superfast automatic lift state is a number that varies.

The lift A place is a place that varies. The lift B place is a place that varies.

The superfast automatic lifts is scenery. It is an open enterable transparent container.  Understand "lift" and "elevator" and "elevators" as the superfast automatic lifts.

The dummy_lift is scenery. Understand "lift A" and "lift B" and "elevator A" and "elevator B" and "A" and "B" as the dummy_lift.

Instead of an actor doing anything with the dummy_lift:
	say "[The actor]: you cannot refer to the lifts by name. Just type 'up' and 'down' if you wish to move. Incidentally, an actor will prefer lift A if both are available.".

Instead of examining the superfast automatic lifts when the puzzle number is 2:
	say "[The actor]: currently, lift A is turned [if the superfast automatic lift state is less than 2]on[otherwise]off[end if] and at the [lift A place] level, while lift B is turned [if the superfast automatic lift state is even]on[otherwise]off[end if] and at the [lift B place].".


Instead of an actor going up when the puzzle number is 2:
	if the place of the actor is upper:
		say "[The actor] tries to go up, but is already on the upper level." instead;
	if the lift A place is lower and the superfast automatic lift state is less than 2:
		now the place of the actor is upper;
		now the lift A place is upper;
		say "[The actor] takes lift A up, and is now standing on the upper level." instead;
	if the lift B place is lower and the superfast automatic lift state is even:
		now the place of the actor is upper;
		now the lift B place is upper;
		say "[The actor] takes lift B up, and is now standing on the upper level." instead;
	say "[The actor] attempts to go up, but there is no lift avaibale.".

Instead of an actor going down when the puzzle number is 2:
	if the place of the actor is lower:
		say "[The actor] tries to go down, but is already on the lower level." instead;
	if the lift A place is upper and the superfast automatic lift state is less than 2:
		now the place of the actor is lower;
		now the lift A place is lower;
		say "[The actor] takes lift A down, and is now standing on the lower level." instead;
	if the lift B place is upper and the superfast automatic lift state is even:
		now the place of the actor is lower;
		now the lift B place is lower;
		say "[The actor] takes lift B down, and is now standing on the lower level." instead;
	say "[The actor] attempts to go down, but there is no lift avaibale.".


Instead of an actor entering the superfast automatic lifts when the puzzle number is 2:
	say "[The actor] stares at the lifts in confusion. These lifts are so fast and automatic that going up and down is done with the commands 'up' and 'down'!".


Instead of examining the chau gong when the puzzle number is 2: say "[The actor]: the chau gong is made of copper-based alloy, bronze in this case. It is almost flat except for the rim, which is turned up to make a shallow cylinder. Traditionally, chau gongs were used to clear the way for important officials and processions. The chau gong is currently [if the power boolean is true]powered[else]unpowered[end if]."

Instead of an actor attacking the chau gong when the puzzle number is 2:
	if the power boolean is false:
		say "[The actor] hits the gong, but there is no sound. These gongs are electric, and must receive power!" instead;
	say "[The actor] hits the chau gong. [italic type]Beng![roman type][paragraph break]";
	increase the gong counter by 25.



Instead of examining the nipple gong when the puzzle number is 2: say "[The actor]: it's a huge, eight feet high nipple gong, so called for the raised boss or nipple in the centre. The nipple gong is currently [if the power boolean is true]powered[else]unpowered[end if].".

Instead of an actor attacking the nipple gong when the puzzle number is 2:
	if the power boolean is false:
		say "[The actor] hits the gong, but there is no sound. These gongs are electric, and must receive power!" instead;
	say "[The actor] strikes the nipple gong, producing a clear resonant tone. [italic type]Bong![roman type][paragraph break]";
	increase the gong counter by 5.


Instead of examining the agung double gong when the puzzle number is 2: say "[The actor]: the agung is a set of two wide-rimmed, vertically-suspended gongs used in the Philippines as a supportive instrument. One person can only hit one of these gongs in a single turn. The agung gong is currently [if the power boolean is true]powered[else]unpowered[end if]."

Instead of an actor attacking the agung double gong when the puzzle number is 2:
	if the power boolean is false:
		say "[The actor] hits the gong, but there is no sound. These gongs are electric, and must receive power!" instead;
	let X be the remainder after dividing the gong counter by 25;
	let Y be the remainder after dividing X by 5;
	if Y is odd, say "[The actor] hits the second gong. [italic type]Bing![roman type][paragraph break]";
	if Y is even, say "[The actor] hits the first gong. [italic type]Bang![roman type][paragraph break]";
	increase the gong counter by 1.

Last every turn when the puzzle number is 2: if count is 0, now the gong counter is 0.

Every turn when the puzzle number is 2 (this is the winning the second puzzle rule):
	if the gong counter is 32:
		say "[bold type]You have SOLVED the second puzzle! Girolamo Frescobaldi would be proud of you.[roman type][paragraph break][paragraph break]";
		finish solving the puzzle..



Chapter - Third Puzzle

Section - The chest kind


A chest is a kind of container. A chest is always openable and transparent. A chest is usually fixed in place. A chest is usually closed. The specification of a chest is "Represents a container with a separately implemented lid; the lid is itself a supporter."

A lid is a kind of supporter. A lid is part of every chest. A lid is usually enterable. The specification of a lid is "A supporter attached to a chest, which can only support things when the chest is closed."


Before opening a lid which is part of a chest (called the item):
	try opening the item instead.

Before closing a lid which is part of a chest (called the item):
	try closing the item instead.

[Before opening a chest when something is on the lid (called the obstruction) which is part of the noun:
	repeat with item running through things on the obstruction:
		say "(first removing [the item])";
		try taking the item.]

Check opening a chest (called the item):
	repeat with X running through lids:
		if X is part of item:
			if something is on X:
				say "[The actor] would have to remove [the list of things on X] from the lid first." instead.

Instead of looking under a lid which is part of a chest (called the item):
	try opening the item.




Before inserting something into a lid which is part of a chest (called the item):
	try inserting the noun into the item instead.

Before putting something on a chest when a lid (called the item) is part of the second noun:
	try putting the noun on the item instead.

Before putting something on a lid which is part of an open chest (called the item):
	say "(first closing [the item])";
	try closing the item.

Instead of putting something on a lid which is part of an open chest (called the item):
	say "[The actor]: [The item] would need to be closed first."



Check examining a closed chest (called item):
	repeat with X running through lids:
		if X is part of item:
			if something is on X:
				say "[The actor]: [The noun] is closed, and there [is-are a list of things on X] on top."

After printing the name of a chest (called the item) while listing contents of a room:
	if a lid (called the second item) which supports something is part of the item:
		say " (on which [is-are a list of things on the second item])";
		omit contents in listing.



Section - Puzzle itself


Third Puzzle is a room. "The room is bare except for a single wooden chest, which is currently [if the wooden chest is open]open[otherwise]closed[end if]. (And be sure to check your inventory.)[paragraph break][bold type]In order to win, all four characters must eat an apple within a single turn.[roman type]"

Reset the puzzle rule (this is the set up the third puzzle rule):
	if the puzzle number is 3:
		now the reset boolean is true;
		move Een to Third Puzzle;
		move Twee to Third Puzzle;
		move Drie to Third Puzzle;
		move Vier to Third Puzzle;
		now the reset boolean is false;
		move wooden chest to Third Puzzle;
		now the wooden chest is closed;
		repeat with X running through things enclosed by wooden chest:
			if X is not wooden chest's lid:
				move X to backstage;
		repeat with X running through things enclosed by wooden chest's lid:
			move X to backstage;
		let N be 1;
		repeat with X running through apples:
			if N is 1, move X to Een;
			if N is 2, move X to Twee;
			if N is 3, move X to Drie;
			if N is 4, move X to Vier;
			now N is N + 1.

An apple is a kind of thing. Instead of examining an apple: say "[The actor]: The apple looks very tasty.". There are four apples in backstage. An apple is edible.

The wooden chest is a chest. The wooden chest is scenery.

Instead of entering the wooden chest:
	if the wooden chest is open:
		say "[The actor] does not fit into the chest.";
	otherwise:
		try the actor entering wooden chest's lid instead.

Before an actor getting off the wooden chest:
	if the actor is on the wooden chest's lid, try the actor getting off the wooden chest's lid instead.

Check an actor entering the wooden chest's lid:
	if the wooden chest is open:
		say "[The actor] cannot climb the wooden chest when it's open." instead;
	repeat with X running through persons:
		if X is on the wooden chest's lid, say "[The actor] cannot get onto the wooden chest, since [X] is already there." instead.

Instead of climbing the chest:
	try the actor entering the wooden chest's lid instead.

The apple counter is a number that varies.

Last every turn (this is the reset the apple counter rule):
	if count is 0, now the apple counter is zero.

Carry out an actor eating an apple:
	increase the apple counter by 1.

				
Every turn when the puzzle number is 3 (this is the winning the third puzzle rule):
	if the apple counter is 4:
		say "[bold type]You have SOLVED the third puzzle! Johann Jakob Froberger would be proud of you.[roman type][paragraph break][paragraph break]";
		finish solving the puzzle.




Chapter - Fourth Puzzle

Fourth Puzzle is a room. "This room contains a huge calculator and a problem screen. Currently, the number on the calculator is [solution number] and the number on the problem screen is [problem number]. The calculator is [if the business is 0]silent[otherwise]spinning[end if].[paragraph break][bold type]In order to win, you must solve all the problems given to you by the problem screen.[roman type]"

Reset the puzzle rule (this is the set up the fourth puzzle rule):
	if the puzzle number is 4:
		now the reset boolean is true;
		move Een to Fourth Puzzle;
		move Twee to Fourth Puzzle;
		move Drie to Fourth Puzzle;
		move Vier to Fourth Puzzle;
		now the reset boolean is false;
		move the problem screen to Fourth Puzzle;
		move the calculator to Fourth Puzzle;
		now the solution number is 0;
		now the business is 0;
		now the problem number is 28;
		now the calculator number is 0.

The problem number is a number that varies. The solution number is a number that varies. The business is a number that varies. The calculator number is a number that varies.



The problem screen is in Fourth Puzzle. It is scenery.

Instead of examining the problem screen: say "[The actor] examines the problem screen. It says: 'Stabilise the calculator on the number [problem number]'."

The calculator is in Fourth Puzzle. It is scenery. Understand "lever" and "machine" as the calculator.

Instead of examining the calculator: say "[The actor]: This machine has an ADD-button and a MUL-button. It also has a lever which can be set, from left to right, to 0, 1, 2, ..., 8 and 9; it is presently at [calculator number]. A little screen on the calculator shows the number [solution number], and the machine is evidently [if the business is not 0]still spinning[otherwise]in a stable state[end if]." 

Spinning it to is an action applying to one thing and one number. Understand "set [something] to [a number]" as spinning it to. Understand "pull [something] to [a number]" as spinning it to. Understand "push [something] to [a number]" as spinning it to.

Check spinning it to:
	if the noun is not the calculator, say "You cannot set that to a value." instead;
	if the number understood is greater than 9, say "It only goes to 9." instead;
	if the number understood is less than 0, say "It only goes to 0." instead.

Carry out spinning it to:
	say "[The actor] sets [the noun] to [the number understood].";
	now the calculator number is the number understood;
	spin the machine.

Instead of pulling left the calculator:
	if the calculator number is 0, say "[The actor]: The lever is already in the leftmost position." instead;
	now the calculator number is the calculator number - 1;
	say "[The actor] sets the lever to [calculator number].";
	spin the machine.
	
Instead of pulling right the calculator:
	if the calculator number is 9, say "[The actor]: The lever is already in the rightmost position." instead;
	now the calculator number is the calculator number + 1;
	say "[The actor] sets the lever to [calculator number].";
	spin the machine.

The ADD-button is part of the calculator. Understand "add" as the add-button. Instead of examining the add-button: say "[The actor] sees nothing special about the button, except that it says 'ADD'."

Instead of pushing the ADD-button:
	now the solution number is the solution number + the calculator number;
	say "[The actor] presses the ADD-button, and the number on the display becomes [solution number].";
	spin the machine.

The MUL-button is part of the calculator. Understand "mul" as the mul-button. Instead of examining the add-button: say "[The actor] sees nothing special about the button, except that it says 'MUL'."

Instead of pushing the MUL-button:
	now the solution number is the solution number times the calculator number;
	say "[The actor] presses the MUL-button, and the number on the display becomes [solution number].";
	spin the machine.

To spin the machine:
	if the business is 1, now the business is 2;
	if the business is 0, now the business is 1.

Last every turn when the puzzle number is 4 and count is 0:
	if the business is not 0, now the business is the business - 1;
	if the business is 0:
		if the solution number is the problem number:
			now the solution number is 0;
			if the problem number is 1080:
				say "[bold type]You have SOLVED the fourth puzzle! Arcangelo Corelli would be proud of you.[roman type][paragraph break][paragraph break]";
				finish solving the puzzle;
			otherwise:
				if the problem number is 7, now the problem number is 1080;
				if the problem number is 30, now the problem number is 7;
				if the problem number is 28, now the problem number is 30;
				say "The problem board briefly shows: 'CONGRATULATIONS!' Then a new problem appears: 'Stabilise the calculator on the number [problem number]'.".




Chapter - Fifth Puzzle

[This puzzle by Jimmy Maher and Dorte Lassen]

Section - Compartment Doors

A compartment door is a kind of thing. It is scenery.
A compartment door can be open or closed. A compartment door is usually closed.
Understand "Doors" as a compartment door.

Instead of examining a compartment door: say "[The actor]: The door is currently [if the noun is open]open[otherwise]closed[end if]."

To flip (door - a compartment door):
	if door is open:
		say "[door] closes";
		now door is closed;
	otherwise:
		say "[door] opens";
		now door is open.

Section - The Puzzle Itself

Fifth Puzzle is a room. 
"This room is divided up into four compartments, each connected by a door on two of its walls, like so:

[fixed letter spacing]
=====================[line break]
|         |         |[line break]
|         |         |[line break]
|         =         |[line break]
|         |         |[line break]
|         |         |[line break]
|===|-|===|===|-|===|[line break]
|         |         |[line break]
|         |         |[line break]
|         =         |[line break]
|         |         |[line break]
|         |         |[line break]
=====================[line break]

[variable letter spacing]A white button is mounted on the wall of each compartment.[if the number of entries in NE compartment is greater than 0]

[occupants of NE compartment]in the northeast compartment.[end if][if the number of entries in SE compartment is greater than 0]

[occupants of SE compartment]in the southeast compartment.[end if][if the number of entries in SW compartment is greater than 0]

[occupants of SW compartment]in the southwest compartment.[end if][if the number of entries in NW compartment is greater than 0]

[occupants of NW compartment]in the northwest compartment.[end if]

[bold type]In order to win, Een, Twee, Drie, and Vier must each be in a separate room for three turns.[roman type]"

Reset the puzzle rule (this is the set up the fifth puzzle rule):
	if the puzzle number is 5:
		now the reset boolean is true;
		move Een to Fifth Puzzle;
		move Twee to Fifth Puzzle;
		move Drie to Fifth Puzzle;
		move Vier to Fifth Puzzle;
		now the reset boolean is false;
		move the white button to Fifth Puzzle;
		move door 1 to Fifth Puzzle;
		move door 2 to Fifth Puzzle;
		move door 3 to Fifth Puzzle;
		move door 4 to Fifth Puzzle;
		truncate NW compartment to 0 entries;
		truncate NE compartment to 0 entries;
		truncate SW compartment to 0 entries;
		truncate SE compartment to 0 entries;
		add {Een, Twee, Drie, Vier} to NW compartment;
		now door 1 is closed;
		now door 2 is closed;
		now door 3 is closed;
		now door 4 is closed;
		change the single counter to 0.

The single counter is a number that varies.

NW compartment is a list of people that varies.
NE compartment is a list of people that varies.
SE compartment is a list of people that varies.
SW compartment is a list of people that varies.

To say occupants of (quadrant - a list of people):
	if the number of entries in quadrant is greater than 0:
		say "[quadrant] [if the number of entries in quadrant is greater than 1]are [otherwise]is [end if]".

Instead of examining the white button when the puzzle number is 5:
	say "[The actor]: A simple white button. Pushing it will reverse the state of the doors in its room."

Door 1 is a compartment door in Fifth Puzzle.
The printed name is "[if the player is NW]east [otherwise]west [end if]door".

Door 2 is a compartment door in Fifth Puzzle.
The printed name is "[if the player is NE]south [otherwise]north [end if]door".

Door 3 is a compartment door in Fifth Puzzle.
The printed name is "[if the player is SE]west [otherwise]east [end if]door".

Door 4 is a compartment door in Fifth Puzzle.
The printed name is "[if the player is SW]north [otherwise]south [end if]door".

Definition: a person is NE if he is listed in the NE compartment.
Definition: a person is SE if he is listed in the SE compartment.
Definition: a person is SW if he is listed in the SW compartment.
Definition: a person is NW if he is listed in the NW compartment.

Understand "E door" and "E" and "east door" and "east" as door 1 when the player is NW.
Understand "W door" and "W" and "west door" and "west" as door 1 when the player is NE.

Understand "S door" and "S" and "south door" and "south" as door 2 when the player is NE.
Understand "N door" and "N" and "north door" and "north" as door 2 when the player is SE.

Understand "W door" and "W" and "west door" and "west" as door 3 when the player is SE.
Understand "E door" and "E" and "east door" and "east" as door 3 when the player is SW.

Understand "N door" and "N" and "north door" and "north" as door 4 when the player is SW.
Understand "S door" and "S" and "south door" and "south" as door 4 when the player is NW.



Instead of examining a direction when the puzzle number is 5: say "[The actor]: There is no door in that direction."

Understand "N door" and "north door" as north when the puzzle number is 5.
Understand "E door" and "east door" as east when the puzzle number is 5.
Understand "S door" and "south door" as south when the puzzle number is 5.
Understand "W door" and "west door" as west when the puzzle number is 5.

Instead of pushing the white button when the puzzle number is 5:
	if the player is NW:
		say "[The actor] pushes the button. The ";
		flip door 1;
		say " and the ";
		flip door 4;
		say ".";
	otherwise:
		if the player is NE:
			say "[The actor] pushes the button. The ";
			flip door 1;
			say " and the ";
			flip door 2;
			say ".";
		otherwise:
			if the player is SE:
				say "[The actor] pushes the button. The ";
				flip door 2;
				say " and the ";
				flip door 3;
				say ".";
			otherwise:
				say "[The actor] pushes the button. The ";
				flip door 3;
				say " and the ";
				flip door 4;
				say ".".


Instead of going when the puzzle number is 5:
	if the player is NW:
		if the noun is east:
			if door 1 is open:
				say "[The actor] moves east.";
				remove the player from the NW compartment;
				add the player to the NE compartment;
			otherwise:
				say "[The actor] tries to go east, but is blocked by a closed door.";
		otherwise:
			if the noun is south:
				if door 4 is open:
					say "[The actor] moves south.";
					remove the player from the NW compartment;
					add the player to the SW compartment;
				otherwise:
					say "[The actor] tries to go south, but is blocked by a closed door.";
			otherwise:
				say "[The Actor]: There is no door in that direction.";
	otherwise:
		if the player is NE:
			if the noun is west:
				if door 1 is open:
					say "[The actor] moves west.";
					remove the player from the NE compartment;
					add the player to the NW compartment;
				otherwise:
					say "[The actor] tries to go west, but is blocked by a closed door.";
			otherwise:
				if the noun is south:
					if door 2 is open:
						say "[The actor] moves south.";
						remove the player from the NE compartment;
						add the player to the SE compartment;
					otherwise:
						say "[The actor] tries to go south, but is blocked by a closed door.";	
				otherwise:
					say "[The Actor]: There is no door in that direction.";
		otherwise:
			if the player is SE:
				if the noun is west:
					if door 3 is open:
						say "[The actor] moves west.";
						remove the player from the SE compartment;
						add the player to the SW compartment;
					otherwise:
						say "[The actor] tries to go west, but is blocked by a closed door.";
				otherwise:
					if the noun is north:
						if door 2 is open:
							say "[The actor] moves north.";
							remove the player from the SE compartment;
							add the player to the NE compartment;
						otherwise:
							say "[The actor] tries to go north, but is blocked by a closed door.";
					otherwise:
						say "[The Actor]: There is no door in that direction.";
			otherwise:
				if the noun is east:
					if door 3 is open:
						say "[The actor] moves east.";
						remove the player from the SW compartment;
						add the player to the SE compartment;
					otherwise:
						say "[The actor] tries to go east, but is blocked by a closed door.";
				otherwise:
					if the noun is north:
						if door 4 is open:
							say "[The actor] moves north.";
							remove the player from the SW compartment;
							add the player to the NW compartment;
						otherwise:
							say "[The actor] tries to go north, but is blocked by a closed door.";
					otherwise:
						say "[The Actor]: There is no door in that direction.".

Every turn when the puzzle number is 5 (this is the winning the fifth puzzle rule):
	if the number of entries in NW compartment is 1 and the number of entries in NE compartment is 1 and the number of entries in SE compartment is 1 and the number of entries in SW compartment is 1:
		increase the single counter by 1;
		if the single counter is 12:
			say "[bold type]You have SOLVED the fifth puzzle! Arcangelo Corelli would be proud of you.[roman type][paragraph break][paragraph break]";
			finish solving the puzzle;
	otherwise:
		now the single counter is 0.


Chapter - Sixth Puzzle

Sixth Puzzle is a room. 
"This room is again divided up into four compartments, each connected by a door on two of its walls, like so:

[fixed letter spacing]
=====================[line break]
|         |         |[line break]
|   [pos1-A] [pos2-A]   -   [pos1-B] [pos2-B]   |[line break]
|    A    [sign5]    B    |[line break]
|   [pos3-A] [pos4-A]   -   [pos3-B] [pos4-B]   |[line break]
|         |         |[line break]
|===|[sign8]|===|===|[sign6]|===|[line break]
|         |         |[line break]
|   [pos1-D] [pos2-D]   -   [pos1-C] [pos2-C]   |[line break]
|    D    [sign7]    C    |[line break]
|   [pos3-D] [pos4-D]   -   [pos3-C] [pos4-C]   |[line break]
|         |         |[line break]
=====================[line break]

[variable letter spacing]The positions of the four characters and whether the doors are open or closed can be read off from the figure.

A white button is mounted on the wall of each compartment.

North, south, east and west are meaningless in these rooms. You can only move [italic type]clockwise[roman type] and [italic type]counterclockwise[roman type] (which you can abbreviate to 'cw' and 'ccw').

[bold type]In order to win, Een, Twee, Drie, and Vier must each be in a separate room for three turns, with all four doors open.[roman type]".

[[if the number of entries in NW compartment is greater than 0] [occupants of NW compartment]in compartment A.[end if][if the number of entries in NE compartment is greater than 0] [occupants of NE compartment]in compartment B.[end if][if the number of entries in SE compartment is greater than 0] [occupants of SE compartment]in compartment C.[end if][if the number of entries in SW compartment is greater than 0] [occupants of SW compartment]in compartment D.[end if] The door between A and B is [if door 5 is open]open[otherwise]closed[end if]. The door between B and C is [if door 6 is open]open[otherwise]closed[end if]. The door between C and D is [if door 7 is open]open[otherwise]closed[end if]. The door between D and A is [if door 8 is open]open[otherwise]closed[end if].
] [REMOVED]

Door 5 is a compartment door in Sixth Puzzle.
The printed name is "[if the player is NW]clockwise [otherwise]counterclockwise [end if]door".

Door 6 is a compartment door in Sixth Puzzle.
The printed name is "[if the player is NE]clockwise [otherwise]counterclockwise [end if]door".

Door 7 is a compartment door in Sixth Puzzle.
The printed name is "[if the player is SE]clockwise [otherwise]counterclockwise [end if]door".

Door 8 is a compartment door in Sixth Puzzle.
The printed name is "[if the player is SW]clockwise [otherwise]counterclockwise [end if]door".

To say sign5:
	if door 5 is open, say " ";
	if door 5 is closed, say "|".

To say sign6:
	if door 6 is open, say " ";
	if door 6 is closed, say "=".

To say sign7:
	if door 7 is open, say " ";
	if door 7 is closed, say "|".

To say sign8:
	if door 8 is open, say " ";
	if door 8 is closed, say "=".

To say pos1-A:
	if Een is NW:
		say "1";
	otherwise:
		say " ".

To say pos1-B:
	if Een is NE:
		say "1";
	otherwise:
		say " ".

To say pos1-C:
	if Een is SE:
		say "1";
	otherwise:
		say " ".

To say pos1-D:
	if Een is SW:
		say "1";
	otherwise:
		say " ".

To say pos2-A:
	if Twee is NW:
		say "2";
	otherwise:
		say " ".

To say pos2-B:
	if Twee is NE:
		say "2";
	otherwise:
		say " ".

To say pos2-C:
	if Twee is SE:
		say "2";
	otherwise:
		say " ".

To say pos2-D:
	if Twee is SW:
		say "2";
	otherwise:
		say " ".

To say pos3-A:
	if Drie is NW:
		say "3";
	otherwise:
		say " ".

To say pos3-B:
	if Drie is NE:
		say "3";
	otherwise:
		say " ".

To say pos3-C:
	if Drie is SE:
		say "3";
	otherwise:
		say " ".

To say pos3-D:
	if Drie is SW:
		say "3";
	otherwise:
		say " ".

To say pos4-A:
	if Vier is NW:
		say "4";
	otherwise:
		say " ".

To say pos4-B:
	if Vier is NE:
		say "4";
	otherwise:
		say " ".

To say pos4-C:
	if Vier is SE:
		say "4";
	otherwise:
		say " ".

To say pos4-D:
	if Vier is SW:
		say "4";
	otherwise:
		say " ".


Reset the puzzle rule (this is the set up the sixth puzzle rule):
	if the puzzle number is 6:
		now the reset boolean is true;
		move Een to Sixth Puzzle;
		move Twee to Sixth Puzzle;
		move Drie to Sixth Puzzle;
		move Vier to Sixth Puzzle;
		now the reset boolean is false;
		move the white button to Sixth Puzzle;
		move door 5 to Sixth Puzzle;
		move door 6 to Sixth Puzzle;
		move door 7 to Sixth Puzzle;
		move door 8 to Sixth Puzzle;
		truncate NW compartment to 0 entries;
		truncate NE compartment to 0 entries;
		truncate SW compartment to 0 entries;
		truncate SE compartment to 0 entries;
		add {Een, Twee, Drie, Vier} to NW compartment;
		now door 5 is open;
		now door 6 is open;
		now door 7 is open;
		now door 8 is open;
		change the single counter to 0.

Clockwise is a direction. The opposite of clockwise is counterclockwise. Understand "cw" as clockwise.
Counterclockwise is a direction. The opposite of counterclockwise is clockwise. Understand "ccw" as counterclockwise.

Before going when the puzzle number is 6:
	if the noun is not clockwise and the noun is not counterclockwise:
		say "[The actor] can only go clockwise or counterclockwise." instead.

Instead of going when the puzzle number is 6:
	if the player is NW:
		if the noun is clockwise:
			if door 5 is open:
				say "[The actor] moves clockwise, to compartment B.";
				remove the player from the NW compartment;
				add the player to the NE compartment;
			otherwise:
				say "[The actor] tries to go clockwise, but is blocked by a closed door.";
		otherwise:
			if the noun is counterclockwise:
				if door 8 is open:
					say "[The actor] moves counterclockwise, to compartment D.";
					remove the player from the NW compartment;
					add the player to the SW compartment;
				otherwise:
					say "[The actor] tries to go counterclockwise, but is blocked by a closed door.";
			otherwise:
				say "[The Actor]: There is no door in that direction.";
	otherwise:
		if the player is NE:
			if the noun is counterclockwise:
				if door 5 is open:
					say "[The actor] moves counterclockwise, to compartment A.";
					remove the player from the NE compartment;
					add the player to the NW compartment;
				otherwise:
					say "[The actor] tries to go counterclockwise, but is blocked by a closed door.";
			otherwise:
				if the noun is clockwise:
					if door 6 is open:
						say "[The actor] moves clockwise, to compartment C.";
						remove the player from the NE compartment;
						add the player to the SE compartment;
					otherwise:
						say "[The actor] tries to go clockwise, but is blocked by a closed door.";	
				otherwise:
					say "[The Actor]: There is no door in that direction.";
		otherwise:
			if the player is SE:
				if the noun is clockwise:
					if door 7 is open:
						say "[The actor] moves clockwise, to compartment D.";
						remove the player from the SE compartment;
						add the player to the SW compartment;
					otherwise:
						say "[The actor] tries to go clockwise, but is blocked by a closed door.";
				otherwise:
					if the noun is counterclockwise:
						if door 6 is open:
							say "[The actor] moves counterclockwise, to compartment B.";
							remove the player from the SE compartment;
							add the player to the NE compartment;
						otherwise:
							say "[The actor] tries to go counterclockwise, but is blocked by a closed door.";
					otherwise:
						say "[The Actor]: There is no door in that direction.";
			otherwise:
				if the noun is counterclockwise:
					if door 7 is open:
						say "[The actor] moves counterclockwise, to compartment C.";
						remove the player from the SW compartment;
						add the player to the SE compartment;
					otherwise:
						say "[The actor] tries to go counterclockwise, but is blocked by a closed door.";
				otherwise:
					if the noun is clockwise:
						if door 8 is open:
							say "[The actor] moves clockwise, to compartment A.";
							remove the player from the SW compartment;
							add the player to the NW compartment;
						otherwise:
							say "[The actor] tries to go clockwise, but is blocked by a closed door.";
					otherwise:
						say "[The Actor]: There is no door in that direction.".

Instead of examining the white button when the puzzle number is 6:
	say "[The actor]: A simple white button. Pushing it will reverse the state of the doors in its room."

Instead of pushing the white button when the puzzle number is 6:
	if the player is NW:
		say "[The actor] pushes the button. The ";
		flip door 5;
		say " and the ";
		flip door 8;
		say ".";
	otherwise:
		if the player is NE:
			say "[The actor] pushes the button. The ";
			flip door 5;
			say " and the ";
			flip door 6;
			say ".";
		otherwise:
			if the player is SE:
				say "[The actor] pushes the button. The ";
				flip door 6;
				say " and the ";
				flip door 7;
				say ".";
			otherwise:
				say "[The actor] pushes the button. The ";
				flip door 7;
				say " and the ";
				flip door 8;
				say ".".



Every turn when the puzzle number is 6 (this is the winning the sixth puzzle rule):
	if the number of entries in NW compartment is 1 and the number of entries in NE compartment is 1 and the number of entries in SE compartment is 1 and the number of entries in SW compartment is 1 and door 5 is open and door 6 is open and door 7 is open and door 8 is open:
		increase the single counter by 1;
		if the single counter is 12:
			say "[bold type]You have SOLVED the sixth puzzle! Benjamin Britten would be proud of you.[roman type][paragraph break][paragraph break]";
			finish solving the puzzle;
	otherwise:
		now the single counter is 0.



Chapter - Seventh Puzzle

Seventh Puzzle is a room. "This room is utterly bare, except for a strange machine.[paragraph break][bold type]In order to win, all four characters must eat a banana within a single turn.[roman type]".

Reset the puzzle rule (this is the set up the seventh puzzle rule):
	if the puzzle number is 7:
		now the reset boolean is true;
		move Een to Seventh Puzzle;
		move Twee to Seventh Puzzle;
		move Drie to Seventh Puzzle;
		move Vier to Seventh Puzzle;
		now the reset boolean is false;
		move strange machine to Seventh Puzzle;
		now the colour of the strange machine is yellow;
		repeat with X running through bananas:
			now the X is yellow;
			move X to Seventh Puzzle;
		now the paint number is 1;
		now the banana list is {}.


Colour is a kind of value. The colours are yellow, burgundy, fuchsia, lilac and mauve.

A banana is a kind of thing. A banana has a colour. A banana is usually yellow. A banana is edible.

Before printing the name of a banana (called the thingy): say "[colour of the thingy] ".
Before printing the plural name of a banana (called the thingy): say "[colour of the thingy] ".

Understand the colour property as describing a banana.

Four bananas are in Seventh Puzzle.

The strange machine is in Seventh Puzzle. The strange machine has a colour. The strange machine is yellow. Understand "weird" and "machine" as the strange machine. The strange machine is a transparent, closed, unopenable container.

The banana list is a list of things that varies.

The paint number is a number that varies. The paint number is 1.

Instead of examining the strange machine: say "[The actor]: This weird contraption can apparently paint things that are put into it. In a compartment behind a glass window are four clamps; [if the number of entries of the banana list is 0 or the paint number is 5]all of them are empty[otherwise if the number of entries of the banana list is 1]the first contains a [entry 1 of the banana list], the other three are empty[otherwise if the number of entries of the banana list is 2]the first contains a [entry 1 of the banana list], the second contains a [entry 2 of the banana list], the other two are empty[otherwise if the number of entries of the banana list is 3]the first contains a [entry 1 of the banana list], the second contains a [entry 2 of the banana list], the third contains a [entry 3 of the banana list], the fourth is empty[otherwise if the number of entries of the banana list is 4]the first contains a [entry 1 of the banana list], the second contains a [entry 2 of the banana list], the third contains a [entry 3 of the banana list], the fourth contains a [entry 4 of the banana list][end if]. There is also a nozzle behind the glass window; it is currently pointed at clamp number [if the paint number is not 5][paint number][otherwise]1[end if].[paragraph break]A big lever on the machine can be set to five different colours: from left to right, yellow, burgundy, fuchsia, lilac and mauve. The lever is currently at [colour of the strange machine]. Finally, there is a huge red button on the machine.".

The red button is part of the strange machine.

Instead of pushing the red button when the paint number is not 5:
	if the number of entries of the banana list is not 4:
		say "[The actor] pushes the button, and a mechanic voice says: `Machine not full. Cannot operate.'";
	otherwise:
		let N be 0;
		repeat with item running through the banana list:
			now N is N + 1;
			if N is the paint number, now the colour of item is the colour of the strange machine;
		now the paint number is the paint number + 1;
		say "[The actor]: A large amount of [colour of the strange machine] paint sprays out of the nozzle, painting the banana. [if the paint number is 5]Once finished, the nozzle moves to clamp number 1, and all four bananas disappear from view[otherwise]Once finished, the nozzle moves to clamp number [paint number][end if].";
		if the paint number is 5:
			repeat with item running through the banana list:
				move item to Backstage.

Instead of pushing the red button when the paint number is 5:
	let N be 0;
	let X be a random banana;
	let Y be a random banana;
	repeat with item running through the banana list:
		now N is N + 1;
		if N is 1:
			move item to Seventh puzzle;
			now X is item;
		if N is 2:
			move item to Seventh puzzle;
			now Y is item;
	say "[The actor] presses the button, and [a X] and [a Y] are ejected from the machine.";
	remove X from the banana list;
	remove Y from the banana list;
	if the number of entries in the banana list is 0, now the paint number is 1.


Check inserting something into the strange machine:
	if the noun is not a banana, say "[The actor] fails to insert [the noun] into the machine. Apparently, only bananas will fit." instead;
	if the paint number is 5, say "[The actor] fails to insert [the noun] into the machine, since it is still in operation.";
	if the number of entries of the banana list is 4, say "[The actor] fails to insert [the noun] into the machine, since it is already full." instead.

Instead of inserting a banana into the strange machine:
	move the noun to the strange machine;
	add the noun to the banana list;
	say "[The actor] throws [the noun] into the top of the machine.".

Pulling left is an action applying to one thing.

Understand "pull [something] left" as pulling left. Understand "pull [something] to left" as pulling left. Understand "pull [something] to the left" as pulling left. Understand "push [something] left" as pulling left. Understand "push [something] to left" as pulling left. Understand "push [something] to the left" as pulling left. Understand "move [something] left" as pulling left. Understand "move [something] to left" as pulling left. Understand "move [something] to the left" as pulling left.

Pulling right is an action applying to one thing.

Understand "pull [something] right" as pulling right. Understand "pull [something] to right" as pulling right. Understand "pull [something] to the right" as pulling right. Understand "push [something] right" as pulling right. Understand "push [something] to right" as pulling right. Understand "push [something] to the right" as pulling right. Understand "move [something] right" as pulling right. Understand "move [something] to right" as pulling right. Understand "move [something] to the right" as pulling right.

Instead of pulling left:
	say "[The actor] tries to pull [the noun] to the left, but without success.".

Instead of pulling right:
	say "[The actor] tries to pull [the noun] to the right, but without success.".

The lever is part of the strange machine.

Instead of pulling left the lever:
	if the colour of the strange machine is yellow, say "The lever is already in the leftmost position." instead;
	change the colour of the strange machine to the colour before the colour of the strange machine;
	say "[The actor] sets the lever to [colour of the strange machine].".
	
Instead of pulling right the lever:
	if the colour of the strange machine is mauve, say "The lever is already in the rightmost position." instead;
	change the colour of the strange machine to the colour after the colour of the strange machine;
	say "[The actor] sets the lever to [colour of the strange machine].".

Setting it to colour is an action applying to one thing and one colour. Understand "set [something] to [a colour]" as setting it to colour. Understand "pull [something] to [a colour]" as setting it to colour. Understand "push [something] to [a colour]" as setting it to colour.

Instead of setting the strange machine to colour:
	try setting the lever to colour the colour understood.

Instead of setting the lever to colour:
	say "[The actor] sets the lever to [the colour understood].";
	now the colour of the strange machine is the colour understood.


The banana counter is a number that varies.

Last every turn (this is the reset the banana counter rule):
	if count is 0, now the banana counter is zero.

Carry out an actor eating a banana:
	increase the banana counter by 1.

				
Every turn when the puzzle number is 7 (this is the winning the seventh puzzle rule):
	if the banana counter is 4:
		say "[bold type]You have SOLVED the seventh puzzle! Jan Pieterszoon Sweelinck would be proud of you.[roman type][paragraph break][paragraph break]";
		finish solving the puzzle.


Chapter - Eighth Puzzle

Eighth Puzzle is a room. "This room contains a large organ and huge bellows. There is also a tap.[if there is at least one reversed person in Eighth Puzzle] [list of reversed persons] [isarereversed] standing upside-down on the ceiling.[line break][end if][paragraph break][bold type]In order to win, you must bring the organ up to its maximum pressure.[roman type]".

To say isarereversed:
	if there are at least two reversed persons in Eighth Puzzle:
		say "are[run paragraph on]";
	otherwise:
		say "is[run paragraph on]".



Reset the puzzle rule (this is the set up the eighth puzzle rule):
	if the puzzle number is 8:
		now the reset boolean is true;
		move Een to Eighth Puzzle;
		move Twee to Eighth Puzzle;
		move Drie to Eighth Puzzle;
		move Vier to Eighth Puzzle;
		now the reset boolean is false;
		move the large organ to Eighth Puzzle;
		now the organ pressure is 0;
		move the tap to Eighth Puzzle;
		now the tap is closed;
		repeat with X running through persons:
			now X is unreversed;
		move the bellows to Eighth Puzzle;
		now the bellows-uppity is true;
		now the bellows-previous-uppity is true.

A person is either unreversed or reversed. A person is normally unreversed.


The large organ is in Eighth Puzzle. The large organ is scenery. The organ pressure is a number that varies. The organ pressure is usually 0.

Instead of examining the organ:
	say "[The actor]: a huge church organ of the kind Bach used to play. The bellows will have to be pulled up and down six times in succession before the maximum pressure is reached.".

The bellows are in Eighth Puzzle. The bellows are scenery. Understand "huge" as the bellows. The bellows-uppity is a truth state that varies. The bellows-uppity is usually true. The bellows-previous-uppity is a truth state that varies. The bellows-previous-uppity is true.

Last every turn when the puzzle number is 8:
	if the organ pressure is not 0:
		if the bellows-uppity is the bellows-previous-uppity:
			say "[italic type]Because the bellows have not been worked, the organ loses its pressure[roman type].";
			now the organ pressure is 0;
	now the bellows-previous-uppity is the bellows-uppity.

Instead of examining the bellows:
	say "[The actor]: these huge bellows are connected to the organ. One side has been fixed in place, and the other side can be pulled up and pulled down as needed. Right now, the movable side is [if the bellows-uppity is true]up, so it could be pulled down[otherwise]down, so it could be pulled up[end if].".


Pulling up is an action applying to one thing.

Understand "pull [something] up" as pulling up. Understand "pull [something] to up" as pulling up. Understand "push [something] up" as pulling up. Understand "push [something] to up" as pulling up. Understand "move [something] up" as pulling up. Understand "move [something] to up" as pulling up.

Pulling down is an action applying to one thing.

Understand "pull [something] down" as pulling down. Understand "pull [something] to down" as pulling down. Understand "push [something] down" as pulling down. Understand "push [something] to down" as pulling down. Understand "move [something] down" as pulling down. Understand "move [something] to down" as pulling down.

Instead of pulling up:
	say "[The actor] tries to pull [the noun] up, but without success.".

Instead of pulling down:
	say "[The actor] tries to pull [the noun] down, but without success.".


Instead of pulling or pushing the bellows:
	say "[The actor] could pull the bellows up or down, but you'll need to indicate which.".


Instead of pulling up the bellows:
	if the actor is unreversed:
		do the bellows up routine with the actor;
	otherwise:
		do the bellows down routine with the actor.

Instead of pulling down the bellows:
	if the actor is unreversed:
		do the bellows down routine with the actor;
	otherwise:
		do the bellows up routine with the actor.

To do the bellows up routine with (the guy - a person):
	if the bellows-uppity is true:
		if the guy is unreversed:
			say "[The guy] tries to pull the bellows up, but they are up already.";
		otherwise:
			say "From his perspective, [the guy] tries to pull the bellows down--but that translates into trying to pull the bellows up. Unfortunately, they are up already.";
	otherwise:
		if the guy is unreversed:
			say "[The guy] pulls the bellows up. ";
		otherwise:
			say "From his perspective, [the guy] tries to pull the bellows down--but that translates into pulling them up. ";
		increase the organ pressure by 1;
		say "The organ pressure increases (to [organ pressure] out of 12).";
	now the bellows-uppity is true.

To do the bellows down routine with (the guy - a person):
	if the bellows-uppity is false:
		if the guy is unreversed:
			say "[The guy] tries to pull the bellows down, but they are down already.";
		otherwise:
			say "From his perspective, [the guy] tries to pull the bellows up--but that translates into trying to pull the bellows down. Unfortunately, they are down already.";
	otherwise:
		if the guy is unreversed:
			say "[The guy] pulls the bellows down. ";
		otherwise:
			say "From his perspective, [the guy] tries to pull the bellows up--but that translates into pulling them down. ";
		increase the organ pressure by 1;
		say "The organ pressure increases (to [organ pressure] out of 12).";
	now the bellows-uppity is false.





The tap is in Eighth Puzzle. The tap is scenery and a container. The tap is openable and closed. Understand "water" and "liquid" and "jet" as the tap.

Understand "drink from [something]" as drinking.

Instead of examining the tap:
	say "[The actor]: the tap is [if the tap is open]open, and a clear liquid flows out of it[otherwise]closed[end if]. It is labeled 'Warning: multiplies mass of drinker by minus one!'."

Instead of opening the tap:
	if the tap is open:
		say "[The actor] tries to open the tap, but it is already open.";
	otherwise:
		say "[The actor] opens the tap. A clear liquid now flows out of the tap in a horizontal jet, dissipating into the air before it reaches the other wall.";
	now the tap is open.

Instead of closing the tap:
	if the tap is closed:
		say "[The actor] tries to close the tap, but it is already open.";
	otherwise:
		say "[The actor] closes the tap, and the liquid stops flowing.";
	now the tap is closed;.

Instead of inserting something into the tap:
	say "[The actor] cannot fit anything into the tap.".

Instead of taking the tap when the tap is open:
	say "[The actor] cannot do that, but he could drink the water.".

Instead of drinking the tap:
	if the tap is closed:
		say "[The actor] tries to drink the water, but the tap is closed.";
	otherwise:
		say "[The actor] takes a big gulp from the water, and immediately [if the actor is reversed]returns to the solid ground[otherwise]tumbles through the air until he lands with his feet on the ceiling, where he can apparently stand as if it were the floor[end if].";
		if the actor is reversed:
			now the actor is unreversed;
		otherwise:
			now the actor is reversed.


Every turn when the puzzle number is 8 (this is the winning the eighth puzzle rule):
	if the organ pressure is 12:
		say "[bold type]You have SOLVED the eighth puzzle! Ludwig van Beethoven would be proud of you.[roman type][paragraph break][paragraph break]";
		finish solving the puzzle.



