// Mercury
			
class mercroom: room
	onmerc = true
	doUnwear( actor ) ={
		"Okay, you're no longer wearing "; self.thedesc; ". ";
		self.isworn := nil;
	if (self = suit or self = icesuit)
		{
		"You remove the suit and immediately explode do to the sudden immersion 
		in a vacuum. ";
		die();
		} 
    }
	
;

mercury: mercroom
	sdesc = "Inside Crater"
	ldesc = "You and the cylinder are inside of a small crater on Mercury's surface.  
		Paths lead out of the crater in all directions.  The western paths lead into the 
		region of the planet that always faces the sun, the eastern ones to the region 
		that always faces away from it.  Even with your suit on, it is doubtful you  
		could survive in either of those environments."
	north = northside
	south = southside
	east = { colddie();}
	ne = {colddie();}
	se = {colddie();}
	west = {hotdie();}
	nw = {hotdie();}
	sw = {hotdie();}
	down = { "You are already at the bottom of the crater. ";
					return (nil);
				}
	up = { "Be specific on from which direction you wish to exit the crater.";
				return (nil);
			}
	in = shipin
;

mecylin: decoration
	sdesc = "large glowing cylinder"
	isopen = true
	noun = 'cylinder' 'ship' 'craft'
	adjective = 'large' 'glowing'
	location = mercury
	ldesc = "The cylinder is about 30 feet in height and width.
		It is very shiny and seems to glow slightly.  There is a passage 
		leading into the interior of it as well."
	verDoGo(actor) = {}
	doGo(actor) = {Me.travelTo(shipin);}
	verDoEnter(actor) = {}
	doEnter(actor) = {Me.travelTo(shipin);}
;



colddie: function
	{
	"You step into the frozen region of Mercury.  The beauty of the sky above is 
		breathtaking.  Looking up you feel the true immensity of the void about you.  
		You go to take a step further when you realize that you can't.  The joints on the suit have frozen solid! \n
		 You die a few hours later, when the respiratory system on the suit freezes solid as well. ";
		die();
	}
; 

hotdie: function
	{
	"You walk out into the blistering heat of Mercury's hot region where the Sun fills the entire sky.  
		You gawk in awe at the immensity of the star when a solar flare erupts 	from its 
		surface and fries you to a nice toasted, golden brown.";
	die();
	}

northside: mercroom
	sdesc = "On Mercury"
	ldesc = "You are on the surface of Mercury.  To the west lies the hot region of the 
		planet, to the east the cold.  There is a shallow crater to the south which 
		you can climb down into.  A large and deep crater blocks any further  
		movement to the north."
	south = mercury
	east = {colddie();}
	ne = {colddie();}
	se = {colddie();}
	west = {hotdie();}
	nw = {hotdie();}
	nonce = nil
	north = {  if (not self.nonce)
			{
			"The crater is large, very steep and deep.  Your chances of 
			successfully climbing down are very, very, VERY small. ";
			self.nonce := true;
			return(nil);
			}
		else
			{
			"Knowing the dangers, you try to climb down the crater any way  
			and only succeed in falling to your death.";
			die();
			}
		}
	down = {
		"Do you want to go down to the north or to the south?";
		return (nil);
		}
;

ncrater: decoration
	sdesc = "deep crater"
	ldesc = "The crater is large, very steep and deep.  Your chances of successfully 
		climbing down are very, very, VERY small. "
	noun = 'crater'
	adjective = 'large' 'deep'
	doClimbdown(actor) = {
				"Knowing the dangers full well, you try to climb down the 
				crater anyway and only succeed in falling to your death.";
				die();
				}
	doClimb (actor) = { self.doClimbdown(actor);}
	location = northside
;

n2crater: decoration
	sdesc = "shallow crater"
	ldesc = "At the bottom of the shallow crater to the south you can see the glow from 
		the cylinder. On the southern rim of the crater you see a large boulder."
	noun = 'crater'
	adjective = 'shallow'
	location = northside
;



crater: decoration
	sdesc = "small crater"
	ldesc = "The crater is fairly shallow.  There are paths lead up and out of it in all 
		directions."
	noun = 'crater'
	adjective = 'small'
	location = mercury
;

southside: mercroom
	sdesc = "South of Crater"
	ldesc = {
		"You are standing on the south end of a large crater.  Down below, to the 
		north, lies the floor of the crater where you can see the 
		cylinder softly glowing.  To your east lies the dark half of the planet, while 
		to the west lies the sunny side. ";
		if (mboulder.location = southside)
			"A huge boulder blocks any further progress to the south.";
		else
			"Directly to the south, there is a walkable path between two large boulder fragments.";
		}
	north = mercury
	south = {
		if (mboulder.location = southside)
			{
			"A large boulder is the way.";
			return(nil);
			}
		else
			return (mcove);
		}
	east ={colddie();}
	ne = {colddie();}
	se = {colddie();}
	west = {hotdie();}
	sw = {hotdie();}
	nw = {hotdie();}
;

scrater: decoration
	sdesc = "shallow crater"
	ldesc = "Down below, in the exact center of the crater, you see the cylinder, patiently glowing."
	noun = 'crater'
	adjective = 'shallow'
	location = southside
;

mboulder: fixeditem
	sdesc = "huge boulder"
	ldesc = {
		"The boulder is conical, at least 30 feet in height and twice as long.  ";
		if (self.swiv = nil)
		"The \"tip\" of the boulder is currently on the dark side of Mercury.  ";
		else
		"The \"tip\" of the boulder is currently on the hot side of Mercury.  ";
		"There is no way to walk around the boulder without ending up in either the 
		hot or cold regions of the planet.  Upon closer examination you notice that 
		the center of the boulder seems to be balanced on some smaller stones.";
		}
	noun = 'boulder' 'rock'
	adjective = 'huge'
	location = southside
	crack = 0
	swiv = nil
	verDoPush(actor) ={}
	verDoTurn(actor) = {}
	doPush(actor) = {
			"You firmly place your hands and the center of the massive rock and 
			with a loud grunt you try to push the rock out of the way.  Beads of 
			sweet pool over your eyes as you push, but the rock is just to 
			massive to push.";
			}
	doTurn(actor) ={
			self.swiv := not self.swiv;
			"Leaning your shoulder into it, you push hard on one side of the 
			massive rock.  Beads of sweet form on your brow and fatigue starts 
			to fill your muscles when the rock suddenly gives and spins around, 
			throwing you to the ground.  The rock comes to a rest after a few 
			seconds with the tip of the rock firmly on the  ";
			if (self.swiv = true)
			"hot side of the planet.";
			else "cold side of the planet.";
			}
	
;

smallstones: decoration
	sdesc = "small stones"
	ldesc = "The smaller stones are supporting the center of the boulder an inch above the ground."
	noun = 'stones'
	adjective = 'small'
	location = southside
	verDoTake(actor) ={}
	doTake(actor) = {
			"The small stones are firmly wedged between the ground and the boulder and cannot be taken.";
			}
;

mrubble: decoration
	sdesc = "boulder fragments"
	ldesc = "Both fragments are quite large and straddle the path to the south.  The 
		fragment to the east is on the cold side of the planet, while the one to the 
		west is on the hot side. "
	noun = 'fragments'
	adjective = 'boulder'
	location = nil
;

mcove: mercroom
	sdesc = "Cul-de-sac"
	ldesc = "You are standing in a small cul-de-sac.  Steep cliffs lie in all directions except to the north."
	north = southside
	east = {"Unclimbable cliffs block passage in that direction.";
				return(nil);
				}
	south ={"Unclimbable cliffs block passage in that direction.";
				return(nil);
				}
	west = {"Unclimbable cliffs block passage in that direction.";
				return(nil);
				}
	ne = {"Unclimbable cliffs block passage in that direction.";
				return(nil);
				}
	nw = {"Unclimbable cliffs block passage in that direction.";
				return(nil);
				}
	se = {"Unclimbable cliffs block passage in that direction.";
				return(nil);
				}
	sw = {"Unclimbable cliffs block passage in that direction.";
				return(nil);
				}
	up = {"The cliffs are unclimbable.";
					return (nil);
				}
;
								
mcliffs: decoration
	hno = true
	sdesc = "steep cliffs"
	ldesc = "The cliffs are very tall and steep. Quite unclimbable."
	noun = 'cliffs'
	adjective = 'steep'
	location =mcove
;
