// Spaceship

class shiproom : room
	spsh = true
;

cylin: decoration
	sdesc = "large glowing cylinder"
	isopen = true
	noun = 'cylinder' 'ship' 'craft'
	adjective = 'large' 'glowing' 'space' 'time'
	location = crash
	ldesc ={
		"The cylinder is about thirty feet in height and width.  It is very shiny and gives 
		 off a slight glow.  There is a passage leading into its interior.";
			}
	verDoEnter(actor) = {}
	doEnter(actor) = {Me.travelTo(shipin);}
	verDoGo(actor) = {}
	doGo(actor) = {Me.travelTo(shipin);}
;

shipin: shiproom
	sdesc = "Inside Cylinder"
	ldesc={
		"You are inside the cylinder.  The entire structure hums with power.  The interior is
		lit by dim yellow light from above.  ";
			{
			if (self.wallsdown)
				"The only exit is out through the airlock.";
			else
				"The airlock is closed.  However, there are passages to the northeast and southeast.";
			}
		}
	wallsdown = true
	onvenus = nil
	ne = {
		if (self.wallsdown)
			{
			"You can't go in that direction.";
			return(nil);
			}
		else return (curvsh1);
		}
	se ={
		if (self.wallsdown)
			{
			"You can't go in that direction.";
			return(nil);
			}
		else return (curvsh2);
			}
	out ={
		if (airlock.isopen)
		{
			{if(ship.location = E1) return (crash);}
			{if(ship.location = V) return (venus);}
			{if(ship.location = EU) return (e0);}
			{if(ship.location = MA) return (mars);}
			{if(ship.location = PL)
					{setdaemon(robotcount,nil);
					return(pluto);}
			}
			{if(ship.location = MER) return (mercury);}
			{if(ship.location = CH) return (charon);}
			{if(ship.location = E2)
					global.verbose := true;
					incscore(30);				// 30 points for reaching end
					return(road);
			}
		}
		else
			{
			"The airlock is closed.\b";
			return(nil);
			}
		}
;

airlock: vowelItem, fixeditem, keyedLockable
	isopen = true
	islocked = nil
	noun = 'door' 'airlock'
	location = shipin
	sdesc = "airlock"
	ldesc = {
		"The airlock is more like part of the wall than an actual door.  The only way you
		you can even tell that the airlock is here is because of a white pad and a handle embedded
		in the wall.  ";
			{
			if (self.isopen) "The airlock is presently open.";
			else "The airlock is presently closed.";
			}
		}
	doOpen(actor) ={
		if (not self.islocked)
		{
		"The airlock opens with a hiss revealing ";
		self.isopen := true;
			{
			if(ship.location = E1)
				{
				"a burnt section of forest.";
				exit;
				}
			if(ship.location = V)
				{
				"the hellish landscape of Venus.";
				setdaemon(venuscount, nil);
				shipin.onvenus := true;
				if (icesuit.isworn or robothead.isworn or robotbody.isworn)
					{
					"\bYou were smart to wear some type of protective gear in this hostile environment.  
					Regrettably, the suit you are wearing lasts about two seconds before it decomposes, 
					exposing you to the Venusian atmosphere.";
					die();
					}
				if(not suit.isworn)
					{
					"\bOf course, without any form of protection from the Venusian environment the
					combination of extreme temperature and pressure quickly dissolves you into a
					a hot pool of brown sludge.";
					die();
					}
				exit;
				}
			if (ship.location = EU)
				{
				"the smooth, frozen landscape of Europa.";
				if(not suit.isworn)
				if(not icesuit.isworn)
					{
					"Regrettably, you are ill equipped to survive in a vacuum.  You realize this when your blood boils 
					as you simultaneously asphyxiate and freeze solid.";
					die();
					}
				exit;
				}
			if (ship.location = MA)
				{
				"the terraformed surface of Mars.";
				exit;
				}
			if (ship.location = PL)
				{
				"the ruin of a huge domed city on the surface of Pluto.";
				exit;
				}
			if (ship.location = MER)
				{
				"the perpetual day of the rocky surface of Mercury.";
				if (not suit.isworn)
				if(not icesuit.isworn)
					{
					"Regrettably, you are ill equipped to survive in a vacuum.  Your realize this when your blood boils 
					as you simultaneously asphyxiate and freeze solid.";
					die();
					}
				exit;
				}
			if (ship.location =CH)
				{
				"the frozen landscape of Pluto's twin planet, Charon.";
				if(not suit.isworn)
				if(not icesuit.isworn)
					{
					"Regrettably, you are ill equipped to survive in a vacuum.  Your realize this when your blood boils 
					as you simultaneously asphyxiate and freeze solid.";
					die();
					}
				exit;
				}
			if (ship.location = E2)
				{
				"the welcome sight of the road near your home.";
				exit;
				}
			}
			}
			else "The airlock won't open.";
		}
	doClose(actor) = {
			"The airlock closes with a loud thud.  With a loud hiss, the ship quickly adjusts the atmosphere to
			an oxygenated one.";
			pad.primed := true;
			self.islocked := nil;
			self.isopen := nil;
			shipin.onvenus := nil;
			if (ship.location = V)
				{
				if (chest.isopen) remdaemon (cvcount, nil);
				if (rope.td)
					{
					remdaemon(vropecount,nil);
					rope.td := nil;
					}
				remdaemon (venuscount,nil);
				}
		}
	doLock(actor)={
			"How do you propose to do that?";
			self.islocked := not self.islocked;
			}
	doUnlock(actor)={
			"How do you propose to do that?";
			self.islocked := not self.islocked;
			}
;

pad: touchitem
	sdesc = "white pad"
	ldesc = "The white pad is rectangular and about twice the size of your hand."
	noun = 'pad'
	adjective = 'white'
	primed = true
	donce = nil
	location = shipin
	doTouch(actor) = {
		if (airlock.isopen) "Nothing happens.";
		else
			{
			if (not self.primed)
				{
				"The pad flashes briefly with your touch and an audible click issues from the
				interior of the airlock.  The ceiling to the northeast and southeast becomes liquid and
				flows down completely blocking the passages into the interior of the ship.  A tinny 
				voice rings out ";
				if (ship.location = E1 or ship.location = E2 or ship.location =MA or
						ship.location = PL)
					{
					if(translator.location = Me) "\bEXTERNAL ATMOSPHERE IS WITHIN 
												SAFETY PARAMETERS";
					else "a cacophony of sounds you cannot even begin to comprehend.";
					}
				else
					{
					if(translator.location =Me) "\bEXTERNAL ATMOSPHERE IS NOT WITHIN
													SAFETY PARAMETERS";
					else "a cacophony of sounds you cannot even begin to comprehend.";
					}
				airlock.islocked := nil;
				self.primed := true;
				shipin.wallsdown := true;
				}
			else
				{
				"A loud click resounds from within the airlock.  The walls to the northeast and southeast turn
				fluid and flow up into the ceiling revealing lit passages in those directions.";
				airlock.islocked := true;
				self.primed := nil;
				shipin.wallsdown := nil;
				if (not self.donce)
					{incscore(5);		//5 for gaining acces to the ship (1st time)
						self.donce := true;}
				}
			}
		}
;

airhand: decoration
	sdesc = "handle"
	ldesc = "There is nothing special about the handle."
	adjective = 'airlock' 'door'
	location = airlock
;

curvsh1: shiproom
	sdesc = "Curving Passage"
	ldesc = {
				"This well lit, perfectly smooth  and shiny corridor curves from a doorway to the southwest to
					a doorway to the southeast.  There is a silver pad on the floor here made from a
					material that is less shiny than the rest of the corridor.  ";
				if (fladder.deploy) "In the floor next to the pad is a hole.  The top of a ladder is sticking out
										of the hole.";
				}
	sw = shipin
	se = shcont
	down = {
		if (fladder.deploy = true)
			{
			"You climb down the ladder.\b";
			return(cellar);
			}
		else
			{
			"You can't go in that direction";
			return(nil);
			}
		}
;

fladpad: touchitem
	sdesc = " square silver pad"
	ldesc = "The silver pad is perfectly square and slightly larger than you hand.  It 
			is made of some material that is less shiny than the material of the surrounding ship."
	noun = 'pad'
	adjective = 'square' 'silver'
	location = curvsh1
	doTouch(actor)={
		if (fladder.deploy)
			{
			"The ladder and the floor around it turns fluid and flows together sealing the hole shut.";
			fladder.deploy := nil;
			fladder.moveInto(void);
			}
		else
			{
			"The floor at you feet turns liquid and opens up to reveal a passage in the floor.  The still liquid
			floor reshapes itself into a rigid ladder leading down into the newly formed passage.";
			fladder.deploy := true;
			fladder.moveInto(curvsh1);
			}
		}
;

fladder: fixeditem
	sdesc = "ladder"
	ldesc = "The ladder ends a few inches above the hole in the floor and continues into the	
				passage leading down."
	noun = 'ladder'
	location = void
	deploy = nil
	doTake(actor) ={"The ladder is firmly fixed to the ship.  You cannot take it.";
								fladder.moveInto(curvsh1);
								}
	doClimb(actor) ={"You climb down the ladder.\b";
									actor.travelTo(cellar);
								}
;

cellar: shiproom
	sdesc = "Circular Room"
	ldesc = "The room is perfectly circular and made of gleaming silvery metal.  The only way out is back up the ladder. 
			On the wall 
				opposite from you is a silvery square button and a silvery octagonal button.  There 
				is some strange writing above the buttons."
	up = {
		"You haul yourself up the ladder.\b";
		return(curvsh1);
		}
;

cladder: fixeditem
	sdesc = "ladder"
	ldesc = "The ladder ends a few inches above the floor and continues up through a hole
					in the ceiling."
	noun = 'ladder'
	location = cellar
	deploy = nil
	doTake(actor) ={"The ladder is firmly fixed to the ship.  You cannot take it.";
								cladder.moveInto(cellar);
								}
	doClimb(actor) ={"You haul yourself up the ladder.\b";
									actor.travelTo(curvsh1);
								}
;

butwriting: decoration, readable
	sdesc = "strange writing"
	ldesc ={
		if(translator.location = Me)
			{
			"Even though you know there is no way you can comprehend the writing, much to your surprise, you find you
			get an impression of its meaning.  The two buttons activate passage to part of the ship.";
			}
		else
			"You cannot even begin to comprehend the writing, much less read it.";
		}
	noun = 'writing'
	adjective = 'strange' 'alien'
	location = cellar
;

sqbutton: buttonitem
	sdesc = "square button"
	ldesc = {
			"The silvery square button is two inches square";
				if (octbutton.active) " and feels warm to the touch.";
				else ".";
			}
	noun = 'button'
	adjective = 'square' 'silvery'
	location = cellar
	donce = nil
	doPush(actor) ={
			"Click.";
			if(octbutton.active)
				{
				ladpad.active := not ladpad.active;
				if (not self.donce) incscore(5);		// 5 points for activating bedroom access pad
				self.donce := true;
				}
			}
;

octbutton: vowelItem, buttonitem
	sdesc = "octagonal button"
	ldesc =  "The silvery octagonal button is about a quarter of an inch a side and is very shiny."
	noun = 'button'
	adjective = 'octagonal' 'silvery' 'shiny'
	location = cellar
	active = nil
	doPush(actor) = {
				"The square button flashes for an instant as you push <<self.thedesc>>.";
				self.active := not self.active;
				}
;

curvsh2: shiproom
	sdesc = "Curving Passage"
	ldesc = {
				"This well lit, perfectly smooth  and shiny corridor curves from a doorway to the northwest to
					a doorway to the northeast.  There is a silver pad on the wall here made from a
					material that is less shiny than the rest of the corridor.  ";
				if (bladder.deploy) "In the ceiling there is a hole with the bottom of a ladder sticking out
										of it.";
				}
	nw = shipin
	ne = shcont
	up = {
		if (bladder.deploy)
			{
			"You swiftly climb up the ladder.\b";
			return(bedroom);
			}
		else
			{
			"You can't go in that direction.";
			return(nil);
			}
	}
;

ladpad: touchitem
	sdesc = "circular silver pad"
	ldesc = "The silver pad is perfectly circular and slightly larger than you hand.  It 
			is made of some material that is less shiny than the material of the surrounding ship."
	noun = 'pad'
	adjective = 'circular' 'silver'
	active = nil
	once = nil
	location = curvsh2
	doTouch(actor)={
		if(self.active)
			{
			if(bladder.deploy)
				{
				"The ladder melts up into the ceiling completely closing off the passage above.";
				bladder.deploy := nil;
				bladder.moveInto(void);
				}
			else
				{
				"The ceiling above turns fluid and flows down forming a passage in the ceiling and
					a ladder leading up through the newly formed passage.";
				bladder.deploy := true;
				bladder.moveInto(curvsh2);
				}
			}
		else "Nothing happens.";
	}
;

bladder: item
	sdesc = "ladder"
	ldesc = "The ladder ends about a foot above the floor and continues up through a hole
					in the ceiling."
	noun = 'ladder'
	location = void
	deploy = nil
	doTake(actor) ={ "The ladder is firmly attached to the ship.  You cannot take it.";
								self.moveInto(curvsh2);
								}
	doClimb(actor) = {"You swiftly climb up the ladder.\b";
									actor.travelTo(bedroom);
								}
;


bedroom: shiproom
	sdesc = "Bedroom"
	ldesc = "This is obviously the quarters of the creature who, until recently, piloted
				this ship.  There is a firm looking mattress on the floor and a golden 
				panel on the far eastern wall.  There is a opening in the western wall and 
				a ladder leads down from here."
	west = closet
	down = {
					"You climb down the ladder.\b";
					return(curvsh2);
				}
;

beladder: fixeditem
	sdesc = "ladder"
	ldesc = "The ladder ends a few inches above the hole in the floor and continues into the	
				passage leading down."
	noun = 'ladder'
	location = bedroom
	doTake(actor) ={ "The ladder is firmly attached to the ship.  You cannot take it.";
								self.moveInto(bedroom);
								}
	doClimb(actor) = {"You climb down the ladder.\b";
									actor.travelTo(curvsh2);
								}
;

goldenpanel: touchitem
	sdesc = "golden panel"
	ldesc = "The golden panel is elliptical and about the size of you head."
	noun = 'panel'
	adjective = 'golden' 'gold' 'elliptical'
	location = bedroom
	doTouch(actor) = {
		if(gloves.isworn or suit.isworn or icesuit.isworn) "Nothing happens.";
		else
			{
			"A fine mist shoots out of the wall above the panel and surrounds you in a golden fog.  
			Thoughts of turkey dinners and cheeseburgers with chocolate shakes float through your 
			head like marshmallows in hot chocolate.  Your gluttonous thoughts soon drift out 
			of your mind.  You find, however, that your hunger is completely satisfied.";
			global.lastMealTime := 0;
			}
		}
;

closet: shiproom
	sdesc = "Closet"
	ldesc = "This cramped room must have been the pilot's closet.  The only exit is to the east."
	east = bedroom
	out = bedroom
;

// Control Room Area

shcont: shiproom
	sdesc = "Control Room"
	ldesc = {
		"This cylindrical room, for lack of better words to describe it, must be the 
		control room for the ship.  A red lit passage leads out of the room to the west.  Two well lit passages exit 
		the room to the northwest and southwest.\b\tThe front wall of the room is dominated by a large silvery panel 
		that rumbles with deep power. ";
		if (holefloor.location = shcont)
			"On the floor of the room, near the front wall, is a deep, dark hole.";
		}
	west = sheng
	nw = curvsh1
	sw = curvsh2
;

sheng: room
	sdesc = "Power Room"
	ldesc = "This perfectly spherical room is at least thirty yards in diameter.  Floating in the very center of 
			the room is a huge red gemstone.  The stone illuminates the entire room in a bright red light.  The 
			only exit is back to the east."
	east = shcont
;

crystal: item
	sdesc = "huge gemstone"
	ldesc = "The huge red gemstone is at least nine feet in radius.  You can see great sparks of power fly 
			to and fro inside the facets of the stone."
	noun = 'gem' 'gemstone' 'crystal'
	adjective = 'red' 'large' 'huge'
	location = sheng
	doTake(actor) = {
			if(self.maxweight <> 10)
				{
				"Even with your enhanced strength <<self.thedesc>> is just much to big and heavy 
				to carry.";
				self.moveInto(sheng);
				}
			else
				{
				"You trying to take the <<self.sdesc>> is like an ant trying to carry a tank.  It is much, 
				much, MUCH to heavy.";
				self.moveInto(sheng);
				}
		}
;

// Control Panel

contpan: fixeditem
	sdesc = "large silvery panel"
	ldesc = {
				"The large silvery panel completely covers the eastern wall of the room.  Some type 
				of strange writing covers the panel.  The only thing that you think might be of use on the panel are 
				a line of eight symbols";
				{
					if (goldbut.location = contpan)
						{
						if(holepanel.location =contpan)
							{
							if(instrcry.location = contpan)											/*crystal, hole and button*/
								", a dark pad, a small, thin orange crystal sticking out of the panel, 
									a small hole next to the 
									dark pad, a gold button and a copper button.";
							else																					/*hole and button*/
								", a dark pad, a small hole next to the dark pad, 
								a gold button and a copper button.";
							}
						else
							{
							if(instrcry.location =contpan)											/*crystal and button*/
								", a dark pad, a small, thin orange crystal sticking out of the panel, 
									a gold button and 
									a copper button.";
							else																				/*buttons only*/
								", a dark pad, a gold button and a copper button.";
							}
						}
					else " and a dark pad.";
				}
			}
	noun = 'panel'
	adjective = 'control' 'silvery' 'large'
	location = shcont
;

writing: decoration
	sdesc = "strange writing"
	ldesc = {
			if(translator.location = Me)
				"You have no comprehension of what the strange writing means but you get the impression 
				that the line of symbols activate the ship somehow.";
			else
				"You have no comprehension of what the strange writing means.";
			}
	noun = 'writing'
	adjective = 'strange'
	location = contpan
;

writpad: touchitem
	sdesc = "dark glossy pad"	
	ldesc = "The pad is made of some smooth, glossy dark substance.  It is the only part of the panel 
			that is not silver."
	noun = 'pad'
	adjective = 'dark' 'glossy'
	location = shcont
	triggered = nil
	doTouch(actor) ={
		"The pad flashes briefly as you touch it.  Nothing happens for a moment after the flash but then 
		a tinny voice announces ";
		if(translator.location = Me)
		{
		if(but1.active) "\b\tFIRST PROGRAM \t\t	TERRA 1995 AD\n";
		else"\b\tFIRST PROGRAM \t\t MALFUNCTION\n";
		"\tSECOND PROGRAM \t\t VENUS 1953 AD\n
		\tTHIRD PROGRAM \t\t EUROPA 20 BC\n
		\tFOURTH PROGRAM \t\t MARS 2537 AD\n
		\tFIFTH PROGRAM \t\t PLUTO 1 MILLION AD\n
		\tSIXTH PROGRAM \t\t MERCURY 1825 AD\n
		\tSEVENTH PROGRAM \tCHARON 1 MILLION AD\n";
		if(not but8.fixed)
		"\tEIGHTH PROGRAM \t\t MALFUNCTION";
		else
		"\tEIGHTH PROGRAM \t\t <<upper(chrcry.destset)>> <<chrcry.tmset>> <<upper(chrcry.eraset)>>";
		self.triggered := true;
		}
		else
		"a message that seems to contain more sounds than you thought existed.  Never the less, whatever is 
			being said you cannot understand it.";
		}
;

// repair manual


instrcry: item
	sdesc = "small orange crystal"
	ldesc ={
			"The orange crystal is the length of you hand and as think as your index finger.";
			if(self.location = contpan)
			"  The <<self.sdesc>> is jutting out of the silvery panel just next to the dark, glossy pad.";
			}
	noun = 'crystal' 'gem'
	adjective = 'orange' 'small' 'thin' 'repair'
	location = void
	doTake(actor) ={
			if(self.location =contpan) {
			"You remove <<self.thedesc>> from the control panel which seals up 
			leaving no mark.";
			self.moveInto(Me);
			}
			else
			pass doTake;
			}
;

goldbut: buttonitem
	sdesc = "gold button"
	ldesc = "Looks like every other gold button you have 
				ever seen."
	adjective = 'gold'
	location = void
	doPush(actor) ={
		if(holefloor.location = void)
			{
			"When you push the gold button part of floor and control panel flows apart to 
				reveal a deep hole in the floor and small shallow hole in the control panel.";
			holefloor.moveInto(shcont);
			holepanel.moveInto(contpan);
			}
		else
			{
			"The material around the holes in the floor and control panel liquefy and 
				flow into the holes sealing them up.";
			holefloor.moveInto(void);
			holepanel.moveInto(void);
			}
		}
;
 
coppbut: buttonitem
	sdesc = "copper button"
	ldesc = "Looks like every other copper button you have ever seen."
	adjective = 'copper' 
	location = void
	active = nil
	doPush(actor)={
		if (holefloor.location = shcont)
			{
			if(self.active)
				{"With thick, slurpy sound the floor surrounding the hole in the floor 
					liquefies and flows into the hole, sealing it up.  A horrible rasping sound 
					vibrates the floor underfoot and the control panel lights up with a mad 
					flurry of activity.  The gold and copper buttons turn fluid and disappear 
					into the control panel leaving no trace of their existence.";
					if(holepanel.location = contpan) "  The material around the small hole in the 
					control panel turns fluid as well and fill in the small hole with a gulp.  ";
					"\n\tWhen the racket subsides a familiar tinny voice 
					intones ";
						if(translator.location =Me)
						"\n\t\t\t\t\t\tREPAIR COMPLETE\n
						\t\t\t\tEIGHTH PROGRAM --- <<upper(chrcry.destset)>> <<chrcry.tmset>> 
										<<upper(chrcry.eraset)>>";
						else
						"a cacophony of sounds you cannot comprehend.";
					but8.fixed := true;
					goldbut.moveInto(void);
					coppbut.moveInto(void);
					holepanel.moveInto(void);
					incscore(10)	;					//  10 points for repairing 8th symbol
					}
				else
					{"With a thick, slurpy sound the floor surrounding the hole in the floor 
						liquefies and flows into the hole, sealing it up.  After a moment a tinny 
						voice announces ";
							if(translator.location =Me)
							"\nALL ITEMS NEEDED FOR REPAIR NOT PRESENT.  CONSULT 
							REPAIR CRYSTAL FOR INSTRUCTIONS.";
							else
							"a cacophony of sounds you cannot comprehend.";
					"\n\tThe floor reliquefies and forms the hole again.";
					}
				}
			else "Nothing happens.";
			}
;


// symbols

symb: decoration
	sdesc = "line of symbols"
	ldesc = {
		"You have never seen such symbols before in your life.  You have no idea 
			what they could stand for.  The ";
		if(ship.location = E1) "first ";
		if(ship.location = V) "second ";
		if(ship.location = EU)"third ";
		if(ship.location = MA) "fourth ";
		if(ship.location = PL) "fifth ";
		if(ship.location = MER) "sixth ";
		if(ship.location = CH) "seventh ";
		if(ship.location = E2) "eighth ";
		"symbol is glowing slightly.";
			}
	noun = 'symbols'
	adjective = 'line of'
	location = contpan
;

class symbitem: touchitem
	noun = 'symbol'
	adjective = 'strange'
	timetrav = {"When you touch the symbol the entire ship comes to life.  A deep trembling 
					builds in the bowels of the vessel.  The sound reaches a crescendo and reality seems 
					to explode into a rainbow of light and energy.  Then, suddenly, it all stops.  A 
					tinny voice announces ";
					}
	location = contpan
;
	
shipglobal:object
	firsttime = nil
;

panictouch:function
	{
	if(shipglobal.firsttime = nil)
	{
	"\b\tAfter the announcement panic seizes your heart.  The feeling that you are now in real trouble fills your soul. 
	Not sure what you are doing you touch one on the symbols at random, the first one.\n\tThe ship again starts to 
	rumble and quake.  Without warning, sparks start 
	to fly across the panel melting the first symbol into a liquid goo that quickly hardens.";
	if(writpad.triggered = true)
	"\n\tThe realization slowly dawns on you that that was the only symbol that could have gotten 
	you home.  Now you truly are lost.  Lost in time and space.";
	but1.active := nil;
	shipglobal.firsttime := true;
	}
	}
;

but1: touchitem
	sdesc = "first symbol"
	ldesc ={
		if(ship.location =E1) "The first symbol is glowing slightly.";
		if(not but1.active) "What was one the first symbol is a twisted mess of silvery metal.";
		else
			if (ship.location <> E1 and but1.active) "It looks just like every other strange symbol 
			you have every seen.";
		}
	noun = 'symbol'
	adjective = 'first' 'strange'
	active = true
	location = contpan
	doTouch(actor) = {
		if(self.active)
			 "Nothing happens.";
		else "The symbol is completely melted.  There is nothing to touch.";
		}
;
		
but2: symbitem
	sdesc = "second symbol"
	ldesc = {
		if(ship.location = V) "The second symbol is glowing slightly.";
		else "It looks just like every other strange symbol you have seen.";
		}
	adjective = 'second'
	doTouch(actor) = {
		if(ship.location <> V){ "<<self.timetrav>>";
			if(translator.location = Me)"\b\t\t ARRIVAL VENUS 1953 AD";
			else "something in a language that sounds like a squid kissing a suction cup.";
			ship.moveInto(V);
			panictouch();
			}
		else "Nothing happens.";
	}
;

but3: symbitem
	sdesc ="third symbol"
	ldesc ={
		if (ship.location = EU) "The third symbol is glowing slightly.";
		else "It looks just like every other strange symbol you have seen.";
		}
	adjective = 'third'
	doTouch(actor)={
		if (ship.location <> EU) {"<<self.timetrav>>";
			if(translator.location = Me)"\b\t\t ARRIVAL EUROPA 20 BC";
			else "something in a language that causes your tongue to tie into knots as 
				you try to mimic it.";
			ship.moveInto(EU);
			panictouch();
			}
		else "Nothing happens.";
	}
;

but4: symbitem
	sdesc = "fourth symbol"
	ldesc = {
		if(ship.location = MA) "The fourth symbol is glowing slightly.";
		else "It looks just like every other strange symbol you have seen.";
		}
	adjective = 'fourth'
	doTouch(actor)={
		if(ship.location <> MA) {"<<self.timetrav>>";
			if(translator.location = Me)"\b\t\t ARRIVAL MARS 2537 AD";
			else "something in a language that would cause most linguists to have a 
					heart attack.";
			ship.moveInto(MA);
			panictouch();
			}
		else "Nothing happens.";
	}
;

but5: symbitem
	sdesc = "fifth symbol"
	ldesc = {
		if(ship.location = PL) "The fifth symbol is glowing slightly.";
		else "It looks just like every other strange symbol you have seen.";
		}
	adjective = 'fifth'
	doTouch(actor)={
		if(ship.location <>PL){"<<self.timetrav>>";
			if(translator.location = Me)"\b\t\t ARRIVAL PLUTO 1 MILLION AD";
				else "something in a language that human being could never reproduce.";
				ship.moveInto(PL);
				panictouch();
			}
		else "Nothing happens.";
	}
;

but6: symbitem
	sdesc = "sixth symbol"
	ldesc ={
		if(ship.location = MER)"The sixth symbol is glowing slightly.";
		else "It looks just like every other strange symbol you have seen.";
		}
	adjective = 'sixth'
	doTouch(actor) = {
		if(ship.location <> MER) {"<<self.timetrav>>";
			if(translator.location = Me)"\b\t\tARRIVAL MERCURY 1825 AD";
			else "something in a language that have a vague resemblance to a drowning moose 
				trying to sing classical opera.";
			ship.moveInto(MER);
			panictouch();
			}
		else "Nothing happens.";
	}
;

but7: symbitem
	sdesc = "seventh symbol"
	ldesc = {
		if(ship.location = CH) "The seventh symbol is glowing slightly.";
		else "It looks like every other strange symbol you have seen.";
		}
	adjective = 'seventh'
	doTouch(actor) ={
		if(ship.location <>CH){"<<self.timetrav>>";
			if(translator.location = Me)"\b\t\tARRIVAL CHARON 1 MILLION AD";
			else "something in a language that gives you a bad headache as you try to listen.";
			ship.moveInto(CH);
			panictouch();
			}
		else "Nothing happens.";
	}
;

eighthbutton: function
	{
		"You touch the eighth symbol and the entire ship comes to life exactly as it has done 
			many times before.  Colors flare about, reality twists upon itself into a nightmarish 
			pattern. The entire ship rumbles and shakes violently with increasing ferocity.\n\tPanic starts 
			to settle in you mind.  You think, \"Maybe I did something wrong in repairing the ship?\"  
			The violence of the vibrations throw you about the ship like a rag doll.  The entire ship feels like it is going 
			to shake itself apart when suddenly";
	if(chrcry.destset = 'Zoltar')
		{
		if(chrcry.tmset < 2500)
			{" the ship comes to a sudden halt and loud alarms start to ring.  The control panel before you 
				turns transparent through which you see the world outside.\n\tZoltar looks like a beautiful planet of emerald 
				green fields and a pink sky with five moons lit by a giant red sun.  You admire the view for a moment 
				before the sun goes supernova, vaporizing the moons, the planet and you.";
				die();
			}
		else
			{
				" the ship comes to a sudden halt and loud alarms start to ring.  The control panel before you 
				turns transparent through which you can see the view outside the craft. \n\tThe ship is floating in 
				space.  The view is dominated by a large black hole surrounded by a fiery halo of radiation.  Before 
				you can react the maelstrom draws you into it where you are ripped apart by the gravitational tides.";
				die();
			}
		}
	if(chrcry.destset = 'Neo-Trilliozaptiofilliocoozbilliarth')
		{" the ship comes to a sudden halt and loud alarms start ringing.  A loud hammering continues to 
			shake the ship.  The control panel before you turns transparent through which you get a view of the world 
			outside.\n\tStanding over the ship, like a child over a bug, is a giant turkey being ridden by a blue 
			furred humanoid creature.  The turkey is kicking the ship violently.  Before you can react, the blue furred 
			man yells something at the giant bird.  The turkey proceeds to step on the ship, crushing it like an 
			empty aluminum can.";
		die();
		}
	if(chrcry.destset <> 'Terra')
		but8.home := nil;
	else
		{
		if(chrcry.tmset = 1995 and chrcry.eraset ='AD')
				but8.home := true;
		else
				but8.home:=nil;
		}
	if (not but8.home)
		{" a titanic explosion rocks the ship in flight.  You turn around just in time to see a large part of the 
			huge crystal from the power room flying straight towards you from its chamber to the west.  Before 
			you can react the hunk of gemstone smashes you into the control panel, smashing you into a mass of bloody jelly.";
		die();
		}
	else
		" the ship comes to a sudden halt and all is quiet.  A familiar tinny voice softly announces ";
}
;

but8: vowelItem, symbitem
	sdesc = "eighth symbol"
	ldesc = {
		if(ship.location = E2)"The eighth symbol is glowing slightly.";
		else "It looks like every other strange symbol you have seen.";
		}
	adjective = 'eighth' 'last'
	fixed = nil
	home = nil
	donce = nil
	doTouch(actor)={
		if(self.fixed)
			{
			if(ship.location <> E2)
				{
				eighthbutton();
				if(translator.location = Me) "\b\t\t ARRIVAL TERRA 1995 AD";
				else "something in a language that sounds vaguely like drinking thick toxic 
						sludge through a hot brick.";
				ship.moveInto(E2);
				}
			else "Nothing happens.";
			}
		else
			{
			"A tinny voice announces ";
				if (translator.location =Me)"\b\t\tMALFUNTION...MALFUNCTION...\n
					\t\tCONSULT REPAIR CRYSTAL FOR INSTRUCTIONS\b";
				else "something in a language that you would need at least one extra tongue to 
						pronounce.\b";
			if (not self.donce)
				{
				"A small, thin orange crystal grows out of the control panel next to the 
					dark pad.  A gold and copper button also flow out of the control panel below the line of symbols.";
				goldbut.moveInto(contpan);
				coppbut.moveInto(contpan);
				instrcry.moveInto(contpan);
				self.donce := true;
				}
			}
		}
;





// holes

holefloor: fixeditem, container
	sdesc = "deep hole"
	ldesc = "The hole is very dark and goes a long way down."
	noun = 'hole' 'hopper'
	adjective = 'deep'
	location = void
	itemcount = 0
	warning = nil
	verIoPutIn(actor)={}
	ioPutIn(actor, dobj)=
		{
		if(dobj.istreasure)
			{
			"\^<<dobj.thedesc>> disappears into the hole.";
			if(dobj = neutron) incscore(10);					// 10 points for neutronium in hole
			if(dobj = icechip) incscore(25);					// 25 points for ice chip in hole
			dobj.moveInto(tvoid);
			self.itemcount := self.itemcount +1;
			if(self.itemcount >=6) coppbut.active := true;
			}
		else
			{
			if(not isclass(dobj, bodyitem))
			{
			"\^<<dobj.thedesc>> disappears into the hole.\n\t After a moment <<dobj.thedesc>> 
			flies out of the hole and onto the floor.  A tinny voice intones";
				if(translator.location = Me)
				"\bITEM NOT REQUIRED FOR REPAIR\b";
				else
				" a mess of sounds that makes you feel slightly woozy.\b";
				dobj.moveInto(shcont);
			}
			else
				{
				"You dangle your <<dobj.sdesc>> over the rim of the deep hole.";
				}
			}
		}
	doEnter(actor) ={
		if( not self.warning) {"I wouldn't do that if I were you.";
											self.warning := true;
											return(nil);}
		else
			{
				"You take a flying leap into <<self.thedesc>> in the floor.  You fall through darkness for 
				about three feet when you are hit from a 
				blast of air from below.  Suddenly you find yourself flying out of the hole and onto the floor
				of the control room.  Unfortunately 
				you land on your neck and break it with an audible \"SNAP!\"";
				die();
			}
	}
;

holepanel: fixeditem, container
	sdesc = "small hole"
	ldesc = "The hole is about six inches deep and just as thick as your index finger."
	noun = 'hole'
	adjective = 'small'
	location = void
	verIoPutIn(actor) = {}
	ioPutIn(actor, dobj) ={
				
		if (dobj = instrcry) {
				"The lights on the control panel flash for a moment then the orange crystal glows 
				with an inner light.  A monotone voice resounds from the crystal.  ";
				if(translator.location = Me)
				"\b\tTo facilitate repair of faulty destination program activator the following items 
					must be fed into the repair hopper: a left-handed widget, an ice microchip, 
					the appropriately programed chronoprogram crystal, a lump of neutronium, 
					an ambidexterous laser trinketer and a piece of 100% pure iron.\n
					\tOnce these items are fed into the repair hopper press the copper repair switch 
					and the ship will go into repair mode to automatically repair the malfunction.\b
					The light and voice die down.";
				else
					"Unfortunately you understand theoretical quantum field theory better that what is being 
					spoken.\b\tAfter a moment the light and voice dies down.";
				instrcry.moveInto(holepanel);
				exit;
			}
		if(dobj = finger)
			{
			"You place your finger in the hole and wiggle it about.  When you try to remove it, however, you find 
			your finger has become stuck.  You tug and tug, but it is no use.  You are stuck.   Suddenly a hot pain rockets up 
			your arm from your finger.  You look down with shock as you see a halo of fire start creeping up your 
			finger and up your arm.  Desperately, and in great pain,  you try to remove your finger from the panel.  After 
			a few moments the halo spreads over your entire body and cooks your to a fine ash.";
			die();
			}
		"\^<<dobj.thedesc>> does not fit in the hole.";
		}
;
