;
; Note:  This AGT CMD source file Copyright (c) W.P. Kegelmeyer, 1988
;
;
; Debugging aid.
;

COMMAND DEBUG
ToggleFlag 0			; Turns on meta debugging
DoneWithTurn
END_COMMAND

;
; Initialization of the various variables at the beginnming of the game
;
COMMAND ANY
FlagOff 1			; First turn of game?
SetVariableTo 1	40		; Set Tark's hits
SetVariableTo 2	100		; Set Tark's spirit
SetVariableTo 3	33		; Set JenLee's hits
SetVariableTo 4	100		; Set JenLee's spirit
SetVariableTo 5	50		; Set Neanderthal's spirt
SetVariableTo 6	114		; Set Tark's spell points
SetVariableTo 7 0		; Set Number of times in Oliphant's nest
SetVariableTo 8 0		; Start off with no new lives
TurnFlagOn 1
END_COMMAND

;
; Status checks and operations to be performed at the beginning of each turn.
; 
;
;			Check win game conditions
;
COMMAND ANY
Present 201		; Soul song is being carried
AtLocation 3		; In Astral Plane
TurnFlagOn 255		; Game won, note with flag
PrintMessage 152	; Print game win message
PrintMessage 150	; Print our Tark's spirituality level
END_COMMAND
COMMAND ANY
FlagOn 255		; Game has been won
Present 300		; Jen-Lee is present
PrintMessage 151	; Print her spirituality as well
END_COMMAND
COMMAND ANY
FlagOn 255		; Game has been won
SendTreasuresToRoom 20	5	; So score will be zero
WinGame			; So win game
DoneWithTurn
QuitAllCmds
END_COMMAND
;
;			Check life status
;
COMMAND ANY
NewLife				; A new life?
AddToVariable 8 1		; Keep track
END_COMMAND
COMMAND ANY
VariableEquals 8 4		; Too many lives
PrintMessage 149		; Resurrection didn't take
PrintMessage 150 		; Spirituality status
Present 300 			; JenLee is present
PrintMessage 151		; Print out her spiritual level
END_COMMAND
COMMAND ANY
VariableEquals 8 4		; Too many lives
SendTreasuresToRoom 20	5	; So score will be zero
EndGame				; Game over
DoneWithTurn
QuitAllCmds
END_COMMAND
;
;			Check spirituality
;
COMMAND ANY
VariableGT 2 100	; If Tark is more spiritual than max possible
SetVariableTo 2 100	; Reset to max possible
END_COMMAND
COMMAND ANY
VariableGT 4 100	; If JenLee is more spiritual than max possible
SetVariableTo 4 100	; Reset to max possible
END_COMMAND
COMMAND ANY
VariableLT 2 0			; If Tark has become evil
PrintMessage 11			; End of game
TurnFlagOn 255		; Game lost note with flag
PrintMessage 150	; Print Tark's spirituality level
END_COMMAND
COMMAND ANY
FlagOn 255		; Game has been won
Present 300		; Jen-Lee is present
PrintMessage 151	; Print her spirituality as well
END_COMMAND
COMMAND ANY
FlagOn 255			; Game has been lost
SendTreasuresToRoom 20	5	; So score will be zero
EndGame				; Game is over
DoneWithTurn		
QuitAllCmds
END_COMMAND
COMMAND ANY
VariableLT 4 0		; If JenLee has become evil
IsSomewhere 300		; And this is the first turn she is evil
PrintMessage 12		; She kills Tark
SwapLocations 300 319	; Bring out Evil JenLee
DoneWithTurn
END_COMMAND
COMMAND ANY
VariableGT 4 0		; If JenLee is good
IsSomewhere 319		; And Evil JenLee is on the prowl
SwapLocations 300 319	; Bring out Good JenLee
END_COMMAND
COMMAND ANY
VariableGT 5 100	; If Neanderthal is good
IsSomewhere 317		; And he still exists
Destroy 317		; Send him to heaven.
PrintMessage 14		; Neanderthal goes to heaven.
SetVariableTo 5 0	; Avoid duplicated message bug
TurnCounterOff 4	; And turn off his counter, if he's summoned.
END_COMMAND
;
;			Check health
;
COMMAND ANY
VariableLT 3 0		; JenLee is dead
IsSomeWhere 300		; She's still alive
SwapLocations 203 300	; Swap her with dead JenLee
PrintMessage 15		; whoops, JenLee is dead.
END_COMMAND
COMMAND ANY
VariableLT 3 5		; JenLee hurting badly
IsSomeWhere 300		; She's still alive
PrintMessage 16		; Warning, JenLee hurt.
END_COMMAND
COMMAND ANY
VariableLT 1 0		; Tark is dead
PrintMessage 17		; Whoops, you seem to be dead.
SetVariableTo 1 20	; Give her some hits when resurrected
KillPlayer		; Whoops, she died.
DoneWithTurn
END_COMMAND
COMMAND ANY
VariableLT 1 1		; Tark hurting badly, at 0
FlagOFF 4		; Jen-Lee's cure not yet used
Present 300		; JenLee is present
PrintMessage 18		; Jen-Lee uses her cure
AddToVariable 1 10	; JenLee cures for 10
TurnFlagOn 4		; Note, JenLee's cure has been used.
END_COMMAND
COMMAND ANY
VariableLT 1 1		; Tark hurting badly, and cure has been used.
PrintMessage 19		; MORE.  Too hurt to recover.
SetVariableTo 1 20	; Give her some hits when resurrected
KillPlayer		; Whoops, she died.
DoneWithTurn
END_COMMAND
COMMAND ANY
VariableLT 1 5		; Tark hurting 
Present 300		; JenLee is present
PrintMessage 99		; Jen-Lee is concerned; should she do cure?
END_COMMAND
;
;			Check the magic lantern
;
COMMAND ANY
CounterEquals 1 20	; Light has been on for 20 turns
Present 220		; If light is present
PrintMessage 43		; Light goes out.
END_COMMAND
COMMAND ANY
CounterEquals 1 20	; Light has been on for 20 turns
Destroy 220		; So extinguish it
TurnCounterOff 1	; And turn off its counter
END_COMMAND
;
;			Check on Jeff
;
COMMAND ANY
CounterEquals 2 5	; Jeff has been present for enough turns
Present 301		; If Jeff is present
PrintMessage 52		; Mention that he goes away
END_COMMAND
COMMAND ANY
CounterEquals 2 5	; Jeff has been present for enough turns
Destroy 301		; So banish him
TurnCounterOff 2	; And turn off his counter
END_COMMAND
;
;			Check on Loam
;
COMMAND ANY
CounterEquals 3 5	; Loam has been present for enough turns
Present 309		; If Loam is present
 OR			; or
Present 310		; If charmed Loam is present
PrintMessage 53		; Mention that he goes away
END_COMMAND
COMMAND ANY
CounterEquals 3 5	; Loam has been present for enough turns
Destroy 309		; So banish him
Destroy 310		; Regardless of his form
TurnCounterOff 3	; And turn off his counter
END_COMMAND
;
;			Check on Neanderthal
;
COMMAND ANY
CounterEquals 4 5	; Neanderthal has been present for enough turns
Present 317		; If Neanderthal is present
PrintMessage 54		; Mention that he goes away
END_COMMAND
COMMAND ANY
CounterEquals 4 5	; Neanderthal has been present for enough turns
IsSomeWhere 317		; And he hasn't been killed
SendToRoom 317 35	; So send him back to his lair
TurnCounterOff 4	; And turn off his counter
END_COMMAND
;
;			Check; In Oliphant's Nest?
;
COMMAND ANY
AtLocation 8			; In Oliphant's nest
VariableGT 7 5			; Oliphant present
Present 300			; JenLee is present
Destroy 300			; So kill her
END_COMMAND
COMMAND ANY
AtLocation 8			; In Oliphant's nest
VariableGT 7 5			; Oliphant present
PrintMessage 67			; Oliphant present, you die
KillPlayer			; Kill Tark
SetVariableTo 1 20		; Give her some hits when she comes back
DoneWithTurn
END_COMMAND
COMMAND ANY
AtLocation 8			; In Oliphant's nest
PrintMessage 66			; Taking damage from odor
SubtractFromVariable 1 6	; Tark takes damage
SubtractFromVariable 3 4	; JenLee takes less damage
AddToVariable 7 1		; Add to "in nest" counter.
VariableEquals 7 4		; Oliphant will be present next turn
PrintMessage 68			; Warning; flap of wings
END_COMMAND
;
;			Check; blood being kept in vial?
;
COMMAND ANY
IsSomewhere 212		; The useful blood is somewhere
IsLocated 212 211	; But it's in the vial
TurnCounterOff 5	; So stop checking on it
END_COMMAND
COMMAND ANY
IsSomewhere 212		; The useful blood is somewhere
NOT IsLocated 212 211 	; Not in the vial
CounterEquals 5	6	; And it's gotten old
SwapLocations 212 242	; Swap it with old blood, quietly
TurnCounterOff 5	; Stop watching the fresh blood
END_COMMAND
COMMAND ANY
IsSomewhere 212		; The useful blood is somewhere
NOT IsLocated 212 211 	; Not in the vial
CounterEquals 5	0	; The counter is not on
TurnCounterOn 5		; So turn it on
END_COMMAND
;
;			Grue, in the valley of
;
COMMAND ANY
NOT InRoom 302		; Grue not in current room
NOT InRoom 205		; Nor is the dead gure
NOT InRoom 303		; Nor is charmed grue
Destroy 302		; Grue disappears if player not present
Destroy	205		; Grue body disappears if player not present
Destroy	303		; Charmed grue disappears if player not present
END_COMMAND
COMMAND ANY
AtLocationGT 28		; Past the North bank
AtLocationLT 34		; Not to South bank
NOT InRoom 302		; Grue not in current room
NOT InRoom 303		; Charmed grue also not in room
NOT InRoom 205		; Nor is the dead grue
PutInCurrentRoom 302	; Put Grue in room
PrintMessage 101	; "A grue suddenly appears" 
END_COMMAND
;
;			Check vampire behavior
;
COMMAND ANY
InRoom 305			; Freed vampire is present
CounterLT 6 4			; Not mad yet
PrintMessage 133		; He asks for a kiss
END_COMMAND
COMMAND ANY
InRoom 305			; Freed vampire is present
CounterGT 6 3			; He's mad now
PrintMessage 134		; He attacks in a rush
SubtractFromVariable 1 13	; Does third of Tark's hits
END_COMMAND
COMMAND ANY
InRoom 304			; Captive vampire is present
PrintMessage 135		; He begs for release
END_COMMAND
;
;			Check magin behavior
;
COMMAND ANY
Chance 2			; Does a magin show?
TurnFlagOn 255			; He does, record temporarily
IsCarryingTreasure 5		; Carrying treasure?
SendTreasuresToRoom 20	5	; The earth plane hole
PrintMessage 147		; Magin takes your manacords
TurnFlagOff 255			; Magin has been handled
END_COMMAND
COMMAND ANY
FlagOn 255			; Magin showed, but no treasure
PrintMessage 148		; Disappointed magin
TurnFlagOff 255			; Magin has been handled
END_COMMAND
;
;			Check on Demon
;
COMMAND ANY
InRoom 317			; Demon is present
InRoom 243			; Pentagram is present
PrintMessage 153		; Demon rails at edge
END_COMMAND
COMMAND ANY
InRoom 317			; Demon is present
NOT InRoom 243			; Pentagram is not present
Present 300			; JenLee is present
PrintMessage 154		; Demon evilizes JenLee
SetVariableTo 4 0		; Sets her spirituality low
SwapLocations 300 319		; Place evil JenLee here
END_COMMAND
COMMAND ANY
InRoom 317			; Demon is present
NOT InRoom 243			; Pentagram is not present
PrintMessage 155		; Demon kills Tark
SubtractFromVariable 2 15	; Also affects her spirituality
KillPlayer 			; Kill Tark
DoneWithTurn
END_COMMAND
;
;			Check on being in Sink Hole
;
COMMAND ANY
AtLocation 20			; In the Sink Hole
FlagOff 8			; Earth Plane is not safe
InRoom 309			; Normal elemental is here
PrintMessage 156		; Loam is grateful at being brought home
Destroy 309			; He goes home
AddToVariable 2 15		; Tark gets a spirit boost
TurnFlagOn 8			; Earth Plane safe in future
END_COMMAND
COMMAND ANY
AtLocation 20			; In the Sink Hole
FlagOff 8			; Earth Plane not safe
PrintMessage 157		; You die
KillPlayer			; Kill her
DoneWithTurn
END_COMMAND
COMMAND ANY
AtLocation 20			; In the Sink Hole.  Must be safe, if here.
PrintMessage 158		; Sentient earth protects her.
END_COMMAND
;
;			Check on the water
;
COMMAND ANY
IsNowhere 213			; Normal water
IsNowhere 238			; Holy water
SendToRoom 213 7		; Put some water in the bathroom
END_COMMAND
;
;	End of "ANY" general processing commands
;
;
; Commands involving other actors
;
; Generic checking
;
COMMAND ANYBODY, ANY
NOT NamePresent			; Actor not present
PrintMessage 23			; Sorry, $NAME is not here.
DoneWithTurn
END_COMMAND
;
; Commands to JenLee
;
;	JenLee "Get" commands
;
COMMAND JENLEE, GET ANY
NameIsNumber 300		; Name is JenLee
NOUNinRoom			; Noun is present
NOUNIsMovable			; Noun can be moved
SendNOUNToRoom 300		; Put Noun in JenLee
PrintMessage 24			; JenLee is carrying NOUN
DoneWithTurn
END_COMMAND
COMMAND JENLEE, GET ANY
NameIsNumber 300		; Name is JenLee
NOUNIsCarrying			; Tark is carrying noun
PrintMessage 25			; You'll have to drop it first
DoneWithTurn
END_COMMAND
COMMAND JENLEE, GET ANY
NameIsNumber 300		; Name is JenLee
NOT NOUNPresent			; Noun isn't even present
PrintMessage 26			; Jen-Lee concerned about Tark's mind.
DoneWithTurn
END_COMMAND
COMMAND JENLEE, GET ANY
NameIsNumber 300		; Name is JenLee
NOT NOUNIsMovable		; Noun is not moveable
PrintMessage 27			; Sorry, I can't move the noun
DoneWithTurn
END_COMMAND
;
;	JenLee "Drop" commands
;
COMMAND JENLEE, DROP
NameIsNumber 300		; Name is JenLee
NOT NOUNIsLocated 300		; Jenlee is not carrying NOUN
PrintMessage 113		; JenLee: Can't drop what not carrying 
DoneWithTurn
END_COMMAND
COMMAND JENLEE, DROP
NameIsNumber 300		; Name is JenLee
NOUNIsLocated 300		; Jenlee is carrying NOUN
PrintMessage 114		; JenLee: Okay, boss
PutNOUNInCurrentRoom		; Move NOUN to current room
DoneWithTurn
END_COMMAND
;
;	JenLee "Heal" commands
;
COMMAND JENLEE, HEAL ME
NameIsNumber 300		; Name is JenLee
FlagOn 4			; Cure already used
PrintMessage 97			; Sorry, I've already used my cure
DoneWithTurn
END_COMMAND
COMMAND JENLEE, HEAL ME
NameIsNumber 300		; Name is JenLee
FlagOff 4			; Cure not already used
AddToVariable 1 10		; Jen-Lee applies her cure
TurnFlagOn 4			; Record that cure has been used
PrintMessage 98			; Jenlee cures Tark on demand
DoneWithTurn
END_COMMAND
;
;	JenLee "Attack" commands
;
COMMAND JENLEE, ATTACK ANY
NameIsNumber 300		; Name is JenLee
NOT NOUNPresent			; The NOUN is not present
PrintMessage 111		; JenLee: What NOUN, Tark?
DoneWithTurn
END_COMMAND
COMMAND JENLEE, ATTACK ANY
NameIsNumber 300		; Name is JenLee
NOUNIsNumber 302		; The target is the grue
PrintMessage 107		; It fights back
SubtractFromVariable 3 6	; It does damage
END_COMMAND
COMMAND JENLEE, ATTACK ANY
NameIsNumber 300		; Name is JenLee
NOUNIsNumber 303		; The target is the charmed grue
 OR
NOUNIsNumber 306		; charmed vampire
 OR 
NOUNIsNumber 308		; charmed cannibal
 OR
NOUNIsNumber 310		; charmed elemental
 OR
NOUNIsNumber 314		; charmed ghost
 OR 
NOUNIsNumber 316		; charmed derro
PrintMessage 104		; It stands there passively
END_COMMAND
COMMAND JENLEE, ATTACK ANY WITH SWORD
NameIsNumber 300		; Name is JenLee
NOT IsLocated 206 300		; She doesn't have normal sword
NOT IsLocated 207 300		; She doesn't have blessed sword
PrintMessage 126		; Don't have a OBJECT, will try fists.
END_COMMAND
COMMAND JENLEE, ATTACK ANY WITH SWORD
NameIsNumber 300		; Name is JenLee
ObjectIsNumber 207		; Object is blessed sword
IsLocated 207 300		; She is carrying blessed sword
NOUNIsNumber 302		; The target is the grue
 OR
NOUNIsNumber 303		; The target is the charmed grue
PrintMessage 109		; JenLee's blessed sword is effective
DestroyNOUN			; Kill the target
PutInCurrentRoom 205		; Put dead grue in current room
DoneWithTurn
END_COMMAND
COMMAND JENLEE, ATTACK ANY WITH SWORD
NameIsNumber 300		; Name is JenLee
ObjectPresent			; Sword is present
NOUNIsNumber 307		; The target is the cannibal
 OR
NOUNIsNumber 308		; The target is the charmed cannibal
PrintMessage 109		; JenLee's sword is effective
DestroyNOUN			; Kill the target
DoneWithTurn
END_COMMAND
COMMAND JENLEE, ATTACK ANY WITH SWORD
NameIsNumber 300		; Name is JenLee
ObjectIsNumber 206		; Object is normal sword
IsLocated 206 300		; She is carrying normal sword
NOUNIsNumber 302		; The target is the grue
 OR
NOUNIsNumber 303		; The target is the charmed grue
PrintMessage 108		; Jen_Lee's sword is ineffective
DoneWithTurn
END_COMMAND
COMMAND JENLEE, ATTACK ANY WITH DAGGER
NameIsNumber 300		; Name is JenLee
NOT IsLocated 216 300		; She doesn't have the dagger
PrintMessage 126		; Don't have a OBJECT, will try fists.
END_COMMAND
COMMAND JENLEE, ATTACK ANY WITH DAGGER
NameIsNumber 300		; Name is JenLee
ObjectIsNumber 216		; Object is Dagger
IsLocated 216 300		; She is carrying the dagger
NOUNIsNumber 302		; The target is the grue
 OR
NOUNIsNumber 303		; The target is the charmed grue
SubtractFromVariable 4 10	; JenLee takes takes some spiritual damage
PrintMessage 110		; Drains blood of target
DestroyNOUN			; Kill the target
PutInCurrentRoom 205		; Put dead grue in current room
DoneWithTurn
END_COMMAND
COMMAND JENLEE, ATTACK ANY WITH DAGGER
NameIsNumber 300		; Name is JenLee
ObjectIsNumber 216		; Object is Dagger
IsLocated 216 300		; She is carrying the dagger
NOUNIsNumber 307		; The target is the cannibal
 OR
NOUNIsNumber 308		; The target is the charmed cannibal
SubtractFromVariable 4 10	; JenLee takes takes some spiritual damage
PrintMessage 110		; Drains blood of target
DestroyNOUN			; Kill the target
DoneWithTurn
END_COMMAND
COMMAND JENLEE, ATTACK ANY
NameIsNumber 300		; Name is JenLee
NOT ObjectPresent		; No object, or not present
PrintMessage 112		; She pummels unsuccessfully
DoneWithTurn
END_COMMAND
;
; Commands to Jeff the genii
;
COMMAND JEFF, ANY
NameIsNumber 301		; Name is Jeff
AtLocationLT 28			; Not yet to North bank
 OR
AtLocationGT 34			; Past South Bank
PrintMessage 62			; Sorry, powerless unless in open air
DoneWithTurn
END_COMMAND
;
; 	Jeff moves people from North to South Bank
; 
COMMAND JEFF, CARRY
NameIsNumber 301		; Name is Jeff
AtLocation 28			; At North Bank
Present 300			; Jen-Lee is present
SendToRoom 300 34		; Send her to South Bank
END_COMMAND
COMMAND JEFF, CARRY
NameIsNumber 301		; Name is Jeff
AtLocation 28			; At North Bank
GoToRoom 34			; Send Tark to South Bank
SendToRoom 301 34		; Send Jeff to South Bank
PrintMessage 63			; "Jeff carries you to south bank"
DoneWithTurn
END_COMMAND
;
; 	Jeff moves people from South to North Bank
; 
COMMAND JEFF, CARRY
NameIsNumber 301		; Name is Jeff
AtLocation 34			; At South Bank
Present 300			; Jen-Lee is present
SendToRoom 300 28		; Send her to North Bank
END_COMMAND
COMMAND JEFF, CARRY
NameIsNumber 301		; Name is Jeff
AtLocation 34			; At South Bank
GoToRoom 28			; Send Tark to North Bank
SendToRoom 301 28		; Send Jeff to North Bank
PrintMessage 64			; "Jeff carries you to north bank"
DoneWithTurn
END_COMMAND
;
; 	Jeff moves people out of Grue Valley to one of the banks
;	If we've gotten to this point, we are in the valley.
;
COMMAND JEFF, CARRY
NameIsNumber 301		; Name is Jeff
PrintMessage 65			; North or South Bank?
GetNumberInput 0 1		; Get the desired destination
END_COMMAND
COMMAND JEFF, CARRY
NameIsNumber 301		; Name is Jeff
NumberEquals 1			; South bank is desired
Present 300			; Jen-Lee is present
SendToRoom 300 34		; Send her to South Bank
END_COMMAND
COMMAND JEFF, CARRY
NameIsNumber 301		; Name is Jeff
NumberEquals 1			; South bank is desired
GoToRoom 34			; Send Tark to South Bank
SendToRoom 301 34		; Send Jeff to South Bank
PrintMessage 63			; "Jeff carries you to south bank"
DoneWithTurn
END_COMMAND
COMMAND JEFF, CARRY
NameIsNumber 301		; Name is Jeff
NumberEquals 0			; North bank is desired
Present 300			; Jen-Lee is present
SendToRoom 300 28		; Send her to North Bank
END_COMMAND
COMMAND JEFF, CARRY
NameIsNumber 301		; Name is Jeff
NumberEquals 0			; North bank is desired
GoToRoom 28			; Send Tark to North Bank
SendToRoom 301 28		; Send Jeff to North Bank
PrintMessage 64			; "Jeff carries you to south bank"
DoneWithTurn
END_COMMAND
COMMAND JEFF, ATTACK
NameIsNumber 301		; Name is Jeff
PrintMessage 165		; Sorry, can't fight on astral plane.
DoneWithTurn			
END_COMMAND
;
; Commands to the Cannibal
;
;	Handling the charmed cannibal
;
COMMAND GIVE GOLD TO CANNIBAL
ReDirectTo CANNIBAL, MAKE SCISSORS
END_COMMAND
COMMAND GIVE JEWELRY TO CANNIBAL
Present 307			; Normal cannibal
 OR
Present 308			; Charmed cannibal
PrintMessage 159		; Not interested in jewelry
DoneWithTurn
END_COMMAND
COMMAND CANNIBAL, MAKE SCISSORS
Present 308		; Charmed Cannibal
NOT AtLocation 13		; Not at Cannibal's hut
PrintMessage 80			; He'd like to give you scissors, but ...
DoneWithTurn
END_COMMAND
COMMAND CANNIBAL, MAKE SCISSORS
Present 308		; Charmed Cannibal
AtLocation 13			; At Cannibal's hut
FlagOn 5			; He's already given up the scissors
PrintMessage 81			; "I already gave you a scissors!"
DoneWithTurn
END_COMMAND
COMMAND CANNIBAL, MAKE SCISSORS
Present 308		; Charmed Cannibal
FlagOFF 5			; He hasn't yet given up the scissors
PrintMessage 79			; Charmed cannibal gives scissors
TurnFlagOn 5			; Note that we've given up the scissors
PutInCurrentRoom 218		; Put scissors in room.
DoneWithTurn
END_COMMAND
;
;	Handling the normal cannibal
;
COMMAND CANNIBAL, MAKE SCISSORS
Present 307		; Normal Cannibal
FlagOn 5			; He already sold you a scissors
PrintMessage 82			; Sorry, no more scissorss to sell
DoneWithTurn
END_COMMAND
COMMAND CANNIBAL, MAKE SCISSORS
Present 307		; Normal Cannibal
FlagOff 5			; He has a scissors available
NOT IsCarrying 239		; Tark is not carrying gold
PrintMessage 83			; I only sell scissorss
DoneWithTurn
END_COMMAND
COMMAND CANNIBAL, MAKE SCISSORS
Present 307		; Normal Cannibal
FlagOff 5			; He has a scissors available
IsCarrying 239			; Tark is carrying gold
PrintMessage 84			; He takes gold and gives scissors
Destroy 239			; Destroy Gold
TurnFlagOn 5			; Note that we sold scissors
PutInCurrentRoom 218		; Put Bone scissors in current room
DoneWithTurn
END_COMMAND
;
; Commands to the earth elemental
;
COMMAND ELEMENTAL, CARRY
Present 300			; Jen-Lee is present
NameIsNumber 309		; Normal elemental
 OR 
NameIsNumber 310		; Charmed elemental
SendToRoom 300 2		; Send her to start room, has died.
END_COMMAND
COMMAND ELEMENTAL, CARRY
NameIsNumber 309		; Normal elemental
 OR 
NameIsNumber 310		; Charmed elemental
PrintMessage 127		; He drags you into dirt
KillPlayer 			; You die
DoneWithTurn 
END_COMMAND
COMMAND ELEMENTAL, ATTACK
Present 300			; Jen-Lee is present
NameIsNumber 309		; Normal elemental
 OR 
NameIsNumber 310		; Charmed elemental
PrintMessage 128		; JenLee stoned
END_COMMAND
COMMAND ELEMENTAL, ATTACK
NameIsNumber 309		; Normal elemental
 OR 
NameIsNumber 310		; Charmed elemental
PrintMessage 129		; Tark Stoned
END_COMMAND
COMMAND ELEMENTAL, ATTACK
Present 300			; Jen-Lee is present
NameIsNumber 309		; Normal elemental
 OR 
NameIsNumber 310		; Charmed elemental
PrintMessage 130		; JenLee discovered by Demon, and enslaved.
Destroy 300			; Kill good JenLee
SendToRoom 319 35		; Put Evil JenLee in Demon's chamber
END_COMMAND
COMMAND ELEMENTAL, ATTACK
NameIsNumber 309		; Normal elemental
 OR 
NameIsNumber 310		; Charmed elemental
PrintMessage 131		; Tark restored by Demon
KillPlayer			; Killed
DoneWithTurn
END_COMMAND
COMMAND ELEMENTAL, ANY
NameIsNumber 309		; Normal elemental
 OR 
NameIsNumber 310		; Charmed elemental
PrintMessage 132		; He gapes stupidly
DoneWithTurn
END_COMMAND


;
; Spell casting and related meta-commands
;
;	Healing
;
COMMAND CONJURE HEAL 
NOT IsCarrying 221		; Tark doesn't have the heal manacord
PrintMessage 28			; Sorry, can't conjure without manacord
DoneWithTurn
END_COMMAND
COMMAND CONJURE HEAL 
VariableLT 6 6			; Not enough spell points
PrintMessage 29			; Sorry, inadequate spell points
DoneWithTurn
END_COMMAND
COMMAND CONJURE HEAL AT SELF
SubtractFromVariable 6 6	; Spell goes off on Tark
AddToVariable 1 10		; Tark is cured
PrintMessage 32			; Self-healing message
DoneWithTurn
END_COMMAND
COMMAND CONJURE HEAL 
NOT ObjectPresent 		; Object is not present
PrintMessage 36			; Object must be present; spell not cast.
DoneWithTurn
END_COMMAND
COMMAND CONJURE HEAL 
ObjectPresent 			; Object is present
NOT ObjectIsCreature		; Object is not a creature
PrintMessage 35			; Spell only affects living creatures
SubtractFromVariable 6 6	; Spell goes off anyway, wasted points
DoneWithTurn
END_COMMAND
COMMAND CONJURE HEAL 
ObjectPresent			; Object is here
ObjectIsNumber 300		; Jen-Lee is the object
SubtractFromVariable 6 6	; Spell goes off
AddToVariable 3 10		; Jenlee is cured
PrintMessage 30			; Print healing message
DoneWithTurn
END_COMMAND
COMMAND CONJURE HEAL 
ObjectPresent 			; Object is present
ObjectIsCreature		; Object is creature, not treated above
PrintMessage 31			; Sorry, your spell doesn't effect it
DoneWithTurn
END_COMMAND
;
;	Wounding
;
COMMAND CONJURE WOUND
NOT IsCarrying 221		; Tark doesn't have the heal manacord
PrintMessage 28			; Sorry, have to have right manacord
DoneWithTurn
END_COMMAND
COMMAND CONJURE WOUND
VariableLT 6 6			; Not enough spell points
PrintMessage 29			; Sorry, inadequate spell points
DoneWithTurn
END_COMMAND
COMMAND CONJURE WOUND AT SELF
SubtractFromVariable 6 6	; Spell goes off on Tark
SubtractFromVariable 1 10	; Tark is wounded
SubtractFromVariable 2 10	; Tark's moral status is decremented
PrintMessage 34			; Self-wounding message
DoneWithTurn
END_COMMAND
COMMAND CONJURE WOUND
NOT ObjectPresent 		; Object is not present
PrintMessage 36			; Object must be present; spell not cast.
DoneWithTurn
END_COMMAND
COMMAND CONJURE WOUND
ObjectPresent 			; Object is present
NOT ObjectIsCreature		; Object is not a creature
PrintMessage 35			; Spell only affects living creatures
SubtractFromVariable 6 6	; Spell goes off anyway, wasted points
DoneWithTurn
END_COMMAND
COMMAND CONJURE WOUND
ObjectPresent			; Object is here
ObjectIsNumber 300		; Jen-Lee is the object
SubtractFromVariable 6 6	; Spell goes off
SubtractFromVariable 3 10	; Jenlee is wounded
SubtractFromVariable 2 10	; Tark's moral status is decremented
PrintMessage 33			; Print wounding message
DoneWithTurn
END_COMMAND
COMMAND CONJURE WOUND
ObjectPresent			; Object is here
ObjectIsNumber 302		; Normal Grue is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 302 205		; Grue is killed
SubtractFromVariable 2 10	; Tark's moral status is decremented
PrintMessage 103		; The Grue attacks you as well
SubtractFromVariable 1 12	; Does damage to Tark
PrintMessage 102		; The $OBJECT$ is killed by your spell
DoneWithTurn
END_COMMAND
COMMAND CONJURE WOUND
ObjectPresent			; Object is here
ObjectIsNumber 303		; Charmed Grue is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 303 205		; Charmed Grue is killed
SubtractFromVariable 2 10	; Tark's moral status is decremented
PrintMessage 104		; The $OBJECT$ stands unresisting
PrintMessage 102		; The $OBJECT$ is killed by your spell
DoneWithTurn
END_COMMAND
COMMAND CONJURE WOUND
ObjectPresent			; Object is here
ObjectIsNumber 307		; Cannibal is the object
 OR
ObjectIsNumber 308		; Charmed Cannibal is the object
SubtractFromVariable 6 6	; Spell goes off
Destroy 307
Destroy 308
SubtractFromVariable 2 10	; Tark's moral status is decremented
PrintMessage 104		; The $OBJECT$ stands unresisting
PrintMessage 102		; The $OBJECT$ is killed by your spell
DoneWithTurn
END_COMMAND
COMMAND CONJURE WOUND
ObjectPresent	 		; Object is present
ObjectIsCreature		; Object is creature, not handled above
PrintMessage 31			; Sorry, your spell seems ineffective
DoneWithTurn
END_COMMAND
;
;	Turning on the light
;
COMMAND CONJURE LIGHT
NOT IsCarrying 225		; Tark doesn't have the light manacord
PrintMessage 28			; Sorry, have to have right manacord
DoneWithTurn
END_COMMAND
COMMAND CONJURE LIGHT
VariableLT 6 5			; Not enough spell points
PrintMessage 29			; Sorry, inadequate spell points
DoneWithTurn
END_COMMAND
COMMAND CONJURE LIGHT
Present 220			; Magic Lantern is already present
PrintMessage 41			; You can only have one light at a time.
DoneWithTurn
END_COMMAND
COMMAND CONJURE LIGHT
SubtractFromVariable 6 5	; Spell goes off
TurnCounterOn 1			; Turn on its duration counter
PutInCurrentRoom 220		; Magic lantern put in room
PrintMessage 42			; Print wounding message
DoneWithTurn
END_COMMAND
;
;	Blessing
;
COMMAND CONJURE BLESS
NOT IsCarrying 222		; Tark doesn't have the bless manacord
PrintMessage 28			; Sorry, can't conjure without manacord
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS
VariableLT 6 7			; Not enough spell points
PrintMessage 29			; Sorry, inadequate spell points
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS
NOT InRoom 215			; Cleaned up altar is not present
PrintMessage 44			; Sorry, can't bless without altar
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS AT SELF
SubtractFromVariable 6 7	; No Object, spell goes off on Tark
AddToVariable 2 25		; Tark is blessed
PrintMessage 49			; Self-blessing message
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS
NOT ObjectPresent 		; Object is not present
PrintMessage 36			; Object must be present; spell not cast.
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS
ObjectPresent			; Object is here
ObjectIsNumber 300		; Jen-Lee is the object
SubtractFromVariable 6 7	; Spell goes off
AddToVariable 4 25		; Jenlee is spirtually enhanced
PrintMessage 45			; Print blessing message
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS
ObjectPresent			; Object is here
ObjectIsNumber 317		; Neanderthal is the object
SubtractFromVariable 6 7	; Spell goes off
AddToVariable 5 26		; Neanderthal is spirtually enhanced
PrintMessage 46			; Print blessing message
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS
ObjectPresent			; Object is here
ObjectIsNumber 208		; Cross is the object
SubtractFromVariable 6 7	; Spell goes off
SwapLocations 208 209		; Swap mundane cross for blessed one
PrintMessage 47			; Cross becomes blessed
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS
ObjectPresent			; Object is here
ObjectIsNumber 206		; Sword is the object
SubtractFromVariable 6 7	; Spell goes off
SwapLocations 206 207		; Swap mundane sword for blessed one
PrintMessage 48			; Sword becomes blessed
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS
ObjectPresent			; Object is here
ObjectIsNumber 213		; Water is the object
SubtractFromVariable 6 7	; Spell goes off
SwapLocations 213 238		; Swap mundane water for holy water
PrintMessage 58			; Water becomes holy
DoneWithTurn
END_COMMAND
COMMAND CONJURE BLESS
ObjectPresent 			; Object is present
PrintMessage 31			; Sorry, your spell doesn't effect it
DoneWithTurn
END_COMMAND
;
;	Charming
;
COMMAND CONJURE CHARM
NOT IsCarrying 223		; Tark doesn't have the charm manacord
PrintMessage 28			; Sorry, have to have right manacord
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
VariableLT 6 6			; Not enough spell points
PrintMessage 29			; Sorry, inadequate spell points
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
NOT ObjectPresent 		; Object is not present
PrintMessage 36			; Object must be present; spell not cast.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent 			; Object is present
NOT ObjectIsCreature		; Object is not a creature
PrintMessage 50			; Spell only affects sentient creatures
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent			; Object is here
ObjectIsNumber 300		; Jen-Lee is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 300 320		; Replace with charmed version
SubtractFromVariable 2 20	; Tark's moral status is decremented
PrintMessage 51			; Print "creature is charmed" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent			; Object is here
ObjectIsNumber 319		; Evil Jen-Lee is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 319 320		; Replace with charmed version
SubtractFromVariable 2 20	; Tark's moral status is decremented
PrintMessage 51			; Print "creature is charmed" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent			; Object is here
ObjectIsNumber 302		; The Grue is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 302 303		; Replace with charmed version
SubtractFromVariable 2 20	; Tark's moral status is decremented
PrintMessage 51			; Print "creature is charmed" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent			; Object is here
ObjectIsNumber 304		; Captive vampire is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 304 306		; Replace with charmed version
SubtractFromVariable 2 20	; Tark's moral status is decremented
PrintMessage 51			; Print "creature is charmed" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent			; Object is here
ObjectIsNumber 305		; Freed vampire is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 305 306		; Replace with charmed version
SubtractFromVariable 2 20	; Tark's moral status is decremented
PrintMessage 51			; Print "creature is charmed" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent			; Object is here
ObjectIsNumber 307		; Cannibal is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 307 308		; Replace with charmed version
SubtractFromVariable 2 20	; Tark's moral status is decremented
PrintMessage 51			; Print "creature is charmed" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent			; Object is here
ObjectIsNumber 309		; Earth elemental is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 309 310		; Replace with charmed version
SubtractFromVariable 2 20	; Tark's moral status is decremented
PrintMessage 51			; Print "creature is charmed" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent			; Object is here
ObjectIsNumber 313		; Ghost is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 313 314		; Replace with charmed version
SubtractFromVariable 2 20	; Tark's moral status is decremented
PrintMessage 51			; Print "creature is charmed" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent			; Object is here
ObjectIsNumber 315		; Derro is the object
SubtractFromVariable 6 6	; Spell goes off
SwapLocations 315 316		; Replace with charmed version
SubtractFromVariable 2 20	; Tark's moral status is decremented
PrintMessage 51			; Print "creature is charmed" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE CHARM
ObjectPresent	 		; Object is present
ObjectIsCreature		; Object is creature, not handled above
PrintMessage 31			; Sorry, your spell seems ineffective
DoneWithTurn
END_COMMAND
;
;	Summoning
;
COMMAND CONJURE SUMMON
NOT IsCarrying 224		; Tark doesn't have the summon manacord
PrintMessage 28			; Sorry, have to have right manacord
DoneWithTurn
END_COMMAND
COMMAND CONJURE SUMMON
VariableLT 6 20			; Not enough spell points
PrintMessage 29			; Sorry, inadequate spell points
DoneWithTurn
END_COMMAND
COMMAND CONJURE SUMMON
NOT ObjectIsCreature		; Object is not a creature
PrintMessage 50			; Spell only affects sentient creatures
DoneWithTurn
END_COMMAND
COMMAND CONJURE SUMMON
ObjectPresent			; Object is already present
PrintMessage 55			; Can't summon those who are already here.
DoneWithTurn
END_COMMAND
COMMAND CONJURE SUMMON
ObjectIsNumber 309		; Loam is the object
SubtractFromVariable 6 20	; Spell goes off
PutInCurrentRoom 309		; Loam is placed in current room
TurnCounterOn 3			; Turn on his counter
PrintMessage 56			; Print "Loam is summoned" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE SUMMON
ObjectIsNumber 301		; Jeff is the object
SubtractFromVariable 6 20	; Spell goes off
PutInCurrentRoom 301		; Jeff is placed in current room
TurnCounterOn 2			; Turn on his counter
PrintMessage 59			; Print "Jeff is summoned" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE SUMMON
ObjectIsNumber 317		; Neanderthal is the object
FlagOff 6			; Name hasn't been learned.
PrintMessage 166		; Sorry, must know his name
DoneWithTurn
END_COMMAND
COMMAND CONJURE SUMMON
ObjectIsNumber 317		; Neanderthal is the object
SubtractFromVariable 6 20	; Spell goes off
AskQuestion 1			; Ask for Demon's name
TurnFlagOn 255			; Temporary flag to test correctness
AnswerIsCorrect			; Was the answer correct?
TurnFlagOff 255			; Yes, if we got to this point.
PutInCurrentRoom 317		; Neanderthal is placed in current room
TurnCounterOn 4			; Turn on his counter
PrintMessage 60			; Print "Neanderthal is summoned" message.
DoneWithTurn
END_COMMAND
COMMAND CONJURE SUMMON
FlagOn 255			; Not turned off, so answer was wrong
TurnFlagOff 255			; Turn it off now
PrintMessage 61			; Name was wrong, spell points wasted.
DoneWithTurn
END_COMMAND
COMMAND CONJURE SUMMON
ObjectIsCreature		; Object is creature, not handled above
PrintMessage 57			; Sorry, the summoning seems ineffective
DoneWithTurn
END_COMMAND

;
; A variety of miscellaneous commands
;
; 	Miscellaneous: Waking JenLee
;
COMMAND WAKE JENLEE
InRoom 202			; The sleeping JenLee is present
SwapLocations 202 300		; Swap with waking JenLee
PutInCurrentRoom 206		; Put her sword in this room
PrintMessage 21			; JenLee is awakened
DoneWithTurn
END_COMMAND
COMMAND WAKE JENLEE
InRoom 300			; Jen-Lee already awake
PrintMessage 22			; JenLee is already awake.
DoneWithTurn
END_COMMAND
;
; 	Miscellaneous: Awaying undead
;
COMMAND AWAY
NOT IsCarrying 209		; Tark doesn't have the blessed cross
PrintMessage 37			; Sorry, can't away without powerful cross
DoneWithTurn
END_COMMAND
COMMAND AWAY
NOT NOUNInRoom	 		; Noun is not present
PrintMessage 38			; Noun must be present; Jen-Lee is puzzled.
DoneWithTurn
END_COMMAND
COMMAND AWAY
NOUNInRoom 			; Noun is present
NOT NOUNIsNumber 304		; Not captive vampire
NOT NOUNIsNumber 305		; Not freed vampire
NOT NOUNIsNumber 306		; Not charmed vampire
NOT NOUNIsNumber 313		; Not ghost
NOT NOUNIsNumber 314		; Not charmed ghost
PrintMessage 39			; Aways only affect undead
DoneWithTurn
END_COMMAND
COMMAND AWAY
NOUNInRoom			; Noun is here, so is one of undead
DestroyNOUN			; Destroy the undead
PrintMessage 40			; Undead is destroyed
END_COMMAND
COMMAND AWAY
NOUNIsNumber 304		; Undead is captive vampire
 OR
NOUNIsNumber 305		; Or freed vampire
 OR
NOUNIsNumber 306		; Or charmed vampire
PrintMessage 100		; Vampire crumples, leaving only the shoes
PutInCurrentRoom 232		; Put shoes in room
END_COMMAND
COMMAND AWAY
DoneWithTurn			; Finally, close up.
END_COMMAND
;
; 	Miscellaneous: The status command and its manipulations
;
COMMAND status
PrintMessage 1			; Hits and spell points
VariableLT 2 26
PrintMessage 2			; vicious and mean
END_COMMAND
COMMAND status
VariableLT 2 51
VariableGT 2 25
PrintMessage 3			; surly and nasty
END_COMMAND
COMMAND status
VariableLT 2 76			
VariableGT 2 50
PrintMessage 4			; oddly confused and distracted
END_COMMAND
COMMAND status
VariableLT 2 101
VariableGT 2 75
PrintMessage 5			; spiritual and pure
END_COMMAND
COMMAND status
Not Present 300			; If the waking Jen-Lee is not present ...
DoneWithTurn			; we are done with the status command.
END_COMMAND
COMMAND status
PrintMessage 6			; JenLee's hits
END_COMMAND
COMMAND status
VariableLT 4 26
PrintMessage 7			; vicious and mean
END_COMMAND
COMMAND status
VariableLT 4 51
VariableGT 4 25
PrintMessage 8			; surly and nasty
END_COMMAND
COMMAND status
VariableLT 4 76
VariableGT 4 50
PrintMessage 9			; oddly confused and distracted
END_COMMAND
COMMAND status
VariableLT 4 101
VariableGT 4 75
PrintMessage 10			; spiritual and pure
END_COMMAND
COMMAND status
SomethingInside 300		; If JenLee is carrying something
PrintMessage 20			; She is carrying:
ShowContents 300		; Show her load
END_COMMAND
COMMAND status
DoneWithTurn			; Quit, after one of the above conditions
END_COMMAND
;
;	Miscellaneous: Doing things with baby
;
;		JenLee kills the baby
;
COMMAND JENLEE, KILL BABY
NameIsNumber 300		; Name is JenLee
NOT Present 235			; Baby not present
PrintMessage 76			; Baby not present, lucky it. 
DoneWithTurn
END_COMMAND
COMMAND JENLEE, KILL BABY
NameIsNumber 300			; Name is JenLee
Present 235				; Baby is present
SubtractFromVariable 2 10		; Tark loses some spirituality
SubtractFromVariable 4 25		; JenLee loses major spirituality
PrintMessage 77				; JenLee is confused and upset
ReDirectTo FOO BABY WITH $OBJECT$ 	; Let generic handling take over
END_COMMAND
;
;		Tark kills the baby
;
COMMAND KILL BABY
NOT Present 235			; Baby not present
PrintMessage 76			; Baby not present, lucky it. 
DoneWithTurn
END_COMMAND
COMMAND KILL BABY
Present 235			; Baby present
SubtractFromVariable 2 25	; Tark loses major spirituality points
ObjectIsNumber 206		; Tark is using sword 
 OR
ObjectIsNumber 207		; Tark is using blessed sword
 OR
ObjectIsNumber 216		; Tark is using sacrificial dagger
SubtractFromVariable 2 5	; Tark loses points for edged weapons
END_COMMAND
COMMAND KILL BABY
ReDirectTo FOO BABY WITH $OBJECT$
END_COMMAND
;
;		Someone kills the baby
;
COMMAND FOO BABY
ObjectIsNumber 206		; Normal sword
PrintMessage 69			; Baby is skewered and useless
Destroy 235			; Kill the baby
DoneWithTurn
END_COMMAND
COMMAND FOO BABY
ObjectIsNumber 207		; Blessed sword
PrintMessage 69			; Baby is skewered and useless
Destroy 235			; Kill the baby
PrintMessage 71			; Blessed sword is destroyed as well
Destroy 207			; Destroy the sword
DoneWithTurn
END_COMMAND
COMMAND FOO BABY
ObjectIsNumber 216		; Sacrifical dagger
PrintMessage 70			; Skin and blood gone, leaves bones
SwapLocations 235 236		; Put baby bones in current room
DoneWithTurn
END_COMMAND
COMMAND FOO BABY
PrintMessage 72			; Baby blundgeoned to death
Destroy 235			; Kill the baby
DoneWithTurn
END_COMMAND
;
;		Making the bone scissors
;
COMMAND MAKE SCISSORS
NOT AtLocation 17	; Not in work room
PrintMessage 73 	; Need tools to make scissorss
DoneWithTurn
END_COMMAND
COMMAND MAKE SCISSORS
AtLocation 17		; In work room
NOT Present 236		; Baby skeleton not here
PrintMessage 74 	; Make scissors out of what?
DoneWithTurn
END_COMMAND
COMMAND MAKE SCISSORS
AtLocation 17		; In work room
Present 236		; Baby skeleton here
Destroy 236		; Get rid of skeleton
PutInCurrentRoom 218	; Put Bone Scissors in room
PrintMessage 75		; You made the bone scissors
DoneWithTurn
END_COMMAND
;
;	Miscellaneous: Making blood
;
;
;		JenLee cuts Tark
;
COMMAND JENLEE, CUT ME
NameIsNumber 300		; Name is JenLee
ObjectIsNumber 206		; Sword
 OR
ObjectIsNumber 207		; Blessed sword
PrintMessage 85			; JenLee cuts you
SubtractFromVariable 1 2	; Tark takes minor damage
END_COMMAND
COMMAND JENLEE, CUT ME
NameIsNumber 300		; Name is JenLee
ObjectIsNumber 216		; Sacrifical dagger
PrintMessage 86			; JenLee cuts you deeply
SubtractFromVariable 1 8	; Tark takes significant damage
END_COMMAND
COMMAND JENLEE, CUT ME
NameIsNumber 300		; Name is JenLee
NOT ObjectPresent		; No object, or not present
PrintMessage 87			; What should I you with?
DoneWithTurn
END_COMMAND
COMMAND JENLEE, CUT ME
ReDirectTo MAKE BLOOD WITH $OBJECT$	; Now make the blood, if appropriate
DoneWithTurn
END_COMMAND
;
;		JenLee cuts herself
;
COMMAND JENLEE, CUT JENLEE
NameIsNumber 300		; Name is JenLee
ObjectIsNumber 206		; Sword
 OR
ObjectIsNumber 207		; Blessed sword
PrintMessage 88			; JenLee cuts herself
SubtractFromVariable 3 2	; Tark takes minor damage
END_COMMAND
COMMAND JENLEE, CUT JENLEE
NameIsNumber 300		; Name is JenLee
ObjectIsNumber 216		; Sacrifical dagger
PrintMessage 86			; JenLee cuts herself deeply
SubtractFromVariable 3 8	; Tark takes significant damage
END_COMMAND
COMMAND JENLEE, CUT JENLEE
NameIsNumber 300		; Name is JenLee
NOT ObjectPresent		; No object, or not present
PrintMessage 87			; What should I cut with?
DoneWithTurn
END_COMMAND
COMMAND JENLEE, CUT JENLEE
ReDirectTo MAKE BLOOD WITH $OBJECT$	; Now make the blood, if appropriate
DoneWithTurn
END_COMMAND
;		Tark cuts herself
;
COMMAND CUT ME
ObjectIsNumber 206		; Sword
 OR
ObjectIsNumber 207		; Blessed sword
PrintMessage 90			; Tark cuts herself with sword
SubtractFromVariable 1 3	; Tark takes minor damage
SubtractFromVariable 2 5	; Tark takes some spiritual damage
END_COMMAND
COMMAND CUT ME
ObjectIsNumber 216		; Sacrifical dagger
PrintMessage 86			; Tark cuts herself deeply
SubtractFromVariable 1 8	; Tark takes significant damage
SubtractFromVariable 2 5	; Tark takes some spiritual damage
END_COMMAND
COMMAND CUT ME
NOT ObjectPresent		; No object, or not present
PrintMessage 92			; What should I cut you with?
DoneWithTurn
END_COMMAND
COMMAND CUT ME
ReDirectTo MAKE BLOOD WITH $OBJECT$	; Now make the blood, if appropriate
DoneWithTurn
END_COMMAND
;
;		Tark cuts JenLee
;
COMMAND CUT JENLEE
ObjectIsNumber 206		; Sword
 OR
ObjectIsNumber 207		; Blessed sword
PrintMessage 93			; Tark cuts Jenlee with sword
SubtractFromVariable 3 3	; JenLee takes minor damage
SubtractFromVariable 2 5	; Tark takes some spiritual damage
END_COMMAND
COMMAND CUT JENLEE
ObjectIsNumber 216		; Sacrifical dagger
PrintMessage 94			; Tark cuts JenLee deeply
SubtractFromVariable 3 8	; JenLee takes significant damage
SubtractFromVariable 2 5	; Tark takes some spiritual damage
END_COMMAND
COMMAND CUT JENLEE
NOT ObjectPresent		; No object, or not present
PrintMessage 92			; What should I cut you with?
DoneWithTurn
END_COMMAND
COMMAND CUT JENLEE
ReDirectTo MAKE BLOOD WITH $OBJECT$	; Now make the blood, if appropriate
DoneWithTurn
END_COMMAND
;
;		Finally, make the blood
;
COMMAND MAKE BLOOD
IsSomeWhere 212			; The Pool of Blood already exists
PrintMessage 95			; No more blood forms
DoneWithTurn
END_COMMAND
COMMAND MAKE BLOOD
IsNowhere 212			; Pool of Blood Doesn't yet exist
Destroy 242			; Destroy the dried blood, if it exists
PutInCurrentRoom 212		; Put Pool of blood in current room
TurnCounterOn 5			; Turn on the "out of vial" counter
PrintMessage 96			; "A pool of blood forms"
DoneWithTurn
END_COMMAND
;
;	Miscellaneous: the jewels
;
COMMAND READ JEWELRY
Present 233			; If they are actually present
TurnFlagOn 6			; Record Neanderthal's name as known
END_COMMAND
;
;	Miscellaneous: the demon protection pentagram
;
COMMAND READ TEXTBOOK
NOUNPresent 			; If book is actually present
NOUNIsNumber 228		; And it is the demon book 
TurnFlagOn 7			; Tark knows how to pentagram; drop through
END_COMMAND
COMMAND MAKE PENTAGRAM
FlagOff 7			; Tark doesn't know how
PrintMessage 115		; You don't know how
DoneWithTurn
END_COMMAND
COMMAND MAKE PENTAGRAM
NOT Present 240			; Dried ichor not present
PrintMessage 116		; You don't have materials
DoneWithTurn
END_COMMAND
COMMAND MAKE PENTAGRAM
Destroy 240			; Ichor can be used only once
PutInCurrentRoom 243		; Put the pentagram in current room
PrintMessage 117		; You successfully make pentagram
DoneWithTurn
END_COMMAND
;
;	Miscellaneous: the charm book
;
COMMAND READ BOOK
NOUNPresent 			; If book is actually present
NOUNIsNumber 229		; And it is the charm book 
OpenNOUN			; Make sure it is open
SubtractFromVariable 2 20	; Tark takes spiritual damage
END_COMMAND
;
;	Miscellaneous: cleaning up the altar
;
COMMAND CLEAN
NOT NOUNPresent			; NOUN Present
PrintMessage 119		; Can't verb it unless it is present
DoneWithTurn
END_COMMAND
COMMAND CLEAN
NOT Present 213			; No water present
PrintMessage 120		; Generally helps to have water
DoneWithTurn
END_COMMAND
COMMAND CLEAN ALTAR
NOUNIsNumber 215		; Altar already restored
PrintMessage 121		; Altar is already clean
DoneWithTurn
END_COMMAND
COMMAND CLEAN ALTAR
NOUNIsNumber 214		; Defaced altar is target
NOT Present 241			; Not carrying scrub brush
PrintMessage 122		; Thick dirt, need scrubber
DoneWithTurn
END_COMMAND
COMMAND CLEAN ALTAR
NOUNIsNumber 214		; Defaced altar is target
Present 241			; Not carrying scrub brush
PrintMessage 123		; You clean
SwapLocations 214 215		; Put restored altar here
SendToRoom 213 7		; Use up the water, send to bathroom
DoneWithTurn
END_COMMAND
COMMAND CLEAN
PrintMessage 124		; Something is cleaned, uses up water
SendToRoom 213 7		; Use up the water, send to bathroom
DoneWithTurn
END_COMMAND
;
;	Miscellaneous: Tark attacks in hand-to-hand
;
COMMAND ATTACK ANY
NOT NOUNPresent			; The NOUN is not present
PrintMessage 125		; No NOUN present to attack
DoneWithTurn
END_COMMAND
COMMAND ATTACK ANY
NOUNPresent 			; The NOUN is Present
NOUNIsNumber 302		; The target is the grue
PrintMessage 103		; It fights back
SubtractFromVariable 1 12	; It does damage
END_COMMAND
COMMAND ATTACK ANY
ObjectPresent			; Object is present
ObjectIsNumber 206		; Sword
 OR
ObjectIsNumber 207		; Blessed sword
 OR
ObjectIsNumber 216		; Sacrificial dagger
SubtractFromVariable 2 5	; Tark takes some spiritual damage
PrintMessage 105		; You bumble around unsuccessfully
DoneWithTurn
END_COMMAND
COMMAND ATTACK ANY
NOT ObjectPresent		; No object, or not present
PrintMessage 106		; You pummel unsuccessfully
DoneWithTurn
END_COMMAND
;
;	Miscellaneous: Vampire handling
;
COMMAND FREE PRISONER
InRoom 305			; Freed prisoner
 OR
InRoom 306			; Charmed prisoner
PrintMessage 136		; Prisoner has already been freed
DoneWithTurn
END_COMMAND
COMMAND FREE PRISONER
InRoom 304			; Captive prisoner
SwapLocations 304 305		; Free Prisoner
PrintMessage 137		; Free Prisoner
TurnCounterOn 6			; Turn on vampire counter
DoneWithTurn
END_COMMAND
COMMAND LOCK PRISONER
InRoom 304			; Captive prisoner
PrintMessage 138		; Free Prisoner
DoneWithTurn
END_COMMAND
COMMAND LOCK PRISONER
InRoom 305			; Freed prisoner
PrintMessage 139		; Freed Prisoner resists.
DoneWithTurn
END_COMMAND
COMMAND LOCK PRISONER
InRoom 306			; Charmed prisoner
PrintMessage 140		; Locked and de-charmed
SwapLocations 306 304		; Put capitive prisoner in place
DoneWithTurn
END_COMMAND
COMMAND KISS PRISONER
InRoom 304			; Captive prisoner
PrintMessage 141		; He asks to be freed first
DoneWithTurn
END_COMMAND
COMMAND KISS PRISONER
InRoom 305			; Freed prisoner
PrintMessage 142		; He kills her with kiss
KillPlayer			; Tark Dies
DoneWithTurn
END_COMMAND
COMMAND KISS PRISONER
InRoom 306			; Charmed prisoner
PrintMessage 143		; He kisses enthusiastically
SubtractFromVariable 2 5	; Tark loses spirituality
DoneWithTurn
END_COMMAND
COMMAND PRISONER, GIVE
InRoom 304			; Captive prisoner
PrintMessage 144		; If you release me
DoneWithTurn
END_COMMAND
COMMAND PRISONER, GIVE
InRoom 305			; Freed prisoner
PrintMessage 145		; If you kiss me
DoneWithTurn
END_COMMAND
COMMAND PRISONER, GIVE
InRoom 306			; Charmed prisoner
PrintMessage 146		; He drops gems and gold
PutInCurrentRoom 233		; Put jewels in room
PutInCurrentRoom 239		; Put gold in room
DoneWithTurn
END_COMMAND
;
;	Miscellaneous: Getting into the treasure room, a series of riddles.
;
COMMAND EAST
AtLocation 35			; In Neanderthal's chamber
PrintMessage 160		; Ask about Blooder
AskQuestion 2			; Prompt for response
TurnFlagOn 255			; Temporary Flag 
AnswerIsCorrect 		; Got it right
TurnFlagOff 255			; Mark that the answer is right
END_COMMAND
COMMAND EAST
AtLocation 35			; In Neanderthal's chamber
FlagOn 255			; Answer was wrong
TurnFlagOff 255			; Turn flag off
PrintMessage 163		; Answer wrong, Tark takes damage
SubtractFromVariable 1 15 	; Do some massive damage
DoneWithTurn
END_COMMAND
COMMAND EAST
AtLocation 35			; In Neanderthal's chamber
PrintMessage 161		; Ask about phelsion
AskQuestion 3			; Prompt for response
TurnFlagOn 255			; Temporary Flag 
AnswerIsCorrect 		; Got it right
TurnFlagOff 255			; Mark that the answer is right
END_COMMAND
COMMAND EAST
AtLocation 35			; In Neanderthal's chamber
FlagOn 255			; Answer was wrong
TurnFlagOff 255			; Turn flag off
PrintMessage 163		; Answer wrong, Tark takes damage
SubtractFromVariable 1 15 	; Do some massive damage
DoneWithTurn
END_COMMAND
COMMAND EAST
AtLocation 35			; In Neanderthal's chamber
PrintMessage 162		; Ask about Neanderthal
AskQuestion 4			; Prompt for response
TurnFlagOn 255			; Temporary Flag 
AnswerIsCorrect 		; Got it right
TurnFlagOff 255			; Mark that the answer is right
PrintMessage 164		; Door opens briefly, you hurry through.
GoToRoom 36			; Put Tark in Treasure room
DoneWithTurn
END_COMMAND
COMMAND EAST
AtLocation 35			; In Neanderthal's chamber
FlagOn 255			; Answer was wrong
TurnFlagOff 255			; Turn flag off
PrintMessage 163		; Answer wrong, Tark takes damage
SubtractFromVariable 1 15 	; Do some massive damage
DoneWithTurn
END_COMMAND


;
; Catch-all actor commands
;
COMMAND ANYBODY, ANY
PrintMessage 167		; MORE (Meta: Sorry, NAME can't do that.)
DoneWithTurn
END_COMMAND


