#if 0 //To compile, type: "nmake mdview.c"
mdview.exe: mdview.obj kplib.obj; link mdview kplib dinput.lib dxguid.lib comdlg32.lib opengl32.lib glu32.lib kernel32.lib user32.lib gdi32.lib /opt:nowin98 /nologo
	del mdview.obj
mdview.obj: mdview.c; cl /c /TP /Ox /Ob2 /G6Fy /MD /nologo mdview.c
kplib.obj:  kplib.c;  cl /c /TP /Ox /Ob2 /G6Fy /MD /nologo kplib.c
!if 0
#endif

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gl\gl.h>
#include <gl\glu.h>

#define PI 3.14159265358979323

extern void kzfindfilestart (const char *st);
extern long kzfindfile (char *filnam);
extern void kpzload (const char *filnam, long *pic, long *bpl, long *xsiz, long *ysiz);

HDC hDC = 0;
HWND ghwnd = 0;
HINSTANCE ghinst;
HGLRC hRC = 0; //Permanent RC

char keystatus[256];

typedef struct { float x, y, z; } point3d;
point3d ipos, istr, ihei, ifor;

long xdim = 0, ydim = 0, fullscreen = 0, numframes = 0, active = 1;
float a1 = 0, a2 = 0, a3 = 0, fov = 1; //fov divided by 90
long usetex = 1, useanim = 1;

	//Timing variables:
__int64 perfrq, ototalclock, totalclock;
double timscale, fsynctics;

//--------------------------------------------------------------------------------------------------

long gtexmalloc = 0;
long mdloadskin (unsigned *texid, long *usesalpha, const char *filename)
{
	long bpl, xsiz, ysiz, x, y;
	unsigned long *uptr;

	(*texid) = 0;
	kpzload(filename,&gtexmalloc,&bpl,&xsiz,&ysiz); if (!gtexmalloc) return(0);

	(*usesalpha) = 0;
	for(y=ysiz-1;y>=0;y--)
	{
		uptr = (unsigned long *)(bpl*y+gtexmalloc);
		for(x=xsiz-1;x>=0;x--) if (uptr[x] < (unsigned long)0xff000000) { (*usesalpha) = 1; break; }
		if (*usesalpha) break;
	}

	glGenTextures(1,texid);
	glBindTexture(GL_TEXTURE_2D,*texid);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
	gluBuild2DMipmaps(GL_TEXTURE_2D,GL_RGBA,xsiz,ysiz,GL_BGRA_EXT,GL_UNSIGNED_BYTE,(char *)gtexmalloc);
	return(*texid);
}

static point3d *vertlist = 0; //temp array for drawing

//-------------------------------------  MD2 LIBRARY BEGINS ----------------------------------------
	//This MD2 code is based on the source code from David Henry (tfc_duke(at)hotmail.com)
	//   http://tfc.duke.free.fr/us/tutorials/models/md2.htm
	//He probably wouldn't recognize it if he looked at it though :)

#if 0
	//precalculated normal vectors
#define NUMVERTEXNORMALS 162
point3d md2normlut[NUMVERTEXNORMALS] =
{
	{-.525731f, .000000f, .850651f},{-.442863f, .238856f, .864188f},{-.295242f, .000000f, .955423f},
	{-.309017f, .500000f, .809017f},{-.162460f, .262866f, .951056f},{ .000000f, .000000f,1.000000f},
	{ .000000f, .850651f, .525731f},{-.147621f, .716567f, .681718f},{ .147621f, .716567f, .681718f},
	{ .000000f, .525731f, .850651f},{ .309017f, .500000f, .809017f},{ .525731f, .000000f, .850651f},
	{ .295242f, .000000f, .955423f},{ .442863f, .238856f, .864188f},{ .162460f, .262866f, .951056f},
	{-.681718f, .147621f, .716567f},{-.809017f, .309017f, .500000f},{-.587785f, .425325f, .688191f},
	{-.850651f, .525731f, .000000f},{-.864188f, .442863f, .238856f},{-.716567f, .681718f, .147621f},
	{-.688191f, .587785f, .425325f},{-.500000f, .809017f, .309017f},{-.238856f, .864188f, .442863f},
	{-.425325f, .688191f, .587785f},{-.716567f, .681718f,-.147621f},{-.500000f, .809017f,-.309017f},
	{-.525731f, .850651f, .000000f},{ .000000f, .850651f,-.525731f},{-.238856f, .864188f,-.442863f},
	{ .000000f, .955423f,-.295242f},{-.262866f, .951056f,-.162460f},{ .000000f,1.000000f, .000000f},
	{ .000000f, .955423f, .295242f},{-.262866f, .951056f, .162460f},{ .238856f, .864188f, .442863f},
	{ .262866f, .951056f, .162460f},{ .500000f, .809017f, .309017f},{ .238856f, .864188f,-.442863f},
	{ .262866f, .951056f,-.162460f},{ .500000f, .809017f,-.309017f},{ .850651f, .525731f, .000000f},
	{ .716567f, .681718f, .147621f},{ .716567f, .681718f,-.147621f},{ .525731f, .850651f, .000000f},
	{ .425325f, .688191f, .587785f},{ .864188f, .442863f, .238856f},{ .688191f, .587785f, .425325f},
	{ .809017f, .309017f, .500000f},{ .681718f, .147621f, .716567f},{ .587785f, .425325f, .688191f},
	{ .955423f, .295242f, .000000f},{1.000000f, .000000f, .000000f},{ .951056f, .162460f, .262866f},
	{ .850651f,-.525731f, .000000f},{ .955423f,-.295242f, .000000f},{ .864188f,-.442863f, .238856f},
	{ .951056f,-.162460f, .262866f},{ .809017f,-.309017f, .500000f},{ .681718f,-.147621f, .716567f},
	{ .850651f, .000000f, .525731f},{ .864188f, .442863f,-.238856f},{ .809017f, .309017f,-.500000f},
	{ .951056f, .162460f,-.262866f},{ .525731f, .000000f,-.850651f},{ .681718f, .147621f,-.716567f},
	{ .681718f,-.147621f,-.716567f},{ .850651f, .000000f,-.525731f},{ .809017f,-.309017f,-.500000f},
	{ .864188f,-.442863f,-.238856f},{ .951056f,-.162460f,-.262866f},{ .147621f, .716567f,-.681718f},
	{ .309017f, .500000f,-.809017f},{ .425325f, .688191f,-.587785f},{ .442863f, .238856f,-.864188f},
	{ .587785f, .425325f,-.688191f},{ .688191f, .587785f,-.425325f},{-.147621f, .716567f,-.681718f},
	{-.309017f, .500000f,-.809017f},{ .000000f, .525731f,-.850651f},{-.525731f, .000000f,-.850651f},
	{-.442863f, .238856f,-.864188f},{-.295242f, .000000f,-.955423f},{-.162460f, .262866f,-.951056f},
	{ .000000f, .000000f,-1.00000f},{ .295242f, .000000f,-.955423f},{ .162460f, .262866f,-.951056f},
	{-.442863f,-.238856f,-.864188f},{-.309017f,-.500000f,-.809017f},{-.162460f,-.262866f,-.951056f},
	{ .000000f,-.850651f,-.525731f},{-.147621f,-.716567f,-.681718f},{ .147621f,-.716567f,-.681718f},
	{ .000000f,-.525731f,-.850651f},{ .309017f,-.500000f,-.809017f},{ .442863f,-.238856f,-.864188f},
	{ .162460f,-.262866f,-.951056f},{ .238856f,-.864188f,-.442863f},{ .500000f,-.809017f,-.309017f},
	{ .425325f,-.688191f,-.587785f},{ .716567f,-.681718f,-.147621f},{ .688191f,-.587785f,-.425325f},
	{ .587785f,-.425325f,-.688191f},{ .000000f,-.955423f,-.295242f},{ .000000f,-1.00000f, .000000f},
	{ .262866f,-.951056f,-.162460f},{ .000000f,-.850651f, .525731f},{ .000000f,-.955423f, .295242f},
	{ .238856f,-.864188f, .442863f},{ .262866f,-.951056f, .162460f},{ .500000f,-.809017f, .309017f},
	{ .716567f,-.681718f, .147621f},{ .525731f,-.850651f, .000000f},{-.238856f,-.864188f,-.442863f},
	{-.500000f,-.809017f,-.309017f},{-.262866f,-.951056f,-.162460f},{-.850651f,-.525731f, .000000f},
	{-.716567f,-.681718f,-.147621f},{-.716567f,-.681718f, .147621f},{-.525731f,-.850651f, .000000f},
	{-.500000f,-.809017f, .309017f},{-.238856f,-.864188f, .442863f},{-.262866f,-.951056f, .162460f},
	{-.864188f,-.442863f, .238856f},{-.809017f,-.309017f, .500000f},{-.688191f,-.587785f, .425325f},
	{-.681718f,-.147621f, .716567f},{-.442863f,-.238856f, .864188f},{-.587785f,-.425325f, .688191f},
	{-.309017f,-.500000f, .809017f},{-.147621f,-.716567f, .681718f},{-.425325f,-.688191f, .587785f},
	{-.162460f,-.262866f, .951056f},{ .442863f,-.238856f, .864188f},{ .162460f,-.262866f, .951056f},
	{ .309017f,-.500000f, .809017f},{ .147621f,-.716567f, .681718f},{ .000000f,-.525731f, .850651f},
	{ .425325f,-.688191f, .587785f},{ .587785f,-.425325f, .688191f},{ .688191f,-.587785f, .425325f},
	{-.955423f, .295242f, .000000f},{-.951056f, .162460f, .262866f},{-1.00000f, .000000f, .000000f},
	{-.850651f, .000000f, .525731f},{-.955423f,-.295242f, .000000f},{-.951056f,-.162460f, .262866f},
	{-.864188f, .442863f,-.238856f},{-.951056f, .162460f,-.262866f},{-.809017f, .309017f,-.500000f},
	{-.864188f,-.442863f,-.238856f},{-.951056f,-.162460f,-.262866f},{-.809017f,-.309017f,-.500000f},
	{-.681718f, .147621f,-.716567f},{-.681718f,-.147621f,-.716567f},{-.850651f, .000000f,-.525731f},
	{-.688191f, .587785f,-.425325f},{-.587785f, .425325f,-.688191f},{-.425325f, .688191f,-.587785f},
	{-.425325f,-.688191f,-.587785f},{-.587785f,-.425325f,-.688191f},{-.688191f,-.587785f,-.425325f}
};
#endif

typedef struct
{  long id, vers, skinxsiz, skinysiz, framebytes; //id:"IPD2", vers:8
	long numskins, numverts, numuv, numtris, numglcmds, numframes;
	long ofsskins, ofsuv, ofstris, ofsframes, ofsglcmds, ofseof; //ofsskins: skin names (64 bytes each)
} md2head_t;

typedef struct { unsigned char v[3], ni; } md2vert_t;
typedef struct
{  point3d mul, add; //scale&translation vector
	char name[16];    //frame name
	md2vert_t verts[1]; //first vertex of this frame
} md2frame_t;

typedef struct
{
	long mdnum; //MD2=2, MD3=3. NOTE: must be first in structure!
	long numframes, numverts, numglcmds, framebytes, *glcmds;
	long frame0, frame1, cframe, nframe, fpssc, usesalpha;
	float oldtime, curtime, interpol, scale;
	unsigned int texid;
	char *frames;
} md2model;

md2model *md2load (FILE *fil, const char *filnam)
{
	md2model *m;
	md2head_t head;
	char *buf, st[MAX_PATH+64];
	long i;

	m = (md2model *)malloc(sizeof(md2model)); if (!m) { fclose(fil); return(0); }
	memset(m,0,sizeof(md2model)); m->mdnum = 2;
	m->glcmds = 0; m->numframes = m->numverts = m->numglcmds = 0; m->texid = 0; m->scale = .01;

	fread((char *)&head,sizeof(md2head_t),1,fil);
	if ((head.id != 0x32504449) && (head.vers != 8)) { fclose(fil); free(m); return(0); } //"IDP2"

	m->numframes = head.numframes;
	m->numverts = head.numverts;
	m->numglcmds = head.numglcmds;
	m->framebytes = head.framebytes;
	m->frames = (char *)malloc(m->numframes*head.framebytes);
	m->glcmds = (long *)malloc(m->numglcmds*sizeof(long));
	fseek(fil,head.ofsframes,SEEK_SET); fread((char *)m->frames,m->numframes*head.framebytes,1,fil);
	fseek(fil,head.ofsglcmds,SEEK_SET); fread((char *)m->glcmds,m->numglcmds*sizeof(long),1,fil);

	m->frame0 = 0; m->frame1 = m->numframes;
	m->cframe = 0; m->nframe = m->cframe+1; if (m->nframe >= m->numframes) m->nframe = 0;
	m->fpssc = 8;

	strcpy(st,filnam);
	for(i=strlen(st)-1;i>0;i--)
		if ((st[i] == '/') || (st[i] == '\\')) { i++; break; }
	fseek(fil,head.ofsskins,SEEK_SET); fread(&st[i],64,1,fil);
	fclose(fil);
	if (!mdloadskin(&m->texid,&m->usesalpha,st)) //Load default texture
	{
		i = strlen(st)-4;
		if ((i >= 0) && (st[i] == '.') && (st[i+1] != '.') && (st[i+2] != '.') && (st[i+3] != '.'))
		{
			st[i+1] = 'p'; st[i+2] = 'n'; st[i+3] = 'g';
			mdloadskin(&m->texid,&m->usesalpha,st); //If PCX not found, try PNG of same name (seems to be DoomsDay engine hack)
		}
	}

	vertlist = (point3d *)malloc(m->numverts*sizeof(point3d));

	return(m);
}

void md2draw (md2model *m, float tim)
{
	point3d fp, m0, m1, a0, a1;
	md2frame_t *f0, *f1;
	unsigned char *c0, *c1;
	long i, *lptr;
	float f, g;

	if (tim > 0)
	{
		m->curtime = tim;

			//get cur&next frames
		m->interpol = (m->curtime-m->oldtime)*m->fpssc;
		if (m->interpol > 1.0)
		{
			m->oldtime = m->curtime; m->interpol = 0;

			m->cframe = m->nframe;
			m->nframe++; if (m->nframe >= m->frame1) m->nframe = m->frame0;
		}

			//current/next frame can't be > tot#frames
		if (m->cframe >= m->numframes) m->cframe = 0;
		if (m->nframe >= m->numframes) m->nframe = 0;
	}

		//create current&next frame's vertex list from whole list
	f0 = (md2frame_t *)&m->frames[m->cframe*m->framebytes];
	f1 = (md2frame_t *)&m->frames[m->nframe*m->framebytes];
	f = m->interpol; g = 1-f;
	m0.x = f0->mul.x*m->scale*g; m1.x = f1->mul.x*m->scale*f;
	m0.y = f0->mul.y*m->scale*g; m1.y = f1->mul.y*m->scale*f;
	m0.z = f0->mul.z*m->scale*g; m1.z = f1->mul.z*m->scale*f;
	a0.x = f0->add.x*m->scale; a0.x = (f1->add.x*m->scale-a0.x)*f+a0.x;
	a0.y = f0->add.y*m->scale; a0.y = (f1->add.y*m->scale-a0.y)*f+a0.y;
	a0.z = f0->add.z*m->scale; a0.z = (f1->add.z*m->scale-a0.z)*f+a0.z;
	c0 = &f0->verts[0].v[0]; c1 = &f1->verts[0].v[0];
	m0.x = -m0.x; m1.x = -m1.x; a0.x = -a0.x;

	f = 1*32.0;
	m0.x *= f; m0.y *= f; m0.z *= f;
	m1.x *= f; m1.y *= f; m1.z *= f;
	a0.x *= f; a0.y *= f; a0.z *= f;

	for(i=m->numverts-1;i>=0;i--) //interpolate&scale vertices to avoid ugly animation
	{
		vertlist[i].z = c0[(i<<2)+0]*m0.x + c1[(i<<2)+0]*m1.x + a0.x;
		vertlist[i].y = c0[(i<<2)+2]*m0.z + c1[(i<<2)+2]*m1.z + a0.z;
		vertlist[i].x = c0[(i<<2)+1]*m0.y + c1[(i<<2)+1]*m1.y + a0.y;
	}

	if (m->usesalpha)
	{
		float pc[4];
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glEnable(GL_BLEND);
		glEnable(GL_ALPHA_TEST);
		glAlphaFunc(GL_GREATER,0.32);
		pc[0] = pc[1] = pc[2] = pc[3] = 1.f;
		glColor4f(pc[0],pc[1],pc[2],pc[3]);
	}
	else glDisable(GL_BLEND);

	glBindTexture(GL_TEXTURE_2D,m->texid);
	for(lptr=m->glcmds;i=(*lptr++);)
	{
		if (i < 0) { glBegin(GL_TRIANGLE_FAN); i = -i; }
				else { glBegin(GL_TRIANGLE_STRIP); }
		for(;i>0;i--,lptr+=3)
		{
			glTexCoord2f(((float *)lptr)[0],((float *)lptr)[1]);
			glVertex3fv((float *)&vertlist[lptr[2]]);
		}
		glEnd();
	}
}

void md2free (md2model *m)
{
	if (gtexmalloc) { free((void *)gtexmalloc); gtexmalloc = 0; }
	if (vertlist) { free(vertlist); vertlist = 0; }
	if (m)
	{
		glDeleteLists(m->texid,1);
		if (m->glcmds) free(m->glcmds);
		if (m->frames) free(m->frames);
		free(m);
	}
}

//--------------------------------------  MD2 LIBRARY ENDS -----------------------------------------
//-------------------------------------  MD3 LIBRARY BEGINS ----------------------------------------

typedef struct { char nam[64]; long i; } md3shader_t; //ascz path of shader, shader index
typedef struct { long i[3]; } md3tri_t; //indices of tri
typedef struct { float u, v; } md3uv_t;
typedef struct { signed short x, y, z; unsigned char nlat, nlng; } md3xyzn_t; //xyz are [10:6] ints

typedef struct
{
	point3d min, max, cen; //bounding box&origin
	float r; //radius of bounding sphere
	char nam[16]; //ascz frame name
} md3frame_t;

typedef struct
{
	char nam[64]; //ascz tag name
	point3d p, x, y, z; //tag object pos&orient
} md3tag_t;

typedef struct
{
	long id; //IDP3(0x33806873)
	char nam[64]; //ascz surface name
	long flags; //?
	long numframes, numshaders, numverts, numtris; //numframes same as md3head,max shade=~256,vert=~4096,tri=~8192
	md3tri_t *tris;       //file format: rel offs from md3surf
	md3shader_t *shaders; //file format: rel offs from md3surf
	md3uv_t *uv;          //file format: rel offs from md3surf
	md3xyzn_t *xyzn;      //file format: rel offs from md3surf
	long ofsend;
} md3surf_t;

typedef struct
{
	long id, vers; //id=IDP3(0x33806873), vers=15
	char nam[64]; //ascz path in PK3
	long flags; //?
	long numframes, numtags, numsurfs, numskins; //max=~1024,~16,~32,numskins=artifact of MD2; use shader field instead
	md3frame_t *frames; //file format: abs offs
	md3tag_t *tags;     //file format: abs offs
	md3surf_t *surfs;   //file format: abs offs
	long eof;           //file format: abs offs
} md3head_t;

typedef struct
{
	long mdnum; //MD2=2, MD3=3. NOTE: must be first in structure!
	md3head_t head;
	long frame0, frame1, cframe, nframe, fpssc, usesalpha;
	float oldtime, curtime, interpol, scale;
	unsigned int texid;
} md3model;

md3model *md3load (FILE *fil, const char *filnam)
{
	char *buf, st[MAX_PATH+2], bst[MAX_PATH+2];
	long i, j, surfi, ofsurf, maxverts, bsc;
	md3model *m;
	md3surf_t *s;

	m = (md3model *)malloc(sizeof(md3model)); if (!m) { fclose(fil); return(0); }
	memset(m,0,sizeof(md3model)); m->mdnum = 3;
	m->texid = 0; m->scale = .01;

	fread(&m->head,sizeof(md3head_t),1,fil);
	if ((m->head.id != 0x33504449) && (m->head.vers != 15)) { fclose(fil); free(m); return(0); } //"IDP3"

	ofsurf = (long)m->head.surfs; maxverts = 0;

	fseek(fil,(long)m->head.frames,SEEK_SET); i = m->head.numframes*sizeof(md3frame_t);
	m->head.frames = (md3frame_t *)malloc(i); if (!m->head.frames) MessageBox(0,"malloc failed",":/",MB_OK);
	fread(m->head.frames,i,1,fil);

	fseek(fil,(long)m->head.tags,SEEK_SET); i = m->head.numtags*sizeof(md3tag_t);
	m->head.tags = (md3tag_t *)malloc(i); if (!m->head.tags) MessageBox(0,"malloc failed",":/",MB_OK);
	fread(m->head.tags,i,1,fil);

	fseek(fil,(long)m->head.surfs,SEEK_SET); i = m->head.numsurfs*sizeof(md3surf_t);
	m->head.surfs = (md3surf_t *)malloc(i); if (!m->head.surfs) MessageBox(0,"malloc failed",":/",MB_OK);
	for(surfi=0;surfi<m->head.numsurfs;surfi++)
	{
		s = &m->head.surfs[surfi];
		fseek(fil,ofsurf,SEEK_SET); fread(s,sizeof(md3surf_t),1,fil);

		fseek(fil,ofsurf+((long)(s->tris)),SEEK_SET); i = s->numtris*sizeof(md3tri_t);
		s->tris = (md3tri_t *)malloc(i); if (!s->tris) MessageBox(0,"malloc failed",":/",MB_OK);
		fread(s->tris,i,1,fil);

		fseek(fil,ofsurf+((long)(s->shaders)),SEEK_SET); i = s->numshaders*sizeof(md3shader_t);
		s->shaders = (md3shader_t *)malloc(i); if (!s->shaders) MessageBox(0,"malloc failed",":/",MB_OK);
		fread(s->shaders,i,1,fil);

		fseek(fil,ofsurf+((long)(s->uv)),SEEK_SET); i = s->numverts*sizeof(md3uv_t);
		s->uv = (md3uv_t *)malloc(i); if (!s->uv) MessageBox(0,"malloc failed",":/",MB_OK);
		fread(s->uv,i,1,fil);

		fseek(fil,ofsurf+((long)(s->xyzn)),SEEK_SET); i = s->numframes*s->numverts*sizeof(md3xyzn_t);
		s->xyzn = (md3xyzn_t *)malloc(i); if (!s->xyzn) MessageBox(0,"malloc failed",":/",MB_OK);
		fread(s->xyzn,i,1,fil);

		if (s->numverts > maxverts) maxverts = s->numverts;
		ofsurf += s->ofsend;
	}
	fclose(fil);

	m->frame0 = 0; m->frame1 = m->head.numframes;
	m->cframe = 0; m->nframe = m->cframe+1; if (m->nframe >= m->head.numframes) m->nframe = 0;
	m->fpssc = 8;

	strcpy(st,filnam);
	for(i=0,j=0;st[i];i++) if ((st[i] == '/') || (st[i] == '\\')) j = i+1;
	st[j] = '*'; st[j+1] = 0;

	kzfindfilestart(st); bsc = -1;
	while (kzfindfile(st))
	{
		for(i=0,j=0;st[i];i++) if (st[i] == '.') j = i+1;
		if ((i > 0) && (st[i-1] == '\\')) continue;
		if ((!stricmp(&st[j],"JPG")) || (!stricmp(&st[j],"PNG")) || (!stricmp(&st[j],"GIF")) ||
			 (!stricmp(&st[j],"PCX")) || (!stricmp(&st[j],"TGA")) || (!stricmp(&st[j],"BMP")) ||
			 (!stricmp(&st[j],"CEL")))
		{
			for(i=0;st[i];i++) if (st[i] != filnam[i]) break;
			if (i > bsc) { bsc = i; strcpy(bst,st); }
		}
	}
	if (!mdloadskin(&m->texid,&m->usesalpha,bst)) ;//bad!
	//strcpy(st,"C:\\c\\CPROG\\BUILD\\jonof\\duke3d\\models\\test.jpg");

	vertlist = (point3d *)malloc(maxverts*sizeof(point3d));

	return(m);
}

void md3draw (md3model *m, float tim)
{
	point3d p0, p1, m0, m1, a0, a1;
	md3frame_t *f0, *f1;
	md3xyzn_t *v0, *v1;
	long i, j, k, surfi, *lptr;
	float f, g;
	md3surf_t *s;

	if (tim > 0)
	{
		m->curtime = tim;

			//get cur&next frames
		m->interpol = (m->curtime-m->oldtime)*m->fpssc;
		if (m->interpol > 1.0)
		{
			m->oldtime = m->curtime; m->interpol = 0;

			m->cframe = m->nframe;
			m->nframe++; if (m->nframe >= m->frame1) m->nframe = m->frame0;
		}

			//current/next frame can't be > tot#frames
		if (m->cframe >= m->head.numframes) m->cframe = 0;
		if (m->nframe >= m->head.numframes) m->nframe = 0;
	}

		//create current&next frame's vertex list from whole list
	f0 = (md3frame_t *)&m->head.frames[m->cframe];
	f1 = (md3frame_t *)&m->head.frames[m->nframe];
	f = m->interpol; g = 1-f;
	m0.x = (1.0/64.0)*m->scale*g; m1.x = (1.0/64.0)*m->scale*f;
	m0.y = (1.0/64.0)*m->scale*g; m1.y = (1.0/64.0)*m->scale*f;
	m0.z = (1.0/64.0)*m->scale*g; m1.z = (1.0/64.0)*m->scale*f;
	a0.x = f0->cen.x*m->scale; a0.x = (f1->cen.x*m->scale-a0.x)*f+a0.x;
	a0.y = f0->cen.y*m->scale; a0.y = (f1->cen.y*m->scale-a0.y)*f+a0.y;
	a0.z = f0->cen.z*m->scale; a0.z = (f1->cen.z*m->scale-a0.z)*f+a0.z;
	m0.x = -m0.x; m1.x = -m1.x; a0.x = -a0.x;

	f = 1*32.0;
	m0.x *= f; m0.y *= f; m0.z *= f;
	m1.x *= f; m1.y *= f; m1.z *= f;
	a0.x *= f; a0.y *= f; a0.z *= f;

	for(surfi=0;surfi<m->head.numsurfs;surfi++)
	{
		s = &m->head.surfs[surfi];
		v0 = &s->xyzn[m->cframe*s->numverts];
		v1 = &s->xyzn[m->nframe*s->numverts];
		for(i=s->numverts-1;i>=0;i--) //interpolate&scale vertices to avoid ugly animation
		{
			vertlist[i].z = ((float)v0[i].x)*m0.x + ((float)v1[i].x)*m1.x + a0.x;
			vertlist[i].y = ((float)v0[i].z)*m0.z + ((float)v1[i].z)*m1.z + a0.z;
			vertlist[i].x = ((float)v0[i].y)*m0.y + ((float)v1[i].y)*m1.y + a0.y;
		}

		if (m->usesalpha)
		{
			float pc[4];
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
			glEnable(GL_BLEND);
			glEnable(GL_ALPHA_TEST);
			glAlphaFunc(GL_GREATER,0.32);
			pc[0] = pc[1] = pc[2] = pc[3] = 1.f;
			glColor4f(pc[0],pc[1],pc[2],pc[3]);
		}
		else glDisable(GL_BLEND);

		glBindTexture(GL_TEXTURE_2D,m->texid);
		glBegin(GL_TRIANGLES);
		for(i=s->numtris-1;i>=0;i--)
			for(j=0;j<3;j++)
			{
				k = s->tris[i].i[j];
				glTexCoord2f(s->uv[k].u,s->uv[k].v);
				glVertex3fv((float *)&vertlist[k]);
			}
		glEnd();
	}

#if 0
		//precalc:
	float sinlut256[256+(256>>2)];
	for(i=0;i<sizeof(sinlut256)/sizeof(sinlut256[0]);i++) sinlut256[i] = sin(((float)i)*(PI*2/255.0));

		//normal to xyz:
	md3vert_t *mv = &md3vert[?];
	z = sinlut256[mv->nlng+(256>>2)];
	x = sinlut256[mv->nlat]*z;
	y = sinlut256[mv->nlat+(256>>2)]*z;
	z = sinlut256[mv->nlng];
#endif
}

void md3free (md3model *m)
{
	md3surf_t *s;
	long surfi;

	if (gtexmalloc) { free((void *)gtexmalloc); gtexmalloc = 0; }
	if (vertlist) { free(vertlist); vertlist = 0; }
	if (m)
	{
		glDeleteLists(m->texid,1);
		if (m->head.surfs)
		{
			for(surfi=m->head.numsurfs-1;surfi>=0;surfi--)
			{
				s = &m->head.surfs[surfi];
				if (s->xyzn) free(s->xyzn);
				if (s->uv) free(s->uv);
				if (s->shaders) free(s->shaders);
				if (s->tris) free(s->tris);
			}
			free(m->head.surfs);
		}
		if (m->head.tags) free(m->head.tags);
		if (m->head.frames) free(m->head.frames);
		free(m);
	}
}

void *mdload (const char *filnam)
{
	FILE *fil;
	long i;

	fil = fopen(filnam,"rb"); if (!fil) return(0);
	fread(&i,4,1,fil); fseek(fil,0,SEEK_SET);
	switch(i)
	{
		case 0x32504449: return(md2load(fil,filnam)); //IDP2
		case 0x33504449: return(md3load(fil,filnam)); //IDP3
		default: return(0);
	}
}

void mddraw (void *vm, float tim)
{
	if (*(long *)vm == 2) { md2draw((md2model *)vm,tim); return; }
	if (*(long *)vm == 3) { md3draw((md3model *)vm,tim); return; }
}

void mdfree (void *vm)
{
	if (*(long *)vm == 2) { md2free((md2model *)vm); return; }
	if (*(long *)vm == 3) { md3free((md3model *)vm); return; }
}

//--------------------------------------  MD3 LIBRARY ENDS -----------------------------------------

static void *mymodel;

void drawframe ()
{
	float m[4][4];
	char snotbuf[256];

	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

		//Convert Ken's favorite coordinate system to OpenGL coordinates
	m[0][0] = -istr.x; m[0][1] = ihei.x; m[0][2] = ifor.x; m[0][3] = 0.f;
	m[1][0] = -istr.y; m[1][1] = ihei.y; m[1][2] = ifor.y; m[1][3] = 0.f;
	m[2][0] = -istr.z; m[2][1] = ihei.z; m[2][2] = ifor.z; m[2][3] = 0.f;
	m[3][0] = m[0][0]*ipos.x + m[1][0]*ipos.y + m[2][0]*ipos.z;
	m[3][1] = m[0][1]*ipos.x + m[1][1]*ipos.y + m[2][1]*ipos.z;
	m[3][2] = m[0][2]*ipos.x + m[1][2]*ipos.y + m[2][2]*ipos.z;
	m[3][3] = 1;
	glLoadMatrixf(&m[0][0]);

	if (!useanim) mddraw(mymodel,0);
				else mddraw(mymodel,GetTickCount()*.001);

	numframes++;
}

#include <commdlg.h>
static char fileselectnam[MAX_PATH];
char *loadfileselect (char *mess, char *spec, char *defext)
{
	OPENFILENAME ofn =
	{
		sizeof(OPENFILENAME),ghwnd,0,spec,0,0,1,fileselectnam,MAX_PATH,0,0,0,mess,
		OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY,0,0,defext,0,0,0
	};
	if (!GetOpenFileName(&ofn)) return(0); else return(fileselectnam);
}

void uninitapp () { mdfree(mymodel); }
long initapp (char *cmdline)
{
	long i;
	char *cptr;

	if (cmdline[0]) mymodel = mdload(cmdline); else mymodel = 0;
	if (!mymodel)
	{
		if (cptr = (char *)loadfileselect("LOAD MD2/MD3 file...","MD2/MD3\0*.md*\0\0\0",""))
			mymodel = mdload(cptr);
	}
	if (!mymodel) { MessageBox(ghwnd,"Must specify a valid MD2/MD3 filename","MDView by Ken Silverman",MB_OK); return(0); }

	ipos.x = 0; ipos.y = -.25*32; ipos.z = .5*32;
	istr.x =-1; istr.y = 0; istr.z = 0;
	ihei.x = 0; ihei.y = 1; ihei.z = 0;
	ifor.x = 0; ifor.y = 0; ifor.z =-1;
	return(1);
}

//DirectInput VARIABLES & CODE-------------------------------------------------------
#define DIRECTINPUT_VERSION 0x0300
#include <dinput.h>

static LPDIRECTINPUT gpdi = 0;
long initdirectinput ()
{
	HRESULT hr;
	char buf[256];

	if ((hr = DirectInputCreate(ghinst,DIRECTINPUT_VERSION,&gpdi,0)) >= 0) return(1);
	wsprintf(buf,"initdirectinput failed: %08lx\n",hr);
	MessageBox(ghwnd,buf,"ERROR",MB_OK);
	return(0);
}

void uninitdirectinput ()
{
	if (gpdi) { gpdi->Release(); gpdi = 0; }
}

//DirectInput (KEYBOARD) VARIABLES & CODE-------------------------------------------------------
static LPDIRECTINPUTDEVICE gpKeyboard = 0;
#define KBDBUFFERSIZE 64
DIDEVICEOBJECTDATA KbdBuffer[KBDBUFFERSIZE];

void uninitkeyboard ()
{
	if (gpKeyboard) { gpKeyboard->Unacquire(); gpKeyboard->Release(); gpKeyboard = 0; }
}

long initkeyboard ()
{
	HRESULT hr;
	DIPROPDWORD dipdw;
	char buf[256];

	if ((hr = gpdi->CreateDevice(GUID_SysKeyboard,&gpKeyboard,0)) >= 0)
		if ((hr = gpKeyboard->SetDataFormat(&c_dfDIKeyboard)) >= 0)
			if ((hr = gpKeyboard->SetCooperativeLevel(ghwnd,DISCL_NONEXCLUSIVE|DISCL_FOREGROUND)) >= 0)
			{
				dipdw.diph.dwSize = sizeof(DIPROPDWORD);
				dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
				dipdw.diph.dwObj = 0;
				dipdw.diph.dwHow = DIPH_DEVICE;
				dipdw.dwData = KBDBUFFERSIZE;
				hr = gpKeyboard->SetProperty(DIPROP_BUFFERSIZE,&dipdw.diph);
				if (hr >= 0) { gpKeyboard->Acquire(); return(1); }
			}

	uninitkeyboard();
	wsprintf(buf,"initdirectinput(keyboard) failed: %08lx\n",hr);
	MessageBox(ghwnd,buf,"ERROR",MB_OK);
	return(0);
}

void readkeyboard ()
{
	HRESULT hr;
	unsigned long i, dwItems;
	DIDEVICEOBJECTDATA *lpdidod;

	dwItems = KBDBUFFERSIZE;
	hr = gpKeyboard->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),KbdBuffer,&dwItems,0);
	if (hr == DIERR_INPUTLOST)
	{
		gpKeyboard->Acquire();
		hr = gpKeyboard->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),KbdBuffer,&dwItems,0);
	}
	for(i=0;i<dwItems;i++)
	{
		lpdidod = &KbdBuffer[i];
		keystatus[lpdidod->dwOfs] = (lpdidod->dwData&128);
	}
}

//DirectInput (MOUSE) VARIABLES & CODE-------------------------------------------------------
static LPDIRECTINPUTDEVICE gpMouse = 0;

void uninitmouse ()
{
	if (gpMouse) { gpMouse->Unacquire(); gpMouse->Release(); gpMouse = 0; }
}

long initmouse ()
{
	HRESULT hr;
	char buf[256];

	if ((hr = gpdi->CreateDevice(GUID_SysMouse,&gpMouse,0)) >= 0)
		if ((hr = gpMouse->SetDataFormat(&c_dfDIMouse)) >= 0)
			if ((hr = gpMouse->SetCooperativeLevel(ghwnd,DISCL_EXCLUSIVE|DISCL_FOREGROUND)) >= 0)
				{ gpMouse->Acquire(); return(1); }

	uninitmouse();
	wsprintf(buf,"initdirectinput(mouse) failed: %08lx\n",hr);
	MessageBox(ghwnd,buf,"ERROR",MB_OK);
	return(0);
}

void readmouse (long *mousx, long *mousy, long *bstatus)
{
	DIMOUSESTATE dims;
	HRESULT hr;

	*mousx = *mousy = *bstatus = 0;
	if (!gpMouse) return;

	if ((hr = gpMouse->GetDeviceState(sizeof(DIMOUSESTATE),&dims)) == DIERR_INPUTLOST)
		{ gpMouse->Acquire(); hr = gpMouse->GetDeviceState(sizeof(DIMOUSESTATE),&dims); }
	if (hr >= 0)
	{
		*mousx = dims.lX;
		*mousy = dims.lY;
		*bstatus = (dims.rgbButtons[0]>>7)+((dims.rgbButtons[1]>>7)<<1);
	}
}

void resizegl (int daxdim, int daydim) //Resize & Initialize GL Window
{
	if ((xdim != daxdim) || (ydim != daydim))
	{
		xdim = max(daxdim,1);
		ydim = max(daydim,1);
		glViewport(0,0,xdim,ydim); //Reset Current Viewport
	}
	glMatrixMode(GL_PROJECTION); //Select Projection Matrix
	glLoadIdentity();            //Reset Projection Matrix
	gluPerspective(atan((float)ydim/(float)xdim)*fov*360/PI,(float)xdim/(float)ydim,0.1,100); //Aspect Ratio

	glMatrixMode(GL_MODELVIEW);  //Select Modelview Matrix
}

void uninitgl ()
{
	if (fullscreen) ChangeDisplaySettings(0,0); //Switch Back To Desktop
	if (hRC)
	{
		if (!wglMakeCurrent(0,0)) MessageBox(0,"Releasing DC&RC Failed","SHUTDOWN ERROR",MB_OK|MB_ICONINFORMATION);
		if (!wglDeleteContext(hRC)) MessageBox(0,"Releasing RC Failed","SHUTDOWN ERROR",MB_OK|MB_ICONINFORMATION);
		hRC = 0;
	}
	if (hDC && !ReleaseDC(ghwnd,hDC))
	{
		MessageBox(0,"Releasing DC Failed","SHUTDOWN ERROR",MB_OK|MB_ICONINFORMATION);
		hDC = 0;
	}
	if (ghwnd && !DestroyWindow(ghwnd))
	{
		MessageBox(0,"Couldn't Release ghwnd","SHUTDOWN ERROR",MB_OK|MB_ICONINFORMATION);
		ghwnd = 0;
	}
	if (!UnregisterClass("OpenGL",ghinst))
	{
		MessageBox(0,"Couldn't Unregister Class","SHUTDOWN ERROR",MB_OK|MB_ICONINFORMATION);
		ghinst = 0;
	}
}

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
long initgl (char *title, int daxdim, int daydim, int bits, int fullsc)
{
	GLuint PixelFormat;             //Holds Results After Searching For Match
	WNDCLASS wc;                    //Windows Class Structure
	DWORD dwExStyle;                //Window Extended Style
	DWORD dwStyle;                  //Window Style
	RECT WindowRect;                //Grabs Rectangle Upper Left / Lower Right Values
	WindowRect.left = (long)0;      //Set Left Value To 0
	WindowRect.right = (long)daxdim;  //Set Right Value To Requested Width
	WindowRect.top = (long)0;       //Set Top Value To 0
	WindowRect.bottom = (long)daydim; //Set Bottom Value To Requested Height

	fullscreen = fullsc;

	ghinst           = GetModuleHandle(0);       //Grab An Instance For Our Window
	wc.style         = CS_HREDRAW|CS_VREDRAW|CS_OWNDC; //Redraw On Size, And Own DC For Window.
	wc.lpfnWndProc   = (WNDPROC)WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = ghinst;
	wc.hIcon         = LoadIcon(0,IDI_WINLOGO);
	wc.hCursor       = LoadCursor(0,IDC_ARROW);
	wc.hbrBackground = 0;
	wc.lpszMenuName  = 0;
	wc.lpszClassName = "OpenGL";

	if (!RegisterClass(&wc)) { MessageBox(0,"Failed To Register WC","ERROR",MB_OK); return(0); }

	if (fullscreen)
	{
		DEVMODE dmScreenSettings;
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);
		dmScreenSettings.dmPelsWidth = daxdim;
		dmScreenSettings.dmPelsHeight = daydim;
		dmScreenSettings.dmBitsPerPel = bits;
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

			//Try To Set Mode & Get Results. CDS_FULLSCREEN Gets Rid Of Start Bar.
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			if (MessageBox(0,"Mode not Supported\nTry Windowed Mode?","KenGL",MB_YESNO)==IDYES)
				fullscreen = 0;
			else return(0);
		}
	}

	dwExStyle = WS_EX_APPWINDOW;
	if (fullscreen) { dwExStyle = WS_EX_TOOLWINDOW; dwStyle=WS_POPUP; }
				  else { dwExStyle |= WS_EX_WINDOWEDGE; dwStyle=WS_OVERLAPPEDWINDOW; }

	AdjustWindowRectEx(&WindowRect,dwStyle,0,dwExStyle); //Set To True Requested Size
	ghwnd = CreateWindowEx(
		dwExStyle,       // Extended Style For Window
		"OpenGL",        // Class Name
		title,           // Window Title
		dwStyle |        // Defined Window Style
		WS_CLIPSIBLINGS| // Required Window Style
		WS_CLIPCHILDREN, // Required Window Style
		0, 0,            // Window Position
		WindowRect.right-WindowRect.left, // Calculate Window Width
		WindowRect.bottom-WindowRect.top, // Calculate Window Height
		0,               // No Parent Window
		0,               // No Menu
		ghinst,
		0);              // Dont Pass Anything To WM_CREATE
	if (!ghwnd)
	{
		uninitgl();
		MessageBox(0,"CreateWindowEx Error","ERROR",MB_OK);
		return(0);
	}

	static PIXELFORMATDESCRIPTOR pfd=
	{
		sizeof(PIXELFORMATDESCRIPTOR),
		1,                             //Version Number
		PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER, //Must Support these
		PFD_TYPE_RGBA,                 //Request An RGBA Format
		(unsigned char)bits,           //Select Our Color Depth
		0,0,0,0,0,0,                   //Color Bits Ignored
		0,                             //No Alpha Buffer
		0,                             //Shift Bit Ignored
		0,                             //No Accumulation Buffer
		0,0,0,0,                       //Accumulation Bits Ignored
		16,                            //16/(24?/32?) Z-Buffer depth
		0,                             //No Stencil Buffer
		0,                             //No Auxiliary Buffer
		PFD_MAIN_PLANE,                //Main Drawing Layer
		0,                             //Reserved
		0,0,0                          //Layer Masks Ignored
	};

	hDC = GetDC(ghwnd);
	if (!hDC)
	{
		uninitgl();
		MessageBox(0,"Can't Create GL DC","ERROR",MB_OK);
		return(0);
	}
	PixelFormat = ChoosePixelFormat(hDC,&pfd);
	if (!PixelFormat) { uninitgl(); MessageBox(0,"Can't Choose PixelFormat","ERROR",MB_OK); return(0); }
	if (!SetPixelFormat(hDC,PixelFormat,&pfd)) { uninitgl(); MessageBox(0,"Can't Set PixelFormat","ERROR",MB_OK); return(0); }
	hRC = wglCreateContext(hDC);
	if (!hRC) { uninitgl(); MessageBox(0,"Can't Create GL RC","ERROR",MB_OK); return(0); }
	if (!wglMakeCurrent(hDC,hRC)) { uninitgl(); MessageBox(0,"Can't Activate GL RC","ERROR",MB_OK); return(0); }

	ShowWindow(ghwnd,SW_SHOW);
	SetForegroundWindow(ghwnd); //Slightly Higher Priority
	SetFocus(ghwnd);            //Sets Keyboard Focus To Window
	resizegl(daxdim,daydim);    //Set Up Perspective GL Screen


	glEnable(GL_CULL_FACE); //Not the default: Don't draw back faces
	glFrontFace(GL_CW);     //Not the default: Ken likes it this way
	glCullFace(GL_BACK);    //GL_FRONT, GL_BACK, GL_FRONT_AND_BACK


	glEnable(GL_TEXTURE_2D);
	glShadeModel(GL_SMOOTH); //GL_FLAT
	glClearColor(0,0,0,0.5); //Black Background
	glEnable(GL_DEPTH_TEST); //Z buffer
	glDepthFunc(GL_LESS); //NEVER,LESS,(,L)EQUAL,GREATER,(NOT,G)EQUAL,ALWAYS
	glBlendFunc(GL_SRC_ALPHA,GL_ONE); //Type of blending
	glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST); //Use FASTEST for ortho!
	glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
	glDisable(GL_DITHER);

	return(1);
}

void orthorotate (float ox, float oy, float oz, point3d *ist, point3d *ihe, point3d *ifo)
{
	float f, t, dx, dy, dz, rr[9];

	dx = sin(ox); ox = cos(ox);
	dy = sin(oy); oy = cos(oy);
	dz = sin(oz); oz = cos(oz);
	f = ox*oz; t = dx*dz; rr[0] =  t*dy + f; rr[7] = -f*dy - t;
	f = ox*dz; t = dx*oz; rr[1] = -f*dy + t; rr[6] =  t*dy - f;
	rr[2] = dz*oy; rr[3] = -dx*oy; rr[4] = ox*oy; rr[8] = oz*oy; rr[5] = dy;
	ox = ist->x; oy = ihe->x; oz = ifo->x;
	ist->x = ox*rr[0] + oy*rr[3] + oz*rr[6];
	ihe->x = ox*rr[1] + oy*rr[4] + oz*rr[7];
	ifo->x = ox*rr[2] + oy*rr[5] + oz*rr[8];
	ox = ist->y; oy = ihe->y; oz = ifo->y;
	ist->y = ox*rr[0] + oy*rr[3] + oz*rr[6];
	ihe->y = ox*rr[1] + oy*rr[4] + oz*rr[7];
	ifo->y = ox*rr[2] + oy*rr[5] + oz*rr[8];
	ox = ist->z; oy = ihe->z; oz = ifo->z;
	ist->z = ox*rr[0] + oy*rr[3] + oz*rr[6];
	ihe->z = ox*rr[1] + oy*rr[4] + oz*rr[7];
	ifo->z = ox*rr[2] + oy*rr[5] + oz*rr[8];
	//orthonormalize(ist,ihe,ifo);
}

static float axisrotatek[9];
void axisrotateinit (float x, float y, float z, float w)
{
	point3d ax;
	float t, c, s, ox, oy, oz, *k = axisrotatek;

	c = cos(w); s = sin(w);
	t = x*x + y*y + z*z; if (t == 0) return;
	t = 1.0 / sqrt(t); ax.x = x*t; ax.y = y*t; ax.z = z*t;

	t = 1.0-c;
	k[0] = ax.x*t; k[7] = ax.x*s; oz = ax.y*k[0];
	k[4] = ax.y*t; k[2] = ax.y*s; oy = ax.z*k[0];
	k[8] = ax.z*t; k[3] = ax.z*s; ox = ax.z*k[4];
	k[0] = ax.x*k[0] + c; k[5] = ox - k[7]; k[7] += ox;
	k[4] = ax.y*k[4] + c; k[6] = oy - k[2]; k[2] += oy;
	k[8] = ax.z*k[8] + c; k[1] = oz - k[3]; k[3] += oz;
}
void axisrotate (point3d *p)
{
	float ox, oy, oz, *k = axisrotatek;

	ox = p->x; oy = p->y; oz = p->z;
	p->x = ox*k[0] + oy*k[1] + oz*k[2];
	p->y = ox*k[3] + oy*k[4] + oz*k[5];
	p->z = ox*k[6] + oy*k[7] + oz*k[8];
}

void moveloop ()
{
	static long bstatus, obstatus;
	float f;
	long mousx, mousy;
	char *cptr;

	ototalclock = totalclock;
	QueryPerformanceCounter((LARGE_INTEGER *)&totalclock);
	fsynctics = (float)((double)(totalclock-ototalclock)*timscale);

	readkeyboard();
	obstatus = bstatus;
	readmouse(&mousx,&mousy,&bstatus);

	if (bstatus&2) { a1 = (a1*.75f-(float)mousx*.002f); a3 = a3*.75f; }
	else
	{
		a3 = (a3*.75f+(float)mousx*.002f);
		a1 = istr.y*.05f;
	}
	a2 = (a2*.75f-(float)mousy*.002f);

	orthorotate(a1*fov,a2*fov,a3*fov,&istr,&ihei,&ifor);

	if (keystatus[0x39]) { keystatus[0x39] = 0; useanim ^= 1;                                      } //Space
	if (keystatus[0x14]) { keystatus[0x14] = 0; usetex ^= 1; if (usetex) glEnable(GL_TEXTURE_2D);
																						 else glDisable(GL_TEXTURE_2D); } //T
	if (keystatus[0x10]) { keystatus[0x10] = 0; glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);          } //Q
	if (keystatus[0x11]) { keystatus[0x11] = 0; glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);          } //W
	if (keystatus[0x12]) { keystatus[0x12] = 0; glPolygonMode(GL_FRONT_AND_BACK,GL_POINT);         } //E

	if (keystatus[0x30]) { keystatus[0x30] = 0; glClearColor((float)rand()/32767.f,(float)rand()/32767.f,(float)rand()/32767.f,0.5); } //B

	f = fsynctics*.25*32;
	if (keystatus[0x2a]) f *= .25f; //Lshift
	if (keystatus[0x36]) f *= 4.f; //Rshift
	if (keystatus[0xcb]) { ipos.x -= istr.x*f; ipos.y -= istr.y*f; ipos.z -= istr.z*f; } //Left arrow
	if (keystatus[0xcd]) { ipos.x += istr.x*f; ipos.y += istr.y*f; ipos.z += istr.z*f; } //Right arrow
	if (keystatus[0x9d]) { ipos.x -= ihei.x*f; ipos.y -= ihei.y*f; ipos.z -= ihei.z*f; } //RCtrl
	if (keystatus[0x52]) { ipos.x += ihei.x*f; ipos.y += ihei.y*f; ipos.z += ihei.z*f; } //KP0
	if (keystatus[0xc8]) { ipos.x += ifor.x*f; ipos.y += ifor.y*f; ipos.z += ifor.z*f; } //Up arrow
	if (keystatus[0xd0]) { ipos.x -= ifor.x*f; ipos.y -= ifor.y*f; ipos.z -= ifor.z*f; } //Down arrow

	if (keystatus[0x33]|keystatus[0x34]) //,.
	{
		axisrotateinit(0,1,0,((float)(keystatus[0x34]-keystatus[0x33]))*f/512);
		axisrotate(&ipos); axisrotate(&istr); axisrotate(&ihei); axisrotate(&ifor);
	}
	if (keystatus[0xc9]|keystatus[0xd1]) //PGUP/PGDN
	{
		axisrotateinit(istr.x,istr.y,istr.z,((float)(keystatus[0xc9]-keystatus[0xd1]))*f/512);
		axisrotate(&ipos); axisrotate(&istr); axisrotate(&ihei); axisrotate(&ifor);
	}

	if (keystatus[0x26]) //L
	{
		keystatus[0x26] = 0;
		if (cptr = (char *)loadfileselect("LOAD MD2/MD3 file...","MD2/MD3\0*.md*\0\0\0",""))
		{
			mdfree(mymodel);
			mymodel = mdload(cptr);
			useanim = 1;
		}
	}

	if (keystatus[0x19]) //P
	{
		keystatus[0x19] = 0;
		if (cptr = (char *)loadfileselect("LOAD skin image..","PNG,JPEG,GIF,DDS,TGA,PCX,BMP\0*.PNG;*.JPG;*.JPEG;*.GIF;*.DDS;*.TGA;*.PCX;*.BMP\0All files (*.*)\0*.*\0\0",""))
		{
			if (mymodel)
			{
				if (gtexmalloc) { free((void *)gtexmalloc); gtexmalloc = 0; }

				if (*(long *)mymodel == 2)
				{
					glDeleteLists(((md2model *)mymodel)->texid,1);
					if (!mdloadskin(&((md2model *)mymodel)->texid,&((md2model *)mymodel)->usesalpha,cptr)) ;//bad!
				}
				else if (*(long *)mymodel == 3)
				{
					glDeleteLists(((md3model *)mymodel)->texid,1);
					if (!mdloadskin(&((md3model *)mymodel)->texid,&((md3model *)mymodel)->usesalpha,cptr)) ;//bad!
				}
			}
		}
	}

	if (keystatus[0x35]) // / (reset position, orientation, and zoom)
	{
		ipos.x = 0; ipos.y = -.25*32; ipos.z = .5*32;
		istr.x =-1; istr.y = 0; istr.z = 0;
		ihei.x = 0; ihei.y = 1; ihei.z = 0;
		ifor.x = 0; ifor.y = 0; ifor.z =-1;
		fov = 1; resizegl(xdim,ydim);
	}

	if (keystatus[0xb5]) { fov *= (1.0f+fsynctics); resizegl(xdim,ydim); } //KP/ (zoom out)
	if (keystatus[0x37]) { fov *= (1.0f-fsynctics); resizegl(xdim,ydim); } //KP* (zoom in)

	if (keystatus[0x3b]) //F1
	{
		char st[4096];

		keystatus[0x3b] = 0;
		sprintf(st,
			"Command line:\n"\
			"\t>mdview [MD2/MD3]\n"\
			"\n"\
			"Main controls:\n"\
			"\tESC\tquit\n"\
			"\tL\tload new MD2/MD3 model\n"\
			"\tP\tload new skin\n"\
			"\tF1\tshow help dialog\n"\
			"\n"\
			"Rendering controls:\n"\
			"\tSpace\ttoggle animation\n"\
			"\tT\ttoggle texture\n"\
			"\tB\ttoggle background color\n"\
			"\tQ\tdraw solid     (GL_FILL )\n"\
			"\tW\tdraw wireframe (GL_LINE )\n"\
			"\tE\tdraw points    (GL_POINT)\n"\
			"\n"\
			"Camera controls: (Note: KP stands for KeyPad)\n"\
			"\tArrows\t\tmove forward/backward/left/right\n"\
			"\tRCtrl/KP0\t\tmove up/down\n"\
			"\tMove mouse\trotate left/right/up/down\n"\
			"\tRMB+Mouse\ttilt\n"\
			"\t, or .\t\trotate left/right\n"\
			"\tPGUP/PGDN\trotate up/down\n"\
			"\tKP*, KP/\t\tzoom in,out\n"\
			"\t/\t\treset camera\n"\
			"\tL.Shift\t\tquarter speed\n"\
			"\tR.Shift\t\t4x speed\n"\
			"\n"\
			"MDView by Ken Silverman (http://advsys.net/ken)\n"\
			"Compiled: %s",__DATE__);
		MessageBox(ghwnd,st,"MDView by Ken Silverman",MB_OK);
	}
}

LRESULT CALLBACK WndProc (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps;
	HDC hDC;

	switch (uMsg)
	{
		case WM_ACTIVATE:
			active = (LOWORD(wParam) == WA_ACTIVE);
			if (gpMouse) { if (active) gpMouse->Acquire(); else gpMouse->Unacquire(); }
			if (gpKeyboard) { if (active) gpKeyboard->Acquire(); else gpKeyboard->Unacquire(); }
			break;
		case WM_LBUTTONDOWN: //This is a hack to wake up application in windowed mode
			active = 1;
			if (gpMouse) gpMouse->Acquire();
			if (gpKeyboard) gpKeyboard->Acquire();
			break;
		case WM_PAINT: //In windowed mode, make screen black when inactive so view doesn't look screwy
			if (fullscreen) return(DefWindowProc(hWnd,uMsg,wParam,lParam));
			hDC = BeginPaint(hWnd,&ps);
			glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
			glLoadIdentity();
			glTranslatef(0,0,(float)(-6/tan(fov*PI*.25)));
			SwapBuffers(hDC);
			EndPaint(hWnd,&ps);
			break;
		case WM_SIZE: if (ghwnd) resizegl(LOWORD(lParam),HIWORD(lParam)); break;
		case WM_SYSCOMMAND: //Prevent screen saver, etc...
			if ((wParam == SC_SCREENSAVE) || (wParam == SC_MONITORPOWER)) break;
			return(DefWindowProc(hWnd,uMsg,wParam,lParam));
		case WM_CLOSE: uninitmouse(); uninitkeyboard(); uninitdirectinput(); uninitapp(); uninitgl(); break;
		case WM_DESTROY: PostQuitMessage(0); return(0);
		default: return(DefWindowProc(hWnd,uMsg,wParam,lParam));
	}
	return(0);
}

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;
	long quitout = 0;
	char snotbuf[256];

		//Prevents stupid "unreferenced" compiler warnings
	hInstance = hInstance; hPrevInstance = hPrevInstance; lpCmdLine = lpCmdLine; nCmdShow = nCmdShow;

	if (!initgl("MDView by Ken Silverman",640,480,32,fullscreen)) return(0);
	if (!initapp(lpCmdLine)) return(0);

	QueryPerformanceFrequency((LARGE_INTEGER *)&perfrq);
	timscale = 1.0 / (double)perfrq;

	if (!initdirectinput()) { DestroyWindow(ghwnd); return(0); }
	if (!initkeyboard()) { uninitdirectinput(); DestroyWindow(ghwnd); return(0); }
	if (!initmouse()) { uninitkeyboard(); uninitdirectinput(); DestroyWindow(ghwnd); return(0); }

	do
	{
		while (PeekMessage(&msg,0,0,0,PM_REMOVE))
		{
			if (msg.message == WM_QUIT) { quitout = 1; break; }
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		if (!active) continue;

		drawframe();
		SwapBuffers(hDC);
		moveloop();

		if (keystatus[1]) PostMessage(ghwnd,WM_CLOSE,0,0); //ESC
	} while (!quitout);
	return(msg.wParam);
}

#if 0
!endif
#endif
