DECLARE SUB project (dax%, day%, daz%, scrx&, scry&)
DECLARE SUB getpoints (danumpoints%)
DECLARE SUB getplanes (danumplanes%)

CONST MAXOBJECTS = 256
CONST MAXPOINTS = 4096
CONST MAXPLANES = 4096

COMMON SHARED numobjects%, numpoints%, numplanes%
COMMON SHARED cosang1&, sinang1&, cosang2&, sinang2&, cosang3&, sinang3&
DIM SHARED fx(MAXPOINTS), fy(MAXPOINTS), fz(MAXPOINTS)
DIM SHARED px%(MAXPOINTS), py%(MAXPOINTS), pz%(MAXPOINTS)
DIM SHARED a%(MAXPLANES), b%(MAXPLANES), c%(MAXPLANES)
DIM SHARED ab%(MAXPLANES), bc%(MAXPLANES), ca%(MAXPLANES)
DIM SHARED planeoff%(MAXOBJECTS), pointoff%(MAXOBJECTS)

SCREEN 12
RANDOMIZE TIMER

numobjects% = 0
numpoints% = 0
numplanes% = 0

FILES "*.asc": INPUT "Filename:"; fil$

OPEN fil$ + ".asc" FOR INPUT AS #1
OPEN fil$ + ".3d" FOR BINARY AS #2

ang1% = INT(2048 * RND): ang2% = INT(2048 * RND): ang3% = INT(2048 * RND)
cosang1& = 16384& * COS(ang1% * 3.141592 / 1024)
sinang1& = 16384& * SIN(ang1% * 3.141592 / 1024)
cosang2& = 16384& * COS(ang2% * 3.141592 / 1024)
sinang2& = 16384& * SIN(ang2% * 3.141592 / 1024)
cosang3& = 16384& * COS(ang3% * 3.141592 / 1024)
sinang3& = 16384& * SIN(ang3% * 3.141592 / 1024)

gotname% = 0

PRINT : PRINT TAB(14); "Points"; TAB(22); "Polygons"

DO
   INPUT #1, z$
  
   IF UCASE$(LEFT$(z$, 12)) = "NAMED OBJECT" THEN
      nam$ = MID$(z$, 16, LEN(z$) - 16)
      gotname% = 1: good% = 0
   ELSEIF UCASE$(LEFT$(z$, 8)) = "TRI-MESH" THEN
      good% = 1
   ELSEIF UCASE$(LEFT$(z$, 8)) = "VERTICES" AND gotname% = 1 AND good% = 1 THEN
      gotname% = 0

      danumpoints% = VAL(MID$(z$, 10, 5))
      i% = 10
      WHILE MID$(z$, i%, 5) <> "Faces": i% = i% + 1: WEND
      danumplanes% = VAL(RIGHT$(z$, LEN(z$) - (i% + 5)))

      DO
         INPUT #1, z$
         IF LEFT$(z$, 6) = "Hidden" THEN good% = 0
      LOOP WHILE LEFT$(z$, 11) <> "Vertex list"
     
      IF good% = 1 THEN
         planeoff%(numobjects%) = numplanes%
         pointoff%(numobjects%) = numpoints%
         numobjects% = numobjects% + 1
        
         PRINT nam$;
         PRINT TAB(14); danumpoints%; : CALL getpoints(danumpoints%)
         DO: INPUT #1, z$: LOOP WHILE LEFT$(z$, 9) <> "Face list"
         PRINT TAB(22); danumplanes%: CALL getplanes(danumplanes%)
      END IF
   END IF
LOOP WHILE EOF(1) = 0
planeoff%(numobjects%) = numplanes%
pointoff%(numobjects%) = numpoints%

PRINT "   TOTAL:"; TAB(14); numpoints%; TAB(22); numplanes%

xmin = 4294967296#: xmax = -4294967296#
ymin = 4294967296#: ymax = -4294967296#
zmin = 4294967296#: zmax = -4294967296#
FOR z% = 0 TO numpoints% - 1
   IF fx(z%) < xmin THEN xmin = fx(z%)
   IF fx(z%) > xmax THEN xmax = fx(z%)
   IF fy(z%) < ymin THEN ymin = fy(z%)
   IF fy(z%) > ymax THEN ymax = fy(z%)
   IF fz(z%) < zmin THEN zmin = fz(z%)
   IF fz(z%) > zmax THEN zmax = fz(z%)
NEXT z%
cx = (xmin + xmax) / 2: xrange = xmax - xmin
cy = (ymin + ymax) / 2: yrange = ymax - ymin
cz = (zmin + zmax) / 2: zrange = zmax - zmin
range = xrange
IF yrange > range THEN range = yrange
IF zrange > range THEN range = zrange
scalefactor = 65536 / range
FOR z% = 0 TO numpoints% - 1
   dax& = INT((fx(z%) - cx) * scalefactor)
   day& = -INT((fz(z%) - cz) * scalefactor)
   daz& = INT((fy(z%) - cy) * scalefactor)
   IF dax& < -32768 THEN dax& = -32768
   IF day& < -32768 THEN day& = -32768
   IF daz& < -32768 THEN daz& = -32768
   IF dax& > 32767 THEN dax& = 32767
   IF day& > 32767 THEN day& = 32767
   IF daz& > 32767 THEN daz& = 32767
   px%(z%) = dax&
   py%(z%) = day&
   pz%(z%) = daz&
NEXT z%

FOR zz% = 0 TO numobjects% - 1
   z1% = planeoff%(zz%): z2% = planeoff%(zz% + 1)
   po% = pointoff%(zz%)
   FOR z% = z1% TO z2% - 1
      CALL project(px%(a%(z%) + po%), py%(a%(z%) + po%), pz%(a%(z%) + po%), x1&, y1&)
      CALL project(px%(b%(z%) + po%), py%(b%(z%) + po%), pz%(b%(z%) + po%), x2&, y2&)
      CALL project(px%(c%(z%) + po%), py%(c%(z%) + po%), pz%(c%(z%) + po%), x3&, y3&)
      IF ab%(z%) = 1 THEN LINE (x1&, y1&)-(x2&, y2&), 4
      IF bc%(z%) = 1 THEN LINE (x2&, y2&)-(x3&, y3&), 4
      IF ca%(z%) = 1 THEN LINE (x3&, y3&)-(x1&, y1&), 4
      PSET (x1&, y1&), 12: PSET (x2&, y2&), 12: PSET (x3&, y3&), 12
   NEXT z%
NEXT zz%

PUT #2, , numobjects%
FOR zz% = 0 TO numobjects% - 1
   z1% = pointoff%(zz%): z2% = pointoff%(zz% + 1)
   danumpoints% = z2% - z1%: PUT #2, , danumpoints%
  
   oval& = 0
   FOR z% = z1% TO z2% - 1
      dat& = px%(z%) - oval&: oval& = px%(z%)
      dat% = ((dat& + 32768) AND 65535) - 32768: PUT #2, , dat%
   NEXT z%
  
   oval& = 0
   FOR z% = z1% TO z2% - 1
      dat& = py%(z%) - oval&: oval& = py%(z%)
      dat% = ((dat& + 32768) AND 65535) - 32768: PUT #2, , dat%
   NEXT z%
  
   oval& = 0
   FOR z% = z1% TO z2% - 1
      dat& = pz%(z%) - oval&: oval& = pz%(z%)
      dat% = ((dat& + 32768) AND 65535) - 32768: PUT #2, , dat%
   NEXT z%
  
   'FOR z% = z1% TO z2% - 1: PUT #2, , px%(z%): NEXT z%
   'FOR z% = z1% TO z2% - 1: PUT #2, , py%(z%): NEXT z%
   'FOR z% = z1% TO z2% - 1: PUT #2, , pz%(z%): NEXT z%
  
   z1% = planeoff%(zz%): z2% = planeoff%(zz% + 1)
   danumplanes% = z2% - z1%: PUT #2, , danumplanes%
  
   oval& = 0
   FOR z% = z1% TO z2% - 1
      dat& = a%(z%) - oval&: oval& = a%(z%)
      IF ABS(dat&) < 127 THEN
         z$ = CHR$(dat& AND 255): PUT #2, , z$
      ELSE
         z$ = CHR$(128): PUT #2, , z$: PUT #2, , a%(z%)
      END IF
   NEXT z%
 
   oval& = 0
   FOR z% = z1% TO z2% - 1
      dat& = b%(z%) - oval&: oval& = b%(z%)
      IF ABS(dat&) < 127 THEN
         z$ = CHR$(dat& AND 255): PUT #2, , z$
      ELSE
         z$ = CHR$(128): PUT #2, , z$: PUT #2, , b%(z%)
      END IF
   NEXT z%
 
   oval& = 0
   FOR z% = z1% TO z2% - 1
      dat& = c%(z%) - oval&: oval& = c%(z%)
      IF ABS(dat&) < 127 THEN
         z$ = CHR$(dat& AND 255): PUT #2, , z$
      ELSE
         z$ = CHR$(128): PUT #2, , z$: PUT #2, , c%(z%)
      END IF
   NEXT z%
  
   'FOR z% = z1% TO z2% - 1: PUT #2, , a%(z%): NEXT z%
   'FOR z% = z1% TO z2% - 1: PUT #2, , b%(z%): NEXT z%
   'FOR z% = z1% TO z2% - 1: PUT #2, , c%(z%): NEXT z%
NEXT zz%

CLOSE #1
CLOSE #2
END

OPEN fil$ + ".map" FOR BINARY AS #3
mapversion& = &H20000
posx& = 0: posy& = 0: posz& = 0
a1% = 0: a2% = 0: a3% = 0
PUT #3, , mapversion&
PUT #3, , posx&: PUT #3, , posy&: PUT #3, , posz&
PUT #3, , a1%: PUT #3, , a2%: PUT #3, , a3%

numlines% = numplanes% * 3
PUT #3, , numplanes%: PUT #3, , numlines%: PUT #3, , numpoints%

FOR z% = 0 TO numpoints% - 1: x& = px%(z%): PUT #3, , x&: NEXT z%
FOR z% = 0 TO numpoints% - 1: y& = py%(z%): PUT #3, , y&: NEXT z%
FOR z% = 0 TO numpoints% - 1: z& = pz%(z%): PUT #3, , z&: NEXT z%

FOR z% = 0 TO numobjects% - 1
   FOR zz% = planeoff%(z%) TO planeoff%(z% + 1) - 1
      a%(zz%) = a%(zz%) + pointoff%(z%)
      b%(zz%) = b%(zz%) + pointoff%(z%)
      c%(zz%) = c%(zz%) + pointoff%(z%)
   NEXT zz%
NEXT z%

FOR z% = 0 TO numplanes% - 1: zz% = 3: PUT #3, , zz%: NEXT z%  'linnum
FOR z% = 0 TO numplanes% - 1   'lin
   zz% = a%(z%): PUT #3, , zz%
   zz% = b%(z%): PUT #3, , zz%
   zz% = c%(z%): PUT #3, , zz%
NEXT z%
FOR z% = 0 TO numplanes% - 1   'lin2
   zz% = b%(z%): PUT #3, , zz%
   zz% = c%(z%): PUT #3, , zz%
   zz% = a%(z%): PUT #3, , zz%
NEXT z%
FOR z% = 0 TO numplanes% * 9 - 1: x& = 1024: PUT #3, , x&: NEXT z%  'b?v
FOR z% = 0 TO numplanes% - 1: z$ = CHR$(0): PUT #3, , z$: NEXT z%  'shade
FOR z% = 0 TO numplanes% - 1: zz% = 0: PUT #3, , z$: NEXT z%  'picnum
FOR z% = 0 TO numplanes% - 1: z$ = CHR$(0): PUT #3, , z$: NEXT z%  'planestat
CLOSE #3

SUB getplanes (danumplanes%)
   danumplanes% = danumplanes% + numplanes%
   WHILE numplanes% < danumplanes%
      INPUT #1, z$
      z$ = z$ + "   "
      IF LEFT$(z$, 4) = "Face" THEN
         i% = 6
         DO WHILE i% < LEN(z$)
            IF MID$(z$, i%, 2) = "A:" THEN
               i% = i% + 2: j% = i%
               WHILE ASC(MID$(z$, j%, 1)) > 32: j% = j% + 1: WEND
               a%(numplanes%) = VAL(MID$(z$, i%, j% - i% + 1))
               i% = j% - 1
            END IF
            IF MID$(z$, i%, 2) = "B:" THEN
               i% = i% + 2: j% = i%
               WHILE ASC(MID$(z$, j%, 1)) > 32: j% = j% + 1: WEND
               b%(numplanes%) = VAL(MID$(z$, i%, j% - i% + 1))
               i% = j% - 1
            END IF
            IF MID$(z$, i%, 2) = "C:" THEN
               i% = i% + 2: j% = i%
               WHILE ASC(MID$(z$, j%, 1)) > 32: j% = j% + 1: WEND
               c%(numplanes%) = VAL(MID$(z$, i%, j% - i% + 1))
               i% = j% - 1
            END IF
            IF MID$(z$, i%, 2) = "AB" THEN
               i% = i% + 3: j% = i%
               WHILE ASC(MID$(z$, j%, 1)) > 32: j% = j% + 1: WEND
               ab%(numplanes%) = VAL(MID$(z$, i%, j% - i% + 1))
               i% = j% - 1
            END IF
            IF MID$(z$, i%, 2) = "BC" THEN
               i% = i% + 3: j% = i%
               WHILE ASC(MID$(z$, j%, 1)) > 32: j% = j% + 1: WEND
               bc%(numplanes%) = VAL(MID$(z$, i%, j% - i% + 1))
               i% = j% - 1
            END IF
            IF MID$(z$, i%, 2) = "CA" THEN
               i% = i% + 3: j% = i%
               WHILE ASC(MID$(z$, j%, 1)) > 32: j% = j% + 1: WEND
               ca%(numplanes%) = VAL(MID$(z$, i%, j% - i% + 1))
               i% = j% - 1
               EXIT DO
            END IF
            i% = i% + 1
         LOOP
         numplanes% = numplanes% + 1
      END IF
   WEND
END SUB

SUB getpoints (danumpoints%)
   danumpoints% = danumpoints% + numpoints%
   WHILE numpoints% < danumpoints%
      INPUT #1, z$
      z$ = z$ + CHR$(32)
      IF LEFT$(z$, 6) = "Vertex" THEN
         i% = 6
         DO WHILE i% < LEN(z$)
            IF MID$(z$, i%, 1) = "X" THEN
               i% = i% + 2: j% = i%
               IF ASC(MID$(z$, j%, 1)) = 32 THEN j% = j% + 1
               WHILE ASC(MID$(z$, j%, 1)) > 32: j% = j% + 1: WEND
               fx(numpoints%) = VAL(MID$(z$, i%, j% - i% + 1))
               i% = j% - 1
            END IF
            IF MID$(z$, i%, 1) = "Y" THEN
               i% = i% + 2: j% = i%
               IF ASC(MID$(z$, j%, 1)) = 32 THEN j% = j% + 1
               WHILE ASC(MID$(z$, j%, 1)) > 32: j% = j% + 1: WEND
               fy(numpoints%) = VAL(MID$(z$, i%, j% - i% + 1))
               i% = j% - 1
            END IF
            IF MID$(z$, i%, 1) = "Z" THEN
               i% = i% + 2: j% = i%
               IF ASC(MID$(z$, j%, 1)) = 32 THEN j% = j% + 1
               WHILE ASC(MID$(z$, j%, 1)) > 32: j% = j% + 1: WEND
               fz(numpoints%) = VAL(MID$(z$, i%, j% - i% + 1))
               EXIT DO
            END IF
            i% = i% + 1
         LOOP
         numpoints% = numpoints% + 1
      END IF
   WEND
END SUB

SUB project (daxe%, daye%, daze%, scrx&, scry&)
   dax& = daxe%: day& = daye%: daz& = daze%

   odax& = dax&
   dax& = (dax& * cosang1& - day& * sinang1&) \ 16384
   day& = (day& * cosang1& + odax& * sinang1&) \ 16384
   oday& = day&
   day& = (day& * cosang2& - daz& * sinang2&) \ 16384
   daz& = (daz& * cosang2& + oday& * sinang2&) \ 16384
   odax& = dax&
   dax& = (dax& * cosang3& - daz& * sinang3&) \ 16384
   daz& = (daz& * cosang3& + odax& * sinang3&) \ 16384
  
   scrx& = (dax& * 1024) \ (daz& + 160000) + 320
   scry& = (day& * 1024) \ (daz& + 160000) + 240
END SUB

