// "Build Engine & Tools" Copyright (c) 1993-1997 Ken Silverman
// Ken Silverman's official web site: "http://www.advsys.net/ken"
// See the included license file "BUILDLIC.TXT" for license info.

#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <dos.h>
#include <math.h>
#include "pragmas.h"
#include "ves2.h"

#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))

#define XDIM 320
#define YDIM 200

#define NUMOPTIONS 8
#define NUMKEYS 19
#define MAXTILES 4096

#define TIMERRATE 9942   //120 times/sec

#define MAXMENUFILES 256
static char menuname[MAXMENUFILES][17], curpath[128], menupath[128];
static long menunamecnt, menuhighlight;

static long kvxcapturecount = 0;

	//These variables need to be copied into BUILD
#define MAXXSIZ 128
#define MAXYSIZ 128
#define MAXZSIZ 200
#define MAXVOXELS 512
#define MAXVOXMIPS 5
static char *voxoff[MAXVOXELS][MAXVOXMIPS];
static long voxsiz[MAXVOXELS][MAXVOXMIPS];
static long ggxinc[MAXXSIZ+1], ggyinc[MAXXSIZ+1];
static long lowrecip[1024], nytooclose, nytoofar;
static unsigned long distrecip[16384];

static char voxdat[262144];

static char voxel[MAXXSIZ*MAXYSIZ*MAXZSIZ];
static char plistx[MAXXSIZ*(MAXXSIZ+MAXYSIZ)];
static char plisty[MAXXSIZ*(MAXXSIZ+MAXYSIZ)];
static long plistcnt[MAXXSIZ];
static char tempbuf[MAXZSIZ*MAXZSIZ];

static char voxixy[MAXXSIZ*MAXYSIZ];  //16K
static char voxixz[MAXXSIZ*MAXZSIZ];  //25K

static char voxiyz[MAXYSIZ*MAXZSIZ];  //25K

static long xsiz, ysiz, zsiz, xpivot, ypivot, zpivot;
static long numrotations, totrotations;

static char artpalname[128], artpalnameleng;
static long starttile = 0, picanm[MAXTILES];
static short tilesizx[MAXTILES], tilesizy[MAXTILES], numpalookups;
static char palette[768], palookup[8192], transluc[65536];
static char whitecol, backgroundcol = 0;
static long pag = 0;

static char palette2[768], palookupe[256];

#define FILLBUFSIZ 8192
static char xfillbuf[FILLBUFSIZ], yfillbuf[FILLBUFSIZ], zfillbuf[FILLBUFSIZ];

	//2D MODE variables:
long viewx = 0, viewy = 0, viewz = 0;
long voxindex = -1, inawindow = -1;

	//Window 0 is (xsiz,ysiz)
	//Window 1 is (xsiz,zsiz)
	//Window 2 is (ysiz,zsiz)
	//Window 3 is the colorbar
long wx1[4], wy1[4], wx2[4], wy2[4], wz[4], numwindows = 4;
long wndorder[4];
char showthrough = 0, edit2dmode = 0, adjustpivotmode = 0;
char currentcol, trailmode = 0, rotatemode = 255, mrestrict = 0;
long trailwindow = -1;
long markx1 = 0, marky1 = 0, markx2 = -1, marky2 = -1, grabwindow = -1;
long markinawindow = -1;

static long ylookup[YDIM], frameplace;

static long randomseed;

static long globalposx = 0, globalposy = 0, globalposz = 0;
static short globalang = 1536;
static long globalhoriz = (100<<8);

static long fvel, svel, hvel, a1vel, a2vel, a3vel;
static long sprx = 0, spry = -MAXXSIZ*16, sprz = 0, sprang = 0;
static long sprxrepeat = 64, spryrepeat = 64;

short mousx, mousy, bstatus, obstatus;

char pow2char[8] = {1,2,4,8,16,32,64,128};
long pow2long[32] =
{
	1L,2L,4L,8L,
	16L,32L,64L,128L,
	256L,512L,1024L,2048L,
	4096L,8192L,16384L,32768L,
	65536L,131072L,262144L,524288L,
	1048576L,2097152L,4194304L,8388608L,
	16777216L,33554432L,67108864L,134217728L,
	268435456L,536870912L,1073741824L,2147483647L,
};
static long sintable[2048];
static long textfont[256] =
{
	0x00000000,0x00000000,0x81a5817e,0x7e8199bd,0xffdbff7e,0x7effe7c3,0xfefefe6c,0x0010387c,
	0xfe7c3810,0x0010387c,0xfe387c38,0x7c1092fe,0x7c381000,0x7c387cfe,0x3c180000,0x0000183c,
	0xc3e7ffff,0xffffe7c3,0x42663c00,0x003c6642,0xbd99c3ff,0xffc399bd,0x7d0f070f,0x78cccccc,
	0x6666663c,0x187e183c,0x303f333f,0xe0f07030,0x637f637f,0xc0e66763,0xe73c5a99,0x995a3ce7,
	0xfef8e080,0x0080e0f8,0xfe3e0e02,0x00020e3e,0x187e3c18,0x183c7e18,0x66666666,0x00660066,
	0x7bdbdb7f,0x001b1b1b,0x6c38633e,0xfc86386c,0x00000000,0x007e7e7e,0x187e3c18,0xff183c7e,
	0x187e3c18,0x00181818,0x18181818,0x00183c7e,0xfe0c1800,0x0000180c,0xfe603000,0x00003060,
	0xc0c00000,0x0000fec0,0xff662400,0x00002466,0x7e3c1800,0x0000ffff,0x7effff00,0x0000183c,
	0x00000000,0x00000000,0x183c3c18,0x00180018,0x006c6c6c,0x00000000,0x6cfe6c6c,0x006c6cfe,
	0x7cc07e18,0x0018fc06,0x18ccc600,0x00c66630,0x76386c38,0x0076ccdc,0x00603030,0x00000000,
	0x60603018,0x00183060,0x18183060,0x00603018,0xff3c6600,0x0000663c,0x7e181800,0x00001818,
	0x00000000,0x30181800,0x7e000000,0x00000000,0x00000000,0x00181800,0x30180c06,0x0080c060,
	0xf6dece7c,0x007cc6e6,0x30307030,0x00fc3030,0x380ccc78,0x00fccc60,0x380ccc78,0x0078cc0c,
	0xcc6c3c1c,0x001e0cfe,0x0cf8c0fc,0x0078cc0c,0xf8c06038,0x0078cccc,0x180cccfc,0x00303030,
	0x78cccc78,0x0078cccc,0x7ccccc78,0x0070180c,0x00181800,0x00181800,0x00181800,0x30181800,
	0xc0603018,0x00183060,0x007e0000,0x0000007e,0x0c183060,0x00603018,0x180c663c,0x00180018,
	0xdedec67c,0x007cc0dc,0xcccc7830,0x00ccccfc,0x7c6666fc,0x00fc6666,0xc0c0663c,0x003c66c0,
	0x66666cf8,0x00f86c66,0x786862fe,0x00fe6268,0x786862fe,0x00f06068,0xc0c0663c,0x003a66ce,
	0xfccccccc,0x00cccccc,0x30303078,0x00783030,0x0c0c0c1e,0x0078cccc,0x786c66e6,0x00e6666c,
	0x606060f0,0x00fe6662,0xfefeeec6,0x00c6c6d6,0xdef6e6c6,0x00c6c6ce,0xc6c66c38,0x00386cc6,
	0x7c6666fc,0x00f06060,0xc6c6c67c,0x000e7cd6,0x7c6666fc,0x00e6666c,0x78e0c67c,0x007cc60e,
	0x3030b4fc,0x00783030,0xcccccccc,0x00fccccc,0xcccccccc,0x003078cc,0xc6c6c6c6,0x006cfed6,
	0x386cc6c6,0x00c6c66c,0x78cccccc,0x00783030,0x188cc6fe,0x00fe6632,0x60606078,0x00786060,
	0x183060c0,0x0002060c,0x18181878,0x00781818,0xc66c3810,0x00000000,0x00000000,0xff000000,
	0x00183030,0x00000000,0x0c780000,0x0076cc7c,0x7c6060e0,0x00dc6666,0xcc780000,0x0078ccc0,
	0x7c0c0c1c,0x0076cccc,0xcc780000,0x0078c0fc,0xf0646c38,0x00f06060,0xcc760000,0xf80c7ccc,
	0x766c60e0,0x00e66666,0x30700030,0x00783030,0x0c1c000c,0x78cccc0c,0x6c6660e0,0x00e66c78,
	0x30303070,0x00783030,0xfecc0000,0x00d6d6fe,0xccb80000,0x00cccccc,0xcc780000,0x0078cccc,
	0x66dc0000,0xf0607c66,0xcc760000,0x1e0c7ccc,0x76dc0000,0x00f06062,0xc07c0000,0x00f81c70,
	0x30fc3010,0x00183430,0xcccc0000,0x0076cccc,0xcccc0000,0x003078cc,0xc6c60000,0x006cfed6,
	0x6cc60000,0x00c66c38,0xcccc0000,0xf80c7ccc,0x98fc0000,0x00fc6430,0xe030301c,0x001c3030,
	0x00181818,0x00181818,0x1c3030e0,0x00e03030,0x0000dc76,0x00000000,0x6c381000,0x00fec6c6,
};
static long smallfnt[256] =
{
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x10101000,0x00001000,0x00282800,0x00000000,0x283c2800,0x0000283c,
	0x10301800,0x00003018,0x10082800,0x00002820,0x10281000,0x00001830,0x00100800,0x00000000,
	0x20201000,0x00001020,0x08081000,0x00001008,0x10280000,0x00000028,0x38100000,0x00000010,
	0x00000000,0x00100808,0x38000000,0x00000000,0x00000000,0x00001000,0x10080800,0x00002010,
	0x28283800,0x00003828,0x10101000,0x00001010,0x38083800,0x00003820,0x38083800,0x00003808,
	0x38282800,0x00000808,0x38203800,0x00003808,0x38203800,0x00003828,0x08083800,0x00000808,
	0x38283800,0x00003828,0x38283800,0x00000808,0x00100000,0x00000010,0x00100000,0x00002010,
	0x20100800,0x00000810,0x00380000,0x00000038,0x08102000,0x00002010,0x10083000,0x00001000,
	0x38283800,0x00003830,0x38281000,0x00002828,0x30283000,0x00003028,0x20201800,0x00001820,
	0x28283000,0x00003028,0x30203800,0x00003820,0x30203800,0x00002020,0x38201800,0x00001028,
	0x38282800,0x00002828,0x10103800,0x00003810,0x10103800,0x00003010,0x30282800,0x00002828,
	0x20202000,0x00003820,0x38382800,0x00002828,0x38382800,0x00002838,0x28283800,0x00003828,
	0x38283800,0x00002020,0x28281000,0x00001838,0x30283000,0x00002828,0x38203800,0x00003808,
	0x10103800,0x00001010,0x28282800,0x00003828,0x28282800,0x00001010,0x38282800,0x00002838,
	0x10282800,0x00002828,0x10282800,0x00001010,0x10083800,0x00003820,0x20203000,0x00003020,
	0x10202000,0x00000808,0x08081800,0x00001808,0x00281000,0x00000000,0x00000000,0x00003800,
	0x00081000,0x00000000,0x18000000,0x00001828,0x38202000,0x00003828,0x38000000,0x00003820,
	0x38080800,0x00003828,0x18000000,0x00001838,0x38100800,0x00001010,0x18000000,0x30081828,
	0x30202000,0x00002828,0x00100000,0x00001010,0x00100000,0x20101010,0x28202000,0x00002830,
	0x10101000,0x00001010,0x38200000,0x00003838,0x38200000,0x00002828,0x38000000,0x00003828,
	0x38000000,0x00203828,0x38000000,0x00083828,0x38000000,0x00002020,0x18000000,0x00003010,
	0x38100000,0x00001010,0x28000000,0x00001828,0x28000000,0x00001028,0x38000000,0x00003838,
	0x28000000,0x00002810,0x28000000,0x00301828,0x30000000,0x00001810,0x20101800,0x00001810,
	0x00101000,0x00001010,0x08103000,0x00003010,0x00301800,0x00000000,0x28100000,0x00000038,
};

static char option[NUMOPTIONS] = {0,0,0,0,0,0,1,0};
static char keys[NUMKEYS] =
{
	0xc8,0xd0,0xcb,0xcd,0x2a,0x9d,0x1d,0x39,
	0x1e,0x2c,0xd1,0xc9,0x33,0x34,
	0x9c,0x1c,0xd,0xc,0xf,
};
long reciptable[2048], fpuasm;

static long osearchx, osearchy, searchx = (XDIM>>1), searchy = 4L, searchit;

extern long setupdrawslab(long,long);
#pragma aux setupdrawslab parm [eax][ebx];
extern long drawslab(long,long,long,long,long,long);
#pragma aux drawslab parm [eax][ebx][ecx][edx][esi][edi];

	//0x007ff000 is (11<<13), 0x3f800000 is (127<<23)
#pragma aux krecipasm =\
	"mov fpuasm, eax",\
	"fild dword ptr fpuasm",\
	"add eax, eax",\
	"fstp dword ptr fpuasm",\
	"sbb ebx, ebx",\
	"mov eax, fpuasm",\
	"mov ecx, eax",\
	"and eax, 0x007ff000",\
	"shr eax, 10",\
	"sub ecx, 0x3f800000",\
	"shr ecx, 23",\
	"mov eax, dword ptr reciptable[eax]",\
	"sar eax, cl",\
	"xor eax, ebx",\
	parm [eax]\
	modify exact [eax ebx ecx]\

#pragma aux slab1 =\
	"begdraw: mov eax, ebx",\
	"add ebx, edx",\
	"shr eax, 16",\
	"mov al, byte ptr [esi+eax]",\
	"mov byte ptr [edi], al",\
	"add edi, dword ptr ylookup[4]",\
	"dec ecx",\
	"jnz begdraw",\
	parm [ebx][ecx][edx][esi][edi]\

#pragma aux slab2 =\
	"begdraw: mov eax, ebx",\
	"add ebx, edx",\
	"shr eax, 16",\
	"mov al, byte ptr [esi+eax]",\
	"mov ah, al",\
	"mov word ptr [edi], ax",\
	"add edi, dword ptr ylookup[4]",\
	"dec ecx",\
	"jnz begdraw",\
	parm [ebx][ecx][edx][esi][edi]\

#pragma aux slab4 =\
	"begdraw: mov eax, ebx",\
	"add ebx, edx",\
	"shr eax, 16",\
	"mov al, byte ptr [esi+eax]",\
	"mov ah, al",\
	"shl eax, 8",\
	"mov al, ah",\
	"shl eax, 8",\
	"mov al, ah",\
	"mov dword ptr [edi], eax",\
	"add edi, dword ptr ylookup[4]",\
	"dec ecx",\
	"jnz begdraw",\
	parm [ebx][ecx][edx][esi][edi]\

static long doublezero[2] = {0,0};
#pragma aux copyandclearbuf =\
	"xor ebx, ebx",\
	"shr ecx, 1",\
	"fld qword ptr doublezero",\
	"beg: fld qword ptr [esi]",\
	"fstp qword ptr [edi]",\
	"fst qword ptr [esi]",\
	"add esi, 8",\
	"add edi, 8",\
	"dec ecx",\
	"jnz beg",\
	"fstp st",\
	parm [esi][edi][ecx]\
	modify [ebx]\

voxfill2dregion(char *vox, long x, long y, long xinc, long yinc, long xbound, long ybound, char col, char bound);
circlize(char *voxptr, long xmul, long ymul, long daxsiz, long daysiz);

	//FPS variables
volatile long totalclock = 0, baktotalclock, lockspeed, numframes = 0;
long ofinetotalclock, ototalclock, chainintrclock = 0, averagefps;
#define AVERAGEFRAMES 32
long frameval[AVERAGEFRAMES], framecnt = 0;
void (__interrupt __far *oldtimerhandler)();
void __interrupt __far timerhandler(void);

#pragma aux inittimer42 =\
	"in al, 0x61",\
	"or al, 1",\
	"out 0x61, al",\
	"mov al, 0xb4",\
	"out 0x43, al",\
	"xor al, al",\
	"out 0x42, al",\
	"out 0x42, al",\
	modify exact [eax]\

#pragma aux uninittimer42 =\
	"in al, 0x61",\
	"and al, 252",\
	"out 0x61, al",\
	modify exact [eax]\

#pragma aux gettimer42 =\
	"mov al, 0x84",\
	"out 0x43, al",\
	"in al, 0x42",\
	"shl eax, 24",\
	"in al, 0x42",\
	"rol eax, 8",\
	modify [eax]\

static float oneover1024 = 1/1024.0, fsinrange = 16384.0;
#pragma aux fcalcsinasm =\
	"fldpi",\
	"fmul dword ptr [oneover1024]",\
	"fld st",\
	"fsin",\
	"fmul dword ptr [fsinrange]",\
	"fxch st(1)",\
	"fmul st, st",\
	"fchs",\
	"fldz",\
	"xor eax, eax",\
	"beg: fist dword ptr sintable[eax*4]",\
	"fadd st, st(2)",\
	"fld st(1)",\
	"fmul st, st(1)",\
	"inc eax",\
	"faddp st(3), st",\
	"cmp eax, 512",\
	"jb beg",\
	"fcompp",\
	"fstp st",\
	modify exact [eax]\

fcalcsin()
{
	long i;

	fcalcsinasm();
	sintable[512] = 16384;
	for(i=513;i<1024;i++) sintable[i] = sintable[1024-i];
	for(i=1024;i<2048;i++) sintable[i] = -sintable[i-1024];
}

volatile char keystatus[256], readch, oldreadch, extended, keytemp;
static void (__interrupt __far *oldkeyhandler)();
static void __interrupt __far keyhandler(void);

main(short argc, char **argv)
{
	long i, j, k, x, y, z, xx, yy, zz, hitx, hity, hitz, fil, oval, *longptr;
	long xxx, yyy, zzz;
	char bad, ch, dabuf[128];
	char *ptr, *ptr2;

	//printf("\n");
	//printf("------------------------------------------------------------------------------\n");
	//printf("SLABSPRI.EXE (.KVX voxel editor) Copyright (c) 1995 - 1997 Ken Silverman.\n");
	//printf("This version of SLABSPRI was created for Shadow Warrior, produced by\n");
	//printf("3D Realms Entertainment\n");
	//printf("\n");
	//printf("License is granted to those writing books or manuals on any tools written by\n");
	//printf("Ken Silverman as long as suitable credit is given.\n");
	//printf("\n");
	//printf("IMPORTANT:  SLABSPRI.EXE and associated tools and utilities are NOT\n");
	//printf("shareware and may NOT be freely distributed to any BBS, CD, floppy, or\n");
	//printf("any other media.  These tools may NOT be sold or repackaged for sale in\n");
	//printf("a commercial product.\n");
	//printf("\n");
	//printf("Any .KVX files created with this editor may only be used with the\n");
	//printf("full (registered) copy of Shadow Warrior, and not the shareware version.\n");
	//printf("Please refer to LICENSE.DOC for further information on .KVX files created with\n");
	//printf("SLABSPRI.EXE.\n");
	//printf("\n");
	//printf("Please help us protect against software piracy (which drives up software\n");
	//printf("prices) by following these simple rules.\n");
	//printf("\n");
	//printf("Thank You!\n");
	//printf("------------------------------------------------------------------------------\n");
	//getch();

	if ((argc != 1) && (argc != 2) && (argc != 5))
	{
		printf("Slabspri [art&pal name][start tile][num tiles][total rotations(neg. for CCW)]\n");
		printf("   See VIEWALL.BAT for example command lines             by Kenneth Silverman\n");
		exit(0);
	}

	loadtables();

	if (argc == 5)
	{
		strcpy(artpalname,argv[1]);
		starttile = atol(argv[2]);
		numrotations = atol(argv[3]);
		totrotations = atol(argv[4]);
	}
	else
	{
		if (argc == 2)
			strcpy(artpalname,argv[1]);
		else
			artpalname[0] = 0;
		starttile = -1;
	}

	for(i=0;artpalname[i];i++)
		if (artpalname[i] == '.') break;
	artpalnameleng = i;

	for(i=1;i<1024;i++) lowrecip[i] = ((1<<24)-1)/i;
	for(i=1;i<16384;i++) distrecip[i] = divscale20(XDIM,i);
	nytooclose = XDIM*2100; nytoofar = 16384*16384-1048576;

	initmouse();

	if (starttile >= 0)
	{
		artpalname[artpalnameleng] = 0;
		strcat(artpalname,".pal");
		loadpalette(artpalname);

		artpalname[artpalnameleng] = 0;
		strcat(artpalname,".art");
		if (art2vox(artpalname) < 0)
		{
			printf("Slabspri [art&pal name][start tile][num tiles][total rotations(neg. for CCW)]\n");
			printf("   See VIEWALL.BAT for example command lines             by Kenneth Silverman\n");
			exit(0);
		}
	}
	else
	{
		artpalname[artpalnameleng] = 0;
		if (!artpalname[0])
		{
			loadefaultkvx();
			strcpy(artpalname,"default.kvx");
		}
		else if ((artpalname[artpalnameleng+1] == 'v') || (artpalname[artpalnameleng+1] == 'V'))
		{
			strcat(artpalname,".vox");
			if (loadvox(artpalname) < 0)
				{ printf("%s not found\n",artpalname); exit(0); }
		}
		else
		{
			strcat(artpalname,".kvx");
			if (loadkvx(artpalname) < 0)
				{ printf("%s not found\n",artpalname); exit(0); }
			kvx2vox(0,0L,0L,0L);
		}
		for(i=0;i<8192;i++) palookup[i] = (i&255);
		loadpalette("palette.dat");  //Hack to load transluscent table
		for(i=0;i<256;i++) palookup[i] = i;
	}

	if (setvesa(320L,200L,8) < 0)
	{
		setvmode(0x13);
		screen = (char *)malloc(65536L);
		frameplace = FP_OFF(screen);
		bytesperline = 320;
		maxpages = 1;
	}
	koutp(0x3c8,0); for(i=0;i<768;i++) koutp(0x3c9,palette[i]);
	j = 0;
	for(i=0;i<YDIM;i++) { ylookup[i] = j; j += bytesperline; }

	setupdrawslab(ylookup[1],(long)&palookup[0]);

	whitecol = 0; k = 0x80000000;
	for(i=0;i<255;i++)
	{
		j = palette[i*3]+palette[i*3+1]+palette[i*3+2];
		if (j > k) { whitecol = i; k = j; }
	}

	initmenupaths(argv[0]);
	menunamecnt = 0;
	menuhighlight = 0;

	inittimer();
	inittimer42();
	initkeys();

	currentcol = 15;
	numframes = 0;
	trailmode = 0;
	trailwindow = -1;
	getwindowborders();

	lockspeed = baktotalclock = totalclock = 0;

	while (keystatus[1] != 2)
	{
		if (maxpages > 1)
		{
			setactivepage(pag);
			clearbufbyte(frameplace,XDIM*YDIM,backgroundcol+(backgroundcol<<8)+(backgroundcol<<16)+(backgroundcol<<24));
		}

		drawvox(sprx,spry,sprz,sprang,sprxrepeat,spryrepeat,0);

		osearchx = searchx; osearchy = searchy; obstatus = bstatus;
		getmousevalues(&mousx,&mousy,&bstatus);
		if (keystatus[0x2a]|keystatus[0x36])
		{
			if ((!mrestrict) && (mousx|mousy))
			{
				if (klabs(mousx) > klabs(mousy)) mrestrict = 1; else mrestrict = 2;
			}
		}
		else
			mrestrict = 0;
		if (mrestrict == 1) mousy = 0;
		if (mrestrict == 2) mousx = 0;
		searchx = min(max(searchx+(mousx>>1),0),XDIM-1);
		searchy = min(max(searchy+(mousy>>1),0),YDIM-1);

		inawindow = -1;
		if (edit2dmode)
		{
			for(i=numwindows-1;i>=0;i--)
			{
				j = wndorder[i];
				drawwindow(j);
				if ((searchx >= wx1[j]) && (searchx < wx1[j]+(wx2[j]-wx1[j])*wz[j]))
					if ((searchy >= wy1[j]) && (searchy < wy1[j]+(wy2[j]-wy1[j])*wz[j]))
						inawindow = j;
			}
		}
		if ((rotatemode != 255) && (inawindow != rotatemode))
			rotatemode = 255;

		i = totalclock-ototalclock; ototalclock += i;
		j = ofinetotalclock-gettimer42(); ofinetotalclock -= j;
		i = ((i*(1193181/240)-(j&65535)+32768)&0xffff0000)+(j&65535);
		if (i) { frameval[framecnt&(AVERAGEFRAMES-1)] = 11931810/i; framecnt++; }
			//Print MAX FRAME RATE
		i = frameval[0];
		for(j=AVERAGEFRAMES-1;j>0;j--) i = max(i,frameval[j]);
		averagefps = ((averagefps*3+i)>>2);
		sprintf(dabuf,"%ld.%ld",averagefps/10,averagefps%10);
		printext256(0L,0L,whitecol,-1,dabuf,1);

		if (edit2dmode)
		{
			sprintf(dabuf,"X:%ld Y:%ld Z:%ld: A:%ld H:%ld SA:%ld",globalposx,globalposy,globalposz,globalang,globalhoriz,sprang);
			printext256(64L,0L,whitecol,-1,dabuf,1);
		}


		if (inawindow == 3)
		{
			if (keystatus[0xcb]) { keystatus[0xcb] = 0; searchx = max(searchx-wz[3],wz[3]); }
			if (keystatus[0xcd]) { keystatus[0xcd] = 0; searchx = min(searchx+wz[3],XDIM-wz[3]); }
			if (keystatus[0xc8]) { keystatus[0xc8] = 0; searchy = max(searchy-wz[3],wz[3]); }
			if (keystatus[0xd0]) { keystatus[0xd0] = 0; searchy = min(searchy+wz[3],YDIM-wz[3]); }
		}

		voxindex = getvoxindexunderpoint(searchx,searchy);
		if ((edit2dmode) && (inawindow >= 0) && (inawindow < 3) && (wz[inawindow] <= 2))
		{
			x = (((searchx-wx1[inawindow])/wz[inawindow])*wz[inawindow])+wx1[inawindow];
			y = (((searchy-wy1[inawindow])/wz[inawindow])*wz[inawindow])+wy1[inawindow];

			ch = (rand()&255);
			for(yy=wz[inawindow]-1;yy>=0;yy--)
				if ((unsigned)(y+yy) < (unsigned)YDIM)
					for(xx=wz[inawindow]-1;xx>=0;xx--)
						if ((unsigned)(x+xx) < (unsigned)XDIM)
							if ((wz[inawindow] <= 1) || (y+yy != searchy) || (x+xx != searchx))
								*(char *)(frameplace+ylookup[y+yy]+x+xx) = ch;
		}
		else
		{
			for(i=2;i<=4;i++)
			{
				if (searchx+i < XDIM) *(char *)(frameplace+ylookup[searchy]+searchx+i) = whitecol;
				if (searchx-i >= 0)   *(char *)(frameplace+ylookup[searchy]+searchx-i) = whitecol;
				if (searchy+i < YDIM) *(char *)(frameplace+ylookup[searchy+i]+searchx) = whitecol;
				if (searchy-i >= 0)   *(char *)(frameplace+ylookup[searchy-i]+searchx) = whitecol;
			}
		}

		if (maxpages > 1)
		{
			setvisualpage(pag);
			pag++; if (pag >= maxpages) pag = 0;
		}
		else
			copyandclearbuf(frameplace,0xa0000,XDIM*YDIM>>2);

		if (keystatus[0x58])  //F12
			{ keystatus[0x58] = 0; screencapture("SLABS000.PCX"); }

		globalposx += mulscale17(sintable[(globalang+512)&2047],fvel*lockspeed);
		globalposy += mulscale17(sintable[globalang&2047],fvel*lockspeed);
		globalposx += mulscale17(sintable[(globalang+1024)&2047],svel*lockspeed);
		globalposy += mulscale17(sintable[(globalang+512)&2047],svel*lockspeed);
		globalposz += mulscale5(hvel,lockspeed);
		globalang = ((globalang+mulscale4(a3vel,lockspeed))&2047);
		globalhoriz -= (a2vel*lockspeed<<1);
		sprang = ((sprang-mulscale4(a1vel,lockspeed))&2047);

		if (keystatus[0x4b]) sprxrepeat = max(sprxrepeat-1,1);
		if (keystatus[0x4d]) sprxrepeat = min(sprxrepeat+1,255);
		if (keystatus[0x48]) spryrepeat = max(spryrepeat-1,1);
		if (keystatus[0x50]) spryrepeat = min(spryrepeat+1,255);
		if (keystatus[0x4c])
		{
			if (keystatus[0x1d]|keystatus[0x9d])
			{
				globalposx = 0; globalposy = 0; globalposz = 0;
				globalang = 1536; globalhoriz = (100<<8);
				sprx = 0; spry = -MAXXSIZ*16; sprz = 0; sprang = 0;
				sprxrepeat = 64; spryrepeat = 64;
			}
			sprxrepeat = spryrepeat = 64;
		}

		if (keystatus[0x3b] > 0) globalposx--;
		if (keystatus[0x3c] > 0) globalposx++;
		if (keystatus[0x3d] > 0) globalposy--;
		if (keystatus[0x3e] > 0) globalposy++;
		if (keystatus[0x3f] > 0) globalposz--;
		if (keystatus[0x40] > 0) globalposz++;
		if (edit2dmode)
		{
			if (keystatus[0x41] > 0) { keystatus[0x41] = 0; sprang--; }
			if (keystatus[0x42] > 0) { keystatus[0x42] = 0; sprang++; }
		}
		else
		{
			if (keystatus[0x41] > 0) sprang--;
			if (keystatus[0x42] > 0) sprang++;
		}
		if (keystatus[0x43] > 0) globalang--;
		if (keystatus[0x44] > 0) globalang++;

		if (keystatus[0x16]) //U (update - Boolean operation with another kvx)
		{
			keystatus[0x16] = 0;
			if (keystatus[0x38]|keystatus[0xb8])  //Alt-U (Ignore changes)
			{
				kvx2vox(0,0L,0L,0L);
				calcvoxindeces();
			}
			else if (menuselect() >= 0)
			{
				x = xsiz; y = ysiz; z = zsiz;
				xx = xpivot; yy = ypivot; zz = zpivot;

				xxx = yyy = zzz = 0;

					//XOR it!
				loadkvx(menuname[menuhighlight]);
				kvx2vox(2,xxx,yyy,zzz);
				xsiz = max(xsiz,x); ysiz = max(ysiz,y); zsiz = max(zsiz,z);
				xpivot = xx; ypivot = yy; zpivot = zz;
				voxsiz[0][0] = compilevoxels(voxdat);

				while (1)
				{
					if (maxpages > 1)
					{
						setactivepage(pag);
						clearbufbyte(frameplace,XDIM*YDIM,backgroundcol+(backgroundcol<<8)+(backgroundcol<<16)+(backgroundcol<<24));
					}

					drawvox(sprx,spry,sprz,sprang,sprxrepeat,spryrepeat,0);

					if (maxpages > 1)
					{
						setvisualpage(pag);
						pag++; if (pag >= maxpages) pag = 0;
					}
					else
						copyandclearbuf(frameplace,0xa0000,XDIM*YDIM>>2);

					globalposx += mulscale17(sintable[(globalang+512)&2047],fvel*lockspeed);
					globalposy += mulscale17(sintable[globalang&2047],fvel*lockspeed);
					globalposx += mulscale17(sintable[(globalang+1024)&2047],svel*lockspeed);
					globalposy += mulscale17(sintable[(globalang+512)&2047],svel*lockspeed);
					globalposz += mulscale5(hvel,lockspeed);
					globalang = ((globalang+mulscale4(a3vel,lockspeed))&2047);
					globalhoriz -= (a2vel*lockspeed<<1);
					sprang = ((sprang-mulscale4(a1vel,lockspeed))&2047);

					lockspeed = totalclock-baktotalclock;
					baktotalclock += lockspeed;

					ch = 0;
					if (keystatus[0x4f]) { keystatus[0x4f] = 0; ch = 1; }
					if (keystatus[0x50]) { keystatus[0x50] = 0; ch = 2; }
					if (keystatus[0x51]) { keystatus[0x51] = 0; ch = 3; }
					if (keystatus[0x4b]) { keystatus[0x4b] = 0; ch = 4; }
					if (keystatus[0x4c]) { keystatus[0x4c] = 0; ch = 5; }
					if (keystatus[0x4d]) { keystatus[0x4d] = 0; ch = 6; }
					if (ch)
					{
							//XOR it!
						loadkvx(menuname[menuhighlight]);
						kvx2vox(2,xxx,yyy,zzz);
						if (ch == 4) xxx = max(xxx-1,0);
						if (ch == 1) xxx = min(xxx+1,max(xsiz,x)-xsiz);
						if (ch == 5) yyy = max(yyy-1,0);
						if (ch == 2) yyy = min(yyy+1,max(ysiz,y)-ysiz);
						if (ch == 6) zzz = max(zzz-1,0);
						if (ch == 3) zzz = min(zzz+1,max(zsiz,z)-zsiz);
						xsiz = max(xsiz,x); ysiz = max(ysiz,y); zsiz = max(zsiz,z);
						xpivot = xx; ypivot = yy; zpivot = zz;
						voxsiz[0][0] = compilevoxels(voxdat);

							//XOR it!
						loadkvx(menuname[menuhighlight]);
						kvx2vox(2,xxx,yyy,zzz);
						xsiz = max(xsiz,x); ysiz = max(ysiz,y); zsiz = max(zsiz,z);
						xpivot = xx; ypivot = yy; zpivot = zz;
						voxsiz[0][0] = compilevoxels(voxdat);
					}
					if (keystatus[0x1c])
					{
						keystatus[0x1c] = 0;

							//XOR it!
						loadkvx(menuname[menuhighlight]);
						kvx2vox(2,xxx,yyy,zzz);
						xsiz = max(xsiz,x); ysiz = max(ysiz,y); zsiz = max(zsiz,z);
						xpivot = xx; ypivot = yy; zpivot = zz;
						voxsiz[0][0] = compilevoxels(voxdat);

						loadkvx(menuname[menuhighlight]);
						kvx2vox(1,xxx,yyy,zzz);
						xsiz = max(xsiz,x); ysiz = max(ysiz,y); zsiz = max(zsiz,z);
						xpivot = xx; ypivot = yy; zpivot = zz;
						compileallmips();
						calcvoxindeces();
						break;
					}
					if (keystatus[1])
					{
						keystatus[1] = 0;

							//XOR it!
						loadkvx(menuname[menuhighlight]);
						kvx2vox(2,xxx,yyy,zzz);
						xsiz = x; ysiz = y; zsiz = z;
						xpivot = xx; ypivot = yy; zpivot = zz;
						compileallmips();

						break;
					}
				}
			}
		}

		if (keystatus[0x26]) //L (load)
		{
			keystatus[0x26] = 0;
			if (menuselect() >= 0)
				if (loadkvx(menuname[menuhighlight]) >= 0)
				{
					kvx2vox(0,0L,0L,0L);

					strcpy(artpalname,menuname[menuhighlight]);
					koutp(0x3c8,0); for(i=0;i<768;i++) koutp(0x3c9,palette[i]);

					whitecol = 0; k = 0x80000000;
					for(i=0;i<255;i++)
					{
						j = palette[i*3]+palette[i*3+1]+palette[i*3+2];
						if (j > k) { whitecol = i; k = j; }
					}

					getwindowborders();
					calcvoxindeces();
				}
		}

		if (keystatus[0x1f])   //Alt-S
		{
			keystatus[0x1f] = 0;
			if (keystatus[0x38])
			{
				printext256((XDIM-14*8L)>>1,(YDIM>>1)-4L,whitecol,0,"Saving as .KVX",0);
				if (maxpages <= 1) copyandclearbuf(frameplace,0xa0000,XDIM*YDIM>>2);
				savekvx();
			}
			if (keystatus[0xb8])
			{
				printext256((XDIM-14*8L)>>1,(YDIM>>1)-4L,whitecol,0,"Saving as .VOX",0);
				if (maxpages <= 1) copyandclearbuf(frameplace,0xa0000,XDIM*YDIM>>2);
				savevox("voxel000.vox");
			}
		}

			// Convert to PALETTE.DAT!
		if ((keystatus[0x38]|keystatus[0xb8]) && (keystatus[0x19])) //Alt-P
		{
			keystatus[0x19] = 0;
			if ((fil = open("palette.dat",O_BINARY|O_RDWR,S_IREAD)) != -1)
			{
				copybufbyte(palette,palette2,768);
				read(fil,palette,768);
				getpaletteconversion();

				for(i=0;i<MAXVOXMIPS;i++)
					remapcompiledvoxel(voxoff[0][i]);

				koutp(0x3c8,0);
				for(i=0;i<768;i++) koutp(0x3c9,palette[i]);

				whitecol = 0; k = 0;
				for(i=0;i<255;i++)
				{
					j = palette[i*3]+palette[i*3+1]+palette[i*3+2];
					if (j > k) { whitecol = i; k = j; }
				}
			}
		}

		if (bstatus&2)
		{
			if (!(obstatus&2))
			{
				grabwindow = inawindow;

				for(i=0;i<numwindows;i++)
					if (wndorder[i] == inawindow)
					{
						for(;i>0;i--) swaplong(&wndorder[i],&wndorder[i-1]);
						break;
					}
			}

			if (grabwindow >= 0)
			{
				wx1[grabwindow] += (mousx>>1); wy1[grabwindow] += (mousy>>1);
				wx2[grabwindow] += (mousx>>1); wy2[grabwindow] += (mousy>>1);
				//if (wx1[grabwindow] < 0)
				//   { wx2[grabwindow] += 0-wx1[grabwindow]; wx1[grabwindow] = 0; }
				//if (wy1[grabwindow] < 6)
				//   { wy2[grabwindow] += 6-wy1[grabwindow]; wy1[grabwindow] = 6; }
				//if (wx2[grabwindow] > XDIM)
				//   { wx1[grabwindow] += XDIM-wx2[grabwindow]; wx2[grabwindow] = XDIM; }
				//if (wy2[grabwindow] > YDIM)
				//   { wy1[grabwindow] += YDIM-wy2[grabwindow]; wy2[grabwindow] = YDIM; }
			}
		}
		else if (obstatus&2)
		{
			grabwindow = -1;
		}

		if (keystatus[0x1a])  //[
		{
			keystatus[0x1a] = 0;
			currentcol--;
		}
		if (keystatus[0x1b])  //]
		{
			keystatus[0x1b] = 0;
			currentcol++;
		}
		if ((inawindow >= 0) && (rotatemode == 255))
			if (keystatus[0x2a]|keystatus[0x36])
			{
				if (keystatus[0xcb]) { keystatus[0xcb] = 0; if ((currentcol&31) > 0) currentcol--; }
				if (keystatus[0xcd]) { keystatus[0xcd] = 0; if ((currentcol&31) < 31) currentcol++; }
				if (keystatus[0xc8]) { keystatus[0xc8] = 0; if (currentcol >= 32) currentcol -= 32; }
				if (keystatus[0xd0]) { keystatus[0xd0] = 0; if (currentcol < 256-32) currentcol += 32; }
			}

			//Kill trail mode when cursor leaves window
		if ((trailmode) && (inawindow != trailwindow)) { trailmode = 0; trailwindow = -1; }

		if (inawindow == 3)
		{
			if ((keystatus[0xf]) || (keystatus[0x39]) || (bstatus&1))
			{
				keystatus[0xf] = 0; keystatus[0x39] = 0;
				currentcol = ((searchx-wx1[3])/wz[3]);
				currentcol += (((searchy-wy1[3])/wz[3])<<5);
			}
			if (keystatus[0x30])  //B (set background color)
			{
				keystatus[0x30] = 0;
				backgroundcol = ((searchx-wx1[3])/wz[3]);
				backgroundcol += (((searchy-wy1[3])/wz[3])<<5);
					//Stupid hack for copyandclearbuf
				doublezero[0] = doublezero[1] = backgroundcol+(backgroundcol<<8)+(backgroundcol<<16)+(backgroundcol<<24);
			}
		}
		else
		{
			if ((keystatus[0xf]) || (bstatus&2)) //Tab
			{
				keystatus[0xf] = 0;
				if (inawindow >= 0)
				{
					if (voxindex >= 0)
						currentcol = voxel[voxindex];
					else
						currentcol = 255;
				}
				else if (voxelhitscan(searchx,searchy,&hitx,&hity,&hitz))
					currentcol = voxel[(hitx*MAXYSIZ+hity)*MAXZSIZ+hitz];
			}
			if (keystatus[0xe])  //Backspace
			{
				keystatus[0xe] = 0;
				currentcol = 255;
			}
			if (keystatus[0xd3])  //Delete
			{
				voxelaserkill(searchx,searchy);
				compileallmips();
			}
			if ((keystatus[0x39]) || (bstatus&1) || ((voxindex >= 0) && trailmode))
			{
				keystatus[0x39] = 0;
				if (voxindex >= 0)
				{
					for(i=0;i<64;i++)
						if ((voxindex = getvoxindexunderpoint(osearchx+mulscale6(searchx-osearchx,i),osearchy+mulscale6(searchy-osearchy,i))) >= 0)
							voxel[voxindex] = currentcol;
					voxindex = getvoxindexunderpoint(searchx,searchy);
				}
				else if ((inawindow < 0) && (voxelhitscan(searchx,searchy,&hitx,&hity,&hitz)))
				{
					voxel[(hitx*MAXYSIZ+hity)*MAXZSIZ+hitz] = currentcol;
					compileallmips();
				}
				if ((currentcol == 255) && (edit2dmode))
					calcvoxindeces();
			}
			if (keystatus[0xc]|keystatus[0x4a])  //-, Keyp.-
			{
				keystatus[0xc] = keystatus[0x4a] = 0;
				if (voxindex >= 0)
					{ if (voxel[voxindex] > 0) voxel[voxindex]--; }
				else if (voxelhitscan(searchx,searchy,&hitx,&hity,&hitz))
				{
					if (voxel[(hitx*MAXYSIZ+hity)*MAXZSIZ+hitz] > 0)
					{
						voxel[(hitx*MAXYSIZ+hity)*MAXZSIZ+hitz]--;
						compileallmips();
					}
				}
			}
			if (keystatus[0xd]|keystatus[0x4e])  //+, Keyp.+
			{
				keystatus[0xd] = keystatus[0x4e] = 0;
				if (voxindex >= 0)
					{ if (voxel[voxindex] < 254) voxel[voxindex]++; }
				else if (voxelhitscan(searchx,searchy,&hitx,&hity,&hitz))
				{
					if (voxel[(hitx*MAXYSIZ+hity)*MAXZSIZ+hitz] < 254)
					{
						voxel[(hitx*MAXYSIZ+hity)*MAXZSIZ+hitz]++;
						compileallmips();
					}
				}
			}
			/*if (keystatus[0xd2])
			{
				keystatus[0xd2] = 0;
				if (voxelhitscan(searchx,searchy,&hitx,&hity,&hitz))
				{
					voxel[(hitx*MAXYSIZ+hity)*MAXZSIZ+hitz] = currentcol;
					for(x=-2;x<=2;x++)
						for(y=-2;y<=2;y++)
							for(z=-2;z<=2;z++)
								if ((hitx+x >= 0) && (hity+y >= 0) && (hitz+z >= 0))
									if ((hitx+x < xsiz) && (hity+y < ysiz) && (hitz+z < zsiz))
										voxel[((hitx+x)*MAXYSIZ+(hity+y))*MAXZSIZ+(hitz+z)] = currentcol;
					compileallmips();
					calcvoxindeces();
				}
			}
			if (keystatus[0xd3])
			{
				keystatus[0xd3] = 0;
				if (voxelhitscan(searchx,searchy,&hitx,&hity,&hitz))
				{
					i = (((globalang+256)>>9)&3);

					if ((i == 0) && (hitx < xsiz-1))
						for(y=hity-2;y<=hity+2;y++)
							for(z=hitz-2;z<=hitz+2;z++)
								if ((y >= 0) && (z >= 0) && (y < ysiz) && (z < zsiz))
								{
									ch = 255;
									for(x=0;x<=hitx;x++)
									{
										i = ((x)*MAXYSIZ+(y))*MAXZSIZ+(z);
										if (ch == 255) ch = voxel[i];
										voxel[i] = 255;
									}
									if (ch != 255) voxel[((hitx+1)*MAXYSIZ+(y))*MAXZSIZ+(z)] = ch;
								}

					if ((i == 1) && (hity < ysiz-1))
						for(x=hitx-2;x<=hitx+2;x++)
							for(z=hitz-2;z<=hitz+2;z++)
								if ((x >= 0) && (z >= 0) && (x < xsiz) && (z < zsiz))
								{
									ch = 255;
									for(y=0;y<=hity;y++)
									{
										i = ((x)*MAXYSIZ+(y))*MAXZSIZ+(z);
										if (ch == 255) ch = voxel[i];
										voxel[i] = 255;
									}
									if (ch != 255) voxel[((x)*MAXYSIZ+(hity+1))*MAXZSIZ+(z)] = ch;
								}

					if ((i == 2) && (hitx > 0))
						for(y=hity-2;y<=hity+2;y++)
							for(z=hitz-2;z<=hitz+2;z++)
								if ((y >= 0) && (z >= 0) && (y < ysiz) && (z < zsiz))
								{
									ch = 255;
									for(x=xsiz-1;x>=hitx;x--)
									{
										i = ((x)*MAXYSIZ+(y))*MAXZSIZ+(z);
										if (ch == 255) ch = voxel[i];
										voxel[i] = 255;
									}
									if (ch != 255) voxel[((hitx-1)*MAXYSIZ+(y))*MAXZSIZ+(z)] = ch;
								}

					if ((i == 3) && (hity > 0))
						for(x=hitx-2;x<=hitx+2;x++)
							for(z=hitz-2;z<=hitz+2;z++)
								if ((x >= 0) && (z >= 0) && (x < xsiz) && (z < zsiz))
								{
									ch = 255;
									for(y=ysiz-1;y>=hity;y--)
									{
										i = ((x)*MAXYSIZ+(y))*MAXZSIZ+(z);
										if (ch == 255) ch = voxel[i];
										voxel[i] = 255;
									}
									if (ch != 255) voxel[((x)*MAXYSIZ+(hity-1))*MAXZSIZ+(z)] = ch;
								}

					compileallmips();
					calcvoxindeces();
				}
			}*/
		}
		if (edit2dmode)
		{
			if (keystatus[0x1c]) //L.Enter
			{
				keystatus[0x1c] = 0;
				showthrough++;
				if (showthrough > 2) showthrough = 0;
				if ((showthrough == 1) || (showthrough == 2))
					calcvoxindeces();
			}
			if (keystatus[0x29]) //`~ Adjust pivot mode
			{
				keystatus[0x29] = 0;
				adjustpivotmode ^= 1;
			}
			if (keystatus[0x35])  // /
			{
				keystatus[0x35] = 0;
				if (adjustpivotmode)
				{
					xpivot = (xsiz<<7);
					ypivot = (ysiz<<7);
					zpivot = (zsiz<<7);
				}
			}
			if (inawindow >= 0)
			{
				if (keystatus[0xb5]) // Keyp. /
				{
					keystatus[0xb5] = 0;
					if (wz[inawindow] > 1)
					{
						x = ((searchx-wx1[inawindow])<<16)/((wx2[inawindow]-wx1[inawindow])*wz[inawindow]);
						y = ((searchy-wy1[inawindow])<<16)/((wy2[inawindow]-wy1[inawindow])*wz[inawindow]);
						wz[inawindow] >>= 1;
						x = (searchx-mulscale16(x,(wx2[inawindow]-wx1[inawindow])*wz[inawindow]))-wx1[inawindow];
						y = (searchy-mulscale16(y,(wy2[inawindow]-wy1[inawindow])*wz[inawindow]))-wy1[inawindow];
						wx1[inawindow] += x; wy1[inawindow] += y;
						wx2[inawindow] += x; wy2[inawindow] += y;
					}
				}
				if (keystatus[0x37]) // Keyp. *
				{
					keystatus[0x37] = 0;
					if (wz[inawindow] < 8)
					{
						x = ((searchx-wx1[inawindow])<<16)/((wx2[inawindow]-wx1[inawindow])*wz[inawindow]);
						y = ((searchy-wy1[inawindow])<<16)/((wy2[inawindow]-wy1[inawindow])*wz[inawindow]);
						wz[inawindow] <<= 1;
						x = (searchx-mulscale16(x,(wx2[inawindow]-wx1[inawindow])*wz[inawindow]))-wx1[inawindow];
						y = (searchy-mulscale16(y,(wy2[inawindow]-wy1[inawindow])*wz[inawindow]))-wy1[inawindow];
						wx1[inawindow] += x; wy1[inawindow] += y;
						wx2[inawindow] += x; wy2[inawindow] += y;
					}
				}
				if (adjustpivotmode)
				{
					if (inawindow == 0)
					{
						if (keystatus[0xcb]) { keystatus[0xcb] = 0; xpivot -= 256; }
						if (keystatus[0xcd]) { keystatus[0xcd] = 0; xpivot += 256; }
						if (keystatus[0xc8]) { keystatus[0xc8] = 0; ypivot -= 256; }
						if (keystatus[0xd0]) { keystatus[0xd0] = 0; ypivot += 256; }
					}
					if (inawindow == 1)
					{
						if (keystatus[0xcb]) { keystatus[0xcb] = 0; xpivot -= 256; }
						if (keystatus[0xcd]) { keystatus[0xcd] = 0; xpivot += 256; }
						if (keystatus[0xc8]) { keystatus[0xc8] = 0; zpivot -= 256; }
						if (keystatus[0xd0]) { keystatus[0xd0] = 0; zpivot += 256; }
					}
					if (inawindow == 2)
					{
						if (keystatus[0xcb]) { keystatus[0xcb] = 0; ypivot -= 256; }
						if (keystatus[0xcd]) { keystatus[0xcd] = 0; ypivot += 256; }
						if (keystatus[0xc8]) { keystatus[0xc8] = 0; zpivot -= 256; }
						if (keystatus[0xd0]) { keystatus[0xd0] = 0; zpivot += 256; }
					}
				}
				else if ((inawindow != 3) && (rotatemode == 255))
				{
					if (keystatus[0xcb]) { keystatus[0xcb] = 0; searchx = max(searchx-wz[inawindow],wx1[inawindow]); }
					if (keystatus[0xcd]) { keystatus[0xcd] = 0; searchx = min(searchx+wz[inawindow],wx1[inawindow]+(wx2[inawindow]-wx1[inawindow])*wz[inawindow]-1); }
					if (keystatus[0xc8]) { keystatus[0xc8] = 0; searchy = max(searchy-wz[inawindow],wy1[inawindow]); }
					if (keystatus[0xd0]) { keystatus[0xd0] = 0; searchy = min(searchy+wz[inawindow],wy1[inawindow]+(wy2[inawindow]-wy1[inawindow])*wz[inawindow]-1); }
				}

				if (keystatus[0x21]) //F (fill)
				{
					keystatus[0x21] = 0;
					if (keystatus[0x38]|keystatus[0xb8])  // Rubix cube flip
					{
						if (inawindow == 0)
						{
							for(x=0;x<xsiz;x++)
								for(y=0;y<ysiz;y++)
									for(z=0;z<(zsiz>>1);z++)
										swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+y)*MAXZSIZ+(zsiz-1-z)]);
							zpivot = (zsiz<<8)-zpivot;
							getwindowborders();
							calcvoxindeces();
						}
						if (inawindow == 1)
						{
							for(x=0;x<xsiz;x++)
								for(y=0;y<(ysiz>>1);y++)
									for(z=0;z<zsiz;z++)
										swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+(ysiz-1-y))*MAXZSIZ+z]);
							ypivot = (ysiz<<8)-ypivot;
							getwindowborders();
							calcvoxindeces();
						}
						if (inawindow == 2)
						{
							for(x=0;x<(xsiz>>1);x++)
								for(y=0;y<ysiz;y++)
									for(z=0;z<zsiz;z++)
										swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[((xsiz-1-x)*MAXYSIZ+y)*MAXZSIZ+z]);
							xpivot = (xsiz<<8)-xpivot;
							getwindowborders();
							calcvoxindeces();
						}
					}
					else if (voxindex >= 0)
					{
						if (showthrough == 0)
						{
							if (inawindow == 0) voxfill2dregion(&voxel[viewz],(searchx-wx1[0])/wz[0],(searchy-wy1[0])/wz[0],MAXYSIZ*MAXZSIZ,MAXZSIZ,wx2[0]-wx1[0],wy2[0]-wy1[0],currentcol,currentcol);
							if (inawindow == 1) voxfill2dregion(&voxel[viewy*MAXZSIZ],(searchx-wx1[1])/wz[1],(searchy-wy1[1])/wz[1],MAXYSIZ*MAXZSIZ,1,wx2[1]-wx1[1],wy2[1]-wy1[1],currentcol,currentcol);
							if (inawindow == 2) voxfill2dregion(&voxel[viewx*MAXYSIZ*MAXZSIZ],(searchx-wx1[2])/wz[2],(searchy-wy1[2])/wz[2],MAXZSIZ,1,wx2[2]-wx1[2],wy2[2]-wy1[2],currentcol,currentcol);
						}
						else
						{
							floodfill3d(voxindex/(MAXYSIZ*MAXZSIZ),(voxindex/MAXZSIZ)%MAXYSIZ,voxindex%MAXZSIZ,currentcol,voxel[voxindex]);
							compileallmips();  //This necessary?
						}
					}
				}
				if (keystatus[0x2e]) //C (change)
				{
					keystatus[0x2e] = 0;
					if ((keystatus[0x38]|keystatus[0xb8]))
					{
						if (showthrough == 0)
						{
							if (inawindow == 0) circlize(&voxel[viewz],MAXYSIZ*MAXZSIZ,MAXZSIZ,xsiz,ysiz);
							if (inawindow == 1) circlize(&voxel[viewy*MAXZSIZ],MAXYSIZ*MAXZSIZ,1L,xsiz,zsiz);
							if (inawindow == 2) circlize(&voxel[viewx*MAXYSIZ*MAXZSIZ],MAXZSIZ,1L,ysiz,zsiz);
						}
						else
						{
							if (inawindow == 0)
								for(z=0;z<zsiz;z++)
									circlize(&voxel[z],MAXYSIZ*MAXZSIZ,MAXZSIZ,xsiz,ysiz);
							if (inawindow == 1)
								for(y=0;y<ysiz;y++)
									circlize(&voxel[y*MAXZSIZ],MAXYSIZ*MAXZSIZ,1L,xsiz,zsiz);
							if (inawindow == 2)
								for(x=0;x<xsiz;x++)
									circlize(&voxel[x*MAXYSIZ*MAXZSIZ],MAXZSIZ,1L,ysiz,zsiz);
							calcvoxindeces();
						}
					}
					else
					{
						if (voxindex >= 0) ch = voxel[voxindex]; else ch = 255;
						if (showthrough == 0)
						{
							if (inawindow == 0)
								for(x=0;x<xsiz;x++)
									for(y=0;y<ysiz;y++)
										if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+viewz] == ch)
											voxel[(x*MAXYSIZ+y)*MAXZSIZ+viewz] = currentcol;
							if (inawindow == 1)
								for(x=0;x<xsiz;x++)
									for(z=0;z<zsiz;z++)
										if (voxel[(x*MAXYSIZ+viewy)*MAXZSIZ+z] == ch)
											voxel[(x*MAXYSIZ+viewy)*MAXZSIZ+z] = currentcol;
							if (inawindow == 2)
								for(y=0;y<ysiz;y++)
									for(z=0;z<zsiz;z++)
										if (voxel[(viewx*MAXYSIZ+y)*MAXZSIZ+z] == ch)
											voxel[(viewx*MAXYSIZ+y)*MAXZSIZ+z] = currentcol;
						}
						else
						{
							for(x=0;x<xsiz;x++)
								for(y=0;y<ysiz;y++)
									for(z=0;z<zsiz;z++)
										if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] == ch)
											voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = currentcol;
							if ((currentcol == 255) || (ch == 255)) calcvoxindeces();
						}
					}
				}
				if (keystatus[0x24]) //J (junk)
				{
					keystatus[0x24] = 0;
					if (voxindex >= 0)
					{
						if (showthrough == 0)
						{
							if (inawindow == 0)
								for(x=0;x<xsiz;x++)
									for(y=0;y<ysiz;y++)
										if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+viewz] == voxel[voxindex])
											if ((rand()&15) == 0)
												voxel[(x*MAXYSIZ+y)*MAXZSIZ+viewz] = currentcol;
							if (inawindow == 1)
								for(x=0;x<xsiz;x++)
									for(z=0;z<zsiz;z++)
										if (voxel[(x*MAXYSIZ+viewy)*MAXZSIZ+z] == voxel[voxindex])
											if ((rand()&15) == 0)
												voxel[(x*MAXYSIZ+viewy)*MAXZSIZ+z] = currentcol;
							if (inawindow == 2)
								for(y=0;y<ysiz;y++)
									for(z=0;z<zsiz;z++)
										if (voxel[(viewx*MAXYSIZ+y)*MAXZSIZ+z] == voxel[voxindex])
											if ((rand()&15) == 0)
												voxel[(viewx*MAXYSIZ+y)*MAXZSIZ+z] = currentcol;
						}
						else
						{
							for(x=0;x<xsiz;x++)
								for(y=0;y<ysiz;y++)
									for(z=0;z<zsiz;z++)
										if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] == voxel[voxindex])
											if ((rand()&15) == 0)
												voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = currentcol;
						}
					}
				}

				k = 0;  // <> darken/brighten rectangle
				if (keystatus[0x33]) { keystatus[0x33] = 0; k = -1; }
				if (keystatus[0x34]) { keystatus[0x34] = 0; k = 1; }
				if (k)
				{
					i = 256;
					if (inawindow == 0) i = 1;
					if (inawindow == 1) i = 2;
					if (inawindow == 2) i = 4;
					j = 512;
					if (markinawindow == 0) j = 1;
					if (markinawindow == 1) j = 2;
					if (markinawindow == 2) j = 4;
					if (!(i^j))
					{
						markx2 = ((searchx-wx1[inawindow])/wz[inawindow])*wz[inawindow]+wx1[inawindow];
						marky2 = ((searchy-wy1[inawindow])/wz[inawindow])*wz[inawindow]+wy1[inawindow];
						xx = ksgn(searchx-markx1);
						yy = ksgn(searchy-marky1);
						for(y=klabs(marky2-marky1)/wz[inawindow];y>=0;y--)
							for(x=klabs(markx2-markx1)/wz[inawindow];x>=0;x--)
							{
								i = getvoxindexunderpoint(markx1+x*xx*wz[inawindow],marky1+y*yy*wz[inawindow]);
								if ((i >= 0) && (voxel[i] != 255))
								{
									if ((voxel[i] != 255) && (voxel[i]+k != 255))
										voxel[i] += k;
								}
							}
					}
				}
				if (keystatus[0x14]) //T (trail)
				{
					keystatus[0x14] = 0;
					trailmode ^= 1;
					if (trailmode)
						trailwindow = inawindow;
					else
						trailwindow = -1;
				}
				if (keystatus[0xc9]) //PGUP
				{
					keystatus[0xc9] = 0;
					if (keystatus[0x9d])
					{
						if (inawindow == 0) zsiz = max(zsiz-1,1);
						if (inawindow == 1) ysiz = max(ysiz-1,1);
						if (inawindow == 2) xsiz = max(xsiz-1,1);
						getwindowborders();
					}
					else
					{
						if (inawindow == 0) viewz = max(viewz-1,0);
						if (inawindow == 1) viewy = max(viewy-1,0);
						if (inawindow == 2) viewx = max(viewx-1,0);
					}
				}
				if (keystatus[0xd1]) //PGDN
				{
					keystatus[0xd1] = 0;
					if (keystatus[0x9d])
					{
						if (inawindow == 0) zsiz = min(zsiz+1,MAXZSIZ);
						if (inawindow == 1) ysiz = min(ysiz+1,MAXYSIZ);
						if (inawindow == 2) xsiz = min(xsiz+1,MAXXSIZ);
						getwindowborders();
						calcvoxindeces();
					}
					else
					{
						if (inawindow == 0) viewz = min(viewz+1,zsiz-1);
						if (inawindow == 1) viewy = min(viewy+1,ysiz-1);
						if (inawindow == 2) viewx = min(viewx+1,xsiz-1);
					}
				}
				if (keystatus[0x13]) //R (rotate)
				{
					keystatus[0x13] = 0;
					if (keystatus[0x38]|keystatus[0xb8])  //Rubix cube rotate
					{
						if (inawindow == 0)
						{
							for(z=0;z<zsiz;z++)
							{
								for(x=0;x<xsiz;x++)
									for(y=0;y<(ysiz>>1);y++)
										swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+(ysiz-1-y))*MAXZSIZ+z]);
								for(x=0;x<max(xsiz,ysiz);x++)
									for(y=0;y<x;y++)
										swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(y*MAXYSIZ+x)*MAXZSIZ+z]);
							}
							ypivot = (ysiz<<8)-ypivot;
							swaplong(&xsiz,&ysiz);
							swaplong(&xpivot,&ypivot);
							getwindowborders();
						}
						if (inawindow == 1)
						{
							for(y=0;y<ysiz;y++)
							{
								for(x=0;x<xsiz;x++)
									for(z=0;z<(zsiz>>1);z++)
										swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+y)*MAXZSIZ+(zsiz-1-z)]);
								for(x=0;x<max(xsiz,zsiz);x++)
									for(z=0;z<x;z++)
										swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(z*MAXYSIZ+y)*MAXZSIZ+x]);
							}
							zpivot = (zsiz<<8)-zpivot;
							swaplong(&xsiz,&zsiz);
							swaplong(&xpivot,&zpivot);
							getwindowborders();
							calcvoxindeces();
						}
						if (inawindow == 2)
						{
							for(x=0;x<xsiz;x++)
							{
								for(y=0;y<ysiz;y++)
									for(z=0;z<(zsiz>>1);z++)
										swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+y)*MAXZSIZ+(zsiz-1-z)]);
								for(y=0;y<max(ysiz,zsiz);y++)
									for(z=0;z<y;z++)
										swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+z)*MAXZSIZ+y]);
							}
							zpivot = (zsiz<<8)-zpivot;
							swaplong(&ysiz,&zsiz);
							swaplong(&ypivot,&zpivot);
							getwindowborders();
							calcvoxindeces();
						}
					}
					else //2D rotate
					{
						if ((rotatemode == 255) && ((unsigned)inawindow < (unsigned)3))
							rotatemode = inawindow;
						else
							rotatemode = 255;
					}
				}
				if (rotatemode != 255)
				{
					if ((xsiz > 0) && (ysiz > 0) && (zsiz > 0))
					{
						while (1)
						{
							if (keystatus[1]|keystatus[0x13]|keystatus[0x1c]|keystatus[0x9c]) { rotatemode = 255; break; }
							bad = 0;
							if (keystatus[0xcb])
							{
								keystatus[0xcb] = 0;
								if (inawindow == 0)
								{
									if (showthrough == 0) i = j = viewz; else { i = 0; j = zsiz-1; }
									for(z=i;z<=j;z++)
										for(x=xsiz-2;x>=0;x--)
											for(y=ysiz-1;y>=0;y--)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(((x+1)%xsiz)*MAXYSIZ+y)*MAXZSIZ+z]);
								}
								if (inawindow == 1)
								{
									if (showthrough == 0) i = j = viewy; else { i = 0; j = ysiz-1; }
									for(y=i;y<=j;y++)
										for(x=xsiz-2;x>=0;x--)
											for(z=zsiz-1;z>=0;z--)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(((x+1)%xsiz)*MAXYSIZ+y)*MAXZSIZ+z]);
								}
								if (inawindow == 2)
								{
									if (showthrough == 0) i = j = viewx; else { i = 0; j = xsiz-1; }
									for(x=i;x<=j;x++)
										for(y=ysiz-2;y>=0;y--)
											for(z=zsiz-1;z>=0;z--)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+((y+1)%ysiz))*MAXZSIZ+z]);
								}
								bad = 1;
							}
							if (keystatus[0xcd])
							{
								keystatus[0xcd] = 0;
								if (inawindow == 0)
								{
									if (showthrough == 0) i = j = viewz; else { i = 0; j = zsiz-1; }
									for(z=i;z<=j;z++)
										for(x=1;x<xsiz;x++)
											for(y=0;y<ysiz;y++)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(((x+1)%xsiz)*MAXYSIZ+y)*MAXZSIZ+z]);
								}
								if (inawindow == 1)
								{
									if (showthrough == 0) i = j = viewy; else { i = 0; j = ysiz-1; }
									for(y=i;y<=j;y++)
										for(x=1;x<xsiz;x++)
											for(z=0;z<zsiz;z++)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(((x+1)%xsiz)*MAXYSIZ+y)*MAXZSIZ+z]);
								}
								if (inawindow == 2)
								{
									if (showthrough == 0) i = j = viewx; else { i = 0; j = xsiz-1; }
									for(x=i;x<=j;x++)
										for(y=1;y<ysiz;y++)
											for(z=0;z<zsiz;z++)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+((y+1)%ysiz))*MAXZSIZ+z]);
								}
								bad = 1;
							}
							if (keystatus[0xc8])
							{
								keystatus[0xc8] = 0;
								if (inawindow == 0)
								{
									if (showthrough == 0) i = j = viewz; else { i = 0; j = zsiz-1; }
									for(z=i;z<=j;z++)
										for(x=xsiz-1;x>=0;x--)
											for(y=ysiz-2;y>=0;y--)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+((y+1)%ysiz))*MAXZSIZ+z]);
								}
								if (inawindow == 1)
								{
									if (showthrough == 0) i = j = viewy; else { i = 0; j = ysiz-1; }
									for(y=i;y<=j;y++)
										for(x=xsiz-1;x>=0;x--)
											for(z=zsiz-2;z>=0;z--)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+y)*MAXZSIZ+((z+1)%zsiz)]);
								}
								if (inawindow == 2)
								{
									if (showthrough == 0) i = j = viewx; else { i = 0; j = xsiz-1; }
									for(x=i;x<=j;x++)
										for(y=ysiz-1;y>=0;y--)
											for(z=zsiz-2;z>=0;z--)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+y)*MAXZSIZ+((z+1)%zsiz)]);
								}
								bad = 1;
							}
							if (keystatus[0xd0])
							{
								keystatus[0xd0] = 0;
								if (inawindow == 0)
								{
									if (showthrough == 0) i = j = viewz; else { i = 0; j = zsiz-1; }
									for(z=i;z<=j;z++)
										for(x=0;x<xsiz;x++)
											for(y=1;y<ysiz;y++)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+((y+1)%ysiz))*MAXZSIZ+z]);
								}
								if (inawindow == 1)
								{
									if (showthrough == 0) i = j = viewy; else { i = 0; j = ysiz-1; }
									for(y=i;y<=j;y++)
										for(x=0;x<xsiz;x++)
											for(z=1;z<zsiz;z++)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+y)*MAXZSIZ+((z+1)%zsiz)]);
								}
								if (inawindow == 2)
								{
									if (showthrough == 0) i = j = viewx; else { i = 0; j = xsiz-1; }
									for(x=i;x<=j;x++)
										for(y=0;y<ysiz;y++)
											for(z=1;z<zsiz;z++)
												swapchar(&voxel[(x*MAXYSIZ+y)*MAXZSIZ+z],&voxel[(x*MAXYSIZ+y)*MAXZSIZ+((z+1)%zsiz)]);
								}
								bad = 1;
							}
							if (bad)
							{
								calcvoxindeces();
								break;
							}
						}
						keystatus[1] = keystatus[0x13] = keystatus[0x1c] = keystatus[0x9c] = 0;
					}
				}
				if (keystatus[0x2]) //1
				{
					keystatus[0x2] = 0;
					if ((inawindow >= 0) && (inawindow < 3))
					{
						markx1 = ((searchx-wx1[inawindow])/wz[inawindow])*wz[inawindow]+wx1[inawindow];
						marky1 = ((searchy-wy1[inawindow])/wz[inawindow])*wz[inawindow]+wy1[inawindow];
						markinawindow = inawindow;
					}
				}
				if (keystatus[0x3]) //2
				{
					keystatus[0x3] = 0;
					i = 256;
					if (inawindow == 0) i = 1;
					if (inawindow == 1) i = 2;
					if (inawindow == 2) i = 4;
					j = 512;
					if (markinawindow == 0) j = 1;
					if (markinawindow == 1) j = 2;
					if (markinawindow == 2) j = 4;
					if (!(i^j))
					{
						markx2 = ((searchx-wx1[inawindow])/wz[inawindow])*wz[inawindow]+wx1[inawindow];
						marky2 = ((searchy-wy1[inawindow])/wz[inawindow])*wz[inawindow]+wy1[inawindow];
						xx = ksgn(markx2-markx1);
						yy = ksgn(marky2-marky1);
						markx2 = klabs(markx2-markx1)/wz[inawindow];
						marky2 = klabs(marky2-marky1)/wz[inawindow];
						for(y=0;y<=marky2;y++)
							for(x=0;x<=markx2;x++)
							{
								i = getvoxindexunderpoint(markx1+xx*x*wz[inawindow],marky1+yy*y*wz[inawindow]);
								if (i >= 0) tempbuf[y*MAXZSIZ+x] = voxel[i];
										 else tempbuf[y*MAXZSIZ+x] = 255;
							}
					}
				}
				if (keystatus[0x4]) //3
				{
					for(y=0;y<=marky2;y++)
						for(x=0;x<=markx2;x++)
						{
							i = getvoxindexunderpoint(searchx+x*wz[inawindow],searchy+y*wz[inawindow]);
							if ((i >= 0) && (tempbuf[y*MAXZSIZ+x] != 255))
								voxel[i] = tempbuf[y*MAXZSIZ+x];
						}
					calcvoxindeces();
				}
				k = 0;
				if (keystatus[0xc7]) { keystatus[0xc7] = 0; k = -1; }  //Home
				if (keystatus[0xcf]) { keystatus[0xcf] = 0; k = 1; }   //End
				if (k)
				{
					i = 256;
					if (inawindow == 0) i = 1;
					if (inawindow == 1) i = 2;
					if (inawindow == 2) i = 4;
					j = 512;
					if (markinawindow == 0) j = 1;
					if (markinawindow == 1) j = 2;
					if (markinawindow == 2) j = 4;
					if (!(i^j))
					{
						if (showthrough == 0)
						{
							if (j == 1) k *= 1;
							if (j == 2) k *= MAXZSIZ;
							if (j == 4) k *= MAXYSIZ*MAXZSIZ;

							if (((k != -MAXYSIZ*MAXZSIZ) || (viewx != 0)) &&
								 ((k != MAXYSIZ*MAXZSIZ) || (viewx != xsiz-1)) &&
								 ((k != -MAXZSIZ) || (viewy != 0)) &&
								 ((k != MAXZSIZ) || (viewy != ysiz-1)) &&
								 ((k != -1) || (viewz != 0)) &&
								 ((k != 1) || (viewz != zsiz-1)))
							{
								markx2 = ((searchx-wx1[inawindow])/wz[inawindow])*wz[inawindow]+wx1[inawindow];
								marky2 = ((searchy-wy1[inawindow])/wz[inawindow])*wz[inawindow]+wy1[inawindow];
								xx = min(markx1,markx2);
								yy = min(marky1,marky2);
								markx2 = klabs(markx2-markx1)/wz[inawindow];
								marky2 = klabs(marky2-marky1)/wz[inawindow];
								for(y=0;y<=marky2;y++)
									for(x=0;x<=markx2;x++)
									{
										i = getvoxindexunderpoint(xx+x*wz[inawindow],yy+y*wz[inawindow]); if (i < 0) continue;
										if (voxel[i] != 255)
										{
											voxel[i+k] = voxel[i];
											voxel[i] = 255;
										}
									}
							}
						}
					}
					calcvoxindeces();
				}
			}
		}

		if (keystatus[0x52]) //Keyp.0
		{
			keystatus[0x52] = 0;
			compileallmips();      //Update changes
		}

		if (keystatus[0x23]&(keystatus[0x38]|keystatus[0xb8])) //ALT-H (hollow fill)
		{
			keystatus[0x23] = 0;
			if (!edit2dmode)
			{
				for(i=0;i<256;i++) tempbuf[i] = 0;

				for(x=0;x<xsiz;x++)
					for(y=0;y<ysiz;y++)
						for(z=0;z<zsiz;z++)
							tempbuf[voxel[(x*MAXYSIZ+y)*MAXZSIZ+z]] = 1;

				for(i=254;i>=0;i--)
					if (!tempbuf[i])
					{
						ch = i;
						for(x=0;x<xsiz;x++)
							for(y=0;y<ysiz;y++)
								for(z=0;z<zsiz;z++)
									if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] == 255)
										voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = ch;

						for(x=0;x<xsiz;x++)
							for(y=0;y<ysiz;y++)
							{
								floodfill3d(x,y,0L,255,ch);
								floodfill3d(x,y,zsiz-1L,255,ch);
							}
						for(x=0;x<xsiz;x++)
							for(z=0;z<zsiz;z++)
							{
								floodfill3d(x,0L,z,255,ch);
								floodfill3d(x,ysiz-1L,z,255,ch);
							}
						for(y=0;y<ysiz;y++)
							for(z=0;z<zsiz;z++)
							{
								floodfill3d(0L,y,z,255,ch);
								floodfill3d(xsiz-1L,y,z,255,ch);
							}

						compileallmips();
						break;
					}
			}
		}

		if (keystatus[0x9c])
		{
			keystatus[0x9c] = 0;
			if (!edit2dmode)
			{
				if (voxelhitscan(searchx,searchy,&hitx,&hity,&hitz))
				{
					viewx = min(max(hitx,0),xsiz-1);
					viewy = min(max(hity,0),ysiz-1);
					viewz = min(max(hitz,0),zsiz-1);
				}
				if ((showthrough == 1) || (showthrough == 2))
					calcvoxindeces();
			}
			else
				compileallmips();      //Update changes
			edit2dmode ^= 1;
		}

		lockspeed = totalclock-baktotalclock;
		baktotalclock += lockspeed;

		numframes++;

		if (keystatus[1])
		{
			keystatus[1] = 0;
			printext256((XDIM-30*8L)>>1,(YDIM>>1)-4L,whitecol,0,"Are you sure you want to quit?",0);

			if (maxpages <= 1) copyandclearbuf(frameplace,0xa0000,XDIM*YDIM>>2);
			while (!(keystatus[1]|keystatus[0x1c]|keystatus[0x39]|keystatus[0x31]))
			{
				if (keystatus[0x15]) { keystatus[1] = 2; break; }
			}
		}
	}

	uninitkeys();
	uninittimer42();
	uninittimer();

	chdir(curpath);

	if (maxpages > 1) uninitvesa();
	setvmode(0x3);

	printf("\tDimensions:\tUncomp size:\tRLE size:\n");
	j = 0;
	for(i=0;i<MAXVOXMIPS;i++)
	{
		printf("Mip %ld:\t",i);
		longptr = (long *)voxoff[0][i];
		if (!longptr)
		{
			printf("WARNING - MISSING THIS MIP LEVEL!\n");
		}
		else
		{
			printf("%3ld*%3ld*%3ld\t",longptr[0],longptr[1],longptr[2]);
			printf("%8ld\t",longptr[0]*longptr[1]*longptr[2]);
			printf("%8ld\n",longptr[longptr[0]+6]+(4*7));
			j += longptr[longptr[0]+6]+(4*7);
		}
	}
	if (starttile >= 0) printf("\nMemory in ART file: %ld (%ld*%ld*%ld)",tilesizx[starttile]*tilesizy[starttile]*numrotations,tilesizx[starttile],tilesizy[starttile],numrotations);
	printf("\nMemory in KVX file: %ld (doesn't include palette)\n",j);
}

drawwindow(long w)
{
	long i, j, k, x, y, z, sx, sy, xx, yy, zz, x1, y1, x2, y2, daz, ptr2inc;
	long bx, by, startx, dax1, day1, dax2, day2, dainc;
	char ch, *ptr, *ptr2, dabuf[64];

	x1 = wx1[w]; y1 = wy1[w];
	x2 = wx2[w]; y2 = wy2[w];
	daz = wz[w];

	if (w == 3)
	{
		for(k=0;k<256;k++)
		{
			x = ((k&31)*daz)+x1; y = ((k>>5)*daz)+y1;

			ch = (char)k;
			if ((numframes&4) && (currentcol == k)) ch = (numframes&255);

			for(sy=y+daz-1;sy>=y;sy--)
				if ((unsigned)sy < (unsigned)YDIM)
					for(sx=x+daz-1;sx>=x;sx--)
						if ((unsigned)sx < (unsigned)XDIM)
							*(char *)(frameplace+ylookup[sy]+sx) = ch;
		}
		return;
	}

	dax1 = max(x1,0); dax2 = min(x1+(x2-x1)*daz,XDIM);
	day1 = max(y1,0); day2 = min(y1+(y2-y1)*daz,YDIM);
	dainc = (1<<16) / daz;
	by = (day1-y1) * dainc;
	startx = (dax1-x1) * dainc;

	if (adjustpivotmode)
	{
		sprintf(dabuf,"Xpiv:%ld/%ld",xpivot>>8,xsiz);
		printext256(0L,12L,whitecol,-1,dabuf,1);

		sprintf(dabuf,"Ypiv:%ld/%ld",ypivot>>8,ysiz);
		printext256(0L,18L,whitecol,-1,dabuf,1);

		sprintf(dabuf,"Zpiv:%ld/%ld",zpivot>>8,zsiz);
		printext256(0L,24L,whitecol,-1,dabuf,1);
	}

	switch(showthrough)
	{
		case 0:
			switch(w)
			{
				case 0: sprintf(dabuf,"Z:%ld/%ld",viewz,zsiz); ptr2inc = -MAXYSIZ*MAXZSIZ; break;
				case 1: sprintf(dabuf,"Y:%ld/%ld",viewy,ysiz); ptr2inc = -MAXYSIZ*MAXZSIZ; break;
				case 2: sprintf(dabuf,"X:%ld/%ld",viewx,xsiz); ptr2inc = -MAXZSIZ; break;
			}
			if ((x1 >= 0) && (x1 < XDIM-strlen(dabuf)*4) && (y1-6 >= 0) && (y1 < YDIM))
				printext256(x1,y1-6,whitecol,-1,dabuf,1);

			switch(w)
			{
				case 0:
					for(y=day1;y<day2;y++)
					{
						bx = startx;
						ptr = (char *)(frameplace+ylookup[y]+dax1);
						ptr2 = (char *)&voxel[(by>>16)*MAXZSIZ+viewz];
						for(x=dax1;x<dax2;x++)
						{
							*ptr++ = ptr2[(bx>>16)*MAXYSIZ*MAXZSIZ];
							bx += dainc;
						}
						by += dainc;
					}
					break;
				case 1:
					for(y=day1;y<day2;y++)
					{
						bx = startx;
						ptr = (char *)(frameplace+ylookup[y]+dax1);
						ptr2 = (char *)&voxel[viewy*MAXZSIZ+(by>>16)];
						for(x=dax1;x<dax2;x++)
						{
							*ptr++ = ptr2[(bx>>16)*MAXYSIZ*MAXZSIZ];
							bx += dainc;
						}
						by += dainc;
					}
					break;
				case 2:
					for(y=day1;y<day2;y++)
					{
						bx = startx;
						ptr = (char *)(frameplace+ylookup[y]+dax1);
						ptr2 = (char *)&voxel[viewx*MAXYSIZ*MAXZSIZ+(by>>16)];
						for(x=dax1;x<dax2;x++)
						{
							*ptr++ = ptr2[(bx>>16)*MAXZSIZ];
							bx += dainc;
						}
						by += dainc;
					}
					break;
			}
			break;
		case 1: case 2:
			switch(w)
			{
				case 0:
					for(y=day1;y<day2;y++)
					{
						bx = startx; i = (by>>16);
						ptr = (char *)(frameplace+ylookup[y]+dax1);
						ptr2 = (char *)&voxel[i*MAXZSIZ];
						i *= MAXXSIZ;
						for(x=dax1;x<dax2;x++)
						{
							*ptr++ = ptr2[(bx>>16)*MAXYSIZ*MAXZSIZ+voxixy[i+(bx>>16)]];
							bx += dainc;
						}
						by += dainc;
					}
					break;
				case 1:
					for(y=day1;y<day2;y++)
					{
						bx = startx; i = (by>>16);
						ptr = (char *)(frameplace+ylookup[y]+dax1);
						ptr2 = (char *)&voxel[i];
						i *= MAXXSIZ;
						for(x=dax1;x<dax2;x++)
						{
							*ptr++ = ptr2[(bx>>16)*MAXYSIZ*MAXZSIZ+voxixz[i+(bx>>16)]*MAXZSIZ];
							bx += dainc;
						}
						by += dainc;
					}
					break;
				case 2:
					for(y=day1;y<day2;y++)
					{
						bx = startx; i = (by>>16);
						ptr = (char *)(frameplace+ylookup[y]+dax1);
						ptr2 = (char *)&voxel[i];
						i *= MAXXSIZ;
						for(x=dax1;x<dax2;x++)
						{
							*ptr++ = ptr2[(voxiyz[i+(bx>>16)]*MAXYSIZ+(bx>>16))*MAXZSIZ];
							bx += dainc;
						}
						by += dainc;
					}
					break;
			}
			break;
	}
	if (adjustpivotmode)
	{
		switch(w)
		{
			case 0:
				for(y=(y2-y1)*daz-1;y>=0;y--)
					if (((unsigned)(y+y1) < (unsigned)YDIM) && ((unsigned)((xpivot*daz>>8)+x1) < (unsigned)XDIM))
						*(char *)(frameplace+ylookup[y+y1]+(xpivot*daz>>8)+x1) = (rand()&255);
				for(x=(x2-x1)*daz-1;x>=0;x--)
					if (((unsigned)((ypivot*daz>>8)+y1) < (unsigned)YDIM) && ((unsigned)(x+x1) < (unsigned)XDIM))
						*(char *)(frameplace+ylookup[(ypivot*daz>>8)+y1]+x+x1) = (rand()&255);
				break;
			case 1:
				for(y=(y2-y1)*daz-1;y>=0;y--)
					if (((unsigned)(y+y1) < (unsigned)YDIM) && ((unsigned)((xpivot*daz>>8)+x1) < (unsigned)XDIM))
						*(char *)(frameplace+ylookup[y+y1]+(xpivot*daz>>8)+x1) = (rand()&255);
				for(x=(x2-x1)*daz-1;x>=0;x--)
					if (((unsigned)((zpivot*daz>>8)+y1) < (unsigned)YDIM) && ((unsigned)(x+x1) < (unsigned)XDIM))
						*(char *)(frameplace+ylookup[(zpivot*daz>>8)+y1]+x+x1) = (rand()&255);
				break;
			case 2:
				for(y=(y2-y1)*daz-1;y>=0;y--)
					if (((unsigned)(y+y1) < (unsigned)YDIM) && ((unsigned)((ypivot*daz>>8)+x1) < (unsigned)XDIM))
						*(char *)(frameplace+ylookup[y+y1]+(ypivot*daz>>8)+x1) = (rand()&255);
				for(x=(x2-x1)*daz-1;x>=0;x--)
					if (((unsigned)((zpivot*daz>>8)+y1) < (unsigned)YDIM) && ((unsigned)(x+x1) < (unsigned)XDIM))
						*(char *)(frameplace+ylookup[(zpivot*daz>>8)+y1]+x+x1) = (rand()&255);
				break;
		}
	}
}

getwindowborders()
{
	wz[0] = wz[1] = wz[2] = 1; wz[3] = 4;

	wx1[0] = 0;         wy1[0] = 8;         wx2[0] = xsiz; wy2[0] = ysiz+8;
	wx1[1] = 0;         wy1[1] = YDIM-zsiz; wx2[1] = xsiz; wy2[1] = YDIM;
	wx1[2] = XDIM-ysiz; wy1[2] = YDIM-zsiz; wx2[2] = XDIM; wy2[2] = YDIM;

	if (wy2[0] < wy1[1]-8)
	{
		wy1[0] += (wy1[1]-8)-wy2[0];
		wy2[0] += (wy1[1]-8)-wy2[0];
	}
	if (wx1[2] > wx2[1]+8)
	{
		wx1[2] = wx2[1]+8;
		wx2[2] = wx1[2]+ysiz;
	}

	if (wx2[2]+8 < XDIM-32*wz[3])
		{ wx1[3] = wx2[2]+8; wy1[3] = YDIM-8*wz[3]; }
	else
		{ wx1[3] = XDIM-32*wz[3]; wy1[3] = 8; }
	wx2[3] = wx1[3]+32; wy2[3] = wy1[3]+8;

	wndorder[0] = 0;
	wndorder[1] = 1;
	wndorder[2] = 2;
	wndorder[3] = 3;
}

getvoxindexunderpoint(long dax, long day)
{
	long i, j, k, w, ww, x1, y1, x2, y2, daz;

	for(ww=0;ww<numwindows;ww++)
	{
		w = wndorder[ww];

		x1 = wx1[w]; y1 = wy1[w];
		x2 = wx2[w]; y2 = wy2[w];
		daz = wz[w];

		if ((dax < x1) || (day < y1) || (dax >= x1+(x2-x1)*daz) || (day >= y1+(y2-y1)*daz)) continue;

		switch(w)
		{
			case 0:
				if (showthrough == 0) return((((dax-x1)/daz)*MAXYSIZ+((day-y1)/daz))*MAXZSIZ+viewz);
				if (showthrough == 1) { i = (((dax-x1)/daz)*MAXYSIZ+((day-y1)/daz))*MAXZSIZ+0; k = 1; }
									  else { i = (((dax-x1)/daz)*MAXYSIZ+((day-y1)/daz))*MAXZSIZ+(zsiz-1); k = -1; }
				for(j=zsiz-1;j>=0;j--)
				{
					if (voxel[i] != 255) return(i);
					i += k;
				}
				break;
			case 1:
				if (showthrough == 0) return((((dax-x1)/daz)*MAXYSIZ+viewy)*MAXZSIZ+((day-y1)/daz));
				if (showthrough == 1) { i = (((dax-x1)/daz)*MAXYSIZ+0)*MAXZSIZ+((day-y1)/daz); k = MAXZSIZ; }
									  else { i = (((dax-x1)/daz)*MAXYSIZ+(ysiz-1))*MAXZSIZ+((day-y1)/daz); k = -MAXZSIZ; }
				for(j=ysiz-1;j>=0;j--)
				{
					if (voxel[i] != 255) return(i);
					i += k;
				}
				break;
			case 2:
				if (showthrough == 0) return((viewx*MAXYSIZ+((dax-x1)/daz))*MAXZSIZ+((day-y1)/daz));
				if (showthrough == 1) { i = (0*MAXYSIZ+((dax-x1)/daz))*MAXZSIZ+((day-y1)/daz); k = MAXYSIZ*MAXZSIZ; }
									  else { i = ((xsiz-1)*MAXYSIZ+((dax-x1)/daz))*MAXZSIZ+((day-y1)/daz); k = -MAXYSIZ*MAXZSIZ; }
				for(j=xsiz-1;j>=0;j--)
				{
					if (voxel[i] != 255) return(i);
					i += k;
				}
				break;
		}
	}
	return(-1);
}

calcvoxindeces()
{
	long i, x, y, z;

	if (edit2dmode == 0) return;
	if (showthrough == 1)
	{
		for(x=wx2[0]-wx1[0]-1;x>=0;x--)
			for(y=wy2[0]-wy1[0]-1;y>=0;y--)
			{
				i = (x*MAXYSIZ+y)*MAXZSIZ+0;
				for(z=0;z<zsiz-1;z++)
				{
					if (voxel[i] != 255) break;
					i++;
				}
				voxixy[y*MAXXSIZ+x] = z;
			}

		for(x=wx2[1]-wx1[1]-1;x>=0;x--)
			for(z=wy2[1]-wy1[1]-1;z>=0;z--)
			{
				i = (x*MAXYSIZ+0)*MAXZSIZ+z;
				for(y=0;y<ysiz-1;y++)
				{
					if (voxel[i] != 255) break;
					i += MAXZSIZ;
				}
				voxixz[z*MAXXSIZ+x] = y;
			}

		for(y=wx2[2]-wx1[2]-1;y>=0;y--)
			for(z=wy2[2]-wy1[2]-1;z>=0;z--)
			{
				i = (0*MAXYSIZ+y)*MAXZSIZ+z;
				for(x=0;x<xsiz-1;x++)
				{
					if (voxel[i] != 255) break;
					i += MAXYSIZ*MAXZSIZ;
				}
				voxiyz[z*MAXYSIZ+y] = x;
			}
	}
	if (showthrough == 2)
	{
		for(x=wx2[0]-wx1[0]-1;x>=0;x--)
			for(y=wy2[0]-wy1[0]-1;y>=0;y--)
			{
				i = (x*MAXYSIZ+y)*MAXZSIZ+(zsiz-1);
				for(z=zsiz-1;z>0;z--)
				{
					if (voxel[i] != 255) break;
					i--;
				}
				voxixy[y*MAXXSIZ+x] = z;
			}

		for(x=wx2[1]-wx1[1]-1;x>=0;x--)
			for(z=wy2[1]-wy1[1]-1;z>=0;z--)
			{
				i = (x*MAXYSIZ+(ysiz-1))*MAXZSIZ+z;
				for(y=ysiz-1;y>0;y--)
				{
					if (voxel[i] != 255) break;
					i -= MAXZSIZ;
				}
				voxixz[z*MAXXSIZ+x] = y;
			}

		for(y=wx2[2]-wx1[2]-1;y>=0;y--)
			for(z=wy2[2]-wy1[2]-1;z>=0;z--)
			{
				i = ((xsiz-1)*MAXYSIZ+y)*MAXZSIZ+z;
				for(x=xsiz-1;x>0;x--)
				{
					if (voxel[i] != 255) break;
					i -= MAXYSIZ*MAXZSIZ;
				}
				voxiyz[z*MAXYSIZ+y] = x;
			}
	}
}

art2vox(char *dafilename)
{
	long fil, x, y, z, xs, ys, zs, i, j, k, l, *longptr;
	long version, numtiles, localtilestart, localtileend, tileoffs;
	char ch, ch2;
	signed char a[64], b[64], binorder[64], cnt, np, c, e;

	if ((fil = open(dafilename,O_BINARY|O_RDWR,S_IREAD)) == -1)
		return(-1);

	read(fil,&version,4);
	read(fil,&numtiles,4);
	read(fil,&localtilestart,4);
	read(fil,&localtileend,4);
	read(fil,tilesizx,(localtileend-localtilestart+1)<<1);
	read(fil,tilesizy,(localtileend-localtilestart+1)<<1);
	read(fil,picanm,(localtileend-localtilestart+1)<<2);

	tileoffs = 0;
	for(j=0;j<starttile;j++) tileoffs += tilesizx[j]*tilesizy[j];

	xsiz = tilesizx[starttile];
	ysiz = tilesizx[starttile];
	zsiz = tilesizy[starttile];

	xpivot = (xsiz<<7); ypivot = (ysiz<<7); zpivot = (zsiz<<7);

	clearbufbyte(voxel,MAXXSIZ*MAXYSIZ*MAXZSIZ,0L);

	xs = tilesizx[starttile]; ys = tilesizy[starttile];
	for(i=0;i<numrotations;i++)  //i<klabs(totrotations>>1)
	{
		printf("Chop %ld...\n",i);
		lseek(fil,16+((localtileend-localtilestart+1)<<3)+i*xs*ys+tileoffs,SEEK_SET);
		if (i == klabs(totrotations)+1) lseek(fil,xs*(xs-ys),SEEK_CUR);
		if (i >= klabs(totrotations)) read(fil,tempbuf,xs*xs);
										 else read(fil,tempbuf,xs*ys);
		chopvoxels(i);
	}

	binorder[0] = 0; cnt = 1;
	if (klabs(totrotations) > 1)
	{
		a[0] = 1; b[0] = klabs(totrotations)-1; c = 0; e = 1;
		do
		{
			np = ((a[c]+b[c])>>1); binorder[cnt++] = np;
			if (a[c] < np) { a[e] = a[c]; b[e] = np-1; e++; }
			if (np < b[c]) { a[e] = np+1; b[e] = b[c]; e++; }
			c++;
		} while (c < e);
	}
	if (numrotations > klabs(totrotations))
	{
		for(i=cnt-1;i>=4;i--)
			binorder[i+numrotations-klabs(totrotations)] = binorder[i];
		for(i=0;i<numrotations-klabs(totrotations);i++)
			binorder[i+4] = i+klabs(totrotations);
		cnt += numrotations-klabs(totrotations);
	}
	//for(i=klabs(totrotations);i<numrotations;i++) binorder[cnt++] = i;

	for(cnt--;cnt>=0;cnt--)
	{
		i = binorder[cnt];
		if (i < numrotations)
		{
			printf("Paint %ld...\n",i);
			lseek(fil,16+((localtileend-localtilestart+1)<<3)+i*xs*ys+tileoffs,SEEK_SET);
			if (i == klabs(totrotations)+1) lseek(fil,xs*(xs-ys),SEEK_CUR);
			if (i >= klabs(totrotations)) read(fil,tempbuf,xs*xs);
											 else read(fil,tempbuf,xs*ys);
			paintvoxels(i);
		}
	}
	close(fil);

	printf("Rando-colors...\n");
	for(x=0;x<xsiz;x++)
		for(y=0;y<ysiz;y++)
		{
			i = (x*MAXYSIZ+y)*MAXZSIZ+0;
			for(z=0;z<zsiz;z++,i++)
			{
				if (voxel[i] != 0) continue;

				if ((x == 0) || (x == xsiz-1)) goto startrando;
				if ((y == 0) || (y == ysiz-1)) goto startrando;
				if ((z == 0) || (z == zsiz-1)) goto startrando;
				if (voxel[i-MAXYSIZ*MAXZSIZ] == 255) goto startrando;
				if (voxel[i+MAXYSIZ*MAXZSIZ] == 255) goto startrando;
				if (voxel[i-MAXZSIZ] == 255) goto startrando;
				if (voxel[i+MAXZSIZ] == 255) goto startrando;
				if (voxel[i-1] == 255) goto startrando;
				if (voxel[i+1] == 255) goto startrando;
				continue;
startrando:
				for(j=3;j<25;j+=2)
				{
					l = (j>>1);
					ch = 255;
					for(k=16;k>0;k--)
					{
						ch2 = voxel[i+((mulscale16(krand(),j)-l)*MAXYSIZ+
											(mulscale16(krand(),j)-l))*MAXZSIZ+
											(mulscale16(krand(),j)-l)];
						if ((char)(ch2-1) < 254)
						{
							if (ch == 255)
								ch = ch2;
							else
								ch = transluc[(((long)ch)<<8)+ch2];
						}
					}
					if (ch != 255) { voxel[i] = ch; break; }
				}
			}
		}

	printf("Optimize edges...\n");
	optimizeedges();

	zpivot = (zsiz<<7);

	compileallmips();
	longptr = (long *)voxoff[0][0];
	xsiz = longptr[0]; ysiz = longptr[1]; zsiz = longptr[2];
	xpivot = longptr[3]; ypivot = longptr[4]; zpivot = longptr[5];

	return(0);
}

chopvoxels(long i)
{
	long x, y, z, xx, yy, xs, ys, j, k, l, cosang, sinang, dasprang;

	xs = tilesizx[starttile]; ys = tilesizy[starttile];

	if (i == klabs(totrotations))
	{
		for(x=0;x<xsiz;x++)
			for(y=0;y<xsiz;y++)
				if (tempbuf[x*xs+y] == 255)
					for(z=0;z<zsiz;z++)
						voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = 255;
		return;
	}
	if (i == klabs(totrotations)+1)
	{
		for(x=0;x<xsiz;x++)
			for(y=0;y<xsiz;y++)
				if (tempbuf[x*xs+y] == 255)
					for(z=0;z<zsiz;z++)
						voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = 255;
		return;
	}

	dasprang = scale(i,2048,totrotations);
	cosang = sintable[(dasprang+512)&2047];
	sinang = sintable[dasprang&2047];

	clearbuf(FP_OFF(plistcnt),xsiz*sizeof(plistcnt[0])>>2,0L);
	for(xx=0;xx<xsiz;xx++)
	{
		j = cosang*((xx<<1)+1-xsiz) - sinang*(1-ysiz) + (xs<<14);
		for(yy=0;yy<ysiz;yy++)
		{
			k = (j>>15); j -= (sinang<<1);
			if ((k >= 0) && (k < xs))
			{
				l = k*(xsiz+ysiz)+plistcnt[k];
				plistx[l] = (char)xx;
				plisty[l] = (char)yy;
				plistcnt[k]++;
			}
			else
			{
				for(y=0;y<ys;y++)
					voxel[(xx*MAXYSIZ+yy)*MAXZSIZ+y] = 255;
			}
			if (ys < zsiz)
				for(y=ys;y<zsiz;y++)
					voxel[(xx*MAXYSIZ+yy)*MAXZSIZ+y] = 255;
		}
	}

	for(x=0;x<xs;x++)
	{
		k = x*(xsiz+ysiz);
		for(y=0;y<ys;y++)
			if (tempbuf[x*ys+y] == 255)
				for(j=plistcnt[x]+k-1;j>=k;j--)
					voxel[((long)plistx[j]*MAXYSIZ+(long)plisty[j])*MAXZSIZ+y] = 255;
	}
}

paintvoxels(long i)
{
	long fil, x, y, z, xx, yy, zz, xs, ys, j, k, l;
	long cosang, sinang, dasprang, max1, max2, maxhit1, maxhit2;
	char ch;

	xs = tilesizx[starttile]; ys = tilesizy[starttile];

	if (i == klabs(totrotations))
	{
		for(x=0;x<xsiz;x++)
			for(y=0;y<xsiz;y++)
			{
				ch = tempbuf[x*xs+y]; if (ch == 255) continue;
				for(z=0;z<zsiz;z++)
					if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != 255)
					{
						max1 = (x*MAXYSIZ+y)*MAXZSIZ+z;
						if (voxel[max1]) voxel[max1] = transluc[((long)ch)+(((long)voxel[max1])<<8)];
										else voxel[max1] = ch;
						break;
					}
			}
		return;
	}
	if (i == klabs(totrotations)+1)
	{
		for(x=0;x<xsiz;x++)
			for(y=0;y<xsiz;y++)
			{
				ch = tempbuf[x*xs+y]; if (ch == 255) continue;
				for(z=zsiz-1;z>=0;z--)
					if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != 255)
					{
						max1 = (x*MAXYSIZ+y)*MAXZSIZ+z;
						if (voxel[max1]) voxel[max1] = transluc[((long)ch)+(((long)voxel[max1])<<8)];
										else voxel[max1] = ch;
						break;
					}
			}
		return;
	}

	dasprang = scale(i,2048,totrotations);
	cosang = sintable[(dasprang+512)&2047];
	sinang = sintable[dasprang&2047];

	clearbuf(plistcnt,xsiz*sizeof(plistcnt[0])>>2,0L);
	for(xx=0;xx<xsiz;xx++)
	{
		j = cosang*(xx-(xpivot>>8)) - sinang*(0-(ypivot>>8)) + (xs<<13);
		for(yy=0;yy<ysiz;yy++)
		{
			k = (j>>14); j -= sinang;
			if ((k >= 0) && (k < xsiz))
			{
				l = k*(xsiz+ysiz)+plistcnt[k];
				plistx[l] = (char)xx; plisty[l] = (char)yy; plistcnt[k]++;
			}
		}
	}

	for(x=0;x<xs;x++)
	{
		k = x*(xsiz+ysiz);
		for(y=0;y<ys;y++)
		{
			ch = tempbuf[x*ys+y]; if (ch == 255) continue;
			maxhit1 = maxhit2 = 0x80000000;

			for(j=plistcnt[x]+k-1;j>=k;j--)
			{
				xx = (long)plistx[j]; yy = (long)plisty[j];

				if (voxel[(xx*MAXYSIZ+yy)*MAXZSIZ+y] == 255) continue;
				l = cosang*yy+sinang*xx;
				if (l > maxhit2)
				{
					if (l > maxhit1)
					{
						maxhit2 = maxhit1; max2 = max1;
						maxhit1 = l; max1 = (xx*MAXYSIZ+yy)*MAXZSIZ+y;
					}
					else
						{ maxhit2 = l; max2 = (xx*MAXYSIZ+yy)*MAXZSIZ+y; }
				}
			}
			if (maxhit1 != 0x80000000)
			{
				if (voxel[max1]) voxel[max1] = transluc[((long)ch)+(((long)voxel[max1])<<8)];
								else voxel[max1] = ch;
			}
			if (maxhit2 != 0x80000000)
			{
				if (voxel[max2]) voxel[max2] = transluc[((long)ch)+(((long)voxel[max2])<<8)];
								else voxel[max2] = ch;
			}
		}
	}
}

mipit()
{
	long x, y, z, i, j, v[8];

	if (xsiz&1)
	{
		for(y=0;y<ysiz;y++)
			for(z=0;z<zsiz;z++)
				voxel[(xsiz*MAXYSIZ+y)*MAXZSIZ+z] = voxel[((xsiz-1)*MAXYSIZ+y)*MAXZSIZ+z];
		xsiz++;
	}
	if (ysiz&1)
	{
		for(x=0;x<xsiz;x++)
			for(z=0;z<zsiz;z++)
				voxel[(x*MAXYSIZ+ysiz)*MAXZSIZ+z] = voxel[(x*MAXYSIZ+(ysiz-1))*MAXZSIZ+z];
		ysiz++;
	}
	if (zsiz&1)
	{
		for(x=0;x<xsiz;x++)
			for(y=0;y<ysiz;y++)
				voxel[(x*MAXYSIZ+y)*MAXZSIZ+zsiz] = voxel[(x*MAXYSIZ+y)*MAXZSIZ+(zsiz-1)];
		zsiz++;
	}

	xpivot >>= 1; ypivot >>= 1; zpivot >>= 1;
	xsiz >>= 1; ysiz >>= 1; zsiz >>= 1;

	for(x=0;x<xsiz;x++)
		for(y=0;y<ysiz;y++)
			for(z=0;z<zsiz;z++)
			{
				i = ((x<<1)*MAXYSIZ+(y<<1))*MAXZSIZ+(z<<1);
				v[0] = (long)voxel[i                          ];
				v[1] = (long)voxel[i                        +1];
				v[2] = (long)voxel[i                +MAXZSIZ  ];
				v[3] = (long)voxel[i                +MAXZSIZ+1];
				v[4] = (long)voxel[i+MAXYSIZ*MAXZSIZ          ];
				v[5] = (long)voxel[i+MAXYSIZ*MAXZSIZ        +1];
				v[6] = (long)voxel[i+MAXYSIZ*MAXZSIZ+MAXZSIZ  ];
				v[7] = (long)voxel[i+MAXYSIZ*MAXZSIZ+MAXZSIZ+1];

				j = 0;
				for(i=0;i<8;i++) if (v[i] == 255) j++;
				if (j >= 5) { voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = 255; continue; }

				for(j=0;j<8;j++)
				{
					i = ((x<<1)*MAXYSIZ+(y<<1))*MAXZSIZ+(z<<1);
					if (j&4) i += MAXYSIZ*MAXZSIZ;
					if (j&2) i += MAXZSIZ;
					if (j&1) i++;

					if (v[j] == 255) continue;

					if ((x == 0) && (!(j&4))) continue;
					if ((y == 0) && (!(j&2))) continue;
					if ((z == 0) && (!(j&1))) continue;
					if ((x<<1)+((j&4)>>2)+1 >= (xsiz<<1)) continue;
					if ((y<<1)+((j&2)>>1)+1 >= (ysiz<<1)) continue;
					if ((z<<1)+((j&1)>>0)+1 >= (zsiz<<1)) continue;

					if (voxel[i-1] == 255) continue;
					if (voxel[i+1] == 255) continue;
					if (voxel[i-MAXZSIZ] == 255) continue;
					if (voxel[i+MAXZSIZ] == 255) continue;
					if (voxel[i-MAXYSIZ*MAXZSIZ] == 255) continue;
					if (voxel[i+MAXYSIZ*MAXZSIZ] == 255) continue;

					v[j] = 255;
				}

				j = 0;
				for(i=0;i<8;i++) if (v[i] == 255) j++;
				if (j == 8) { voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = 0; continue; }

				for(i=0;i<8;i++)
					while (v[i] == 255) v[i] = v[krand()&7];

				i = (krand()&4); v[0] = transluc[v[0+i]+(v[4-i]<<8)];
				i = (krand()&4); v[1] = transluc[v[1+i]+(v[5-i]<<8)];
				i = (krand()&4); v[2] = transluc[v[2+i]+(v[6-i]<<8)];
				i = (krand()&4); v[3] = transluc[v[3+i]+(v[7-i]<<8)];

				i = (krand()&2); v[0] = transluc[v[0+i]+(v[2-i]<<8)];
				i = (krand()&2); v[1] = transluc[v[1+i]+(v[3-i]<<8)];

				i = (krand()&1); v[0] = transluc[v[0+i]+(v[1-i]<<8)];
				voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = v[0];
			}
}

optimizeedges()
{
	long x, y, z, xs, ys, zs;
	char ch;

	xs = 0; ys = 0; zs = 0;

	do
	{
		ch = 0; z = zs;
		for(x=xs;x<xsiz;x++)
			for(y=ys;y<ysiz;y++)
				if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != 255) { ch = 1; break; }
		if (ch == 0) zs++;
		if (zs >= zsiz)
		{
			printf("The object got chopped down to nothingness!\n");
			exit(0);
		}
	} while (ch == 0);

	do
	{
		ch = 0; y = ys;
		for(x=xs;x<xsiz;x++)
			for(z=zs;z<zsiz;z++)
				if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != 255) { ch = 1; break; }
		if (ch == 0) ys++;
	} while (ch == 0);

	do
	{
		ch = 0; x = xs;
		for(y=ys;y<ysiz;y++)
			for(z=zs;z<zsiz;z++)
				if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != 255) { ch = 1; break; }
		if (ch == 0) xs++;
	} while (ch == 0);

	do
	{
		ch = 0; z = zsiz-1;
		for(x=xs;x<xsiz;x++)
			for(y=ys;y<ysiz;y++)
				if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != 255) { ch = 1; break; }
		if (ch == 0) zsiz--;
	} while (ch == 0);

	do
	{
		ch = 0; y = ysiz-1;
		for(x=xs;x<xsiz;x++)
			for(z=zs;z<zsiz;z++)
				if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != 255) { ch = 1; break; }
		if (ch == 0) ysiz--;
	} while (ch == 0);

	do
	{
		ch = 0; x = xsiz-1;
		for(y=ys;y<ysiz;y++)
			for(z=zs;z<zsiz;z++)
				if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != 255) { ch = 1; break; }
		if (ch == 0) xsiz--;
	} while (ch == 0);

	xpivot -= (xs<<8); ypivot -= (ys<<8); zpivot -= (zs<<8);
	xsiz -= xs; ysiz -= ys; zsiz -= zs;

	for(x=0;x<xsiz;x++)
		for(y=0;y<ysiz;y++)
			for(z=0;z<zsiz;z++)
				voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = voxel[((x+xs)*MAXYSIZ+(y+ys))*MAXZSIZ+(z+zs)];
}

loadkvx(char *filename)
{
	long i, lengcnt, lengtot, fil;
	char *ptr;

	if ((fil = open(filename,O_BINARY|O_RDWR,S_IREAD)) == -1)
		return(-1);

	lengcnt = 0;
	lengtot = filelength(fil);

	ptr = voxdat;
	for(i=0;i<MAXVOXMIPS;i++)
	{
		read(fil,&voxsiz[0][i],4);
		read(fil,ptr,voxsiz[0][i]);
		voxoff[0][i] = ptr; ptr += voxsiz[0][i];

		lengcnt += voxsiz[0][i]+4;
		if (lengcnt >= lengtot-768) break;
	}
	read(fil,palette,768);
	close(fil);

	return(0);
}

savekvx()
{
	long i, fil;
	char filename[16];

	if (starttile < 0)
	{
		strcpy(filename,artpalname);
		i = strlen(filename);
		if ((filename[i-4] == '.') &&
			 ((filename[i-3] == 'V') || (filename[i-3] == 'v')) &&
			 ((filename[i-2] == 'O') || (filename[i-2] == 'o')) &&
			 ((filename[i-1] == 'X') || (filename[i-1] == 'x')))
		{
			filename[i-3] = 'K';
			filename[i-2] = 'V';
		}
	}
	else
	{
		menunamecnt = 0;
		getfilenames("voxel???.kvx");
		sortfilenames();

		if (menunamecnt >= MAXMENUFILES)
			{ setvmode(0x3); printf("MAXIMUM FILES is %ld!",MAXMENUFILES); exit(0); }

		kvxcapturecount = 0;
		if (menunamecnt > 0)
		{
			kvxcapturecount = (menuname[menunamecnt-1][7]-48);
			kvxcapturecount += (menuname[menunamecnt-1][6]-48)*10;
			kvxcapturecount += (menuname[menunamecnt-1][5]-48)*100;
			kvxcapturecount++;
		}

		strcpy(filename,"voxelxxx.kvx");
		filename[5] = ((kvxcapturecount/100)%10)+48;
		filename[6] = ((kvxcapturecount/10)%10)+48;
		filename[7] = (kvxcapturecount%10)+48;
	}

	if ((fil = open(filename,O_BINARY|O_TRUNC|O_CREAT|O_WRONLY,S_IWRITE)) != -1)
	{
		for(i=0;i<MAXVOXMIPS;i++)
		{
			write(fil,&voxsiz[0][i],sizeof(long));
			write(fil,voxoff[0][i],voxsiz[0][i]);
		}
		write(fil,palette,768);
		close(fil);
	}
}

loadvox(char *filename)
{
	long i, x, y, fil;
	char *voxptr;

	if ((fil = open(filename,O_BINARY|O_RDWR,S_IREAD)) == -1)
		return(-1);

	read(fil,&xsiz,4);
	read(fil,&ysiz,4);
	read(fil,&zsiz,4);
	for(x=0;x<xsiz;x++)
		for(y=0;y<ysiz;y++)
			read(fil,&voxel[(x*MAXYSIZ+y)*MAXZSIZ],zsiz);
	read(fil,palette,768);
	close(fil);

	optimizeedges();

	xpivot = (xsiz<<7);
	ypivot = (ysiz<<7);
	zpivot = (zsiz<<7);

	compileallmips();

	return(0);
}

savevox(char *filename)
{
	long i, x, y, fil;

	if ((fil = open(filename,O_BINARY|O_TRUNC|O_CREAT|O_WRONLY,S_IWRITE)) != -1)
	{
		kvx2vox(0,0L,0L,0L);
		write(fil,&xsiz,4);
		write(fil,&ysiz,4);
		write(fil,&zsiz,4);
		for(x=0;x<xsiz;x++)
			for(y=0;y<ysiz;y++)
				write(fil,&voxel[(x*MAXYSIZ+y)*MAXZSIZ],zsiz);
		write(fil,palette,768);
		close(fil);
	}
}

compilevoxels(char *voxptr)
{
	long x, y, z, i, lastz, olastz, oz, *longptr;
	short *shortptr;
	char ostat, nstat, cull, ncull, *nvoxptr, *vox, v1, v2, v3, v4, v5, v6;

	longptr = (long *)voxptr;
	voxptr += (6<<2);
	shortptr = (short *)&voxptr[((xsiz+1)<<2)];
	nvoxptr = (char *)&voxptr[((xsiz+1)<<2)+(xsiz*(ysiz+1)<<1)];

	longptr[0] = xsiz; longptr[1] = ysiz; longptr[2] = zsiz;
	longptr[3] = xpivot; longptr[4] = ypivot; longptr[5] = zpivot;

	for(x=0;x<xsiz;x++)
	{
		longptr[x+6] = (long)(nvoxptr-voxptr);
		for(y=0;y<ysiz;y++)
		{
			shortptr[x*(ysiz+1)+y] = (short)((nvoxptr-voxptr)-longptr[x+6]);

			vox = (char *)&voxel[(x*MAXYSIZ+y)*MAXZSIZ+0];

			nstat = 255; cull = 0; olastz = -1;
			for(z=0;z<=zsiz;z++)
			{
				ostat = nstat;

				nstat = 255;
				if ((z < zsiz) && (vox[z] != 255))
				{
					if (x <= 0)      v1 = 255; else v1 = vox[z-MAXYSIZ*MAXZSIZ];
					if (x >= xsiz-1) v2 = 255; else v2 = vox[z+MAXYSIZ*MAXZSIZ];
					if (y <= 0)      v3 = 255; else v3 = vox[z-MAXZSIZ];
					if (y >= ysiz-1) v4 = 255; else v4 = vox[z+MAXZSIZ];
					if (z <= 0)      v5 = 255; else v5 = vox[z-1];
					if (z >= zsiz-1) v6 = 255; else v6 = vox[z+1];

					ncull = ((v1==255)<<0)+((v2==255)<<1)+((v3==255)<<2)+
							  ((v4==255)<<3)+((v5==255)<<4)+((v6==255)<<5);

					if (ncull) { nstat = vox[z]; cull |= ncull; }
				}
				if ((nstat==255) == (ostat==255)) continue;

				if (nstat != 255) { lastz = z; continue; }

					//Make short slabs into 1 slab instead of 2 edge slabs
				if ((olastz > 0) && ((lastz-oz) < 3))
				{
					nvoxptr[olastz-oz-2] = z-olastz;
					nvoxptr[olastz-oz-1] |= cull; cull = 0;
					v1 = transluc[(((long)vox[oz-1])<<8)+vox[lastz]];
					for(i=oz;i<lastz;i++) *nvoxptr++ = v1;
					for(i=lastz;i<z;i++) *nvoxptr++ = vox[i];

					olastz = -1; continue;
				}

				if ((cull&32) == 0) { olastz = lastz; oz = z; }
				*nvoxptr++ = lastz;
				*nvoxptr++ = z-lastz;
				*nvoxptr++ = cull; cull = 0;
				for(i=lastz;i<z;i++) *nvoxptr++ = vox[i];
			}
		}
		shortptr[x*(ysiz+1)+ysiz] = (short)((nvoxptr-voxptr)-longptr[x+6]);
	}
	longptr[xsiz+6] = (long)(nvoxptr-voxptr);
	return((long)(nvoxptr-((char *)longptr)));
}

drawvox(long dasprx, long daspry, long dasprz, long dasprang,
		  long daxscale, long dayscale, char daindex)
{
	long i, j, k, x, y, z, syoff, ggxstart, ggystart, nxoff;
	long cosang, sinang, sprcosang, sprsinang, backx, backy, gxinc, gyinc;
	long daxsiz, daysiz, dazsiz, daxpivot, daypivot, dazpivot;
	long daxscalerecip, dayscalerecip, cnt, gxstart, gystart;
	long l1, l2, p, pend, slabxoffs, dahorizoff, xyvoxoffs, *longptr;
	long lx, rx, nx, ny, zx, zy, x1, y1, z1, x2, y2, z2, yplc, yinc, bufplc;
	long yoff, xs, ys, xe, ye, xi, yi, cbackx, cbacky, dagxinc, dagyinc;
	short *shortptr;
	char *voxptr, *voxend, *davoxptr, oand, oand16, oand32;

	cosang = sintable[(globalang+512)&2047];
	sinang = sintable[globalang&2047];
	sprcosang = sintable[(dasprang+512)&2047];
	sprsinang = sintable[dasprang&2047];

	i = klabs(dmulscale6(dasprx-globalposx,cosang,daspry-globalposy,sinang));
	j = 1310720;
	for(k=0;k<MAXVOXMIPS;k++)
	{
		if (i < j) { i = k; break; }
		j <<= 1;
	}
	if (k >= MAXVOXMIPS) i = MAXVOXMIPS-1;

	if (!edit2dmode)
		for(j=0;j<MAXVOXMIPS;j++)
			if (keystatus[j+2]) i = j;

	daxscale <<= i; dayscale <<= i;
	davoxptr = (char *)voxoff[daindex][i]; if (!davoxptr) return;

	daxscalerecip = krecipasm(daxscale);
	dayscalerecip = krecipasm(dayscale);

	longptr = (long *)davoxptr;
	daxsiz = longptr[0]; daysiz = longptr[1]; dazsiz = longptr[2];
	daxpivot = longptr[3]; daypivot = longptr[4]; dazpivot = longptr[5];
	davoxptr += (6<<2);

	x = mulscale24(globalposx-dasprx,daxscalerecip);
	y = mulscale24(globalposy-daspry,daxscalerecip);
	backx = ((dmulscale10(x,sprcosang,y,sprsinang)+daxpivot)>>8);
	backy = ((dmulscale10(y,sprcosang,x,-sprsinang)+daypivot)>>8);
	cbackx = min(max(backx,0),daxsiz-1);
	cbacky = min(max(backy,0),daysiz-1);

	sprcosang = mulscale6(daxscale,sprcosang);
	sprsinang = mulscale6(daxscale,sprsinang);

	x = (dasprx-globalposx) - dmulscale18(daxpivot,sprcosang,daypivot,-sprsinang);
	y = (daspry-globalposy) - dmulscale18(daypivot,sprcosang,daxpivot,sprsinang);

	cosang = mulscale24(cosang,dayscalerecip);
	sinang = mulscale24(sinang,dayscalerecip);

	gxstart = y*cosang - x*sinang;
	gystart = x*cosang + y*sinang;
	gxinc = dmulscale10(sprsinang,cosang,sprcosang,-sinang);
	gyinc = dmulscale10(sprcosang,cosang,sprsinang,sinang);

	x = 0; y = 0; j = max(daxsiz,daysiz);
	for(i=0;i<=j;i++)
	{
		ggxinc[i] = x; x += gxinc;
		ggyinc[i] = y; y += gyinc;
	}

	syoff = (dazpivot<<7)+mulscale13(globalposz-dasprz,dayscalerecip);
	yoff = ((klabs(gxinc)+klabs(gyinc))>>1);
	dahorizoff = (globalhoriz>>8);
	longptr = (long *)davoxptr;
	xyvoxoffs = ((daxsiz+1)<<2);

	for(cnt=0;cnt<8;cnt++)
	{
		switch(cnt)
		{
			case 0: xs = 0;        ys = 0;        xi = 1;  yi = 1;  break;
			case 1: xs = daxsiz-1; ys = 0;        xi = -1; yi = 1;  break;
			case 2: xs = 0;        ys = daysiz-1; xi = 1;  yi = -1; break;
			case 3: xs = daxsiz-1; ys = daysiz-1; xi = -1; yi = -1; break;
			case 4: xs = 0;        ys = cbacky;   xi = 1;  yi = 2;  break;
			case 5: xs = daxsiz-1; ys = cbacky;   xi = -1; yi = 2;  break;
			case 6: xs = cbackx;   ys = 0;        xi = 2;  yi = 1;  break;
			case 7: xs = cbackx;   ys = daysiz-1; xi = 2;  yi = -1; break;
		}
		xe = cbackx; ye = cbacky;
		if (cnt < 4)
		{
			if ((xi < 0) && (xe >= xs)) continue;
			if ((xi > 0) && (xe <= xs)) continue;
			if ((yi < 0) && (ye >= ys)) continue;
			if ((yi > 0) && (ye <= ys)) continue;
		}
		else
		{
			if ((xi < 0) && (xe > xs)) continue;
			if ((xi > 0) && (xe < xs)) continue;
			if ((yi < 0) && (ye > ys)) continue;
			if ((yi > 0) && (ye < ys)) continue;
			xe += xi; ye += yi;
		}

		i = ksgn(ys-backy)+ksgn(xs-backx)*3+4;
		switch(i)
		{
			case 6: case 7: x1 = 0; y1 = 0; break;
			case 8: case 5: x1 = gxinc; y1 = gyinc; break;
			case 0: case 3: x1 = gyinc; y1 = -gxinc; break;
			case 2: case 1: x1 = gxinc+gyinc; y1 = gyinc-gxinc; break;
		}
		switch(i)
		{
			case 2: case 5: x2 = 0; y2 = 0; break;
			case 0: case 1: x2 = gxinc; y2 = gyinc; break;
			case 8: case 7: x2 = gyinc; y2 = -gxinc; break;
			case 6: case 3: x2 = gxinc+gyinc; y2 = gyinc-gxinc; break;
		}
		oand = 0;
		if (xs > backx) oand += 1;
		else if (xs < backx) oand += 2;
		if (ys > backy) oand += 4;
		else if (ys < backy) oand += 8;
		//oand = pow2char[(xs<backx)+0]+pow2char[(ys<backy)+2];
		oand16 = oand+16;
		oand32 = oand+32;

		if (yi > 0) { dagxinc = gxinc; dagyinc = gyinc; }
				 else { dagxinc = -gxinc; dagyinc = -gyinc; }

		nxoff = x2-x1;
		ggxstart = gxstart+ggyinc[ys];
		ggystart = gystart-ggxinc[ys];
		for(x=xs;x!=xe;x+=xi)
		{
			slabxoffs = (long)&davoxptr[longptr[x]];
			shortptr = (short *)&davoxptr[((x*(daysiz+1))<<1)+xyvoxoffs];

			nx = ggxstart+ggxinc[x]+x1;
			ny = ggystart+ggyinc[x];
			for(y=ys;y!=ye;y+=yi,nx+=dagyinc,ny-=dagxinc)
			{
				if ((ny <= nytooclose) || (ny >= nytoofar)) continue;
				voxptr = (char *)(shortptr[y]+slabxoffs);
				voxend = (char *)(shortptr[y+1]+slabxoffs);
				if (voxptr == voxend) continue;

				lx = mulscale32((nx)>>3,distrecip[(ny+y1)>>14])+(XDIM>>1);
				if (lx < 0) lx = 0;
				rx = mulscale32((nx+nxoff)>>3,distrecip[(ny+y2)>>14])+(XDIM>>1);
				if (rx > XDIM) rx = XDIM;
				if (rx <= lx) continue;
				rx -= lx;

				l1 = distrecip[(ny-yoff)>>14];
				l2 = distrecip[(ny+yoff)>>14];

				for(;voxptr<voxend;voxptr+=voxptr[1]+3)
				{
					j = (voxptr[0]<<15)-syoff;
					if (j < 0)
					{
						k = j+(voxptr[1]<<15);
						if (k < 0)
						{
							if ((voxptr[2]&oand32) == 0) continue;
							z2 = mulscale32(l2,k) + dahorizoff;     //Below slab
						}
						else
						{
							if ((voxptr[2]&oand) == 0) continue;    //Middle of slab
							z2 = mulscale32(l1,k) + dahorizoff;
						}
						z1 = mulscale32(l1,j) + dahorizoff;
					}
					else
					{
						if ((voxptr[2]&oand16) == 0) continue;
						z1 = mulscale32(l2,j) + dahorizoff;        //Above slab
						z2 = mulscale32(l1,j+(voxptr[1]<<15)) + dahorizoff;
					}

					if (voxptr[1] == 1)
					{
						yplc = 0; yinc = 0;
						if (z1 < 0) z1 = 0;
					}
					else
					{
						if (z2-z1 >= 1024) yinc = divscale16(voxptr[1],z2-z1);
						else yinc = (lowrecip[z2-z1]*voxptr[1]>>8);
						if (z1 < 0) { yplc = yinc*(-z1); z1 = 0; } else yplc = 0;
					}
					if (z2 > YDIM) z2 = YDIM;
					z2 -= z1; if (z2 <= 0) continue;

					drawslab(rx,yplc,z2,yinc,(long)&voxptr[3],ylookup[z1]+lx+frameplace);
				}
			}
		}
	}
}

/*drawslab(long rx, long yplc, long z2, long yinc, long voxplc, long p)
{
	switch(rx)
	{
		case 1: slab1(yplc,z2,yinc,voxplc,p); return;
		case 2: slab2(yplc,z2,yinc,voxplc,p); return;
		case 4: slab4(yplc,z2,yinc,voxplc,p); return;
		default:
			rx += p;
			if ((p&1) && (p != rx)) slab1(yplc,z2,yinc,voxplc,p), p++;
			if ((p&2) && (p < rx-1)) slab2(yplc,z2,yinc,voxplc,p), p += 2;
			while (p < rx-3) slab4(yplc,z2,yinc,voxplc,p), p += 4;
			if (p < rx-1) slab2(yplc,z2,yinc,voxplc,p), p += 2;
			if (p != rx) slab1(yplc,z2,yinc,voxplc,p);
			return;
	}
}*/

loadtables()
{
	long i, fil;

	if ((fil = open("setup.dat",O_BINARY|O_RDWR,S_IREAD)) != -1)
	{
		read(fil,option,NUMOPTIONS);
		read(fil,keys,NUMKEYS);
		close(fil);
	}

	fcalcsin();
	for(i=0;i<2048;i++) reciptable[i] = divscale30(2048L,i+2048);
}

printext256(long xpos, long ypos, short col, short backcol, char name[82], char fontsize)
{
	long stx, i, x, y, charxsiz, charysiz;
	char *fontptr, *letptr, *ptr, ch;

	if (fontsize) { fontptr = (char *)smallfnt; charxsiz = 4; charysiz = 6; }
				else { fontptr = (char *)textfont; charxsiz = 8; charysiz = 8; }

	stx = xpos;
	for(i=0;name[i];i++)
	{
		letptr = &fontptr[name[i]<<3];
		ptr = (char *)(ylookup[ypos+charysiz-1]+(stx-fontsize)+frameplace);
		for(y=charysiz-1;y>=0;y--)
		{
			ch = letptr[y];
			for(x=charxsiz-1;x>=0;x--)
			{
				if (ch&pow2char[7-fontsize-x]) ptr[x] = (char)col;
						  else if (backcol >= 0) ptr[x] = (char)backcol;
			}
			ptr -= ylookup[1];
		}
		stx += charxsiz;
	}
}

inittimer()
{
	koutp(0x43,0x36); koutp(0x40,TIMERRATE&255); koutp(0x40,TIMERRATE>>8);
	oldtimerhandler = _dos_getvect(0x8);
	_disable(); _dos_setvect(0x8, timerhandler); _enable();
}

uninittimer()
{
	koutp(0x43,0x36); koutp(0x40,0); koutp(0x40,0);           //18.2 times/sec
	_disable(); _dos_setvect(0x8, oldtimerhandler); _enable();
}

void __interrupt __far timerhandler()
{
	totalclock++;
	if (totalclock&1) keytimerstuff();
	chainintrclock -= TIMERRATE;
	if (chainintrclock < 0)
	{
		chainintrclock += 65536;
		_chain_intr(oldtimerhandler);
	}
	koutp(0x20,0x20);
}

initkeys()
{
	long i;

	for(i=0;i<256;i++) keystatus[i] = 0;
	oldkeyhandler = _dos_getvect(0x9);
	_disable(); _dos_setvect(0x9, keyhandler); _enable();
}

uninitkeys()
{
	short *ptr;

	_dos_setvect(0x9, oldkeyhandler);
		//Turn off shifts to prevent stucks with quitting
	ptr = (short *)0x417; *ptr &= ~0x030f;
}

void __interrupt __far keyhandler()
{
	oldreadch = readch; readch = kinp(0x60);
	keytemp = kinp(0x61); koutp(0x61,keytemp|128); koutp(0x61,keytemp&127);
	if ((readch|1) == 0xe1)
		extended = 128;
	else
	{
		if (oldreadch != readch)
			keystatus[(readch&127)+extended] = ((readch>>7)^1);
		extended = 0;
	}
	koutp(0x20,0x20);
	if (keystatus[0x46])
	{
		koutp(0x43,0x36); koutp(0x40,0); koutp(0x40,0);
		_dos_setvect(0x9, oldkeyhandler);
		_dos_setvect(0x8, oldtimerhandler);
		setvmode(0x3);
		exit(0);
	}
}

keytimerstuff()
{
	if (inawindow < 0)
	{
			//Acceleration
		if (keystatus[keys[0]]) fvel = min(fvel+8,127);
		if (keystatus[keys[1]]) fvel = max(fvel-8,-128);
		if (keystatus[0x2c]) hvel = min(hvel+8,127);
		if (keystatus[0x1e]) hvel = max(hvel-8,-128);
		if (keystatus[keys[5]])
		{
			if (keystatus[keys[3]]) svel = min(svel+8,127);
			if (keystatus[keys[2]]) svel = max(svel-8,-128);
		}
		else
		{
			if (keystatus[keys[3]]) a3vel = min(a3vel+16,127);
			if (keystatus[keys[2]]) a3vel = max(a3vel-16,-128);
		}
		if (keystatus[0x33]) a1vel = min(a1vel+32,127);
		if (keystatus[0x34]) a1vel = max(a1vel-32,-128);
		if (keystatus[keys[11]]) a2vel = min(a2vel+16,127);
		if (keystatus[keys[10]]) a2vel = max(a2vel-16,-128);
	}

		//Friction
	if (fvel < 0) fvel = min(fvel+2,0);
	if (fvel > 0) fvel = max(fvel-2,0);
	if (svel < 0) svel = min(svel+2,0);
	if (svel > 0) svel = max(svel-2,0);
	if (hvel < 0) hvel = min(hvel+2,0);
	if (hvel > 0) hvel = max(hvel-2,0);
	if (a1vel < 0) a1vel = min(a1vel+12,0);
	if (a1vel > 0) a1vel = max(a1vel-12,0);
	if (a2vel < 0) a2vel = min(a2vel+12,0);
	if (a2vel > 0) a2vel = max(a2vel-12,0);
	if (a3vel < 0) a3vel = min(a3vel+12,0);
	if (a3vel > 0) a3vel = max(a3vel-12,0);
}

loadpalette(char *dafilename)
{
	long i, j, fil, mindist, newdist;
	char col;

	if ((fil = open(dafilename,O_BINARY|O_RDWR,S_IREAD)) == -1) return;
	if (starttile >= 0)
		read(fil,palette,768);
	else
		lseek(fil,768,SEEK_SET);
	read(fil,&numpalookups,2);
	read(fil,palookup,numpalookups<<8);
	read(fil,transluc,65536);

		//Get closest color to 255 since 255 can't be used
	mindist = 0x7fffffff;
	for(i=0;i<255;i++)
	{
		j = i*3;
		newdist = (palette[j  ]-palette[765])*(palette[j  ]-palette[765])*3+
					 (palette[j+1]-palette[766])*(palette[j+1]-palette[766])*5+
					 (palette[j+2]-palette[767])*(palette[j+2]-palette[767])*2;
		if (newdist < mindist) { mindist = newdist; col = i; }
	}
	for(i=0;i<65536;i++) if (transluc[i] == 255) transluc[i] = col;

	close(fil);
}

static char moustat = 0;
initmouse()
{
	return(moustat = setupmouse());
}

getmousevalues(short *mousx, short *mousy, short *bstatus)
{
	if (moustat == 0) { *mousx = 0; *mousy = 0; *bstatus = 0; return; }
	readmousexy(mousx,mousy);
	readmousebstatus(bstatus);
}

getpaletteconversion()
{
	long i, j, k, c1, c2, c3, bestcol, mindist, d;

	for(i=0;i<765;i+=3)
	{
		c1 = palette2[i+0]; c2 = palette2[i+1]; c3 = palette2[i+2];
		mindist = 0x7fffffff;
		for(j=0;j<765;j+=3)
		{
			k = (c2-(long)palette[j+1]); d = k*k; if (d >= mindist) continue;
			k = (c1-(long)palette[j+0]); d += k*k; if (d >= mindist) continue;
			k = (c3-(long)palette[j+2]); d += k*k; if (d >= mindist) continue;
			mindist = d; bestcol = j;
		}
		palookupe[i/3] = bestcol/3;
	}
	palookupe[255] = 255;
}

remapcompiledvoxel(char *charptr)
{
	long i, x, y, slabxoffs, daxsiz, daysiz, *longptr;
	short *shortptr;
	char *voxptr, *voxend;

	if (!charptr) return;
	longptr = (long *)charptr;
	daxsiz = longptr[0]; daysiz = longptr[1];
	charptr += (6<<2);
	longptr = (long *)charptr;
	for(x=daxsiz-1;x>=0;x--)
	{
		slabxoffs = (long)&charptr[longptr[x]];
		shortptr = (short *)&charptr[((x*(daysiz+1))<<1)+((daxsiz+1)<<2)];
		for(y=daysiz-1;y>=0;y--)
		{
			voxptr = (char *)(shortptr[y+0]+slabxoffs);
			voxend = (char *)(shortptr[y+1]+slabxoffs);
			for(;voxptr<voxend;voxptr+=voxptr[1]+3)
				for(i=voxptr[1]+2;i>=3;i--)
					voxptr[i] = palookupe[voxptr[i]];
		}
	}
}

	//0 = CLEAR & PSET, 1 = PSET, 2 = XOR
kvx2vox(char boolop, long xoff, long yoff, long zoff)
{
	long i, j, x, y, z, slabxoffs, *longptr, lastz;
	short *shortptr;
	char *voxptr, *voxend, *charptr, *davox;

	charptr = voxoff[0][0];
	longptr = (long *)charptr;
	xsiz = longptr[0]; ysiz = longptr[1]; zsiz = longptr[2];
	xpivot = longptr[3]; ypivot = longptr[4]; zpivot = longptr[5];
	charptr += (6<<2);
	longptr = (long *)charptr;

	if (boolop == 0)
		clearbufbyte(voxel,MAXXSIZ*MAXYSIZ*MAXZSIZ,0xffffffff);

	davox = &voxel[((xoff*MAXYSIZ)+yoff)*MAXZSIZ+zoff];

	for(x=xsiz-1;x>=0;x--)
	{
		slabxoffs = (long)&charptr[longptr[x]];
		shortptr = (short *)&charptr[((x*(ysiz+1))<<1)+((xsiz+1)<<2)];
		for(y=ysiz-1;y>=0;y--)
		{
			j = (x*MAXYSIZ+y)*MAXZSIZ;
			voxptr = (char *)(shortptr[y+0]+slabxoffs);
			voxend = (char *)(shortptr[y+1]+slabxoffs);
			lastz = 0;
			if (boolop == 2)
			{
				for(;voxptr<voxend;voxptr+=voxptr[1]+3)
				{
					if (!(voxptr[2]&16))
					{
						for(z=lastz;z<voxptr[0];z++)
							davox[j+z] ^= voxptr[3] ^ 255;
					}
					for(i=voxptr[1]-1;i>=0;i--)
						davox[i+j+voxptr[0]] ^= voxptr[i+3] ^ 255;
					lastz = voxptr[0]+voxptr[1];
				}
			}
			else
			{
				for(;voxptr<voxend;voxptr+=voxptr[1]+3)
				{
					if (!(voxptr[2]&16))
					{
						for(z=lastz;z<voxptr[0];z++)
							davox[j+z] = voxptr[3];
					}
					for(i=voxptr[1]-1;i>=0;i--)
						davox[i+j+voxptr[0]] = voxptr[i+3];
					lastz = voxptr[0]+voxptr[1];
				}
			}
		}
	}
}

getfilenames(char *kind)
{
	short type;
	struct find_t fileinfo;

	if (strcmp(kind,"SUBD") == 0)
	{
		strcpy(kind,"*.*");
		if (_dos_findfirst(kind,_A_SUBDIR,&fileinfo) != 0)
			return(-1);
		type = 1;
	}
	else
	{
		if (_dos_findfirst(kind,_A_NORMAL,&fileinfo) != 0)
			return(-1);
		type = 0;
	}
	do
	{
		if ((type == 0) || ((fileinfo.attrib&16) > 0))
			if ((fileinfo.name[0] != '.') || (fileinfo.name[1] != 0))
				if (menunamecnt < MAXMENUFILES)
				{
					strcpy(menuname[menunamecnt],fileinfo.name);
					menuname[menunamecnt][16] = type;
					menunamecnt++;
				}
	}
	while (_dos_findnext(&fileinfo) == 0);

	return(0);
}

sortfilenames()
{
	char sortbuffer[17];
	long i, j, k, m;

	for(i=1;i<menunamecnt;i++)
		for(j=0;j<i;j++)
		{
			k = 0;
			while ((menuname[i][k] == menuname[j][k]) && (menuname[i][k] != 0) && (menuname[j][k] != 0))
				k++;
			if (menuname[i][k] < menuname[j][k])
			{
				memcpy(&sortbuffer[0],&menuname[i][0],sizeof(menuname[0]));
				memcpy(&menuname[i][0],&menuname[j][0],sizeof(menuname[0]));
				memcpy(&menuname[j][0],&sortbuffer[0],sizeof(menuname[0]));
			}
		}
}

krand()
{
	randomseed = (randomseed*27584621)+1;
	return(((unsigned long)randomseed)>>16);
}

voxelhitscan (long startx, long starty, long *hitx, long *hity, long *hitz)
{
	long i, j, t[4], cosang, sinang, sprcosang, sprsinang;
	long x, y, z, dz, odax, oday, dax, day, dvx, dvy, *longptr;
	long xdir, ydir, snx, sny, xc, startz;

	cosang = sintable[(globalang+512)&2047]; sinang = sintable[globalang&2047];
	sprcosang = sintable[(sprang+512)&2047]; sprsinang = sintable[sprang&2047];
	x = divscale6(globalposx-sprx,sprxrepeat);
	y = divscale6(globalposy-spry,spryrepeat);
	odax = dmulscale10(x,sprcosang,y,sprsinang)+xpivot;
	oday = dmulscale10(y,sprcosang,x,-sprsinang)+ypivot;
	dvx = dmulscale16(cosang,sprcosang,sinang,sprsinang);
	dvy = dmulscale16(sinang,sprcosang,cosang,-sprsinang);

	dz = divscale12(starty-(globalhoriz>>8),XDIM>>1);

	x = -dvy;
	y = dvx;
	dvx += scale(x,(startx<<1)-XDIM,XDIM);
	dvy += scale(y,(startx<<1)-XDIM,XDIM);

		//Box-raytracing
	dax = odax;
	day = oday;
	if (dvx > 0)
		{ if (dax < 0) { day += scale(-dax,dvy,dvx); dax = 0; } }
	else if (dvx < 0)
		{ if (dax >= (xsiz<<8)) { day += scale((xsiz<<8)-1-dax,dvy,dvx); dax = (xsiz<<8)-1; } }
	if (dvy > 0)
		{ if (day < 0) { dax += scale(-day,dvx,dvy); day = 0; } }
	else if (dvy < 0)
		{ if (day >= (ysiz<<8)) { dax += scale((ysiz<<8)-1-day,dvx,dvy); day = (ysiz<<8)-1; } }
	xdir = ksgn(dvx); dvx = klabs(dvx);
	ydir = ksgn(dvy); dvy = klabs(dvy);
	snx = (dax&255); if (xdir > 0) snx ^= 255;
	sny = (day&255); if (ydir > 0) sny ^= 255;
	xc = dmulscale8(snx,dvy,-sny,dvx);
	x = (dax>>8); y = (day>>8);
	startz = ((globalposz-sprz)<<4)+zpivot+128;
	while (((unsigned)x < (unsigned)xsiz) && ((unsigned)y < (unsigned)ysiz))
	{
		z = startz;
		if (klabs(dvx) >= klabs(dvy)) z += scale(klabs(odax-((x<<8)+128)),dz,dvx);
										 else z += scale(klabs(oday-((y<<8)+128)),dz,dvy);
		z >>= 8;
		if ((unsigned)z < (unsigned)zsiz)
			if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != 255)
				{ *hitx = x; *hity = y; *hitz = z; return(1); }

		if (xc < 0) { xc += dvy; x += xdir; }
				 else { xc -= dvx; y += ydir; }
	}
	return(0);
}

voxelaserkill(long startx, long starty)
{
	long i, j, t[4], cosang, sinang, sprcosang, sprsinang;
	long x, y, z, dz, odax, oday, dax, day, dvx, dvy, *longptr;
	long xdir, ydir, snx, sny, xc, startz;

	cosang = sintable[(globalang+512)&2047]; sinang = sintable[globalang&2047];
	sprcosang = sintable[(sprang+512)&2047]; sprsinang = sintable[sprang&2047];
	x = divscale6(globalposx-sprx,sprxrepeat);
	y = divscale6(globalposy-spry,spryrepeat);
	odax = dmulscale10(x,sprcosang,y,sprsinang)+xpivot;
	oday = dmulscale10(y,sprcosang,x,-sprsinang)+ypivot;
	dvx = dmulscale16(cosang,sprcosang,sinang,sprsinang);
	dvy = dmulscale16(sinang,sprcosang,cosang,-sprsinang);

	dz = divscale12(starty-(globalhoriz>>8),XDIM>>1);

	x = -dvy;
	y = dvx;
	dvx += scale(x,(startx<<1)-XDIM,XDIM);
	dvy += scale(y,(startx<<1)-XDIM,XDIM);

		//Box-raytracing
	dax = odax;
	day = oday;
	if (dvx > 0)
		{ if (dax < 0) { day += scale(-dax,dvy,dvx); dax = 0; } }
	else if (dvx < 0)
		{ if (dax >= (xsiz<<8)) { day += scale((xsiz<<8)-1-dax,dvy,dvx); dax = (xsiz<<8)-1; } }
	if (dvy > 0)
		{ if (day < 0) { dax += scale(-day,dvx,dvy); day = 0; } }
	else if (dvy < 0)
		{ if (day >= (ysiz<<8)) { dax += scale((ysiz<<8)-1-day,dvx,dvy); day = (ysiz<<8)-1; } }
	xdir = ksgn(dvx); dvx = klabs(dvx);
	ydir = ksgn(dvy); dvy = klabs(dvy);
	snx = (dax&255); if (xdir > 0) snx ^= 255;
	sny = (day&255); if (ydir > 0) sny ^= 255;
	xc = dmulscale8(snx,dvy,-sny,dvx);
	x = (dax>>8); y = (day>>8);
	startz = ((globalposz-sprz)<<4)+zpivot+128;
	while (((unsigned)x < (unsigned)xsiz) && ((unsigned)y < (unsigned)ysiz))
	{
		z = startz;
		if (klabs(dvx) >= klabs(dvy)) z += scale(klabs(odax-((x<<8)+128)),dz,dvx);
										 else z += scale(klabs(oday-((y<<8)+128)),dz,dvy);
		z >>= 8;
		if ((unsigned)z < (unsigned)zsiz) voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = 255;

		if (xc < 0) { xc += dvy; x += xdir; }
				 else { xc -= dvx; y += ydir; }
	}
	return(0);
}

compileallmips()
{
	long i;
	char *voxptr;

	voxptr = voxdat;
	for(i=0;i<MAXVOXMIPS;i++)
	{
		voxoff[0][i] = voxptr;
		voxsiz[0][i] = compilevoxels(voxptr);
		voxptr += voxsiz[0][i];
		if (i < MAXVOXMIPS-1) mipit();
	}

	kvx2vox(0,0L,0L,0L);
}

voxfill2dregion(char *vox, long x, long y, long xinc, long yinc, long xbound, long ybound, char col, char bound)
{
	unsigned char tstat, bstat, tlast, blast;
	int i, leftz, z, zz, c;

	c = 1;
	xfillbuf[c] = x;
	yfillbuf[c] = y;
	if (vox[y*yinc+x*xinc] == bound) return(-1);
	while (c > 0)
	{
		z = xfillbuf[c]; zz = yfillbuf[c];
		c--;
		while ((vox[zz*yinc+(z-1)*xinc] != bound) && (z > 0)) z--;
		leftz = z; tlast = 0; blast = 0;
		while ((vox[zz*yinc+z*xinc] != bound) && (z < xbound))
		{
			if (zz > 0)
			{
				tstat = vox[(zz-1)*yinc+z*xinc];
				if ((tstat != bound) && (tstat != col))
				{
					if (tlast == 0)
					{
						c++;
						xfillbuf[c] = z; yfillbuf[c] = zz-1;
						tlast = 1;
					}
				}
				else
					tlast = 0;
			}
			if (zz < ybound-1)
			{
				bstat = vox[(zz+1)*yinc+z*xinc];
				if ((bstat != bound) && (bstat != col))
				{
					if (blast == 0)
					{
						c++;
						xfillbuf[c] = z; yfillbuf[c] = zz+1;
						blast = 1;
					}
				}
				else
					blast = 0;
			}
			z++;
		}
		z--;
		while (z >= leftz)
		{
			if ((z >= 0) && (z < xbound)) vox[zz*yinc+z*xinc] = col;
			z--;
		}
	}
	return(0);
}

circlize(char *voxptr, long xmul, long ymul, long daxsiz, long daysiz)
{
	float xc, yc, r, rd, ang;
	long cnt, x, y, incrx, incry, xdir, ydir, snx, sny, gridx, gridy, col;

	xc = 0; yc = 0; rd = 0; cnt = 0;
	for(x=0;x<daxsiz;x++)
		for(y=0;y<daysiz;y++)
			if (voxptr[x*xmul+y*ymul] != 255)
				{ xc += x; yc += y; cnt++; }
	if (cnt <= 0) return;
	xc /= cnt; yc /= cnt;
	xc += .5; yc += .5;

	cnt = 0;
	for(x=0;x<daxsiz;x++)
		for(y=0;y<daysiz;y++)
			if (voxptr[x*xmul+y*ymul] != 255)
			{
				if ((x == 0) || (y == 0) || (x == daxsiz-1) || (y == daysiz-1))
				{
					rd += sqrt((x+.5-xc)*(x+.5-xc)+(y+.5-yc)*(y+.5-yc));
					cnt++;
				}
				else if ((voxptr[(x-1)*xmul+y*ymul] == 255) ||
							(voxptr[(x+1)*xmul+y*ymul] == 255) ||
							(voxptr[x*xmul+(y-1)*ymul] == 255) ||
							(voxptr[x*xmul+(y+1)*ymul] == 255))
				{
					rd += sqrt((x+.5-xc)*(x+.5-xc)+(y+.5-yc)*(y+.5-yc));
					cnt++;
				}
			}
	if (cnt <= 0) return;
	rd /= cnt;
	rd -= .1;
	if (rd < 2) return;

	for(x=0;x<daxsiz;x++)
		for(y=0;y<daysiz;y++)
			tempbuf[y*MAXZSIZ+x] = voxptr[x*xmul+y*ymul];

	for(x=0;x<daxsiz;x++)
		for(y=0;y<daysiz;y++)
		{
			if ((x+.5-xc)*(x+.5-xc)+(y+.5-yc)*(y+.5-yc) < rd*rd)
			{
				if (tempbuf[y*MAXZSIZ+x] == 255)
					voxptr[x*xmul+y*ymul] = 0;
			}
			else
				voxptr[x*xmul+y*ymul] = 255;
		}

	for(ang=0;ang<3.141592*2;ang+=.1/rd)
	{
		incrx = 16384*cos(ang);
		incry = 16384*sin(ang);
		xdir = ksgn(incrx); incrx = klabs(incrx);
		ydir = ksgn(incry); incry = klabs(incry);
		snx = ((long)(xc*1024))&1023; if (xdir == 1) snx ^= 1023;
		sny = ((long)(yc*1024))&1023; if (ydir == 1) sny ^= 1023;
		cnt = ((snx*incry-sny*incrx)>>10);
		gridx = xc; gridy = yc;
		do
		{
			if (tempbuf[gridy*MAXZSIZ+gridx] == 255) break;
			col = tempbuf[gridy*MAXZSIZ+gridx];
			if (cnt < 0) { cnt += incry; gridx += xdir; }
					  else { cnt -= incrx; gridy += ydir; }
		} while ((gridx >= 0) && (gridx < daxsiz) && (gridy >= 0) && (gridy < daysiz));
		x = (long)(cos(ang)*rd+xc);
		y = (long)(sin(ang)*rd+yc);
		if ((x >= 0) && (y >= 0) && (x < daxsiz) && (y < daysiz))
			voxptr[x*xmul+y*ymul] = col;
	}
}


floodfill3d(long x, long y, long z, char col, char followcol)
{
	long fillplc, fillend;

	if (voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] != followcol) return;
	voxel[(x*MAXYSIZ+y)*MAXZSIZ+z] = col;

	fillplc = fillend = 0;
	xfillbuf[fillend] = x; yfillbuf[fillend] = y; zfillbuf[fillend] = z; fillend = ((fillend+1)&(FILLBUFSIZ-1));
	while (fillplc != fillend)
	{
		x = xfillbuf[fillplc]; y = yfillbuf[fillplc]; z = zfillbuf[fillplc]; fillplc = ((fillplc+1)&(FILLBUFSIZ-1));
		if ((x > 0) && (voxel[((x-1)*MAXYSIZ+y)*MAXZSIZ+z] == followcol))
		{
			voxel[((x-1)*MAXYSIZ+y)*MAXZSIZ+z] = col;
			xfillbuf[fillend] = x-1; yfillbuf[fillend] = y; zfillbuf[fillend] = z; fillend = ((fillend+1)&(FILLBUFSIZ-1));
		}
		if ((y > 0) && (voxel[(x*MAXYSIZ+(y-1))*MAXZSIZ+z] == followcol))
		{
			voxel[(x*MAXYSIZ+(y-1))*MAXZSIZ+z] = col;
			xfillbuf[fillend] = x; yfillbuf[fillend] = y-1; zfillbuf[fillend] = z; fillend = ((fillend+1)&(FILLBUFSIZ-1));
		}
		if ((z > 0) && (voxel[(x*MAXYSIZ+y)*MAXZSIZ+(z-1)] == followcol))
		{
			voxel[(x*MAXYSIZ+y)*MAXZSIZ+(z-1)] = col;
			xfillbuf[fillend] = x; yfillbuf[fillend] = y; zfillbuf[fillend] = z-1; fillend = ((fillend+1)&(FILLBUFSIZ-1));
		}
		if ((x < xsiz-1) && (voxel[((x+1)*MAXYSIZ+y)*MAXZSIZ+z] == followcol))
		{
			voxel[((x+1)*MAXYSIZ+y)*MAXZSIZ+z] = col;
			xfillbuf[fillend] = x+1; yfillbuf[fillend] = y; zfillbuf[fillend] = z; fillend = ((fillend+1)&(FILLBUFSIZ-1));
		}
		if ((y < ysiz-1) && (voxel[(x*MAXYSIZ+(y+1))*MAXZSIZ+z] == followcol))
		{
			voxel[(x*MAXYSIZ+(y+1))*MAXZSIZ+z] = col;
			xfillbuf[fillend] = x; yfillbuf[fillend] = y+1; zfillbuf[fillend] = z; fillend = ((fillend+1)&(FILLBUFSIZ-1));
		}
		if ((z < zsiz-1) && (voxel[(x*MAXYSIZ+y)*MAXZSIZ+(z+1)] == followcol))
		{
			voxel[(x*MAXYSIZ+y)*MAXZSIZ+(z+1)] = col;
			xfillbuf[fillend] = x; yfillbuf[fillend] = y; zfillbuf[fillend] = z+1; fillend = ((fillend+1)&(FILLBUFSIZ-1));
		}
	}
}

static short capturecount = 0;
static char pcxheader[128] =
{
	0xa,0x5,0x1,0x8,0x0,0x0,0x0,0x0,0x3f,0x1,0xc7,0x0,
	0x40,0x1,0xc8,0x0,0x0,0x0,0x0,0x8,0x8,0x8,0x10,0x10,
	0x10,0x18,0x18,0x18,0x20,0x20,0x20,0x28,0x28,0x28,0x30,0x30,
	0x30,0x38,0x38,0x38,0x40,0x40,0x40,0x48,0x48,0x48,0x50,0x50,
	0x50,0x58,0x58,0x58,0x60,0x60,0x60,0x68,0x68,0x68,0x70,0x70,
	0x70,0x78,0x78,0x78,0x0,0x1,0x40,0x1,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
};

screencapture(char *filename)
{
	char *ptr;
	long fil, i, bufplc, p, col, ncol, leng, numbytes, xres;

	filename[4] = ((capturecount/1000)%10)+48;
	filename[5] = ((capturecount/100)%10)+48;
	filename[6] = ((capturecount/10)%10)+48;
	filename[7] = (capturecount%10)+48;
	if ((fil=open(filename,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY,S_IWRITE))==-1)
		return(-1);

	pcxheader[8] = ((XDIM-1)&255); pcxheader[9] = (((XDIM-1)>>8)&255);
	pcxheader[10] = ((YDIM-1)&255); pcxheader[11] = (((YDIM-1)>>8)&255);
	pcxheader[12] = (XDIM&255); pcxheader[13] = ((XDIM>>8)&255);
	pcxheader[14] = (YDIM&255); pcxheader[15] = ((YDIM>>8)&255);
	pcxheader[66] = (XDIM&255); pcxheader[67] = ((XDIM>>8)&255);

	write(fil,&pcxheader[0],128);

	ptr = (char *)0xa0000;
	numbytes = XDIM*YDIM;
	xres = XDIM;

	bufplc = 0; p = 0;
	while (p < numbytes)
	{
		koutp(97,kinp(97)|3);

		col = *ptr; p++; ptr++;

		leng = 1;

		ncol = *ptr;

		while ((ncol == col) && (p < numbytes) && (leng < 63) && ((p%xres) != 0))
		{
			leng++;

			p++; ptr++; ncol = *ptr;
		}

		koutp(97,kinp(97)&252);

		if ((leng > 1) || (col >= 0xc0))
		{
			tempbuf[bufplc++] = (leng|0xc0);
			if (bufplc == 4096) { bufplc = 0; if (write(fil,tempbuf,4096) < 4096) { close(fil); return(-1); } }
		}
		tempbuf[bufplc++] = col;
		if (bufplc == 4096) { bufplc = 0; if (write(fil,tempbuf,4096) < 4096) { close(fil); return(-1); } }
	}

	tempbuf[bufplc++] = 0xc;
	if (bufplc == 4096) { bufplc = 0; if (write(fil,tempbuf,4096) < 4096) { close(fil); return(-1); } }

	for(i=0;i<256;i++)
	{
		tempbuf[bufplc++] = (palette[i*3+0]<<2);
		if (bufplc == 4096) { bufplc = 0; if (write(fil,tempbuf,4096) < 4096) { close(fil); return(-1); } }
		tempbuf[bufplc++] = (palette[i*3+1]<<2);
		if (bufplc == 4096) { bufplc = 0; if (write(fil,tempbuf,4096) < 4096) { close(fil); return(-1); } }
		tempbuf[bufplc++] = (palette[i*3+2]<<2);
		if (bufplc == 4096) { bufplc = 0; if (write(fil,tempbuf,4096) < 4096) { close(fil); return(-1); } }
	}

	if (bufplc > 0)
		if (write(fil,tempbuf,bufplc) < bufplc) { close(fil); return(-1); }

	close(fil);
	capturecount++;
	return(0);
}

initmenupaths(char *filename)
{
	long i;

	strcpy(&curpath,filename);
	for(i=strlen(curpath);i>0;i--)
		if (curpath[i] == 92) break;  //92 is backslash
	if ((i == 2) && (curpath[i-1] == ':')) i++;  //Fix C: case to be C:backslash
	curpath[i] = 0;
	strcpy(&menupath,curpath);
}

menuselect()
{
	long newhighlight, i, j, topplc, menuheight = 24;
	char ch, buffer[42];

	chdir(menupath);
	menunamecnt = 0;
	getfilenames("SUBD");
	getfilenames("*.KVX");
	sortfilenames();
	if (!menunamecnt) return(-2);

	newhighlight = menuhighlight = min(max(menuhighlight,0),menunamecnt-1);
	do
	{
			//Clear page
		if (maxpages > 1)
		{
			setactivepage(pag);
			clearbufbyte(frameplace,XDIM*YDIM,backgroundcol+(backgroundcol<<8)+(backgroundcol<<16)+(backgroundcol<<24));
		}

		topplc = max(min(newhighlight-(menuheight>>1),menunamecnt-menuheight-1),0);
		for(i=0;i<menunamecnt;i++)
		{
			if (i == newhighlight)
				{ buffer[0] = buffer[1] = '-'; buffer[2] = '>'; buffer[3] = 32; }
			else
				{ buffer[0] = buffer[1] = buffer[2] = buffer[3] = 32; }
			strcpy(&buffer[4],menuname[i]);

			if ((unsigned)(i-topplc) <= (unsigned)menuheight)
				printext256(0L,((i-topplc)<<3),whitecol,-1,buffer,0);
		}

			//Nextpage
		if (maxpages > 1)
		{
			setvisualpage(pag);
			pag++; if (pag >= maxpages) pag = 0;
		}
		else
			copyandclearbuf(frameplace,0xa0000,XDIM*YDIM>>2);

		ch = 0;                      //Interesting fakery of ch = getch()
		while (ch == 0)
		{
			if (keystatus[0xcb] > 0) { keystatus[0xcb] = 0; ch = 75; }
			if (keystatus[0xcd] > 0) { keystatus[0xcd] = 0; ch = 77; }
			if (keystatus[0xc8] > 0) { keystatus[0xc8] = 0; ch = 72; }
			if (keystatus[0xd0] > 0) { keystatus[0xd0] = 0; ch = 80; }
			if (keystatus[0xc9] > 0) { keystatus[0xc9] = 0; ch = 73; }  //PGUP
			if (keystatus[0xd1] > 0) { keystatus[0xd1] = 0; ch = 81; }  //PGDN
			if (keystatus[0xc7] > 0) { keystatus[0xc7] = 0; ch = 71; }  //Home
			if (keystatus[0xcf] > 0) { keystatus[0xcf] = 0; ch = 79; }  //End
			if (keystatus[0x1c] > 0) { keystatus[0x1c] = 0; ch = 13; }
			if (keystatus[1] > 0) { keystatus[1] = 0; ch = 27; }
		}

		if ((ch == 75) || (ch == 72)) newhighlight = max(newhighlight-1,0);
		if ((ch == 77) || (ch == 80)) newhighlight = min(newhighlight+1,menunamecnt-1);
		if (ch == 73) newhighlight = max(newhighlight-menuheight,0);
		if (ch == 81) newhighlight = min(newhighlight+menuheight,menunamecnt-1);
		if (ch == 71) newhighlight = 0;
		if (ch == 79) newhighlight = menunamecnt-1;
		if (ch == 13)
		{
			if (menuname[newhighlight][16] != 1)
			{
				menuhighlight = newhighlight;
				return(newhighlight);
			}
			if ((menuname[newhighlight][0] == '.') && (menuname[newhighlight][1] == '.'))
			{
				i = 0;
				while ((i < 128) && (menupath[i] != 0)) i++;
				while ((i > 0) && (menupath[i] != 92)) i--;
				menupath[i] = 0;
			}
			else
			{
				strcat(&menupath,"\\");
				strcat(&menupath,menuname[newhighlight]);
			}
			chdir(menuname[newhighlight]);
			menunamecnt = 0;
			getfilenames("SUBD");
			getfilenames("*.KVX");
			sortfilenames();
			newhighlight = 0;
			ch = 0;
		}
	} while (ch != 27);
	return(-1);
}

static long kenslogo[(64>>5)*24] =
{
	0xfc01f003,0xff00fff8,0xfc03f007,0xff83fffe,0xfc07f007,0xff87ffff,
	0xfc0ff007,0xff87ffff,0xfc1fe003,0xff0fffff,0xfc3fc000,0xfc0ff01e,
	0xfc7f8000,0xfc0fe000,0xfcff0000,0xfc0fe000,0xfdfe0000,0xfc0fe000,
	0xfffc0000,0xfc0ff000,0xfff80000,0xfc07fff0,0xfff00000,0xfc07fffc,
	0xfff00000,0xfc03fffe,0xfff80000,0xfc00fffe,0xfffc0000,0xfc00007f,
	0xfdfe0000,0xfc00003f,0xfcff0000,0xfc00003f,0xfc7f8000,0xfc00003f,
	0xfc3fc060,0xfc07807f,0xfc1fe0f1,0xfc0fffff,0xfc0ff1ff,0xf80ffffe,
	0xfc07f1ff,0xf80ffffe,0xfc03f0ff,0xf007fffc,0xfc01f07f,0xe001fff0,
};
static char paldef[24] =
	{63,63,63,48,48,63,63,48,32,63,32,24,63,24,24,32,32,63,24,63,24,63,32,63};

loadefaultkvx()
{
	long x, y, z;

	z = 0;
	for(x=0;x<24;x+=3)
		for(y=1;y<=32;y++)
		{
			palette[z  ] = ((paldef[x  ]*y)>>5);
			palette[z+1] = ((paldef[x+1]*y)>>5);
			palette[z+2] = ((paldef[x+2]*y)>>5);
			z += 3;
		}

	xsiz = 64; ysiz = 6; zsiz = 24;
	xpivot = (xsiz<<7); ypivot = (ysiz<<7); zpivot = (zsiz<<7);

	for(z=0;z<zsiz;z++)
		for(x=0;x<xsiz;x++)
		{
			if (!(kenslogo[z*2+(x>>5)]&(0x80000000>>(x&31))))
			{
				voxel[((x*MAXYSIZ)+0)*MAXZSIZ+z] = 255;
				voxel[((x*MAXYSIZ)+1)*MAXZSIZ+z] = 255;
				voxel[((x*MAXYSIZ)+2)*MAXZSIZ+z] = 255;
				voxel[((x*MAXYSIZ)+3)*MAXZSIZ+z] = 255;
				voxel[((x*MAXYSIZ)+4)*MAXZSIZ+z] = 255;
				voxel[((x*MAXYSIZ)+5)*MAXZSIZ+z] = 255;
				continue;
			}
			voxel[((x*MAXYSIZ)+0)*MAXZSIZ+z] = 53;
			voxel[((x*MAXYSIZ)+1)*MAXZSIZ+z] = 55;
			voxel[((x*MAXYSIZ)+2)*MAXZSIZ+z] = 55;
			voxel[((x*MAXYSIZ)+3)*MAXZSIZ+z] = 55;
			voxel[((x*MAXYSIZ)+4)*MAXZSIZ+z] = 55;
			if ((x == 0) || (z == 0) || (x == xsiz-1) || (z == zsiz-1))
				{ voxel[((x*MAXYSIZ)+5)*MAXZSIZ+z] = 61; continue; }
			if (!(kenslogo[(z-1)*2+(x>>5)]&(0x80000000>>(x&31))))
				{ voxel[((x*MAXYSIZ)+5)*MAXZSIZ+z] = 61; continue; }
			if (!(kenslogo[(z+1)*2+(x>>5)]&(0x80000000>>(x&31))))
				{ voxel[((x*MAXYSIZ)+5)*MAXZSIZ+z] = 61; continue; }
			if (!(kenslogo[z*2+((x-1)>>5)]&(0x80000000>>((x-1)&31))))
				{ voxel[((x*MAXYSIZ)+5)*MAXZSIZ+z] = 61; continue; }
			if (!(kenslogo[z*2+((x+1)>>5)]&(0x80000000>>((x+1)&31))))
				{ voxel[((x*MAXYSIZ)+5)*MAXZSIZ+z] = 61; continue; }
			voxel[((x*MAXYSIZ)+5)*MAXZSIZ+z] = 58;
		}

	compileallmips();
}
