#include <dlfcn.h>
#include "../hello_child.h"

typedef int (*my_func)( char* );

int main( int argc, char *argv[] ) {
   char *messg = "Hello world!\n";
   // Открываем совместно используемую библиотеку
   void *dl_handle = dlopen( "./libhello.so", RTLD_LAZY );
   if( !dl_handle ) {
      printf( "ERROR: %s\n", dlerror() );
      return 3;
   }
   // Находим адрес функции в библиотеке
   my_func func = dlsym( dl_handle, "put_my_msg" );
   char *error = dlerror();
   if( error != NULL ) {
      printf( "ERROR: %s\n", dlerror() );
      return 4;
   }
   // Вызываем функцию по найденному адресу
   int res = (*func)( messg );
   // Закрываем библиотеку
   dlclose( dl_handle );
   return res;
};
