#include <linux/fs.h>
#include <linux/miscdevice.h>
#include "../dev.h"

static const struct file_operations hello_fops = {
   .owner  = THIS_MODULE,
   .read   = hello_read,
};

static struct miscdevice hello_dev = {
   MISC_DYNAMIC_MINOR, "hello", &hello_fops
};

static int __init hello_init( void ) {
   int ret = misc_register( &hello_dev );
   if( ret ) printk( KERN_ERR "unable to register misc device\n" );
   return ret;
}

static void __exit hello_exit( void ) {
   misc_deregister( &hello_dev );
}
