#include <linux/module.h>
#include <linux/fs.h>
#include <linux/sched.h>

static const char inp_file[] = "/etc/yumex.profiles.conf";
#define BUF_LEN 255

static int __init kread_init( void ) {
    struct file *f;
    char buff[ BUF_LEN + 1 ];
    size_t n;

    printk( KERN_ALERT "**** openning file: %s\n", inp_file );
    f = filp_open( inp_file, O_RDONLY, 0 );

    if( !f ) { 
        printk( KERN_ALERT "file open failed: %s\n",inp_file );
        return -ENOENT;
    }

    n = kernel_read( f, 0, buff, BUF_LEN );
    if( n ) {
        printk( KERN_ALERT "**** read first %d bytes:\n", n );
        buff[ n ] = '\0';
        printk( KERN_ALERT "%s\n", buff );
    } else {
        printk( KERN_ALERT "kernel_read failed\n" );
        return -EIO;
    }

    printk( KERN_ALERT "**** close file: %s\n", inp_file );
//    filp_close( f, current->files );
    filp_close( f, NULL );
    return -EPERM;
}

module_init( kread_init );
MODULE_LICENSE( "GPL" );
